% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_palette.R
\name{set_palette}
\alias{set_palette}
\alias{change_palette}
\alias{color_palette}
\alias{fill_palette}
\title{Set Color Palette}
\usage{
set_palette(p, palette)

change_palette(p, palette)

color_palette(palette = NULL, ...)

fill_palette(palette = NULL, ...)
}
\arguments{
\item{p}{a ggplot}

\item{palette}{Color palette. Allowed values include: \itemize{ \item
\strong{Grey color palettes}: "grey" or "gray"; \item \strong{RColorBrewer
palettes}, see \code{\link[RColorBrewer:ColorBrewer]{brewer.pal}} and details section.
Examples of palette names include: "RdBu", "Blues", "Dark2", "Set2", ...;
\item \strong{Custom color palettes}. For example, palette = c("#00AFBB",
"#E7B800", "#FC4E07"); \item \strong{ggsci scientific journal palettes},
e.g.: "npg", "aaas", "lancet", "jco", "ucscgb", "uchicago", "simpsons" and
"rickandmorty". }}

\item{...}{other arguments passed to ggplot2 scale_color_xxx() and
scale_fill_xxx() functions.}
}
\description{
\itemize{ \item \code{change_palette(), set_palette()}: Change
both color and fill palettes. \item \code{color_palette()}: change color
palette only. \item \code{fill_palette()}: change fill palette only.

}
}
\examples{
# Load data
data("ToothGrowth")
df <- ToothGrowth

# Basic plot
p <- ggboxplot(df, x = "dose", y = "len",
   color = "dose")
p

# Change the color palette
set_palette(p, "jco")
}
\seealso{
\link{get_palette}.
}
