% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.R
\name{native-encoding}
\alias{native-encoding}
\alias{encode_native}
\alias{decode_native}
\title{Convert to and from the R native colour representation}
\usage{
encode_native(colour, ...)

decode_native(colour)
}
\arguments{
\item{colour}{For \code{encode_native} either a vector of hex-encoded
colours/colour names or a matrix encoding colours in any of the supported
colour spaces. If the  latter, the colours will be encoded to a hex string
using \code{\link[=encode_colour]{encode_colour()}} first. For \code{decode_native} it is a vector of
integers.}

\item{...}{Arguments passed on to \code{\link[=encode_colour]{encode_colour()}}}
}
\value{
\code{encode_native()} returns an integer vector and \code{decode_native()}
returns a character vector, both matching the length of the input.
}
\description{
Colours in R are internally encoded as integers when they are passed around
to graphics devices. The encoding splits the 32 bit in the integer between
red, green, blue, and alpha, so that each get 8 bit, equivalent to 256
values. It is very seldom that an R user is subjected to this representation,
but it is present in the \code{nativeRaster} format which can be obtained from
e.g. capturing the content of a graphic device (using \code{dev.cap()}) or reading
in PNG files using \code{png::readPNG(native = TRUE)}. It is very rare that you
might need to convert back and forth between this format, but it is provided
here for completeness.
}
\examples{

# Get native representation of navyblue and #228B22
native_col <- encode_native(c('navyblue', '#228B22'))
native_col

# Convert back
decode_native(native_col)

}
