% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_kendalls_w.R
\name{interpret_kendalls_w}
\alias{interpret_kendalls_w}
\title{Interpret Kendall's Coefficient of Concordance \emph{W}}
\usage{
interpret_kendalls_w(w, rules = "landis1977")
}
\arguments{
\item{w}{Value or vector of Kendall's coefficient of concordance.}

\item{rules}{Can be \code{"landis1977"} (default) or a custom set of \code{\link[=rules]{rules()}}.}
}
\description{
Interpret Kendall's Coefficient of Concordance \emph{W}
}
\section{Rules}{

\itemize{
\item Landis & Koch (1977) (\code{"landis1977"}; default)
\itemize{
\item \strong{0.00 <= w < 0.20} - Slight agreement
\item \strong{0.20 <= w < 0.40} - Fair agreement
\item \strong{0.40 <= w < 0.60} - Moderate agreement
\item \strong{0.60 <= w < 0.80} - Substantial agreement
\item \strong{w >= 0.80}        - Almost perfect agreement
}
}
}

\references{
\itemize{
\item Landis, J. R., & Koch G. G. (1977). The measurement of observer agreement
for categorical data. Biometrics, 33:159-74.
}
}
\keyword{interpreters}
