% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise.R
\name{all_vars}
\alias{all_vars}
\alias{any_vars}
\title{Apply predicate to all variables}
\usage{
all_vars(expr)

any_vars(expr)
}
\arguments{
\item{expr}{A predicate expression. This variable supports
\link[rlang:quasiquotation]{unquoting} and will be evaluated in the
context of the data frame. It should return a logical vector.

This argument is automatically \link[rlang:quo]{quoted} and later
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. It supports \link[rlang:quasiquotation]{unquoting}. See
\code{vignette("programming")} for an introduction to these concepts.}
}
\description{
These quoting functions signal to scoped filtering verbs
(e.g. \code{\link[=filter_if]{filter_if()}} or \code{\link[=filter_all]{filter_all()}}) that a predicate expression
should be applied to all relevant variables. The \code{all_vars()}
variant takes the intersection of the predicate expressions with
\code{&} while the \code{any_vars()} variant takes the union with \code{|}.
}
\seealso{
\code{\link[=vars]{vars()}} for other quoting functions that you
can use with scoped verbs.
}
