% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_num_hash.R
\name{num_hash}
\alias{num_hash}
\alias{signed_hash}
\title{Text hashing parameters}
\usage{
num_hash(range = c(8L, 12L), trans = log2_trans())

signed_hash(values = c(TRUE, FALSE))
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}

\item{values}{A vector of possible values (TRUE or FALSE).}
}
\description{
Used in \code{textrecipes::step_texthash()}.
}
\examples{
num_hash()
signed_hash()
}
