% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-transaction-with-transaction.R
\docType{data}
\name{spec_transaction_with_transaction}
\alias{spec_transaction_with_transaction}
\title{spec_transaction_with_transaction}
\value{
\code{dbWithTransaction()} returns the value of the executed code.
Failure to initiate the transaction
(e.g., if the connection is closed
or invalid
of if \code{\link[=dbBegin]{dbBegin()}} has been called already)
gives an error.
}
\description{
spec_transaction_with_transaction
}
\section{Specification}{

\code{dbWithTransaction()} initiates a transaction with \code{dbBegin()}, executes
the code given in the \code{code} argument, and commits the transaction with
\code{\link[=dbCommit]{dbCommit()}}.
If the code raises an error, the transaction is instead aborted with
\code{\link[=dbRollback]{dbRollback()}}, and the error is propagated.
If the code calls \code{dbBreak()}, execution of the code stops and the
transaction is silently aborted.
All side effects caused by the code
(such as the creation of new variables)
propagate to the calling environment.
}

