% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{filter_select}
\alias{filter_checkbox}
\alias{filter_select}
\title{Categorical filter controls}
\usage{
filter_select(id, label, sharedData, group, allLevels = FALSE,
  multiple = TRUE)

filter_checkbox(id, label, sharedData, group, allLevels = FALSE,
  inline = FALSE, columns = 1)
}
\arguments{
\item{id}{An HTML element ID; must be unique within the web page}

\item{label}{A human-readable label}

\item{sharedData}{\code{SharedData} object with the data to filter}

\item{group}{A one-sided formula whose values will populate this select box.
Generally this should be a character or factor column; if not, it will be
coerced to character.}

\item{allLevels}{If the vector described by \code{group} is factor-based,
should all the levels be displayed as options, or only ones that are
present in the data?}

\item{multiple}{Can multiple values be selected?}

\item{inline}{If \code{TRUE}, render checkbox options horizontally instead of vertically.}

\item{columns}{Number of columns the options should be arranged into.}
}
\description{
Creates a select box or list of checkboxes, for filtering a
\code{\link{SharedData}} object based on categorical data.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

sd <- SharedData$new(chickwts)
filter_select("feedtype", "Feed type", sd, "feed")

}

}

