% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-list.R
\name{chk_list}
\alias{chk_list}
\alias{vld_list}
\title{Check List}
\usage{
chk_list(x, x_name = NULL)

vld_list(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a list using

\code{is.list(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_list()}: Validate List

}}
\examples{
# chk_list
chk_list(list())
try(chk_list(1))
# vld_list
vld_list(list())
vld_list(list(x = 1))
vld_list(mtcars)
vld_list(1)
vld_list(NULL)
}
\seealso{
\code{\link[=is.list]{is.list()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other data_structure_checkers: 
\code{\link{chk_array}()},
\code{\link{chk_atomic}()},
\code{\link{chk_matrix}()},
\code{\link{chk_vector}()}
}
\concept{data_structure_checkers}
