% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-complex-number.R
\name{chk_complex_number}
\alias{chk_complex_number}
\alias{vld_complex_number}
\title{Check Complex Number}
\usage{
chk_complex_number(x, x_name = NULL)

vld_complex_number(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if non-missing complex scalar using

\code{is.complex(x) && length(x) == 1L && !anyNA(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_complex_number()}: Validate Complex Number

}}
\examples{
# chk_complex_number
chk_complex_number(as.complex(1.1))
try(chk_complex_number(1.1))
# vld_complex_number
vld_complex_number(as.complex(2))
}
\seealso{
\code{\link[=is.integer]{is.integer()}}

\code{\link[=vld_true]{vld_true()}}

\code{\link[=vld_number]{vld_number()}}

For more details about the use of this function,
please read the article
\href{https://poissonconsulting.github.io/chk/articles/chk-families.html}{chk families}.

Other scalar_checker: 
\code{\link{chk_whole_number}()}
}
\concept{scalar_checker}
