% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aw_calculate.R
\name{aw_calculate}
\alias{aw_calculate}
\title{Calculate Estimated Population}
\usage{
aw_calculate(.data, value, areaWeight, newVar)
}
\arguments{
\item{.data}{A given intersected dataset}

\item{value}{A column within \code{source} to be interpolated}

\item{areaWeight}{The name of the variable containing area weight per feature}

\item{newVar}{Optional; a new field name to store the interpolated value in. If not specified,
the \code{value} argument will be used as the new field name.}
}
\value{
An intersected file of class sf with a new field of interest recalculated with area weight
}
\description{
\code{aw_calculate} multiplies the given \code{value} by the area weight. This
    is the fourth step in the interpolation process after \link{aw_weight}.
}
\examples{
library(dplyr)

race <- select(ar_stl_race, GEOID, TOTAL_E)
wards <- select(ar_stl_wards, WARD)

wards \%>\%
    aw_intersect(source = race, areaVar = "area") \%>\%
    aw_total(source = race, id = GEOID, areaVar = "area", totalVar = "totalArea",
             weight = "sum", type = "extensive") \%>\%
    aw_weight(areaVar = "area", totalVar = "totalArea", areaWeight = "areaWeight") -> intersect

aw_calculate(intersect, value = "TOTAL_E", areaWeight = "areaWeight")

}
