% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsva.R
\name{fsva}
\alias{fsva}
\title{A function for performing frozen surrogate variable analysis as proposed in Parker, Corrada Bravo and Leek 2013}
\usage{
fsva(dbdat, mod, sv, newdat = NULL, method = c("fast", "exact"))
}
\arguments{
\item{dbdat}{A m genes by n arrays matrix of expression data from the database/training data}

\item{mod}{The model matrix for the terms included in the analysis for the training data}

\item{sv}{The surrogate variable object created by running sva on dbdat using mod.}

\item{newdat}{(optional) A set of test samples to be adjusted using the training database}

\item{method}{If method ="fast" then the SVD is calculated using an online approach, this may introduce slight bias. If method="exact" the exact SVD is calculated, but will be slower}
}
\value{
db An adjusted version of the training database where the effect of batch/expression heterogeneity has been removed

new An adjusted version of the new samples, adjusted one at a time using the fsva methodology.

newsv Surrogate variables for the new samples
}
\description{
This function performs frozen surrogate variable analysis as described in Parker, Corrada Bravo and Leek 2013. 
The approach uses a training database to create surrogate variables which are then used
to remove batch effects both from the training database and a new data set for prediction purposes.
For inferential analysis see \code{\link{sva}}, \code{\link{svaseq}}, with low level functionality available
through \code{\link{irwsva.build}} and \code{\link{ssva}}.
}
\examples{
library(bladderbatch)
library(pamr)
data(bladderdata)
dat <- bladderEset[1:50,]

pheno = pData(dat)
edata = exprs(dat)

set.seed(1234)
trainIndicator = sample(1:57,size=30,replace=FALSE)
testIndicator = (1:57)[-trainIndicator]
trainData = edata[,trainIndicator]
testData = edata[,testIndicator]
trainPheno = pheno[trainIndicator,]
testPheno = pheno[testIndicator,]

mydata = list(x=trainData,y=trainPheno$cancer)
mytrain = pamr.train(mydata)
table(pamr.predict(mytrain,testData,threshold=2),testPheno$cancer)

trainMod = model.matrix(~cancer,data=trainPheno)
trainMod0 = model.matrix(~1,data=trainPheno)
trainSv = sva(trainData,trainMod,trainMod0)

fsvaobj = fsva(trainData,trainMod,trainSv,testData)
mydataSv = list(x=fsvaobj$db,y=trainPheno$cancer)
mytrainSv = pamr.train(mydataSv)
table(pamr.predict(mytrainSv,fsvaobj$new,threshold=1),testPheno$cancer)

}
