% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/megadepth.R
\name{megadepth_cmd}
\alias{megadepth_cmd}
\alias{megadepth_shell}
\title{Run Megadepth commands}
\usage{
megadepth_cmd(...)

megadepth_shell(input = ".", ...)
}
\arguments{
\item{...}{Arguments to be passed to \code{system2('megadepth', ...)}, e.g.
\code{annotation(path)} is basically
\code{megadepth_cmd(c('--annotation', path))}
(i.e. run the command \command{megadepth --annotation path}).}

\item{input}{A \code{character(1)} with the path to the input BAM, BigWig or
text file for Megadepth.}
}
\value{
See \code{base::system2()} for the types of output you can generate.

A \code{character()} with the capture of the standard output stream
generated by Megadepth.
}
\description{
Wrapper functions to run Megadepth commands via
\code{\link{system2}('megadepth', ...)}.
}
\section{Functions}{
\itemize{
\item \code{megadepth_cmd()}: Run an arbitrary Megadepth command.

\item \code{megadepth_shell()}: Run an arbitrary Megadepth command.

}}
\examples{

## Install if necessary
install_megadepth()

## Find version
## megadepth_shell() provides an interface more familiar to R users
megadepth_shell(version = TRUE)
## megadepth_cmd() requires using directly the command line syntax for
## Megadepth
megadepth_cmd("--version", stdout = TRUE)

## Compare the help files:
# megadepth_shell() captures the standard output and returns a character()
# megadepth_cmd() shows the standard output on the console
megadepth_shell("--help")
megadepth_cmd("--help")
}
\references{
\code{megadepth_cmd()} is based on blogdown::hugo_cmd() which is available at
\url{https://github.com/rstudio/blogdown/blob/master/R/hugo.R}.

\code{megadepth_shell()} is based on the shell_ls() example from cmdfun which is
available at \url{https://snystrom.github.io/cmdfun/index.html}.
}
