% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-compress.R
\name{miniSwish}
\alias{miniSwish}
\title{Helper function for distributing Swish on a subset of data}
\usage{
miniSwish(
  infile,
  outfile,
  numReps = 20,
  lengthCorrect = FALSE,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{infile}{path to an RDS file of a SummarizedExperiment}

\item{outfile}{a CSV file to write out}

\item{numReps}{how many inferential replicates to generate}

\item{lengthCorrect}{logical, see \code{\link{scaleInfReps}},
and Swish vignette. As this function is primarily for alevin,
the default is \code{FALSE}}

\item{overwrite}{logical, whether \code{outfile}
should overwrite an existing file}

\item{...}{arguments passed to \code{\link{swish}}}
}
\value{
nothing, files are written out
}
\description{
This function is called by the \code{Snakefile} that is generated
by \code{\link{splitSwish}}. See alevin example in the vignette.
As such, it doesn't need to be run by users in an interactive
R session.
}
\details{
Note that the default for length correction is FALSE, as
opposed to the default in \code{\link{scaleInfReps}} which
is TRUE. The default for \code{numReps} here is 20.
}
