% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfcShrink.R
\name{lfcShrink}
\alias{lfcShrink}
\title{Shrink log2 fold changes}
\usage{
lfcShrink(dds, coef, contrast, res, type = c("normal", "apeglm", "ashr"),
  svalue = FALSE, returnList = FALSE, apeAdapt = TRUE, parallel = FALSE,
  BPPARAM = bpparam(), ...)
}
\arguments{
\item{dds}{a DESeqDataSet object, after running \code{\link{DESeq}}}

\item{coef}{the name or number of the coefficient (LFC) to shrink,
consult \code{resultsNames(dds)} after running \code{DESeq(dds)}.
note: only \code{coef} or \code{contrast} can be specified, not both.
\code{type="apeglm"} requires use of \code{coef}.}

\item{contrast}{see argument description in \code{\link{results}}.
only \code{coef} or \code{contrast} can be specified, not both.}

\item{res}{a DESeqResults object. Results table produced by the
default pipeline, i.e. \code{DESeq} followed by \code{results}.
If not provided, it will be generated internally using \code{coef} or \code{contrast}}

\item{type}{\code{"normal"} is the original DESeq2 shrinkage estimator;
\code{"apeglm"} is the adaptive t prior shrinkage estimator from the 'apeglm' package;
\code{"ashr"} is the adaptive shrinkage estimator from the 'ashr' package,
using a fitted mixture of normals prior
- see the Stephens (2016) reference below for citation}

\item{svalue}{logical, should p-values and adjusted p-values be replaced
with s-values when using \code{apeglm} or \code{ashr}.
See Stephens (2016) reference on s-values.}

\item{returnList}{logical, should \code{lfcShrink} return a list, where
the first element is the results table, and the second element is the
output of \code{apeglm} or \code{ashr}}

\item{apeAdapt}{logical, should \code{apeglm} use the MLE estimates of
LFC to adapt the prior, or use default or specified \code{prior.control}}

\item{parallel}{if FALSE, no parallelization. if TRUE, parallel
execution using \code{BiocParallel}, see same argument of \code{\link{DESeq}}
parallelization only used with \code{normal} or \code{apeglm}}

\item{BPPARAM}{see same argument of \code{\link{DESeq}}}

\item{...}{arguments passed to \code{apeglm} and \code{ashr}}
}
\value{
a DESeqResults object with the \code{log2FoldChange} and \code{lfcSE}
columns replaced with shrunken LFC and SE.
\code{priorInfo(res)} contains information about the shrinkage procedure,
relevant to the various methods specified by \code{type}.
}
\description{
Adds shrunken log2 fold changes (LFC) and SE to a
results table from \code{DESeq} run without LFC shrinkage.
Three shrinkage esimators for LFC are available via \code{type}.
}
\details{
As of DESeq2 version 1.18, \code{type="apeglm"} and \code{type="ashr"}
are new features, and still under development.
Specifying \code{type="apeglm"} passes along DESeq2 MLE log2
fold changes and standard errors to the \code{apeglm} function
in the apeglm package, and re-estimates posterior LFCs for
the coefficient specified by \code{coef}.
Specifying \code{type="ashr"} passes along DESeq2 MLE log2
fold changes and standard errors to the \code{ash} function
in the ashr package, 
with arguments \code{mixcompdist="normal"} and \code{method="shrink"}
(\code{coef} and \code{contrast} ignored).
See vignette for a comparison of shrinkage estimators on an example dataset.
For all shrinkage methods, details on the prior is included in
\code{priorInfo(res)}, including the \code{fitted_g} mixture for ashr.
The integration of shrinkage methods from
external packages will likely evolve over time. We will likely incorporate an
\code{lfcThreshold} argument which can be passed to apeglm
to specify regions of the posterior at an arbitrary threshold.

For \code{type="normal"}, shrinkage cannot be applied to coefficients
in a model with interaction terms.
}
\examples{

 set.seed(1)
 dds <- makeExampleDESeqDataSet(n=500,betaSD=1)
 dds <- DESeq(dds)
 res <- results(dds)

 res.shr <- lfcShrink(dds=dds, coef=2)
 res.shr <- lfcShrink(dds=dds, contrast=c("condition","B","A"))
 res.ape <- lfcShrink(dds=dds, coef=2, type="apeglm")
 res.ash <- lfcShrink(dds=dds, coef=2, type="ashr")

}
\references{
\code{type="normal"}:

Love, M.I., Huber, W., Anders, S. (2014) Moderated estimation of fold change and dispersion for RNA-seq data with DESeq2. Genome Biology, 15:550. \url{https://doi.org/10.1186/s13059-014-0550-8}

\code{type="ashr"}:

Stephens, M. (2016) False discovery rates: a new deal. Biostatistics, 18:2. \url{https://doi.org/10.1093/biostatistics/kxw041}
}
