% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanoPlot.R
\name{degVolcano}
\alias{degVolcano}
\title{Create volcano plot from log2FC and adjusted pvalues data frame}
\usage{
degVolcano(
  stats,
  side = "both",
  title = "Volcano Plot with Marginal Distributions",
  pval.cutoff = 0.05,
  lfc.cutoff = 1,
  shade.colour = "orange",
  shade.alpha = 0.25,
  point.colour = "gray",
  point.alpha = 0.75,
  point.outline.colour = "darkgray",
  line.colour = "gray",
  plot_text = NULL
)
}
\arguments{
\item{stats}{data.frame with two columns: logFC and Adjusted.Pvalue}

\item{side}{plot UP, DOWN or BOTH de-regulated points}

\item{title}{title for the figure}

\item{pval.cutoff}{cutoff for the adjusted pvalue. Default 0.05}

\item{lfc.cutoff}{cutoff for the log2FC. Default 1}

\item{shade.colour}{background color. Default orange.}

\item{shade.alpha}{transparency value. Default 0.25}

\item{point.colour}{colours for points. Default gray}

\item{point.alpha}{transparency for points. Default 0.75}

\item{point.outline.colour}{Default darkgray}

\item{line.colour}{Defaul gray}

\item{plot_text}{data.frame with three columns: logFC, Pvalue, Gene name}
}
\value{
The function will plot volcano plot together
with density of the fold change and p-values on the top and the
right side of the volcano plot.
}
\description{
Create volcano plot from log2FC and adjusted pvalues data frame
}
\details{
This function was mainly developed by @jnhutchinson.
}
\examples{
library(DESeq2)
dds <- makeExampleDESeqDataSet(betaSD = 1)
dds <- DESeq(dds)
stats <- results(dds)[,c("log2FoldChange", "padj")]
stats[["name"]] <- row.names(stats)
degVolcano(stats, plot_text = stats[1:10,])
}
\author{
Lorena Pantano, John Hutchinson
}
