library(biomaRt)

########################
context('getBM()')
########################

test_that("Fail with no arguments", {
    expect_error(getBM(), "You must provide a valid Mart object")
})

test_that("Fail when no dataset is specified", {
     ensembl=useMart("ensembl")
     expect_error(getBM(mart = ensembl), "No dataset selected, please select a dataset first")
})


#######################
## the definition_1006 entry for this gene includes unescaped new lines, so the HTML result is requested
########################
test_that("HTML reading code is used when needed", {
    expect_silent(ensembl <- useMart("ensembl", dataset = 'hsapiens_gene_ensembl'))
    attributes <-  c("ensembl_gene_id", "hgnc_symbol",  "go_id", "name_1006",  "definition_1006")
    expect_silent(go_sets <- getBM(attributes =  attributes,
                                   filters = "ensembl_gene_id",
                                   values = c('ENSG00000100036'),
                                   mart = ensembl,
                                   bmHeader = FALSE))
    expect_is(go_sets, "data.frame")
    expect_equal(colnames(go_sets), attributes)
})
 
