#ifndef SSTVGLOBAL_H
#define SSTVGLOBAL_H
#include <QString>
#include <QCursor>
#include "utils/logging.h"
#include "drmrx/sourcedecoder.h"
#include "qsstvdefs.h"




class QSplashScreen;
class QStatusBar;
class logFile;
class galleryWidget ;
class configDialog;
class dispatcher;
class rxWidget;
class txWidget;
class imageViewer;
class mainWindow;
class waterfallText;
class logBook;
class xmlInterface;

class synthesizer;

extern const QString MAJORVERSION;
extern const QString CONFIGVERSION;
extern const QString MINORVERSION;
extern const QString ORGANIZATION;
extern const QString APPLICATION;
extern const QString qsstvVersion;
extern const QString shortText;
#define MAGICNUMBER   (('4'<<24)+('Q'<<16)+('Z'<<8)+'S')

extern QSplashScreen    *splashPtr;
extern configDialog     *confDiag;
extern mainWindow *mainWindowPtr;
extern waterfallText *waterfallPtr;
extern QString splashStr;


extern txWidget *txWidgetPtr;
extern galleryWidget *galleryWidgetPtr;

extern synthesizer *synthesPtr;
extern dispatcher *dispatcherPtr;
extern QStatusBar *statusBarPtr;

// for DRM
enum emscStatus {INVALID,VALID,ALREADYRECEIVED};
extern emscStatus msc_valid;
extern int bodyTotalSegments;
extern int rxSegments;
extern int currentSegmentNumber;
extern unsigned int rxTransportID;
extern unsigned int bitsPerSecond;
extern bool stopDRM;
extern QList<short unsigned int> drmBlockList;
extern uint txTransportID;
extern QList<short unsigned int> fixBlockList;
extern float avgSNR;
extern float lastAvgSNR;

extern QCursor *cpCursor;
void globalInit(void);
void globalEnd(void);

extern logFile *logfile;
extern logBook *logBookPtr;
extern xmlInterface *xmlIntfPtr;

#ifndef QT_NO_DEBUG
class scopeView;
extern scopeView *scopeViewerData;
extern scopeView *scopeViewerSync;
#endif

extern QByteArray *debugPtr;
extern sourceDecoder srcDecoder;

extern QPixmap *greenPXM;
extern QPixmap *redPXM;



#endif
