/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FieldInfos {
    public static final int FORMAT_PRE = -1;
    public static final int FORMAT_START = -2;
    public static final int FORMAT_OMIT_POSITIONS = -3;
    static final int CURRENT_FORMAT = -3;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_POSITIONS_WITH_TERMVECTOR = 4;
    static final byte STORE_OFFSET_WITH_TERMVECTOR = 8;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    static final byte OMIT_POSITIONS = -128;
    private final ArrayList<FieldInfo> byNumber;
    private final HashMap<String, FieldInfo> byName;
    private int format;

    FieldInfos() {
        this.byNumber = new ArrayList();
        this.byName = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfos(Directory d, String name) throws IOException {
        block8: {
            this.byNumber = new ArrayList();
            this.byName = new HashMap();
            IndexInput input = d.openInput(name);
            try {
                try {
                    this.read(input, name);
                }
                catch (IOException ioe) {
                    if (this.format == -1) {
                        input.seek(0L);
                        input.setModifiedUTF8StringsMode();
                        this.byNumber.clear();
                        this.byName.clear();
                        try {
                            this.read(input, name);
                            break block8;
                        }
                        catch (Throwable t) {
                            throw ioe;
                        }
                    }
                    throw ioe;
                }
            }
            finally {
                input.close();
            }
        }
    }

    public synchronized Object clone() {
        FieldInfos fis = new FieldInfos();
        int numField = this.byNumber.size();
        for (int i = 0; i < numField; ++i) {
            FieldInfo fi = (FieldInfo)this.byNumber.get(i).clone();
            fis.byNumber.add(fi);
            fis.byName.put(fi.name, fi);
        }
        return fis;
    }

    public synchronized void add(Document doc) {
        List<Fieldable> fields = doc.getFields();
        for (Fieldable field : fields) {
            this.add(field.name(), field.isIndexed(), field.isTermVectorStored(), field.isStorePositionWithTermVector(), field.isStoreOffsetWithTermVector(), field.getOmitNorms(), false, field.getIndexOptions());
        }
    }

    boolean hasProx() {
        int numFields = this.byNumber.size();
        for (int i = 0; i < numFields; ++i) {
            FieldInfo fi = this.fieldInfo(i);
            if (!fi.isIndexed || fi.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) continue;
            return true;
        }
        return false;
    }

    public synchronized void addIndexed(Collection<String> names, boolean storeTermVectors, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector) {
        for (String name : names) {
            this.add(name, true, storeTermVectors, storePositionWithTermVector, storeOffsetWithTermVector);
        }
    }

    public synchronized void add(Collection<String> names, boolean isIndexed) {
        for (String name : names) {
            this.add(name, isIndexed);
        }
    }

    public synchronized void add(String name, boolean isIndexed) {
        this.add(name, isIndexed, false, false, false, false);
    }

    public synchronized void add(String name, boolean isIndexed, boolean storeTermVector) {
        this.add(name, isIndexed, storeTermVector, false, false, false);
    }

    public synchronized void add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector) {
        this.add(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, false);
    }

    public synchronized void add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms) {
        this.add(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, false, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
    }

    public synchronized FieldInfo add(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms, boolean storePayloads, FieldInfo.IndexOptions indexOptions) {
        FieldInfo fi = this.fieldInfo(name);
        if (fi == null) {
            return this.addInternal(name, isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, indexOptions);
        }
        fi.update(isIndexed, storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, indexOptions);
        assert (fi.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS || !fi.storePayloads);
        return fi;
    }

    public synchronized FieldInfo add(FieldInfo fi) {
        return this.add(fi.name, fi.isIndexed, fi.storeTermVector, fi.storePositionWithTermVector, fi.storeOffsetWithTermVector, fi.omitNorms, fi.storePayloads, fi.indexOptions);
    }

    private FieldInfo addInternal(String name, boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms, boolean storePayloads, FieldInfo.IndexOptions indexOptions) {
        name = StringHelper.intern(name);
        FieldInfo fi = new FieldInfo(name, isIndexed, this.byNumber.size(), storeTermVector, storePositionWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, indexOptions);
        this.byNumber.add(fi);
        this.byName.put(name, fi);
        return fi;
    }

    public int fieldNumber(String fieldName) {
        FieldInfo fi = this.fieldInfo(fieldName);
        return fi != null ? fi.number : -1;
    }

    public FieldInfo fieldInfo(String fieldName) {
        return this.byName.get(fieldName);
    }

    public String fieldName(int fieldNumber) {
        FieldInfo fi = this.fieldInfo(fieldNumber);
        return fi != null ? fi.name : "";
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        return fieldNumber >= 0 ? this.byNumber.get(fieldNumber) : null;
    }

    public int size() {
        return this.byNumber.size();
    }

    public boolean hasVectors() {
        boolean hasVectors = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.fieldInfo((int)i).storeTermVector) continue;
            hasVectors = true;
            break;
        }
        return hasVectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory d, String name) throws IOException {
        IndexOutput output = d.createOutput(name);
        try {
            this.write(output);
        }
        finally {
            output.close();
        }
    }

    public void write(IndexOutput output) throws IOException {
        output.writeVInt(-3);
        output.writeVInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            FieldInfo fi = this.fieldInfo(i);
            assert (fi.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS || !fi.storePayloads);
            byte bits = 0;
            if (fi.isIndexed) {
                bits = (byte)(bits | 1);
            }
            if (fi.storeTermVector) {
                bits = (byte)(bits | 2);
            }
            if (fi.storePositionWithTermVector) {
                bits = (byte)(bits | 4);
            }
            if (fi.storeOffsetWithTermVector) {
                bits = (byte)(bits | 8);
            }
            if (fi.omitNorms) {
                bits = (byte)(bits | 0x10);
            }
            if (fi.storePayloads) {
                bits = (byte)(bits | 0x20);
            }
            if (fi.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                bits = (byte)(bits | 0x40);
            } else if (fi.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS) {
                bits = (byte)(bits | 0xFFFFFF80);
            }
            output.writeString(fi.name);
            output.writeByte(bits);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void read(IndexInput input, String fileName) throws IOException {
        int firstInt = input.readVInt();
        this.format = firstInt < 0 ? firstInt : -1;
        if (this.format != -1 && this.format != -2 && this.format != -3) {
            throw new CorruptIndexException("unrecognized format " + this.format + " in file \"" + fileName + "\"");
        }
        int size = this.format == -1 ? firstInt : input.readVInt();
        for (int i = 0; i < size; ++i) {
            FieldInfo.IndexOptions indexOptions;
            boolean storePayloads;
            String name = StringHelper.intern(input.readString());
            byte bits = input.readByte();
            boolean isIndexed = (bits & 1) != 0;
            boolean storeTermVector = (bits & 2) != 0;
            boolean storePositionsWithTermVector = (bits & 4) != 0;
            boolean storeOffsetWithTermVector = (bits & 8) != 0;
            boolean omitNorms = (bits & 0x10) != 0;
            boolean bl = storePayloads = (bits & 0x20) != 0;
            if ((bits & 0x40) != 0) {
                indexOptions = FieldInfo.IndexOptions.DOCS_ONLY;
            } else if ((bits & 0xFFFFFF80) != 0) {
                if (this.format > -3) throw new CorruptIndexException("Corrupt fieldinfos, OMIT_POSITIONS set but format=" + this.format);
                indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS;
            } else {
                indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            if (indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                storePayloads = false;
            }
            this.addInternal(name, isIndexed, storeTermVector, storePositionsWithTermVector, storeOffsetWithTermVector, omitNorms, storePayloads, indexOptions);
        }
        if (input.getFilePointer() == input.length()) return;
        throw new CorruptIndexException("did not read all bytes from file \"" + fileName + "\": read " + input.getFilePointer() + " vs size " + input.length());
    }
}

