"""News to mail gateway script. Copyright 2000 Cosimo Alfarano

Author: Cosimo Alfarano
Date: June 11 2000

whitelist.py - Copyright 2000 by Cosimo Alfarano <Alfarano@Students.CS.UniBo.It>
You can use this software under the terms of the GPL. If we meet some day,
and you think this stuff is worth it, you can buy me a beer in return.

Thanks to md for this useful formula. Beer is beer.

whitelist manage a list of trusted user.
"""

import sys
import string
import time
import fcntl

import pyginfo
import wlp


class whitelist:
	"""whitelist handling class

	Do you really want anyone can post? Ah ah ah.
	"""

	wl = {}
	debug = None
	log = None	# filedescriptor

	# constants
	DENY = 0
	ACCEPT = 1 

	def __init__(self, wlfile='wl.pyg', logfile='pyg.log', debug=0):

		self.debug = debug

		try:
			wlp.setfilebyname(wlfile)
		except (Exception), (errno,message):
			print 'Opening %s: %s (errno %d)' % (wlfile,message,errno)
			sys.exit(0)

		# dict is a { ownername : {variable: value}} dictionary of dictionaries
		self.wl = wlp.mkdict()

#		print 'owner: option = value'
#		for owner in self.wl.keys():
#			for option in self.wl[owner].keys():
#				print '%s: %s = %s' % (owner,option,self.wl[owner][option])	

		try:
			self.log = open(logfile, 'a')
			self.lock()
		except (Exception), message:
			print '%s\nAre you authorized to use this program? ' % message
			sys.exit(1)
		
	def lock(self):
		fcntl.flock(self.log.fileno(),fcntl.LOCK_EX)

	# to unlock fd locked, usually fd are unlocked after process exit()
	def unlock(self):
		fcntl.flock(self.log.fileno(),fcntl.LOCK_UN)
	
	def checkfrom(self, fromhead):
		"""have you permission to be here, sir?"""

		for owner in self.wl.keys():
#			if(self.wl[owner]['From:'] == fromhead[:-1]): # remove '\n'
			if(string.find(fromhead[:-1],self.wl[owner]['From:']) >= 0):
				return owner
		else:
			return None


	def log(self, string):
		"""Captain Diary, Astral Date 962555394 from epoch.
		it rawly write a line in logfile. Remeber to indent it, if you
		like.
		"""

		self.log.write(string + '\n')

	def logmsg(self, heads, ok=DENY,owner=None):
		"""who are walking through my gate?
		log
		"""

		ltime = time.ctime(time.time())

		if time.daylight:
			tzone = time.tzname[1]
		else:
			tzone = time.tzname[0]
	
		if(ok == self.ACCEPT):
			self.log.write('Permission Accorded ')
		else:
			self.log.write('Permission Denied ')

		self.log.write('at %s (%s)\n' % (ltime,tzone))
		if(owner != None):
			self.log.write('\tWLOwner: ' + owner + '\n')
		self.log.write('\tFrom: ' + heads.get('From:','NOT PRESENT\n'))
		self.log.write('\tSubject: ' + heads.get('Subject:','NOT PRESENT\n'))
		self.log.write('\tSender: ' + heads.get('Sender:','NOT PRESENT\n'))
		self.log.write('\tDate: ' + heads.get('Date:','NOT PRESENT\n'))

		# some client create Message-Id other Message-ID.
		if(heads.has_key('Message-ID:')):
			self.log.write('\tMessage-ID: ' + heads.get('Message-ID:'))
		else:
			self.log.write('\tMessage-Id: ' + heads.get('Message-Id:','NOT PRESENT\n'))
	
		# X-Newsgroups: and To: are present if user is trusted, else
		# Newsgroup: exists since no changes on nntp headers are done.
		if(heads.has_key('X-Newsgroups:')):
			self.log.write('\tTo: ' + heads.get('To:','NOT PRESENT\n'))
			self.log.write('\tX-Newsgroups: ' + heads.get('X-Newsgroups:','NOT PRESENT\n'))
		else:
			self.log.write('\tNewsgroups: ' + heads.get('Newsgroups:','NOT PRESENT\n'))

		
		self.log.write('\n')
