//
// EntityResolverImpl.h
//
// $Id: //poco/1.3/XML/include/Poco/SAX/EntityResolverImpl.h#2 $
//
// Library: XML
// Package: SAX
// Module:  SAX
//
// An implementation of EntityResolver.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef SAX_EntityResolverImpl_INCLUDED
#define SAX_EntityResolverImpl_INCLUDED


#include "Poco/XML/XML.h"
#include "Poco/XML/XMLString.h"
#include "Poco/SAX/EntityResolver.h"
#include "Poco/URIStreamOpener.h"


namespace Poco {
namespace XML {


class XML_API EntityResolverImpl: public EntityResolver
	/// A default implementation of the EntityResolver interface.
	///
	/// The system ID is first interpreted as an URI and the
	/// URIStreamOpener is used to create and open an istream
	/// for an InputSource.
	///
	/// If the system ID is not a valid URI, it is
	/// interpreted as a filesystem path and a Poco::FileInputStream
	/// is opened for it.
{
public:
	EntityResolverImpl();
		/// Creates an EntityResolverImpl that uses the default
		/// URIStreamOpener.
		
	EntityResolverImpl(const Poco::URIStreamOpener& opener);
		/// Creates an EntityResolverImpl that uses the given
		/// URIStreamOpener.
		
	~EntityResolverImpl();
		/// Destroys the EntityResolverImpl.
	
	InputSource* resolveEntity(const XMLString* publicId, const XMLString& systemId);
		/// Tries to use the URIStreamOpener to create and open an istream
		/// for the given systemId, which is interpreted as an URI.
		///
		/// If the systemId is not a valid URI, it is interpreted as
		/// a local filesystem path and a Poco::FileInputStream is opened for it.
		
	void releaseInputSource(InputSource* pSource);
		/// Deletes the InputSource's stream.
	
protected:
	std::istream* resolveSystemId(const XMLString& systemId);	
	
private:
	EntityResolverImpl(const EntityResolverImpl&);
	EntityResolverImpl& operator = (const EntityResolverImpl&);
	
	const Poco::URIStreamOpener& _opener;
};


} } // namespace Poco::XML


#endif // SAX_EntityResolverImpl_INCLUDED
