/*	Percent_Bar

PIRL CVS ID: Percent_Bar.java,v 1.3 2012/04/16 06:22:59 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package	PIRL.Viewers;

import	javax.swing.JComponent;
import	javax.swing.UIManager;
import	java.awt.Color;


/**	A <i>Percent_Bar</i> provides a bar chart component that is sized to be
	some percentage of the width or height of its display area.
<p>
	@author		Bradford Castalia, UA/PIRL
	@version	1.3
*/
public class Percent_Bar
	extends JComponent
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Viewers.Percent_Bar (1.3 2012/04/16 06:22:59)";

public static final int
	TOP						= 1,
	LEFT					= 2,
	BOTTOM					= 3,
	RIGHT					= 4,
	DEFAULT_ORIENTATION		= LEFT;
private int
	Orientation				= DEFAULT_ORIENTATION;

public static final Color
	DEFAULT_COLOR			= Color.BLACK;
private Color
	Bar_Color				= DEFAULT_COLOR;

private double
	Percent					= 0.0;

private static final String
	NL	= System.getProperty ("line.separator");


//  DEBUG control.
private static final int
	DEBUG_OFF			= 0,
	DEBUG_CONSTRUCTORS	= 1 << 0,
	DEBUG_UI			= 1 << 1,
	DEBUG_ALL			= -1,

	DEBUG		    	= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
/**	Construct a Percent_Bar.
<p>
	@param	percent	The percentage of the display width or height
		occupied by the bar.
	@param	orientation	Either VERTICAL or HORIZONTAL.
	@param	color	The Color of the bar.
*/
public Percent_Bar
	(
	double	percent,
	int		orientation,
	Color	color
	)
{
if ((DEBUG & DEBUG_CONSTRUCTORS) != 0)
	System.out.println
		(">>> Percent_Bar.Constructor:" + NL
		+"        Percent: " + percent + NL
		+"    Orientation: " + orientation + NL
		+"          Color: " + color);

if (percent < 0.0 ||
	percent > 100.0)
	throw new IllegalArgumentException (ID + NL
		+ "Invalid percent: " + percent);
Percent = percent;

if (orientation < 1 ||
	orientation > 4)
	throw new IllegalArgumentException (ID + NL
		+ "Invalid orientation: " + orientation);
Orientation = orientation;

if (color == null)
	color = DEFAULT_COLOR;
setForeground (color);

UIManager.put ("Percent_BarUI", "Percent_Bar_UI");
setUI (new Percent_Bar_UI ());
if ((DEBUG & DEBUG_CONSTRUCTORS) != 0)
	System.out.println ("<<< Percent_Bar.Constructor");
}


public Percent_Bar ()
{this (0.0, LEFT, null);}

/*==============================================================================
	Accessors
*/
public Percent_Bar Percent
	(
	double	percent
	)
{
if (percent < 0.0 ||
	percent > 100.0)
	throw new IllegalArgumentException (ID + NL
		+ "Invalid percent: " + percent);
Percent = percent;
repaint ();
return this;
}


public double Percent ()
{return Percent;}


public Percent_Bar Orientation
	(
	int		orientation
	)
{
if (orientation < 1 ||
	orientation > 4)
	throw new IllegalArgumentException (ID + NL
		+ "Invalid orientation: " + orientation);
Orientation = orientation;
repaint ();
return this;
}


public int Orientation ()
{return Orientation;}

/*==============================================================================
	View
*/
/**	Set the graphical user interface (UI) delegate for the component.
<p>
	@param	UI	A Percent_BarUI object that will paint the component
		and handle other user interface events.
	@see	JComponent#setUI(ComponentUI)
*/
public void setUI
	(
	Percent_BarUI	UI
	)
{super.setUI (UI);}

/**	Set the user interface delegate to the ComponentUI found by the
	UIManger for this component.
<p>
	This component is invalidated.
<p>
	@see	#getUIClassID()
*/
public void updateUI ()
{
if ((DEBUG & DEBUG_UI) != 0)
	System.out.println (">>> Percent_Bar.updateUI");
setUI ((Percent_BarUI)UIManager.getUI (this));
invalidate ();
if ((DEBUG & DEBUG_UI) != 0)
	System.out.println ("<<< Percent_Bar.updateUI");
}

/**	Get the ComponentUI class identification for this component.
<p>
	@return	The String "Percent_BarUI".
*/
public String getUIClassID ()
{
if ((DEBUG & DEBUG_UI) != 0)
	System.out.println (">-< Percent_Bar.getUIClassID: Percent_BarUI");
return "Percent_BarUI";
}

}	//	End of Percent_Bar class.
