/*	String_Utilities_test

CVS ID: String_Utilities_test.java,v 1.5 2012/04/16 06:15:36 castalia Exp

Copyright (C) 2004-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Strings.String_Utilities;
import	PIRL.Utilities.Checker;


public class String_Utilities_test
{
public static void main (String[] arguments) 
{
System.out.println
	("*** String_Utilities_test:\n"
	+ String_Utilities.ID);
String
	string,
	expected;
Checker
	checker = new Checker ();

if (arguments.length > 0 &&
	arguments[0].startsWith ("-v"))
	checker.Verbose = true;

string = "";
expected = string;
checker.Check ("Trim (\"" + string + "\", ' ')",
	expected, String_Utilities.Trim (string, ' '));

string = "Word";
expected = string;
checker.Check ("Trim (\"" + string + "\", ' ')",
	expected, String_Utilities.Trim (string, ' '));

string = " Word";
checker.Check ("Trim (\"" + string + "\", ' ')",
	expected, String_Utilities.Trim (string, ' '));

string = "Word ";
checker.Check ("Trim (\"" + string + "\", ' ')",
	expected, String_Utilities.Trim (string, ' '));

string = " Word ";
checker.Check ("Trim (\"" + string + "\", ' ')",
	expected, String_Utilities.Trim (string, ' '));

string = "   Word   ";
checker.Check ("Trim (\"" + string + "\", ' ')",
	expected, String_Utilities.Trim (string, ' '));

long
	number = 0;
int
	digits = 2;
checker.Check ("Amount_Magnitude (" + number + ")",
	"0", String_Utilities.Amount_Magnitude (number));

number = 1024;
checker.Check ("Amount_Magnitude (" + number + ", " + digits + ")",
	"1.00K", String_Utilities.Amount_Magnitude (number, digits));

number = -1024;
checker.Check ("Amount_Magnitude (" + number + ", " + digits + ")",
	"-1.00K", String_Utilities.Amount_Magnitude (number, digits));

number = 1024;
digits = 0;
checker.Check ("Amount_Magnitude (" + number + ", " + digits + ")",
	"1K", String_Utilities.Amount_Magnitude (number, digits));

number = 1536;
digits = 2;
checker.Check ("Amount_Magnitude (" + number + ", " + digits + ")",
	"1.50K", String_Utilities.Amount_Magnitude (number, digits));

digits = 0;
checker.Check ("Amount_Magnitude (" + number + ", " + digits + ")",
	"2K", String_Utilities.Amount_Magnitude (number, digits));

number = 2 * 1024 * 1024;
digits = -1;
checker.Check ("Amount_Magnitude (" + number + ", " + digits + ")",
	"2.00M", String_Utilities.Amount_Magnitude (number, digits));

number = (long)(3 * 1024 + 768) * 1024 * 1024;
digits = 3;
checker.Check ("Amount_Magnitude (" + number + ", " + digits + ")",
	"3.750G", String_Utilities.Amount_Magnitude (number, digits));

digits = 1;
checker.Check ("Amount_Magnitude (" + number + ", " + digits + ")",
	"3.8G", String_Utilities.Amount_Magnitude (number, digits));

System.out.println
	("Checks: " + checker.Checks_Total + '\n'
	+"Passed: " + checker.Checks_Passed);

System.exit (0);
}
}
