/*	Message_Delivered_Event

PIRL CVS ID: Message_Delivered_Event.java,v 1.5 2012/04/16 06:11:36 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Messenger;

import	java.util.EventObject;


/**	A <i>Message_Delivered_Event</i> is used to notify a Messenger
	employer that a message was delivered needing attention.
<p>
	@author		Bradford Castalia - UA/PIRL
	@version	1.5
	@see		Message
	@see		Messenger
*/
public class Message_Delivered_Event
	extends EventObject
{
public Message
	Message;

/**	Constructs a Message_Delivered_Event.
<p>
	@param	messenger	The Messenger that is delivering the message.
	@param	message	The Message being delivered.
*/
public Message_Delivered_Event
	(
	Messenger	messenger,
	Message		message
	)
{
super (messenger);
Message = message;
}

}

