.\" -*- coding: us-ascii -*-
.if \n(.g .ds T< \\FC
.if \n(.g .ds T> \\F[\n[.fam]]
.de URL
\\$2 \(la\\$1\(ra\\$3
..
.if \n(.g .mso www.tmac
.TH pg_select n "March 2018" "" "PostgreSQL Tcl Interface Documentation"
.SH NAME
pg_select \- loop over the result of a query
.SH SYNOPSIS
.nf

pg_select [\*(T<\-rowbyrow\*(T>] [\*(T<\-nodotfields\*(T>] [\*(T<\-withoutnulls\*(T>] [\*(T<\-paramarray var\*(T>] [\*(T<\-variables\*(T>] [\*(T<\-params\*(T> paramList] [\*(T<\-count\*(T> countVar] \*(T<conn\*(T> \*(T<commandString\*(T> \*(T<arrayVar\*(T> \*(T<procedure\*(T>
.fi
.SH DESCRIPTION
\*(T<\fBpg_select\fR\*(T> submits a query
(\fBSELECT\fR statement) to the
PostgreSQL server and executes a given
chunk of code for each row in the result. The
\*(T<commandString\*(T> must be a
\fBSELECT\fR statement; anything else returns an
error. The \*(T<arrayVar\*(T> variable is an array
name used in the loop. For each row,
\*(T<arrayVar\*(T> is filled in with the row values,
using the column names as the array indices. Then the
\*(T<procedure\*(T> is executed.
.PP
In addition to the column values, the following special entries are
made in the array (unless the [-nodotfields] flag is provided):
.TP 
\*(T<\&.headers\*(T>
A list of the column names returned by the query.
.TP 
\*(T<\&.numcols\*(T>
The number of columns returned by the query.
.TP 
\*(T<\&.tupno\*(T>
The current row number, starting at zero and incrementing for
each iteration of the loop body.
.PP
If the [-param] flag is provided, then it contains a list of parameters that will replace "$1", "$2" and so
on in the query string, as if it were a prepared statement. Be sure to properly escape or quote the "$" in the query. :)
.PP
If the [-paramarray] flag is provided, then a substitution is performed on the query, securely replacing
each back-quote delimited name with the corresponding entry from the named array. If the array does not contain the named element,
then NULL is substituted (similarly to the way an array created by -withoutnulls is generated).
Each such name must occur in a location where a value or field name could appear.
.PP
If the [-variables] flag is provided, then embedded Tcl variables are passed as parameters. Variables can be flagged with ':' and array references and namespaces are supported. Complex variable names can usually be embedded with :{nasty-name-here} though no attempt at duplicating Tcl brace-escaping is made.
If the variable does not exist, then NULL is substituted.
.PP
Notes: This substitution is performed by generating a positional parameter list and calling PQExecParams with a modified query containing
$1, $2, ... where the original `names` appeared. This is a straight substitution, so if this mechanism is used the back-quote
character (`) can not appear elsewhere in the query, even in a quoted string. There are a maximum of 99,999 names.
.SH ARGUMENTS
.TP 
[-params list]
Perform parameter substitution using PQexecParams or PQSendQueryParams.
.TP 
[-paramarray arrayname]
Perform parameter substitution via `quoted` elements of the array using PQexecParams or PQSendQueryParams.
.TP 
[-variables]
Substitute Tcl variables found in the SQL string using PQexecParams or PQSendQueryParams.
.TP 
[-rowbyrow]
Perform the select in row-by-row mode. This means that the code block is called immediately results
become available, rather than waiting for the query to complete. 
.TP 
[-nodotfields]
Suppress generation of the pseudo-fields .headers, .numcols, and .tupno.
.TP 
[-withoutnulls]
If specified null columns will be unset from the array rather than being defined and containing the null string, typically an empty string.
.TP 
[-count countVar]
Set the variable "countVar" to the number of tuples returned for use in the block.
.TP 
\*(T<conn\*(T>
The handle of the connection on which to execute the query.
.TP 
\*(T<commandString\*(T>
The SQL query to execute.
.TP 
\*(T<arrayVar\*(T>
An array variable for returned rows.
.TP 
\*(T<procedure\*(T>
The procedure to run for each returned row.
.SH "RETURN VALUE"
Number of rows actually processed.
.SH EXAMPLES
This examples assumes that the table \*(T<table1\*(T> has
columns \*(T<control\*(T> and \*(T<name\*(T> (and
perhaps others):

.nf
\*(T<
pg_select $pgconn "SELECT * FROM table1;" array {
    puts [format "%5d %s" $array(control) $array(name)]
}
\*(T>
.fi
.PP
This example demonstrates how to use named parameters to securely perform queries on an SQL database:

.nf
\*(T<
# An array imported from some hive of scum and villainy like a web form.
set form(first) {Andrew'); DROP TABLE students;\-\-}
set form(last) {Randall}

# Secure extraction of data
pg_select \-paramarray form $pgconn "SELECT * from students WHERE firstname = `first` AND lastname = `last`;" row {
    lappend candidates $row(student_id) $row(firstname) $row(lastname) $row(age)
}
\*(T>
.fi
