/*
 * Copyright (c) 2014, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

/*
 * @test
 * @bug 8035437
 * @summary Verifies that java.lang.AbstractMethodError is not thrown when
 *          serializing improper version of DocumentImpl class as reported in XERCESJ-1007.
 *          Test preconditions and steps:
 *          - Compiles test version of org.w3c.dom.Node and org.w3c.dom.Document
 *          - Compiles DocumentImpl overriding java.xml module with Node and Document
 *          - Runs AbstractMethodErrorTest overriding java.xml only with DocumentImpl class
 *            Hence, the interfaces compiled in the first step need to be removed
 *            from the test folder in order to reproduce the bug scenario. At the time of writing,
 *            the clean command was not able to resolve paths generated by compile/module
 * @library /test/lib
 * @compile --patch-module java.xml=${test.src} org/w3c/dom/Document.java
 * org/w3c/dom/Node.java com/sun/org/apache/xerces/internal/dom/DocumentImpl.java
 * @clean org.w3c.dom.*
 * @run main/othervm --patch-module java.xml=${test.class.path} AbstractMethodErrorTest
 */

public class AbstractMethodErrorTest {

    public static void main(String[] args) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();

        DOMImplementation impl = document.getImplementation();
        DOMImplementationLS implLS = (DOMImplementationLS) impl.getFeature("LS", "3.0");
        LSSerializer dsi = implLS.createLSSerializer();

        // We should have here incorrect document without getXmlVersion() method
        String result = dsi.writeToString(document);
        System.out.println("Result:" + result);
    }

}
