/*      -*- linux-c -*-
 *
 * (C) Copyright IBM Corp. 2004
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  This
 * file and program are licensed under a BSD style license.  See
 * the Copying file included with the OpenHPI distribution for
 * full licensing terms.
 *
 * Author(s):
 *      Steve Sherman <stevees@us.ibm.com> 
 */

/******************************************************************* 
 * WARNING! This file is auto-magically generated by:
 *          ./SaHpi2code.pl. 
 *          Do not change this file manually. Update script instead
 *******************************************************************/

#include <strings.h>

#include <SaHpi.h>
#include <oh_utils.h>

/**
 * oh_lookup_atcahpiledcolor:
 * @value: enum value of type AtcaHpiLedColorT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid AtcaHpiLedColorT.
 **/

char * oh_lookup_atcahpiledcolor(AtcaHpiLedColorT value)
{
        switch (value) {
        case ATCAHPI_LED_COLOR_RESERVED:
                return "COLOR_RESERVED";
        case ATCAHPI_LED_COLOR_BLUE:
                return "COLOR_BLUE";
        case ATCAHPI_LED_COLOR_RED:
                return "COLOR_RED";
        case ATCAHPI_LED_COLOR_GREEN:
                return "COLOR_GREEN";
        case ATCAHPI_LED_COLOR_AMBER:
                return "COLOR_AMBER";
        case ATCAHPI_LED_COLOR_ORANGE:
                return "COLOR_ORANGE";
        case ATCAHPI_LED_COLOR_WHITE:
                return "COLOR_WHITE";
        case ATCAHPI_LED_COLOR_NO_CHANGE:
                return "COLOR_NO_CHANGE";
        case ATCAHPI_LED_COLOR_USE_DEFAULT:
                return "COLOR_USE_DEFAULT";
        default:
                return NULL;
        }
}

struct oh_atcahpiledcolor_map atcahpiledcolor_strings[] = {
       {ATCAHPI_LED_COLOR_RESERVED, "COLOR_RESERVED"},
       {ATCAHPI_LED_COLOR_BLUE, "COLOR_BLUE"},
       {ATCAHPI_LED_COLOR_RED, "COLOR_RED"},
       {ATCAHPI_LED_COLOR_GREEN, "COLOR_GREEN"},
       {ATCAHPI_LED_COLOR_AMBER, "COLOR_AMBER"},
       {ATCAHPI_LED_COLOR_ORANGE, "COLOR_ORANGE"},
       {ATCAHPI_LED_COLOR_WHITE, "COLOR_WHITE"},
       {ATCAHPI_LED_COLOR_NO_CHANGE, "COLOR_NO_CHANGE"},
       {ATCAHPI_LED_COLOR_USE_DEFAULT, "COLOR_USE_DEFAULT"},
};

/**
 * oh_encode_atcahpiledcolor:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of AtcaHpiLedColorT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_atcahpiledcolor(), back 
 * into an AtcaHpiLedColorT type. 
 *
 * Returns:
 * AtcaHpiLedColorT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_atcahpiledcolor(SaHpiTextBufferT *buffer, AtcaHpiLedColorT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_ATCAHPILEDCOLOR; i++) {
		if (strcasecmp((char *)buffer->Data, atcahpiledcolor_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = atcahpiledcolor_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_atcahpiresourceledmode:
 * @value: enum value of type AtcaHpiResourceLedModeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid AtcaHpiResourceLedModeT.
 **/

char * oh_lookup_atcahpiresourceledmode(AtcaHpiResourceLedModeT value)
{
        switch (value) {
        case ATCAHPI_LED_AUTO:
                return "AUTO";
        case ATCAHPI_LED_MANUAL:
                return "MANUAL";
        case ATCAHPI_LED_LAMP_TEST:
                return "LAMP_TEST";
        default:
                return NULL;
        }
}

struct oh_atcahpiresourceledmode_map atcahpiresourceledmode_strings[] = {
       {ATCAHPI_LED_AUTO, "AUTO"},
       {ATCAHPI_LED_MANUAL, "MANUAL"},
       {ATCAHPI_LED_LAMP_TEST, "LAMP_TEST"},
};

/**
 * oh_encode_atcahpiresourceledmode:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of AtcaHpiResourceLedModeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_atcahpiresourceledmode(), back 
 * into an AtcaHpiResourceLedModeT type. 
 *
 * Returns:
 * AtcaHpiResourceLedModeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_atcahpiresourceledmode(SaHpiTextBufferT *buffer, AtcaHpiResourceLedModeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_ATCAHPIRESOURCELEDMODE; i++) {
		if (strcasecmp((char *)buffer->Data, atcahpiresourceledmode_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = atcahpiresourceledmode_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_atcahpiledbrsupport:
 * @value: enum value of type AtcaHpiLedBrSupportT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid AtcaHpiLedBrSupportT.
 **/

char * oh_lookup_atcahpiledbrsupport(AtcaHpiLedBrSupportT value)
{
        switch (value) {
        case ATCAHPI_LED_BR_SUPPORTED:
                return "BR_SUPPORTED";
        case ATCAHPI_LED_BR_NOT_SUPPORTED:
                return "BR_NOT_SUPPORTED";
        case ATCAHPI_LED_BR_UNKNOWN:
                return "BR_UNKNOWN";
        default:
                return NULL;
        }
}

struct oh_atcahpiledbrsupport_map atcahpiledbrsupport_strings[] = {
       {ATCAHPI_LED_BR_SUPPORTED, "BR_SUPPORTED"},
       {ATCAHPI_LED_BR_NOT_SUPPORTED, "BR_NOT_SUPPORTED"},
       {ATCAHPI_LED_BR_UNKNOWN, "BR_UNKNOWN"},
};

/**
 * oh_encode_atcahpiledbrsupport:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of AtcaHpiLedBrSupportT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_atcahpiledbrsupport(), back 
 * into an AtcaHpiLedBrSupportT type. 
 *
 * Returns:
 * AtcaHpiLedBrSupportT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_atcahpiledbrsupport(SaHpiTextBufferT *buffer, AtcaHpiLedBrSupportT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_ATCAHPILEDBRSUPPORT; i++) {
		if (strcasecmp((char *)buffer->Data, atcahpiledbrsupport_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = atcahpiledbrsupport_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

/**
 * oh_lookup_atcahpientitytype:
 * @value: enum value of type AtcaHpiEntityTypeT.
 *
 * Converts @value into a string based on @value's HPI enum definition.
 * 
 * Returns:
 * string - normal operation.
 * NULL - if @value not a valid AtcaHpiEntityTypeT.
 **/

char * oh_lookup_atcahpientitytype(AtcaHpiEntityTypeT value)
{
        switch (value) {
        case ATCAHPI_ENT_POWER_ENTRY_MODULE_SLOT:
                return "POWER_ENTRY_MODULE_SLOT";
        case ATCAHPI_ENT_SHELF_FRU_DEVICE_SLOT:
                return "SHELF_FRU_DEVICE_SLOT";
        case ATCAHPI_ENT_SHELF_MANAGER_SLOT:
                return "SHELF_MANAGER_SLOT";
        case ATCAHPI_ENT_FAN_TRAY_SLOT:
                return "FAN_TRAY_SLOT";
        case ATCAHPI_ENT_FAN_FILTER_TRAY_SLOT:
                return "FAN_FILTER_TRAY_SLOT";
        case ATCAHPI_ENT_ALARM_SLOT:
                return "ALARM_SLOT";
        case ATCAHPI_ENT_AMC_SLOT:
                return "AMC_SLOT";
        case ATCAHPI_ENT_PMC_SLOT:
                return "PMC_SLOT";
        case ATCAHPI_ENT_RTM_SLOT:
                return "RTM_SLOT";
        case ATCAHPI_ENT_PICMG_FRONT_BLADE:
                return "PICMG_FRONT_BLADE";
        case ATCAHPI_ENT_SHELF_FRU_DEVICE:
                return "SHELF_FRU_DEVICE";
        case ATCAHPI_ENT_FILTRATION_UNIT:
                return "FILTRATION_UNIT";
        case ATCAHPI_ENT_AMC:
                return "AMC";
        default:
                return NULL;
        }
}

struct oh_atcahpientitytype_map atcahpientitytype_strings[] = {
       {ATCAHPI_ENT_POWER_ENTRY_MODULE_SLOT, "POWER_ENTRY_MODULE_SLOT"},
       {ATCAHPI_ENT_SHELF_FRU_DEVICE_SLOT, "SHELF_FRU_DEVICE_SLOT"},
       {ATCAHPI_ENT_SHELF_MANAGER_SLOT, "SHELF_MANAGER_SLOT"},
       {ATCAHPI_ENT_FAN_TRAY_SLOT, "FAN_TRAY_SLOT"},
       {ATCAHPI_ENT_FAN_FILTER_TRAY_SLOT, "FAN_FILTER_TRAY_SLOT"},
       {ATCAHPI_ENT_ALARM_SLOT, "ALARM_SLOT"},
       {ATCAHPI_ENT_AMC_SLOT, "AMC_SLOT"},
       {ATCAHPI_ENT_PMC_SLOT, "PMC_SLOT"},
       {ATCAHPI_ENT_RTM_SLOT, "RTM_SLOT"},
       {ATCAHPI_ENT_PICMG_FRONT_BLADE, "PICMG_FRONT_BLADE"},
       {ATCAHPI_ENT_SHELF_FRU_DEVICE, "SHELF_FRU_DEVICE"},
       {ATCAHPI_ENT_FILTRATION_UNIT, "FILTRATION_UNIT"},
       {ATCAHPI_ENT_AMC, "AMC"},
};

/**
 * oh_encode_atcahpientitytype:
 * @buffer: Pointer to SaHpiTextBufferT that contains enum's string representation.
 * @type: Location (of AtcaHpiEntityTypeT) to place encoded result.
 * 
 * Converts a @buffer->Data string, generated by oh_lookup_atcahpientitytype(), back 
 * into an AtcaHpiEntityTypeT type. 
 *
 * Returns:
 * AtcaHpiEntityTypeT value - normal operation.
 * SA_ERR_HPI_INVALID_PARAMS - if @buffer or @type is NULL or @buffer->Data empty.
 * SA_ERR_HPI_INVALID_DATA - if @buffer->Data is invalid.
 **/
SaErrorT oh_encode_atcahpientitytype(SaHpiTextBufferT *buffer, AtcaHpiEntityTypeT *type)
{
	int i, found;

	if (!buffer || !type || buffer->Data == NULL || buffer->Data[0] == '\0') {
		return(SA_ERR_HPI_INVALID_PARAMS);
	}
	
	found = 0;
	for (i=0; i<OH_MAX_ATCAHPIENTITYTYPE; i++) {
		if (strcasecmp((char *)buffer->Data, atcahpientitytype_strings[i].str) == 0) {
			found++;
			break;
		}
	}

	if (found) {
		*type = atcahpientitytype_strings[i].entity_type;
	}
	else {
		return(SA_ERR_HPI_INVALID_DATA);
	}
	
	return(SA_OK);
}

