/******************************************************************************
 * Author:   Laurent Kneip                                                    *
 * Contact:  kneip.laurent@gmail.com                                          *
 * License:  Copyright (c) 2013 Laurent Kneip, ANU. All rights reserved.      *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 * * Redistributions of source code must retain the above copyright           *
 *   notice, this list of conditions and the following disclaimer.            *
 * * Redistributions in binary form must reproduce the above copyright        *
 *   notice, this list of conditions and the following disclaimer in the      *
 *   documentation and/or other materials provided with the distribution.     *
 * * Neither the name of ANU nor the names of its contributors may be         *
 *   used to endorse or promote products derived from this software without   *
 *   specific prior written permission.                                       *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"*
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE *
 * ARE DISCLAIMED. IN NO EVENT SHALL ANU OR THE CONTRIBUTORS BE LIABLE        *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR *
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT         *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     *
 * SUCH DAMAGE.                                                               *
 ******************************************************************************/

#include <opengv/relative_pose/modules/sixpt/modules.hpp>
#include <opengv/math/gauss_jordan.hpp>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>


void
opengv::relative_pose::modules::sixpt::fillRow1(
    const Eigen::Matrix<double,6,1> & l01,
    const Eigen::Matrix<double,6,1> & l02,
    const Eigen::Matrix<double,6,1> & l11,
    const Eigen::Matrix<double,6,1> & l12,
    std::vector<double> & c0,
    std::vector<double> & c1,
    std::vector<double> & c2 )
{
  c0.push_back(-l12[2]*l11[1]*l01[0]+l12[2]*l11[0]*l01[1]+l12[1]*l11[2]*l01[0]-l12[1]*l11[0]*l01[2]+l12[0]*l11[2]*l01[1]-l12[0]*l11[1]*l01[2]);
  c0.push_back(2*l12[1]*l11[2]*l01[1]-2*l12[1]*l11[1]*l01[2]-2*l12[0]*l11[2]*l01[0]+2*l12[0]*l11[0]*l01[2]);
  c0.push_back(-l12[2]*l11[1]*l01[0]+l12[2]*l11[0]*l01[1]-l12[1]*l11[2]*l01[0]+l12[1]*l11[0]*l01[2]-l12[0]*l11[2]*l01[1]+l12[0]*l11[1]*l01[2]);
  c0.push_back(2*l12[2]*l11[2]*l01[1]-2*l12[2]*l11[1]*l01[2]+2*l12[0]*l11[1]*l01[0]-2*l12[0]*l11[0]*l01[1]);
  c0.push_back(-2*l12[2]*l11[2]*l01[0]+2*l12[2]*l11[0]*l01[2]+2*l12[1]*l11[1]*l01[0]-2*l12[1]*l11[0]*l01[1]);
  c0.push_back(l12[2]*l11[1]*l01[0]-l12[2]*l11[0]*l01[1]+l12[1]*l11[2]*l01[0]-l12[1]*l11[0]*l01[2]-l12[0]*l11[2]*l01[1]+l12[0]*l11[1]*l01[2]);
  c0.push_back(-2*l12[2]*l11[2]*l01[0]+2*l12[2]*l11[0]*l01[2]-2*l12[1]*l11[1]*l01[0]+2*l12[1]*l11[0]*l01[1]);
  c0.push_back(-2*l12[2]*l11[2]*l01[1]+2*l12[2]*l11[1]*l01[2]+2*l12[0]*l11[1]*l01[0]-2*l12[0]*l11[0]*l01[1]);
  c0.push_back(2*l12[1]*l11[2]*l01[1]-2*l12[1]*l11[1]*l01[2]+2*l12[0]*l11[2]*l01[0]-2*l12[0]*l11[0]*l01[2]);
  c0.push_back(l12[2]*l11[1]*l01[0]-l12[2]*l11[0]*l01[1]-l12[1]*l11[2]*l01[0]+l12[1]*l11[0]*l01[2]+l12[0]*l11[2]*l01[1]-l12[0]*l11[1]*l01[2]);
  c1.push_back(l12[2]*l11[1]*l02[0]+l12[2]*l11[0]*l02[1]-l12[1]*l11[2]*l02[0]-l12[1]*l11[0]*l02[2]+l12[0]*l11[2]*l02[1]-l12[0]*l11[1]*l02[2]);
  c1.push_back(2*l12[2]*l11[1]*l02[1]-2*l12[2]*l11[0]*l02[0]-2*l12[1]*l11[1]*l02[2]+2*l12[0]*l11[0]*l02[2]);
  c1.push_back(-l12[2]*l11[1]*l02[0]-l12[2]*l11[0]*l02[1]-l12[1]*l11[2]*l02[0]+l12[1]*l11[0]*l02[2]+l12[0]*l11[2]*l02[1]+l12[0]*l11[1]*l02[2]);
  c1.push_back(2*l12[2]*l11[2]*l02[1]-2*l12[1]*l11[2]*l02[2]+2*l12[1]*l11[0]*l02[0]-2*l12[0]*l11[0]*l02[1]);
  c1.push_back(-2*l12[2]*l11[2]*l02[0]+2*l12[1]*l11[1]*l02[0]+2*l12[0]*l11[2]*l02[2]-2*l12[0]*l11[1]*l02[1]);
  c1.push_back(l12[2]*l11[1]*l02[0]-l12[2]*l11[0]*l02[1]+l12[1]*l11[2]*l02[0]+l12[1]*l11[0]*l02[2]-l12[0]*l11[2]*l02[1]-l12[0]*l11[1]*l02[2]);
  c1.push_back(2*l12[2]*l11[2]*l02[0]+2*l12[1]*l11[1]*l02[0]-2*l12[0]*l11[2]*l02[2]-2*l12[0]*l11[1]*l02[1]);
  c1.push_back(2*l12[2]*l11[2]*l02[1]-2*l12[1]*l11[2]*l02[2]-2*l12[1]*l11[0]*l02[0]+2*l12[0]*l11[0]*l02[1]);
  c1.push_back(-2*l12[2]*l11[1]*l02[1]-2*l12[2]*l11[0]*l02[0]+2*l12[1]*l11[1]*l02[2]+2*l12[0]*l11[0]*l02[2]);
  c1.push_back(-l12[2]*l11[1]*l02[0]+l12[2]*l11[0]*l02[1]+l12[1]*l11[2]*l02[0]-l12[1]*l11[0]*l02[2]-l12[0]*l11[2]*l02[1]+l12[0]*l11[1]*l02[2]);
  c2.push_back(-l12[2]*l11[1]*l02[5]*l02[1]+l12[2]*l11[1]*l02[4]*l02[2]+l12[2]*l11[1]*l01[5]*l01[1]-l12[2]*l11[1]*l01[4]*l01[2]+l12[2]*l11[0]*l02[5]*l02[0]-l12[2]*l11[0]*l02[3]*l02[2]+l12[2]*l11[0]*l01[5]*l01[0]-l12[2]*l11[0]*l01[3]*l01[2]+l12[1]*l11[2]*l02[5]*l02[1]-l12[1]*l11[2]*l02[4]*l02[2]-l12[1]*l11[2]*l01[5]*l01[1]+l12[1]*l11[2]*l01[4]*l01[2]+l12[1]*l11[0]*l02[4]*l02[0]-l12[1]*l11[0]*l02[3]*l02[1]+l12[1]*l11[0]*l01[4]*l01[0]-l12[1]*l11[0]*l01[3]*l01[1]+l12[0]*l11[2]*l02[5]*l02[0]-l12[0]*l11[2]*l02[3]*l02[2]+l12[0]*l11[2]*l01[5]*l01[0]-l12[0]*l11[2]*l01[3]*l01[2]+l12[0]*l11[1]*l02[4]*l02[0]-l12[0]*l11[1]*l02[3]*l02[1]+l12[0]*l11[1]*l01[4]*l01[0]-l12[0]*l11[1]*l01[3]*l01[1]-l12[5]*l11[2]-l12[4]*l11[1]+l12[3]*l11[0]-l12[2]*l11[5]-l12[1]*l11[4]+l12[0]*l11[3]);
  c2.push_back(2*l12[2]*l11[1]*l02[5]*l02[0]-2*l12[2]*l11[1]*l02[3]*l02[2]+2*l12[2]*l11[0]*l02[5]*l02[1]-2*l12[2]*l11[0]*l02[4]*l02[2]+2*l12[1]*l11[2]*l01[5]*l01[0]-2*l12[1]*l11[2]*l01[3]*l01[2]+2*l12[1]*l11[1]*l02[4]*l02[0]-2*l12[1]*l11[1]*l02[3]*l02[1]+2*l12[1]*l11[1]*l01[4]*l01[0]-2*l12[1]*l11[1]*l01[3]*l01[1]+2*l12[0]*l11[2]*l01[5]*l01[1]-2*l12[0]*l11[2]*l01[4]*l01[2]-2*l12[0]*l11[0]*l02[4]*l02[0]+2*l12[0]*l11[0]*l02[3]*l02[1]-2*l12[0]*l11[0]*l01[4]*l01[0]+2*l12[0]*l11[0]*l01[3]*l01[1]+2*l12[4]*l11[0]+2*l12[3]*l11[1]+2*l12[1]*l11[3]+2*l12[0]*l11[4]);
  c2.push_back(l12[2]*l11[1]*l02[5]*l02[1]-l12[2]*l11[1]*l02[4]*l02[2]+l12[2]*l11[1]*l01[5]*l01[1]-l12[2]*l11[1]*l01[4]*l01[2]-l12[2]*l11[0]*l02[5]*l02[0]+l12[2]*l11[0]*l02[3]*l02[2]+l12[2]*l11[0]*l01[5]*l01[0]-l12[2]*l11[0]*l01[3]*l01[2]+l12[1]*l11[2]*l02[5]*l02[1]-l12[1]*l11[2]*l02[4]*l02[2]+l12[1]*l11[2]*l01[5]*l01[1]-l12[1]*l11[2]*l01[4]*l01[2]-l12[1]*l11[0]*l02[4]*l02[0]+l12[1]*l11[0]*l02[3]*l02[1]-l12[1]*l11[0]*l01[4]*l01[0]+l12[1]*l11[0]*l01[3]*l01[1]+l12[0]*l11[2]*l02[5]*l02[0]-l12[0]*l11[2]*l02[3]*l02[2]-l12[0]*l11[2]*l01[5]*l01[0]+l12[0]*l11[2]*l01[3]*l01[2]-l12[0]*l11[1]*l02[4]*l02[0]+l12[0]*l11[1]*l02[3]*l02[1]-l12[0]*l11[1]*l01[4]*l01[0]+l12[0]*l11[1]*l01[3]*l01[1]-l12[5]*l11[2]+l12[4]*l11[1]-l12[3]*l11[0]-l12[2]*l11[5]+l12[1]*l11[4]-l12[0]*l11[3]);
  c2.push_back(2*l12[2]*l11[2]*l02[5]*l02[0]-2*l12[2]*l11[2]*l02[3]*l02[2]+2*l12[2]*l11[2]*l01[5]*l01[0]-2*l12[2]*l11[2]*l01[3]*l01[2]+2*l12[2]*l11[1]*l01[4]*l01[0]-2*l12[2]*l11[1]*l01[3]*l01[1]+2*l12[1]*l11[2]*l02[4]*l02[0]-2*l12[1]*l11[2]*l02[3]*l02[1]-2*l12[1]*l11[0]*l02[5]*l02[1]+2*l12[1]*l11[0]*l02[4]*l02[2]-2*l12[0]*l11[1]*l01[5]*l01[1]+2*l12[0]*l11[1]*l01[4]*l01[2]-2*l12[0]*l11[0]*l02[5]*l02[0]+2*l12[0]*l11[0]*l02[3]*l02[2]-2*l12[0]*l11[0]*l01[5]*l01[0]+2*l12[0]*l11[0]*l01[3]*l01[2]+2*l12[5]*l11[0]+2*l12[3]*l11[2]+2*l12[2]*l11[3]+2*l12[0]*l11[5]);
  c2.push_back(2*l12[2]*l11[2]*l02[5]*l02[1]-2*l12[2]*l11[2]*l02[4]*l02[2]+2*l12[2]*l11[2]*l01[5]*l01[1]-2*l12[2]*l11[2]*l01[4]*l01[2]-2*l12[2]*l11[0]*l01[4]*l01[0]+2*l12[2]*l11[0]*l01[3]*l01[1]-2*l12[1]*l11[1]*l02[5]*l02[1]+2*l12[1]*l11[1]*l02[4]*l02[2]-2*l12[1]*l11[1]*l01[5]*l01[1]+2*l12[1]*l11[1]*l01[4]*l01[2]-2*l12[1]*l11[0]*l01[5]*l01[0]+2*l12[1]*l11[0]*l01[3]*l01[2]-2*l12[0]*l11[2]*l02[4]*l02[0]+2*l12[0]*l11[2]*l02[3]*l02[1]-2*l12[0]*l11[1]*l02[5]*l02[0]+2*l12[0]*l11[1]*l02[3]*l02[2]+2*l12[5]*l11[1]+2*l12[4]*l11[2]+2*l12[2]*l11[4]+2*l12[1]*l11[5]);
  c2.push_back(-l12[2]*l11[1]*l02[5]*l02[1]+l12[2]*l11[1]*l02[4]*l02[2]-l12[2]*l11[1]*l01[5]*l01[1]+l12[2]*l11[1]*l01[4]*l01[2]-l12[2]*l11[0]*l02[5]*l02[0]+l12[2]*l11[0]*l02[3]*l02[2]-l12[2]*l11[0]*l01[5]*l01[0]+l12[2]*l11[0]*l01[3]*l01[2]-l12[1]*l11[2]*l02[5]*l02[1]+l12[1]*l11[2]*l02[4]*l02[2]-l12[1]*l11[2]*l01[5]*l01[1]+l12[1]*l11[2]*l01[4]*l01[2]-l12[1]*l11[0]*l02[4]*l02[0]+l12[1]*l11[0]*l02[3]*l02[1]+l12[1]*l11[0]*l01[4]*l01[0]-l12[1]*l11[0]*l01[3]*l01[1]-l12[0]*l11[2]*l02[5]*l02[0]+l12[0]*l11[2]*l02[3]*l02[2]-l12[0]*l11[2]*l01[5]*l01[0]+l12[0]*l11[2]*l01[3]*l01[2]+l12[0]*l11[1]*l02[4]*l02[0]-l12[0]*l11[1]*l02[3]*l02[1]-l12[0]*l11[1]*l01[4]*l01[0]+l12[0]*l11[1]*l01[3]*l01[1]+l12[5]*l11[2]-l12[4]*l11[1]-l12[3]*l11[0]+l12[2]*l11[5]-l12[1]*l11[4]-l12[0]*l11[3]);
  c2.push_back(-2*l12[2]*l11[2]*l02[5]*l02[1]+2*l12[2]*l11[2]*l02[4]*l02[2]+2*l12[2]*l11[2]*l01[5]*l01[1]-2*l12[2]*l11[2]*l01[4]*l01[2]-2*l12[2]*l11[0]*l01[4]*l01[0]+2*l12[2]*l11[0]*l01[3]*l01[1]-2*l12[1]*l11[1]*l02[5]*l02[1]+2*l12[1]*l11[1]*l02[4]*l02[2]+2*l12[1]*l11[1]*l01[5]*l01[1]-2*l12[1]*l11[1]*l01[4]*l01[2]+2*l12[1]*l11[0]*l01[5]*l01[0]-2*l12[1]*l11[0]*l01[3]*l01[2]+2*l12[0]*l11[2]*l02[4]*l02[0]-2*l12[0]*l11[2]*l02[3]*l02[1]-2*l12[0]*l11[1]*l02[5]*l02[0]+2*l12[0]*l11[1]*l02[3]*l02[2]+2*l12[5]*l11[1]-2*l12[4]*l11[2]+2*l12[2]*l11[4]-2*l12[1]*l11[5]);
  c2.push_back(2*l12[2]*l11[2]*l02[5]*l02[0]-2*l12[2]*l11[2]*l02[3]*l02[2]-2*l12[2]*l11[2]*l01[5]*l01[0]+2*l12[2]*l11[2]*l01[3]*l01[2]-2*l12[2]*l11[1]*l01[4]*l01[0]+2*l12[2]*l11[1]*l01[3]*l01[1]+2*l12[1]*l11[2]*l02[4]*l02[0]-2*l12[1]*l11[2]*l02[3]*l02[1]+2*l12[1]*l11[0]*l02[5]*l02[1]-2*l12[1]*l11[0]*l02[4]*l02[2]-2*l12[0]*l11[1]*l01[5]*l01[1]+2*l12[0]*l11[1]*l01[4]*l01[2]+2*l12[0]*l11[0]*l02[5]*l02[0]-2*l12[0]*l11[0]*l02[3]*l02[2]-2*l12[0]*l11[0]*l01[5]*l01[0]+2*l12[0]*l11[0]*l01[3]*l01[2]-2*l12[5]*l11[0]+2*l12[3]*l11[2]-2*l12[2]*l11[3]+2*l12[0]*l11[5]);
  c2.push_back(-2*l12[2]*l11[1]*l02[5]*l02[0]+2*l12[2]*l11[1]*l02[3]*l02[2]+2*l12[2]*l11[0]*l02[5]*l02[1]-2*l12[2]*l11[0]*l02[4]*l02[2]+2*l12[1]*l11[2]*l01[5]*l01[0]-2*l12[1]*l11[2]*l01[3]*l01[2]-2*l12[1]*l11[1]*l02[4]*l02[0]+2*l12[1]*l11[1]*l02[3]*l02[1]+2*l12[1]*l11[1]*l01[4]*l01[0]-2*l12[1]*l11[1]*l01[3]*l01[1]-2*l12[0]*l11[2]*l01[5]*l01[1]+2*l12[0]*l11[2]*l01[4]*l01[2]-2*l12[0]*l11[0]*l02[4]*l02[0]+2*l12[0]*l11[0]*l02[3]*l02[1]+2*l12[0]*l11[0]*l01[4]*l01[0]-2*l12[0]*l11[0]*l01[3]*l01[1]+2*l12[4]*l11[0]-2*l12[3]*l11[1]+2*l12[1]*l11[3]-2*l12[0]*l11[4]);
  c2.push_back(l12[2]*l11[1]*l02[5]*l02[1]-l12[2]*l11[1]*l02[4]*l02[2]-l12[2]*l11[1]*l01[5]*l01[1]+l12[2]*l11[1]*l01[4]*l01[2]+l12[2]*l11[0]*l02[5]*l02[0]-l12[2]*l11[0]*l02[3]*l02[2]-l12[2]*l11[0]*l01[5]*l01[0]+l12[2]*l11[0]*l01[3]*l01[2]-l12[1]*l11[2]*l02[5]*l02[1]+l12[1]*l11[2]*l02[4]*l02[2]+l12[1]*l11[2]*l01[5]*l01[1]-l12[1]*l11[2]*l01[4]*l01[2]+l12[1]*l11[0]*l02[4]*l02[0]-l12[1]*l11[0]*l02[3]*l02[1]-l12[1]*l11[0]*l01[4]*l01[0]+l12[1]*l11[0]*l01[3]*l01[1]-l12[0]*l11[2]*l02[5]*l02[0]+l12[0]*l11[2]*l02[3]*l02[2]+l12[0]*l11[2]*l01[5]*l01[0]-l12[0]*l11[2]*l01[3]*l01[2]-l12[0]*l11[1]*l02[4]*l02[0]+l12[0]*l11[1]*l02[3]*l02[1]+l12[0]*l11[1]*l01[4]*l01[0]-l12[0]*l11[1]*l01[3]*l01[1]+l12[5]*l11[2]+l12[4]*l11[1]+l12[3]*l11[0]+l12[2]*l11[5]+l12[1]*l11[4]+l12[0]*l11[3]);
}

void
opengv::relative_pose::modules::sixpt::fillRow2(
    Eigen::Matrix<double,EQS,84> & M1,
    int row,
    const std::vector<double> (&m0)[3],
    const std::vector<double> (&m1)[3],
    const std::vector<double> (&m2)[3] )
{
  M1(row,0) = m2[2][0]*m1[1][0]*m0[0][0]-m2[2][0]*m1[0][0]*m0[1][0]-m2[1][0]*m1[2][0]*m0[0][0]+m2[1][0]*m1[0][0]*m0[2][0]+m2[0][0]*m1[2][0]*m0[1][0]-m2[0][0]*m1[1][0]*m0[2][0]; 
  M1(row,1) = m2[2][1]*m1[1][0]*m0[0][0]-m2[2][1]*m1[0][0]*m0[1][0]+m2[2][0]*m1[1][1]*m0[0][0]+m2[2][0]*m1[1][0]*m0[0][1]-m2[2][0]*m1[0][1]*m0[1][0]-m2[2][0]*m1[0][0]*m0[1][1]-m2[1][1]*m1[2][0]*m0[0][0]+m2[1][1]*m1[0][0]*m0[2][0]-m2[1][0]*m1[2][1]*m0[0][0]-m2[1][0]*m1[2][0]*m0[0][1]+m2[1][0]*m1[0][1]*m0[2][0]+m2[1][0]*m1[0][0]*m0[2][1]+m2[0][1]*m1[2][0]*m0[1][0]-m2[0][1]*m1[1][0]*m0[2][0]+m2[0][0]*m1[2][1]*m0[1][0]+m2[0][0]*m1[2][0]*m0[1][1]-m2[0][0]*m1[1][1]*m0[2][0]-m2[0][0]*m1[1][0]*m0[2][1]; 
  M1(row,2) = m2[2][2]*m1[1][0]*m0[0][0]-m2[2][2]*m1[0][0]*m0[1][0]+m2[2][1]*m1[1][1]*m0[0][0]+m2[2][1]*m1[1][0]*m0[0][1]-m2[2][1]*m1[0][1]*m0[1][0]-m2[2][1]*m1[0][0]*m0[1][1]+m2[2][0]*m1[1][2]*m0[0][0]+m2[2][0]*m1[1][1]*m0[0][1]+m2[2][0]*m1[1][0]*m0[0][2]-m2[2][0]*m1[0][2]*m0[1][0]-m2[2][0]*m1[0][1]*m0[1][1]-m2[2][0]*m1[0][0]*m0[1][2]-m2[1][2]*m1[2][0]*m0[0][0]+m2[1][2]*m1[0][0]*m0[2][0]-m2[1][1]*m1[2][1]*m0[0][0]-m2[1][1]*m1[2][0]*m0[0][1]+m2[1][1]*m1[0][1]*m0[2][0]+m2[1][1]*m1[0][0]*m0[2][1]-m2[1][0]*m1[2][2]*m0[0][0]-m2[1][0]*m1[2][1]*m0[0][1]-m2[1][0]*m1[2][0]*m0[0][2]+m2[1][0]*m1[0][2]*m0[2][0]+m2[1][0]*m1[0][1]*m0[2][1]+m2[1][0]*m1[0][0]*m0[2][2]+m2[0][2]*m1[2][0]*m0[1][0]-m2[0][2]*m1[1][0]*m0[2][0]+m2[0][1]*m1[2][1]*m0[1][0]+m2[0][1]*m1[2][0]*m0[1][1]-m2[0][1]*m1[1][1]*m0[2][0]-m2[0][1]*m1[1][0]*m0[2][1]+m2[0][0]*m1[2][2]*m0[1][0]+m2[0][0]*m1[2][1]*m0[1][1]+m2[0][0]*m1[2][0]*m0[1][2]-m2[0][0]*m1[1][2]*m0[2][0]-m2[0][0]*m1[1][1]*m0[2][1]-m2[0][0]*m1[1][0]*m0[2][2]; 
  M1(row,3) = m2[2][2]*m1[1][1]*m0[0][0]+m2[2][2]*m1[1][0]*m0[0][1]-m2[2][2]*m1[0][1]*m0[1][0]-m2[2][2]*m1[0][0]*m0[1][1]+m2[2][1]*m1[1][2]*m0[0][0]+m2[2][1]*m1[1][1]*m0[0][1]+m2[2][1]*m1[1][0]*m0[0][2]-m2[2][1]*m1[0][2]*m0[1][0]-m2[2][1]*m1[0][1]*m0[1][1]-m2[2][1]*m1[0][0]*m0[1][2]+m2[2][0]*m1[1][2]*m0[0][1]+m2[2][0]*m1[1][1]*m0[0][2]-m2[2][0]*m1[0][2]*m0[1][1]-m2[2][0]*m1[0][1]*m0[1][2]-m2[1][2]*m1[2][1]*m0[0][0]-m2[1][2]*m1[2][0]*m0[0][1]+m2[1][2]*m1[0][1]*m0[2][0]+m2[1][2]*m1[0][0]*m0[2][1]-m2[1][1]*m1[2][2]*m0[0][0]-m2[1][1]*m1[2][1]*m0[0][1]-m2[1][1]*m1[2][0]*m0[0][2]+m2[1][1]*m1[0][2]*m0[2][0]+m2[1][1]*m1[0][1]*m0[2][1]+m2[1][1]*m1[0][0]*m0[2][2]-m2[1][0]*m1[2][2]*m0[0][1]-m2[1][0]*m1[2][1]*m0[0][2]+m2[1][0]*m1[0][2]*m0[2][1]+m2[1][0]*m1[0][1]*m0[2][2]+m2[0][2]*m1[2][1]*m0[1][0]+m2[0][2]*m1[2][0]*m0[1][1]-m2[0][2]*m1[1][1]*m0[2][0]-m2[0][2]*m1[1][0]*m0[2][1]+m2[0][1]*m1[2][2]*m0[1][0]+m2[0][1]*m1[2][1]*m0[1][1]+m2[0][1]*m1[2][0]*m0[1][2]-m2[0][1]*m1[1][2]*m0[2][0]-m2[0][1]*m1[1][1]*m0[2][1]-m2[0][1]*m1[1][0]*m0[2][2]+m2[0][0]*m1[2][2]*m0[1][1]+m2[0][0]*m1[2][1]*m0[1][2]-m2[0][0]*m1[1][2]*m0[2][1]-m2[0][0]*m1[1][1]*m0[2][2]; 
  M1(row,4) = m2[2][2]*m1[1][2]*m0[0][0]+m2[2][2]*m1[1][1]*m0[0][1]+m2[2][2]*m1[1][0]*m0[0][2]-m2[2][2]*m1[0][2]*m0[1][0]-m2[2][2]*m1[0][1]*m0[1][1]-m2[2][2]*m1[0][0]*m0[1][2]+m2[2][1]*m1[1][2]*m0[0][1]+m2[2][1]*m1[1][1]*m0[0][2]-m2[2][1]*m1[0][2]*m0[1][1]-m2[2][1]*m1[0][1]*m0[1][2]+m2[2][0]*m1[1][2]*m0[0][2]-m2[2][0]*m1[0][2]*m0[1][2]-m2[1][2]*m1[2][2]*m0[0][0]-m2[1][2]*m1[2][1]*m0[0][1]-m2[1][2]*m1[2][0]*m0[0][2]+m2[1][2]*m1[0][2]*m0[2][0]+m2[1][2]*m1[0][1]*m0[2][1]+m2[1][2]*m1[0][0]*m0[2][2]-m2[1][1]*m1[2][2]*m0[0][1]-m2[1][1]*m1[2][1]*m0[0][2]+m2[1][1]*m1[0][2]*m0[2][1]+m2[1][1]*m1[0][1]*m0[2][2]-m2[1][0]*m1[2][2]*m0[0][2]+m2[1][0]*m1[0][2]*m0[2][2]+m2[0][2]*m1[2][2]*m0[1][0]+m2[0][2]*m1[2][1]*m0[1][1]+m2[0][2]*m1[2][0]*m0[1][2]-m2[0][2]*m1[1][2]*m0[2][0]-m2[0][2]*m1[1][1]*m0[2][1]-m2[0][2]*m1[1][0]*m0[2][2]+m2[0][1]*m1[2][2]*m0[1][1]+m2[0][1]*m1[2][1]*m0[1][2]-m2[0][1]*m1[1][2]*m0[2][1]-m2[0][1]*m1[1][1]*m0[2][2]+m2[0][0]*m1[2][2]*m0[1][2]-m2[0][0]*m1[1][2]*m0[2][2]; 
  M1(row,5) = m2[2][2]*m1[1][2]*m0[0][1]+m2[2][2]*m1[1][1]*m0[0][2]-m2[2][2]*m1[0][2]*m0[1][1]-m2[2][2]*m1[0][1]*m0[1][2]+m2[2][1]*m1[1][2]*m0[0][2]-m2[2][1]*m1[0][2]*m0[1][2]-m2[1][2]*m1[2][2]*m0[0][1]-m2[1][2]*m1[2][1]*m0[0][2]+m2[1][2]*m1[0][2]*m0[2][1]+m2[1][2]*m1[0][1]*m0[2][2]-m2[1][1]*m1[2][2]*m0[0][2]+m2[1][1]*m1[0][2]*m0[2][2]+m2[0][2]*m1[2][2]*m0[1][1]+m2[0][2]*m1[2][1]*m0[1][2]-m2[0][2]*m1[1][2]*m0[2][1]-m2[0][2]*m1[1][1]*m0[2][2]+m2[0][1]*m1[2][2]*m0[1][2]-m2[0][1]*m1[1][2]*m0[2][2]; 
  M1(row,6) = m2[2][2]*m1[1][2]*m0[0][2]-m2[2][2]*m1[0][2]*m0[1][2]-m2[1][2]*m1[2][2]*m0[0][2]+m2[1][2]*m1[0][2]*m0[2][2]+m2[0][2]*m1[2][2]*m0[1][2]-m2[0][2]*m1[1][2]*m0[2][2]; 
  M1(row,7) = m2[2][3]*m1[1][0]*m0[0][0]-m2[2][3]*m1[0][0]*m0[1][0]+m2[2][0]*m1[1][3]*m0[0][0]+m2[2][0]*m1[1][0]*m0[0][3]-m2[2][0]*m1[0][3]*m0[1][0]-m2[2][0]*m1[0][0]*m0[1][3]-m2[1][3]*m1[2][0]*m0[0][0]+m2[1][3]*m1[0][0]*m0[2][0]-m2[1][0]*m1[2][3]*m0[0][0]-m2[1][0]*m1[2][0]*m0[0][3]+m2[1][0]*m1[0][3]*m0[2][0]+m2[1][0]*m1[0][0]*m0[2][3]+m2[0][3]*m1[2][0]*m0[1][0]-m2[0][3]*m1[1][0]*m0[2][0]+m2[0][0]*m1[2][3]*m0[1][0]+m2[0][0]*m1[2][0]*m0[1][3]-m2[0][0]*m1[1][3]*m0[2][0]-m2[0][0]*m1[1][0]*m0[2][3]; 
  M1(row,8) = m2[2][4]*m1[1][0]*m0[0][0]-m2[2][4]*m1[0][0]*m0[1][0]+m2[2][3]*m1[1][1]*m0[0][0]+m2[2][3]*m1[1][0]*m0[0][1]-m2[2][3]*m1[0][1]*m0[1][0]-m2[2][3]*m1[0][0]*m0[1][1]+m2[2][1]*m1[1][3]*m0[0][0]+m2[2][1]*m1[1][0]*m0[0][3]-m2[2][1]*m1[0][3]*m0[1][0]-m2[2][1]*m1[0][0]*m0[1][3]+m2[2][0]*m1[1][4]*m0[0][0]+m2[2][0]*m1[1][3]*m0[0][1]+m2[2][0]*m1[1][1]*m0[0][3]+m2[2][0]*m1[1][0]*m0[0][4]-m2[2][0]*m1[0][4]*m0[1][0]-m2[2][0]*m1[0][3]*m0[1][1]-m2[2][0]*m1[0][1]*m0[1][3]-m2[2][0]*m1[0][0]*m0[1][4]-m2[1][4]*m1[2][0]*m0[0][0]+m2[1][4]*m1[0][0]*m0[2][0]-m2[1][3]*m1[2][1]*m0[0][0]-m2[1][3]*m1[2][0]*m0[0][1]+m2[1][3]*m1[0][1]*m0[2][0]+m2[1][3]*m1[0][0]*m0[2][1]-m2[1][1]*m1[2][3]*m0[0][0]-m2[1][1]*m1[2][0]*m0[0][3]+m2[1][1]*m1[0][3]*m0[2][0]+m2[1][1]*m1[0][0]*m0[2][3]-m2[1][0]*m1[2][4]*m0[0][0]-m2[1][0]*m1[2][3]*m0[0][1]-m2[1][0]*m1[2][1]*m0[0][3]-m2[1][0]*m1[2][0]*m0[0][4]+m2[1][0]*m1[0][4]*m0[2][0]+m2[1][0]*m1[0][3]*m0[2][1]+m2[1][0]*m1[0][1]*m0[2][3]+m2[1][0]*m1[0][0]*m0[2][4]+m2[0][4]*m1[2][0]*m0[1][0]-m2[0][4]*m1[1][0]*m0[2][0]+m2[0][3]*m1[2][1]*m0[1][0]+m2[0][3]*m1[2][0]*m0[1][1]-m2[0][3]*m1[1][1]*m0[2][0]-m2[0][3]*m1[1][0]*m0[2][1]+m2[0][1]*m1[2][3]*m0[1][0]+m2[0][1]*m1[2][0]*m0[1][3]-m2[0][1]*m1[1][3]*m0[2][0]-m2[0][1]*m1[1][0]*m0[2][3]+m2[0][0]*m1[2][4]*m0[1][0]+m2[0][0]*m1[2][3]*m0[1][1]+m2[0][0]*m1[2][1]*m0[1][3]+m2[0][0]*m1[2][0]*m0[1][4]-m2[0][0]*m1[1][4]*m0[2][0]-m2[0][0]*m1[1][3]*m0[2][1]-m2[0][0]*m1[1][1]*m0[2][3]-m2[0][0]*m1[1][0]*m0[2][4]; 
  M1(row,9) = m2[2][4]*m1[1][1]*m0[0][0]+m2[2][4]*m1[1][0]*m0[0][1]-m2[2][4]*m1[0][1]*m0[1][0]-m2[2][4]*m1[0][0]*m0[1][1]+m2[2][3]*m1[1][2]*m0[0][0]+m2[2][3]*m1[1][1]*m0[0][1]+m2[2][3]*m1[1][0]*m0[0][2]-m2[2][3]*m1[0][2]*m0[1][0]-m2[2][3]*m1[0][1]*m0[1][1]-m2[2][3]*m1[0][0]*m0[1][2]+m2[2][2]*m1[1][3]*m0[0][0]+m2[2][2]*m1[1][0]*m0[0][3]-m2[2][2]*m1[0][3]*m0[1][0]-m2[2][2]*m1[0][0]*m0[1][3]+m2[2][1]*m1[1][4]*m0[0][0]+m2[2][1]*m1[1][3]*m0[0][1]+m2[2][1]*m1[1][1]*m0[0][3]+m2[2][1]*m1[1][0]*m0[0][4]-m2[2][1]*m1[0][4]*m0[1][0]-m2[2][1]*m1[0][3]*m0[1][1]-m2[2][1]*m1[0][1]*m0[1][3]-m2[2][1]*m1[0][0]*m0[1][4]+m2[2][0]*m1[1][4]*m0[0][1]+m2[2][0]*m1[1][3]*m0[0][2]+m2[2][0]*m1[1][2]*m0[0][3]+m2[2][0]*m1[1][1]*m0[0][4]-m2[2][0]*m1[0][4]*m0[1][1]-m2[2][0]*m1[0][3]*m0[1][2]-m2[2][0]*m1[0][2]*m0[1][3]-m2[2][0]*m1[0][1]*m0[1][4]-m2[1][4]*m1[2][1]*m0[0][0]-m2[1][4]*m1[2][0]*m0[0][1]+m2[1][4]*m1[0][1]*m0[2][0]+m2[1][4]*m1[0][0]*m0[2][1]-m2[1][3]*m1[2][2]*m0[0][0]-m2[1][3]*m1[2][1]*m0[0][1]-m2[1][3]*m1[2][0]*m0[0][2]+m2[1][3]*m1[0][2]*m0[2][0]+m2[1][3]*m1[0][1]*m0[2][1]+m2[1][3]*m1[0][0]*m0[2][2]-m2[1][2]*m1[2][3]*m0[0][0]-m2[1][2]*m1[2][0]*m0[0][3]+m2[1][2]*m1[0][3]*m0[2][0]+m2[1][2]*m1[0][0]*m0[2][3]-m2[1][1]*m1[2][4]*m0[0][0]-m2[1][1]*m1[2][3]*m0[0][1]-m2[1][1]*m1[2][1]*m0[0][3]-m2[1][1]*m1[2][0]*m0[0][4]+m2[1][1]*m1[0][4]*m0[2][0]+m2[1][1]*m1[0][3]*m0[2][1]+m2[1][1]*m1[0][1]*m0[2][3]+m2[1][1]*m1[0][0]*m0[2][4]-m2[1][0]*m1[2][4]*m0[0][1]-m2[1][0]*m1[2][3]*m0[0][2]-m2[1][0]*m1[2][2]*m0[0][3]-m2[1][0]*m1[2][1]*m0[0][4]+m2[1][0]*m1[0][4]*m0[2][1]+m2[1][0]*m1[0][3]*m0[2][2]+m2[1][0]*m1[0][2]*m0[2][3]+m2[1][0]*m1[0][1]*m0[2][4]+m2[0][4]*m1[2][1]*m0[1][0]+m2[0][4]*m1[2][0]*m0[1][1]-m2[0][4]*m1[1][1]*m0[2][0]-m2[0][4]*m1[1][0]*m0[2][1]+m2[0][3]*m1[2][2]*m0[1][0]+m2[0][3]*m1[2][1]*m0[1][1]+m2[0][3]*m1[2][0]*m0[1][2]-m2[0][3]*m1[1][2]*m0[2][0]-m2[0][3]*m1[1][1]*m0[2][1]-m2[0][3]*m1[1][0]*m0[2][2]+m2[0][2]*m1[2][3]*m0[1][0]+m2[0][2]*m1[2][0]*m0[1][3]-m2[0][2]*m1[1][3]*m0[2][0]-m2[0][2]*m1[1][0]*m0[2][3]+m2[0][1]*m1[2][4]*m0[1][0]+m2[0][1]*m1[2][3]*m0[1][1]+m2[0][1]*m1[2][1]*m0[1][3]+m2[0][1]*m1[2][0]*m0[1][4]-m2[0][1]*m1[1][4]*m0[2][0]-m2[0][1]*m1[1][3]*m0[2][1]-m2[0][1]*m1[1][1]*m0[2][3]-m2[0][1]*m1[1][0]*m0[2][4]+m2[0][0]*m1[2][4]*m0[1][1]+m2[0][0]*m1[2][3]*m0[1][2]+m2[0][0]*m1[2][2]*m0[1][3]+m2[0][0]*m1[2][1]*m0[1][4]-m2[0][0]*m1[1][4]*m0[2][1]-m2[0][0]*m1[1][3]*m0[2][2]-m2[0][0]*m1[1][2]*m0[2][3]-m2[0][0]*m1[1][1]*m0[2][4]; 
  M1(row,10) = m2[2][4]*m1[1][2]*m0[0][0]+m2[2][4]*m1[1][1]*m0[0][1]+m2[2][4]*m1[1][0]*m0[0][2]-m2[2][4]*m1[0][2]*m0[1][0]-m2[2][4]*m1[0][1]*m0[1][1]-m2[2][4]*m1[0][0]*m0[1][2]+m2[2][3]*m1[1][2]*m0[0][1]+m2[2][3]*m1[1][1]*m0[0][2]-m2[2][3]*m1[0][2]*m0[1][1]-m2[2][3]*m1[0][1]*m0[1][2]+m2[2][2]*m1[1][4]*m0[0][0]+m2[2][2]*m1[1][3]*m0[0][1]+m2[2][2]*m1[1][1]*m0[0][3]+m2[2][2]*m1[1][0]*m0[0][4]-m2[2][2]*m1[0][4]*m0[1][0]-m2[2][2]*m1[0][3]*m0[1][1]-m2[2][2]*m1[0][1]*m0[1][3]-m2[2][2]*m1[0][0]*m0[1][4]+m2[2][1]*m1[1][4]*m0[0][1]+m2[2][1]*m1[1][3]*m0[0][2]+m2[2][1]*m1[1][2]*m0[0][3]+m2[2][1]*m1[1][1]*m0[0][4]-m2[2][1]*m1[0][4]*m0[1][1]-m2[2][1]*m1[0][3]*m0[1][2]-m2[2][1]*m1[0][2]*m0[1][3]-m2[2][1]*m1[0][1]*m0[1][4]+m2[2][0]*m1[1][4]*m0[0][2]+m2[2][0]*m1[1][2]*m0[0][4]-m2[2][0]*m1[0][4]*m0[1][2]-m2[2][0]*m1[0][2]*m0[1][4]-m2[1][4]*m1[2][2]*m0[0][0]-m2[1][4]*m1[2][1]*m0[0][1]-m2[1][4]*m1[2][0]*m0[0][2]+m2[1][4]*m1[0][2]*m0[2][0]+m2[1][4]*m1[0][1]*m0[2][1]+m2[1][4]*m1[0][0]*m0[2][2]-m2[1][3]*m1[2][2]*m0[0][1]-m2[1][3]*m1[2][1]*m0[0][2]+m2[1][3]*m1[0][2]*m0[2][1]+m2[1][3]*m1[0][1]*m0[2][2]-m2[1][2]*m1[2][4]*m0[0][0]-m2[1][2]*m1[2][3]*m0[0][1]-m2[1][2]*m1[2][1]*m0[0][3]-m2[1][2]*m1[2][0]*m0[0][4]+m2[1][2]*m1[0][4]*m0[2][0]+m2[1][2]*m1[0][3]*m0[2][1]+m2[1][2]*m1[0][1]*m0[2][3]+m2[1][2]*m1[0][0]*m0[2][4]-m2[1][1]*m1[2][4]*m0[0][1]-m2[1][1]*m1[2][3]*m0[0][2]-m2[1][1]*m1[2][2]*m0[0][3]-m2[1][1]*m1[2][1]*m0[0][4]+m2[1][1]*m1[0][4]*m0[2][1]+m2[1][1]*m1[0][3]*m0[2][2]+m2[1][1]*m1[0][2]*m0[2][3]+m2[1][1]*m1[0][1]*m0[2][4]-m2[1][0]*m1[2][4]*m0[0][2]-m2[1][0]*m1[2][2]*m0[0][4]+m2[1][0]*m1[0][4]*m0[2][2]+m2[1][0]*m1[0][2]*m0[2][4]+m2[0][4]*m1[2][2]*m0[1][0]+m2[0][4]*m1[2][1]*m0[1][1]+m2[0][4]*m1[2][0]*m0[1][2]-m2[0][4]*m1[1][2]*m0[2][0]-m2[0][4]*m1[1][1]*m0[2][1]-m2[0][4]*m1[1][0]*m0[2][2]+m2[0][3]*m1[2][2]*m0[1][1]+m2[0][3]*m1[2][1]*m0[1][2]-m2[0][3]*m1[1][2]*m0[2][1]-m2[0][3]*m1[1][1]*m0[2][2]+m2[0][2]*m1[2][4]*m0[1][0]+m2[0][2]*m1[2][3]*m0[1][1]+m2[0][2]*m1[2][1]*m0[1][3]+m2[0][2]*m1[2][0]*m0[1][4]-m2[0][2]*m1[1][4]*m0[2][0]-m2[0][2]*m1[1][3]*m0[2][1]-m2[0][2]*m1[1][1]*m0[2][3]-m2[0][2]*m1[1][0]*m0[2][4]+m2[0][1]*m1[2][4]*m0[1][1]+m2[0][1]*m1[2][3]*m0[1][2]+m2[0][1]*m1[2][2]*m0[1][3]+m2[0][1]*m1[2][1]*m0[1][4]-m2[0][1]*m1[1][4]*m0[2][1]-m2[0][1]*m1[1][3]*m0[2][2]-m2[0][1]*m1[1][2]*m0[2][3]-m2[0][1]*m1[1][1]*m0[2][4]+m2[0][0]*m1[2][4]*m0[1][2]+m2[0][0]*m1[2][2]*m0[1][4]-m2[0][0]*m1[1][4]*m0[2][2]-m2[0][0]*m1[1][2]*m0[2][4]; 
  M1(row,11) = m2[2][4]*m1[1][2]*m0[0][1]+m2[2][4]*m1[1][1]*m0[0][2]-m2[2][4]*m1[0][2]*m0[1][1]-m2[2][4]*m1[0][1]*m0[1][2]+m2[2][3]*m1[1][2]*m0[0][2]-m2[2][3]*m1[0][2]*m0[1][2]+m2[2][2]*m1[1][4]*m0[0][1]+m2[2][2]*m1[1][3]*m0[0][2]+m2[2][2]*m1[1][2]*m0[0][3]+m2[2][2]*m1[1][1]*m0[0][4]-m2[2][2]*m1[0][4]*m0[1][1]-m2[2][2]*m1[0][3]*m0[1][2]-m2[2][2]*m1[0][2]*m0[1][3]-m2[2][2]*m1[0][1]*m0[1][4]+m2[2][1]*m1[1][4]*m0[0][2]+m2[2][1]*m1[1][2]*m0[0][4]-m2[2][1]*m1[0][4]*m0[1][2]-m2[2][1]*m1[0][2]*m0[1][4]-m2[1][4]*m1[2][2]*m0[0][1]-m2[1][4]*m1[2][1]*m0[0][2]+m2[1][4]*m1[0][2]*m0[2][1]+m2[1][4]*m1[0][1]*m0[2][2]-m2[1][3]*m1[2][2]*m0[0][2]+m2[1][3]*m1[0][2]*m0[2][2]-m2[1][2]*m1[2][4]*m0[0][1]-m2[1][2]*m1[2][3]*m0[0][2]-m2[1][2]*m1[2][2]*m0[0][3]-m2[1][2]*m1[2][1]*m0[0][4]+m2[1][2]*m1[0][4]*m0[2][1]+m2[1][2]*m1[0][3]*m0[2][2]+m2[1][2]*m1[0][2]*m0[2][3]+m2[1][2]*m1[0][1]*m0[2][4]-m2[1][1]*m1[2][4]*m0[0][2]-m2[1][1]*m1[2][2]*m0[0][4]+m2[1][1]*m1[0][4]*m0[2][2]+m2[1][1]*m1[0][2]*m0[2][4]+m2[0][4]*m1[2][2]*m0[1][1]+m2[0][4]*m1[2][1]*m0[1][2]-m2[0][4]*m1[1][2]*m0[2][1]-m2[0][4]*m1[1][1]*m0[2][2]+m2[0][3]*m1[2][2]*m0[1][2]-m2[0][3]*m1[1][2]*m0[2][2]+m2[0][2]*m1[2][4]*m0[1][1]+m2[0][2]*m1[2][3]*m0[1][2]+m2[0][2]*m1[2][2]*m0[1][3]+m2[0][2]*m1[2][1]*m0[1][4]-m2[0][2]*m1[1][4]*m0[2][1]-m2[0][2]*m1[1][3]*m0[2][2]-m2[0][2]*m1[1][2]*m0[2][3]-m2[0][2]*m1[1][1]*m0[2][4]+m2[0][1]*m1[2][4]*m0[1][2]+m2[0][1]*m1[2][2]*m0[1][4]-m2[0][1]*m1[1][4]*m0[2][2]-m2[0][1]*m1[1][2]*m0[2][4]; 
  M1(row,12) = m2[2][4]*m1[1][2]*m0[0][2]-m2[2][4]*m1[0][2]*m0[1][2]+m2[2][2]*m1[1][4]*m0[0][2]+m2[2][2]*m1[1][2]*m0[0][4]-m2[2][2]*m1[0][4]*m0[1][2]-m2[2][2]*m1[0][2]*m0[1][4]-m2[1][4]*m1[2][2]*m0[0][2]+m2[1][4]*m1[0][2]*m0[2][2]-m2[1][2]*m1[2][4]*m0[0][2]-m2[1][2]*m1[2][2]*m0[0][4]+m2[1][2]*m1[0][4]*m0[2][2]+m2[1][2]*m1[0][2]*m0[2][4]+m2[0][4]*m1[2][2]*m0[1][2]-m2[0][4]*m1[1][2]*m0[2][2]+m2[0][2]*m1[2][4]*m0[1][2]+m2[0][2]*m1[2][2]*m0[1][4]-m2[0][2]*m1[1][4]*m0[2][2]-m2[0][2]*m1[1][2]*m0[2][4]; 
  M1(row,13) = m2[2][5]*m1[1][0]*m0[0][0]-m2[2][5]*m1[0][0]*m0[1][0]+m2[2][3]*m1[1][3]*m0[0][0]+m2[2][3]*m1[1][0]*m0[0][3]-m2[2][3]*m1[0][3]*m0[1][0]-m2[2][3]*m1[0][0]*m0[1][3]+m2[2][0]*m1[1][5]*m0[0][0]+m2[2][0]*m1[1][3]*m0[0][3]+m2[2][0]*m1[1][0]*m0[0][5]-m2[2][0]*m1[0][5]*m0[1][0]-m2[2][0]*m1[0][3]*m0[1][3]-m2[2][0]*m1[0][0]*m0[1][5]-m2[1][5]*m1[2][0]*m0[0][0]+m2[1][5]*m1[0][0]*m0[2][0]-m2[1][3]*m1[2][3]*m0[0][0]-m2[1][3]*m1[2][0]*m0[0][3]+m2[1][3]*m1[0][3]*m0[2][0]+m2[1][3]*m1[0][0]*m0[2][3]-m2[1][0]*m1[2][5]*m0[0][0]-m2[1][0]*m1[2][3]*m0[0][3]-m2[1][0]*m1[2][0]*m0[0][5]+m2[1][0]*m1[0][5]*m0[2][0]+m2[1][0]*m1[0][3]*m0[2][3]+m2[1][0]*m1[0][0]*m0[2][5]+m2[0][5]*m1[2][0]*m0[1][0]-m2[0][5]*m1[1][0]*m0[2][0]+m2[0][3]*m1[2][3]*m0[1][0]+m2[0][3]*m1[2][0]*m0[1][3]-m2[0][3]*m1[1][3]*m0[2][0]-m2[0][3]*m1[1][0]*m0[2][3]+m2[0][0]*m1[2][5]*m0[1][0]+m2[0][0]*m1[2][3]*m0[1][3]+m2[0][0]*m1[2][0]*m0[1][5]-m2[0][0]*m1[1][5]*m0[2][0]-m2[0][0]*m1[1][3]*m0[2][3]-m2[0][0]*m1[1][0]*m0[2][5]; 
  M1(row,14) = m2[2][5]*m1[1][1]*m0[0][0]+m2[2][5]*m1[1][0]*m0[0][1]-m2[2][5]*m1[0][1]*m0[1][0]-m2[2][5]*m1[0][0]*m0[1][1]+m2[2][4]*m1[1][3]*m0[0][0]+m2[2][4]*m1[1][0]*m0[0][3]-m2[2][4]*m1[0][3]*m0[1][0]-m2[2][4]*m1[0][0]*m0[1][3]+m2[2][3]*m1[1][4]*m0[0][0]+m2[2][3]*m1[1][3]*m0[0][1]+m2[2][3]*m1[1][1]*m0[0][3]+m2[2][3]*m1[1][0]*m0[0][4]-m2[2][3]*m1[0][4]*m0[1][0]-m2[2][3]*m1[0][3]*m0[1][1]-m2[2][3]*m1[0][1]*m0[1][3]-m2[2][3]*m1[0][0]*m0[1][4]+m2[2][1]*m1[1][5]*m0[0][0]+m2[2][1]*m1[1][3]*m0[0][3]+m2[2][1]*m1[1][0]*m0[0][5]-m2[2][1]*m1[0][5]*m0[1][0]-m2[2][1]*m1[0][3]*m0[1][3]-m2[2][1]*m1[0][0]*m0[1][5]+m2[2][0]*m1[1][5]*m0[0][1]+m2[2][0]*m1[1][4]*m0[0][3]+m2[2][0]*m1[1][3]*m0[0][4]+m2[2][0]*m1[1][1]*m0[0][5]-m2[2][0]*m1[0][5]*m0[1][1]-m2[2][0]*m1[0][4]*m0[1][3]-m2[2][0]*m1[0][3]*m0[1][4]-m2[2][0]*m1[0][1]*m0[1][5]-m2[1][5]*m1[2][1]*m0[0][0]-m2[1][5]*m1[2][0]*m0[0][1]+m2[1][5]*m1[0][1]*m0[2][0]+m2[1][5]*m1[0][0]*m0[2][1]-m2[1][4]*m1[2][3]*m0[0][0]-m2[1][4]*m1[2][0]*m0[0][3]+m2[1][4]*m1[0][3]*m0[2][0]+m2[1][4]*m1[0][0]*m0[2][3]-m2[1][3]*m1[2][4]*m0[0][0]-m2[1][3]*m1[2][3]*m0[0][1]-m2[1][3]*m1[2][1]*m0[0][3]-m2[1][3]*m1[2][0]*m0[0][4]+m2[1][3]*m1[0][4]*m0[2][0]+m2[1][3]*m1[0][3]*m0[2][1]+m2[1][3]*m1[0][1]*m0[2][3]+m2[1][3]*m1[0][0]*m0[2][4]-m2[1][1]*m1[2][5]*m0[0][0]-m2[1][1]*m1[2][3]*m0[0][3]-m2[1][1]*m1[2][0]*m0[0][5]+m2[1][1]*m1[0][5]*m0[2][0]+m2[1][1]*m1[0][3]*m0[2][3]+m2[1][1]*m1[0][0]*m0[2][5]-m2[1][0]*m1[2][5]*m0[0][1]-m2[1][0]*m1[2][4]*m0[0][3]-m2[1][0]*m1[2][3]*m0[0][4]-m2[1][0]*m1[2][1]*m0[0][5]+m2[1][0]*m1[0][5]*m0[2][1]+m2[1][0]*m1[0][4]*m0[2][3]+m2[1][0]*m1[0][3]*m0[2][4]+m2[1][0]*m1[0][1]*m0[2][5]+m2[0][5]*m1[2][1]*m0[1][0]+m2[0][5]*m1[2][0]*m0[1][1]-m2[0][5]*m1[1][1]*m0[2][0]-m2[0][5]*m1[1][0]*m0[2][1]+m2[0][4]*m1[2][3]*m0[1][0]+m2[0][4]*m1[2][0]*m0[1][3]-m2[0][4]*m1[1][3]*m0[2][0]-m2[0][4]*m1[1][0]*m0[2][3]+m2[0][3]*m1[2][4]*m0[1][0]+m2[0][3]*m1[2][3]*m0[1][1]+m2[0][3]*m1[2][1]*m0[1][3]+m2[0][3]*m1[2][0]*m0[1][4]-m2[0][3]*m1[1][4]*m0[2][0]-m2[0][3]*m1[1][3]*m0[2][1]-m2[0][3]*m1[1][1]*m0[2][3]-m2[0][3]*m1[1][0]*m0[2][4]+m2[0][1]*m1[2][5]*m0[1][0]+m2[0][1]*m1[2][3]*m0[1][3]+m2[0][1]*m1[2][0]*m0[1][5]-m2[0][1]*m1[1][5]*m0[2][0]-m2[0][1]*m1[1][3]*m0[2][3]-m2[0][1]*m1[1][0]*m0[2][5]+m2[0][0]*m1[2][5]*m0[1][1]+m2[0][0]*m1[2][4]*m0[1][3]+m2[0][0]*m1[2][3]*m0[1][4]+m2[0][0]*m1[2][1]*m0[1][5]-m2[0][0]*m1[1][5]*m0[2][1]-m2[0][0]*m1[1][4]*m0[2][3]-m2[0][0]*m1[1][3]*m0[2][4]-m2[0][0]*m1[1][1]*m0[2][5]; 
  M1(row,15) = m2[2][5]*m1[1][2]*m0[0][0]+m2[2][5]*m1[1][1]*m0[0][1]+m2[2][5]*m1[1][0]*m0[0][2]-m2[2][5]*m1[0][2]*m0[1][0]-m2[2][5]*m1[0][1]*m0[1][1]-m2[2][5]*m1[0][0]*m0[1][2]+m2[2][4]*m1[1][4]*m0[0][0]+m2[2][4]*m1[1][3]*m0[0][1]+m2[2][4]*m1[1][1]*m0[0][3]+m2[2][4]*m1[1][0]*m0[0][4]-m2[2][4]*m1[0][4]*m0[1][0]-m2[2][4]*m1[0][3]*m0[1][1]-m2[2][4]*m1[0][1]*m0[1][3]-m2[2][4]*m1[0][0]*m0[1][4]+m2[2][3]*m1[1][4]*m0[0][1]+m2[2][3]*m1[1][3]*m0[0][2]+m2[2][3]*m1[1][2]*m0[0][3]+m2[2][3]*m1[1][1]*m0[0][4]-m2[2][3]*m1[0][4]*m0[1][1]-m2[2][3]*m1[0][3]*m0[1][2]-m2[2][3]*m1[0][2]*m0[1][3]-m2[2][3]*m1[0][1]*m0[1][4]+m2[2][2]*m1[1][5]*m0[0][0]+m2[2][2]*m1[1][3]*m0[0][3]+m2[2][2]*m1[1][0]*m0[0][5]-m2[2][2]*m1[0][5]*m0[1][0]-m2[2][2]*m1[0][3]*m0[1][3]-m2[2][2]*m1[0][0]*m0[1][5]+m2[2][1]*m1[1][5]*m0[0][1]+m2[2][1]*m1[1][4]*m0[0][3]+m2[2][1]*m1[1][3]*m0[0][4]+m2[2][1]*m1[1][1]*m0[0][5]-m2[2][1]*m1[0][5]*m0[1][1]-m2[2][1]*m1[0][4]*m0[1][3]-m2[2][1]*m1[0][3]*m0[1][4]-m2[2][1]*m1[0][1]*m0[1][5]+m2[2][0]*m1[1][5]*m0[0][2]+m2[2][0]*m1[1][4]*m0[0][4]+m2[2][0]*m1[1][2]*m0[0][5]-m2[2][0]*m1[0][5]*m0[1][2]-m2[2][0]*m1[0][4]*m0[1][4]-m2[2][0]*m1[0][2]*m0[1][5]-m2[1][5]*m1[2][2]*m0[0][0]-m2[1][5]*m1[2][1]*m0[0][1]-m2[1][5]*m1[2][0]*m0[0][2]+m2[1][5]*m1[0][2]*m0[2][0]+m2[1][5]*m1[0][1]*m0[2][1]+m2[1][5]*m1[0][0]*m0[2][2]-m2[1][4]*m1[2][4]*m0[0][0]-m2[1][4]*m1[2][3]*m0[0][1]-m2[1][4]*m1[2][1]*m0[0][3]-m2[1][4]*m1[2][0]*m0[0][4]+m2[1][4]*m1[0][4]*m0[2][0]+m2[1][4]*m1[0][3]*m0[2][1]+m2[1][4]*m1[0][1]*m0[2][3]+m2[1][4]*m1[0][0]*m0[2][4]-m2[1][3]*m1[2][4]*m0[0][1]-m2[1][3]*m1[2][3]*m0[0][2]-m2[1][3]*m1[2][2]*m0[0][3]-m2[1][3]*m1[2][1]*m0[0][4]+m2[1][3]*m1[0][4]*m0[2][1]+m2[1][3]*m1[0][3]*m0[2][2]+m2[1][3]*m1[0][2]*m0[2][3]+m2[1][3]*m1[0][1]*m0[2][4]-m2[1][2]*m1[2][5]*m0[0][0]-m2[1][2]*m1[2][3]*m0[0][3]-m2[1][2]*m1[2][0]*m0[0][5]+m2[1][2]*m1[0][5]*m0[2][0]+m2[1][2]*m1[0][3]*m0[2][3]+m2[1][2]*m1[0][0]*m0[2][5]-m2[1][1]*m1[2][5]*m0[0][1]-m2[1][1]*m1[2][4]*m0[0][3]-m2[1][1]*m1[2][3]*m0[0][4]-m2[1][1]*m1[2][1]*m0[0][5]+m2[1][1]*m1[0][5]*m0[2][1]+m2[1][1]*m1[0][4]*m0[2][3]+m2[1][1]*m1[0][3]*m0[2][4]+m2[1][1]*m1[0][1]*m0[2][5]-m2[1][0]*m1[2][5]*m0[0][2]-m2[1][0]*m1[2][4]*m0[0][4]-m2[1][0]*m1[2][2]*m0[0][5]+m2[1][0]*m1[0][5]*m0[2][2]+m2[1][0]*m1[0][4]*m0[2][4]+m2[1][0]*m1[0][2]*m0[2][5]+m2[0][5]*m1[2][2]*m0[1][0]+m2[0][5]*m1[2][1]*m0[1][1]+m2[0][5]*m1[2][0]*m0[1][2]-m2[0][5]*m1[1][2]*m0[2][0]-m2[0][5]*m1[1][1]*m0[2][1]-m2[0][5]*m1[1][0]*m0[2][2]+m2[0][4]*m1[2][4]*m0[1][0]+m2[0][4]*m1[2][3]*m0[1][1]+m2[0][4]*m1[2][1]*m0[1][3]+m2[0][4]*m1[2][0]*m0[1][4]-m2[0][4]*m1[1][4]*m0[2][0]-m2[0][4]*m1[1][3]*m0[2][1]-m2[0][4]*m1[1][1]*m0[2][3]-m2[0][4]*m1[1][0]*m0[2][4]+m2[0][3]*m1[2][4]*m0[1][1]+m2[0][3]*m1[2][3]*m0[1][2]+m2[0][3]*m1[2][2]*m0[1][3]+m2[0][3]*m1[2][1]*m0[1][4]-m2[0][3]*m1[1][4]*m0[2][1]-m2[0][3]*m1[1][3]*m0[2][2]-m2[0][3]*m1[1][2]*m0[2][3]-m2[0][3]*m1[1][1]*m0[2][4]+m2[0][2]*m1[2][5]*m0[1][0]+m2[0][2]*m1[2][3]*m0[1][3]+m2[0][2]*m1[2][0]*m0[1][5]-m2[0][2]*m1[1][5]*m0[2][0]-m2[0][2]*m1[1][3]*m0[2][3]-m2[0][2]*m1[1][0]*m0[2][5]+m2[0][1]*m1[2][5]*m0[1][1]+m2[0][1]*m1[2][4]*m0[1][3]+m2[0][1]*m1[2][3]*m0[1][4]+m2[0][1]*m1[2][1]*m0[1][5]-m2[0][1]*m1[1][5]*m0[2][1]-m2[0][1]*m1[1][4]*m0[2][3]-m2[0][1]*m1[1][3]*m0[2][4]-m2[0][1]*m1[1][1]*m0[2][5]+m2[0][0]*m1[2][5]*m0[1][2]+m2[0][0]*m1[2][4]*m0[1][4]+m2[0][0]*m1[2][2]*m0[1][5]-m2[0][0]*m1[1][5]*m0[2][2]-m2[0][0]*m1[1][4]*m0[2][4]-m2[0][0]*m1[1][2]*m0[2][5]; 
  M1(row,16) = m2[2][5]*m1[1][2]*m0[0][1]+m2[2][5]*m1[1][1]*m0[0][2]-m2[2][5]*m1[0][2]*m0[1][1]-m2[2][5]*m1[0][1]*m0[1][2]+m2[2][4]*m1[1][4]*m0[0][1]+m2[2][4]*m1[1][3]*m0[0][2]+m2[2][4]*m1[1][2]*m0[0][3]+m2[2][4]*m1[1][1]*m0[0][4]-m2[2][4]*m1[0][4]*m0[1][1]-m2[2][4]*m1[0][3]*m0[1][2]-m2[2][4]*m1[0][2]*m0[1][3]-m2[2][4]*m1[0][1]*m0[1][4]+m2[2][3]*m1[1][4]*m0[0][2]+m2[2][3]*m1[1][2]*m0[0][4]-m2[2][3]*m1[0][4]*m0[1][2]-m2[2][3]*m1[0][2]*m0[1][4]+m2[2][2]*m1[1][5]*m0[0][1]+m2[2][2]*m1[1][4]*m0[0][3]+m2[2][2]*m1[1][3]*m0[0][4]+m2[2][2]*m1[1][1]*m0[0][5]-m2[2][2]*m1[0][5]*m0[1][1]-m2[2][2]*m1[0][4]*m0[1][3]-m2[2][2]*m1[0][3]*m0[1][4]-m2[2][2]*m1[0][1]*m0[1][5]+m2[2][1]*m1[1][5]*m0[0][2]+m2[2][1]*m1[1][4]*m0[0][4]+m2[2][1]*m1[1][2]*m0[0][5]-m2[2][1]*m1[0][5]*m0[1][2]-m2[2][1]*m1[0][4]*m0[1][4]-m2[2][1]*m1[0][2]*m0[1][5]-m2[1][5]*m1[2][2]*m0[0][1]-m2[1][5]*m1[2][1]*m0[0][2]+m2[1][5]*m1[0][2]*m0[2][1]+m2[1][5]*m1[0][1]*m0[2][2]-m2[1][4]*m1[2][4]*m0[0][1]-m2[1][4]*m1[2][3]*m0[0][2]-m2[1][4]*m1[2][2]*m0[0][3]-m2[1][4]*m1[2][1]*m0[0][4]+m2[1][4]*m1[0][4]*m0[2][1]+m2[1][4]*m1[0][3]*m0[2][2]+m2[1][4]*m1[0][2]*m0[2][3]+m2[1][4]*m1[0][1]*m0[2][4]-m2[1][3]*m1[2][4]*m0[0][2]-m2[1][3]*m1[2][2]*m0[0][4]+m2[1][3]*m1[0][4]*m0[2][2]+m2[1][3]*m1[0][2]*m0[2][4]-m2[1][2]*m1[2][5]*m0[0][1]-m2[1][2]*m1[2][4]*m0[0][3]-m2[1][2]*m1[2][3]*m0[0][4]-m2[1][2]*m1[2][1]*m0[0][5]+m2[1][2]*m1[0][5]*m0[2][1]+m2[1][2]*m1[0][4]*m0[2][3]+m2[1][2]*m1[0][3]*m0[2][4]+m2[1][2]*m1[0][1]*m0[2][5]-m2[1][1]*m1[2][5]*m0[0][2]-m2[1][1]*m1[2][4]*m0[0][4]-m2[1][1]*m1[2][2]*m0[0][5]+m2[1][1]*m1[0][5]*m0[2][2]+m2[1][1]*m1[0][4]*m0[2][4]+m2[1][1]*m1[0][2]*m0[2][5]+m2[0][5]*m1[2][2]*m0[1][1]+m2[0][5]*m1[2][1]*m0[1][2]-m2[0][5]*m1[1][2]*m0[2][1]-m2[0][5]*m1[1][1]*m0[2][2]+m2[0][4]*m1[2][4]*m0[1][1]+m2[0][4]*m1[2][3]*m0[1][2]+m2[0][4]*m1[2][2]*m0[1][3]+m2[0][4]*m1[2][1]*m0[1][4]-m2[0][4]*m1[1][4]*m0[2][1]-m2[0][4]*m1[1][3]*m0[2][2]-m2[0][4]*m1[1][2]*m0[2][3]-m2[0][4]*m1[1][1]*m0[2][4]+m2[0][3]*m1[2][4]*m0[1][2]+m2[0][3]*m1[2][2]*m0[1][4]-m2[0][3]*m1[1][4]*m0[2][2]-m2[0][3]*m1[1][2]*m0[2][4]+m2[0][2]*m1[2][5]*m0[1][1]+m2[0][2]*m1[2][4]*m0[1][3]+m2[0][2]*m1[2][3]*m0[1][4]+m2[0][2]*m1[2][1]*m0[1][5]-m2[0][2]*m1[1][5]*m0[2][1]-m2[0][2]*m1[1][4]*m0[2][3]-m2[0][2]*m1[1][3]*m0[2][4]-m2[0][2]*m1[1][1]*m0[2][5]+m2[0][1]*m1[2][5]*m0[1][2]+m2[0][1]*m1[2][4]*m0[1][4]+m2[0][1]*m1[2][2]*m0[1][5]-m2[0][1]*m1[1][5]*m0[2][2]-m2[0][1]*m1[1][4]*m0[2][4]-m2[0][1]*m1[1][2]*m0[2][5]; 
  M1(row,17) = m2[2][5]*m1[1][2]*m0[0][2]-m2[2][5]*m1[0][2]*m0[1][2]+m2[2][4]*m1[1][4]*m0[0][2]+m2[2][4]*m1[1][2]*m0[0][4]-m2[2][4]*m1[0][4]*m0[1][2]-m2[2][4]*m1[0][2]*m0[1][4]+m2[2][2]*m1[1][5]*m0[0][2]+m2[2][2]*m1[1][4]*m0[0][4]+m2[2][2]*m1[1][2]*m0[0][5]-m2[2][2]*m1[0][5]*m0[1][2]-m2[2][2]*m1[0][4]*m0[1][4]-m2[2][2]*m1[0][2]*m0[1][5]-m2[1][5]*m1[2][2]*m0[0][2]+m2[1][5]*m1[0][2]*m0[2][2]-m2[1][4]*m1[2][4]*m0[0][2]-m2[1][4]*m1[2][2]*m0[0][4]+m2[1][4]*m1[0][4]*m0[2][2]+m2[1][4]*m1[0][2]*m0[2][4]-m2[1][2]*m1[2][5]*m0[0][2]-m2[1][2]*m1[2][4]*m0[0][4]-m2[1][2]*m1[2][2]*m0[0][5]+m2[1][2]*m1[0][5]*m0[2][2]+m2[1][2]*m1[0][4]*m0[2][4]+m2[1][2]*m1[0][2]*m0[2][5]+m2[0][5]*m1[2][2]*m0[1][2]-m2[0][5]*m1[1][2]*m0[2][2]+m2[0][4]*m1[2][4]*m0[1][2]+m2[0][4]*m1[2][2]*m0[1][4]-m2[0][4]*m1[1][4]*m0[2][2]-m2[0][4]*m1[1][2]*m0[2][4]+m2[0][2]*m1[2][5]*m0[1][2]+m2[0][2]*m1[2][4]*m0[1][4]+m2[0][2]*m1[2][2]*m0[1][5]-m2[0][2]*m1[1][5]*m0[2][2]-m2[0][2]*m1[1][4]*m0[2][4]-m2[0][2]*m1[1][2]*m0[2][5]; 
  M1(row,18) = m2[2][5]*m1[1][3]*m0[0][0]+m2[2][5]*m1[1][0]*m0[0][3]-m2[2][5]*m1[0][3]*m0[1][0]-m2[2][5]*m1[0][0]*m0[1][3]+m2[2][3]*m1[1][5]*m0[0][0]+m2[2][3]*m1[1][3]*m0[0][3]+m2[2][3]*m1[1][0]*m0[0][5]-m2[2][3]*m1[0][5]*m0[1][0]-m2[2][3]*m1[0][3]*m0[1][3]-m2[2][3]*m1[0][0]*m0[1][5]+m2[2][0]*m1[1][5]*m0[0][3]+m2[2][0]*m1[1][3]*m0[0][5]-m2[2][0]*m1[0][5]*m0[1][3]-m2[2][0]*m1[0][3]*m0[1][5]-m2[1][5]*m1[2][3]*m0[0][0]-m2[1][5]*m1[2][0]*m0[0][3]+m2[1][5]*m1[0][3]*m0[2][0]+m2[1][5]*m1[0][0]*m0[2][3]-m2[1][3]*m1[2][5]*m0[0][0]-m2[1][3]*m1[2][3]*m0[0][3]-m2[1][3]*m1[2][0]*m0[0][5]+m2[1][3]*m1[0][5]*m0[2][0]+m2[1][3]*m1[0][3]*m0[2][3]+m2[1][3]*m1[0][0]*m0[2][5]-m2[1][0]*m1[2][5]*m0[0][3]-m2[1][0]*m1[2][3]*m0[0][5]+m2[1][0]*m1[0][5]*m0[2][3]+m2[1][0]*m1[0][3]*m0[2][5]+m2[0][5]*m1[2][3]*m0[1][0]+m2[0][5]*m1[2][0]*m0[1][3]-m2[0][5]*m1[1][3]*m0[2][0]-m2[0][5]*m1[1][0]*m0[2][3]+m2[0][3]*m1[2][5]*m0[1][0]+m2[0][3]*m1[2][3]*m0[1][3]+m2[0][3]*m1[2][0]*m0[1][5]-m2[0][3]*m1[1][5]*m0[2][0]-m2[0][3]*m1[1][3]*m0[2][3]-m2[0][3]*m1[1][0]*m0[2][5]+m2[0][0]*m1[2][5]*m0[1][3]+m2[0][0]*m1[2][3]*m0[1][5]-m2[0][0]*m1[1][5]*m0[2][3]-m2[0][0]*m1[1][3]*m0[2][5]; 
  M1(row,19) = m2[2][5]*m1[1][4]*m0[0][0]+m2[2][5]*m1[1][3]*m0[0][1]+m2[2][5]*m1[1][1]*m0[0][3]+m2[2][5]*m1[1][0]*m0[0][4]-m2[2][5]*m1[0][4]*m0[1][0]-m2[2][5]*m1[0][3]*m0[1][1]-m2[2][5]*m1[0][1]*m0[1][3]-m2[2][5]*m1[0][0]*m0[1][4]+m2[2][4]*m1[1][5]*m0[0][0]+m2[2][4]*m1[1][3]*m0[0][3]+m2[2][4]*m1[1][0]*m0[0][5]-m2[2][4]*m1[0][5]*m0[1][0]-m2[2][4]*m1[0][3]*m0[1][3]-m2[2][4]*m1[0][0]*m0[1][5]+m2[2][3]*m1[1][5]*m0[0][1]+m2[2][3]*m1[1][4]*m0[0][3]+m2[2][3]*m1[1][3]*m0[0][4]+m2[2][3]*m1[1][1]*m0[0][5]-m2[2][3]*m1[0][5]*m0[1][1]-m2[2][3]*m1[0][4]*m0[1][3]-m2[2][3]*m1[0][3]*m0[1][4]-m2[2][3]*m1[0][1]*m0[1][5]+m2[2][1]*m1[1][5]*m0[0][3]+m2[2][1]*m1[1][3]*m0[0][5]-m2[2][1]*m1[0][5]*m0[1][3]-m2[2][1]*m1[0][3]*m0[1][5]+m2[2][0]*m1[1][5]*m0[0][4]+m2[2][0]*m1[1][4]*m0[0][5]-m2[2][0]*m1[0][5]*m0[1][4]-m2[2][0]*m1[0][4]*m0[1][5]-m2[1][5]*m1[2][4]*m0[0][0]-m2[1][5]*m1[2][3]*m0[0][1]-m2[1][5]*m1[2][1]*m0[0][3]-m2[1][5]*m1[2][0]*m0[0][4]+m2[1][5]*m1[0][4]*m0[2][0]+m2[1][5]*m1[0][3]*m0[2][1]+m2[1][5]*m1[0][1]*m0[2][3]+m2[1][5]*m1[0][0]*m0[2][4]-m2[1][4]*m1[2][5]*m0[0][0]-m2[1][4]*m1[2][3]*m0[0][3]-m2[1][4]*m1[2][0]*m0[0][5]+m2[1][4]*m1[0][5]*m0[2][0]+m2[1][4]*m1[0][3]*m0[2][3]+m2[1][4]*m1[0][0]*m0[2][5]-m2[1][3]*m1[2][5]*m0[0][1]-m2[1][3]*m1[2][4]*m0[0][3]-m2[1][3]*m1[2][3]*m0[0][4]-m2[1][3]*m1[2][1]*m0[0][5]+m2[1][3]*m1[0][5]*m0[2][1]+m2[1][3]*m1[0][4]*m0[2][3]+m2[1][3]*m1[0][3]*m0[2][4]+m2[1][3]*m1[0][1]*m0[2][5]-m2[1][1]*m1[2][5]*m0[0][3]-m2[1][1]*m1[2][3]*m0[0][5]+m2[1][1]*m1[0][5]*m0[2][3]+m2[1][1]*m1[0][3]*m0[2][5]-m2[1][0]*m1[2][5]*m0[0][4]-m2[1][0]*m1[2][4]*m0[0][5]+m2[1][0]*m1[0][5]*m0[2][4]+m2[1][0]*m1[0][4]*m0[2][5]+m2[0][5]*m1[2][4]*m0[1][0]+m2[0][5]*m1[2][3]*m0[1][1]+m2[0][5]*m1[2][1]*m0[1][3]+m2[0][5]*m1[2][0]*m0[1][4]-m2[0][5]*m1[1][4]*m0[2][0]-m2[0][5]*m1[1][3]*m0[2][1]-m2[0][5]*m1[1][1]*m0[2][3]-m2[0][5]*m1[1][0]*m0[2][4]+m2[0][4]*m1[2][5]*m0[1][0]+m2[0][4]*m1[2][3]*m0[1][3]+m2[0][4]*m1[2][0]*m0[1][5]-m2[0][4]*m1[1][5]*m0[2][0]-m2[0][4]*m1[1][3]*m0[2][3]-m2[0][4]*m1[1][0]*m0[2][5]+m2[0][3]*m1[2][5]*m0[1][1]+m2[0][3]*m1[2][4]*m0[1][3]+m2[0][3]*m1[2][3]*m0[1][4]+m2[0][3]*m1[2][1]*m0[1][5]-m2[0][3]*m1[1][5]*m0[2][1]-m2[0][3]*m1[1][4]*m0[2][3]-m2[0][3]*m1[1][3]*m0[2][4]-m2[0][3]*m1[1][1]*m0[2][5]+m2[0][1]*m1[2][5]*m0[1][3]+m2[0][1]*m1[2][3]*m0[1][5]-m2[0][1]*m1[1][5]*m0[2][3]-m2[0][1]*m1[1][3]*m0[2][5]+m2[0][0]*m1[2][5]*m0[1][4]+m2[0][0]*m1[2][4]*m0[1][5]-m2[0][0]*m1[1][5]*m0[2][4]-m2[0][0]*m1[1][4]*m0[2][5]; 
  M1(row,20) = m2[2][5]*m1[1][4]*m0[0][1]+m2[2][5]*m1[1][3]*m0[0][2]+m2[2][5]*m1[1][2]*m0[0][3]+m2[2][5]*m1[1][1]*m0[0][4]-m2[2][5]*m1[0][4]*m0[1][1]-m2[2][5]*m1[0][3]*m0[1][2]-m2[2][5]*m1[0][2]*m0[1][3]-m2[2][5]*m1[0][1]*m0[1][4]+m2[2][4]*m1[1][5]*m0[0][1]+m2[2][4]*m1[1][4]*m0[0][3]+m2[2][4]*m1[1][3]*m0[0][4]+m2[2][4]*m1[1][1]*m0[0][5]-m2[2][4]*m1[0][5]*m0[1][1]-m2[2][4]*m1[0][4]*m0[1][3]-m2[2][4]*m1[0][3]*m0[1][4]-m2[2][4]*m1[0][1]*m0[1][5]+m2[2][3]*m1[1][5]*m0[0][2]+m2[2][3]*m1[1][4]*m0[0][4]+m2[2][3]*m1[1][2]*m0[0][5]-m2[2][3]*m1[0][5]*m0[1][2]-m2[2][3]*m1[0][4]*m0[1][4]-m2[2][3]*m1[0][2]*m0[1][5]+m2[2][2]*m1[1][5]*m0[0][3]+m2[2][2]*m1[1][3]*m0[0][5]-m2[2][2]*m1[0][5]*m0[1][3]-m2[2][2]*m1[0][3]*m0[1][5]+m2[2][1]*m1[1][5]*m0[0][4]+m2[2][1]*m1[1][4]*m0[0][5]-m2[2][1]*m1[0][5]*m0[1][4]-m2[2][1]*m1[0][4]*m0[1][5]-m2[1][5]*m1[2][4]*m0[0][1]-m2[1][5]*m1[2][3]*m0[0][2]-m2[1][5]*m1[2][2]*m0[0][3]-m2[1][5]*m1[2][1]*m0[0][4]+m2[1][5]*m1[0][4]*m0[2][1]+m2[1][5]*m1[0][3]*m0[2][2]+m2[1][5]*m1[0][2]*m0[2][3]+m2[1][5]*m1[0][1]*m0[2][4]-m2[1][4]*m1[2][5]*m0[0][1]-m2[1][4]*m1[2][4]*m0[0][3]-m2[1][4]*m1[2][3]*m0[0][4]-m2[1][4]*m1[2][1]*m0[0][5]+m2[1][4]*m1[0][5]*m0[2][1]+m2[1][4]*m1[0][4]*m0[2][3]+m2[1][4]*m1[0][3]*m0[2][4]+m2[1][4]*m1[0][1]*m0[2][5]-m2[1][3]*m1[2][5]*m0[0][2]-m2[1][3]*m1[2][4]*m0[0][4]-m2[1][3]*m1[2][2]*m0[0][5]+m2[1][3]*m1[0][5]*m0[2][2]+m2[1][3]*m1[0][4]*m0[2][4]+m2[1][3]*m1[0][2]*m0[2][5]-m2[1][2]*m1[2][5]*m0[0][3]-m2[1][2]*m1[2][3]*m0[0][5]+m2[1][2]*m1[0][5]*m0[2][3]+m2[1][2]*m1[0][3]*m0[2][5]-m2[1][1]*m1[2][5]*m0[0][4]-m2[1][1]*m1[2][4]*m0[0][5]+m2[1][1]*m1[0][5]*m0[2][4]+m2[1][1]*m1[0][4]*m0[2][5]+m2[0][5]*m1[2][4]*m0[1][1]+m2[0][5]*m1[2][3]*m0[1][2]+m2[0][5]*m1[2][2]*m0[1][3]+m2[0][5]*m1[2][1]*m0[1][4]-m2[0][5]*m1[1][4]*m0[2][1]-m2[0][5]*m1[1][3]*m0[2][2]-m2[0][5]*m1[1][2]*m0[2][3]-m2[0][5]*m1[1][1]*m0[2][4]+m2[0][4]*m1[2][5]*m0[1][1]+m2[0][4]*m1[2][4]*m0[1][3]+m2[0][4]*m1[2][3]*m0[1][4]+m2[0][4]*m1[2][1]*m0[1][5]-m2[0][4]*m1[1][5]*m0[2][1]-m2[0][4]*m1[1][4]*m0[2][3]-m2[0][4]*m1[1][3]*m0[2][4]-m2[0][4]*m1[1][1]*m0[2][5]+m2[0][3]*m1[2][5]*m0[1][2]+m2[0][3]*m1[2][4]*m0[1][4]+m2[0][3]*m1[2][2]*m0[1][5]-m2[0][3]*m1[1][5]*m0[2][2]-m2[0][3]*m1[1][4]*m0[2][4]-m2[0][3]*m1[1][2]*m0[2][5]+m2[0][2]*m1[2][5]*m0[1][3]+m2[0][2]*m1[2][3]*m0[1][5]-m2[0][2]*m1[1][5]*m0[2][3]-m2[0][2]*m1[1][3]*m0[2][5]+m2[0][1]*m1[2][5]*m0[1][4]+m2[0][1]*m1[2][4]*m0[1][5]-m2[0][1]*m1[1][5]*m0[2][4]-m2[0][1]*m1[1][4]*m0[2][5]; 
  M1(row,21) = m2[2][5]*m1[1][4]*m0[0][2]+m2[2][5]*m1[1][2]*m0[0][4]-m2[2][5]*m1[0][4]*m0[1][2]-m2[2][5]*m1[0][2]*m0[1][4]+m2[2][4]*m1[1][5]*m0[0][2]+m2[2][4]*m1[1][4]*m0[0][4]+m2[2][4]*m1[1][2]*m0[0][5]-m2[2][4]*m1[0][5]*m0[1][2]-m2[2][4]*m1[0][4]*m0[1][4]-m2[2][4]*m1[0][2]*m0[1][5]+m2[2][2]*m1[1][5]*m0[0][4]+m2[2][2]*m1[1][4]*m0[0][5]-m2[2][2]*m1[0][5]*m0[1][4]-m2[2][2]*m1[0][4]*m0[1][5]-m2[1][5]*m1[2][4]*m0[0][2]-m2[1][5]*m1[2][2]*m0[0][4]+m2[1][5]*m1[0][4]*m0[2][2]+m2[1][5]*m1[0][2]*m0[2][4]-m2[1][4]*m1[2][5]*m0[0][2]-m2[1][4]*m1[2][4]*m0[0][4]-m2[1][4]*m1[2][2]*m0[0][5]+m2[1][4]*m1[0][5]*m0[2][2]+m2[1][4]*m1[0][4]*m0[2][4]+m2[1][4]*m1[0][2]*m0[2][5]-m2[1][2]*m1[2][5]*m0[0][4]-m2[1][2]*m1[2][4]*m0[0][5]+m2[1][2]*m1[0][5]*m0[2][4]+m2[1][2]*m1[0][4]*m0[2][5]+m2[0][5]*m1[2][4]*m0[1][2]+m2[0][5]*m1[2][2]*m0[1][4]-m2[0][5]*m1[1][4]*m0[2][2]-m2[0][5]*m1[1][2]*m0[2][4]+m2[0][4]*m1[2][5]*m0[1][2]+m2[0][4]*m1[2][4]*m0[1][4]+m2[0][4]*m1[2][2]*m0[1][5]-m2[0][4]*m1[1][5]*m0[2][2]-m2[0][4]*m1[1][4]*m0[2][4]-m2[0][4]*m1[1][2]*m0[2][5]+m2[0][2]*m1[2][5]*m0[1][4]+m2[0][2]*m1[2][4]*m0[1][5]-m2[0][2]*m1[1][5]*m0[2][4]-m2[0][2]*m1[1][4]*m0[2][5]; 
  M1(row,22) = m2[2][5]*m1[1][5]*m0[0][0]+m2[2][5]*m1[1][3]*m0[0][3]+m2[2][5]*m1[1][0]*m0[0][5]-m2[2][5]*m1[0][5]*m0[1][0]-m2[2][5]*m1[0][3]*m0[1][3]-m2[2][5]*m1[0][0]*m0[1][5]+m2[2][3]*m1[1][5]*m0[0][3]+m2[2][3]*m1[1][3]*m0[0][5]-m2[2][3]*m1[0][5]*m0[1][3]-m2[2][3]*m1[0][3]*m0[1][5]+m2[2][0]*m1[1][5]*m0[0][5]-m2[2][0]*m1[0][5]*m0[1][5]-m2[1][5]*m1[2][5]*m0[0][0]-m2[1][5]*m1[2][3]*m0[0][3]-m2[1][5]*m1[2][0]*m0[0][5]+m2[1][5]*m1[0][5]*m0[2][0]+m2[1][5]*m1[0][3]*m0[2][3]+m2[1][5]*m1[0][0]*m0[2][5]-m2[1][3]*m1[2][5]*m0[0][3]-m2[1][3]*m1[2][3]*m0[0][5]+m2[1][3]*m1[0][5]*m0[2][3]+m2[1][3]*m1[0][3]*m0[2][5]-m2[1][0]*m1[2][5]*m0[0][5]+m2[1][0]*m1[0][5]*m0[2][5]+m2[0][5]*m1[2][5]*m0[1][0]+m2[0][5]*m1[2][3]*m0[1][3]+m2[0][5]*m1[2][0]*m0[1][5]-m2[0][5]*m1[1][5]*m0[2][0]-m2[0][5]*m1[1][3]*m0[2][3]-m2[0][5]*m1[1][0]*m0[2][5]+m2[0][3]*m1[2][5]*m0[1][3]+m2[0][3]*m1[2][3]*m0[1][5]-m2[0][3]*m1[1][5]*m0[2][3]-m2[0][3]*m1[1][3]*m0[2][5]+m2[0][0]*m1[2][5]*m0[1][5]-m2[0][0]*m1[1][5]*m0[2][5]; 
  M1(row,23) = m2[2][5]*m1[1][5]*m0[0][1]+m2[2][5]*m1[1][4]*m0[0][3]+m2[2][5]*m1[1][3]*m0[0][4]+m2[2][5]*m1[1][1]*m0[0][5]-m2[2][5]*m1[0][5]*m0[1][1]-m2[2][5]*m1[0][4]*m0[1][3]-m2[2][5]*m1[0][3]*m0[1][4]-m2[2][5]*m1[0][1]*m0[1][5]+m2[2][4]*m1[1][5]*m0[0][3]+m2[2][4]*m1[1][3]*m0[0][5]-m2[2][4]*m1[0][5]*m0[1][3]-m2[2][4]*m1[0][3]*m0[1][5]+m2[2][3]*m1[1][5]*m0[0][4]+m2[2][3]*m1[1][4]*m0[0][5]-m2[2][3]*m1[0][5]*m0[1][4]-m2[2][3]*m1[0][4]*m0[1][5]+m2[2][1]*m1[1][5]*m0[0][5]-m2[2][1]*m1[0][5]*m0[1][5]-m2[1][5]*m1[2][5]*m0[0][1]-m2[1][5]*m1[2][4]*m0[0][3]-m2[1][5]*m1[2][3]*m0[0][4]-m2[1][5]*m1[2][1]*m0[0][5]+m2[1][5]*m1[0][5]*m0[2][1]+m2[1][5]*m1[0][4]*m0[2][3]+m2[1][5]*m1[0][3]*m0[2][4]+m2[1][5]*m1[0][1]*m0[2][5]-m2[1][4]*m1[2][5]*m0[0][3]-m2[1][4]*m1[2][3]*m0[0][5]+m2[1][4]*m1[0][5]*m0[2][3]+m2[1][4]*m1[0][3]*m0[2][5]-m2[1][3]*m1[2][5]*m0[0][4]-m2[1][3]*m1[2][4]*m0[0][5]+m2[1][3]*m1[0][5]*m0[2][4]+m2[1][3]*m1[0][4]*m0[2][5]-m2[1][1]*m1[2][5]*m0[0][5]+m2[1][1]*m1[0][5]*m0[2][5]+m2[0][5]*m1[2][5]*m0[1][1]+m2[0][5]*m1[2][4]*m0[1][3]+m2[0][5]*m1[2][3]*m0[1][4]+m2[0][5]*m1[2][1]*m0[1][5]-m2[0][5]*m1[1][5]*m0[2][1]-m2[0][5]*m1[1][4]*m0[2][3]-m2[0][5]*m1[1][3]*m0[2][4]-m2[0][5]*m1[1][1]*m0[2][5]+m2[0][4]*m1[2][5]*m0[1][3]+m2[0][4]*m1[2][3]*m0[1][5]-m2[0][4]*m1[1][5]*m0[2][3]-m2[0][4]*m1[1][3]*m0[2][5]+m2[0][3]*m1[2][5]*m0[1][4]+m2[0][3]*m1[2][4]*m0[1][5]-m2[0][3]*m1[1][5]*m0[2][4]-m2[0][3]*m1[1][4]*m0[2][5]+m2[0][1]*m1[2][5]*m0[1][5]-m2[0][1]*m1[1][5]*m0[2][5]; 
  M1(row,24) = m2[2][5]*m1[1][5]*m0[0][2]+m2[2][5]*m1[1][4]*m0[0][4]+m2[2][5]*m1[1][2]*m0[0][5]-m2[2][5]*m1[0][5]*m0[1][2]-m2[2][5]*m1[0][4]*m0[1][4]-m2[2][5]*m1[0][2]*m0[1][5]+m2[2][4]*m1[1][5]*m0[0][4]+m2[2][4]*m1[1][4]*m0[0][5]-m2[2][4]*m1[0][5]*m0[1][4]-m2[2][4]*m1[0][4]*m0[1][5]+m2[2][2]*m1[1][5]*m0[0][5]-m2[2][2]*m1[0][5]*m0[1][5]-m2[1][5]*m1[2][5]*m0[0][2]-m2[1][5]*m1[2][4]*m0[0][4]-m2[1][5]*m1[2][2]*m0[0][5]+m2[1][5]*m1[0][5]*m0[2][2]+m2[1][5]*m1[0][4]*m0[2][4]+m2[1][5]*m1[0][2]*m0[2][5]-m2[1][4]*m1[2][5]*m0[0][4]-m2[1][4]*m1[2][4]*m0[0][5]+m2[1][4]*m1[0][5]*m0[2][4]+m2[1][4]*m1[0][4]*m0[2][5]-m2[1][2]*m1[2][5]*m0[0][5]+m2[1][2]*m1[0][5]*m0[2][5]+m2[0][5]*m1[2][5]*m0[1][2]+m2[0][5]*m1[2][4]*m0[1][4]+m2[0][5]*m1[2][2]*m0[1][5]-m2[0][5]*m1[1][5]*m0[2][2]-m2[0][5]*m1[1][4]*m0[2][4]-m2[0][5]*m1[1][2]*m0[2][5]+m2[0][4]*m1[2][5]*m0[1][4]+m2[0][4]*m1[2][4]*m0[1][5]-m2[0][4]*m1[1][5]*m0[2][4]-m2[0][4]*m1[1][4]*m0[2][5]+m2[0][2]*m1[2][5]*m0[1][5]-m2[0][2]*m1[1][5]*m0[2][5]; 
  M1(row,25) = m2[2][5]*m1[1][5]*m0[0][3]+m2[2][5]*m1[1][3]*m0[0][5]-m2[2][5]*m1[0][5]*m0[1][3]-m2[2][5]*m1[0][3]*m0[1][5]+m2[2][3]*m1[1][5]*m0[0][5]-m2[2][3]*m1[0][5]*m0[1][5]-m2[1][5]*m1[2][5]*m0[0][3]-m2[1][5]*m1[2][3]*m0[0][5]+m2[1][5]*m1[0][5]*m0[2][3]+m2[1][5]*m1[0][3]*m0[2][5]-m2[1][3]*m1[2][5]*m0[0][5]+m2[1][3]*m1[0][5]*m0[2][5]+m2[0][5]*m1[2][5]*m0[1][3]+m2[0][5]*m1[2][3]*m0[1][5]-m2[0][5]*m1[1][5]*m0[2][3]-m2[0][5]*m1[1][3]*m0[2][5]+m2[0][3]*m1[2][5]*m0[1][5]-m2[0][3]*m1[1][5]*m0[2][5]; 
  M1(row,26) = m2[2][5]*m1[1][5]*m0[0][4]+m2[2][5]*m1[1][4]*m0[0][5]-m2[2][5]*m1[0][5]*m0[1][4]-m2[2][5]*m1[0][4]*m0[1][5]+m2[2][4]*m1[1][5]*m0[0][5]-m2[2][4]*m1[0][5]*m0[1][5]-m2[1][5]*m1[2][5]*m0[0][4]-m2[1][5]*m1[2][4]*m0[0][5]+m2[1][5]*m1[0][5]*m0[2][4]+m2[1][5]*m1[0][4]*m0[2][5]-m2[1][4]*m1[2][5]*m0[0][5]+m2[1][4]*m1[0][5]*m0[2][5]+m2[0][5]*m1[2][5]*m0[1][4]+m2[0][5]*m1[2][4]*m0[1][5]-m2[0][5]*m1[1][5]*m0[2][4]-m2[0][5]*m1[1][4]*m0[2][5]+m2[0][4]*m1[2][5]*m0[1][5]-m2[0][4]*m1[1][5]*m0[2][5]; 
  M1(row,27) = m2[2][5]*m1[1][5]*m0[0][5]-m2[2][5]*m1[0][5]*m0[1][5]-m2[1][5]*m1[2][5]*m0[0][5]+m2[1][5]*m1[0][5]*m0[2][5]+m2[0][5]*m1[2][5]*m0[1][5]-m2[0][5]*m1[1][5]*m0[2][5]; 
  M1(row,28) = m2[2][6]*m1[1][0]*m0[0][0]-m2[2][6]*m1[0][0]*m0[1][0]+m2[2][0]*m1[1][6]*m0[0][0]+m2[2][0]*m1[1][0]*m0[0][6]-m2[2][0]*m1[0][6]*m0[1][0]-m2[2][0]*m1[0][0]*m0[1][6]-m2[1][6]*m1[2][0]*m0[0][0]+m2[1][6]*m1[0][0]*m0[2][0]-m2[1][0]*m1[2][6]*m0[0][0]-m2[1][0]*m1[2][0]*m0[0][6]+m2[1][0]*m1[0][6]*m0[2][0]+m2[1][0]*m1[0][0]*m0[2][6]+m2[0][6]*m1[2][0]*m0[1][0]-m2[0][6]*m1[1][0]*m0[2][0]+m2[0][0]*m1[2][6]*m0[1][0]+m2[0][0]*m1[2][0]*m0[1][6]-m2[0][0]*m1[1][6]*m0[2][0]-m2[0][0]*m1[1][0]*m0[2][6]; 
  M1(row,29) = m2[2][7]*m1[1][0]*m0[0][0]-m2[2][7]*m1[0][0]*m0[1][0]+m2[2][6]*m1[1][1]*m0[0][0]+m2[2][6]*m1[1][0]*m0[0][1]-m2[2][6]*m1[0][1]*m0[1][0]-m2[2][6]*m1[0][0]*m0[1][1]+m2[2][1]*m1[1][6]*m0[0][0]+m2[2][1]*m1[1][0]*m0[0][6]-m2[2][1]*m1[0][6]*m0[1][0]-m2[2][1]*m1[0][0]*m0[1][6]+m2[2][0]*m1[1][7]*m0[0][0]+m2[2][0]*m1[1][6]*m0[0][1]+m2[2][0]*m1[1][1]*m0[0][6]+m2[2][0]*m1[1][0]*m0[0][7]-m2[2][0]*m1[0][7]*m0[1][0]-m2[2][0]*m1[0][6]*m0[1][1]-m2[2][0]*m1[0][1]*m0[1][6]-m2[2][0]*m1[0][0]*m0[1][7]-m2[1][7]*m1[2][0]*m0[0][0]+m2[1][7]*m1[0][0]*m0[2][0]-m2[1][6]*m1[2][1]*m0[0][0]-m2[1][6]*m1[2][0]*m0[0][1]+m2[1][6]*m1[0][1]*m0[2][0]+m2[1][6]*m1[0][0]*m0[2][1]-m2[1][1]*m1[2][6]*m0[0][0]-m2[1][1]*m1[2][0]*m0[0][6]+m2[1][1]*m1[0][6]*m0[2][0]+m2[1][1]*m1[0][0]*m0[2][6]-m2[1][0]*m1[2][7]*m0[0][0]-m2[1][0]*m1[2][6]*m0[0][1]-m2[1][0]*m1[2][1]*m0[0][6]-m2[1][0]*m1[2][0]*m0[0][7]+m2[1][0]*m1[0][7]*m0[2][0]+m2[1][0]*m1[0][6]*m0[2][1]+m2[1][0]*m1[0][1]*m0[2][6]+m2[1][0]*m1[0][0]*m0[2][7]+m2[0][7]*m1[2][0]*m0[1][0]-m2[0][7]*m1[1][0]*m0[2][0]+m2[0][6]*m1[2][1]*m0[1][0]+m2[0][6]*m1[2][0]*m0[1][1]-m2[0][6]*m1[1][1]*m0[2][0]-m2[0][6]*m1[1][0]*m0[2][1]+m2[0][1]*m1[2][6]*m0[1][0]+m2[0][1]*m1[2][0]*m0[1][6]-m2[0][1]*m1[1][6]*m0[2][0]-m2[0][1]*m1[1][0]*m0[2][6]+m2[0][0]*m1[2][7]*m0[1][0]+m2[0][0]*m1[2][6]*m0[1][1]+m2[0][0]*m1[2][1]*m0[1][6]+m2[0][0]*m1[2][0]*m0[1][7]-m2[0][0]*m1[1][7]*m0[2][0]-m2[0][0]*m1[1][6]*m0[2][1]-m2[0][0]*m1[1][1]*m0[2][6]-m2[0][0]*m1[1][0]*m0[2][7]; 
  M1(row,30) = m2[2][7]*m1[1][1]*m0[0][0]+m2[2][7]*m1[1][0]*m0[0][1]-m2[2][7]*m1[0][1]*m0[1][0]-m2[2][7]*m1[0][0]*m0[1][1]+m2[2][6]*m1[1][2]*m0[0][0]+m2[2][6]*m1[1][1]*m0[0][1]+m2[2][6]*m1[1][0]*m0[0][2]-m2[2][6]*m1[0][2]*m0[1][0]-m2[2][6]*m1[0][1]*m0[1][1]-m2[2][6]*m1[0][0]*m0[1][2]+m2[2][2]*m1[1][6]*m0[0][0]+m2[2][2]*m1[1][0]*m0[0][6]-m2[2][2]*m1[0][6]*m0[1][0]-m2[2][2]*m1[0][0]*m0[1][6]+m2[2][1]*m1[1][7]*m0[0][0]+m2[2][1]*m1[1][6]*m0[0][1]+m2[2][1]*m1[1][1]*m0[0][6]+m2[2][1]*m1[1][0]*m0[0][7]-m2[2][1]*m1[0][7]*m0[1][0]-m2[2][1]*m1[0][6]*m0[1][1]-m2[2][1]*m1[0][1]*m0[1][6]-m2[2][1]*m1[0][0]*m0[1][7]+m2[2][0]*m1[1][7]*m0[0][1]+m2[2][0]*m1[1][6]*m0[0][2]+m2[2][0]*m1[1][2]*m0[0][6]+m2[2][0]*m1[1][1]*m0[0][7]-m2[2][0]*m1[0][7]*m0[1][1]-m2[2][0]*m1[0][6]*m0[1][2]-m2[2][0]*m1[0][2]*m0[1][6]-m2[2][0]*m1[0][1]*m0[1][7]-m2[1][7]*m1[2][1]*m0[0][0]-m2[1][7]*m1[2][0]*m0[0][1]+m2[1][7]*m1[0][1]*m0[2][0]+m2[1][7]*m1[0][0]*m0[2][1]-m2[1][6]*m1[2][2]*m0[0][0]-m2[1][6]*m1[2][1]*m0[0][1]-m2[1][6]*m1[2][0]*m0[0][2]+m2[1][6]*m1[0][2]*m0[2][0]+m2[1][6]*m1[0][1]*m0[2][1]+m2[1][6]*m1[0][0]*m0[2][2]-m2[1][2]*m1[2][6]*m0[0][0]-m2[1][2]*m1[2][0]*m0[0][6]+m2[1][2]*m1[0][6]*m0[2][0]+m2[1][2]*m1[0][0]*m0[2][6]-m2[1][1]*m1[2][7]*m0[0][0]-m2[1][1]*m1[2][6]*m0[0][1]-m2[1][1]*m1[2][1]*m0[0][6]-m2[1][1]*m1[2][0]*m0[0][7]+m2[1][1]*m1[0][7]*m0[2][0]+m2[1][1]*m1[0][6]*m0[2][1]+m2[1][1]*m1[0][1]*m0[2][6]+m2[1][1]*m1[0][0]*m0[2][7]-m2[1][0]*m1[2][7]*m0[0][1]-m2[1][0]*m1[2][6]*m0[0][2]-m2[1][0]*m1[2][2]*m0[0][6]-m2[1][0]*m1[2][1]*m0[0][7]+m2[1][0]*m1[0][7]*m0[2][1]+m2[1][0]*m1[0][6]*m0[2][2]+m2[1][0]*m1[0][2]*m0[2][6]+m2[1][0]*m1[0][1]*m0[2][7]+m2[0][7]*m1[2][1]*m0[1][0]+m2[0][7]*m1[2][0]*m0[1][1]-m2[0][7]*m1[1][1]*m0[2][0]-m2[0][7]*m1[1][0]*m0[2][1]+m2[0][6]*m1[2][2]*m0[1][0]+m2[0][6]*m1[2][1]*m0[1][1]+m2[0][6]*m1[2][0]*m0[1][2]-m2[0][6]*m1[1][2]*m0[2][0]-m2[0][6]*m1[1][1]*m0[2][1]-m2[0][6]*m1[1][0]*m0[2][2]+m2[0][2]*m1[2][6]*m0[1][0]+m2[0][2]*m1[2][0]*m0[1][6]-m2[0][2]*m1[1][6]*m0[2][0]-m2[0][2]*m1[1][0]*m0[2][6]+m2[0][1]*m1[2][7]*m0[1][0]+m2[0][1]*m1[2][6]*m0[1][1]+m2[0][1]*m1[2][1]*m0[1][6]+m2[0][1]*m1[2][0]*m0[1][7]-m2[0][1]*m1[1][7]*m0[2][0]-m2[0][1]*m1[1][6]*m0[2][1]-m2[0][1]*m1[1][1]*m0[2][6]-m2[0][1]*m1[1][0]*m0[2][7]+m2[0][0]*m1[2][7]*m0[1][1]+m2[0][0]*m1[2][6]*m0[1][2]+m2[0][0]*m1[2][2]*m0[1][6]+m2[0][0]*m1[2][1]*m0[1][7]-m2[0][0]*m1[1][7]*m0[2][1]-m2[0][0]*m1[1][6]*m0[2][2]-m2[0][0]*m1[1][2]*m0[2][6]-m2[0][0]*m1[1][1]*m0[2][7]; 
  M1(row,31) = m2[2][7]*m1[1][2]*m0[0][0]+m2[2][7]*m1[1][1]*m0[0][1]+m2[2][7]*m1[1][0]*m0[0][2]-m2[2][7]*m1[0][2]*m0[1][0]-m2[2][7]*m1[0][1]*m0[1][1]-m2[2][7]*m1[0][0]*m0[1][2]+m2[2][6]*m1[1][2]*m0[0][1]+m2[2][6]*m1[1][1]*m0[0][2]-m2[2][6]*m1[0][2]*m0[1][1]-m2[2][6]*m1[0][1]*m0[1][2]+m2[2][2]*m1[1][7]*m0[0][0]+m2[2][2]*m1[1][6]*m0[0][1]+m2[2][2]*m1[1][1]*m0[0][6]+m2[2][2]*m1[1][0]*m0[0][7]-m2[2][2]*m1[0][7]*m0[1][0]-m2[2][2]*m1[0][6]*m0[1][1]-m2[2][2]*m1[0][1]*m0[1][6]-m2[2][2]*m1[0][0]*m0[1][7]+m2[2][1]*m1[1][7]*m0[0][1]+m2[2][1]*m1[1][6]*m0[0][2]+m2[2][1]*m1[1][2]*m0[0][6]+m2[2][1]*m1[1][1]*m0[0][7]-m2[2][1]*m1[0][7]*m0[1][1]-m2[2][1]*m1[0][6]*m0[1][2]-m2[2][1]*m1[0][2]*m0[1][6]-m2[2][1]*m1[0][1]*m0[1][7]+m2[2][0]*m1[1][7]*m0[0][2]+m2[2][0]*m1[1][2]*m0[0][7]-m2[2][0]*m1[0][7]*m0[1][2]-m2[2][0]*m1[0][2]*m0[1][7]-m2[1][7]*m1[2][2]*m0[0][0]-m2[1][7]*m1[2][1]*m0[0][1]-m2[1][7]*m1[2][0]*m0[0][2]+m2[1][7]*m1[0][2]*m0[2][0]+m2[1][7]*m1[0][1]*m0[2][1]+m2[1][7]*m1[0][0]*m0[2][2]-m2[1][6]*m1[2][2]*m0[0][1]-m2[1][6]*m1[2][1]*m0[0][2]+m2[1][6]*m1[0][2]*m0[2][1]+m2[1][6]*m1[0][1]*m0[2][2]-m2[1][2]*m1[2][7]*m0[0][0]-m2[1][2]*m1[2][6]*m0[0][1]-m2[1][2]*m1[2][1]*m0[0][6]-m2[1][2]*m1[2][0]*m0[0][7]+m2[1][2]*m1[0][7]*m0[2][0]+m2[1][2]*m1[0][6]*m0[2][1]+m2[1][2]*m1[0][1]*m0[2][6]+m2[1][2]*m1[0][0]*m0[2][7]-m2[1][1]*m1[2][7]*m0[0][1]-m2[1][1]*m1[2][6]*m0[0][2]-m2[1][1]*m1[2][2]*m0[0][6]-m2[1][1]*m1[2][1]*m0[0][7]+m2[1][1]*m1[0][7]*m0[2][1]+m2[1][1]*m1[0][6]*m0[2][2]+m2[1][1]*m1[0][2]*m0[2][6]+m2[1][1]*m1[0][1]*m0[2][7]-m2[1][0]*m1[2][7]*m0[0][2]-m2[1][0]*m1[2][2]*m0[0][7]+m2[1][0]*m1[0][7]*m0[2][2]+m2[1][0]*m1[0][2]*m0[2][7]+m2[0][7]*m1[2][2]*m0[1][0]+m2[0][7]*m1[2][1]*m0[1][1]+m2[0][7]*m1[2][0]*m0[1][2]-m2[0][7]*m1[1][2]*m0[2][0]-m2[0][7]*m1[1][1]*m0[2][1]-m2[0][7]*m1[1][0]*m0[2][2]+m2[0][6]*m1[2][2]*m0[1][1]+m2[0][6]*m1[2][1]*m0[1][2]-m2[0][6]*m1[1][2]*m0[2][1]-m2[0][6]*m1[1][1]*m0[2][2]+m2[0][2]*m1[2][7]*m0[1][0]+m2[0][2]*m1[2][6]*m0[1][1]+m2[0][2]*m1[2][1]*m0[1][6]+m2[0][2]*m1[2][0]*m0[1][7]-m2[0][2]*m1[1][7]*m0[2][0]-m2[0][2]*m1[1][6]*m0[2][1]-m2[0][2]*m1[1][1]*m0[2][6]-m2[0][2]*m1[1][0]*m0[2][7]+m2[0][1]*m1[2][7]*m0[1][1]+m2[0][1]*m1[2][6]*m0[1][2]+m2[0][1]*m1[2][2]*m0[1][6]+m2[0][1]*m1[2][1]*m0[1][7]-m2[0][1]*m1[1][7]*m0[2][1]-m2[0][1]*m1[1][6]*m0[2][2]-m2[0][1]*m1[1][2]*m0[2][6]-m2[0][1]*m1[1][1]*m0[2][7]+m2[0][0]*m1[2][7]*m0[1][2]+m2[0][0]*m1[2][2]*m0[1][7]-m2[0][0]*m1[1][7]*m0[2][2]-m2[0][0]*m1[1][2]*m0[2][7]; 
  M1(row,32) = m2[2][7]*m1[1][2]*m0[0][1]+m2[2][7]*m1[1][1]*m0[0][2]-m2[2][7]*m1[0][2]*m0[1][1]-m2[2][7]*m1[0][1]*m0[1][2]+m2[2][6]*m1[1][2]*m0[0][2]-m2[2][6]*m1[0][2]*m0[1][2]+m2[2][2]*m1[1][7]*m0[0][1]+m2[2][2]*m1[1][6]*m0[0][2]+m2[2][2]*m1[1][2]*m0[0][6]+m2[2][2]*m1[1][1]*m0[0][7]-m2[2][2]*m1[0][7]*m0[1][1]-m2[2][2]*m1[0][6]*m0[1][2]-m2[2][2]*m1[0][2]*m0[1][6]-m2[2][2]*m1[0][1]*m0[1][7]+m2[2][1]*m1[1][7]*m0[0][2]+m2[2][1]*m1[1][2]*m0[0][7]-m2[2][1]*m1[0][7]*m0[1][2]-m2[2][1]*m1[0][2]*m0[1][7]-m2[1][7]*m1[2][2]*m0[0][1]-m2[1][7]*m1[2][1]*m0[0][2]+m2[1][7]*m1[0][2]*m0[2][1]+m2[1][7]*m1[0][1]*m0[2][2]-m2[1][6]*m1[2][2]*m0[0][2]+m2[1][6]*m1[0][2]*m0[2][2]-m2[1][2]*m1[2][7]*m0[0][1]-m2[1][2]*m1[2][6]*m0[0][2]-m2[1][2]*m1[2][2]*m0[0][6]-m2[1][2]*m1[2][1]*m0[0][7]+m2[1][2]*m1[0][7]*m0[2][1]+m2[1][2]*m1[0][6]*m0[2][2]+m2[1][2]*m1[0][2]*m0[2][6]+m2[1][2]*m1[0][1]*m0[2][7]-m2[1][1]*m1[2][7]*m0[0][2]-m2[1][1]*m1[2][2]*m0[0][7]+m2[1][1]*m1[0][7]*m0[2][2]+m2[1][1]*m1[0][2]*m0[2][7]+m2[0][7]*m1[2][2]*m0[1][1]+m2[0][7]*m1[2][1]*m0[1][2]-m2[0][7]*m1[1][2]*m0[2][1]-m2[0][7]*m1[1][1]*m0[2][2]+m2[0][6]*m1[2][2]*m0[1][2]-m2[0][6]*m1[1][2]*m0[2][2]+m2[0][2]*m1[2][7]*m0[1][1]+m2[0][2]*m1[2][6]*m0[1][2]+m2[0][2]*m1[2][2]*m0[1][6]+m2[0][2]*m1[2][1]*m0[1][7]-m2[0][2]*m1[1][7]*m0[2][1]-m2[0][2]*m1[1][6]*m0[2][2]-m2[0][2]*m1[1][2]*m0[2][6]-m2[0][2]*m1[1][1]*m0[2][7]+m2[0][1]*m1[2][7]*m0[1][2]+m2[0][1]*m1[2][2]*m0[1][7]-m2[0][1]*m1[1][7]*m0[2][2]-m2[0][1]*m1[1][2]*m0[2][7]; 
  M1(row,33) = m2[2][7]*m1[1][2]*m0[0][2]-m2[2][7]*m1[0][2]*m0[1][2]+m2[2][2]*m1[1][7]*m0[0][2]+m2[2][2]*m1[1][2]*m0[0][7]-m2[2][2]*m1[0][7]*m0[1][2]-m2[2][2]*m1[0][2]*m0[1][7]-m2[1][7]*m1[2][2]*m0[0][2]+m2[1][7]*m1[0][2]*m0[2][2]-m2[1][2]*m1[2][7]*m0[0][2]-m2[1][2]*m1[2][2]*m0[0][7]+m2[1][2]*m1[0][7]*m0[2][2]+m2[1][2]*m1[0][2]*m0[2][7]+m2[0][7]*m1[2][2]*m0[1][2]-m2[0][7]*m1[1][2]*m0[2][2]+m2[0][2]*m1[2][7]*m0[1][2]+m2[0][2]*m1[2][2]*m0[1][7]-m2[0][2]*m1[1][7]*m0[2][2]-m2[0][2]*m1[1][2]*m0[2][7]; 
  M1(row,34) = m2[2][8]*m1[1][0]*m0[0][0]-m2[2][8]*m1[0][0]*m0[1][0]+m2[2][6]*m1[1][3]*m0[0][0]+m2[2][6]*m1[1][0]*m0[0][3]-m2[2][6]*m1[0][3]*m0[1][0]-m2[2][6]*m1[0][0]*m0[1][3]+m2[2][3]*m1[1][6]*m0[0][0]+m2[2][3]*m1[1][0]*m0[0][6]-m2[2][3]*m1[0][6]*m0[1][0]-m2[2][3]*m1[0][0]*m0[1][6]+m2[2][0]*m1[1][8]*m0[0][0]+m2[2][0]*m1[1][6]*m0[0][3]+m2[2][0]*m1[1][3]*m0[0][6]+m2[2][0]*m1[1][0]*m0[0][8]-m2[2][0]*m1[0][8]*m0[1][0]-m2[2][0]*m1[0][6]*m0[1][3]-m2[2][0]*m1[0][3]*m0[1][6]-m2[2][0]*m1[0][0]*m0[1][8]-m2[1][8]*m1[2][0]*m0[0][0]+m2[1][8]*m1[0][0]*m0[2][0]-m2[1][6]*m1[2][3]*m0[0][0]-m2[1][6]*m1[2][0]*m0[0][3]+m2[1][6]*m1[0][3]*m0[2][0]+m2[1][6]*m1[0][0]*m0[2][3]-m2[1][3]*m1[2][6]*m0[0][0]-m2[1][3]*m1[2][0]*m0[0][6]+m2[1][3]*m1[0][6]*m0[2][0]+m2[1][3]*m1[0][0]*m0[2][6]-m2[1][0]*m1[2][8]*m0[0][0]-m2[1][0]*m1[2][6]*m0[0][3]-m2[1][0]*m1[2][3]*m0[0][6]-m2[1][0]*m1[2][0]*m0[0][8]+m2[1][0]*m1[0][8]*m0[2][0]+m2[1][0]*m1[0][6]*m0[2][3]+m2[1][0]*m1[0][3]*m0[2][6]+m2[1][0]*m1[0][0]*m0[2][8]+m2[0][8]*m1[2][0]*m0[1][0]-m2[0][8]*m1[1][0]*m0[2][0]+m2[0][6]*m1[2][3]*m0[1][0]+m2[0][6]*m1[2][0]*m0[1][3]-m2[0][6]*m1[1][3]*m0[2][0]-m2[0][6]*m1[1][0]*m0[2][3]+m2[0][3]*m1[2][6]*m0[1][0]+m2[0][3]*m1[2][0]*m0[1][6]-m2[0][3]*m1[1][6]*m0[2][0]-m2[0][3]*m1[1][0]*m0[2][6]+m2[0][0]*m1[2][8]*m0[1][0]+m2[0][0]*m1[2][6]*m0[1][3]+m2[0][0]*m1[2][3]*m0[1][6]+m2[0][0]*m1[2][0]*m0[1][8]-m2[0][0]*m1[1][8]*m0[2][0]-m2[0][0]*m1[1][6]*m0[2][3]-m2[0][0]*m1[1][3]*m0[2][6]-m2[0][0]*m1[1][0]*m0[2][8]; 
  M1(row,35) = m2[2][8]*m1[1][1]*m0[0][0]+m2[2][8]*m1[1][0]*m0[0][1]-m2[2][8]*m1[0][1]*m0[1][0]-m2[2][8]*m1[0][0]*m0[1][1]+m2[2][7]*m1[1][3]*m0[0][0]+m2[2][7]*m1[1][0]*m0[0][3]-m2[2][7]*m1[0][3]*m0[1][0]-m2[2][7]*m1[0][0]*m0[1][3]+m2[2][6]*m1[1][4]*m0[0][0]+m2[2][6]*m1[1][3]*m0[0][1]+m2[2][6]*m1[1][1]*m0[0][3]+m2[2][6]*m1[1][0]*m0[0][4]-m2[2][6]*m1[0][4]*m0[1][0]-m2[2][6]*m1[0][3]*m0[1][1]-m2[2][6]*m1[0][1]*m0[1][3]-m2[2][6]*m1[0][0]*m0[1][4]+m2[2][4]*m1[1][6]*m0[0][0]+m2[2][4]*m1[1][0]*m0[0][6]-m2[2][4]*m1[0][6]*m0[1][0]-m2[2][4]*m1[0][0]*m0[1][6]+m2[2][3]*m1[1][7]*m0[0][0]+m2[2][3]*m1[1][6]*m0[0][1]+m2[2][3]*m1[1][1]*m0[0][6]+m2[2][3]*m1[1][0]*m0[0][7]-m2[2][3]*m1[0][7]*m0[1][0]-m2[2][3]*m1[0][6]*m0[1][1]-m2[2][3]*m1[0][1]*m0[1][6]-m2[2][3]*m1[0][0]*m0[1][7]+m2[2][1]*m1[1][8]*m0[0][0]+m2[2][1]*m1[1][6]*m0[0][3]+m2[2][1]*m1[1][3]*m0[0][6]+m2[2][1]*m1[1][0]*m0[0][8]-m2[2][1]*m1[0][8]*m0[1][0]-m2[2][1]*m1[0][6]*m0[1][3]-m2[2][1]*m1[0][3]*m0[1][6]-m2[2][1]*m1[0][0]*m0[1][8]+m2[2][0]*m1[1][8]*m0[0][1]+m2[2][0]*m1[1][7]*m0[0][3]+m2[2][0]*m1[1][6]*m0[0][4]+m2[2][0]*m1[1][4]*m0[0][6]+m2[2][0]*m1[1][3]*m0[0][7]+m2[2][0]*m1[1][1]*m0[0][8]-m2[2][0]*m1[0][8]*m0[1][1]-m2[2][0]*m1[0][7]*m0[1][3]-m2[2][0]*m1[0][6]*m0[1][4]-m2[2][0]*m1[0][4]*m0[1][6]-m2[2][0]*m1[0][3]*m0[1][7]-m2[2][0]*m1[0][1]*m0[1][8]-m2[1][8]*m1[2][1]*m0[0][0]-m2[1][8]*m1[2][0]*m0[0][1]+m2[1][8]*m1[0][1]*m0[2][0]+m2[1][8]*m1[0][0]*m0[2][1]-m2[1][7]*m1[2][3]*m0[0][0]-m2[1][7]*m1[2][0]*m0[0][3]+m2[1][7]*m1[0][3]*m0[2][0]+m2[1][7]*m1[0][0]*m0[2][3]-m2[1][6]*m1[2][4]*m0[0][0]-m2[1][6]*m1[2][3]*m0[0][1]-m2[1][6]*m1[2][1]*m0[0][3]-m2[1][6]*m1[2][0]*m0[0][4]+m2[1][6]*m1[0][4]*m0[2][0]+m2[1][6]*m1[0][3]*m0[2][1]+m2[1][6]*m1[0][1]*m0[2][3]+m2[1][6]*m1[0][0]*m0[2][4]-m2[1][4]*m1[2][6]*m0[0][0]-m2[1][4]*m1[2][0]*m0[0][6]+m2[1][4]*m1[0][6]*m0[2][0]+m2[1][4]*m1[0][0]*m0[2][6]-m2[1][3]*m1[2][7]*m0[0][0]-m2[1][3]*m1[2][6]*m0[0][1]-m2[1][3]*m1[2][1]*m0[0][6]-m2[1][3]*m1[2][0]*m0[0][7]+m2[1][3]*m1[0][7]*m0[2][0]+m2[1][3]*m1[0][6]*m0[2][1]+m2[1][3]*m1[0][1]*m0[2][6]+m2[1][3]*m1[0][0]*m0[2][7]-m2[1][1]*m1[2][8]*m0[0][0]-m2[1][1]*m1[2][6]*m0[0][3]-m2[1][1]*m1[2][3]*m0[0][6]-m2[1][1]*m1[2][0]*m0[0][8]+m2[1][1]*m1[0][8]*m0[2][0]+m2[1][1]*m1[0][6]*m0[2][3]+m2[1][1]*m1[0][3]*m0[2][6]+m2[1][1]*m1[0][0]*m0[2][8]-m2[1][0]*m1[2][8]*m0[0][1]-m2[1][0]*m1[2][7]*m0[0][3]-m2[1][0]*m1[2][6]*m0[0][4]-m2[1][0]*m1[2][4]*m0[0][6]-m2[1][0]*m1[2][3]*m0[0][7]-m2[1][0]*m1[2][1]*m0[0][8]+m2[1][0]*m1[0][8]*m0[2][1]+m2[1][0]*m1[0][7]*m0[2][3]+m2[1][0]*m1[0][6]*m0[2][4]+m2[1][0]*m1[0][4]*m0[2][6]+m2[1][0]*m1[0][3]*m0[2][7]+m2[1][0]*m1[0][1]*m0[2][8]+m2[0][8]*m1[2][1]*m0[1][0]+m2[0][8]*m1[2][0]*m0[1][1]-m2[0][8]*m1[1][1]*m0[2][0]-m2[0][8]*m1[1][0]*m0[2][1]+m2[0][7]*m1[2][3]*m0[1][0]+m2[0][7]*m1[2][0]*m0[1][3]-m2[0][7]*m1[1][3]*m0[2][0]-m2[0][7]*m1[1][0]*m0[2][3]+m2[0][6]*m1[2][4]*m0[1][0]+m2[0][6]*m1[2][3]*m0[1][1]+m2[0][6]*m1[2][1]*m0[1][3]+m2[0][6]*m1[2][0]*m0[1][4]-m2[0][6]*m1[1][4]*m0[2][0]-m2[0][6]*m1[1][3]*m0[2][1]-m2[0][6]*m1[1][1]*m0[2][3]-m2[0][6]*m1[1][0]*m0[2][4]+m2[0][4]*m1[2][6]*m0[1][0]+m2[0][4]*m1[2][0]*m0[1][6]-m2[0][4]*m1[1][6]*m0[2][0]-m2[0][4]*m1[1][0]*m0[2][6]+m2[0][3]*m1[2][7]*m0[1][0]+m2[0][3]*m1[2][6]*m0[1][1]+m2[0][3]*m1[2][1]*m0[1][6]+m2[0][3]*m1[2][0]*m0[1][7]-m2[0][3]*m1[1][7]*m0[2][0]-m2[0][3]*m1[1][6]*m0[2][1]-m2[0][3]*m1[1][1]*m0[2][6]-m2[0][3]*m1[1][0]*m0[2][7]+m2[0][1]*m1[2][8]*m0[1][0]+m2[0][1]*m1[2][6]*m0[1][3]+m2[0][1]*m1[2][3]*m0[1][6]+m2[0][1]*m1[2][0]*m0[1][8]-m2[0][1]*m1[1][8]*m0[2][0]-m2[0][1]*m1[1][6]*m0[2][3]-m2[0][1]*m1[1][3]*m0[2][6]-m2[0][1]*m1[1][0]*m0[2][8]+m2[0][0]*m1[2][8]*m0[1][1]+m2[0][0]*m1[2][7]*m0[1][3]+m2[0][0]*m1[2][6]*m0[1][4]+m2[0][0]*m1[2][4]*m0[1][6]+m2[0][0]*m1[2][3]*m0[1][7]+m2[0][0]*m1[2][1]*m0[1][8]-m2[0][0]*m1[1][8]*m0[2][1]-m2[0][0]*m1[1][7]*m0[2][3]-m2[0][0]*m1[1][6]*m0[2][4]-m2[0][0]*m1[1][4]*m0[2][6]-m2[0][0]*m1[1][3]*m0[2][7]-m2[0][0]*m1[1][1]*m0[2][8]; 
  M1(row,36) = m2[2][8]*m1[1][2]*m0[0][0]+m2[2][8]*m1[1][1]*m0[0][1]+m2[2][8]*m1[1][0]*m0[0][2]-m2[2][8]*m1[0][2]*m0[1][0]-m2[2][8]*m1[0][1]*m0[1][1]-m2[2][8]*m1[0][0]*m0[1][2]+m2[2][7]*m1[1][4]*m0[0][0]+m2[2][7]*m1[1][3]*m0[0][1]+m2[2][7]*m1[1][1]*m0[0][3]+m2[2][7]*m1[1][0]*m0[0][4]-m2[2][7]*m1[0][4]*m0[1][0]-m2[2][7]*m1[0][3]*m0[1][1]-m2[2][7]*m1[0][1]*m0[1][3]-m2[2][7]*m1[0][0]*m0[1][4]+m2[2][6]*m1[1][4]*m0[0][1]+m2[2][6]*m1[1][3]*m0[0][2]+m2[2][6]*m1[1][2]*m0[0][3]+m2[2][6]*m1[1][1]*m0[0][4]-m2[2][6]*m1[0][4]*m0[1][1]-m2[2][6]*m1[0][3]*m0[1][2]-m2[2][6]*m1[0][2]*m0[1][3]-m2[2][6]*m1[0][1]*m0[1][4]+m2[2][4]*m1[1][7]*m0[0][0]+m2[2][4]*m1[1][6]*m0[0][1]+m2[2][4]*m1[1][1]*m0[0][6]+m2[2][4]*m1[1][0]*m0[0][7]-m2[2][4]*m1[0][7]*m0[1][0]-m2[2][4]*m1[0][6]*m0[1][1]-m2[2][4]*m1[0][1]*m0[1][6]-m2[2][4]*m1[0][0]*m0[1][7]+m2[2][3]*m1[1][7]*m0[0][1]+m2[2][3]*m1[1][6]*m0[0][2]+m2[2][3]*m1[1][2]*m0[0][6]+m2[2][3]*m1[1][1]*m0[0][7]-m2[2][3]*m1[0][7]*m0[1][1]-m2[2][3]*m1[0][6]*m0[1][2]-m2[2][3]*m1[0][2]*m0[1][6]-m2[2][3]*m1[0][1]*m0[1][7]+m2[2][2]*m1[1][8]*m0[0][0]+m2[2][2]*m1[1][6]*m0[0][3]+m2[2][2]*m1[1][3]*m0[0][6]+m2[2][2]*m1[1][0]*m0[0][8]-m2[2][2]*m1[0][8]*m0[1][0]-m2[2][2]*m1[0][6]*m0[1][3]-m2[2][2]*m1[0][3]*m0[1][6]-m2[2][2]*m1[0][0]*m0[1][8]+m2[2][1]*m1[1][8]*m0[0][1]+m2[2][1]*m1[1][7]*m0[0][3]+m2[2][1]*m1[1][6]*m0[0][4]+m2[2][1]*m1[1][4]*m0[0][6]+m2[2][1]*m1[1][3]*m0[0][7]+m2[2][1]*m1[1][1]*m0[0][8]-m2[2][1]*m1[0][8]*m0[1][1]-m2[2][1]*m1[0][7]*m0[1][3]-m2[2][1]*m1[0][6]*m0[1][4]-m2[2][1]*m1[0][4]*m0[1][6]-m2[2][1]*m1[0][3]*m0[1][7]-m2[2][1]*m1[0][1]*m0[1][8]+m2[2][0]*m1[1][8]*m0[0][2]+m2[2][0]*m1[1][7]*m0[0][4]+m2[2][0]*m1[1][4]*m0[0][7]+m2[2][0]*m1[1][2]*m0[0][8]-m2[2][0]*m1[0][8]*m0[1][2]-m2[2][0]*m1[0][7]*m0[1][4]-m2[2][0]*m1[0][4]*m0[1][7]-m2[2][0]*m1[0][2]*m0[1][8]-m2[1][8]*m1[2][2]*m0[0][0]-m2[1][8]*m1[2][1]*m0[0][1]-m2[1][8]*m1[2][0]*m0[0][2]+m2[1][8]*m1[0][2]*m0[2][0]+m2[1][8]*m1[0][1]*m0[2][1]+m2[1][8]*m1[0][0]*m0[2][2]-m2[1][7]*m1[2][4]*m0[0][0]-m2[1][7]*m1[2][3]*m0[0][1]-m2[1][7]*m1[2][1]*m0[0][3]-m2[1][7]*m1[2][0]*m0[0][4]+m2[1][7]*m1[0][4]*m0[2][0]+m2[1][7]*m1[0][3]*m0[2][1]+m2[1][7]*m1[0][1]*m0[2][3]+m2[1][7]*m1[0][0]*m0[2][4]-m2[1][6]*m1[2][4]*m0[0][1]-m2[1][6]*m1[2][3]*m0[0][2]-m2[1][6]*m1[2][2]*m0[0][3]-m2[1][6]*m1[2][1]*m0[0][4]+m2[1][6]*m1[0][4]*m0[2][1]+m2[1][6]*m1[0][3]*m0[2][2]+m2[1][6]*m1[0][2]*m0[2][3]+m2[1][6]*m1[0][1]*m0[2][4]-m2[1][4]*m1[2][7]*m0[0][0]-m2[1][4]*m1[2][6]*m0[0][1]-m2[1][4]*m1[2][1]*m0[0][6]-m2[1][4]*m1[2][0]*m0[0][7]+m2[1][4]*m1[0][7]*m0[2][0]+m2[1][4]*m1[0][6]*m0[2][1]+m2[1][4]*m1[0][1]*m0[2][6]+m2[1][4]*m1[0][0]*m0[2][7]-m2[1][3]*m1[2][7]*m0[0][1]-m2[1][3]*m1[2][6]*m0[0][2]-m2[1][3]*m1[2][2]*m0[0][6]-m2[1][3]*m1[2][1]*m0[0][7]+m2[1][3]*m1[0][7]*m0[2][1]+m2[1][3]*m1[0][6]*m0[2][2]+m2[1][3]*m1[0][2]*m0[2][6]+m2[1][3]*m1[0][1]*m0[2][7]-m2[1][2]*m1[2][8]*m0[0][0]-m2[1][2]*m1[2][6]*m0[0][3]-m2[1][2]*m1[2][3]*m0[0][6]-m2[1][2]*m1[2][0]*m0[0][8]+m2[1][2]*m1[0][8]*m0[2][0]+m2[1][2]*m1[0][6]*m0[2][3]+m2[1][2]*m1[0][3]*m0[2][6]+m2[1][2]*m1[0][0]*m0[2][8]-m2[1][1]*m1[2][8]*m0[0][1]-m2[1][1]*m1[2][7]*m0[0][3]-m2[1][1]*m1[2][6]*m0[0][4]-m2[1][1]*m1[2][4]*m0[0][6]-m2[1][1]*m1[2][3]*m0[0][7]-m2[1][1]*m1[2][1]*m0[0][8]+m2[1][1]*m1[0][8]*m0[2][1]+m2[1][1]*m1[0][7]*m0[2][3]+m2[1][1]*m1[0][6]*m0[2][4]+m2[1][1]*m1[0][4]*m0[2][6]+m2[1][1]*m1[0][3]*m0[2][7]+m2[1][1]*m1[0][1]*m0[2][8]-m2[1][0]*m1[2][8]*m0[0][2]-m2[1][0]*m1[2][7]*m0[0][4]-m2[1][0]*m1[2][4]*m0[0][7]-m2[1][0]*m1[2][2]*m0[0][8]+m2[1][0]*m1[0][8]*m0[2][2]+m2[1][0]*m1[0][7]*m0[2][4]+m2[1][0]*m1[0][4]*m0[2][7]+m2[1][0]*m1[0][2]*m0[2][8]+m2[0][8]*m1[2][2]*m0[1][0]+m2[0][8]*m1[2][1]*m0[1][1]+m2[0][8]*m1[2][0]*m0[1][2]-m2[0][8]*m1[1][2]*m0[2][0]-m2[0][8]*m1[1][1]*m0[2][1]-m2[0][8]*m1[1][0]*m0[2][2]+m2[0][7]*m1[2][4]*m0[1][0]+m2[0][7]*m1[2][3]*m0[1][1]+m2[0][7]*m1[2][1]*m0[1][3]+m2[0][7]*m1[2][0]*m0[1][4]-m2[0][7]*m1[1][4]*m0[2][0]-m2[0][7]*m1[1][3]*m0[2][1]-m2[0][7]*m1[1][1]*m0[2][3]-m2[0][7]*m1[1][0]*m0[2][4]+m2[0][6]*m1[2][4]*m0[1][1]+m2[0][6]*m1[2][3]*m0[1][2]+m2[0][6]*m1[2][2]*m0[1][3]+m2[0][6]*m1[2][1]*m0[1][4]-m2[0][6]*m1[1][4]*m0[2][1]-m2[0][6]*m1[1][3]*m0[2][2]-m2[0][6]*m1[1][2]*m0[2][3]-m2[0][6]*m1[1][1]*m0[2][4]+m2[0][4]*m1[2][7]*m0[1][0]+m2[0][4]*m1[2][6]*m0[1][1]+m2[0][4]*m1[2][1]*m0[1][6]+m2[0][4]*m1[2][0]*m0[1][7]-m2[0][4]*m1[1][7]*m0[2][0]-m2[0][4]*m1[1][6]*m0[2][1]-m2[0][4]*m1[1][1]*m0[2][6]-m2[0][4]*m1[1][0]*m0[2][7]+m2[0][3]*m1[2][7]*m0[1][1]+m2[0][3]*m1[2][6]*m0[1][2]+m2[0][3]*m1[2][2]*m0[1][6]+m2[0][3]*m1[2][1]*m0[1][7]-m2[0][3]*m1[1][7]*m0[2][1]-m2[0][3]*m1[1][6]*m0[2][2]-m2[0][3]*m1[1][2]*m0[2][6]-m2[0][3]*m1[1][1]*m0[2][7]+m2[0][2]*m1[2][8]*m0[1][0]+m2[0][2]*m1[2][6]*m0[1][3]+m2[0][2]*m1[2][3]*m0[1][6]+m2[0][2]*m1[2][0]*m0[1][8]-m2[0][2]*m1[1][8]*m0[2][0]-m2[0][2]*m1[1][6]*m0[2][3]-m2[0][2]*m1[1][3]*m0[2][6]-m2[0][2]*m1[1][0]*m0[2][8]+m2[0][1]*m1[2][8]*m0[1][1]+m2[0][1]*m1[2][7]*m0[1][3]+m2[0][1]*m1[2][6]*m0[1][4]+m2[0][1]*m1[2][4]*m0[1][6]+m2[0][1]*m1[2][3]*m0[1][7]+m2[0][1]*m1[2][1]*m0[1][8]-m2[0][1]*m1[1][8]*m0[2][1]-m2[0][1]*m1[1][7]*m0[2][3]-m2[0][1]*m1[1][6]*m0[2][4]-m2[0][1]*m1[1][4]*m0[2][6]-m2[0][1]*m1[1][3]*m0[2][7]-m2[0][1]*m1[1][1]*m0[2][8]+m2[0][0]*m1[2][8]*m0[1][2]+m2[0][0]*m1[2][7]*m0[1][4]+m2[0][0]*m1[2][4]*m0[1][7]+m2[0][0]*m1[2][2]*m0[1][8]-m2[0][0]*m1[1][8]*m0[2][2]-m2[0][0]*m1[1][7]*m0[2][4]-m2[0][0]*m1[1][4]*m0[2][7]-m2[0][0]*m1[1][2]*m0[2][8]; 
  M1(row,37) = m2[2][8]*m1[1][2]*m0[0][1]+m2[2][8]*m1[1][1]*m0[0][2]-m2[2][8]*m1[0][2]*m0[1][1]-m2[2][8]*m1[0][1]*m0[1][2]+m2[2][7]*m1[1][4]*m0[0][1]+m2[2][7]*m1[1][3]*m0[0][2]+m2[2][7]*m1[1][2]*m0[0][3]+m2[2][7]*m1[1][1]*m0[0][4]-m2[2][7]*m1[0][4]*m0[1][1]-m2[2][7]*m1[0][3]*m0[1][2]-m2[2][7]*m1[0][2]*m0[1][3]-m2[2][7]*m1[0][1]*m0[1][4]+m2[2][6]*m1[1][4]*m0[0][2]+m2[2][6]*m1[1][2]*m0[0][4]-m2[2][6]*m1[0][4]*m0[1][2]-m2[2][6]*m1[0][2]*m0[1][4]+m2[2][4]*m1[1][7]*m0[0][1]+m2[2][4]*m1[1][6]*m0[0][2]+m2[2][4]*m1[1][2]*m0[0][6]+m2[2][4]*m1[1][1]*m0[0][7]-m2[2][4]*m1[0][7]*m0[1][1]-m2[2][4]*m1[0][6]*m0[1][2]-m2[2][4]*m1[0][2]*m0[1][6]-m2[2][4]*m1[0][1]*m0[1][7]+m2[2][3]*m1[1][7]*m0[0][2]+m2[2][3]*m1[1][2]*m0[0][7]-m2[2][3]*m1[0][7]*m0[1][2]-m2[2][3]*m1[0][2]*m0[1][7]+m2[2][2]*m1[1][8]*m0[0][1]+m2[2][2]*m1[1][7]*m0[0][3]+m2[2][2]*m1[1][6]*m0[0][4]+m2[2][2]*m1[1][4]*m0[0][6]+m2[2][2]*m1[1][3]*m0[0][7]+m2[2][2]*m1[1][1]*m0[0][8]-m2[2][2]*m1[0][8]*m0[1][1]-m2[2][2]*m1[0][7]*m0[1][3]-m2[2][2]*m1[0][6]*m0[1][4]-m2[2][2]*m1[0][4]*m0[1][6]-m2[2][2]*m1[0][3]*m0[1][7]-m2[2][2]*m1[0][1]*m0[1][8]+m2[2][1]*m1[1][8]*m0[0][2]+m2[2][1]*m1[1][7]*m0[0][4]+m2[2][1]*m1[1][4]*m0[0][7]+m2[2][1]*m1[1][2]*m0[0][8]-m2[2][1]*m1[0][8]*m0[1][2]-m2[2][1]*m1[0][7]*m0[1][4]-m2[2][1]*m1[0][4]*m0[1][7]-m2[2][1]*m1[0][2]*m0[1][8]-m2[1][8]*m1[2][2]*m0[0][1]-m2[1][8]*m1[2][1]*m0[0][2]+m2[1][8]*m1[0][2]*m0[2][1]+m2[1][8]*m1[0][1]*m0[2][2]-m2[1][7]*m1[2][4]*m0[0][1]-m2[1][7]*m1[2][3]*m0[0][2]-m2[1][7]*m1[2][2]*m0[0][3]-m2[1][7]*m1[2][1]*m0[0][4]+m2[1][7]*m1[0][4]*m0[2][1]+m2[1][7]*m1[0][3]*m0[2][2]+m2[1][7]*m1[0][2]*m0[2][3]+m2[1][7]*m1[0][1]*m0[2][4]-m2[1][6]*m1[2][4]*m0[0][2]-m2[1][6]*m1[2][2]*m0[0][4]+m2[1][6]*m1[0][4]*m0[2][2]+m2[1][6]*m1[0][2]*m0[2][4]-m2[1][4]*m1[2][7]*m0[0][1]-m2[1][4]*m1[2][6]*m0[0][2]-m2[1][4]*m1[2][2]*m0[0][6]-m2[1][4]*m1[2][1]*m0[0][7]+m2[1][4]*m1[0][7]*m0[2][1]+m2[1][4]*m1[0][6]*m0[2][2]+m2[1][4]*m1[0][2]*m0[2][6]+m2[1][4]*m1[0][1]*m0[2][7]-m2[1][3]*m1[2][7]*m0[0][2]-m2[1][3]*m1[2][2]*m0[0][7]+m2[1][3]*m1[0][7]*m0[2][2]+m2[1][3]*m1[0][2]*m0[2][7]-m2[1][2]*m1[2][8]*m0[0][1]-m2[1][2]*m1[2][7]*m0[0][3]-m2[1][2]*m1[2][6]*m0[0][4]-m2[1][2]*m1[2][4]*m0[0][6]-m2[1][2]*m1[2][3]*m0[0][7]-m2[1][2]*m1[2][1]*m0[0][8]+m2[1][2]*m1[0][8]*m0[2][1]+m2[1][2]*m1[0][7]*m0[2][3]+m2[1][2]*m1[0][6]*m0[2][4]+m2[1][2]*m1[0][4]*m0[2][6]+m2[1][2]*m1[0][3]*m0[2][7]+m2[1][2]*m1[0][1]*m0[2][8]-m2[1][1]*m1[2][8]*m0[0][2]-m2[1][1]*m1[2][7]*m0[0][4]-m2[1][1]*m1[2][4]*m0[0][7]-m2[1][1]*m1[2][2]*m0[0][8]+m2[1][1]*m1[0][8]*m0[2][2]+m2[1][1]*m1[0][7]*m0[2][4]+m2[1][1]*m1[0][4]*m0[2][7]+m2[1][1]*m1[0][2]*m0[2][8]+m2[0][8]*m1[2][2]*m0[1][1]+m2[0][8]*m1[2][1]*m0[1][2]-m2[0][8]*m1[1][2]*m0[2][1]-m2[0][8]*m1[1][1]*m0[2][2]+m2[0][7]*m1[2][4]*m0[1][1]+m2[0][7]*m1[2][3]*m0[1][2]+m2[0][7]*m1[2][2]*m0[1][3]+m2[0][7]*m1[2][1]*m0[1][4]-m2[0][7]*m1[1][4]*m0[2][1]-m2[0][7]*m1[1][3]*m0[2][2]-m2[0][7]*m1[1][2]*m0[2][3]-m2[0][7]*m1[1][1]*m0[2][4]+m2[0][6]*m1[2][4]*m0[1][2]+m2[0][6]*m1[2][2]*m0[1][4]-m2[0][6]*m1[1][4]*m0[2][2]-m2[0][6]*m1[1][2]*m0[2][4]+m2[0][4]*m1[2][7]*m0[1][1]+m2[0][4]*m1[2][6]*m0[1][2]+m2[0][4]*m1[2][2]*m0[1][6]+m2[0][4]*m1[2][1]*m0[1][7]-m2[0][4]*m1[1][7]*m0[2][1]-m2[0][4]*m1[1][6]*m0[2][2]-m2[0][4]*m1[1][2]*m0[2][6]-m2[0][4]*m1[1][1]*m0[2][7]+m2[0][3]*m1[2][7]*m0[1][2]+m2[0][3]*m1[2][2]*m0[1][7]-m2[0][3]*m1[1][7]*m0[2][2]-m2[0][3]*m1[1][2]*m0[2][7]+m2[0][2]*m1[2][8]*m0[1][1]+m2[0][2]*m1[2][7]*m0[1][3]+m2[0][2]*m1[2][6]*m0[1][4]+m2[0][2]*m1[2][4]*m0[1][6]+m2[0][2]*m1[2][3]*m0[1][7]+m2[0][2]*m1[2][1]*m0[1][8]-m2[0][2]*m1[1][8]*m0[2][1]-m2[0][2]*m1[1][7]*m0[2][3]-m2[0][2]*m1[1][6]*m0[2][4]-m2[0][2]*m1[1][4]*m0[2][6]-m2[0][2]*m1[1][3]*m0[2][7]-m2[0][2]*m1[1][1]*m0[2][8]+m2[0][1]*m1[2][8]*m0[1][2]+m2[0][1]*m1[2][7]*m0[1][4]+m2[0][1]*m1[2][4]*m0[1][7]+m2[0][1]*m1[2][2]*m0[1][8]-m2[0][1]*m1[1][8]*m0[2][2]-m2[0][1]*m1[1][7]*m0[2][4]-m2[0][1]*m1[1][4]*m0[2][7]-m2[0][1]*m1[1][2]*m0[2][8]; 
  M1(row,38) = m2[2][8]*m1[1][2]*m0[0][2]-m2[2][8]*m1[0][2]*m0[1][2]+m2[2][7]*m1[1][4]*m0[0][2]+m2[2][7]*m1[1][2]*m0[0][4]-m2[2][7]*m1[0][4]*m0[1][2]-m2[2][7]*m1[0][2]*m0[1][4]+m2[2][4]*m1[1][7]*m0[0][2]+m2[2][4]*m1[1][2]*m0[0][7]-m2[2][4]*m1[0][7]*m0[1][2]-m2[2][4]*m1[0][2]*m0[1][7]+m2[2][2]*m1[1][8]*m0[0][2]+m2[2][2]*m1[1][7]*m0[0][4]+m2[2][2]*m1[1][4]*m0[0][7]+m2[2][2]*m1[1][2]*m0[0][8]-m2[2][2]*m1[0][8]*m0[1][2]-m2[2][2]*m1[0][7]*m0[1][4]-m2[2][2]*m1[0][4]*m0[1][7]-m2[2][2]*m1[0][2]*m0[1][8]-m2[1][8]*m1[2][2]*m0[0][2]+m2[1][8]*m1[0][2]*m0[2][2]-m2[1][7]*m1[2][4]*m0[0][2]-m2[1][7]*m1[2][2]*m0[0][4]+m2[1][7]*m1[0][4]*m0[2][2]+m2[1][7]*m1[0][2]*m0[2][4]-m2[1][4]*m1[2][7]*m0[0][2]-m2[1][4]*m1[2][2]*m0[0][7]+m2[1][4]*m1[0][7]*m0[2][2]+m2[1][4]*m1[0][2]*m0[2][7]-m2[1][2]*m1[2][8]*m0[0][2]-m2[1][2]*m1[2][7]*m0[0][4]-m2[1][2]*m1[2][4]*m0[0][7]-m2[1][2]*m1[2][2]*m0[0][8]+m2[1][2]*m1[0][8]*m0[2][2]+m2[1][2]*m1[0][7]*m0[2][4]+m2[1][2]*m1[0][4]*m0[2][7]+m2[1][2]*m1[0][2]*m0[2][8]+m2[0][8]*m1[2][2]*m0[1][2]-m2[0][8]*m1[1][2]*m0[2][2]+m2[0][7]*m1[2][4]*m0[1][2]+m2[0][7]*m1[2][2]*m0[1][4]-m2[0][7]*m1[1][4]*m0[2][2]-m2[0][7]*m1[1][2]*m0[2][4]+m2[0][4]*m1[2][7]*m0[1][2]+m2[0][4]*m1[2][2]*m0[1][7]-m2[0][4]*m1[1][7]*m0[2][2]-m2[0][4]*m1[1][2]*m0[2][7]+m2[0][2]*m1[2][8]*m0[1][2]+m2[0][2]*m1[2][7]*m0[1][4]+m2[0][2]*m1[2][4]*m0[1][7]+m2[0][2]*m1[2][2]*m0[1][8]-m2[0][2]*m1[1][8]*m0[2][2]-m2[0][2]*m1[1][7]*m0[2][4]-m2[0][2]*m1[1][4]*m0[2][7]-m2[0][2]*m1[1][2]*m0[2][8]; 
  M1(row,39) = m2[2][8]*m1[1][3]*m0[0][0]+m2[2][8]*m1[1][0]*m0[0][3]-m2[2][8]*m1[0][3]*m0[1][0]-m2[2][8]*m1[0][0]*m0[1][3]+m2[2][6]*m1[1][5]*m0[0][0]+m2[2][6]*m1[1][3]*m0[0][3]+m2[2][6]*m1[1][0]*m0[0][5]-m2[2][6]*m1[0][5]*m0[1][0]-m2[2][6]*m1[0][3]*m0[1][3]-m2[2][6]*m1[0][0]*m0[1][5]+m2[2][5]*m1[1][6]*m0[0][0]+m2[2][5]*m1[1][0]*m0[0][6]-m2[2][5]*m1[0][6]*m0[1][0]-m2[2][5]*m1[0][0]*m0[1][6]+m2[2][3]*m1[1][8]*m0[0][0]+m2[2][3]*m1[1][6]*m0[0][3]+m2[2][3]*m1[1][3]*m0[0][6]+m2[2][3]*m1[1][0]*m0[0][8]-m2[2][3]*m1[0][8]*m0[1][0]-m2[2][3]*m1[0][6]*m0[1][3]-m2[2][3]*m1[0][3]*m0[1][6]-m2[2][3]*m1[0][0]*m0[1][8]+m2[2][0]*m1[1][8]*m0[0][3]+m2[2][0]*m1[1][6]*m0[0][5]+m2[2][0]*m1[1][5]*m0[0][6]+m2[2][0]*m1[1][3]*m0[0][8]-m2[2][0]*m1[0][8]*m0[1][3]-m2[2][0]*m1[0][6]*m0[1][5]-m2[2][0]*m1[0][5]*m0[1][6]-m2[2][0]*m1[0][3]*m0[1][8]-m2[1][8]*m1[2][3]*m0[0][0]-m2[1][8]*m1[2][0]*m0[0][3]+m2[1][8]*m1[0][3]*m0[2][0]+m2[1][8]*m1[0][0]*m0[2][3]-m2[1][6]*m1[2][5]*m0[0][0]-m2[1][6]*m1[2][3]*m0[0][3]-m2[1][6]*m1[2][0]*m0[0][5]+m2[1][6]*m1[0][5]*m0[2][0]+m2[1][6]*m1[0][3]*m0[2][3]+m2[1][6]*m1[0][0]*m0[2][5]-m2[1][5]*m1[2][6]*m0[0][0]-m2[1][5]*m1[2][0]*m0[0][6]+m2[1][5]*m1[0][6]*m0[2][0]+m2[1][5]*m1[0][0]*m0[2][6]-m2[1][3]*m1[2][8]*m0[0][0]-m2[1][3]*m1[2][6]*m0[0][3]-m2[1][3]*m1[2][3]*m0[0][6]-m2[1][3]*m1[2][0]*m0[0][8]+m2[1][3]*m1[0][8]*m0[2][0]+m2[1][3]*m1[0][6]*m0[2][3]+m2[1][3]*m1[0][3]*m0[2][6]+m2[1][3]*m1[0][0]*m0[2][8]-m2[1][0]*m1[2][8]*m0[0][3]-m2[1][0]*m1[2][6]*m0[0][5]-m2[1][0]*m1[2][5]*m0[0][6]-m2[1][0]*m1[2][3]*m0[0][8]+m2[1][0]*m1[0][8]*m0[2][3]+m2[1][0]*m1[0][6]*m0[2][5]+m2[1][0]*m1[0][5]*m0[2][6]+m2[1][0]*m1[0][3]*m0[2][8]+m2[0][8]*m1[2][3]*m0[1][0]+m2[0][8]*m1[2][0]*m0[1][3]-m2[0][8]*m1[1][3]*m0[2][0]-m2[0][8]*m1[1][0]*m0[2][3]+m2[0][6]*m1[2][5]*m0[1][0]+m2[0][6]*m1[2][3]*m0[1][3]+m2[0][6]*m1[2][0]*m0[1][5]-m2[0][6]*m1[1][5]*m0[2][0]-m2[0][6]*m1[1][3]*m0[2][3]-m2[0][6]*m1[1][0]*m0[2][5]+m2[0][5]*m1[2][6]*m0[1][0]+m2[0][5]*m1[2][0]*m0[1][6]-m2[0][5]*m1[1][6]*m0[2][0]-m2[0][5]*m1[1][0]*m0[2][6]+m2[0][3]*m1[2][8]*m0[1][0]+m2[0][3]*m1[2][6]*m0[1][3]+m2[0][3]*m1[2][3]*m0[1][6]+m2[0][3]*m1[2][0]*m0[1][8]-m2[0][3]*m1[1][8]*m0[2][0]-m2[0][3]*m1[1][6]*m0[2][3]-m2[0][3]*m1[1][3]*m0[2][6]-m2[0][3]*m1[1][0]*m0[2][8]+m2[0][0]*m1[2][8]*m0[1][3]+m2[0][0]*m1[2][6]*m0[1][5]+m2[0][0]*m1[2][5]*m0[1][6]+m2[0][0]*m1[2][3]*m0[1][8]-m2[0][0]*m1[1][8]*m0[2][3]-m2[0][0]*m1[1][6]*m0[2][5]-m2[0][0]*m1[1][5]*m0[2][6]-m2[0][0]*m1[1][3]*m0[2][8]; 
  M1(row,40) = m2[2][8]*m1[1][4]*m0[0][0]+m2[2][8]*m1[1][3]*m0[0][1]+m2[2][8]*m1[1][1]*m0[0][3]+m2[2][8]*m1[1][0]*m0[0][4]-m2[2][8]*m1[0][4]*m0[1][0]-m2[2][8]*m1[0][3]*m0[1][1]-m2[2][8]*m1[0][1]*m0[1][3]-m2[2][8]*m1[0][0]*m0[1][4]+m2[2][7]*m1[1][5]*m0[0][0]+m2[2][7]*m1[1][3]*m0[0][3]+m2[2][7]*m1[1][0]*m0[0][5]-m2[2][7]*m1[0][5]*m0[1][0]-m2[2][7]*m1[0][3]*m0[1][3]-m2[2][7]*m1[0][0]*m0[1][5]+m2[2][6]*m1[1][5]*m0[0][1]+m2[2][6]*m1[1][4]*m0[0][3]+m2[2][6]*m1[1][3]*m0[0][4]+m2[2][6]*m1[1][1]*m0[0][5]-m2[2][6]*m1[0][5]*m0[1][1]-m2[2][6]*m1[0][4]*m0[1][3]-m2[2][6]*m1[0][3]*m0[1][4]-m2[2][6]*m1[0][1]*m0[1][5]+m2[2][5]*m1[1][7]*m0[0][0]+m2[2][5]*m1[1][6]*m0[0][1]+m2[2][5]*m1[1][1]*m0[0][6]+m2[2][5]*m1[1][0]*m0[0][7]-m2[2][5]*m1[0][7]*m0[1][0]-m2[2][5]*m1[0][6]*m0[1][1]-m2[2][5]*m1[0][1]*m0[1][6]-m2[2][5]*m1[0][0]*m0[1][7]+m2[2][4]*m1[1][8]*m0[0][0]+m2[2][4]*m1[1][6]*m0[0][3]+m2[2][4]*m1[1][3]*m0[0][6]+m2[2][4]*m1[1][0]*m0[0][8]-m2[2][4]*m1[0][8]*m0[1][0]-m2[2][4]*m1[0][6]*m0[1][3]-m2[2][4]*m1[0][3]*m0[1][6]-m2[2][4]*m1[0][0]*m0[1][8]+m2[2][3]*m1[1][8]*m0[0][1]+m2[2][3]*m1[1][7]*m0[0][3]+m2[2][3]*m1[1][6]*m0[0][4]+m2[2][3]*m1[1][4]*m0[0][6]+m2[2][3]*m1[1][3]*m0[0][7]+m2[2][3]*m1[1][1]*m0[0][8]-m2[2][3]*m1[0][8]*m0[1][1]-m2[2][3]*m1[0][7]*m0[1][3]-m2[2][3]*m1[0][6]*m0[1][4]-m2[2][3]*m1[0][4]*m0[1][6]-m2[2][3]*m1[0][3]*m0[1][7]-m2[2][3]*m1[0][1]*m0[1][8]+m2[2][1]*m1[1][8]*m0[0][3]+m2[2][1]*m1[1][6]*m0[0][5]+m2[2][1]*m1[1][5]*m0[0][6]+m2[2][1]*m1[1][3]*m0[0][8]-m2[2][1]*m1[0][8]*m0[1][3]-m2[2][1]*m1[0][6]*m0[1][5]-m2[2][1]*m1[0][5]*m0[1][6]-m2[2][1]*m1[0][3]*m0[1][8]+m2[2][0]*m1[1][8]*m0[0][4]+m2[2][0]*m1[1][7]*m0[0][5]+m2[2][0]*m1[1][5]*m0[0][7]+m2[2][0]*m1[1][4]*m0[0][8]-m2[2][0]*m1[0][8]*m0[1][4]-m2[2][0]*m1[0][7]*m0[1][5]-m2[2][0]*m1[0][5]*m0[1][7]-m2[2][0]*m1[0][4]*m0[1][8]-m2[1][8]*m1[2][4]*m0[0][0]-m2[1][8]*m1[2][3]*m0[0][1]-m2[1][8]*m1[2][1]*m0[0][3]-m2[1][8]*m1[2][0]*m0[0][4]+m2[1][8]*m1[0][4]*m0[2][0]+m2[1][8]*m1[0][3]*m0[2][1]+m2[1][8]*m1[0][1]*m0[2][3]+m2[1][8]*m1[0][0]*m0[2][4]-m2[1][7]*m1[2][5]*m0[0][0]-m2[1][7]*m1[2][3]*m0[0][3]-m2[1][7]*m1[2][0]*m0[0][5]+m2[1][7]*m1[0][5]*m0[2][0]+m2[1][7]*m1[0][3]*m0[2][3]+m2[1][7]*m1[0][0]*m0[2][5]-m2[1][6]*m1[2][5]*m0[0][1]-m2[1][6]*m1[2][4]*m0[0][3]-m2[1][6]*m1[2][3]*m0[0][4]-m2[1][6]*m1[2][1]*m0[0][5]+m2[1][6]*m1[0][5]*m0[2][1]+m2[1][6]*m1[0][4]*m0[2][3]+m2[1][6]*m1[0][3]*m0[2][4]+m2[1][6]*m1[0][1]*m0[2][5]-m2[1][5]*m1[2][7]*m0[0][0]-m2[1][5]*m1[2][6]*m0[0][1]-m2[1][5]*m1[2][1]*m0[0][6]-m2[1][5]*m1[2][0]*m0[0][7]+m2[1][5]*m1[0][7]*m0[2][0]+m2[1][5]*m1[0][6]*m0[2][1]+m2[1][5]*m1[0][1]*m0[2][6]+m2[1][5]*m1[0][0]*m0[2][7]-m2[1][4]*m1[2][8]*m0[0][0]-m2[1][4]*m1[2][6]*m0[0][3]-m2[1][4]*m1[2][3]*m0[0][6]-m2[1][4]*m1[2][0]*m0[0][8]+m2[1][4]*m1[0][8]*m0[2][0]+m2[1][4]*m1[0][6]*m0[2][3]+m2[1][4]*m1[0][3]*m0[2][6]+m2[1][4]*m1[0][0]*m0[2][8]-m2[1][3]*m1[2][8]*m0[0][1]-m2[1][3]*m1[2][7]*m0[0][3]-m2[1][3]*m1[2][6]*m0[0][4]-m2[1][3]*m1[2][4]*m0[0][6]-m2[1][3]*m1[2][3]*m0[0][7]-m2[1][3]*m1[2][1]*m0[0][8]+m2[1][3]*m1[0][8]*m0[2][1]+m2[1][3]*m1[0][7]*m0[2][3]+m2[1][3]*m1[0][6]*m0[2][4]+m2[1][3]*m1[0][4]*m0[2][6]+m2[1][3]*m1[0][3]*m0[2][7]+m2[1][3]*m1[0][1]*m0[2][8]-m2[1][1]*m1[2][8]*m0[0][3]-m2[1][1]*m1[2][6]*m0[0][5]-m2[1][1]*m1[2][5]*m0[0][6]-m2[1][1]*m1[2][3]*m0[0][8]+m2[1][1]*m1[0][8]*m0[2][3]+m2[1][1]*m1[0][6]*m0[2][5]+m2[1][1]*m1[0][5]*m0[2][6]+m2[1][1]*m1[0][3]*m0[2][8]-m2[1][0]*m1[2][8]*m0[0][4]-m2[1][0]*m1[2][7]*m0[0][5]-m2[1][0]*m1[2][5]*m0[0][7]-m2[1][0]*m1[2][4]*m0[0][8]+m2[1][0]*m1[0][8]*m0[2][4]+m2[1][0]*m1[0][7]*m0[2][5]+m2[1][0]*m1[0][5]*m0[2][7]+m2[1][0]*m1[0][4]*m0[2][8]+m2[0][8]*m1[2][4]*m0[1][0]+m2[0][8]*m1[2][3]*m0[1][1]+m2[0][8]*m1[2][1]*m0[1][3]+m2[0][8]*m1[2][0]*m0[1][4]-m2[0][8]*m1[1][4]*m0[2][0]-m2[0][8]*m1[1][3]*m0[2][1]-m2[0][8]*m1[1][1]*m0[2][3]-m2[0][8]*m1[1][0]*m0[2][4]+m2[0][7]*m1[2][5]*m0[1][0]+m2[0][7]*m1[2][3]*m0[1][3]+m2[0][7]*m1[2][0]*m0[1][5]-m2[0][7]*m1[1][5]*m0[2][0]-m2[0][7]*m1[1][3]*m0[2][3]-m2[0][7]*m1[1][0]*m0[2][5]+m2[0][6]*m1[2][5]*m0[1][1]+m2[0][6]*m1[2][4]*m0[1][3]+m2[0][6]*m1[2][3]*m0[1][4]+m2[0][6]*m1[2][1]*m0[1][5]-m2[0][6]*m1[1][5]*m0[2][1]-m2[0][6]*m1[1][4]*m0[2][3]-m2[0][6]*m1[1][3]*m0[2][4]-m2[0][6]*m1[1][1]*m0[2][5]+m2[0][5]*m1[2][7]*m0[1][0]+m2[0][5]*m1[2][6]*m0[1][1]+m2[0][5]*m1[2][1]*m0[1][6]+m2[0][5]*m1[2][0]*m0[1][7]-m2[0][5]*m1[1][7]*m0[2][0]-m2[0][5]*m1[1][6]*m0[2][1]-m2[0][5]*m1[1][1]*m0[2][6]-m2[0][5]*m1[1][0]*m0[2][7]+m2[0][4]*m1[2][8]*m0[1][0]+m2[0][4]*m1[2][6]*m0[1][3]+m2[0][4]*m1[2][3]*m0[1][6]+m2[0][4]*m1[2][0]*m0[1][8]-m2[0][4]*m1[1][8]*m0[2][0]-m2[0][4]*m1[1][6]*m0[2][3]-m2[0][4]*m1[1][3]*m0[2][6]-m2[0][4]*m1[1][0]*m0[2][8]+m2[0][3]*m1[2][8]*m0[1][1]+m2[0][3]*m1[2][7]*m0[1][3]+m2[0][3]*m1[2][6]*m0[1][4]+m2[0][3]*m1[2][4]*m0[1][6]+m2[0][3]*m1[2][3]*m0[1][7]+m2[0][3]*m1[2][1]*m0[1][8]-m2[0][3]*m1[1][8]*m0[2][1]-m2[0][3]*m1[1][7]*m0[2][3]-m2[0][3]*m1[1][6]*m0[2][4]-m2[0][3]*m1[1][4]*m0[2][6]-m2[0][3]*m1[1][3]*m0[2][7]-m2[0][3]*m1[1][1]*m0[2][8]+m2[0][1]*m1[2][8]*m0[1][3]+m2[0][1]*m1[2][6]*m0[1][5]+m2[0][1]*m1[2][5]*m0[1][6]+m2[0][1]*m1[2][3]*m0[1][8]-m2[0][1]*m1[1][8]*m0[2][3]-m2[0][1]*m1[1][6]*m0[2][5]-m2[0][1]*m1[1][5]*m0[2][6]-m2[0][1]*m1[1][3]*m0[2][8]+m2[0][0]*m1[2][8]*m0[1][4]+m2[0][0]*m1[2][7]*m0[1][5]+m2[0][0]*m1[2][5]*m0[1][7]+m2[0][0]*m1[2][4]*m0[1][8]-m2[0][0]*m1[1][8]*m0[2][4]-m2[0][0]*m1[1][7]*m0[2][5]-m2[0][0]*m1[1][5]*m0[2][7]-m2[0][0]*m1[1][4]*m0[2][8]; 
  M1(row,41) = m2[2][8]*m1[1][4]*m0[0][1]+m2[2][8]*m1[1][3]*m0[0][2]+m2[2][8]*m1[1][2]*m0[0][3]+m2[2][8]*m1[1][1]*m0[0][4]-m2[2][8]*m1[0][4]*m0[1][1]-m2[2][8]*m1[0][3]*m0[1][2]-m2[2][8]*m1[0][2]*m0[1][3]-m2[2][8]*m1[0][1]*m0[1][4]+m2[2][7]*m1[1][5]*m0[0][1]+m2[2][7]*m1[1][4]*m0[0][3]+m2[2][7]*m1[1][3]*m0[0][4]+m2[2][7]*m1[1][1]*m0[0][5]-m2[2][7]*m1[0][5]*m0[1][1]-m2[2][7]*m1[0][4]*m0[1][3]-m2[2][7]*m1[0][3]*m0[1][4]-m2[2][7]*m1[0][1]*m0[1][5]+m2[2][6]*m1[1][5]*m0[0][2]+m2[2][6]*m1[1][4]*m0[0][4]+m2[2][6]*m1[1][2]*m0[0][5]-m2[2][6]*m1[0][5]*m0[1][2]-m2[2][6]*m1[0][4]*m0[1][4]-m2[2][6]*m1[0][2]*m0[1][5]+m2[2][5]*m1[1][7]*m0[0][1]+m2[2][5]*m1[1][6]*m0[0][2]+m2[2][5]*m1[1][2]*m0[0][6]+m2[2][5]*m1[1][1]*m0[0][7]-m2[2][5]*m1[0][7]*m0[1][1]-m2[2][5]*m1[0][6]*m0[1][2]-m2[2][5]*m1[0][2]*m0[1][6]-m2[2][5]*m1[0][1]*m0[1][7]+m2[2][4]*m1[1][8]*m0[0][1]+m2[2][4]*m1[1][7]*m0[0][3]+m2[2][4]*m1[1][6]*m0[0][4]+m2[2][4]*m1[1][4]*m0[0][6]+m2[2][4]*m1[1][3]*m0[0][7]+m2[2][4]*m1[1][1]*m0[0][8]-m2[2][4]*m1[0][8]*m0[1][1]-m2[2][4]*m1[0][7]*m0[1][3]-m2[2][4]*m1[0][6]*m0[1][4]-m2[2][4]*m1[0][4]*m0[1][6]-m2[2][4]*m1[0][3]*m0[1][7]-m2[2][4]*m1[0][1]*m0[1][8]+m2[2][3]*m1[1][8]*m0[0][2]+m2[2][3]*m1[1][7]*m0[0][4]+m2[2][3]*m1[1][4]*m0[0][7]+m2[2][3]*m1[1][2]*m0[0][8]-m2[2][3]*m1[0][8]*m0[1][2]-m2[2][3]*m1[0][7]*m0[1][4]-m2[2][3]*m1[0][4]*m0[1][7]-m2[2][3]*m1[0][2]*m0[1][8]+m2[2][2]*m1[1][8]*m0[0][3]+m2[2][2]*m1[1][6]*m0[0][5]+m2[2][2]*m1[1][5]*m0[0][6]+m2[2][2]*m1[1][3]*m0[0][8]-m2[2][2]*m1[0][8]*m0[1][3]-m2[2][2]*m1[0][6]*m0[1][5]-m2[2][2]*m1[0][5]*m0[1][6]-m2[2][2]*m1[0][3]*m0[1][8]+m2[2][1]*m1[1][8]*m0[0][4]+m2[2][1]*m1[1][7]*m0[0][5]+m2[2][1]*m1[1][5]*m0[0][7]+m2[2][1]*m1[1][4]*m0[0][8]-m2[2][1]*m1[0][8]*m0[1][4]-m2[2][1]*m1[0][7]*m0[1][5]-m2[2][1]*m1[0][5]*m0[1][7]-m2[2][1]*m1[0][4]*m0[1][8]-m2[1][8]*m1[2][4]*m0[0][1]-m2[1][8]*m1[2][3]*m0[0][2]-m2[1][8]*m1[2][2]*m0[0][3]-m2[1][8]*m1[2][1]*m0[0][4]+m2[1][8]*m1[0][4]*m0[2][1]+m2[1][8]*m1[0][3]*m0[2][2]+m2[1][8]*m1[0][2]*m0[2][3]+m2[1][8]*m1[0][1]*m0[2][4]-m2[1][7]*m1[2][5]*m0[0][1]-m2[1][7]*m1[2][4]*m0[0][3]-m2[1][7]*m1[2][3]*m0[0][4]-m2[1][7]*m1[2][1]*m0[0][5]+m2[1][7]*m1[0][5]*m0[2][1]+m2[1][7]*m1[0][4]*m0[2][3]+m2[1][7]*m1[0][3]*m0[2][4]+m2[1][7]*m1[0][1]*m0[2][5]-m2[1][6]*m1[2][5]*m0[0][2]-m2[1][6]*m1[2][4]*m0[0][4]-m2[1][6]*m1[2][2]*m0[0][5]+m2[1][6]*m1[0][5]*m0[2][2]+m2[1][6]*m1[0][4]*m0[2][4]+m2[1][6]*m1[0][2]*m0[2][5]-m2[1][5]*m1[2][7]*m0[0][1]-m2[1][5]*m1[2][6]*m0[0][2]-m2[1][5]*m1[2][2]*m0[0][6]-m2[1][5]*m1[2][1]*m0[0][7]+m2[1][5]*m1[0][7]*m0[2][1]+m2[1][5]*m1[0][6]*m0[2][2]+m2[1][5]*m1[0][2]*m0[2][6]+m2[1][5]*m1[0][1]*m0[2][7]-m2[1][4]*m1[2][8]*m0[0][1]-m2[1][4]*m1[2][7]*m0[0][3]-m2[1][4]*m1[2][6]*m0[0][4]-m2[1][4]*m1[2][4]*m0[0][6]-m2[1][4]*m1[2][3]*m0[0][7]-m2[1][4]*m1[2][1]*m0[0][8]+m2[1][4]*m1[0][8]*m0[2][1]+m2[1][4]*m1[0][7]*m0[2][3]+m2[1][4]*m1[0][6]*m0[2][4]+m2[1][4]*m1[0][4]*m0[2][6]+m2[1][4]*m1[0][3]*m0[2][7]+m2[1][4]*m1[0][1]*m0[2][8]-m2[1][3]*m1[2][8]*m0[0][2]-m2[1][3]*m1[2][7]*m0[0][4]-m2[1][3]*m1[2][4]*m0[0][7]-m2[1][3]*m1[2][2]*m0[0][8]+m2[1][3]*m1[0][8]*m0[2][2]+m2[1][3]*m1[0][7]*m0[2][4]+m2[1][3]*m1[0][4]*m0[2][7]+m2[1][3]*m1[0][2]*m0[2][8]-m2[1][2]*m1[2][8]*m0[0][3]-m2[1][2]*m1[2][6]*m0[0][5]-m2[1][2]*m1[2][5]*m0[0][6]-m2[1][2]*m1[2][3]*m0[0][8]+m2[1][2]*m1[0][8]*m0[2][3]+m2[1][2]*m1[0][6]*m0[2][5]+m2[1][2]*m1[0][5]*m0[2][6]+m2[1][2]*m1[0][3]*m0[2][8]-m2[1][1]*m1[2][8]*m0[0][4]-m2[1][1]*m1[2][7]*m0[0][5]-m2[1][1]*m1[2][5]*m0[0][7]-m2[1][1]*m1[2][4]*m0[0][8]+m2[1][1]*m1[0][8]*m0[2][4]+m2[1][1]*m1[0][7]*m0[2][5]+m2[1][1]*m1[0][5]*m0[2][7]+m2[1][1]*m1[0][4]*m0[2][8]+m2[0][8]*m1[2][4]*m0[1][1]+m2[0][8]*m1[2][3]*m0[1][2]+m2[0][8]*m1[2][2]*m0[1][3]+m2[0][8]*m1[2][1]*m0[1][4]-m2[0][8]*m1[1][4]*m0[2][1]-m2[0][8]*m1[1][3]*m0[2][2]-m2[0][8]*m1[1][2]*m0[2][3]-m2[0][8]*m1[1][1]*m0[2][4]+m2[0][7]*m1[2][5]*m0[1][1]+m2[0][7]*m1[2][4]*m0[1][3]+m2[0][7]*m1[2][3]*m0[1][4]+m2[0][7]*m1[2][1]*m0[1][5]-m2[0][7]*m1[1][5]*m0[2][1]-m2[0][7]*m1[1][4]*m0[2][3]-m2[0][7]*m1[1][3]*m0[2][4]-m2[0][7]*m1[1][1]*m0[2][5]+m2[0][6]*m1[2][5]*m0[1][2]+m2[0][6]*m1[2][4]*m0[1][4]+m2[0][6]*m1[2][2]*m0[1][5]-m2[0][6]*m1[1][5]*m0[2][2]-m2[0][6]*m1[1][4]*m0[2][4]-m2[0][6]*m1[1][2]*m0[2][5]+m2[0][5]*m1[2][7]*m0[1][1]+m2[0][5]*m1[2][6]*m0[1][2]+m2[0][5]*m1[2][2]*m0[1][6]+m2[0][5]*m1[2][1]*m0[1][7]-m2[0][5]*m1[1][7]*m0[2][1]-m2[0][5]*m1[1][6]*m0[2][2]-m2[0][5]*m1[1][2]*m0[2][6]-m2[0][5]*m1[1][1]*m0[2][7]+m2[0][4]*m1[2][8]*m0[1][1]+m2[0][4]*m1[2][7]*m0[1][3]+m2[0][4]*m1[2][6]*m0[1][4]+m2[0][4]*m1[2][4]*m0[1][6]+m2[0][4]*m1[2][3]*m0[1][7]+m2[0][4]*m1[2][1]*m0[1][8]-m2[0][4]*m1[1][8]*m0[2][1]-m2[0][4]*m1[1][7]*m0[2][3]-m2[0][4]*m1[1][6]*m0[2][4]-m2[0][4]*m1[1][4]*m0[2][6]-m2[0][4]*m1[1][3]*m0[2][7]-m2[0][4]*m1[1][1]*m0[2][8]+m2[0][3]*m1[2][8]*m0[1][2]+m2[0][3]*m1[2][7]*m0[1][4]+m2[0][3]*m1[2][4]*m0[1][7]+m2[0][3]*m1[2][2]*m0[1][8]-m2[0][3]*m1[1][8]*m0[2][2]-m2[0][3]*m1[1][7]*m0[2][4]-m2[0][3]*m1[1][4]*m0[2][7]-m2[0][3]*m1[1][2]*m0[2][8]+m2[0][2]*m1[2][8]*m0[1][3]+m2[0][2]*m1[2][6]*m0[1][5]+m2[0][2]*m1[2][5]*m0[1][6]+m2[0][2]*m1[2][3]*m0[1][8]-m2[0][2]*m1[1][8]*m0[2][3]-m2[0][2]*m1[1][6]*m0[2][5]-m2[0][2]*m1[1][5]*m0[2][6]-m2[0][2]*m1[1][3]*m0[2][8]+m2[0][1]*m1[2][8]*m0[1][4]+m2[0][1]*m1[2][7]*m0[1][5]+m2[0][1]*m1[2][5]*m0[1][7]+m2[0][1]*m1[2][4]*m0[1][8]-m2[0][1]*m1[1][8]*m0[2][4]-m2[0][1]*m1[1][7]*m0[2][5]-m2[0][1]*m1[1][5]*m0[2][7]-m2[0][1]*m1[1][4]*m0[2][8]; 
  M1(row,42) = m2[2][8]*m1[1][4]*m0[0][2]+m2[2][8]*m1[1][2]*m0[0][4]-m2[2][8]*m1[0][4]*m0[1][2]-m2[2][8]*m1[0][2]*m0[1][4]+m2[2][7]*m1[1][5]*m0[0][2]+m2[2][7]*m1[1][4]*m0[0][4]+m2[2][7]*m1[1][2]*m0[0][5]-m2[2][7]*m1[0][5]*m0[1][2]-m2[2][7]*m1[0][4]*m0[1][4]-m2[2][7]*m1[0][2]*m0[1][5]+m2[2][5]*m1[1][7]*m0[0][2]+m2[2][5]*m1[1][2]*m0[0][7]-m2[2][5]*m1[0][7]*m0[1][2]-m2[2][5]*m1[0][2]*m0[1][7]+m2[2][4]*m1[1][8]*m0[0][2]+m2[2][4]*m1[1][7]*m0[0][4]+m2[2][4]*m1[1][4]*m0[0][7]+m2[2][4]*m1[1][2]*m0[0][8]-m2[2][4]*m1[0][8]*m0[1][2]-m2[2][4]*m1[0][7]*m0[1][4]-m2[2][4]*m1[0][4]*m0[1][7]-m2[2][4]*m1[0][2]*m0[1][8]+m2[2][2]*m1[1][8]*m0[0][4]+m2[2][2]*m1[1][7]*m0[0][5]+m2[2][2]*m1[1][5]*m0[0][7]+m2[2][2]*m1[1][4]*m0[0][8]-m2[2][2]*m1[0][8]*m0[1][4]-m2[2][2]*m1[0][7]*m0[1][5]-m2[2][2]*m1[0][5]*m0[1][7]-m2[2][2]*m1[0][4]*m0[1][8]-m2[1][8]*m1[2][4]*m0[0][2]-m2[1][8]*m1[2][2]*m0[0][4]+m2[1][8]*m1[0][4]*m0[2][2]+m2[1][8]*m1[0][2]*m0[2][4]-m2[1][7]*m1[2][5]*m0[0][2]-m2[1][7]*m1[2][4]*m0[0][4]-m2[1][7]*m1[2][2]*m0[0][5]+m2[1][7]*m1[0][5]*m0[2][2]+m2[1][7]*m1[0][4]*m0[2][4]+m2[1][7]*m1[0][2]*m0[2][5]-m2[1][5]*m1[2][7]*m0[0][2]-m2[1][5]*m1[2][2]*m0[0][7]+m2[1][5]*m1[0][7]*m0[2][2]+m2[1][5]*m1[0][2]*m0[2][7]-m2[1][4]*m1[2][8]*m0[0][2]-m2[1][4]*m1[2][7]*m0[0][4]-m2[1][4]*m1[2][4]*m0[0][7]-m2[1][4]*m1[2][2]*m0[0][8]+m2[1][4]*m1[0][8]*m0[2][2]+m2[1][4]*m1[0][7]*m0[2][4]+m2[1][4]*m1[0][4]*m0[2][7]+m2[1][4]*m1[0][2]*m0[2][8]-m2[1][2]*m1[2][8]*m0[0][4]-m2[1][2]*m1[2][7]*m0[0][5]-m2[1][2]*m1[2][5]*m0[0][7]-m2[1][2]*m1[2][4]*m0[0][8]+m2[1][2]*m1[0][8]*m0[2][4]+m2[1][2]*m1[0][7]*m0[2][5]+m2[1][2]*m1[0][5]*m0[2][7]+m2[1][2]*m1[0][4]*m0[2][8]+m2[0][8]*m1[2][4]*m0[1][2]+m2[0][8]*m1[2][2]*m0[1][4]-m2[0][8]*m1[1][4]*m0[2][2]-m2[0][8]*m1[1][2]*m0[2][4]+m2[0][7]*m1[2][5]*m0[1][2]+m2[0][7]*m1[2][4]*m0[1][4]+m2[0][7]*m1[2][2]*m0[1][5]-m2[0][7]*m1[1][5]*m0[2][2]-m2[0][7]*m1[1][4]*m0[2][4]-m2[0][7]*m1[1][2]*m0[2][5]+m2[0][5]*m1[2][7]*m0[1][2]+m2[0][5]*m1[2][2]*m0[1][7]-m2[0][5]*m1[1][7]*m0[2][2]-m2[0][5]*m1[1][2]*m0[2][7]+m2[0][4]*m1[2][8]*m0[1][2]+m2[0][4]*m1[2][7]*m0[1][4]+m2[0][4]*m1[2][4]*m0[1][7]+m2[0][4]*m1[2][2]*m0[1][8]-m2[0][4]*m1[1][8]*m0[2][2]-m2[0][4]*m1[1][7]*m0[2][4]-m2[0][4]*m1[1][4]*m0[2][7]-m2[0][4]*m1[1][2]*m0[2][8]+m2[0][2]*m1[2][8]*m0[1][4]+m2[0][2]*m1[2][7]*m0[1][5]+m2[0][2]*m1[2][5]*m0[1][7]+m2[0][2]*m1[2][4]*m0[1][8]-m2[0][2]*m1[1][8]*m0[2][4]-m2[0][2]*m1[1][7]*m0[2][5]-m2[0][2]*m1[1][5]*m0[2][7]-m2[0][2]*m1[1][4]*m0[2][8]; 
  M1(row,43) = m2[2][8]*m1[1][5]*m0[0][0]+m2[2][8]*m1[1][3]*m0[0][3]+m2[2][8]*m1[1][0]*m0[0][5]-m2[2][8]*m1[0][5]*m0[1][0]-m2[2][8]*m1[0][3]*m0[1][3]-m2[2][8]*m1[0][0]*m0[1][5]+m2[2][6]*m1[1][5]*m0[0][3]+m2[2][6]*m1[1][3]*m0[0][5]-m2[2][6]*m1[0][5]*m0[1][3]-m2[2][6]*m1[0][3]*m0[1][5]+m2[2][5]*m1[1][8]*m0[0][0]+m2[2][5]*m1[1][6]*m0[0][3]+m2[2][5]*m1[1][3]*m0[0][6]+m2[2][5]*m1[1][0]*m0[0][8]-m2[2][5]*m1[0][8]*m0[1][0]-m2[2][5]*m1[0][6]*m0[1][3]-m2[2][5]*m1[0][3]*m0[1][6]-m2[2][5]*m1[0][0]*m0[1][8]+m2[2][3]*m1[1][8]*m0[0][3]+m2[2][3]*m1[1][6]*m0[0][5]+m2[2][3]*m1[1][5]*m0[0][6]+m2[2][3]*m1[1][3]*m0[0][8]-m2[2][3]*m1[0][8]*m0[1][3]-m2[2][3]*m1[0][6]*m0[1][5]-m2[2][3]*m1[0][5]*m0[1][6]-m2[2][3]*m1[0][3]*m0[1][8]+m2[2][0]*m1[1][8]*m0[0][5]+m2[2][0]*m1[1][5]*m0[0][8]-m2[2][0]*m1[0][8]*m0[1][5]-m2[2][0]*m1[0][5]*m0[1][8]-m2[1][8]*m1[2][5]*m0[0][0]-m2[1][8]*m1[2][3]*m0[0][3]-m2[1][8]*m1[2][0]*m0[0][5]+m2[1][8]*m1[0][5]*m0[2][0]+m2[1][8]*m1[0][3]*m0[2][3]+m2[1][8]*m1[0][0]*m0[2][5]-m2[1][6]*m1[2][5]*m0[0][3]-m2[1][6]*m1[2][3]*m0[0][5]+m2[1][6]*m1[0][5]*m0[2][3]+m2[1][6]*m1[0][3]*m0[2][5]-m2[1][5]*m1[2][8]*m0[0][0]-m2[1][5]*m1[2][6]*m0[0][3]-m2[1][5]*m1[2][3]*m0[0][6]-m2[1][5]*m1[2][0]*m0[0][8]+m2[1][5]*m1[0][8]*m0[2][0]+m2[1][5]*m1[0][6]*m0[2][3]+m2[1][5]*m1[0][3]*m0[2][6]+m2[1][5]*m1[0][0]*m0[2][8]-m2[1][3]*m1[2][8]*m0[0][3]-m2[1][3]*m1[2][6]*m0[0][5]-m2[1][3]*m1[2][5]*m0[0][6]-m2[1][3]*m1[2][3]*m0[0][8]+m2[1][3]*m1[0][8]*m0[2][3]+m2[1][3]*m1[0][6]*m0[2][5]+m2[1][3]*m1[0][5]*m0[2][6]+m2[1][3]*m1[0][3]*m0[2][8]-m2[1][0]*m1[2][8]*m0[0][5]-m2[1][0]*m1[2][5]*m0[0][8]+m2[1][0]*m1[0][8]*m0[2][5]+m2[1][0]*m1[0][5]*m0[2][8]+m2[0][8]*m1[2][5]*m0[1][0]+m2[0][8]*m1[2][3]*m0[1][3]+m2[0][8]*m1[2][0]*m0[1][5]-m2[0][8]*m1[1][5]*m0[2][0]-m2[0][8]*m1[1][3]*m0[2][3]-m2[0][8]*m1[1][0]*m0[2][5]+m2[0][6]*m1[2][5]*m0[1][3]+m2[0][6]*m1[2][3]*m0[1][5]-m2[0][6]*m1[1][5]*m0[2][3]-m2[0][6]*m1[1][3]*m0[2][5]+m2[0][5]*m1[2][8]*m0[1][0]+m2[0][5]*m1[2][6]*m0[1][3]+m2[0][5]*m1[2][3]*m0[1][6]+m2[0][5]*m1[2][0]*m0[1][8]-m2[0][5]*m1[1][8]*m0[2][0]-m2[0][5]*m1[1][6]*m0[2][3]-m2[0][5]*m1[1][3]*m0[2][6]-m2[0][5]*m1[1][0]*m0[2][8]+m2[0][3]*m1[2][8]*m0[1][3]+m2[0][3]*m1[2][6]*m0[1][5]+m2[0][3]*m1[2][5]*m0[1][6]+m2[0][3]*m1[2][3]*m0[1][8]-m2[0][3]*m1[1][8]*m0[2][3]-m2[0][3]*m1[1][6]*m0[2][5]-m2[0][3]*m1[1][5]*m0[2][6]-m2[0][3]*m1[1][3]*m0[2][8]+m2[0][0]*m1[2][8]*m0[1][5]+m2[0][0]*m1[2][5]*m0[1][8]-m2[0][0]*m1[1][8]*m0[2][5]-m2[0][0]*m1[1][5]*m0[2][8]; 
  M1(row,44) = m2[2][8]*m1[1][5]*m0[0][1]+m2[2][8]*m1[1][4]*m0[0][3]+m2[2][8]*m1[1][3]*m0[0][4]+m2[2][8]*m1[1][1]*m0[0][5]-m2[2][8]*m1[0][5]*m0[1][1]-m2[2][8]*m1[0][4]*m0[1][3]-m2[2][8]*m1[0][3]*m0[1][4]-m2[2][8]*m1[0][1]*m0[1][5]+m2[2][7]*m1[1][5]*m0[0][3]+m2[2][7]*m1[1][3]*m0[0][5]-m2[2][7]*m1[0][5]*m0[1][3]-m2[2][7]*m1[0][3]*m0[1][5]+m2[2][6]*m1[1][5]*m0[0][4]+m2[2][6]*m1[1][4]*m0[0][5]-m2[2][6]*m1[0][5]*m0[1][4]-m2[2][6]*m1[0][4]*m0[1][5]+m2[2][5]*m1[1][8]*m0[0][1]+m2[2][5]*m1[1][7]*m0[0][3]+m2[2][5]*m1[1][6]*m0[0][4]+m2[2][5]*m1[1][4]*m0[0][6]+m2[2][5]*m1[1][3]*m0[0][7]+m2[2][5]*m1[1][1]*m0[0][8]-m2[2][5]*m1[0][8]*m0[1][1]-m2[2][5]*m1[0][7]*m0[1][3]-m2[2][5]*m1[0][6]*m0[1][4]-m2[2][5]*m1[0][4]*m0[1][6]-m2[2][5]*m1[0][3]*m0[1][7]-m2[2][5]*m1[0][1]*m0[1][8]+m2[2][4]*m1[1][8]*m0[0][3]+m2[2][4]*m1[1][6]*m0[0][5]+m2[2][4]*m1[1][5]*m0[0][6]+m2[2][4]*m1[1][3]*m0[0][8]-m2[2][4]*m1[0][8]*m0[1][3]-m2[2][4]*m1[0][6]*m0[1][5]-m2[2][4]*m1[0][5]*m0[1][6]-m2[2][4]*m1[0][3]*m0[1][8]+m2[2][3]*m1[1][8]*m0[0][4]+m2[2][3]*m1[1][7]*m0[0][5]+m2[2][3]*m1[1][5]*m0[0][7]+m2[2][3]*m1[1][4]*m0[0][8]-m2[2][3]*m1[0][8]*m0[1][4]-m2[2][3]*m1[0][7]*m0[1][5]-m2[2][3]*m1[0][5]*m0[1][7]-m2[2][3]*m1[0][4]*m0[1][8]+m2[2][1]*m1[1][8]*m0[0][5]+m2[2][1]*m1[1][5]*m0[0][8]-m2[2][1]*m1[0][8]*m0[1][5]-m2[2][1]*m1[0][5]*m0[1][8]-m2[1][8]*m1[2][5]*m0[0][1]-m2[1][8]*m1[2][4]*m0[0][3]-m2[1][8]*m1[2][3]*m0[0][4]-m2[1][8]*m1[2][1]*m0[0][5]+m2[1][8]*m1[0][5]*m0[2][1]+m2[1][8]*m1[0][4]*m0[2][3]+m2[1][8]*m1[0][3]*m0[2][4]+m2[1][8]*m1[0][1]*m0[2][5]-m2[1][7]*m1[2][5]*m0[0][3]-m2[1][7]*m1[2][3]*m0[0][5]+m2[1][7]*m1[0][5]*m0[2][3]+m2[1][7]*m1[0][3]*m0[2][5]-m2[1][6]*m1[2][5]*m0[0][4]-m2[1][6]*m1[2][4]*m0[0][5]+m2[1][6]*m1[0][5]*m0[2][4]+m2[1][6]*m1[0][4]*m0[2][5]-m2[1][5]*m1[2][8]*m0[0][1]-m2[1][5]*m1[2][7]*m0[0][3]-m2[1][5]*m1[2][6]*m0[0][4]-m2[1][5]*m1[2][4]*m0[0][6]-m2[1][5]*m1[2][3]*m0[0][7]-m2[1][5]*m1[2][1]*m0[0][8]+m2[1][5]*m1[0][8]*m0[2][1]+m2[1][5]*m1[0][7]*m0[2][3]+m2[1][5]*m1[0][6]*m0[2][4]+m2[1][5]*m1[0][4]*m0[2][6]+m2[1][5]*m1[0][3]*m0[2][7]+m2[1][5]*m1[0][1]*m0[2][8]-m2[1][4]*m1[2][8]*m0[0][3]-m2[1][4]*m1[2][6]*m0[0][5]-m2[1][4]*m1[2][5]*m0[0][6]-m2[1][4]*m1[2][3]*m0[0][8]+m2[1][4]*m1[0][8]*m0[2][3]+m2[1][4]*m1[0][6]*m0[2][5]+m2[1][4]*m1[0][5]*m0[2][6]+m2[1][4]*m1[0][3]*m0[2][8]-m2[1][3]*m1[2][8]*m0[0][4]-m2[1][3]*m1[2][7]*m0[0][5]-m2[1][3]*m1[2][5]*m0[0][7]-m2[1][3]*m1[2][4]*m0[0][8]+m2[1][3]*m1[0][8]*m0[2][4]+m2[1][3]*m1[0][7]*m0[2][5]+m2[1][3]*m1[0][5]*m0[2][7]+m2[1][3]*m1[0][4]*m0[2][8]-m2[1][1]*m1[2][8]*m0[0][5]-m2[1][1]*m1[2][5]*m0[0][8]+m2[1][1]*m1[0][8]*m0[2][5]+m2[1][1]*m1[0][5]*m0[2][8]+m2[0][8]*m1[2][5]*m0[1][1]+m2[0][8]*m1[2][4]*m0[1][3]+m2[0][8]*m1[2][3]*m0[1][4]+m2[0][8]*m1[2][1]*m0[1][5]-m2[0][8]*m1[1][5]*m0[2][1]-m2[0][8]*m1[1][4]*m0[2][3]-m2[0][8]*m1[1][3]*m0[2][4]-m2[0][8]*m1[1][1]*m0[2][5]+m2[0][7]*m1[2][5]*m0[1][3]+m2[0][7]*m1[2][3]*m0[1][5]-m2[0][7]*m1[1][5]*m0[2][3]-m2[0][7]*m1[1][3]*m0[2][5]+m2[0][6]*m1[2][5]*m0[1][4]+m2[0][6]*m1[2][4]*m0[1][5]-m2[0][6]*m1[1][5]*m0[2][4]-m2[0][6]*m1[1][4]*m0[2][5]+m2[0][5]*m1[2][8]*m0[1][1]+m2[0][5]*m1[2][7]*m0[1][3]+m2[0][5]*m1[2][6]*m0[1][4]+m2[0][5]*m1[2][4]*m0[1][6]+m2[0][5]*m1[2][3]*m0[1][7]+m2[0][5]*m1[2][1]*m0[1][8]-m2[0][5]*m1[1][8]*m0[2][1]-m2[0][5]*m1[1][7]*m0[2][3]-m2[0][5]*m1[1][6]*m0[2][4]-m2[0][5]*m1[1][4]*m0[2][6]-m2[0][5]*m1[1][3]*m0[2][7]-m2[0][5]*m1[1][1]*m0[2][8]+m2[0][4]*m1[2][8]*m0[1][3]+m2[0][4]*m1[2][6]*m0[1][5]+m2[0][4]*m1[2][5]*m0[1][6]+m2[0][4]*m1[2][3]*m0[1][8]-m2[0][4]*m1[1][8]*m0[2][3]-m2[0][4]*m1[1][6]*m0[2][5]-m2[0][4]*m1[1][5]*m0[2][6]-m2[0][4]*m1[1][3]*m0[2][8]+m2[0][3]*m1[2][8]*m0[1][4]+m2[0][3]*m1[2][7]*m0[1][5]+m2[0][3]*m1[2][5]*m0[1][7]+m2[0][3]*m1[2][4]*m0[1][8]-m2[0][3]*m1[1][8]*m0[2][4]-m2[0][3]*m1[1][7]*m0[2][5]-m2[0][3]*m1[1][5]*m0[2][7]-m2[0][3]*m1[1][4]*m0[2][8]+m2[0][1]*m1[2][8]*m0[1][5]+m2[0][1]*m1[2][5]*m0[1][8]-m2[0][1]*m1[1][8]*m0[2][5]-m2[0][1]*m1[1][5]*m0[2][8]; 
  M1(row,45) = m2[2][8]*m1[1][5]*m0[0][2]+m2[2][8]*m1[1][4]*m0[0][4]+m2[2][8]*m1[1][2]*m0[0][5]-m2[2][8]*m1[0][5]*m0[1][2]-m2[2][8]*m1[0][4]*m0[1][4]-m2[2][8]*m1[0][2]*m0[1][5]+m2[2][7]*m1[1][5]*m0[0][4]+m2[2][7]*m1[1][4]*m0[0][5]-m2[2][7]*m1[0][5]*m0[1][4]-m2[2][7]*m1[0][4]*m0[1][5]+m2[2][5]*m1[1][8]*m0[0][2]+m2[2][5]*m1[1][7]*m0[0][4]+m2[2][5]*m1[1][4]*m0[0][7]+m2[2][5]*m1[1][2]*m0[0][8]-m2[2][5]*m1[0][8]*m0[1][2]-m2[2][5]*m1[0][7]*m0[1][4]-m2[2][5]*m1[0][4]*m0[1][7]-m2[2][5]*m1[0][2]*m0[1][8]+m2[2][4]*m1[1][8]*m0[0][4]+m2[2][4]*m1[1][7]*m0[0][5]+m2[2][4]*m1[1][5]*m0[0][7]+m2[2][4]*m1[1][4]*m0[0][8]-m2[2][4]*m1[0][8]*m0[1][4]-m2[2][4]*m1[0][7]*m0[1][5]-m2[2][4]*m1[0][5]*m0[1][7]-m2[2][4]*m1[0][4]*m0[1][8]+m2[2][2]*m1[1][8]*m0[0][5]+m2[2][2]*m1[1][5]*m0[0][8]-m2[2][2]*m1[0][8]*m0[1][5]-m2[2][2]*m1[0][5]*m0[1][8]-m2[1][8]*m1[2][5]*m0[0][2]-m2[1][8]*m1[2][4]*m0[0][4]-m2[1][8]*m1[2][2]*m0[0][5]+m2[1][8]*m1[0][5]*m0[2][2]+m2[1][8]*m1[0][4]*m0[2][4]+m2[1][8]*m1[0][2]*m0[2][5]-m2[1][7]*m1[2][5]*m0[0][4]-m2[1][7]*m1[2][4]*m0[0][5]+m2[1][7]*m1[0][5]*m0[2][4]+m2[1][7]*m1[0][4]*m0[2][5]-m2[1][5]*m1[2][8]*m0[0][2]-m2[1][5]*m1[2][7]*m0[0][4]-m2[1][5]*m1[2][4]*m0[0][7]-m2[1][5]*m1[2][2]*m0[0][8]+m2[1][5]*m1[0][8]*m0[2][2]+m2[1][5]*m1[0][7]*m0[2][4]+m2[1][5]*m1[0][4]*m0[2][7]+m2[1][5]*m1[0][2]*m0[2][8]-m2[1][4]*m1[2][8]*m0[0][4]-m2[1][4]*m1[2][7]*m0[0][5]-m2[1][4]*m1[2][5]*m0[0][7]-m2[1][4]*m1[2][4]*m0[0][8]+m2[1][4]*m1[0][8]*m0[2][4]+m2[1][4]*m1[0][7]*m0[2][5]+m2[1][4]*m1[0][5]*m0[2][7]+m2[1][4]*m1[0][4]*m0[2][8]-m2[1][2]*m1[2][8]*m0[0][5]-m2[1][2]*m1[2][5]*m0[0][8]+m2[1][2]*m1[0][8]*m0[2][5]+m2[1][2]*m1[0][5]*m0[2][8]+m2[0][8]*m1[2][5]*m0[1][2]+m2[0][8]*m1[2][4]*m0[1][4]+m2[0][8]*m1[2][2]*m0[1][5]-m2[0][8]*m1[1][5]*m0[2][2]-m2[0][8]*m1[1][4]*m0[2][4]-m2[0][8]*m1[1][2]*m0[2][5]+m2[0][7]*m1[2][5]*m0[1][4]+m2[0][7]*m1[2][4]*m0[1][5]-m2[0][7]*m1[1][5]*m0[2][4]-m2[0][7]*m1[1][4]*m0[2][5]+m2[0][5]*m1[2][8]*m0[1][2]+m2[0][5]*m1[2][7]*m0[1][4]+m2[0][5]*m1[2][4]*m0[1][7]+m2[0][5]*m1[2][2]*m0[1][8]-m2[0][5]*m1[1][8]*m0[2][2]-m2[0][5]*m1[1][7]*m0[2][4]-m2[0][5]*m1[1][4]*m0[2][7]-m2[0][5]*m1[1][2]*m0[2][8]+m2[0][4]*m1[2][8]*m0[1][4]+m2[0][4]*m1[2][7]*m0[1][5]+m2[0][4]*m1[2][5]*m0[1][7]+m2[0][4]*m1[2][4]*m0[1][8]-m2[0][4]*m1[1][8]*m0[2][4]-m2[0][4]*m1[1][7]*m0[2][5]-m2[0][4]*m1[1][5]*m0[2][7]-m2[0][4]*m1[1][4]*m0[2][8]+m2[0][2]*m1[2][8]*m0[1][5]+m2[0][2]*m1[2][5]*m0[1][8]-m2[0][2]*m1[1][8]*m0[2][5]-m2[0][2]*m1[1][5]*m0[2][8]; 
  M1(row,46) = m2[2][8]*m1[1][5]*m0[0][3]+m2[2][8]*m1[1][3]*m0[0][5]-m2[2][8]*m1[0][5]*m0[1][3]-m2[2][8]*m1[0][3]*m0[1][5]+m2[2][6]*m1[1][5]*m0[0][5]-m2[2][6]*m1[0][5]*m0[1][5]+m2[2][5]*m1[1][8]*m0[0][3]+m2[2][5]*m1[1][6]*m0[0][5]+m2[2][5]*m1[1][5]*m0[0][6]+m2[2][5]*m1[1][3]*m0[0][8]-m2[2][5]*m1[0][8]*m0[1][3]-m2[2][5]*m1[0][6]*m0[1][5]-m2[2][5]*m1[0][5]*m0[1][6]-m2[2][5]*m1[0][3]*m0[1][8]+m2[2][3]*m1[1][8]*m0[0][5]+m2[2][3]*m1[1][5]*m0[0][8]-m2[2][3]*m1[0][8]*m0[1][5]-m2[2][3]*m1[0][5]*m0[1][8]-m2[1][8]*m1[2][5]*m0[0][3]-m2[1][8]*m1[2][3]*m0[0][5]+m2[1][8]*m1[0][5]*m0[2][3]+m2[1][8]*m1[0][3]*m0[2][5]-m2[1][6]*m1[2][5]*m0[0][5]+m2[1][6]*m1[0][5]*m0[2][5]-m2[1][5]*m1[2][8]*m0[0][3]-m2[1][5]*m1[2][6]*m0[0][5]-m2[1][5]*m1[2][5]*m0[0][6]-m2[1][5]*m1[2][3]*m0[0][8]+m2[1][5]*m1[0][8]*m0[2][3]+m2[1][5]*m1[0][6]*m0[2][5]+m2[1][5]*m1[0][5]*m0[2][6]+m2[1][5]*m1[0][3]*m0[2][8]-m2[1][3]*m1[2][8]*m0[0][5]-m2[1][3]*m1[2][5]*m0[0][8]+m2[1][3]*m1[0][8]*m0[2][5]+m2[1][3]*m1[0][5]*m0[2][8]+m2[0][8]*m1[2][5]*m0[1][3]+m2[0][8]*m1[2][3]*m0[1][5]-m2[0][8]*m1[1][5]*m0[2][3]-m2[0][8]*m1[1][3]*m0[2][5]+m2[0][6]*m1[2][5]*m0[1][5]-m2[0][6]*m1[1][5]*m0[2][5]+m2[0][5]*m1[2][8]*m0[1][3]+m2[0][5]*m1[2][6]*m0[1][5]+m2[0][5]*m1[2][5]*m0[1][6]+m2[0][5]*m1[2][3]*m0[1][8]-m2[0][5]*m1[1][8]*m0[2][3]-m2[0][5]*m1[1][6]*m0[2][5]-m2[0][5]*m1[1][5]*m0[2][6]-m2[0][5]*m1[1][3]*m0[2][8]+m2[0][3]*m1[2][8]*m0[1][5]+m2[0][3]*m1[2][5]*m0[1][8]-m2[0][3]*m1[1][8]*m0[2][5]-m2[0][3]*m1[1][5]*m0[2][8]; 
  M1(row,47) = m2[2][8]*m1[1][5]*m0[0][4]+m2[2][8]*m1[1][4]*m0[0][5]-m2[2][8]*m1[0][5]*m0[1][4]-m2[2][8]*m1[0][4]*m0[1][5]+m2[2][7]*m1[1][5]*m0[0][5]-m2[2][7]*m1[0][5]*m0[1][5]+m2[2][5]*m1[1][8]*m0[0][4]+m2[2][5]*m1[1][7]*m0[0][5]+m2[2][5]*m1[1][5]*m0[0][7]+m2[2][5]*m1[1][4]*m0[0][8]-m2[2][5]*m1[0][8]*m0[1][4]-m2[2][5]*m1[0][7]*m0[1][5]-m2[2][5]*m1[0][5]*m0[1][7]-m2[2][5]*m1[0][4]*m0[1][8]+m2[2][4]*m1[1][8]*m0[0][5]+m2[2][4]*m1[1][5]*m0[0][8]-m2[2][4]*m1[0][8]*m0[1][5]-m2[2][4]*m1[0][5]*m0[1][8]-m2[1][8]*m1[2][5]*m0[0][4]-m2[1][8]*m1[2][4]*m0[0][5]+m2[1][8]*m1[0][5]*m0[2][4]+m2[1][8]*m1[0][4]*m0[2][5]-m2[1][7]*m1[2][5]*m0[0][5]+m2[1][7]*m1[0][5]*m0[2][5]-m2[1][5]*m1[2][8]*m0[0][4]-m2[1][5]*m1[2][7]*m0[0][5]-m2[1][5]*m1[2][5]*m0[0][7]-m2[1][5]*m1[2][4]*m0[0][8]+m2[1][5]*m1[0][8]*m0[2][4]+m2[1][5]*m1[0][7]*m0[2][5]+m2[1][5]*m1[0][5]*m0[2][7]+m2[1][5]*m1[0][4]*m0[2][8]-m2[1][4]*m1[2][8]*m0[0][5]-m2[1][4]*m1[2][5]*m0[0][8]+m2[1][4]*m1[0][8]*m0[2][5]+m2[1][4]*m1[0][5]*m0[2][8]+m2[0][8]*m1[2][5]*m0[1][4]+m2[0][8]*m1[2][4]*m0[1][5]-m2[0][8]*m1[1][5]*m0[2][4]-m2[0][8]*m1[1][4]*m0[2][5]+m2[0][7]*m1[2][5]*m0[1][5]-m2[0][7]*m1[1][5]*m0[2][5]+m2[0][5]*m1[2][8]*m0[1][4]+m2[0][5]*m1[2][7]*m0[1][5]+m2[0][5]*m1[2][5]*m0[1][7]+m2[0][5]*m1[2][4]*m0[1][8]-m2[0][5]*m1[1][8]*m0[2][4]-m2[0][5]*m1[1][7]*m0[2][5]-m2[0][5]*m1[1][5]*m0[2][7]-m2[0][5]*m1[1][4]*m0[2][8]+m2[0][4]*m1[2][8]*m0[1][5]+m2[0][4]*m1[2][5]*m0[1][8]-m2[0][4]*m1[1][8]*m0[2][5]-m2[0][4]*m1[1][5]*m0[2][8]; 
  M1(row,48) = m2[2][8]*m1[1][5]*m0[0][5]-m2[2][8]*m1[0][5]*m0[1][5]+m2[2][5]*m1[1][8]*m0[0][5]+m2[2][5]*m1[1][5]*m0[0][8]-m2[2][5]*m1[0][8]*m0[1][5]-m2[2][5]*m1[0][5]*m0[1][8]-m2[1][8]*m1[2][5]*m0[0][5]+m2[1][8]*m1[0][5]*m0[2][5]-m2[1][5]*m1[2][8]*m0[0][5]-m2[1][5]*m1[2][5]*m0[0][8]+m2[1][5]*m1[0][8]*m0[2][5]+m2[1][5]*m1[0][5]*m0[2][8]+m2[0][8]*m1[2][5]*m0[1][5]-m2[0][8]*m1[1][5]*m0[2][5]+m2[0][5]*m1[2][8]*m0[1][5]+m2[0][5]*m1[2][5]*m0[1][8]-m2[0][5]*m1[1][8]*m0[2][5]-m2[0][5]*m1[1][5]*m0[2][8]; 
  M1(row,49) = m2[2][9]*m1[1][0]*m0[0][0]-m2[2][9]*m1[0][0]*m0[1][0]+m2[2][6]*m1[1][6]*m0[0][0]+m2[2][6]*m1[1][0]*m0[0][6]-m2[2][6]*m1[0][6]*m0[1][0]-m2[2][6]*m1[0][0]*m0[1][6]+m2[2][0]*m1[1][9]*m0[0][0]+m2[2][0]*m1[1][6]*m0[0][6]+m2[2][0]*m1[1][0]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][0]-m2[2][0]*m1[0][6]*m0[1][6]-m2[2][0]*m1[0][0]*m0[1][9]-m2[1][9]*m1[2][0]*m0[0][0]+m2[1][9]*m1[0][0]*m0[2][0]-m2[1][6]*m1[2][6]*m0[0][0]-m2[1][6]*m1[2][0]*m0[0][6]+m2[1][6]*m1[0][6]*m0[2][0]+m2[1][6]*m1[0][0]*m0[2][6]-m2[1][0]*m1[2][9]*m0[0][0]-m2[1][0]*m1[2][6]*m0[0][6]-m2[1][0]*m1[2][0]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][0]+m2[1][0]*m1[0][6]*m0[2][6]+m2[1][0]*m1[0][0]*m0[2][9]+m2[0][9]*m1[2][0]*m0[1][0]-m2[0][9]*m1[1][0]*m0[2][0]+m2[0][6]*m1[2][6]*m0[1][0]+m2[0][6]*m1[2][0]*m0[1][6]-m2[0][6]*m1[1][6]*m0[2][0]-m2[0][6]*m1[1][0]*m0[2][6]+m2[0][0]*m1[2][9]*m0[1][0]+m2[0][0]*m1[2][6]*m0[1][6]+m2[0][0]*m1[2][0]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][0]-m2[0][0]*m1[1][6]*m0[2][6]-m2[0][0]*m1[1][0]*m0[2][9]; 
  M1(row,50) = m2[2][9]*m1[1][1]*m0[0][0]+m2[2][9]*m1[1][0]*m0[0][1]-m2[2][9]*m1[0][1]*m0[1][0]-m2[2][9]*m1[0][0]*m0[1][1]+m2[2][7]*m1[1][6]*m0[0][0]+m2[2][7]*m1[1][0]*m0[0][6]-m2[2][7]*m1[0][6]*m0[1][0]-m2[2][7]*m1[0][0]*m0[1][6]+m2[2][6]*m1[1][7]*m0[0][0]+m2[2][6]*m1[1][6]*m0[0][1]+m2[2][6]*m1[1][1]*m0[0][6]+m2[2][6]*m1[1][0]*m0[0][7]-m2[2][6]*m1[0][7]*m0[1][0]-m2[2][6]*m1[0][6]*m0[1][1]-m2[2][6]*m1[0][1]*m0[1][6]-m2[2][6]*m1[0][0]*m0[1][7]+m2[2][1]*m1[1][9]*m0[0][0]+m2[2][1]*m1[1][6]*m0[0][6]+m2[2][1]*m1[1][0]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][0]-m2[2][1]*m1[0][6]*m0[1][6]-m2[2][1]*m1[0][0]*m0[1][9]+m2[2][0]*m1[1][9]*m0[0][1]+m2[2][0]*m1[1][7]*m0[0][6]+m2[2][0]*m1[1][6]*m0[0][7]+m2[2][0]*m1[1][1]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][1]-m2[2][0]*m1[0][7]*m0[1][6]-m2[2][0]*m1[0][6]*m0[1][7]-m2[2][0]*m1[0][1]*m0[1][9]-m2[1][9]*m1[2][1]*m0[0][0]-m2[1][9]*m1[2][0]*m0[0][1]+m2[1][9]*m1[0][1]*m0[2][0]+m2[1][9]*m1[0][0]*m0[2][1]-m2[1][7]*m1[2][6]*m0[0][0]-m2[1][7]*m1[2][0]*m0[0][6]+m2[1][7]*m1[0][6]*m0[2][0]+m2[1][7]*m1[0][0]*m0[2][6]-m2[1][6]*m1[2][7]*m0[0][0]-m2[1][6]*m1[2][6]*m0[0][1]-m2[1][6]*m1[2][1]*m0[0][6]-m2[1][6]*m1[2][0]*m0[0][7]+m2[1][6]*m1[0][7]*m0[2][0]+m2[1][6]*m1[0][6]*m0[2][1]+m2[1][6]*m1[0][1]*m0[2][6]+m2[1][6]*m1[0][0]*m0[2][7]-m2[1][1]*m1[2][9]*m0[0][0]-m2[1][1]*m1[2][6]*m0[0][6]-m2[1][1]*m1[2][0]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][0]+m2[1][1]*m1[0][6]*m0[2][6]+m2[1][1]*m1[0][0]*m0[2][9]-m2[1][0]*m1[2][9]*m0[0][1]-m2[1][0]*m1[2][7]*m0[0][6]-m2[1][0]*m1[2][6]*m0[0][7]-m2[1][0]*m1[2][1]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][1]+m2[1][0]*m1[0][7]*m0[2][6]+m2[1][0]*m1[0][6]*m0[2][7]+m2[1][0]*m1[0][1]*m0[2][9]+m2[0][9]*m1[2][1]*m0[1][0]+m2[0][9]*m1[2][0]*m0[1][1]-m2[0][9]*m1[1][1]*m0[2][0]-m2[0][9]*m1[1][0]*m0[2][1]+m2[0][7]*m1[2][6]*m0[1][0]+m2[0][7]*m1[2][0]*m0[1][6]-m2[0][7]*m1[1][6]*m0[2][0]-m2[0][7]*m1[1][0]*m0[2][6]+m2[0][6]*m1[2][7]*m0[1][0]+m2[0][6]*m1[2][6]*m0[1][1]+m2[0][6]*m1[2][1]*m0[1][6]+m2[0][6]*m1[2][0]*m0[1][7]-m2[0][6]*m1[1][7]*m0[2][0]-m2[0][6]*m1[1][6]*m0[2][1]-m2[0][6]*m1[1][1]*m0[2][6]-m2[0][6]*m1[1][0]*m0[2][7]+m2[0][1]*m1[2][9]*m0[1][0]+m2[0][1]*m1[2][6]*m0[1][6]+m2[0][1]*m1[2][0]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][0]-m2[0][1]*m1[1][6]*m0[2][6]-m2[0][1]*m1[1][0]*m0[2][9]+m2[0][0]*m1[2][9]*m0[1][1]+m2[0][0]*m1[2][7]*m0[1][6]+m2[0][0]*m1[2][6]*m0[1][7]+m2[0][0]*m1[2][1]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][1]-m2[0][0]*m1[1][7]*m0[2][6]-m2[0][0]*m1[1][6]*m0[2][7]-m2[0][0]*m1[1][1]*m0[2][9]; 
  M1(row,51) = m2[2][9]*m1[1][2]*m0[0][0]+m2[2][9]*m1[1][1]*m0[0][1]+m2[2][9]*m1[1][0]*m0[0][2]-m2[2][9]*m1[0][2]*m0[1][0]-m2[2][9]*m1[0][1]*m0[1][1]-m2[2][9]*m1[0][0]*m0[1][2]+m2[2][7]*m1[1][7]*m0[0][0]+m2[2][7]*m1[1][6]*m0[0][1]+m2[2][7]*m1[1][1]*m0[0][6]+m2[2][7]*m1[1][0]*m0[0][7]-m2[2][7]*m1[0][7]*m0[1][0]-m2[2][7]*m1[0][6]*m0[1][1]-m2[2][7]*m1[0][1]*m0[1][6]-m2[2][7]*m1[0][0]*m0[1][7]+m2[2][6]*m1[1][7]*m0[0][1]+m2[2][6]*m1[1][6]*m0[0][2]+m2[2][6]*m1[1][2]*m0[0][6]+m2[2][6]*m1[1][1]*m0[0][7]-m2[2][6]*m1[0][7]*m0[1][1]-m2[2][6]*m1[0][6]*m0[1][2]-m2[2][6]*m1[0][2]*m0[1][6]-m2[2][6]*m1[0][1]*m0[1][7]+m2[2][2]*m1[1][9]*m0[0][0]+m2[2][2]*m1[1][6]*m0[0][6]+m2[2][2]*m1[1][0]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][0]-m2[2][2]*m1[0][6]*m0[1][6]-m2[2][2]*m1[0][0]*m0[1][9]+m2[2][1]*m1[1][9]*m0[0][1]+m2[2][1]*m1[1][7]*m0[0][6]+m2[2][1]*m1[1][6]*m0[0][7]+m2[2][1]*m1[1][1]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][1]-m2[2][1]*m1[0][7]*m0[1][6]-m2[2][1]*m1[0][6]*m0[1][7]-m2[2][1]*m1[0][1]*m0[1][9]+m2[2][0]*m1[1][9]*m0[0][2]+m2[2][0]*m1[1][7]*m0[0][7]+m2[2][0]*m1[1][2]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][2]-m2[2][0]*m1[0][7]*m0[1][7]-m2[2][0]*m1[0][2]*m0[1][9]-m2[1][9]*m1[2][2]*m0[0][0]-m2[1][9]*m1[2][1]*m0[0][1]-m2[1][9]*m1[2][0]*m0[0][2]+m2[1][9]*m1[0][2]*m0[2][0]+m2[1][9]*m1[0][1]*m0[2][1]+m2[1][9]*m1[0][0]*m0[2][2]-m2[1][7]*m1[2][7]*m0[0][0]-m2[1][7]*m1[2][6]*m0[0][1]-m2[1][7]*m1[2][1]*m0[0][6]-m2[1][7]*m1[2][0]*m0[0][7]+m2[1][7]*m1[0][7]*m0[2][0]+m2[1][7]*m1[0][6]*m0[2][1]+m2[1][7]*m1[0][1]*m0[2][6]+m2[1][7]*m1[0][0]*m0[2][7]-m2[1][6]*m1[2][7]*m0[0][1]-m2[1][6]*m1[2][6]*m0[0][2]-m2[1][6]*m1[2][2]*m0[0][6]-m2[1][6]*m1[2][1]*m0[0][7]+m2[1][6]*m1[0][7]*m0[2][1]+m2[1][6]*m1[0][6]*m0[2][2]+m2[1][6]*m1[0][2]*m0[2][6]+m2[1][6]*m1[0][1]*m0[2][7]-m2[1][2]*m1[2][9]*m0[0][0]-m2[1][2]*m1[2][6]*m0[0][6]-m2[1][2]*m1[2][0]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][0]+m2[1][2]*m1[0][6]*m0[2][6]+m2[1][2]*m1[0][0]*m0[2][9]-m2[1][1]*m1[2][9]*m0[0][1]-m2[1][1]*m1[2][7]*m0[0][6]-m2[1][1]*m1[2][6]*m0[0][7]-m2[1][1]*m1[2][1]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][1]+m2[1][1]*m1[0][7]*m0[2][6]+m2[1][1]*m1[0][6]*m0[2][7]+m2[1][1]*m1[0][1]*m0[2][9]-m2[1][0]*m1[2][9]*m0[0][2]-m2[1][0]*m1[2][7]*m0[0][7]-m2[1][0]*m1[2][2]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][2]+m2[1][0]*m1[0][7]*m0[2][7]+m2[1][0]*m1[0][2]*m0[2][9]+m2[0][9]*m1[2][2]*m0[1][0]+m2[0][9]*m1[2][1]*m0[1][1]+m2[0][9]*m1[2][0]*m0[1][2]-m2[0][9]*m1[1][2]*m0[2][0]-m2[0][9]*m1[1][1]*m0[2][1]-m2[0][9]*m1[1][0]*m0[2][2]+m2[0][7]*m1[2][7]*m0[1][0]+m2[0][7]*m1[2][6]*m0[1][1]+m2[0][7]*m1[2][1]*m0[1][6]+m2[0][7]*m1[2][0]*m0[1][7]-m2[0][7]*m1[1][7]*m0[2][0]-m2[0][7]*m1[1][6]*m0[2][1]-m2[0][7]*m1[1][1]*m0[2][6]-m2[0][7]*m1[1][0]*m0[2][7]+m2[0][6]*m1[2][7]*m0[1][1]+m2[0][6]*m1[2][6]*m0[1][2]+m2[0][6]*m1[2][2]*m0[1][6]+m2[0][6]*m1[2][1]*m0[1][7]-m2[0][6]*m1[1][7]*m0[2][1]-m2[0][6]*m1[1][6]*m0[2][2]-m2[0][6]*m1[1][2]*m0[2][6]-m2[0][6]*m1[1][1]*m0[2][7]+m2[0][2]*m1[2][9]*m0[1][0]+m2[0][2]*m1[2][6]*m0[1][6]+m2[0][2]*m1[2][0]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][0]-m2[0][2]*m1[1][6]*m0[2][6]-m2[0][2]*m1[1][0]*m0[2][9]+m2[0][1]*m1[2][9]*m0[1][1]+m2[0][1]*m1[2][7]*m0[1][6]+m2[0][1]*m1[2][6]*m0[1][7]+m2[0][1]*m1[2][1]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][1]-m2[0][1]*m1[1][7]*m0[2][6]-m2[0][1]*m1[1][6]*m0[2][7]-m2[0][1]*m1[1][1]*m0[2][9]+m2[0][0]*m1[2][9]*m0[1][2]+m2[0][0]*m1[2][7]*m0[1][7]+m2[0][0]*m1[2][2]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][2]-m2[0][0]*m1[1][7]*m0[2][7]-m2[0][0]*m1[1][2]*m0[2][9]; 
  M1(row,52) = m2[2][9]*m1[1][2]*m0[0][1]+m2[2][9]*m1[1][1]*m0[0][2]-m2[2][9]*m1[0][2]*m0[1][1]-m2[2][9]*m1[0][1]*m0[1][2]+m2[2][7]*m1[1][7]*m0[0][1]+m2[2][7]*m1[1][6]*m0[0][2]+m2[2][7]*m1[1][2]*m0[0][6]+m2[2][7]*m1[1][1]*m0[0][7]-m2[2][7]*m1[0][7]*m0[1][1]-m2[2][7]*m1[0][6]*m0[1][2]-m2[2][7]*m1[0][2]*m0[1][6]-m2[2][7]*m1[0][1]*m0[1][7]+m2[2][6]*m1[1][7]*m0[0][2]+m2[2][6]*m1[1][2]*m0[0][7]-m2[2][6]*m1[0][7]*m0[1][2]-m2[2][6]*m1[0][2]*m0[1][7]+m2[2][2]*m1[1][9]*m0[0][1]+m2[2][2]*m1[1][7]*m0[0][6]+m2[2][2]*m1[1][6]*m0[0][7]+m2[2][2]*m1[1][1]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][1]-m2[2][2]*m1[0][7]*m0[1][6]-m2[2][2]*m1[0][6]*m0[1][7]-m2[2][2]*m1[0][1]*m0[1][9]+m2[2][1]*m1[1][9]*m0[0][2]+m2[2][1]*m1[1][7]*m0[0][7]+m2[2][1]*m1[1][2]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][2]-m2[2][1]*m1[0][7]*m0[1][7]-m2[2][1]*m1[0][2]*m0[1][9]-m2[1][9]*m1[2][2]*m0[0][1]-m2[1][9]*m1[2][1]*m0[0][2]+m2[1][9]*m1[0][2]*m0[2][1]+m2[1][9]*m1[0][1]*m0[2][2]-m2[1][7]*m1[2][7]*m0[0][1]-m2[1][7]*m1[2][6]*m0[0][2]-m2[1][7]*m1[2][2]*m0[0][6]-m2[1][7]*m1[2][1]*m0[0][7]+m2[1][7]*m1[0][7]*m0[2][1]+m2[1][7]*m1[0][6]*m0[2][2]+m2[1][7]*m1[0][2]*m0[2][6]+m2[1][7]*m1[0][1]*m0[2][7]-m2[1][6]*m1[2][7]*m0[0][2]-m2[1][6]*m1[2][2]*m0[0][7]+m2[1][6]*m1[0][7]*m0[2][2]+m2[1][6]*m1[0][2]*m0[2][7]-m2[1][2]*m1[2][9]*m0[0][1]-m2[1][2]*m1[2][7]*m0[0][6]-m2[1][2]*m1[2][6]*m0[0][7]-m2[1][2]*m1[2][1]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][1]+m2[1][2]*m1[0][7]*m0[2][6]+m2[1][2]*m1[0][6]*m0[2][7]+m2[1][2]*m1[0][1]*m0[2][9]-m2[1][1]*m1[2][9]*m0[0][2]-m2[1][1]*m1[2][7]*m0[0][7]-m2[1][1]*m1[2][2]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][2]+m2[1][1]*m1[0][7]*m0[2][7]+m2[1][1]*m1[0][2]*m0[2][9]+m2[0][9]*m1[2][2]*m0[1][1]+m2[0][9]*m1[2][1]*m0[1][2]-m2[0][9]*m1[1][2]*m0[2][1]-m2[0][9]*m1[1][1]*m0[2][2]+m2[0][7]*m1[2][7]*m0[1][1]+m2[0][7]*m1[2][6]*m0[1][2]+m2[0][7]*m1[2][2]*m0[1][6]+m2[0][7]*m1[2][1]*m0[1][7]-m2[0][7]*m1[1][7]*m0[2][1]-m2[0][7]*m1[1][6]*m0[2][2]-m2[0][7]*m1[1][2]*m0[2][6]-m2[0][7]*m1[1][1]*m0[2][7]+m2[0][6]*m1[2][7]*m0[1][2]+m2[0][6]*m1[2][2]*m0[1][7]-m2[0][6]*m1[1][7]*m0[2][2]-m2[0][6]*m1[1][2]*m0[2][7]+m2[0][2]*m1[2][9]*m0[1][1]+m2[0][2]*m1[2][7]*m0[1][6]+m2[0][2]*m1[2][6]*m0[1][7]+m2[0][2]*m1[2][1]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][1]-m2[0][2]*m1[1][7]*m0[2][6]-m2[0][2]*m1[1][6]*m0[2][7]-m2[0][2]*m1[1][1]*m0[2][9]+m2[0][1]*m1[2][9]*m0[1][2]+m2[0][1]*m1[2][7]*m0[1][7]+m2[0][1]*m1[2][2]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][2]-m2[0][1]*m1[1][7]*m0[2][7]-m2[0][1]*m1[1][2]*m0[2][9]; 
  M1(row,53) = m2[2][9]*m1[1][2]*m0[0][2]-m2[2][9]*m1[0][2]*m0[1][2]+m2[2][7]*m1[1][7]*m0[0][2]+m2[2][7]*m1[1][2]*m0[0][7]-m2[2][7]*m1[0][7]*m0[1][2]-m2[2][7]*m1[0][2]*m0[1][7]+m2[2][2]*m1[1][9]*m0[0][2]+m2[2][2]*m1[1][7]*m0[0][7]+m2[2][2]*m1[1][2]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][2]-m2[2][2]*m1[0][7]*m0[1][7]-m2[2][2]*m1[0][2]*m0[1][9]-m2[1][9]*m1[2][2]*m0[0][2]+m2[1][9]*m1[0][2]*m0[2][2]-m2[1][7]*m1[2][7]*m0[0][2]-m2[1][7]*m1[2][2]*m0[0][7]+m2[1][7]*m1[0][7]*m0[2][2]+m2[1][7]*m1[0][2]*m0[2][7]-m2[1][2]*m1[2][9]*m0[0][2]-m2[1][2]*m1[2][7]*m0[0][7]-m2[1][2]*m1[2][2]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][2]+m2[1][2]*m1[0][7]*m0[2][7]+m2[1][2]*m1[0][2]*m0[2][9]+m2[0][9]*m1[2][2]*m0[1][2]-m2[0][9]*m1[1][2]*m0[2][2]+m2[0][7]*m1[2][7]*m0[1][2]+m2[0][7]*m1[2][2]*m0[1][7]-m2[0][7]*m1[1][7]*m0[2][2]-m2[0][7]*m1[1][2]*m0[2][7]+m2[0][2]*m1[2][9]*m0[1][2]+m2[0][2]*m1[2][7]*m0[1][7]+m2[0][2]*m1[2][2]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][2]-m2[0][2]*m1[1][7]*m0[2][7]-m2[0][2]*m1[1][2]*m0[2][9]; 
  M1(row,54) = m2[2][9]*m1[1][3]*m0[0][0]+m2[2][9]*m1[1][0]*m0[0][3]-m2[2][9]*m1[0][3]*m0[1][0]-m2[2][9]*m1[0][0]*m0[1][3]+m2[2][8]*m1[1][6]*m0[0][0]+m2[2][8]*m1[1][0]*m0[0][6]-m2[2][8]*m1[0][6]*m0[1][0]-m2[2][8]*m1[0][0]*m0[1][6]+m2[2][6]*m1[1][8]*m0[0][0]+m2[2][6]*m1[1][6]*m0[0][3]+m2[2][6]*m1[1][3]*m0[0][6]+m2[2][6]*m1[1][0]*m0[0][8]-m2[2][6]*m1[0][8]*m0[1][0]-m2[2][6]*m1[0][6]*m0[1][3]-m2[2][6]*m1[0][3]*m0[1][6]-m2[2][6]*m1[0][0]*m0[1][8]+m2[2][3]*m1[1][9]*m0[0][0]+m2[2][3]*m1[1][6]*m0[0][6]+m2[2][3]*m1[1][0]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][0]-m2[2][3]*m1[0][6]*m0[1][6]-m2[2][3]*m1[0][0]*m0[1][9]+m2[2][0]*m1[1][9]*m0[0][3]+m2[2][0]*m1[1][8]*m0[0][6]+m2[2][0]*m1[1][6]*m0[0][8]+m2[2][0]*m1[1][3]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][3]-m2[2][0]*m1[0][8]*m0[1][6]-m2[2][0]*m1[0][6]*m0[1][8]-m2[2][0]*m1[0][3]*m0[1][9]-m2[1][9]*m1[2][3]*m0[0][0]-m2[1][9]*m1[2][0]*m0[0][3]+m2[1][9]*m1[0][3]*m0[2][0]+m2[1][9]*m1[0][0]*m0[2][3]-m2[1][8]*m1[2][6]*m0[0][0]-m2[1][8]*m1[2][0]*m0[0][6]+m2[1][8]*m1[0][6]*m0[2][0]+m2[1][8]*m1[0][0]*m0[2][6]-m2[1][6]*m1[2][8]*m0[0][0]-m2[1][6]*m1[2][6]*m0[0][3]-m2[1][6]*m1[2][3]*m0[0][6]-m2[1][6]*m1[2][0]*m0[0][8]+m2[1][6]*m1[0][8]*m0[2][0]+m2[1][6]*m1[0][6]*m0[2][3]+m2[1][6]*m1[0][3]*m0[2][6]+m2[1][6]*m1[0][0]*m0[2][8]-m2[1][3]*m1[2][9]*m0[0][0]-m2[1][3]*m1[2][6]*m0[0][6]-m2[1][3]*m1[2][0]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][0]+m2[1][3]*m1[0][6]*m0[2][6]+m2[1][3]*m1[0][0]*m0[2][9]-m2[1][0]*m1[2][9]*m0[0][3]-m2[1][0]*m1[2][8]*m0[0][6]-m2[1][0]*m1[2][6]*m0[0][8]-m2[1][0]*m1[2][3]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][3]+m2[1][0]*m1[0][8]*m0[2][6]+m2[1][0]*m1[0][6]*m0[2][8]+m2[1][0]*m1[0][3]*m0[2][9]+m2[0][9]*m1[2][3]*m0[1][0]+m2[0][9]*m1[2][0]*m0[1][3]-m2[0][9]*m1[1][3]*m0[2][0]-m2[0][9]*m1[1][0]*m0[2][3]+m2[0][8]*m1[2][6]*m0[1][0]+m2[0][8]*m1[2][0]*m0[1][6]-m2[0][8]*m1[1][6]*m0[2][0]-m2[0][8]*m1[1][0]*m0[2][6]+m2[0][6]*m1[2][8]*m0[1][0]+m2[0][6]*m1[2][6]*m0[1][3]+m2[0][6]*m1[2][3]*m0[1][6]+m2[0][6]*m1[2][0]*m0[1][8]-m2[0][6]*m1[1][8]*m0[2][0]-m2[0][6]*m1[1][6]*m0[2][3]-m2[0][6]*m1[1][3]*m0[2][6]-m2[0][6]*m1[1][0]*m0[2][8]+m2[0][3]*m1[2][9]*m0[1][0]+m2[0][3]*m1[2][6]*m0[1][6]+m2[0][3]*m1[2][0]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][0]-m2[0][3]*m1[1][6]*m0[2][6]-m2[0][3]*m1[1][0]*m0[2][9]+m2[0][0]*m1[2][9]*m0[1][3]+m2[0][0]*m1[2][8]*m0[1][6]+m2[0][0]*m1[2][6]*m0[1][8]+m2[0][0]*m1[2][3]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][3]-m2[0][0]*m1[1][8]*m0[2][6]-m2[0][0]*m1[1][6]*m0[2][8]-m2[0][0]*m1[1][3]*m0[2][9]; 
  M1(row,55) = m2[2][9]*m1[1][4]*m0[0][0]+m2[2][9]*m1[1][3]*m0[0][1]+m2[2][9]*m1[1][1]*m0[0][3]+m2[2][9]*m1[1][0]*m0[0][4]-m2[2][9]*m1[0][4]*m0[1][0]-m2[2][9]*m1[0][3]*m0[1][1]-m2[2][9]*m1[0][1]*m0[1][3]-m2[2][9]*m1[0][0]*m0[1][4]+m2[2][8]*m1[1][7]*m0[0][0]+m2[2][8]*m1[1][6]*m0[0][1]+m2[2][8]*m1[1][1]*m0[0][6]+m2[2][8]*m1[1][0]*m0[0][7]-m2[2][8]*m1[0][7]*m0[1][0]-m2[2][8]*m1[0][6]*m0[1][1]-m2[2][8]*m1[0][1]*m0[1][6]-m2[2][8]*m1[0][0]*m0[1][7]+m2[2][7]*m1[1][8]*m0[0][0]+m2[2][7]*m1[1][6]*m0[0][3]+m2[2][7]*m1[1][3]*m0[0][6]+m2[2][7]*m1[1][0]*m0[0][8]-m2[2][7]*m1[0][8]*m0[1][0]-m2[2][7]*m1[0][6]*m0[1][3]-m2[2][7]*m1[0][3]*m0[1][6]-m2[2][7]*m1[0][0]*m0[1][8]+m2[2][6]*m1[1][8]*m0[0][1]+m2[2][6]*m1[1][7]*m0[0][3]+m2[2][6]*m1[1][6]*m0[0][4]+m2[2][6]*m1[1][4]*m0[0][6]+m2[2][6]*m1[1][3]*m0[0][7]+m2[2][6]*m1[1][1]*m0[0][8]-m2[2][6]*m1[0][8]*m0[1][1]-m2[2][6]*m1[0][7]*m0[1][3]-m2[2][6]*m1[0][6]*m0[1][4]-m2[2][6]*m1[0][4]*m0[1][6]-m2[2][6]*m1[0][3]*m0[1][7]-m2[2][6]*m1[0][1]*m0[1][8]+m2[2][4]*m1[1][9]*m0[0][0]+m2[2][4]*m1[1][6]*m0[0][6]+m2[2][4]*m1[1][0]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][0]-m2[2][4]*m1[0][6]*m0[1][6]-m2[2][4]*m1[0][0]*m0[1][9]+m2[2][3]*m1[1][9]*m0[0][1]+m2[2][3]*m1[1][7]*m0[0][6]+m2[2][3]*m1[1][6]*m0[0][7]+m2[2][3]*m1[1][1]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][1]-m2[2][3]*m1[0][7]*m0[1][6]-m2[2][3]*m1[0][6]*m0[1][7]-m2[2][3]*m1[0][1]*m0[1][9]+m2[2][1]*m1[1][9]*m0[0][3]+m2[2][1]*m1[1][8]*m0[0][6]+m2[2][1]*m1[1][6]*m0[0][8]+m2[2][1]*m1[1][3]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][3]-m2[2][1]*m1[0][8]*m0[1][6]-m2[2][1]*m1[0][6]*m0[1][8]-m2[2][1]*m1[0][3]*m0[1][9]+m2[2][0]*m1[1][9]*m0[0][4]+m2[2][0]*m1[1][8]*m0[0][7]+m2[2][0]*m1[1][7]*m0[0][8]+m2[2][0]*m1[1][4]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][4]-m2[2][0]*m1[0][8]*m0[1][7]-m2[2][0]*m1[0][7]*m0[1][8]-m2[2][0]*m1[0][4]*m0[1][9]-m2[1][9]*m1[2][4]*m0[0][0]-m2[1][9]*m1[2][3]*m0[0][1]-m2[1][9]*m1[2][1]*m0[0][3]-m2[1][9]*m1[2][0]*m0[0][4]+m2[1][9]*m1[0][4]*m0[2][0]+m2[1][9]*m1[0][3]*m0[2][1]+m2[1][9]*m1[0][1]*m0[2][3]+m2[1][9]*m1[0][0]*m0[2][4]-m2[1][8]*m1[2][7]*m0[0][0]-m2[1][8]*m1[2][6]*m0[0][1]-m2[1][8]*m1[2][1]*m0[0][6]-m2[1][8]*m1[2][0]*m0[0][7]+m2[1][8]*m1[0][7]*m0[2][0]+m2[1][8]*m1[0][6]*m0[2][1]+m2[1][8]*m1[0][1]*m0[2][6]+m2[1][8]*m1[0][0]*m0[2][7]-m2[1][7]*m1[2][8]*m0[0][0]-m2[1][7]*m1[2][6]*m0[0][3]-m2[1][7]*m1[2][3]*m0[0][6]-m2[1][7]*m1[2][0]*m0[0][8]+m2[1][7]*m1[0][8]*m0[2][0]+m2[1][7]*m1[0][6]*m0[2][3]+m2[1][7]*m1[0][3]*m0[2][6]+m2[1][7]*m1[0][0]*m0[2][8]-m2[1][6]*m1[2][8]*m0[0][1]-m2[1][6]*m1[2][7]*m0[0][3]-m2[1][6]*m1[2][6]*m0[0][4]-m2[1][6]*m1[2][4]*m0[0][6]-m2[1][6]*m1[2][3]*m0[0][7]-m2[1][6]*m1[2][1]*m0[0][8]+m2[1][6]*m1[0][8]*m0[2][1]+m2[1][6]*m1[0][7]*m0[2][3]+m2[1][6]*m1[0][6]*m0[2][4]+m2[1][6]*m1[0][4]*m0[2][6]+m2[1][6]*m1[0][3]*m0[2][7]+m2[1][6]*m1[0][1]*m0[2][8]-m2[1][4]*m1[2][9]*m0[0][0]-m2[1][4]*m1[2][6]*m0[0][6]-m2[1][4]*m1[2][0]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][0]+m2[1][4]*m1[0][6]*m0[2][6]+m2[1][4]*m1[0][0]*m0[2][9]-m2[1][3]*m1[2][9]*m0[0][1]-m2[1][3]*m1[2][7]*m0[0][6]-m2[1][3]*m1[2][6]*m0[0][7]-m2[1][3]*m1[2][1]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][1]+m2[1][3]*m1[0][7]*m0[2][6]+m2[1][3]*m1[0][6]*m0[2][7]+m2[1][3]*m1[0][1]*m0[2][9]-m2[1][1]*m1[2][9]*m0[0][3]-m2[1][1]*m1[2][8]*m0[0][6]-m2[1][1]*m1[2][6]*m0[0][8]-m2[1][1]*m1[2][3]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][3]+m2[1][1]*m1[0][8]*m0[2][6]+m2[1][1]*m1[0][6]*m0[2][8]+m2[1][1]*m1[0][3]*m0[2][9]-m2[1][0]*m1[2][9]*m0[0][4]-m2[1][0]*m1[2][8]*m0[0][7]-m2[1][0]*m1[2][7]*m0[0][8]-m2[1][0]*m1[2][4]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][4]+m2[1][0]*m1[0][8]*m0[2][7]+m2[1][0]*m1[0][7]*m0[2][8]+m2[1][0]*m1[0][4]*m0[2][9]+m2[0][9]*m1[2][4]*m0[1][0]+m2[0][9]*m1[2][3]*m0[1][1]+m2[0][9]*m1[2][1]*m0[1][3]+m2[0][9]*m1[2][0]*m0[1][4]-m2[0][9]*m1[1][4]*m0[2][0]-m2[0][9]*m1[1][3]*m0[2][1]-m2[0][9]*m1[1][1]*m0[2][3]-m2[0][9]*m1[1][0]*m0[2][4]+m2[0][8]*m1[2][7]*m0[1][0]+m2[0][8]*m1[2][6]*m0[1][1]+m2[0][8]*m1[2][1]*m0[1][6]+m2[0][8]*m1[2][0]*m0[1][7]-m2[0][8]*m1[1][7]*m0[2][0]-m2[0][8]*m1[1][6]*m0[2][1]-m2[0][8]*m1[1][1]*m0[2][6]-m2[0][8]*m1[1][0]*m0[2][7]+m2[0][7]*m1[2][8]*m0[1][0]+m2[0][7]*m1[2][6]*m0[1][3]+m2[0][7]*m1[2][3]*m0[1][6]+m2[0][7]*m1[2][0]*m0[1][8]-m2[0][7]*m1[1][8]*m0[2][0]-m2[0][7]*m1[1][6]*m0[2][3]-m2[0][7]*m1[1][3]*m0[2][6]-m2[0][7]*m1[1][0]*m0[2][8]+m2[0][6]*m1[2][8]*m0[1][1]+m2[0][6]*m1[2][7]*m0[1][3]+m2[0][6]*m1[2][6]*m0[1][4]+m2[0][6]*m1[2][4]*m0[1][6]+m2[0][6]*m1[2][3]*m0[1][7]+m2[0][6]*m1[2][1]*m0[1][8]-m2[0][6]*m1[1][8]*m0[2][1]-m2[0][6]*m1[1][7]*m0[2][3]-m2[0][6]*m1[1][6]*m0[2][4]-m2[0][6]*m1[1][4]*m0[2][6]-m2[0][6]*m1[1][3]*m0[2][7]-m2[0][6]*m1[1][1]*m0[2][8]+m2[0][4]*m1[2][9]*m0[1][0]+m2[0][4]*m1[2][6]*m0[1][6]+m2[0][4]*m1[2][0]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][0]-m2[0][4]*m1[1][6]*m0[2][6]-m2[0][4]*m1[1][0]*m0[2][9]+m2[0][3]*m1[2][9]*m0[1][1]+m2[0][3]*m1[2][7]*m0[1][6]+m2[0][3]*m1[2][6]*m0[1][7]+m2[0][3]*m1[2][1]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][1]-m2[0][3]*m1[1][7]*m0[2][6]-m2[0][3]*m1[1][6]*m0[2][7]-m2[0][3]*m1[1][1]*m0[2][9]+m2[0][1]*m1[2][9]*m0[1][3]+m2[0][1]*m1[2][8]*m0[1][6]+m2[0][1]*m1[2][6]*m0[1][8]+m2[0][1]*m1[2][3]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][3]-m2[0][1]*m1[1][8]*m0[2][6]-m2[0][1]*m1[1][6]*m0[2][8]-m2[0][1]*m1[1][3]*m0[2][9]+m2[0][0]*m1[2][9]*m0[1][4]+m2[0][0]*m1[2][8]*m0[1][7]+m2[0][0]*m1[2][7]*m0[1][8]+m2[0][0]*m1[2][4]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][4]-m2[0][0]*m1[1][8]*m0[2][7]-m2[0][0]*m1[1][7]*m0[2][8]-m2[0][0]*m1[1][4]*m0[2][9]; 
  M1(row,56) = m2[2][9]*m1[1][4]*m0[0][1]+m2[2][9]*m1[1][3]*m0[0][2]+m2[2][9]*m1[1][2]*m0[0][3]+m2[2][9]*m1[1][1]*m0[0][4]-m2[2][9]*m1[0][4]*m0[1][1]-m2[2][9]*m1[0][3]*m0[1][2]-m2[2][9]*m1[0][2]*m0[1][3]-m2[2][9]*m1[0][1]*m0[1][4]+m2[2][8]*m1[1][7]*m0[0][1]+m2[2][8]*m1[1][6]*m0[0][2]+m2[2][8]*m1[1][2]*m0[0][6]+m2[2][8]*m1[1][1]*m0[0][7]-m2[2][8]*m1[0][7]*m0[1][1]-m2[2][8]*m1[0][6]*m0[1][2]-m2[2][8]*m1[0][2]*m0[1][6]-m2[2][8]*m1[0][1]*m0[1][7]+m2[2][7]*m1[1][8]*m0[0][1]+m2[2][7]*m1[1][7]*m0[0][3]+m2[2][7]*m1[1][6]*m0[0][4]+m2[2][7]*m1[1][4]*m0[0][6]+m2[2][7]*m1[1][3]*m0[0][7]+m2[2][7]*m1[1][1]*m0[0][8]-m2[2][7]*m1[0][8]*m0[1][1]-m2[2][7]*m1[0][7]*m0[1][3]-m2[2][7]*m1[0][6]*m0[1][4]-m2[2][7]*m1[0][4]*m0[1][6]-m2[2][7]*m1[0][3]*m0[1][7]-m2[2][7]*m1[0][1]*m0[1][8]+m2[2][6]*m1[1][8]*m0[0][2]+m2[2][6]*m1[1][7]*m0[0][4]+m2[2][6]*m1[1][4]*m0[0][7]+m2[2][6]*m1[1][2]*m0[0][8]-m2[2][6]*m1[0][8]*m0[1][2]-m2[2][6]*m1[0][7]*m0[1][4]-m2[2][6]*m1[0][4]*m0[1][7]-m2[2][6]*m1[0][2]*m0[1][8]+m2[2][4]*m1[1][9]*m0[0][1]+m2[2][4]*m1[1][7]*m0[0][6]+m2[2][4]*m1[1][6]*m0[0][7]+m2[2][4]*m1[1][1]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][1]-m2[2][4]*m1[0][7]*m0[1][6]-m2[2][4]*m1[0][6]*m0[1][7]-m2[2][4]*m1[0][1]*m0[1][9]+m2[2][3]*m1[1][9]*m0[0][2]+m2[2][3]*m1[1][7]*m0[0][7]+m2[2][3]*m1[1][2]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][2]-m2[2][3]*m1[0][7]*m0[1][7]-m2[2][3]*m1[0][2]*m0[1][9]+m2[2][2]*m1[1][9]*m0[0][3]+m2[2][2]*m1[1][8]*m0[0][6]+m2[2][2]*m1[1][6]*m0[0][8]+m2[2][2]*m1[1][3]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][3]-m2[2][2]*m1[0][8]*m0[1][6]-m2[2][2]*m1[0][6]*m0[1][8]-m2[2][2]*m1[0][3]*m0[1][9]+m2[2][1]*m1[1][9]*m0[0][4]+m2[2][1]*m1[1][8]*m0[0][7]+m2[2][1]*m1[1][7]*m0[0][8]+m2[2][1]*m1[1][4]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][4]-m2[2][1]*m1[0][8]*m0[1][7]-m2[2][1]*m1[0][7]*m0[1][8]-m2[2][1]*m1[0][4]*m0[1][9]-m2[1][9]*m1[2][4]*m0[0][1]-m2[1][9]*m1[2][3]*m0[0][2]-m2[1][9]*m1[2][2]*m0[0][3]-m2[1][9]*m1[2][1]*m0[0][4]+m2[1][9]*m1[0][4]*m0[2][1]+m2[1][9]*m1[0][3]*m0[2][2]+m2[1][9]*m1[0][2]*m0[2][3]+m2[1][9]*m1[0][1]*m0[2][4]-m2[1][8]*m1[2][7]*m0[0][1]-m2[1][8]*m1[2][6]*m0[0][2]-m2[1][8]*m1[2][2]*m0[0][6]-m2[1][8]*m1[2][1]*m0[0][7]+m2[1][8]*m1[0][7]*m0[2][1]+m2[1][8]*m1[0][6]*m0[2][2]+m2[1][8]*m1[0][2]*m0[2][6]+m2[1][8]*m1[0][1]*m0[2][7]-m2[1][7]*m1[2][8]*m0[0][1]-m2[1][7]*m1[2][7]*m0[0][3]-m2[1][7]*m1[2][6]*m0[0][4]-m2[1][7]*m1[2][4]*m0[0][6]-m2[1][7]*m1[2][3]*m0[0][7]-m2[1][7]*m1[2][1]*m0[0][8]+m2[1][7]*m1[0][8]*m0[2][1]+m2[1][7]*m1[0][7]*m0[2][3]+m2[1][7]*m1[0][6]*m0[2][4]+m2[1][7]*m1[0][4]*m0[2][6]+m2[1][7]*m1[0][3]*m0[2][7]+m2[1][7]*m1[0][1]*m0[2][8]-m2[1][6]*m1[2][8]*m0[0][2]-m2[1][6]*m1[2][7]*m0[0][4]-m2[1][6]*m1[2][4]*m0[0][7]-m2[1][6]*m1[2][2]*m0[0][8]+m2[1][6]*m1[0][8]*m0[2][2]+m2[1][6]*m1[0][7]*m0[2][4]+m2[1][6]*m1[0][4]*m0[2][7]+m2[1][6]*m1[0][2]*m0[2][8]-m2[1][4]*m1[2][9]*m0[0][1]-m2[1][4]*m1[2][7]*m0[0][6]-m2[1][4]*m1[2][6]*m0[0][7]-m2[1][4]*m1[2][1]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][1]+m2[1][4]*m1[0][7]*m0[2][6]+m2[1][4]*m1[0][6]*m0[2][7]+m2[1][4]*m1[0][1]*m0[2][9]-m2[1][3]*m1[2][9]*m0[0][2]-m2[1][3]*m1[2][7]*m0[0][7]-m2[1][3]*m1[2][2]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][2]+m2[1][3]*m1[0][7]*m0[2][7]+m2[1][3]*m1[0][2]*m0[2][9]-m2[1][2]*m1[2][9]*m0[0][3]-m2[1][2]*m1[2][8]*m0[0][6]-m2[1][2]*m1[2][6]*m0[0][8]-m2[1][2]*m1[2][3]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][3]+m2[1][2]*m1[0][8]*m0[2][6]+m2[1][2]*m1[0][6]*m0[2][8]+m2[1][2]*m1[0][3]*m0[2][9]-m2[1][1]*m1[2][9]*m0[0][4]-m2[1][1]*m1[2][8]*m0[0][7]-m2[1][1]*m1[2][7]*m0[0][8]-m2[1][1]*m1[2][4]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][4]+m2[1][1]*m1[0][8]*m0[2][7]+m2[1][1]*m1[0][7]*m0[2][8]+m2[1][1]*m1[0][4]*m0[2][9]+m2[0][9]*m1[2][4]*m0[1][1]+m2[0][9]*m1[2][3]*m0[1][2]+m2[0][9]*m1[2][2]*m0[1][3]+m2[0][9]*m1[2][1]*m0[1][4]-m2[0][9]*m1[1][4]*m0[2][1]-m2[0][9]*m1[1][3]*m0[2][2]-m2[0][9]*m1[1][2]*m0[2][3]-m2[0][9]*m1[1][1]*m0[2][4]+m2[0][8]*m1[2][7]*m0[1][1]+m2[0][8]*m1[2][6]*m0[1][2]+m2[0][8]*m1[2][2]*m0[1][6]+m2[0][8]*m1[2][1]*m0[1][7]-m2[0][8]*m1[1][7]*m0[2][1]-m2[0][8]*m1[1][6]*m0[2][2]-m2[0][8]*m1[1][2]*m0[2][6]-m2[0][8]*m1[1][1]*m0[2][7]+m2[0][7]*m1[2][8]*m0[1][1]+m2[0][7]*m1[2][7]*m0[1][3]+m2[0][7]*m1[2][6]*m0[1][4]+m2[0][7]*m1[2][4]*m0[1][6]+m2[0][7]*m1[2][3]*m0[1][7]+m2[0][7]*m1[2][1]*m0[1][8]-m2[0][7]*m1[1][8]*m0[2][1]-m2[0][7]*m1[1][7]*m0[2][3]-m2[0][7]*m1[1][6]*m0[2][4]-m2[0][7]*m1[1][4]*m0[2][6]-m2[0][7]*m1[1][3]*m0[2][7]-m2[0][7]*m1[1][1]*m0[2][8]+m2[0][6]*m1[2][8]*m0[1][2]+m2[0][6]*m1[2][7]*m0[1][4]+m2[0][6]*m1[2][4]*m0[1][7]+m2[0][6]*m1[2][2]*m0[1][8]-m2[0][6]*m1[1][8]*m0[2][2]-m2[0][6]*m1[1][7]*m0[2][4]-m2[0][6]*m1[1][4]*m0[2][7]-m2[0][6]*m1[1][2]*m0[2][8]+m2[0][4]*m1[2][9]*m0[1][1]+m2[0][4]*m1[2][7]*m0[1][6]+m2[0][4]*m1[2][6]*m0[1][7]+m2[0][4]*m1[2][1]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][1]-m2[0][4]*m1[1][7]*m0[2][6]-m2[0][4]*m1[1][6]*m0[2][7]-m2[0][4]*m1[1][1]*m0[2][9]+m2[0][3]*m1[2][9]*m0[1][2]+m2[0][3]*m1[2][7]*m0[1][7]+m2[0][3]*m1[2][2]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][2]-m2[0][3]*m1[1][7]*m0[2][7]-m2[0][3]*m1[1][2]*m0[2][9]+m2[0][2]*m1[2][9]*m0[1][3]+m2[0][2]*m1[2][8]*m0[1][6]+m2[0][2]*m1[2][6]*m0[1][8]+m2[0][2]*m1[2][3]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][3]-m2[0][2]*m1[1][8]*m0[2][6]-m2[0][2]*m1[1][6]*m0[2][8]-m2[0][2]*m1[1][3]*m0[2][9]+m2[0][1]*m1[2][9]*m0[1][4]+m2[0][1]*m1[2][8]*m0[1][7]+m2[0][1]*m1[2][7]*m0[1][8]+m2[0][1]*m1[2][4]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][4]-m2[0][1]*m1[1][8]*m0[2][7]-m2[0][1]*m1[1][7]*m0[2][8]-m2[0][1]*m1[1][4]*m0[2][9]; 
  M1(row,57) = m2[2][9]*m1[1][4]*m0[0][2]+m2[2][9]*m1[1][2]*m0[0][4]-m2[2][9]*m1[0][4]*m0[1][2]-m2[2][9]*m1[0][2]*m0[1][4]+m2[2][8]*m1[1][7]*m0[0][2]+m2[2][8]*m1[1][2]*m0[0][7]-m2[2][8]*m1[0][7]*m0[1][2]-m2[2][8]*m1[0][2]*m0[1][7]+m2[2][7]*m1[1][8]*m0[0][2]+m2[2][7]*m1[1][7]*m0[0][4]+m2[2][7]*m1[1][4]*m0[0][7]+m2[2][7]*m1[1][2]*m0[0][8]-m2[2][7]*m1[0][8]*m0[1][2]-m2[2][7]*m1[0][7]*m0[1][4]-m2[2][7]*m1[0][4]*m0[1][7]-m2[2][7]*m1[0][2]*m0[1][8]+m2[2][4]*m1[1][9]*m0[0][2]+m2[2][4]*m1[1][7]*m0[0][7]+m2[2][4]*m1[1][2]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][2]-m2[2][4]*m1[0][7]*m0[1][7]-m2[2][4]*m1[0][2]*m0[1][9]+m2[2][2]*m1[1][9]*m0[0][4]+m2[2][2]*m1[1][8]*m0[0][7]+m2[2][2]*m1[1][7]*m0[0][8]+m2[2][2]*m1[1][4]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][4]-m2[2][2]*m1[0][8]*m0[1][7]-m2[2][2]*m1[0][7]*m0[1][8]-m2[2][2]*m1[0][4]*m0[1][9]-m2[1][9]*m1[2][4]*m0[0][2]-m2[1][9]*m1[2][2]*m0[0][4]+m2[1][9]*m1[0][4]*m0[2][2]+m2[1][9]*m1[0][2]*m0[2][4]-m2[1][8]*m1[2][7]*m0[0][2]-m2[1][8]*m1[2][2]*m0[0][7]+m2[1][8]*m1[0][7]*m0[2][2]+m2[1][8]*m1[0][2]*m0[2][7]-m2[1][7]*m1[2][8]*m0[0][2]-m2[1][7]*m1[2][7]*m0[0][4]-m2[1][7]*m1[2][4]*m0[0][7]-m2[1][7]*m1[2][2]*m0[0][8]+m2[1][7]*m1[0][8]*m0[2][2]+m2[1][7]*m1[0][7]*m0[2][4]+m2[1][7]*m1[0][4]*m0[2][7]+m2[1][7]*m1[0][2]*m0[2][8]-m2[1][4]*m1[2][9]*m0[0][2]-m2[1][4]*m1[2][7]*m0[0][7]-m2[1][4]*m1[2][2]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][2]+m2[1][4]*m1[0][7]*m0[2][7]+m2[1][4]*m1[0][2]*m0[2][9]-m2[1][2]*m1[2][9]*m0[0][4]-m2[1][2]*m1[2][8]*m0[0][7]-m2[1][2]*m1[2][7]*m0[0][8]-m2[1][2]*m1[2][4]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][4]+m2[1][2]*m1[0][8]*m0[2][7]+m2[1][2]*m1[0][7]*m0[2][8]+m2[1][2]*m1[0][4]*m0[2][9]+m2[0][9]*m1[2][4]*m0[1][2]+m2[0][9]*m1[2][2]*m0[1][4]-m2[0][9]*m1[1][4]*m0[2][2]-m2[0][9]*m1[1][2]*m0[2][4]+m2[0][8]*m1[2][7]*m0[1][2]+m2[0][8]*m1[2][2]*m0[1][7]-m2[0][8]*m1[1][7]*m0[2][2]-m2[0][8]*m1[1][2]*m0[2][7]+m2[0][7]*m1[2][8]*m0[1][2]+m2[0][7]*m1[2][7]*m0[1][4]+m2[0][7]*m1[2][4]*m0[1][7]+m2[0][7]*m1[2][2]*m0[1][8]-m2[0][7]*m1[1][8]*m0[2][2]-m2[0][7]*m1[1][7]*m0[2][4]-m2[0][7]*m1[1][4]*m0[2][7]-m2[0][7]*m1[1][2]*m0[2][8]+m2[0][4]*m1[2][9]*m0[1][2]+m2[0][4]*m1[2][7]*m0[1][7]+m2[0][4]*m1[2][2]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][2]-m2[0][4]*m1[1][7]*m0[2][7]-m2[0][4]*m1[1][2]*m0[2][9]+m2[0][2]*m1[2][9]*m0[1][4]+m2[0][2]*m1[2][8]*m0[1][7]+m2[0][2]*m1[2][7]*m0[1][8]+m2[0][2]*m1[2][4]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][4]-m2[0][2]*m1[1][8]*m0[2][7]-m2[0][2]*m1[1][7]*m0[2][8]-m2[0][2]*m1[1][4]*m0[2][9]; 
  M1(row,58) = m2[2][9]*m1[1][5]*m0[0][0]+m2[2][9]*m1[1][3]*m0[0][3]+m2[2][9]*m1[1][0]*m0[0][5]-m2[2][9]*m1[0][5]*m0[1][0]-m2[2][9]*m1[0][3]*m0[1][3]-m2[2][9]*m1[0][0]*m0[1][5]+m2[2][8]*m1[1][8]*m0[0][0]+m2[2][8]*m1[1][6]*m0[0][3]+m2[2][8]*m1[1][3]*m0[0][6]+m2[2][8]*m1[1][0]*m0[0][8]-m2[2][8]*m1[0][8]*m0[1][0]-m2[2][8]*m1[0][6]*m0[1][3]-m2[2][8]*m1[0][3]*m0[1][6]-m2[2][8]*m1[0][0]*m0[1][8]+m2[2][6]*m1[1][8]*m0[0][3]+m2[2][6]*m1[1][6]*m0[0][5]+m2[2][6]*m1[1][5]*m0[0][6]+m2[2][6]*m1[1][3]*m0[0][8]-m2[2][6]*m1[0][8]*m0[1][3]-m2[2][6]*m1[0][6]*m0[1][5]-m2[2][6]*m1[0][5]*m0[1][6]-m2[2][6]*m1[0][3]*m0[1][8]+m2[2][5]*m1[1][9]*m0[0][0]+m2[2][5]*m1[1][6]*m0[0][6]+m2[2][5]*m1[1][0]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][0]-m2[2][5]*m1[0][6]*m0[1][6]-m2[2][5]*m1[0][0]*m0[1][9]+m2[2][3]*m1[1][9]*m0[0][3]+m2[2][3]*m1[1][8]*m0[0][6]+m2[2][3]*m1[1][6]*m0[0][8]+m2[2][3]*m1[1][3]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][3]-m2[2][3]*m1[0][8]*m0[1][6]-m2[2][3]*m1[0][6]*m0[1][8]-m2[2][3]*m1[0][3]*m0[1][9]+m2[2][0]*m1[1][9]*m0[0][5]+m2[2][0]*m1[1][8]*m0[0][8]+m2[2][0]*m1[1][5]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][5]-m2[2][0]*m1[0][8]*m0[1][8]-m2[2][0]*m1[0][5]*m0[1][9]-m2[1][9]*m1[2][5]*m0[0][0]-m2[1][9]*m1[2][3]*m0[0][3]-m2[1][9]*m1[2][0]*m0[0][5]+m2[1][9]*m1[0][5]*m0[2][0]+m2[1][9]*m1[0][3]*m0[2][3]+m2[1][9]*m1[0][0]*m0[2][5]-m2[1][8]*m1[2][8]*m0[0][0]-m2[1][8]*m1[2][6]*m0[0][3]-m2[1][8]*m1[2][3]*m0[0][6]-m2[1][8]*m1[2][0]*m0[0][8]+m2[1][8]*m1[0][8]*m0[2][0]+m2[1][8]*m1[0][6]*m0[2][3]+m2[1][8]*m1[0][3]*m0[2][6]+m2[1][8]*m1[0][0]*m0[2][8]-m2[1][6]*m1[2][8]*m0[0][3]-m2[1][6]*m1[2][6]*m0[0][5]-m2[1][6]*m1[2][5]*m0[0][6]-m2[1][6]*m1[2][3]*m0[0][8]+m2[1][6]*m1[0][8]*m0[2][3]+m2[1][6]*m1[0][6]*m0[2][5]+m2[1][6]*m1[0][5]*m0[2][6]+m2[1][6]*m1[0][3]*m0[2][8]-m2[1][5]*m1[2][9]*m0[0][0]-m2[1][5]*m1[2][6]*m0[0][6]-m2[1][5]*m1[2][0]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][0]+m2[1][5]*m1[0][6]*m0[2][6]+m2[1][5]*m1[0][0]*m0[2][9]-m2[1][3]*m1[2][9]*m0[0][3]-m2[1][3]*m1[2][8]*m0[0][6]-m2[1][3]*m1[2][6]*m0[0][8]-m2[1][3]*m1[2][3]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][3]+m2[1][3]*m1[0][8]*m0[2][6]+m2[1][3]*m1[0][6]*m0[2][8]+m2[1][3]*m1[0][3]*m0[2][9]-m2[1][0]*m1[2][9]*m0[0][5]-m2[1][0]*m1[2][8]*m0[0][8]-m2[1][0]*m1[2][5]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][5]+m2[1][0]*m1[0][8]*m0[2][8]+m2[1][0]*m1[0][5]*m0[2][9]+m2[0][9]*m1[2][5]*m0[1][0]+m2[0][9]*m1[2][3]*m0[1][3]+m2[0][9]*m1[2][0]*m0[1][5]-m2[0][9]*m1[1][5]*m0[2][0]-m2[0][9]*m1[1][3]*m0[2][3]-m2[0][9]*m1[1][0]*m0[2][5]+m2[0][8]*m1[2][8]*m0[1][0]+m2[0][8]*m1[2][6]*m0[1][3]+m2[0][8]*m1[2][3]*m0[1][6]+m2[0][8]*m1[2][0]*m0[1][8]-m2[0][8]*m1[1][8]*m0[2][0]-m2[0][8]*m1[1][6]*m0[2][3]-m2[0][8]*m1[1][3]*m0[2][6]-m2[0][8]*m1[1][0]*m0[2][8]+m2[0][6]*m1[2][8]*m0[1][3]+m2[0][6]*m1[2][6]*m0[1][5]+m2[0][6]*m1[2][5]*m0[1][6]+m2[0][6]*m1[2][3]*m0[1][8]-m2[0][6]*m1[1][8]*m0[2][3]-m2[0][6]*m1[1][6]*m0[2][5]-m2[0][6]*m1[1][5]*m0[2][6]-m2[0][6]*m1[1][3]*m0[2][8]+m2[0][5]*m1[2][9]*m0[1][0]+m2[0][5]*m1[2][6]*m0[1][6]+m2[0][5]*m1[2][0]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][0]-m2[0][5]*m1[1][6]*m0[2][6]-m2[0][5]*m1[1][0]*m0[2][9]+m2[0][3]*m1[2][9]*m0[1][3]+m2[0][3]*m1[2][8]*m0[1][6]+m2[0][3]*m1[2][6]*m0[1][8]+m2[0][3]*m1[2][3]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][3]-m2[0][3]*m1[1][8]*m0[2][6]-m2[0][3]*m1[1][6]*m0[2][8]-m2[0][3]*m1[1][3]*m0[2][9]+m2[0][0]*m1[2][9]*m0[1][5]+m2[0][0]*m1[2][8]*m0[1][8]+m2[0][0]*m1[2][5]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][5]-m2[0][0]*m1[1][8]*m0[2][8]-m2[0][0]*m1[1][5]*m0[2][9]; 
  M1(row,59) = m2[2][9]*m1[1][5]*m0[0][1]+m2[2][9]*m1[1][4]*m0[0][3]+m2[2][9]*m1[1][3]*m0[0][4]+m2[2][9]*m1[1][1]*m0[0][5]-m2[2][9]*m1[0][5]*m0[1][1]-m2[2][9]*m1[0][4]*m0[1][3]-m2[2][9]*m1[0][3]*m0[1][4]-m2[2][9]*m1[0][1]*m0[1][5]+m2[2][8]*m1[1][8]*m0[0][1]+m2[2][8]*m1[1][7]*m0[0][3]+m2[2][8]*m1[1][6]*m0[0][4]+m2[2][8]*m1[1][4]*m0[0][6]+m2[2][8]*m1[1][3]*m0[0][7]+m2[2][8]*m1[1][1]*m0[0][8]-m2[2][8]*m1[0][8]*m0[1][1]-m2[2][8]*m1[0][7]*m0[1][3]-m2[2][8]*m1[0][6]*m0[1][4]-m2[2][8]*m1[0][4]*m0[1][6]-m2[2][8]*m1[0][3]*m0[1][7]-m2[2][8]*m1[0][1]*m0[1][8]+m2[2][7]*m1[1][8]*m0[0][3]+m2[2][7]*m1[1][6]*m0[0][5]+m2[2][7]*m1[1][5]*m0[0][6]+m2[2][7]*m1[1][3]*m0[0][8]-m2[2][7]*m1[0][8]*m0[1][3]-m2[2][7]*m1[0][6]*m0[1][5]-m2[2][7]*m1[0][5]*m0[1][6]-m2[2][7]*m1[0][3]*m0[1][8]+m2[2][6]*m1[1][8]*m0[0][4]+m2[2][6]*m1[1][7]*m0[0][5]+m2[2][6]*m1[1][5]*m0[0][7]+m2[2][6]*m1[1][4]*m0[0][8]-m2[2][6]*m1[0][8]*m0[1][4]-m2[2][6]*m1[0][7]*m0[1][5]-m2[2][6]*m1[0][5]*m0[1][7]-m2[2][6]*m1[0][4]*m0[1][8]+m2[2][5]*m1[1][9]*m0[0][1]+m2[2][5]*m1[1][7]*m0[0][6]+m2[2][5]*m1[1][6]*m0[0][7]+m2[2][5]*m1[1][1]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][1]-m2[2][5]*m1[0][7]*m0[1][6]-m2[2][5]*m1[0][6]*m0[1][7]-m2[2][5]*m1[0][1]*m0[1][9]+m2[2][4]*m1[1][9]*m0[0][3]+m2[2][4]*m1[1][8]*m0[0][6]+m2[2][4]*m1[1][6]*m0[0][8]+m2[2][4]*m1[1][3]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][3]-m2[2][4]*m1[0][8]*m0[1][6]-m2[2][4]*m1[0][6]*m0[1][8]-m2[2][4]*m1[0][3]*m0[1][9]+m2[2][3]*m1[1][9]*m0[0][4]+m2[2][3]*m1[1][8]*m0[0][7]+m2[2][3]*m1[1][7]*m0[0][8]+m2[2][3]*m1[1][4]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][4]-m2[2][3]*m1[0][8]*m0[1][7]-m2[2][3]*m1[0][7]*m0[1][8]-m2[2][3]*m1[0][4]*m0[1][9]+m2[2][1]*m1[1][9]*m0[0][5]+m2[2][1]*m1[1][8]*m0[0][8]+m2[2][1]*m1[1][5]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][5]-m2[2][1]*m1[0][8]*m0[1][8]-m2[2][1]*m1[0][5]*m0[1][9]-m2[1][9]*m1[2][5]*m0[0][1]-m2[1][9]*m1[2][4]*m0[0][3]-m2[1][9]*m1[2][3]*m0[0][4]-m2[1][9]*m1[2][1]*m0[0][5]+m2[1][9]*m1[0][5]*m0[2][1]+m2[1][9]*m1[0][4]*m0[2][3]+m2[1][9]*m1[0][3]*m0[2][4]+m2[1][9]*m1[0][1]*m0[2][5]-m2[1][8]*m1[2][8]*m0[0][1]-m2[1][8]*m1[2][7]*m0[0][3]-m2[1][8]*m1[2][6]*m0[0][4]-m2[1][8]*m1[2][4]*m0[0][6]-m2[1][8]*m1[2][3]*m0[0][7]-m2[1][8]*m1[2][1]*m0[0][8]+m2[1][8]*m1[0][8]*m0[2][1]+m2[1][8]*m1[0][7]*m0[2][3]+m2[1][8]*m1[0][6]*m0[2][4]+m2[1][8]*m1[0][4]*m0[2][6]+m2[1][8]*m1[0][3]*m0[2][7]+m2[1][8]*m1[0][1]*m0[2][8]-m2[1][7]*m1[2][8]*m0[0][3]-m2[1][7]*m1[2][6]*m0[0][5]-m2[1][7]*m1[2][5]*m0[0][6]-m2[1][7]*m1[2][3]*m0[0][8]+m2[1][7]*m1[0][8]*m0[2][3]+m2[1][7]*m1[0][6]*m0[2][5]+m2[1][7]*m1[0][5]*m0[2][6]+m2[1][7]*m1[0][3]*m0[2][8]-m2[1][6]*m1[2][8]*m0[0][4]-m2[1][6]*m1[2][7]*m0[0][5]-m2[1][6]*m1[2][5]*m0[0][7]-m2[1][6]*m1[2][4]*m0[0][8]+m2[1][6]*m1[0][8]*m0[2][4]+m2[1][6]*m1[0][7]*m0[2][5]+m2[1][6]*m1[0][5]*m0[2][7]+m2[1][6]*m1[0][4]*m0[2][8]-m2[1][5]*m1[2][9]*m0[0][1]-m2[1][5]*m1[2][7]*m0[0][6]-m2[1][5]*m1[2][6]*m0[0][7]-m2[1][5]*m1[2][1]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][1]+m2[1][5]*m1[0][7]*m0[2][6]+m2[1][5]*m1[0][6]*m0[2][7]+m2[1][5]*m1[0][1]*m0[2][9]-m2[1][4]*m1[2][9]*m0[0][3]-m2[1][4]*m1[2][8]*m0[0][6]-m2[1][4]*m1[2][6]*m0[0][8]-m2[1][4]*m1[2][3]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][3]+m2[1][4]*m1[0][8]*m0[2][6]+m2[1][4]*m1[0][6]*m0[2][8]+m2[1][4]*m1[0][3]*m0[2][9]-m2[1][3]*m1[2][9]*m0[0][4]-m2[1][3]*m1[2][8]*m0[0][7]-m2[1][3]*m1[2][7]*m0[0][8]-m2[1][3]*m1[2][4]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][4]+m2[1][3]*m1[0][8]*m0[2][7]+m2[1][3]*m1[0][7]*m0[2][8]+m2[1][3]*m1[0][4]*m0[2][9]-m2[1][1]*m1[2][9]*m0[0][5]-m2[1][1]*m1[2][8]*m0[0][8]-m2[1][1]*m1[2][5]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][5]+m2[1][1]*m1[0][8]*m0[2][8]+m2[1][1]*m1[0][5]*m0[2][9]+m2[0][9]*m1[2][5]*m0[1][1]+m2[0][9]*m1[2][4]*m0[1][3]+m2[0][9]*m1[2][3]*m0[1][4]+m2[0][9]*m1[2][1]*m0[1][5]-m2[0][9]*m1[1][5]*m0[2][1]-m2[0][9]*m1[1][4]*m0[2][3]-m2[0][9]*m1[1][3]*m0[2][4]-m2[0][9]*m1[1][1]*m0[2][5]+m2[0][8]*m1[2][8]*m0[1][1]+m2[0][8]*m1[2][7]*m0[1][3]+m2[0][8]*m1[2][6]*m0[1][4]+m2[0][8]*m1[2][4]*m0[1][6]+m2[0][8]*m1[2][3]*m0[1][7]+m2[0][8]*m1[2][1]*m0[1][8]-m2[0][8]*m1[1][8]*m0[2][1]-m2[0][8]*m1[1][7]*m0[2][3]-m2[0][8]*m1[1][6]*m0[2][4]-m2[0][8]*m1[1][4]*m0[2][6]-m2[0][8]*m1[1][3]*m0[2][7]-m2[0][8]*m1[1][1]*m0[2][8]+m2[0][7]*m1[2][8]*m0[1][3]+m2[0][7]*m1[2][6]*m0[1][5]+m2[0][7]*m1[2][5]*m0[1][6]+m2[0][7]*m1[2][3]*m0[1][8]-m2[0][7]*m1[1][8]*m0[2][3]-m2[0][7]*m1[1][6]*m0[2][5]-m2[0][7]*m1[1][5]*m0[2][6]-m2[0][7]*m1[1][3]*m0[2][8]+m2[0][6]*m1[2][8]*m0[1][4]+m2[0][6]*m1[2][7]*m0[1][5]+m2[0][6]*m1[2][5]*m0[1][7]+m2[0][6]*m1[2][4]*m0[1][8]-m2[0][6]*m1[1][8]*m0[2][4]-m2[0][6]*m1[1][7]*m0[2][5]-m2[0][6]*m1[1][5]*m0[2][7]-m2[0][6]*m1[1][4]*m0[2][8]+m2[0][5]*m1[2][9]*m0[1][1]+m2[0][5]*m1[2][7]*m0[1][6]+m2[0][5]*m1[2][6]*m0[1][7]+m2[0][5]*m1[2][1]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][1]-m2[0][5]*m1[1][7]*m0[2][6]-m2[0][5]*m1[1][6]*m0[2][7]-m2[0][5]*m1[1][1]*m0[2][9]+m2[0][4]*m1[2][9]*m0[1][3]+m2[0][4]*m1[2][8]*m0[1][6]+m2[0][4]*m1[2][6]*m0[1][8]+m2[0][4]*m1[2][3]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][3]-m2[0][4]*m1[1][8]*m0[2][6]-m2[0][4]*m1[1][6]*m0[2][8]-m2[0][4]*m1[1][3]*m0[2][9]+m2[0][3]*m1[2][9]*m0[1][4]+m2[0][3]*m1[2][8]*m0[1][7]+m2[0][3]*m1[2][7]*m0[1][8]+m2[0][3]*m1[2][4]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][4]-m2[0][3]*m1[1][8]*m0[2][7]-m2[0][3]*m1[1][7]*m0[2][8]-m2[0][3]*m1[1][4]*m0[2][9]+m2[0][1]*m1[2][9]*m0[1][5]+m2[0][1]*m1[2][8]*m0[1][8]+m2[0][1]*m1[2][5]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][5]-m2[0][1]*m1[1][8]*m0[2][8]-m2[0][1]*m1[1][5]*m0[2][9]; 
  M1(row,60) = m2[2][9]*m1[1][5]*m0[0][2]+m2[2][9]*m1[1][4]*m0[0][4]+m2[2][9]*m1[1][2]*m0[0][5]-m2[2][9]*m1[0][5]*m0[1][2]-m2[2][9]*m1[0][4]*m0[1][4]-m2[2][9]*m1[0][2]*m0[1][5]+m2[2][8]*m1[1][8]*m0[0][2]+m2[2][8]*m1[1][7]*m0[0][4]+m2[2][8]*m1[1][4]*m0[0][7]+m2[2][8]*m1[1][2]*m0[0][8]-m2[2][8]*m1[0][8]*m0[1][2]-m2[2][8]*m1[0][7]*m0[1][4]-m2[2][8]*m1[0][4]*m0[1][7]-m2[2][8]*m1[0][2]*m0[1][8]+m2[2][7]*m1[1][8]*m0[0][4]+m2[2][7]*m1[1][7]*m0[0][5]+m2[2][7]*m1[1][5]*m0[0][7]+m2[2][7]*m1[1][4]*m0[0][8]-m2[2][7]*m1[0][8]*m0[1][4]-m2[2][7]*m1[0][7]*m0[1][5]-m2[2][7]*m1[0][5]*m0[1][7]-m2[2][7]*m1[0][4]*m0[1][8]+m2[2][5]*m1[1][9]*m0[0][2]+m2[2][5]*m1[1][7]*m0[0][7]+m2[2][5]*m1[1][2]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][2]-m2[2][5]*m1[0][7]*m0[1][7]-m2[2][5]*m1[0][2]*m0[1][9]+m2[2][4]*m1[1][9]*m0[0][4]+m2[2][4]*m1[1][8]*m0[0][7]+m2[2][4]*m1[1][7]*m0[0][8]+m2[2][4]*m1[1][4]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][4]-m2[2][4]*m1[0][8]*m0[1][7]-m2[2][4]*m1[0][7]*m0[1][8]-m2[2][4]*m1[0][4]*m0[1][9]+m2[2][2]*m1[1][9]*m0[0][5]+m2[2][2]*m1[1][8]*m0[0][8]+m2[2][2]*m1[1][5]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][5]-m2[2][2]*m1[0][8]*m0[1][8]-m2[2][2]*m1[0][5]*m0[1][9]-m2[1][9]*m1[2][5]*m0[0][2]-m2[1][9]*m1[2][4]*m0[0][4]-m2[1][9]*m1[2][2]*m0[0][5]+m2[1][9]*m1[0][5]*m0[2][2]+m2[1][9]*m1[0][4]*m0[2][4]+m2[1][9]*m1[0][2]*m0[2][5]-m2[1][8]*m1[2][8]*m0[0][2]-m2[1][8]*m1[2][7]*m0[0][4]-m2[1][8]*m1[2][4]*m0[0][7]-m2[1][8]*m1[2][2]*m0[0][8]+m2[1][8]*m1[0][8]*m0[2][2]+m2[1][8]*m1[0][7]*m0[2][4]+m2[1][8]*m1[0][4]*m0[2][7]+m2[1][8]*m1[0][2]*m0[2][8]-m2[1][7]*m1[2][8]*m0[0][4]-m2[1][7]*m1[2][7]*m0[0][5]-m2[1][7]*m1[2][5]*m0[0][7]-m2[1][7]*m1[2][4]*m0[0][8]+m2[1][7]*m1[0][8]*m0[2][4]+m2[1][7]*m1[0][7]*m0[2][5]+m2[1][7]*m1[0][5]*m0[2][7]+m2[1][7]*m1[0][4]*m0[2][8]-m2[1][5]*m1[2][9]*m0[0][2]-m2[1][5]*m1[2][7]*m0[0][7]-m2[1][5]*m1[2][2]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][2]+m2[1][5]*m1[0][7]*m0[2][7]+m2[1][5]*m1[0][2]*m0[2][9]-m2[1][4]*m1[2][9]*m0[0][4]-m2[1][4]*m1[2][8]*m0[0][7]-m2[1][4]*m1[2][7]*m0[0][8]-m2[1][4]*m1[2][4]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][4]+m2[1][4]*m1[0][8]*m0[2][7]+m2[1][4]*m1[0][7]*m0[2][8]+m2[1][4]*m1[0][4]*m0[2][9]-m2[1][2]*m1[2][9]*m0[0][5]-m2[1][2]*m1[2][8]*m0[0][8]-m2[1][2]*m1[2][5]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][5]+m2[1][2]*m1[0][8]*m0[2][8]+m2[1][2]*m1[0][5]*m0[2][9]+m2[0][9]*m1[2][5]*m0[1][2]+m2[0][9]*m1[2][4]*m0[1][4]+m2[0][9]*m1[2][2]*m0[1][5]-m2[0][9]*m1[1][5]*m0[2][2]-m2[0][9]*m1[1][4]*m0[2][4]-m2[0][9]*m1[1][2]*m0[2][5]+m2[0][8]*m1[2][8]*m0[1][2]+m2[0][8]*m1[2][7]*m0[1][4]+m2[0][8]*m1[2][4]*m0[1][7]+m2[0][8]*m1[2][2]*m0[1][8]-m2[0][8]*m1[1][8]*m0[2][2]-m2[0][8]*m1[1][7]*m0[2][4]-m2[0][8]*m1[1][4]*m0[2][7]-m2[0][8]*m1[1][2]*m0[2][8]+m2[0][7]*m1[2][8]*m0[1][4]+m2[0][7]*m1[2][7]*m0[1][5]+m2[0][7]*m1[2][5]*m0[1][7]+m2[0][7]*m1[2][4]*m0[1][8]-m2[0][7]*m1[1][8]*m0[2][4]-m2[0][7]*m1[1][7]*m0[2][5]-m2[0][7]*m1[1][5]*m0[2][7]-m2[0][7]*m1[1][4]*m0[2][8]+m2[0][5]*m1[2][9]*m0[1][2]+m2[0][5]*m1[2][7]*m0[1][7]+m2[0][5]*m1[2][2]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][2]-m2[0][5]*m1[1][7]*m0[2][7]-m2[0][5]*m1[1][2]*m0[2][9]+m2[0][4]*m1[2][9]*m0[1][4]+m2[0][4]*m1[2][8]*m0[1][7]+m2[0][4]*m1[2][7]*m0[1][8]+m2[0][4]*m1[2][4]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][4]-m2[0][4]*m1[1][8]*m0[2][7]-m2[0][4]*m1[1][7]*m0[2][8]-m2[0][4]*m1[1][4]*m0[2][9]+m2[0][2]*m1[2][9]*m0[1][5]+m2[0][2]*m1[2][8]*m0[1][8]+m2[0][2]*m1[2][5]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][5]-m2[0][2]*m1[1][8]*m0[2][8]-m2[0][2]*m1[1][5]*m0[2][9]; 
  M1(row,61) = m2[2][9]*m1[1][5]*m0[0][3]+m2[2][9]*m1[1][3]*m0[0][5]-m2[2][9]*m1[0][5]*m0[1][3]-m2[2][9]*m1[0][3]*m0[1][5]+m2[2][8]*m1[1][8]*m0[0][3]+m2[2][8]*m1[1][6]*m0[0][5]+m2[2][8]*m1[1][5]*m0[0][6]+m2[2][8]*m1[1][3]*m0[0][8]-m2[2][8]*m1[0][8]*m0[1][3]-m2[2][8]*m1[0][6]*m0[1][5]-m2[2][8]*m1[0][5]*m0[1][6]-m2[2][8]*m1[0][3]*m0[1][8]+m2[2][6]*m1[1][8]*m0[0][5]+m2[2][6]*m1[1][5]*m0[0][8]-m2[2][6]*m1[0][8]*m0[1][5]-m2[2][6]*m1[0][5]*m0[1][8]+m2[2][5]*m1[1][9]*m0[0][3]+m2[2][5]*m1[1][8]*m0[0][6]+m2[2][5]*m1[1][6]*m0[0][8]+m2[2][5]*m1[1][3]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][3]-m2[2][5]*m1[0][8]*m0[1][6]-m2[2][5]*m1[0][6]*m0[1][8]-m2[2][5]*m1[0][3]*m0[1][9]+m2[2][3]*m1[1][9]*m0[0][5]+m2[2][3]*m1[1][8]*m0[0][8]+m2[2][3]*m1[1][5]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][5]-m2[2][3]*m1[0][8]*m0[1][8]-m2[2][3]*m1[0][5]*m0[1][9]-m2[1][9]*m1[2][5]*m0[0][3]-m2[1][9]*m1[2][3]*m0[0][5]+m2[1][9]*m1[0][5]*m0[2][3]+m2[1][9]*m1[0][3]*m0[2][5]-m2[1][8]*m1[2][8]*m0[0][3]-m2[1][8]*m1[2][6]*m0[0][5]-m2[1][8]*m1[2][5]*m0[0][6]-m2[1][8]*m1[2][3]*m0[0][8]+m2[1][8]*m1[0][8]*m0[2][3]+m2[1][8]*m1[0][6]*m0[2][5]+m2[1][8]*m1[0][5]*m0[2][6]+m2[1][8]*m1[0][3]*m0[2][8]-m2[1][6]*m1[2][8]*m0[0][5]-m2[1][6]*m1[2][5]*m0[0][8]+m2[1][6]*m1[0][8]*m0[2][5]+m2[1][6]*m1[0][5]*m0[2][8]-m2[1][5]*m1[2][9]*m0[0][3]-m2[1][5]*m1[2][8]*m0[0][6]-m2[1][5]*m1[2][6]*m0[0][8]-m2[1][5]*m1[2][3]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][3]+m2[1][5]*m1[0][8]*m0[2][6]+m2[1][5]*m1[0][6]*m0[2][8]+m2[1][5]*m1[0][3]*m0[2][9]-m2[1][3]*m1[2][9]*m0[0][5]-m2[1][3]*m1[2][8]*m0[0][8]-m2[1][3]*m1[2][5]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][5]+m2[1][3]*m1[0][8]*m0[2][8]+m2[1][3]*m1[0][5]*m0[2][9]+m2[0][9]*m1[2][5]*m0[1][3]+m2[0][9]*m1[2][3]*m0[1][5]-m2[0][9]*m1[1][5]*m0[2][3]-m2[0][9]*m1[1][3]*m0[2][5]+m2[0][8]*m1[2][8]*m0[1][3]+m2[0][8]*m1[2][6]*m0[1][5]+m2[0][8]*m1[2][5]*m0[1][6]+m2[0][8]*m1[2][3]*m0[1][8]-m2[0][8]*m1[1][8]*m0[2][3]-m2[0][8]*m1[1][6]*m0[2][5]-m2[0][8]*m1[1][5]*m0[2][6]-m2[0][8]*m1[1][3]*m0[2][8]+m2[0][6]*m1[2][8]*m0[1][5]+m2[0][6]*m1[2][5]*m0[1][8]-m2[0][6]*m1[1][8]*m0[2][5]-m2[0][6]*m1[1][5]*m0[2][8]+m2[0][5]*m1[2][9]*m0[1][3]+m2[0][5]*m1[2][8]*m0[1][6]+m2[0][5]*m1[2][6]*m0[1][8]+m2[0][5]*m1[2][3]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][3]-m2[0][5]*m1[1][8]*m0[2][6]-m2[0][5]*m1[1][6]*m0[2][8]-m2[0][5]*m1[1][3]*m0[2][9]+m2[0][3]*m1[2][9]*m0[1][5]+m2[0][3]*m1[2][8]*m0[1][8]+m2[0][3]*m1[2][5]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][5]-m2[0][3]*m1[1][8]*m0[2][8]-m2[0][3]*m1[1][5]*m0[2][9]; 
  M1(row,62) = m2[2][9]*m1[1][5]*m0[0][4]+m2[2][9]*m1[1][4]*m0[0][5]-m2[2][9]*m1[0][5]*m0[1][4]-m2[2][9]*m1[0][4]*m0[1][5]+m2[2][8]*m1[1][8]*m0[0][4]+m2[2][8]*m1[1][7]*m0[0][5]+m2[2][8]*m1[1][5]*m0[0][7]+m2[2][8]*m1[1][4]*m0[0][8]-m2[2][8]*m1[0][8]*m0[1][4]-m2[2][8]*m1[0][7]*m0[1][5]-m2[2][8]*m1[0][5]*m0[1][7]-m2[2][8]*m1[0][4]*m0[1][8]+m2[2][7]*m1[1][8]*m0[0][5]+m2[2][7]*m1[1][5]*m0[0][8]-m2[2][7]*m1[0][8]*m0[1][5]-m2[2][7]*m1[0][5]*m0[1][8]+m2[2][5]*m1[1][9]*m0[0][4]+m2[2][5]*m1[1][8]*m0[0][7]+m2[2][5]*m1[1][7]*m0[0][8]+m2[2][5]*m1[1][4]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][4]-m2[2][5]*m1[0][8]*m0[1][7]-m2[2][5]*m1[0][7]*m0[1][8]-m2[2][5]*m1[0][4]*m0[1][9]+m2[2][4]*m1[1][9]*m0[0][5]+m2[2][4]*m1[1][8]*m0[0][8]+m2[2][4]*m1[1][5]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][5]-m2[2][4]*m1[0][8]*m0[1][8]-m2[2][4]*m1[0][5]*m0[1][9]-m2[1][9]*m1[2][5]*m0[0][4]-m2[1][9]*m1[2][4]*m0[0][5]+m2[1][9]*m1[0][5]*m0[2][4]+m2[1][9]*m1[0][4]*m0[2][5]-m2[1][8]*m1[2][8]*m0[0][4]-m2[1][8]*m1[2][7]*m0[0][5]-m2[1][8]*m1[2][5]*m0[0][7]-m2[1][8]*m1[2][4]*m0[0][8]+m2[1][8]*m1[0][8]*m0[2][4]+m2[1][8]*m1[0][7]*m0[2][5]+m2[1][8]*m1[0][5]*m0[2][7]+m2[1][8]*m1[0][4]*m0[2][8]-m2[1][7]*m1[2][8]*m0[0][5]-m2[1][7]*m1[2][5]*m0[0][8]+m2[1][7]*m1[0][8]*m0[2][5]+m2[1][7]*m1[0][5]*m0[2][8]-m2[1][5]*m1[2][9]*m0[0][4]-m2[1][5]*m1[2][8]*m0[0][7]-m2[1][5]*m1[2][7]*m0[0][8]-m2[1][5]*m1[2][4]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][4]+m2[1][5]*m1[0][8]*m0[2][7]+m2[1][5]*m1[0][7]*m0[2][8]+m2[1][5]*m1[0][4]*m0[2][9]-m2[1][4]*m1[2][9]*m0[0][5]-m2[1][4]*m1[2][8]*m0[0][8]-m2[1][4]*m1[2][5]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][5]+m2[1][4]*m1[0][8]*m0[2][8]+m2[1][4]*m1[0][5]*m0[2][9]+m2[0][9]*m1[2][5]*m0[1][4]+m2[0][9]*m1[2][4]*m0[1][5]-m2[0][9]*m1[1][5]*m0[2][4]-m2[0][9]*m1[1][4]*m0[2][5]+m2[0][8]*m1[2][8]*m0[1][4]+m2[0][8]*m1[2][7]*m0[1][5]+m2[0][8]*m1[2][5]*m0[1][7]+m2[0][8]*m1[2][4]*m0[1][8]-m2[0][8]*m1[1][8]*m0[2][4]-m2[0][8]*m1[1][7]*m0[2][5]-m2[0][8]*m1[1][5]*m0[2][7]-m2[0][8]*m1[1][4]*m0[2][8]+m2[0][7]*m1[2][8]*m0[1][5]+m2[0][7]*m1[2][5]*m0[1][8]-m2[0][7]*m1[1][8]*m0[2][5]-m2[0][7]*m1[1][5]*m0[2][8]+m2[0][5]*m1[2][9]*m0[1][4]+m2[0][5]*m1[2][8]*m0[1][7]+m2[0][5]*m1[2][7]*m0[1][8]+m2[0][5]*m1[2][4]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][4]-m2[0][5]*m1[1][8]*m0[2][7]-m2[0][5]*m1[1][7]*m0[2][8]-m2[0][5]*m1[1][4]*m0[2][9]+m2[0][4]*m1[2][9]*m0[1][5]+m2[0][4]*m1[2][8]*m0[1][8]+m2[0][4]*m1[2][5]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][5]-m2[0][4]*m1[1][8]*m0[2][8]-m2[0][4]*m1[1][5]*m0[2][9]; 
  M1(row,63) = m2[2][9]*m1[1][5]*m0[0][5]-m2[2][9]*m1[0][5]*m0[1][5]+m2[2][8]*m1[1][8]*m0[0][5]+m2[2][8]*m1[1][5]*m0[0][8]-m2[2][8]*m1[0][8]*m0[1][5]-m2[2][8]*m1[0][5]*m0[1][8]+m2[2][5]*m1[1][9]*m0[0][5]+m2[2][5]*m1[1][8]*m0[0][8]+m2[2][5]*m1[1][5]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][5]-m2[2][5]*m1[0][8]*m0[1][8]-m2[2][5]*m1[0][5]*m0[1][9]-m2[1][9]*m1[2][5]*m0[0][5]+m2[1][9]*m1[0][5]*m0[2][5]-m2[1][8]*m1[2][8]*m0[0][5]-m2[1][8]*m1[2][5]*m0[0][8]+m2[1][8]*m1[0][8]*m0[2][5]+m2[1][8]*m1[0][5]*m0[2][8]-m2[1][5]*m1[2][9]*m0[0][5]-m2[1][5]*m1[2][8]*m0[0][8]-m2[1][5]*m1[2][5]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][5]+m2[1][5]*m1[0][8]*m0[2][8]+m2[1][5]*m1[0][5]*m0[2][9]+m2[0][9]*m1[2][5]*m0[1][5]-m2[0][9]*m1[1][5]*m0[2][5]+m2[0][8]*m1[2][8]*m0[1][5]+m2[0][8]*m1[2][5]*m0[1][8]-m2[0][8]*m1[1][8]*m0[2][5]-m2[0][8]*m1[1][5]*m0[2][8]+m2[0][5]*m1[2][9]*m0[1][5]+m2[0][5]*m1[2][8]*m0[1][8]+m2[0][5]*m1[2][5]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][5]-m2[0][5]*m1[1][8]*m0[2][8]-m2[0][5]*m1[1][5]*m0[2][9]; 
  M1(row,64) = m2[2][9]*m1[1][6]*m0[0][0]+m2[2][9]*m1[1][0]*m0[0][6]-m2[2][9]*m1[0][6]*m0[1][0]-m2[2][9]*m1[0][0]*m0[1][6]+m2[2][6]*m1[1][9]*m0[0][0]+m2[2][6]*m1[1][6]*m0[0][6]+m2[2][6]*m1[1][0]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][0]-m2[2][6]*m1[0][6]*m0[1][6]-m2[2][6]*m1[0][0]*m0[1][9]+m2[2][0]*m1[1][9]*m0[0][6]+m2[2][0]*m1[1][6]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][6]-m2[2][0]*m1[0][6]*m0[1][9]-m2[1][9]*m1[2][6]*m0[0][0]-m2[1][9]*m1[2][0]*m0[0][6]+m2[1][9]*m1[0][6]*m0[2][0]+m2[1][9]*m1[0][0]*m0[2][6]-m2[1][6]*m1[2][9]*m0[0][0]-m2[1][6]*m1[2][6]*m0[0][6]-m2[1][6]*m1[2][0]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][0]+m2[1][6]*m1[0][6]*m0[2][6]+m2[1][6]*m1[0][0]*m0[2][9]-m2[1][0]*m1[2][9]*m0[0][6]-m2[1][0]*m1[2][6]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][6]+m2[1][0]*m1[0][6]*m0[2][9]+m2[0][9]*m1[2][6]*m0[1][0]+m2[0][9]*m1[2][0]*m0[1][6]-m2[0][9]*m1[1][6]*m0[2][0]-m2[0][9]*m1[1][0]*m0[2][6]+m2[0][6]*m1[2][9]*m0[1][0]+m2[0][6]*m1[2][6]*m0[1][6]+m2[0][6]*m1[2][0]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][0]-m2[0][6]*m1[1][6]*m0[2][6]-m2[0][6]*m1[1][0]*m0[2][9]+m2[0][0]*m1[2][9]*m0[1][6]+m2[0][0]*m1[2][6]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][6]-m2[0][0]*m1[1][6]*m0[2][9]; 
  M1(row,65) = m2[2][9]*m1[1][7]*m0[0][0]+m2[2][9]*m1[1][6]*m0[0][1]+m2[2][9]*m1[1][1]*m0[0][6]+m2[2][9]*m1[1][0]*m0[0][7]-m2[2][9]*m1[0][7]*m0[1][0]-m2[2][9]*m1[0][6]*m0[1][1]-m2[2][9]*m1[0][1]*m0[1][6]-m2[2][9]*m1[0][0]*m0[1][7]+m2[2][7]*m1[1][9]*m0[0][0]+m2[2][7]*m1[1][6]*m0[0][6]+m2[2][7]*m1[1][0]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][0]-m2[2][7]*m1[0][6]*m0[1][6]-m2[2][7]*m1[0][0]*m0[1][9]+m2[2][6]*m1[1][9]*m0[0][1]+m2[2][6]*m1[1][7]*m0[0][6]+m2[2][6]*m1[1][6]*m0[0][7]+m2[2][6]*m1[1][1]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][1]-m2[2][6]*m1[0][7]*m0[1][6]-m2[2][6]*m1[0][6]*m0[1][7]-m2[2][6]*m1[0][1]*m0[1][9]+m2[2][1]*m1[1][9]*m0[0][6]+m2[2][1]*m1[1][6]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][6]-m2[2][1]*m1[0][6]*m0[1][9]+m2[2][0]*m1[1][9]*m0[0][7]+m2[2][0]*m1[1][7]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][7]-m2[2][0]*m1[0][7]*m0[1][9]-m2[1][9]*m1[2][7]*m0[0][0]-m2[1][9]*m1[2][6]*m0[0][1]-m2[1][9]*m1[2][1]*m0[0][6]-m2[1][9]*m1[2][0]*m0[0][7]+m2[1][9]*m1[0][7]*m0[2][0]+m2[1][9]*m1[0][6]*m0[2][1]+m2[1][9]*m1[0][1]*m0[2][6]+m2[1][9]*m1[0][0]*m0[2][7]-m2[1][7]*m1[2][9]*m0[0][0]-m2[1][7]*m1[2][6]*m0[0][6]-m2[1][7]*m1[2][0]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][0]+m2[1][7]*m1[0][6]*m0[2][6]+m2[1][7]*m1[0][0]*m0[2][9]-m2[1][6]*m1[2][9]*m0[0][1]-m2[1][6]*m1[2][7]*m0[0][6]-m2[1][6]*m1[2][6]*m0[0][7]-m2[1][6]*m1[2][1]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][1]+m2[1][6]*m1[0][7]*m0[2][6]+m2[1][6]*m1[0][6]*m0[2][7]+m2[1][6]*m1[0][1]*m0[2][9]-m2[1][1]*m1[2][9]*m0[0][6]-m2[1][1]*m1[2][6]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][6]+m2[1][1]*m1[0][6]*m0[2][9]-m2[1][0]*m1[2][9]*m0[0][7]-m2[1][0]*m1[2][7]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][7]+m2[1][0]*m1[0][7]*m0[2][9]+m2[0][9]*m1[2][7]*m0[1][0]+m2[0][9]*m1[2][6]*m0[1][1]+m2[0][9]*m1[2][1]*m0[1][6]+m2[0][9]*m1[2][0]*m0[1][7]-m2[0][9]*m1[1][7]*m0[2][0]-m2[0][9]*m1[1][6]*m0[2][1]-m2[0][9]*m1[1][1]*m0[2][6]-m2[0][9]*m1[1][0]*m0[2][7]+m2[0][7]*m1[2][9]*m0[1][0]+m2[0][7]*m1[2][6]*m0[1][6]+m2[0][7]*m1[2][0]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][0]-m2[0][7]*m1[1][6]*m0[2][6]-m2[0][7]*m1[1][0]*m0[2][9]+m2[0][6]*m1[2][9]*m0[1][1]+m2[0][6]*m1[2][7]*m0[1][6]+m2[0][6]*m1[2][6]*m0[1][7]+m2[0][6]*m1[2][1]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][1]-m2[0][6]*m1[1][7]*m0[2][6]-m2[0][6]*m1[1][6]*m0[2][7]-m2[0][6]*m1[1][1]*m0[2][9]+m2[0][1]*m1[2][9]*m0[1][6]+m2[0][1]*m1[2][6]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][6]-m2[0][1]*m1[1][6]*m0[2][9]+m2[0][0]*m1[2][9]*m0[1][7]+m2[0][0]*m1[2][7]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][7]-m2[0][0]*m1[1][7]*m0[2][9]; 
  M1(row,66) = m2[2][9]*m1[1][7]*m0[0][1]+m2[2][9]*m1[1][6]*m0[0][2]+m2[2][9]*m1[1][2]*m0[0][6]+m2[2][9]*m1[1][1]*m0[0][7]-m2[2][9]*m1[0][7]*m0[1][1]-m2[2][9]*m1[0][6]*m0[1][2]-m2[2][9]*m1[0][2]*m0[1][6]-m2[2][9]*m1[0][1]*m0[1][7]+m2[2][7]*m1[1][9]*m0[0][1]+m2[2][7]*m1[1][7]*m0[0][6]+m2[2][7]*m1[1][6]*m0[0][7]+m2[2][7]*m1[1][1]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][1]-m2[2][7]*m1[0][7]*m0[1][6]-m2[2][7]*m1[0][6]*m0[1][7]-m2[2][7]*m1[0][1]*m0[1][9]+m2[2][6]*m1[1][9]*m0[0][2]+m2[2][6]*m1[1][7]*m0[0][7]+m2[2][6]*m1[1][2]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][2]-m2[2][6]*m1[0][7]*m0[1][7]-m2[2][6]*m1[0][2]*m0[1][9]+m2[2][2]*m1[1][9]*m0[0][6]+m2[2][2]*m1[1][6]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][6]-m2[2][2]*m1[0][6]*m0[1][9]+m2[2][1]*m1[1][9]*m0[0][7]+m2[2][1]*m1[1][7]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][7]-m2[2][1]*m1[0][7]*m0[1][9]-m2[1][9]*m1[2][7]*m0[0][1]-m2[1][9]*m1[2][6]*m0[0][2]-m2[1][9]*m1[2][2]*m0[0][6]-m2[1][9]*m1[2][1]*m0[0][7]+m2[1][9]*m1[0][7]*m0[2][1]+m2[1][9]*m1[0][6]*m0[2][2]+m2[1][9]*m1[0][2]*m0[2][6]+m2[1][9]*m1[0][1]*m0[2][7]-m2[1][7]*m1[2][9]*m0[0][1]-m2[1][7]*m1[2][7]*m0[0][6]-m2[1][7]*m1[2][6]*m0[0][7]-m2[1][7]*m1[2][1]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][1]+m2[1][7]*m1[0][7]*m0[2][6]+m2[1][7]*m1[0][6]*m0[2][7]+m2[1][7]*m1[0][1]*m0[2][9]-m2[1][6]*m1[2][9]*m0[0][2]-m2[1][6]*m1[2][7]*m0[0][7]-m2[1][6]*m1[2][2]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][2]+m2[1][6]*m1[0][7]*m0[2][7]+m2[1][6]*m1[0][2]*m0[2][9]-m2[1][2]*m1[2][9]*m0[0][6]-m2[1][2]*m1[2][6]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][6]+m2[1][2]*m1[0][6]*m0[2][9]-m2[1][1]*m1[2][9]*m0[0][7]-m2[1][1]*m1[2][7]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][7]+m2[1][1]*m1[0][7]*m0[2][9]+m2[0][9]*m1[2][7]*m0[1][1]+m2[0][9]*m1[2][6]*m0[1][2]+m2[0][9]*m1[2][2]*m0[1][6]+m2[0][9]*m1[2][1]*m0[1][7]-m2[0][9]*m1[1][7]*m0[2][1]-m2[0][9]*m1[1][6]*m0[2][2]-m2[0][9]*m1[1][2]*m0[2][6]-m2[0][9]*m1[1][1]*m0[2][7]+m2[0][7]*m1[2][9]*m0[1][1]+m2[0][7]*m1[2][7]*m0[1][6]+m2[0][7]*m1[2][6]*m0[1][7]+m2[0][7]*m1[2][1]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][1]-m2[0][7]*m1[1][7]*m0[2][6]-m2[0][7]*m1[1][6]*m0[2][7]-m2[0][7]*m1[1][1]*m0[2][9]+m2[0][6]*m1[2][9]*m0[1][2]+m2[0][6]*m1[2][7]*m0[1][7]+m2[0][6]*m1[2][2]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][2]-m2[0][6]*m1[1][7]*m0[2][7]-m2[0][6]*m1[1][2]*m0[2][9]+m2[0][2]*m1[2][9]*m0[1][6]+m2[0][2]*m1[2][6]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][6]-m2[0][2]*m1[1][6]*m0[2][9]+m2[0][1]*m1[2][9]*m0[1][7]+m2[0][1]*m1[2][7]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][7]-m2[0][1]*m1[1][7]*m0[2][9]; 
  M1(row,67) = m2[2][9]*m1[1][7]*m0[0][2]+m2[2][9]*m1[1][2]*m0[0][7]-m2[2][9]*m1[0][7]*m0[1][2]-m2[2][9]*m1[0][2]*m0[1][7]+m2[2][7]*m1[1][9]*m0[0][2]+m2[2][7]*m1[1][7]*m0[0][7]+m2[2][7]*m1[1][2]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][2]-m2[2][7]*m1[0][7]*m0[1][7]-m2[2][7]*m1[0][2]*m0[1][9]+m2[2][2]*m1[1][9]*m0[0][7]+m2[2][2]*m1[1][7]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][7]-m2[2][2]*m1[0][7]*m0[1][9]-m2[1][9]*m1[2][7]*m0[0][2]-m2[1][9]*m1[2][2]*m0[0][7]+m2[1][9]*m1[0][7]*m0[2][2]+m2[1][9]*m1[0][2]*m0[2][7]-m2[1][7]*m1[2][9]*m0[0][2]-m2[1][7]*m1[2][7]*m0[0][7]-m2[1][7]*m1[2][2]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][2]+m2[1][7]*m1[0][7]*m0[2][7]+m2[1][7]*m1[0][2]*m0[2][9]-m2[1][2]*m1[2][9]*m0[0][7]-m2[1][2]*m1[2][7]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][7]+m2[1][2]*m1[0][7]*m0[2][9]+m2[0][9]*m1[2][7]*m0[1][2]+m2[0][9]*m1[2][2]*m0[1][7]-m2[0][9]*m1[1][7]*m0[2][2]-m2[0][9]*m1[1][2]*m0[2][7]+m2[0][7]*m1[2][9]*m0[1][2]+m2[0][7]*m1[2][7]*m0[1][7]+m2[0][7]*m1[2][2]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][2]-m2[0][7]*m1[1][7]*m0[2][7]-m2[0][7]*m1[1][2]*m0[2][9]+m2[0][2]*m1[2][9]*m0[1][7]+m2[0][2]*m1[2][7]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][7]-m2[0][2]*m1[1][7]*m0[2][9]; 
  M1(row,68) = m2[2][9]*m1[1][8]*m0[0][0]+m2[2][9]*m1[1][6]*m0[0][3]+m2[2][9]*m1[1][3]*m0[0][6]+m2[2][9]*m1[1][0]*m0[0][8]-m2[2][9]*m1[0][8]*m0[1][0]-m2[2][9]*m1[0][6]*m0[1][3]-m2[2][9]*m1[0][3]*m0[1][6]-m2[2][9]*m1[0][0]*m0[1][8]+m2[2][8]*m1[1][9]*m0[0][0]+m2[2][8]*m1[1][6]*m0[0][6]+m2[2][8]*m1[1][0]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][0]-m2[2][8]*m1[0][6]*m0[1][6]-m2[2][8]*m1[0][0]*m0[1][9]+m2[2][6]*m1[1][9]*m0[0][3]+m2[2][6]*m1[1][8]*m0[0][6]+m2[2][6]*m1[1][6]*m0[0][8]+m2[2][6]*m1[1][3]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][3]-m2[2][6]*m1[0][8]*m0[1][6]-m2[2][6]*m1[0][6]*m0[1][8]-m2[2][6]*m1[0][3]*m0[1][9]+m2[2][3]*m1[1][9]*m0[0][6]+m2[2][3]*m1[1][6]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][6]-m2[2][3]*m1[0][6]*m0[1][9]+m2[2][0]*m1[1][9]*m0[0][8]+m2[2][0]*m1[1][8]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][8]-m2[2][0]*m1[0][8]*m0[1][9]-m2[1][9]*m1[2][8]*m0[0][0]-m2[1][9]*m1[2][6]*m0[0][3]-m2[1][9]*m1[2][3]*m0[0][6]-m2[1][9]*m1[2][0]*m0[0][8]+m2[1][9]*m1[0][8]*m0[2][0]+m2[1][9]*m1[0][6]*m0[2][3]+m2[1][9]*m1[0][3]*m0[2][6]+m2[1][9]*m1[0][0]*m0[2][8]-m2[1][8]*m1[2][9]*m0[0][0]-m2[1][8]*m1[2][6]*m0[0][6]-m2[1][8]*m1[2][0]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][0]+m2[1][8]*m1[0][6]*m0[2][6]+m2[1][8]*m1[0][0]*m0[2][9]-m2[1][6]*m1[2][9]*m0[0][3]-m2[1][6]*m1[2][8]*m0[0][6]-m2[1][6]*m1[2][6]*m0[0][8]-m2[1][6]*m1[2][3]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][3]+m2[1][6]*m1[0][8]*m0[2][6]+m2[1][6]*m1[0][6]*m0[2][8]+m2[1][6]*m1[0][3]*m0[2][9]-m2[1][3]*m1[2][9]*m0[0][6]-m2[1][3]*m1[2][6]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][6]+m2[1][3]*m1[0][6]*m0[2][9]-m2[1][0]*m1[2][9]*m0[0][8]-m2[1][0]*m1[2][8]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][8]+m2[1][0]*m1[0][8]*m0[2][9]+m2[0][9]*m1[2][8]*m0[1][0]+m2[0][9]*m1[2][6]*m0[1][3]+m2[0][9]*m1[2][3]*m0[1][6]+m2[0][9]*m1[2][0]*m0[1][8]-m2[0][9]*m1[1][8]*m0[2][0]-m2[0][9]*m1[1][6]*m0[2][3]-m2[0][9]*m1[1][3]*m0[2][6]-m2[0][9]*m1[1][0]*m0[2][8]+m2[0][8]*m1[2][9]*m0[1][0]+m2[0][8]*m1[2][6]*m0[1][6]+m2[0][8]*m1[2][0]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][0]-m2[0][8]*m1[1][6]*m0[2][6]-m2[0][8]*m1[1][0]*m0[2][9]+m2[0][6]*m1[2][9]*m0[1][3]+m2[0][6]*m1[2][8]*m0[1][6]+m2[0][6]*m1[2][6]*m0[1][8]+m2[0][6]*m1[2][3]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][3]-m2[0][6]*m1[1][8]*m0[2][6]-m2[0][6]*m1[1][6]*m0[2][8]-m2[0][6]*m1[1][3]*m0[2][9]+m2[0][3]*m1[2][9]*m0[1][6]+m2[0][3]*m1[2][6]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][6]-m2[0][3]*m1[1][6]*m0[2][9]+m2[0][0]*m1[2][9]*m0[1][8]+m2[0][0]*m1[2][8]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][8]-m2[0][0]*m1[1][8]*m0[2][9]; 
  M1(row,69) = m2[2][9]*m1[1][8]*m0[0][1]+m2[2][9]*m1[1][7]*m0[0][3]+m2[2][9]*m1[1][6]*m0[0][4]+m2[2][9]*m1[1][4]*m0[0][6]+m2[2][9]*m1[1][3]*m0[0][7]+m2[2][9]*m1[1][1]*m0[0][8]-m2[2][9]*m1[0][8]*m0[1][1]-m2[2][9]*m1[0][7]*m0[1][3]-m2[2][9]*m1[0][6]*m0[1][4]-m2[2][9]*m1[0][4]*m0[1][6]-m2[2][9]*m1[0][3]*m0[1][7]-m2[2][9]*m1[0][1]*m0[1][8]+m2[2][8]*m1[1][9]*m0[0][1]+m2[2][8]*m1[1][7]*m0[0][6]+m2[2][8]*m1[1][6]*m0[0][7]+m2[2][8]*m1[1][1]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][1]-m2[2][8]*m1[0][7]*m0[1][6]-m2[2][8]*m1[0][6]*m0[1][7]-m2[2][8]*m1[0][1]*m0[1][9]+m2[2][7]*m1[1][9]*m0[0][3]+m2[2][7]*m1[1][8]*m0[0][6]+m2[2][7]*m1[1][6]*m0[0][8]+m2[2][7]*m1[1][3]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][3]-m2[2][7]*m1[0][8]*m0[1][6]-m2[2][7]*m1[0][6]*m0[1][8]-m2[2][7]*m1[0][3]*m0[1][9]+m2[2][6]*m1[1][9]*m0[0][4]+m2[2][6]*m1[1][8]*m0[0][7]+m2[2][6]*m1[1][7]*m0[0][8]+m2[2][6]*m1[1][4]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][4]-m2[2][6]*m1[0][8]*m0[1][7]-m2[2][6]*m1[0][7]*m0[1][8]-m2[2][6]*m1[0][4]*m0[1][9]+m2[2][4]*m1[1][9]*m0[0][6]+m2[2][4]*m1[1][6]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][6]-m2[2][4]*m1[0][6]*m0[1][9]+m2[2][3]*m1[1][9]*m0[0][7]+m2[2][3]*m1[1][7]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][7]-m2[2][3]*m1[0][7]*m0[1][9]+m2[2][1]*m1[1][9]*m0[0][8]+m2[2][1]*m1[1][8]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][8]-m2[2][1]*m1[0][8]*m0[1][9]-m2[1][9]*m1[2][8]*m0[0][1]-m2[1][9]*m1[2][7]*m0[0][3]-m2[1][9]*m1[2][6]*m0[0][4]-m2[1][9]*m1[2][4]*m0[0][6]-m2[1][9]*m1[2][3]*m0[0][7]-m2[1][9]*m1[2][1]*m0[0][8]+m2[1][9]*m1[0][8]*m0[2][1]+m2[1][9]*m1[0][7]*m0[2][3]+m2[1][9]*m1[0][6]*m0[2][4]+m2[1][9]*m1[0][4]*m0[2][6]+m2[1][9]*m1[0][3]*m0[2][7]+m2[1][9]*m1[0][1]*m0[2][8]-m2[1][8]*m1[2][9]*m0[0][1]-m2[1][8]*m1[2][7]*m0[0][6]-m2[1][8]*m1[2][6]*m0[0][7]-m2[1][8]*m1[2][1]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][1]+m2[1][8]*m1[0][7]*m0[2][6]+m2[1][8]*m1[0][6]*m0[2][7]+m2[1][8]*m1[0][1]*m0[2][9]-m2[1][7]*m1[2][9]*m0[0][3]-m2[1][7]*m1[2][8]*m0[0][6]-m2[1][7]*m1[2][6]*m0[0][8]-m2[1][7]*m1[2][3]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][3]+m2[1][7]*m1[0][8]*m0[2][6]+m2[1][7]*m1[0][6]*m0[2][8]+m2[1][7]*m1[0][3]*m0[2][9]-m2[1][6]*m1[2][9]*m0[0][4]-m2[1][6]*m1[2][8]*m0[0][7]-m2[1][6]*m1[2][7]*m0[0][8]-m2[1][6]*m1[2][4]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][4]+m2[1][6]*m1[0][8]*m0[2][7]+m2[1][6]*m1[0][7]*m0[2][8]+m2[1][6]*m1[0][4]*m0[2][9]-m2[1][4]*m1[2][9]*m0[0][6]-m2[1][4]*m1[2][6]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][6]+m2[1][4]*m1[0][6]*m0[2][9]-m2[1][3]*m1[2][9]*m0[0][7]-m2[1][3]*m1[2][7]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][7]+m2[1][3]*m1[0][7]*m0[2][9]-m2[1][1]*m1[2][9]*m0[0][8]-m2[1][1]*m1[2][8]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][8]+m2[1][1]*m1[0][8]*m0[2][9]+m2[0][9]*m1[2][8]*m0[1][1]+m2[0][9]*m1[2][7]*m0[1][3]+m2[0][9]*m1[2][6]*m0[1][4]+m2[0][9]*m1[2][4]*m0[1][6]+m2[0][9]*m1[2][3]*m0[1][7]+m2[0][9]*m1[2][1]*m0[1][8]-m2[0][9]*m1[1][8]*m0[2][1]-m2[0][9]*m1[1][7]*m0[2][3]-m2[0][9]*m1[1][6]*m0[2][4]-m2[0][9]*m1[1][4]*m0[2][6]-m2[0][9]*m1[1][3]*m0[2][7]-m2[0][9]*m1[1][1]*m0[2][8]+m2[0][8]*m1[2][9]*m0[1][1]+m2[0][8]*m1[2][7]*m0[1][6]+m2[0][8]*m1[2][6]*m0[1][7]+m2[0][8]*m1[2][1]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][1]-m2[0][8]*m1[1][7]*m0[2][6]-m2[0][8]*m1[1][6]*m0[2][7]-m2[0][8]*m1[1][1]*m0[2][9]+m2[0][7]*m1[2][9]*m0[1][3]+m2[0][7]*m1[2][8]*m0[1][6]+m2[0][7]*m1[2][6]*m0[1][8]+m2[0][7]*m1[2][3]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][3]-m2[0][7]*m1[1][8]*m0[2][6]-m2[0][7]*m1[1][6]*m0[2][8]-m2[0][7]*m1[1][3]*m0[2][9]+m2[0][6]*m1[2][9]*m0[1][4]+m2[0][6]*m1[2][8]*m0[1][7]+m2[0][6]*m1[2][7]*m0[1][8]+m2[0][6]*m1[2][4]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][4]-m2[0][6]*m1[1][8]*m0[2][7]-m2[0][6]*m1[1][7]*m0[2][8]-m2[0][6]*m1[1][4]*m0[2][9]+m2[0][4]*m1[2][9]*m0[1][6]+m2[0][4]*m1[2][6]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][6]-m2[0][4]*m1[1][6]*m0[2][9]+m2[0][3]*m1[2][9]*m0[1][7]+m2[0][3]*m1[2][7]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][7]-m2[0][3]*m1[1][7]*m0[2][9]+m2[0][1]*m1[2][9]*m0[1][8]+m2[0][1]*m1[2][8]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][8]-m2[0][1]*m1[1][8]*m0[2][9]; 
  M1(row,70) = m2[2][9]*m1[1][8]*m0[0][2]+m2[2][9]*m1[1][7]*m0[0][4]+m2[2][9]*m1[1][4]*m0[0][7]+m2[2][9]*m1[1][2]*m0[0][8]-m2[2][9]*m1[0][8]*m0[1][2]-m2[2][9]*m1[0][7]*m0[1][4]-m2[2][9]*m1[0][4]*m0[1][7]-m2[2][9]*m1[0][2]*m0[1][8]+m2[2][8]*m1[1][9]*m0[0][2]+m2[2][8]*m1[1][7]*m0[0][7]+m2[2][8]*m1[1][2]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][2]-m2[2][8]*m1[0][7]*m0[1][7]-m2[2][8]*m1[0][2]*m0[1][9]+m2[2][7]*m1[1][9]*m0[0][4]+m2[2][7]*m1[1][8]*m0[0][7]+m2[2][7]*m1[1][7]*m0[0][8]+m2[2][7]*m1[1][4]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][4]-m2[2][7]*m1[0][8]*m0[1][7]-m2[2][7]*m1[0][7]*m0[1][8]-m2[2][7]*m1[0][4]*m0[1][9]+m2[2][4]*m1[1][9]*m0[0][7]+m2[2][4]*m1[1][7]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][7]-m2[2][4]*m1[0][7]*m0[1][9]+m2[2][2]*m1[1][9]*m0[0][8]+m2[2][2]*m1[1][8]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][8]-m2[2][2]*m1[0][8]*m0[1][9]-m2[1][9]*m1[2][8]*m0[0][2]-m2[1][9]*m1[2][7]*m0[0][4]-m2[1][9]*m1[2][4]*m0[0][7]-m2[1][9]*m1[2][2]*m0[0][8]+m2[1][9]*m1[0][8]*m0[2][2]+m2[1][9]*m1[0][7]*m0[2][4]+m2[1][9]*m1[0][4]*m0[2][7]+m2[1][9]*m1[0][2]*m0[2][8]-m2[1][8]*m1[2][9]*m0[0][2]-m2[1][8]*m1[2][7]*m0[0][7]-m2[1][8]*m1[2][2]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][2]+m2[1][8]*m1[0][7]*m0[2][7]+m2[1][8]*m1[0][2]*m0[2][9]-m2[1][7]*m1[2][9]*m0[0][4]-m2[1][7]*m1[2][8]*m0[0][7]-m2[1][7]*m1[2][7]*m0[0][8]-m2[1][7]*m1[2][4]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][4]+m2[1][7]*m1[0][8]*m0[2][7]+m2[1][7]*m1[0][7]*m0[2][8]+m2[1][7]*m1[0][4]*m0[2][9]-m2[1][4]*m1[2][9]*m0[0][7]-m2[1][4]*m1[2][7]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][7]+m2[1][4]*m1[0][7]*m0[2][9]-m2[1][2]*m1[2][9]*m0[0][8]-m2[1][2]*m1[2][8]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][8]+m2[1][2]*m1[0][8]*m0[2][9]+m2[0][9]*m1[2][8]*m0[1][2]+m2[0][9]*m1[2][7]*m0[1][4]+m2[0][9]*m1[2][4]*m0[1][7]+m2[0][9]*m1[2][2]*m0[1][8]-m2[0][9]*m1[1][8]*m0[2][2]-m2[0][9]*m1[1][7]*m0[2][4]-m2[0][9]*m1[1][4]*m0[2][7]-m2[0][9]*m1[1][2]*m0[2][8]+m2[0][8]*m1[2][9]*m0[1][2]+m2[0][8]*m1[2][7]*m0[1][7]+m2[0][8]*m1[2][2]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][2]-m2[0][8]*m1[1][7]*m0[2][7]-m2[0][8]*m1[1][2]*m0[2][9]+m2[0][7]*m1[2][9]*m0[1][4]+m2[0][7]*m1[2][8]*m0[1][7]+m2[0][7]*m1[2][7]*m0[1][8]+m2[0][7]*m1[2][4]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][4]-m2[0][7]*m1[1][8]*m0[2][7]-m2[0][7]*m1[1][7]*m0[2][8]-m2[0][7]*m1[1][4]*m0[2][9]+m2[0][4]*m1[2][9]*m0[1][7]+m2[0][4]*m1[2][7]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][7]-m2[0][4]*m1[1][7]*m0[2][9]+m2[0][2]*m1[2][9]*m0[1][8]+m2[0][2]*m1[2][8]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][8]-m2[0][2]*m1[1][8]*m0[2][9]; 
  M1(row,71) = m2[2][9]*m1[1][8]*m0[0][3]+m2[2][9]*m1[1][6]*m0[0][5]+m2[2][9]*m1[1][5]*m0[0][6]+m2[2][9]*m1[1][3]*m0[0][8]-m2[2][9]*m1[0][8]*m0[1][3]-m2[2][9]*m1[0][6]*m0[1][5]-m2[2][9]*m1[0][5]*m0[1][6]-m2[2][9]*m1[0][3]*m0[1][8]+m2[2][8]*m1[1][9]*m0[0][3]+m2[2][8]*m1[1][8]*m0[0][6]+m2[2][8]*m1[1][6]*m0[0][8]+m2[2][8]*m1[1][3]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][3]-m2[2][8]*m1[0][8]*m0[1][6]-m2[2][8]*m1[0][6]*m0[1][8]-m2[2][8]*m1[0][3]*m0[1][9]+m2[2][6]*m1[1][9]*m0[0][5]+m2[2][6]*m1[1][8]*m0[0][8]+m2[2][6]*m1[1][5]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][5]-m2[2][6]*m1[0][8]*m0[1][8]-m2[2][6]*m1[0][5]*m0[1][9]+m2[2][5]*m1[1][9]*m0[0][6]+m2[2][5]*m1[1][6]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][6]-m2[2][5]*m1[0][6]*m0[1][9]+m2[2][3]*m1[1][9]*m0[0][8]+m2[2][3]*m1[1][8]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][8]-m2[2][3]*m1[0][8]*m0[1][9]-m2[1][9]*m1[2][8]*m0[0][3]-m2[1][9]*m1[2][6]*m0[0][5]-m2[1][9]*m1[2][5]*m0[0][6]-m2[1][9]*m1[2][3]*m0[0][8]+m2[1][9]*m1[0][8]*m0[2][3]+m2[1][9]*m1[0][6]*m0[2][5]+m2[1][9]*m1[0][5]*m0[2][6]+m2[1][9]*m1[0][3]*m0[2][8]-m2[1][8]*m1[2][9]*m0[0][3]-m2[1][8]*m1[2][8]*m0[0][6]-m2[1][8]*m1[2][6]*m0[0][8]-m2[1][8]*m1[2][3]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][3]+m2[1][8]*m1[0][8]*m0[2][6]+m2[1][8]*m1[0][6]*m0[2][8]+m2[1][8]*m1[0][3]*m0[2][9]-m2[1][6]*m1[2][9]*m0[0][5]-m2[1][6]*m1[2][8]*m0[0][8]-m2[1][6]*m1[2][5]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][5]+m2[1][6]*m1[0][8]*m0[2][8]+m2[1][6]*m1[0][5]*m0[2][9]-m2[1][5]*m1[2][9]*m0[0][6]-m2[1][5]*m1[2][6]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][6]+m2[1][5]*m1[0][6]*m0[2][9]-m2[1][3]*m1[2][9]*m0[0][8]-m2[1][3]*m1[2][8]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][8]+m2[1][3]*m1[0][8]*m0[2][9]+m2[0][9]*m1[2][8]*m0[1][3]+m2[0][9]*m1[2][6]*m0[1][5]+m2[0][9]*m1[2][5]*m0[1][6]+m2[0][9]*m1[2][3]*m0[1][8]-m2[0][9]*m1[1][8]*m0[2][3]-m2[0][9]*m1[1][6]*m0[2][5]-m2[0][9]*m1[1][5]*m0[2][6]-m2[0][9]*m1[1][3]*m0[2][8]+m2[0][8]*m1[2][9]*m0[1][3]+m2[0][8]*m1[2][8]*m0[1][6]+m2[0][8]*m1[2][6]*m0[1][8]+m2[0][8]*m1[2][3]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][3]-m2[0][8]*m1[1][8]*m0[2][6]-m2[0][8]*m1[1][6]*m0[2][8]-m2[0][8]*m1[1][3]*m0[2][9]+m2[0][6]*m1[2][9]*m0[1][5]+m2[0][6]*m1[2][8]*m0[1][8]+m2[0][6]*m1[2][5]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][5]-m2[0][6]*m1[1][8]*m0[2][8]-m2[0][6]*m1[1][5]*m0[2][9]+m2[0][5]*m1[2][9]*m0[1][6]+m2[0][5]*m1[2][6]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][6]-m2[0][5]*m1[1][6]*m0[2][9]+m2[0][3]*m1[2][9]*m0[1][8]+m2[0][3]*m1[2][8]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][8]-m2[0][3]*m1[1][8]*m0[2][9]; 
  M1(row,72) = m2[2][9]*m1[1][8]*m0[0][4]+m2[2][9]*m1[1][7]*m0[0][5]+m2[2][9]*m1[1][5]*m0[0][7]+m2[2][9]*m1[1][4]*m0[0][8]-m2[2][9]*m1[0][8]*m0[1][4]-m2[2][9]*m1[0][7]*m0[1][5]-m2[2][9]*m1[0][5]*m0[1][7]-m2[2][9]*m1[0][4]*m0[1][8]+m2[2][8]*m1[1][9]*m0[0][4]+m2[2][8]*m1[1][8]*m0[0][7]+m2[2][8]*m1[1][7]*m0[0][8]+m2[2][8]*m1[1][4]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][4]-m2[2][8]*m1[0][8]*m0[1][7]-m2[2][8]*m1[0][7]*m0[1][8]-m2[2][8]*m1[0][4]*m0[1][9]+m2[2][7]*m1[1][9]*m0[0][5]+m2[2][7]*m1[1][8]*m0[0][8]+m2[2][7]*m1[1][5]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][5]-m2[2][7]*m1[0][8]*m0[1][8]-m2[2][7]*m1[0][5]*m0[1][9]+m2[2][5]*m1[1][9]*m0[0][7]+m2[2][5]*m1[1][7]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][7]-m2[2][5]*m1[0][7]*m0[1][9]+m2[2][4]*m1[1][9]*m0[0][8]+m2[2][4]*m1[1][8]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][8]-m2[2][4]*m1[0][8]*m0[1][9]-m2[1][9]*m1[2][8]*m0[0][4]-m2[1][9]*m1[2][7]*m0[0][5]-m2[1][9]*m1[2][5]*m0[0][7]-m2[1][9]*m1[2][4]*m0[0][8]+m2[1][9]*m1[0][8]*m0[2][4]+m2[1][9]*m1[0][7]*m0[2][5]+m2[1][9]*m1[0][5]*m0[2][7]+m2[1][9]*m1[0][4]*m0[2][8]-m2[1][8]*m1[2][9]*m0[0][4]-m2[1][8]*m1[2][8]*m0[0][7]-m2[1][8]*m1[2][7]*m0[0][8]-m2[1][8]*m1[2][4]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][4]+m2[1][8]*m1[0][8]*m0[2][7]+m2[1][8]*m1[0][7]*m0[2][8]+m2[1][8]*m1[0][4]*m0[2][9]-m2[1][7]*m1[2][9]*m0[0][5]-m2[1][7]*m1[2][8]*m0[0][8]-m2[1][7]*m1[2][5]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][5]+m2[1][7]*m1[0][8]*m0[2][8]+m2[1][7]*m1[0][5]*m0[2][9]-m2[1][5]*m1[2][9]*m0[0][7]-m2[1][5]*m1[2][7]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][7]+m2[1][5]*m1[0][7]*m0[2][9]-m2[1][4]*m1[2][9]*m0[0][8]-m2[1][4]*m1[2][8]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][8]+m2[1][4]*m1[0][8]*m0[2][9]+m2[0][9]*m1[2][8]*m0[1][4]+m2[0][9]*m1[2][7]*m0[1][5]+m2[0][9]*m1[2][5]*m0[1][7]+m2[0][9]*m1[2][4]*m0[1][8]-m2[0][9]*m1[1][8]*m0[2][4]-m2[0][9]*m1[1][7]*m0[2][5]-m2[0][9]*m1[1][5]*m0[2][7]-m2[0][9]*m1[1][4]*m0[2][8]+m2[0][8]*m1[2][9]*m0[1][4]+m2[0][8]*m1[2][8]*m0[1][7]+m2[0][8]*m1[2][7]*m0[1][8]+m2[0][8]*m1[2][4]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][4]-m2[0][8]*m1[1][8]*m0[2][7]-m2[0][8]*m1[1][7]*m0[2][8]-m2[0][8]*m1[1][4]*m0[2][9]+m2[0][7]*m1[2][9]*m0[1][5]+m2[0][7]*m1[2][8]*m0[1][8]+m2[0][7]*m1[2][5]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][5]-m2[0][7]*m1[1][8]*m0[2][8]-m2[0][7]*m1[1][5]*m0[2][9]+m2[0][5]*m1[2][9]*m0[1][7]+m2[0][5]*m1[2][7]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][7]-m2[0][5]*m1[1][7]*m0[2][9]+m2[0][4]*m1[2][9]*m0[1][8]+m2[0][4]*m1[2][8]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][8]-m2[0][4]*m1[1][8]*m0[2][9]; 
  M1(row,73) = m2[2][9]*m1[1][8]*m0[0][5]+m2[2][9]*m1[1][5]*m0[0][8]-m2[2][9]*m1[0][8]*m0[1][5]-m2[2][9]*m1[0][5]*m0[1][8]+m2[2][8]*m1[1][9]*m0[0][5]+m2[2][8]*m1[1][8]*m0[0][8]+m2[2][8]*m1[1][5]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][5]-m2[2][8]*m1[0][8]*m0[1][8]-m2[2][8]*m1[0][5]*m0[1][9]+m2[2][5]*m1[1][9]*m0[0][8]+m2[2][5]*m1[1][8]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][8]-m2[2][5]*m1[0][8]*m0[1][9]-m2[1][9]*m1[2][8]*m0[0][5]-m2[1][9]*m1[2][5]*m0[0][8]+m2[1][9]*m1[0][8]*m0[2][5]+m2[1][9]*m1[0][5]*m0[2][8]-m2[1][8]*m1[2][9]*m0[0][5]-m2[1][8]*m1[2][8]*m0[0][8]-m2[1][8]*m1[2][5]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][5]+m2[1][8]*m1[0][8]*m0[2][8]+m2[1][8]*m1[0][5]*m0[2][9]-m2[1][5]*m1[2][9]*m0[0][8]-m2[1][5]*m1[2][8]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][8]+m2[1][5]*m1[0][8]*m0[2][9]+m2[0][9]*m1[2][8]*m0[1][5]+m2[0][9]*m1[2][5]*m0[1][8]-m2[0][9]*m1[1][8]*m0[2][5]-m2[0][9]*m1[1][5]*m0[2][8]+m2[0][8]*m1[2][9]*m0[1][5]+m2[0][8]*m1[2][8]*m0[1][8]+m2[0][8]*m1[2][5]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][5]-m2[0][8]*m1[1][8]*m0[2][8]-m2[0][8]*m1[1][5]*m0[2][9]+m2[0][5]*m1[2][9]*m0[1][8]+m2[0][5]*m1[2][8]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][8]-m2[0][5]*m1[1][8]*m0[2][9]; 
  M1(row,74) = m2[2][9]*m1[1][9]*m0[0][0]+m2[2][9]*m1[1][6]*m0[0][6]+m2[2][9]*m1[1][0]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][0]-m2[2][9]*m1[0][6]*m0[1][6]-m2[2][9]*m1[0][0]*m0[1][9]+m2[2][6]*m1[1][9]*m0[0][6]+m2[2][6]*m1[1][6]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][6]-m2[2][6]*m1[0][6]*m0[1][9]+m2[2][0]*m1[1][9]*m0[0][9]-m2[2][0]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][0]-m2[1][9]*m1[2][6]*m0[0][6]-m2[1][9]*m1[2][0]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][0]+m2[1][9]*m1[0][6]*m0[2][6]+m2[1][9]*m1[0][0]*m0[2][9]-m2[1][6]*m1[2][9]*m0[0][6]-m2[1][6]*m1[2][6]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][6]+m2[1][6]*m1[0][6]*m0[2][9]-m2[1][0]*m1[2][9]*m0[0][9]+m2[1][0]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][0]+m2[0][9]*m1[2][6]*m0[1][6]+m2[0][9]*m1[2][0]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][0]-m2[0][9]*m1[1][6]*m0[2][6]-m2[0][9]*m1[1][0]*m0[2][9]+m2[0][6]*m1[2][9]*m0[1][6]+m2[0][6]*m1[2][6]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][6]-m2[0][6]*m1[1][6]*m0[2][9]+m2[0][0]*m1[2][9]*m0[1][9]-m2[0][0]*m1[1][9]*m0[2][9]; 
  M1(row,75) = m2[2][9]*m1[1][9]*m0[0][1]+m2[2][9]*m1[1][7]*m0[0][6]+m2[2][9]*m1[1][6]*m0[0][7]+m2[2][9]*m1[1][1]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][1]-m2[2][9]*m1[0][7]*m0[1][6]-m2[2][9]*m1[0][6]*m0[1][7]-m2[2][9]*m1[0][1]*m0[1][9]+m2[2][7]*m1[1][9]*m0[0][6]+m2[2][7]*m1[1][6]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][6]-m2[2][7]*m1[0][6]*m0[1][9]+m2[2][6]*m1[1][9]*m0[0][7]+m2[2][6]*m1[1][7]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][7]-m2[2][6]*m1[0][7]*m0[1][9]+m2[2][1]*m1[1][9]*m0[0][9]-m2[2][1]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][1]-m2[1][9]*m1[2][7]*m0[0][6]-m2[1][9]*m1[2][6]*m0[0][7]-m2[1][9]*m1[2][1]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][1]+m2[1][9]*m1[0][7]*m0[2][6]+m2[1][9]*m1[0][6]*m0[2][7]+m2[1][9]*m1[0][1]*m0[2][9]-m2[1][7]*m1[2][9]*m0[0][6]-m2[1][7]*m1[2][6]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][6]+m2[1][7]*m1[0][6]*m0[2][9]-m2[1][6]*m1[2][9]*m0[0][7]-m2[1][6]*m1[2][7]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][7]+m2[1][6]*m1[0][7]*m0[2][9]-m2[1][1]*m1[2][9]*m0[0][9]+m2[1][1]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][1]+m2[0][9]*m1[2][7]*m0[1][6]+m2[0][9]*m1[2][6]*m0[1][7]+m2[0][9]*m1[2][1]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][1]-m2[0][9]*m1[1][7]*m0[2][6]-m2[0][9]*m1[1][6]*m0[2][7]-m2[0][9]*m1[1][1]*m0[2][9]+m2[0][7]*m1[2][9]*m0[1][6]+m2[0][7]*m1[2][6]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][6]-m2[0][7]*m1[1][6]*m0[2][9]+m2[0][6]*m1[2][9]*m0[1][7]+m2[0][6]*m1[2][7]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][7]-m2[0][6]*m1[1][7]*m0[2][9]+m2[0][1]*m1[2][9]*m0[1][9]-m2[0][1]*m1[1][9]*m0[2][9]; 
  M1(row,76) = m2[2][9]*m1[1][9]*m0[0][2]+m2[2][9]*m1[1][7]*m0[0][7]+m2[2][9]*m1[1][2]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][2]-m2[2][9]*m1[0][7]*m0[1][7]-m2[2][9]*m1[0][2]*m0[1][9]+m2[2][7]*m1[1][9]*m0[0][7]+m2[2][7]*m1[1][7]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][7]-m2[2][7]*m1[0][7]*m0[1][9]+m2[2][2]*m1[1][9]*m0[0][9]-m2[2][2]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][2]-m2[1][9]*m1[2][7]*m0[0][7]-m2[1][9]*m1[2][2]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][2]+m2[1][9]*m1[0][7]*m0[2][7]+m2[1][9]*m1[0][2]*m0[2][9]-m2[1][7]*m1[2][9]*m0[0][7]-m2[1][7]*m1[2][7]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][7]+m2[1][7]*m1[0][7]*m0[2][9]-m2[1][2]*m1[2][9]*m0[0][9]+m2[1][2]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][2]+m2[0][9]*m1[2][7]*m0[1][7]+m2[0][9]*m1[2][2]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][2]-m2[0][9]*m1[1][7]*m0[2][7]-m2[0][9]*m1[1][2]*m0[2][9]+m2[0][7]*m1[2][9]*m0[1][7]+m2[0][7]*m1[2][7]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][7]-m2[0][7]*m1[1][7]*m0[2][9]+m2[0][2]*m1[2][9]*m0[1][9]-m2[0][2]*m1[1][9]*m0[2][9]; 
  M1(row,77) = m2[2][9]*m1[1][9]*m0[0][3]+m2[2][9]*m1[1][8]*m0[0][6]+m2[2][9]*m1[1][6]*m0[0][8]+m2[2][9]*m1[1][3]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][3]-m2[2][9]*m1[0][8]*m0[1][6]-m2[2][9]*m1[0][6]*m0[1][8]-m2[2][9]*m1[0][3]*m0[1][9]+m2[2][8]*m1[1][9]*m0[0][6]+m2[2][8]*m1[1][6]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][6]-m2[2][8]*m1[0][6]*m0[1][9]+m2[2][6]*m1[1][9]*m0[0][8]+m2[2][6]*m1[1][8]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][8]-m2[2][6]*m1[0][8]*m0[1][9]+m2[2][3]*m1[1][9]*m0[0][9]-m2[2][3]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][3]-m2[1][9]*m1[2][8]*m0[0][6]-m2[1][9]*m1[2][6]*m0[0][8]-m2[1][9]*m1[2][3]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][3]+m2[1][9]*m1[0][8]*m0[2][6]+m2[1][9]*m1[0][6]*m0[2][8]+m2[1][9]*m1[0][3]*m0[2][9]-m2[1][8]*m1[2][9]*m0[0][6]-m2[1][8]*m1[2][6]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][6]+m2[1][8]*m1[0][6]*m0[2][9]-m2[1][6]*m1[2][9]*m0[0][8]-m2[1][6]*m1[2][8]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][8]+m2[1][6]*m1[0][8]*m0[2][9]-m2[1][3]*m1[2][9]*m0[0][9]+m2[1][3]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][3]+m2[0][9]*m1[2][8]*m0[1][6]+m2[0][9]*m1[2][6]*m0[1][8]+m2[0][9]*m1[2][3]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][3]-m2[0][9]*m1[1][8]*m0[2][6]-m2[0][9]*m1[1][6]*m0[2][8]-m2[0][9]*m1[1][3]*m0[2][9]+m2[0][8]*m1[2][9]*m0[1][6]+m2[0][8]*m1[2][6]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][6]-m2[0][8]*m1[1][6]*m0[2][9]+m2[0][6]*m1[2][9]*m0[1][8]+m2[0][6]*m1[2][8]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][8]-m2[0][6]*m1[1][8]*m0[2][9]+m2[0][3]*m1[2][9]*m0[1][9]-m2[0][3]*m1[1][9]*m0[2][9]; 
  M1(row,78) = m2[2][9]*m1[1][9]*m0[0][4]+m2[2][9]*m1[1][8]*m0[0][7]+m2[2][9]*m1[1][7]*m0[0][8]+m2[2][9]*m1[1][4]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][4]-m2[2][9]*m1[0][8]*m0[1][7]-m2[2][9]*m1[0][7]*m0[1][8]-m2[2][9]*m1[0][4]*m0[1][9]+m2[2][8]*m1[1][9]*m0[0][7]+m2[2][8]*m1[1][7]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][7]-m2[2][8]*m1[0][7]*m0[1][9]+m2[2][7]*m1[1][9]*m0[0][8]+m2[2][7]*m1[1][8]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][8]-m2[2][7]*m1[0][8]*m0[1][9]+m2[2][4]*m1[1][9]*m0[0][9]-m2[2][4]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][4]-m2[1][9]*m1[2][8]*m0[0][7]-m2[1][9]*m1[2][7]*m0[0][8]-m2[1][9]*m1[2][4]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][4]+m2[1][9]*m1[0][8]*m0[2][7]+m2[1][9]*m1[0][7]*m0[2][8]+m2[1][9]*m1[0][4]*m0[2][9]-m2[1][8]*m1[2][9]*m0[0][7]-m2[1][8]*m1[2][7]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][7]+m2[1][8]*m1[0][7]*m0[2][9]-m2[1][7]*m1[2][9]*m0[0][8]-m2[1][7]*m1[2][8]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][8]+m2[1][7]*m1[0][8]*m0[2][9]-m2[1][4]*m1[2][9]*m0[0][9]+m2[1][4]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][4]+m2[0][9]*m1[2][8]*m0[1][7]+m2[0][9]*m1[2][7]*m0[1][8]+m2[0][9]*m1[2][4]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][4]-m2[0][9]*m1[1][8]*m0[2][7]-m2[0][9]*m1[1][7]*m0[2][8]-m2[0][9]*m1[1][4]*m0[2][9]+m2[0][8]*m1[2][9]*m0[1][7]+m2[0][8]*m1[2][7]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][7]-m2[0][8]*m1[1][7]*m0[2][9]+m2[0][7]*m1[2][9]*m0[1][8]+m2[0][7]*m1[2][8]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][8]-m2[0][7]*m1[1][8]*m0[2][9]+m2[0][4]*m1[2][9]*m0[1][9]-m2[0][4]*m1[1][9]*m0[2][9]; 
  M1(row,79) = m2[2][9]*m1[1][9]*m0[0][5]+m2[2][9]*m1[1][8]*m0[0][8]+m2[2][9]*m1[1][5]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][5]-m2[2][9]*m1[0][8]*m0[1][8]-m2[2][9]*m1[0][5]*m0[1][9]+m2[2][8]*m1[1][9]*m0[0][8]+m2[2][8]*m1[1][8]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][8]-m2[2][8]*m1[0][8]*m0[1][9]+m2[2][5]*m1[1][9]*m0[0][9]-m2[2][5]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][5]-m2[1][9]*m1[2][8]*m0[0][8]-m2[1][9]*m1[2][5]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][5]+m2[1][9]*m1[0][8]*m0[2][8]+m2[1][9]*m1[0][5]*m0[2][9]-m2[1][8]*m1[2][9]*m0[0][8]-m2[1][8]*m1[2][8]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][8]+m2[1][8]*m1[0][8]*m0[2][9]-m2[1][5]*m1[2][9]*m0[0][9]+m2[1][5]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][5]+m2[0][9]*m1[2][8]*m0[1][8]+m2[0][9]*m1[2][5]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][5]-m2[0][9]*m1[1][8]*m0[2][8]-m2[0][9]*m1[1][5]*m0[2][9]+m2[0][8]*m1[2][9]*m0[1][8]+m2[0][8]*m1[2][8]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][8]-m2[0][8]*m1[1][8]*m0[2][9]+m2[0][5]*m1[2][9]*m0[1][9]-m2[0][5]*m1[1][9]*m0[2][9]; 
  M1(row,80) = m2[2][9]*m1[1][9]*m0[0][6]+m2[2][9]*m1[1][6]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][6]-m2[2][9]*m1[0][6]*m0[1][9]+m2[2][6]*m1[1][9]*m0[0][9]-m2[2][6]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][6]-m2[1][9]*m1[2][6]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][6]+m2[1][9]*m1[0][6]*m0[2][9]-m2[1][6]*m1[2][9]*m0[0][9]+m2[1][6]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][6]+m2[0][9]*m1[2][6]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][6]-m2[0][9]*m1[1][6]*m0[2][9]+m2[0][6]*m1[2][9]*m0[1][9]-m2[0][6]*m1[1][9]*m0[2][9]; 
  M1(row,81) = m2[2][9]*m1[1][9]*m0[0][7]+m2[2][9]*m1[1][7]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][7]-m2[2][9]*m1[0][7]*m0[1][9]+m2[2][7]*m1[1][9]*m0[0][9]-m2[2][7]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][7]-m2[1][9]*m1[2][7]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][7]+m2[1][9]*m1[0][7]*m0[2][9]-m2[1][7]*m1[2][9]*m0[0][9]+m2[1][7]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][7]+m2[0][9]*m1[2][7]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][7]-m2[0][9]*m1[1][7]*m0[2][9]+m2[0][7]*m1[2][9]*m0[1][9]-m2[0][7]*m1[1][9]*m0[2][9]; 
  M1(row,82) = m2[2][9]*m1[1][9]*m0[0][8]+m2[2][9]*m1[1][8]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][8]-m2[2][9]*m1[0][8]*m0[1][9]+m2[2][8]*m1[1][9]*m0[0][9]-m2[2][8]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][8]-m2[1][9]*m1[2][8]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][8]+m2[1][9]*m1[0][8]*m0[2][9]-m2[1][8]*m1[2][9]*m0[0][9]+m2[1][8]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][8]+m2[0][9]*m1[2][8]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][8]-m2[0][9]*m1[1][8]*m0[2][9]+m2[0][8]*m1[2][9]*m0[1][9]-m2[0][8]*m1[1][9]*m0[2][9]; 
  M1(row,83) = m2[2][9]*m1[1][9]*m0[0][9]-m2[2][9]*m1[0][9]*m0[1][9]-m2[1][9]*m1[2][9]*m0[0][9]+m2[1][9]*m1[0][9]*m0[2][9]+m2[0][9]*m1[2][9]*m0[1][9]-m2[0][9]*m1[1][9]*m0[2][9];
}

#if EQS > 50
#define DECA_EQS 6
#else
  #if EQS > 40
  #define DECA_EQS 5
  #else
    #if EQS > 30
    #define DECA_EQS 4
    #else
      #if EQS > 20
      #define DECA_EQS 3
      #else
        #define DECA_EQS 2
      #endif
    #endif
  #endif
#endif

void
opengv::relative_pose::modules::sixpt::setupAction(
    const std::vector<Eigen::Matrix<double,6,1>,Eigen::aligned_allocator< Eigen::Matrix<double,6,1> > > & L1,
    const std::vector<Eigen::Matrix<double,6,1>,Eigen::aligned_allocator< Eigen::Matrix<double,6,1> > > & L2,
    Eigen::Matrix<double,64,64> & Action )
{
  std::vector<double> m[DECA_EQS][5][3];
  for( int primI = 0; primI < DECA_EQS; primI++ )
  {
    for( int secI = 0; secI < 6; secI++ )
    {
      if( primI != secI )
      {
        const Eigen::Matrix<double,6,1> & l01 = L1[primI];
        const Eigen::Matrix<double,6,1> & l02 = L2[primI];
        const Eigen::Matrix<double,6,1> & l11 = L1[secI];
        const Eigen::Matrix<double,6,1> & l12 = L2[secI];
        
        int r = secI;
        if(secI > primI)
          r--;
        
        fillRow1( l01, l02, l11, l12, m[primI][r][0], m[primI][r][1], m[primI][r][2] );
      }
    }
  }

  Eigen::Matrix<double,EQS,84> M1p = Eigen::Matrix<double,EQS,84>::Zero();
  
  int decaIndex = 0;
  int row0 = 0;
  int row1 = 1;
  int row2 = 2;
  
  for( int row = 0; row < EQS; row++ )
  {
    fillRow2( M1p, row, m[decaIndex][row0], m[decaIndex][row1], m[decaIndex][row2] );
    
    row2++;
    if( row2 > 4 )
    {
      row1++;
      row2 = row1 + 1;
      if( row1 > 3 )
      {
        row0++;
        row1 = row0 + 1;
        row2 = row1 + 1;
        
        if( row0 > 2)
        {
          decaIndex++;
          row0 = 0;
          row1 = 1;
          row2 = 2;
        }
      }
    }
  }
  
  //this is currently hardcoded for 15 equations!
  //Eigen::Matrix<double,15,15> M1_part1 = M1.block<15,15>(0,0);
  //Eigen::Matrix<double,15,84> M1_part2 = M1_part1.inverse() * M1;
  //M1 = M1_part2;
  
  Eigen::Matrix<double,EQS,15> B = M1p.block<EQS,15>(0,0);
  Eigen::Matrix<double,15,EQS> Bt = B.transpose();
  Eigen::Matrix<double,15,15> BtB = Bt * B;
  Eigen::Matrix<double,15,84> M1 = BtB.inverse() * Bt * M1p;
  
  Eigen::Matrix<double,93,157> M2 = Eigen::Matrix<double,93,157>::Zero();
M2(0,23) = M1(14,14); M2(0,24) = M1(14,15); M2(0,25) = M1(14,16); M2(0,26) = M1(14,17); M2(0,27) = M1(14,18); M2(0,28) = M1(14,19); M2(0,29) = M1(14,20); M2(0,30) = M1(14,21); M2(0,31) = M1(14,22); M2(0,32) = M1(14,23); M2(0,33) = M1(14,24); M2(0,34) = M1(14,25); M2(0,35) = M1(14,26); M2(0,36) = M1(14,27); M2(0,52) = M1(14,28); M2(0,53) = M1(14,29); M2(0,54) = M1(14,30); M2(0,55) = M1(14,31); M2(0,56) = M1(14,32); M2(0,57) = M1(14,33); M2(0,58) = M1(14,34); M2(0,59) = M1(14,35); M2(0,60) = M1(14,36); M2(0,61) = M1(14,37); M2(0,62) = M1(14,38); M2(0,63) = M1(14,39); M2(0,64) = M1(14,40); M2(0,65) = M1(14,41); M2(0,66) = M1(14,42); M2(0,67) = M1(14,43); M2(0,68) = M1(14,44); M2(0,69) = M1(14,45); M2(0,70) = M1(14,46); M2(0,71) = M1(14,47); M2(0,85) = M1(14,49); M2(0,86) = M1(14,50); M2(0,87) = M1(14,51); M2(0,88) = M1(14,52); M2(0,89) = M1(14,53); M2(0,90) = M1(14,54); M2(0,91) = M1(14,55); M2(0,92) = M1(14,56); M2(0,93) = M1(14,48); M2(0,94) = M1(14,57); M2(0,95) = M1(14,58); M2(0,96) = M1(14,59); M2(0,97) = M1(14,60); M2(0,98) = M1(14,61); M2(0,99) = M1(14,62); M2(0,100) = M1(14,63); M2(0,112) = M1(14,64); M2(0,113) = M1(14,65); M2(0,114) = M1(14,66); M2(0,115) = M1(14,67); M2(0,116) = M1(14,68); M2(0,117) = M1(14,69); M2(0,118) = M1(14,70); M2(0,119) = M1(14,71); M2(0,120) = M1(14,72); M2(0,121) = M1(14,73); M2(0,131) = M1(14,74); M2(0,132) = M1(14,75); M2(0,133) = M1(14,76); M2(0,134) = M1(14,77); M2(0,135) = M1(14,78); M2(0,136) = M1(14,79); M2(0,144) = M1(14,80); M2(0,145) = M1(14,81); M2(0,146) = M1(14,82); M2(0,152) = M1(14,83); 
M2(1,18) = M1(14,14); M2(1,19) = M1(14,15); M2(1,20) = M1(14,16); M2(1,21) = M1(14,17); M2(1,23) = M1(14,18); M2(1,24) = M1(14,19); M2(1,25) = M1(14,20); M2(1,26) = M1(14,21); M2(1,28) = M1(14,22); M2(1,29) = M1(14,23); M2(1,30) = M1(14,24); M2(1,32) = M1(14,25); M2(1,33) = M1(14,26); M2(1,35) = M1(14,27); M2(1,46) = M1(14,28); M2(1,47) = M1(14,29); M2(1,48) = M1(14,30); M2(1,49) = M1(14,31); M2(1,50) = M1(14,32); M2(1,51) = M1(14,33); M2(1,53) = M1(14,34); M2(1,54) = M1(14,35); M2(1,55) = M1(14,36); M2(1,56) = M1(14,37); M2(1,57) = M1(14,38); M2(1,59) = M1(14,39); M2(1,60) = M1(14,40); M2(1,61) = M1(14,41); M2(1,62) = M1(14,42); M2(1,64) = M1(14,43); M2(1,65) = M1(14,44); M2(1,66) = M1(14,45); M2(1,68) = M1(14,46); M2(1,69) = M1(14,47); M2(1,71) = M1(14,48); M2(1,80) = M1(14,49); M2(1,81) = M1(14,50); M2(1,82) = M1(14,51); M2(1,83) = M1(14,52); M2(1,84) = M1(14,53); M2(1,86) = M1(14,54); M2(1,87) = M1(14,55); M2(1,88) = M1(14,56); M2(1,89) = M1(14,57); M2(1,91) = M1(14,58); M2(1,92) = M1(14,59); M2(1,94) = M1(14,60); M2(1,96) = M1(14,61); M2(1,97) = M1(14,62); M2(1,99) = M1(14,63); M2(1,108) = M1(14,64); M2(1,109) = M1(14,65); M2(1,110) = M1(14,66); M2(1,111) = M1(14,67); M2(1,113) = M1(14,68); M2(1,114) = M1(14,69); M2(1,115) = M1(14,70); M2(1,117) = M1(14,71); M2(1,118) = M1(14,72); M2(1,120) = M1(14,73); M2(1,128) = M1(14,74); M2(1,129) = M1(14,75); M2(1,130) = M1(14,76); M2(1,132) = M1(14,77); M2(1,133) = M1(14,78); M2(1,135) = M1(14,79); M2(1,142) = M1(14,80); M2(1,143) = M1(14,81); M2(1,145) = M1(14,82); M2(1,151) = M1(14,83); 
M2(2,6) = M1(8,8); M2(2,13) = M1(8,15); M2(2,14) = M1(8,16); M2(2,15) = M1(8,17); M2(2,18) = M1(8,18); M2(2,19) = M1(8,19); M2(2,20) = M1(8,20); M2(2,21) = M1(8,21); M2(2,24) = M1(8,22); M2(2,25) = M1(8,23); M2(2,26) = M1(8,24); M2(2,29) = M1(8,25); M2(2,30) = M1(8,26); M2(2,33) = M1(8,27); M2(2,39) = M1(8,28); M2(2,40) = M1(8,29); M2(2,41) = M1(8,30); M2(2,42) = M1(8,31); M2(2,43) = M1(8,32); M2(2,44) = M1(8,33); M2(2,47) = M1(8,34); M2(2,48) = M1(8,35); M2(2,49) = M1(8,36); M2(2,50) = M1(8,37); M2(2,51) = M1(8,38); M2(2,54) = M1(8,39); M2(2,55) = M1(8,40); M2(2,56) = M1(8,41); M2(2,57) = M1(8,42); M2(2,60) = M1(8,43); M2(2,61) = M1(8,44); M2(2,62) = M1(8,45); M2(2,65) = M1(8,46); M2(2,66) = M1(8,47); M2(2,69) = M1(8,48); M2(2,74) = M1(8,49); M2(2,75) = M1(8,50); M2(2,76) = M1(8,51); M2(2,77) = M1(8,52); M2(2,78) = M1(8,53); M2(2,81) = M1(8,54); M2(2,82) = M1(8,55); M2(2,83) = M1(8,56); M2(2,84) = M1(8,57); M2(2,87) = M1(8,58); M2(2,88) = M1(8,59); M2(2,89) = M1(8,60); M2(2,92) = M1(8,61); M2(2,94) = M1(8,62); M2(2,97) = M1(8,63); M2(2,103) = M1(8,64); M2(2,104) = M1(8,65); M2(2,105) = M1(8,66); M2(2,106) = M1(8,67); M2(2,109) = M1(8,68); M2(2,110) = M1(8,69); M2(2,111) = M1(8,70); M2(2,114) = M1(8,71); M2(2,115) = M1(8,72); M2(2,118) = M1(8,73); M2(2,124) = M1(8,74); M2(2,125) = M1(8,75); M2(2,126) = M1(8,76); M2(2,129) = M1(8,77); M2(2,130) = M1(8,78); M2(2,133) = M1(8,79); M2(2,139) = M1(8,80); M2(2,140) = M1(8,81); M2(2,143) = M1(8,82); M2(2,149) = M1(8,83); 
M2(3,7) = M1(9,9); M2(3,13) = M1(9,15); M2(3,14) = M1(9,16); M2(3,15) = M1(9,17); M2(3,18) = M1(9,18); M2(3,19) = M1(9,19); M2(3,20) = M1(9,20); M2(3,21) = M1(9,21); M2(3,24) = M1(9,22); M2(3,25) = M1(9,23); M2(3,26) = M1(9,24); M2(3,29) = M1(9,25); M2(3,30) = M1(9,26); M2(3,33) = M1(9,27); M2(3,39) = M1(9,28); M2(3,40) = M1(9,29); M2(3,41) = M1(9,30); M2(3,42) = M1(9,31); M2(3,43) = M1(9,32); M2(3,44) = M1(9,33); M2(3,47) = M1(9,34); M2(3,48) = M1(9,35); M2(3,49) = M1(9,36); M2(3,50) = M1(9,37); M2(3,51) = M1(9,38); M2(3,54) = M1(9,39); M2(3,55) = M1(9,40); M2(3,56) = M1(9,41); M2(3,57) = M1(9,42); M2(3,60) = M1(9,43); M2(3,61) = M1(9,44); M2(3,62) = M1(9,45); M2(3,65) = M1(9,46); M2(3,66) = M1(9,47); M2(3,69) = M1(9,48); M2(3,74) = M1(9,49); M2(3,75) = M1(9,50); M2(3,76) = M1(9,51); M2(3,77) = M1(9,52); M2(3,78) = M1(9,53); M2(3,81) = M1(9,54); M2(3,82) = M1(9,55); M2(3,83) = M1(9,56); M2(3,84) = M1(9,57); M2(3,87) = M1(9,58); M2(3,88) = M1(9,59); M2(3,89) = M1(9,60); M2(3,92) = M1(9,61); M2(3,94) = M1(9,62); M2(3,97) = M1(9,63); M2(3,103) = M1(9,64); M2(3,104) = M1(9,65); M2(3,105) = M1(9,66); M2(3,106) = M1(9,67); M2(3,109) = M1(9,68); M2(3,110) = M1(9,69); M2(3,111) = M1(9,70); M2(3,114) = M1(9,71); M2(3,115) = M1(9,72); M2(3,118) = M1(9,73); M2(3,124) = M1(9,74); M2(3,125) = M1(9,75); M2(3,126) = M1(9,76); M2(3,129) = M1(9,77); M2(3,130) = M1(9,78); M2(3,133) = M1(9,79); M2(3,139) = M1(9,80); M2(3,140) = M1(9,81); M2(3,143) = M1(9,82); M2(3,149) = M1(9,83); 
M2(4,8) = M1(10,10); M2(4,13) = M1(10,15); M2(4,14) = M1(10,16); M2(4,15) = M1(10,17); M2(4,18) = M1(10,18); M2(4,19) = M1(10,19); M2(4,20) = M1(10,20); M2(4,21) = M1(10,21); M2(4,24) = M1(10,22); M2(4,25) = M1(10,23); M2(4,26) = M1(10,24); M2(4,29) = M1(10,25); M2(4,30) = M1(10,26); M2(4,33) = M1(10,27); M2(4,39) = M1(10,28); M2(4,40) = M1(10,29); M2(4,41) = M1(10,30); M2(4,42) = M1(10,31); M2(4,43) = M1(10,32); M2(4,44) = M1(10,33); M2(4,47) = M1(10,34); M2(4,48) = M1(10,35); M2(4,49) = M1(10,36); M2(4,50) = M1(10,37); M2(4,51) = M1(10,38); M2(4,54) = M1(10,39); M2(4,55) = M1(10,40); M2(4,56) = M1(10,41); M2(4,57) = M1(10,42); M2(4,60) = M1(10,43); M2(4,61) = M1(10,44); M2(4,62) = M1(10,45); M2(4,65) = M1(10,46); M2(4,66) = M1(10,47); M2(4,69) = M1(10,48); M2(4,74) = M1(10,49); M2(4,75) = M1(10,50); M2(4,76) = M1(10,51); M2(4,77) = M1(10,52); M2(4,78) = M1(10,53); M2(4,81) = M1(10,54); M2(4,82) = M1(10,55); M2(4,83) = M1(10,56); M2(4,84) = M1(10,57); M2(4,87) = M1(10,58); M2(4,88) = M1(10,59); M2(4,89) = M1(10,60); M2(4,92) = M1(10,61); M2(4,94) = M1(10,62); M2(4,97) = M1(10,63); M2(4,103) = M1(10,64); M2(4,104) = M1(10,65); M2(4,105) = M1(10,66); M2(4,106) = M1(10,67); M2(4,109) = M1(10,68); M2(4,110) = M1(10,69); M2(4,111) = M1(10,70); M2(4,114) = M1(10,71); M2(4,115) = M1(10,72); M2(4,118) = M1(10,73); M2(4,124) = M1(10,74); M2(4,125) = M1(10,75); M2(4,126) = M1(10,76); M2(4,129) = M1(10,77); M2(4,130) = M1(10,78); M2(4,133) = M1(10,79); M2(4,139) = M1(10,80); M2(4,140) = M1(10,81); M2(4,143) = M1(10,82); M2(4,149) = M1(10,83); 
M2(5,9) = M1(11,11); M2(5,13) = M1(11,15); M2(5,14) = M1(11,16); M2(5,15) = M1(11,17); M2(5,18) = M1(11,18); M2(5,19) = M1(11,19); M2(5,20) = M1(11,20); M2(5,21) = M1(11,21); M2(5,24) = M1(11,22); M2(5,25) = M1(11,23); M2(5,26) = M1(11,24); M2(5,29) = M1(11,25); M2(5,30) = M1(11,26); M2(5,33) = M1(11,27); M2(5,39) = M1(11,28); M2(5,40) = M1(11,29); M2(5,41) = M1(11,30); M2(5,42) = M1(11,31); M2(5,43) = M1(11,32); M2(5,44) = M1(11,33); M2(5,47) = M1(11,34); M2(5,48) = M1(11,35); M2(5,49) = M1(11,36); M2(5,50) = M1(11,37); M2(5,51) = M1(11,38); M2(5,54) = M1(11,39); M2(5,55) = M1(11,40); M2(5,56) = M1(11,41); M2(5,57) = M1(11,42); M2(5,60) = M1(11,43); M2(5,61) = M1(11,44); M2(5,62) = M1(11,45); M2(5,65) = M1(11,46); M2(5,66) = M1(11,47); M2(5,69) = M1(11,48); M2(5,74) = M1(11,49); M2(5,75) = M1(11,50); M2(5,76) = M1(11,51); M2(5,77) = M1(11,52); M2(5,78) = M1(11,53); M2(5,81) = M1(11,54); M2(5,82) = M1(11,55); M2(5,83) = M1(11,56); M2(5,84) = M1(11,57); M2(5,87) = M1(11,58); M2(5,88) = M1(11,59); M2(5,89) = M1(11,60); M2(5,92) = M1(11,61); M2(5,94) = M1(11,62); M2(5,97) = M1(11,63); M2(5,103) = M1(11,64); M2(5,104) = M1(11,65); M2(5,105) = M1(11,66); M2(5,106) = M1(11,67); M2(5,109) = M1(11,68); M2(5,110) = M1(11,69); M2(5,111) = M1(11,70); M2(5,114) = M1(11,71); M2(5,115) = M1(11,72); M2(5,118) = M1(11,73); M2(5,124) = M1(11,74); M2(5,125) = M1(11,75); M2(5,126) = M1(11,76); M2(5,129) = M1(11,77); M2(5,130) = M1(11,78); M2(5,133) = M1(11,79); M2(5,139) = M1(11,80); M2(5,140) = M1(11,81); M2(5,143) = M1(11,82); M2(5,149) = M1(11,83); 
M2(6,11) = M1(13,13); M2(6,13) = M1(13,15); M2(6,14) = M1(13,16); M2(6,15) = M1(13,17); M2(6,18) = M1(13,18); M2(6,19) = M1(13,19); M2(6,20) = M1(13,20); M2(6,21) = M1(13,21); M2(6,24) = M1(13,22); M2(6,25) = M1(13,23); M2(6,26) = M1(13,24); M2(6,29) = M1(13,25); M2(6,30) = M1(13,26); M2(6,33) = M1(13,27); M2(6,39) = M1(13,28); M2(6,40) = M1(13,29); M2(6,41) = M1(13,30); M2(6,42) = M1(13,31); M2(6,43) = M1(13,32); M2(6,44) = M1(13,33); M2(6,47) = M1(13,34); M2(6,48) = M1(13,35); M2(6,49) = M1(13,36); M2(6,50) = M1(13,37); M2(6,51) = M1(13,38); M2(6,54) = M1(13,39); M2(6,55) = M1(13,40); M2(6,56) = M1(13,41); M2(6,57) = M1(13,42); M2(6,60) = M1(13,43); M2(6,61) = M1(13,44); M2(6,62) = M1(13,45); M2(6,65) = M1(13,46); M2(6,66) = M1(13,47); M2(6,69) = M1(13,48); M2(6,74) = M1(13,49); M2(6,75) = M1(13,50); M2(6,76) = M1(13,51); M2(6,77) = M1(13,52); M2(6,78) = M1(13,53); M2(6,81) = M1(13,54); M2(6,82) = M1(13,55); M2(6,83) = M1(13,56); M2(6,84) = M1(13,57); M2(6,87) = M1(13,58); M2(6,88) = M1(13,59); M2(6,89) = M1(13,60); M2(6,92) = M1(13,61); M2(6,94) = M1(13,62); M2(6,97) = M1(13,63); M2(6,103) = M1(13,64); M2(6,104) = M1(13,65); M2(6,105) = M1(13,66); M2(6,106) = M1(13,67); M2(6,109) = M1(13,68); M2(6,110) = M1(13,69); M2(6,111) = M1(13,70); M2(6,114) = M1(13,71); M2(6,115) = M1(13,72); M2(6,118) = M1(13,73); M2(6,124) = M1(13,74); M2(6,125) = M1(13,75); M2(6,126) = M1(13,76); M2(6,129) = M1(13,77); M2(6,130) = M1(13,78); M2(6,133) = M1(13,79); M2(6,139) = M1(13,80); M2(6,140) = M1(13,81); M2(6,143) = M1(13,82); M2(6,149) = M1(13,83); 
M2(7,12) = M1(14,14); M2(7,13) = M1(14,15); M2(7,14) = M1(14,16); M2(7,15) = M1(14,17); M2(7,18) = M1(14,18); M2(7,19) = M1(14,19); M2(7,20) = M1(14,20); M2(7,21) = M1(14,21); M2(7,24) = M1(14,22); M2(7,25) = M1(14,23); M2(7,26) = M1(14,24); M2(7,29) = M1(14,25); M2(7,30) = M1(14,26); M2(7,33) = M1(14,27); M2(7,39) = M1(14,28); M2(7,40) = M1(14,29); M2(7,41) = M1(14,30); M2(7,42) = M1(14,31); M2(7,43) = M1(14,32); M2(7,44) = M1(14,33); M2(7,47) = M1(14,34); M2(7,48) = M1(14,35); M2(7,49) = M1(14,36); M2(7,50) = M1(14,37); M2(7,51) = M1(14,38); M2(7,54) = M1(14,39); M2(7,55) = M1(14,40); M2(7,56) = M1(14,41); M2(7,57) = M1(14,42); M2(7,60) = M1(14,43); M2(7,61) = M1(14,44); M2(7,62) = M1(14,45); M2(7,65) = M1(14,46); M2(7,66) = M1(14,47); M2(7,69) = M1(14,48); M2(7,74) = M1(14,49); M2(7,75) = M1(14,50); M2(7,76) = M1(14,51); M2(7,77) = M1(14,52); M2(7,78) = M1(14,53); M2(7,81) = M1(14,54); M2(7,82) = M1(14,55); M2(7,83) = M1(14,56); M2(7,84) = M1(14,57); M2(7,87) = M1(14,58); M2(7,88) = M1(14,59); M2(7,89) = M1(14,60); M2(7,92) = M1(14,61); M2(7,94) = M1(14,62); M2(7,97) = M1(14,63); M2(7,103) = M1(14,64); M2(7,104) = M1(14,65); M2(7,105) = M1(14,66); M2(7,106) = M1(14,67); M2(7,109) = M1(14,68); M2(7,110) = M1(14,69); M2(7,111) = M1(14,70); M2(7,114) = M1(14,71); M2(7,115) = M1(14,72); M2(7,118) = M1(14,73); M2(7,124) = M1(14,74); M2(7,125) = M1(14,75); M2(7,126) = M1(14,76); M2(7,129) = M1(14,77); M2(7,130) = M1(14,78); M2(7,133) = M1(14,79); M2(7,139) = M1(14,80); M2(7,140) = M1(14,81); M2(7,143) = M1(14,82); M2(7,149) = M1(14,83); 
M2(8,10) = M1(8,8); M2(8,18) = M1(8,15); M2(8,19) = M1(8,16); M2(8,20) = M1(8,17); M2(8,22) = M1(8,18); M2(8,23) = M1(8,19); M2(8,24) = M1(8,20); M2(8,25) = M1(8,21); M2(8,27) = M1(8,22); M2(8,28) = M1(8,23); M2(8,29) = M1(8,24); M2(8,31) = M1(8,25); M2(8,32) = M1(8,26); M2(8,34) = M1(8,27); M2(8,45) = M1(8,28); M2(8,46) = M1(8,29); M2(8,47) = M1(8,30); M2(8,48) = M1(8,31); M2(8,49) = M1(8,32); M2(8,50) = M1(8,33); M2(8,52) = M1(8,34); M2(8,53) = M1(8,35); M2(8,54) = M1(8,36); M2(8,55) = M1(8,37); M2(8,56) = M1(8,38); M2(8,58) = M1(8,39); M2(8,59) = M1(8,40); M2(8,60) = M1(8,41); M2(8,61) = M1(8,42); M2(8,63) = M1(8,43); M2(8,64) = M1(8,44); M2(8,65) = M1(8,45); M2(8,67) = M1(8,46); M2(8,68) = M1(8,47); M2(8,70) = M1(8,48); M2(8,79) = M1(8,49); M2(8,80) = M1(8,50); M2(8,81) = M1(8,51); M2(8,82) = M1(8,52); M2(8,83) = M1(8,53); M2(8,85) = M1(8,54); M2(8,86) = M1(8,55); M2(8,87) = M1(8,56); M2(8,88) = M1(8,57); M2(8,90) = M1(8,58); M2(8,91) = M1(8,59); M2(8,92) = M1(8,60); M2(8,95) = M1(8,61); M2(8,96) = M1(8,62); M2(8,98) = M1(8,63); M2(8,107) = M1(8,64); M2(8,108) = M1(8,65); M2(8,109) = M1(8,66); M2(8,110) = M1(8,67); M2(8,112) = M1(8,68); M2(8,113) = M1(8,69); M2(8,114) = M1(8,70); M2(8,116) = M1(8,71); M2(8,117) = M1(8,72); M2(8,119) = M1(8,73); M2(8,127) = M1(8,74); M2(8,128) = M1(8,75); M2(8,129) = M1(8,76); M2(8,131) = M1(8,77); M2(8,132) = M1(8,78); M2(8,134) = M1(8,79); M2(8,141) = M1(8,80); M2(8,142) = M1(8,81); M2(8,144) = M1(8,82); M2(8,150) = M1(8,83); 
M2(9,11) = M1(9,9); M2(9,18) = M1(9,15); M2(9,19) = M1(9,16); M2(9,20) = M1(9,17); M2(9,22) = M1(9,18); M2(9,23) = M1(9,19); M2(9,24) = M1(9,20); M2(9,25) = M1(9,21); M2(9,27) = M1(9,22); M2(9,28) = M1(9,23); M2(9,29) = M1(9,24); M2(9,31) = M1(9,25); M2(9,32) = M1(9,26); M2(9,34) = M1(9,27); M2(9,45) = M1(9,28); M2(9,46) = M1(9,29); M2(9,47) = M1(9,30); M2(9,48) = M1(9,31); M2(9,49) = M1(9,32); M2(9,50) = M1(9,33); M2(9,52) = M1(9,34); M2(9,53) = M1(9,35); M2(9,54) = M1(9,36); M2(9,55) = M1(9,37); M2(9,56) = M1(9,38); M2(9,58) = M1(9,39); M2(9,59) = M1(9,40); M2(9,60) = M1(9,41); M2(9,61) = M1(9,42); M2(9,63) = M1(9,43); M2(9,64) = M1(9,44); M2(9,65) = M1(9,45); M2(9,67) = M1(9,46); M2(9,68) = M1(9,47); M2(9,70) = M1(9,48); M2(9,79) = M1(9,49); M2(9,80) = M1(9,50); M2(9,81) = M1(9,51); M2(9,82) = M1(9,52); M2(9,83) = M1(9,53); M2(9,85) = M1(9,54); M2(9,86) = M1(9,55); M2(9,87) = M1(9,56); M2(9,88) = M1(9,57); M2(9,90) = M1(9,58); M2(9,91) = M1(9,59); M2(9,92) = M1(9,60); M2(9,95) = M1(9,61); M2(9,96) = M1(9,62); M2(9,98) = M1(9,63); M2(9,107) = M1(9,64); M2(9,108) = M1(9,65); M2(9,109) = M1(9,66); M2(9,110) = M1(9,67); M2(9,112) = M1(9,68); M2(9,113) = M1(9,69); M2(9,114) = M1(9,70); M2(9,116) = M1(9,71); M2(9,117) = M1(9,72); M2(9,119) = M1(9,73); M2(9,127) = M1(9,74); M2(9,128) = M1(9,75); M2(9,129) = M1(9,76); M2(9,131) = M1(9,77); M2(9,132) = M1(9,78); M2(9,134) = M1(9,79); M2(9,141) = M1(9,80); M2(9,142) = M1(9,81); M2(9,144) = M1(9,82); M2(9,150) = M1(9,83); 
M2(10,12) = M1(10,10); M2(10,18) = M1(10,15); M2(10,19) = M1(10,16); M2(10,20) = M1(10,17); M2(10,22) = M1(10,18); M2(10,23) = M1(10,19); M2(10,24) = M1(10,20); M2(10,25) = M1(10,21); M2(10,27) = M1(10,22); M2(10,28) = M1(10,23); M2(10,29) = M1(10,24); M2(10,31) = M1(10,25); M2(10,32) = M1(10,26); M2(10,34) = M1(10,27); M2(10,45) = M1(10,28); M2(10,46) = M1(10,29); M2(10,47) = M1(10,30); M2(10,48) = M1(10,31); M2(10,49) = M1(10,32); M2(10,50) = M1(10,33); M2(10,52) = M1(10,34); M2(10,53) = M1(10,35); M2(10,54) = M1(10,36); M2(10,55) = M1(10,37); M2(10,56) = M1(10,38); M2(10,58) = M1(10,39); M2(10,59) = M1(10,40); M2(10,60) = M1(10,41); M2(10,61) = M1(10,42); M2(10,63) = M1(10,43); M2(10,64) = M1(10,44); M2(10,65) = M1(10,45); M2(10,67) = M1(10,46); M2(10,68) = M1(10,47); M2(10,70) = M1(10,48); M2(10,79) = M1(10,49); M2(10,80) = M1(10,50); M2(10,81) = M1(10,51); M2(10,82) = M1(10,52); M2(10,83) = M1(10,53); M2(10,85) = M1(10,54); M2(10,86) = M1(10,55); M2(10,87) = M1(10,56); M2(10,88) = M1(10,57); M2(10,90) = M1(10,58); M2(10,91) = M1(10,59); M2(10,92) = M1(10,60); M2(10,95) = M1(10,61); M2(10,96) = M1(10,62); M2(10,98) = M1(10,63); M2(10,107) = M1(10,64); M2(10,108) = M1(10,65); M2(10,109) = M1(10,66); M2(10,110) = M1(10,67); M2(10,112) = M1(10,68); M2(10,113) = M1(10,69); M2(10,114) = M1(10,70); M2(10,116) = M1(10,71); M2(10,117) = M1(10,72); M2(10,119) = M1(10,73); M2(10,127) = M1(10,74); M2(10,128) = M1(10,75); M2(10,129) = M1(10,76); M2(10,131) = M1(10,77); M2(10,132) = M1(10,78); M2(10,134) = M1(10,79); M2(10,141) = M1(10,80); M2(10,142) = M1(10,81); M2(10,144) = M1(10,82); M2(10,150) = M1(10,83); 
M2(11,13) = M1(11,11); M2(11,18) = M1(11,15); M2(11,19) = M1(11,16); M2(11,20) = M1(11,17); M2(11,22) = M1(11,18); M2(11,23) = M1(11,19); M2(11,24) = M1(11,20); M2(11,25) = M1(11,21); M2(11,27) = M1(11,22); M2(11,28) = M1(11,23); M2(11,29) = M1(11,24); M2(11,31) = M1(11,25); M2(11,32) = M1(11,26); M2(11,34) = M1(11,27); M2(11,45) = M1(11,28); M2(11,46) = M1(11,29); M2(11,47) = M1(11,30); M2(11,48) = M1(11,31); M2(11,49) = M1(11,32); M2(11,50) = M1(11,33); M2(11,52) = M1(11,34); M2(11,53) = M1(11,35); M2(11,54) = M1(11,36); M2(11,55) = M1(11,37); M2(11,56) = M1(11,38); M2(11,58) = M1(11,39); M2(11,59) = M1(11,40); M2(11,60) = M1(11,41); M2(11,61) = M1(11,42); M2(11,63) = M1(11,43); M2(11,64) = M1(11,44); M2(11,65) = M1(11,45); M2(11,67) = M1(11,46); M2(11,68) = M1(11,47); M2(11,70) = M1(11,48); M2(11,79) = M1(11,49); M2(11,80) = M1(11,50); M2(11,81) = M1(11,51); M2(11,82) = M1(11,52); M2(11,83) = M1(11,53); M2(11,85) = M1(11,54); M2(11,86) = M1(11,55); M2(11,87) = M1(11,56); M2(11,88) = M1(11,57); M2(11,90) = M1(11,58); M2(11,91) = M1(11,59); M2(11,92) = M1(11,60); M2(11,95) = M1(11,61); M2(11,96) = M1(11,62); M2(11,98) = M1(11,63); M2(11,107) = M1(11,64); M2(11,108) = M1(11,65); M2(11,109) = M1(11,66); M2(11,110) = M1(11,67); M2(11,112) = M1(11,68); M2(11,113) = M1(11,69); M2(11,114) = M1(11,70); M2(11,116) = M1(11,71); M2(11,117) = M1(11,72); M2(11,119) = M1(11,73); M2(11,127) = M1(11,74); M2(11,128) = M1(11,75); M2(11,129) = M1(11,76); M2(11,131) = M1(11,77); M2(11,132) = M1(11,78); M2(11,134) = M1(11,79); M2(11,141) = M1(11,80); M2(11,142) = M1(11,81); M2(11,144) = M1(11,82); M2(11,150) = M1(11,83); 
M2(12,14) = M1(12,12); M2(12,18) = M1(12,15); M2(12,19) = M1(12,16); M2(12,20) = M1(12,17); M2(12,22) = M1(12,18); M2(12,23) = M1(12,19); M2(12,24) = M1(12,20); M2(12,25) = M1(12,21); M2(12,27) = M1(12,22); M2(12,28) = M1(12,23); M2(12,29) = M1(12,24); M2(12,31) = M1(12,25); M2(12,32) = M1(12,26); M2(12,34) = M1(12,27); M2(12,45) = M1(12,28); M2(12,46) = M1(12,29); M2(12,47) = M1(12,30); M2(12,48) = M1(12,31); M2(12,49) = M1(12,32); M2(12,50) = M1(12,33); M2(12,52) = M1(12,34); M2(12,53) = M1(12,35); M2(12,54) = M1(12,36); M2(12,55) = M1(12,37); M2(12,56) = M1(12,38); M2(12,58) = M1(12,39); M2(12,59) = M1(12,40); M2(12,60) = M1(12,41); M2(12,61) = M1(12,42); M2(12,63) = M1(12,43); M2(12,64) = M1(12,44); M2(12,65) = M1(12,45); M2(12,67) = M1(12,46); M2(12,68) = M1(12,47); M2(12,70) = M1(12,48); M2(12,79) = M1(12,49); M2(12,80) = M1(12,50); M2(12,81) = M1(12,51); M2(12,82) = M1(12,52); M2(12,83) = M1(12,53); M2(12,85) = M1(12,54); M2(12,86) = M1(12,55); M2(12,87) = M1(12,56); M2(12,88) = M1(12,57); M2(12,90) = M1(12,58); M2(12,91) = M1(12,59); M2(12,92) = M1(12,60); M2(12,95) = M1(12,61); M2(12,96) = M1(12,62); M2(12,98) = M1(12,63); M2(12,107) = M1(12,64); M2(12,108) = M1(12,65); M2(12,109) = M1(12,66); M2(12,110) = M1(12,67); M2(12,112) = M1(12,68); M2(12,113) = M1(12,69); M2(12,114) = M1(12,70); M2(12,116) = M1(12,71); M2(12,117) = M1(12,72); M2(12,119) = M1(12,73); M2(12,127) = M1(12,74); M2(12,128) = M1(12,75); M2(12,129) = M1(12,76); M2(12,131) = M1(12,77); M2(12,132) = M1(12,78); M2(12,134) = M1(12,79); M2(12,141) = M1(12,80); M2(12,142) = M1(12,81); M2(12,144) = M1(12,82); M2(12,150) = M1(12,83); 
M2(13,16) = M1(13,13); M2(13,18) = M1(13,15); M2(13,19) = M1(13,16); M2(13,20) = M1(13,17); M2(13,22) = M1(13,18); M2(13,23) = M1(13,19); M2(13,24) = M1(13,20); M2(13,25) = M1(13,21); M2(13,27) = M1(13,22); M2(13,28) = M1(13,23); M2(13,29) = M1(13,24); M2(13,31) = M1(13,25); M2(13,32) = M1(13,26); M2(13,34) = M1(13,27); M2(13,45) = M1(13,28); M2(13,46) = M1(13,29); M2(13,47) = M1(13,30); M2(13,48) = M1(13,31); M2(13,49) = M1(13,32); M2(13,50) = M1(13,33); M2(13,52) = M1(13,34); M2(13,53) = M1(13,35); M2(13,54) = M1(13,36); M2(13,55) = M1(13,37); M2(13,56) = M1(13,38); M2(13,58) = M1(13,39); M2(13,59) = M1(13,40); M2(13,60) = M1(13,41); M2(13,61) = M1(13,42); M2(13,63) = M1(13,43); M2(13,64) = M1(13,44); M2(13,65) = M1(13,45); M2(13,67) = M1(13,46); M2(13,68) = M1(13,47); M2(13,70) = M1(13,48); M2(13,79) = M1(13,49); M2(13,80) = M1(13,50); M2(13,81) = M1(13,51); M2(13,82) = M1(13,52); M2(13,83) = M1(13,53); M2(13,85) = M1(13,54); M2(13,86) = M1(13,55); M2(13,87) = M1(13,56); M2(13,88) = M1(13,57); M2(13,90) = M1(13,58); M2(13,91) = M1(13,59); M2(13,92) = M1(13,60); M2(13,95) = M1(13,61); M2(13,96) = M1(13,62); M2(13,98) = M1(13,63); M2(13,107) = M1(13,64); M2(13,108) = M1(13,65); M2(13,109) = M1(13,66); M2(13,110) = M1(13,67); M2(13,112) = M1(13,68); M2(13,113) = M1(13,69); M2(13,114) = M1(13,70); M2(13,116) = M1(13,71); M2(13,117) = M1(13,72); M2(13,119) = M1(13,73); M2(13,127) = M1(13,74); M2(13,128) = M1(13,75); M2(13,129) = M1(13,76); M2(13,131) = M1(13,77); M2(13,132) = M1(13,78); M2(13,134) = M1(13,79); M2(13,141) = M1(13,80); M2(13,142) = M1(13,81); M2(13,144) = M1(13,82); M2(13,150) = M1(13,83); 
M2(14,17) = M1(14,14); M2(14,18) = M1(14,15); M2(14,19) = M1(14,16); M2(14,20) = M1(14,17); M2(14,22) = M1(14,18); M2(14,23) = M1(14,19); M2(14,24) = M1(14,20); M2(14,25) = M1(14,21); M2(14,27) = M1(14,22); M2(14,28) = M1(14,23); M2(14,29) = M1(14,24); M2(14,31) = M1(14,25); M2(14,32) = M1(14,26); M2(14,34) = M1(14,27); M2(14,45) = M1(14,28); M2(14,46) = M1(14,29); M2(14,47) = M1(14,30); M2(14,48) = M1(14,31); M2(14,49) = M1(14,32); M2(14,50) = M1(14,33); M2(14,52) = M1(14,34); M2(14,53) = M1(14,35); M2(14,54) = M1(14,36); M2(14,55) = M1(14,37); M2(14,56) = M1(14,38); M2(14,58) = M1(14,39); M2(14,59) = M1(14,40); M2(14,60) = M1(14,41); M2(14,61) = M1(14,42); M2(14,63) = M1(14,43); M2(14,64) = M1(14,44); M2(14,65) = M1(14,45); M2(14,67) = M1(14,46); M2(14,68) = M1(14,47); M2(14,70) = M1(14,48); M2(14,79) = M1(14,49); M2(14,80) = M1(14,50); M2(14,81) = M1(14,51); M2(14,82) = M1(14,52); M2(14,83) = M1(14,53); M2(14,85) = M1(14,54); M2(14,86) = M1(14,55); M2(14,87) = M1(14,56); M2(14,88) = M1(14,57); M2(14,90) = M1(14,58); M2(14,91) = M1(14,59); M2(14,92) = M1(14,60); M2(14,95) = M1(14,61); M2(14,96) = M1(14,62); M2(14,98) = M1(14,63); M2(14,107) = M1(14,64); M2(14,108) = M1(14,65); M2(14,109) = M1(14,66); M2(14,110) = M1(14,67); M2(14,112) = M1(14,68); M2(14,113) = M1(14,69); M2(14,114) = M1(14,70); M2(14,116) = M1(14,71); M2(14,117) = M1(14,72); M2(14,119) = M1(14,73); M2(14,127) = M1(14,74); M2(14,128) = M1(14,75); M2(14,129) = M1(14,76); M2(14,131) = M1(14,77); M2(14,132) = M1(14,78); M2(14,134) = M1(14,79); M2(14,141) = M1(14,80); M2(14,142) = M1(14,81); M2(14,144) = M1(14,82); M2(14,150) = M1(14,83); 
M2(15,0) = M1(2,2); M2(15,12) = M1(2,15); M2(15,13) = M1(2,16); M2(15,14) = M1(2,17); M2(15,17) = M1(2,18); M2(15,18) = M1(2,19); M2(15,19) = M1(2,20); M2(15,20) = M1(2,21); M2(15,23) = M1(2,22); M2(15,24) = M1(2,23); M2(15,25) = M1(2,24); M2(15,28) = M1(2,25); M2(15,29) = M1(2,26); M2(15,32) = M1(2,27); M2(15,38) = M1(2,28); M2(15,39) = M1(2,29); M2(15,40) = M1(2,30); M2(15,41) = M1(2,31); M2(15,42) = M1(2,32); M2(15,43) = M1(2,33); M2(15,46) = M1(2,34); M2(15,47) = M1(2,35); M2(15,48) = M1(2,36); M2(15,49) = M1(2,37); M2(15,50) = M1(2,38); M2(15,53) = M1(2,39); M2(15,54) = M1(2,40); M2(15,55) = M1(2,41); M2(15,56) = M1(2,42); M2(15,59) = M1(2,43); M2(15,60) = M1(2,44); M2(15,61) = M1(2,45); M2(15,64) = M1(2,46); M2(15,65) = M1(2,47); M2(15,68) = M1(2,48); M2(15,73) = M1(2,49); M2(15,74) = M1(2,50); M2(15,75) = M1(2,51); M2(15,76) = M1(2,52); M2(15,77) = M1(2,53); M2(15,80) = M1(2,54); M2(15,81) = M1(2,55); M2(15,82) = M1(2,56); M2(15,83) = M1(2,57); M2(15,86) = M1(2,58); M2(15,87) = M1(2,59); M2(15,88) = M1(2,60); M2(15,91) = M1(2,61); M2(15,92) = M1(2,62); M2(15,96) = M1(2,63); M2(15,102) = M1(2,64); M2(15,103) = M1(2,65); M2(15,104) = M1(2,66); M2(15,105) = M1(2,67); M2(15,108) = M1(2,68); M2(15,109) = M1(2,69); M2(15,110) = M1(2,70); M2(15,113) = M1(2,71); M2(15,114) = M1(2,72); M2(15,117) = M1(2,73); M2(15,123) = M1(2,74); M2(15,124) = M1(2,75); M2(15,125) = M1(2,76); M2(15,128) = M1(2,77); M2(15,129) = M1(2,78); M2(15,132) = M1(2,79); M2(15,138) = M1(2,80); M2(15,139) = M1(2,81); M2(15,142) = M1(2,82); M2(15,148) = M1(2,83); 
M2(16,1) = M1(3,3); M2(16,12) = M1(3,15); M2(16,13) = M1(3,16); M2(16,14) = M1(3,17); M2(16,17) = M1(3,18); M2(16,18) = M1(3,19); M2(16,19) = M1(3,20); M2(16,20) = M1(3,21); M2(16,23) = M1(3,22); M2(16,24) = M1(3,23); M2(16,25) = M1(3,24); M2(16,28) = M1(3,25); M2(16,29) = M1(3,26); M2(16,32) = M1(3,27); M2(16,38) = M1(3,28); M2(16,39) = M1(3,29); M2(16,40) = M1(3,30); M2(16,41) = M1(3,31); M2(16,42) = M1(3,32); M2(16,43) = M1(3,33); M2(16,46) = M1(3,34); M2(16,47) = M1(3,35); M2(16,48) = M1(3,36); M2(16,49) = M1(3,37); M2(16,50) = M1(3,38); M2(16,53) = M1(3,39); M2(16,54) = M1(3,40); M2(16,55) = M1(3,41); M2(16,56) = M1(3,42); M2(16,59) = M1(3,43); M2(16,60) = M1(3,44); M2(16,61) = M1(3,45); M2(16,64) = M1(3,46); M2(16,65) = M1(3,47); M2(16,68) = M1(3,48); M2(16,73) = M1(3,49); M2(16,74) = M1(3,50); M2(16,75) = M1(3,51); M2(16,76) = M1(3,52); M2(16,77) = M1(3,53); M2(16,80) = M1(3,54); M2(16,81) = M1(3,55); M2(16,82) = M1(3,56); M2(16,83) = M1(3,57); M2(16,86) = M1(3,58); M2(16,87) = M1(3,59); M2(16,88) = M1(3,60); M2(16,91) = M1(3,61); M2(16,92) = M1(3,62); M2(16,96) = M1(3,63); M2(16,102) = M1(3,64); M2(16,103) = M1(3,65); M2(16,104) = M1(3,66); M2(16,105) = M1(3,67); M2(16,108) = M1(3,68); M2(16,109) = M1(3,69); M2(16,110) = M1(3,70); M2(16,113) = M1(3,71); M2(16,114) = M1(3,72); M2(16,117) = M1(3,73); M2(16,123) = M1(3,74); M2(16,124) = M1(3,75); M2(16,125) = M1(3,76); M2(16,128) = M1(3,77); M2(16,129) = M1(3,78); M2(16,132) = M1(3,79); M2(16,138) = M1(3,80); M2(16,139) = M1(3,81); M2(16,142) = M1(3,82); M2(16,148) = M1(3,83); 
M2(17,2) = M1(4,4); M2(17,12) = M1(4,15); M2(17,13) = M1(4,16); M2(17,14) = M1(4,17); M2(17,17) = M1(4,18); M2(17,18) = M1(4,19); M2(17,19) = M1(4,20); M2(17,20) = M1(4,21); M2(17,23) = M1(4,22); M2(17,24) = M1(4,23); M2(17,25) = M1(4,24); M2(17,28) = M1(4,25); M2(17,29) = M1(4,26); M2(17,32) = M1(4,27); M2(17,38) = M1(4,28); M2(17,39) = M1(4,29); M2(17,40) = M1(4,30); M2(17,41) = M1(4,31); M2(17,42) = M1(4,32); M2(17,43) = M1(4,33); M2(17,46) = M1(4,34); M2(17,47) = M1(4,35); M2(17,48) = M1(4,36); M2(17,49) = M1(4,37); M2(17,50) = M1(4,38); M2(17,53) = M1(4,39); M2(17,54) = M1(4,40); M2(17,55) = M1(4,41); M2(17,56) = M1(4,42); M2(17,59) = M1(4,43); M2(17,60) = M1(4,44); M2(17,61) = M1(4,45); M2(17,64) = M1(4,46); M2(17,65) = M1(4,47); M2(17,68) = M1(4,48); M2(17,73) = M1(4,49); M2(17,74) = M1(4,50); M2(17,75) = M1(4,51); M2(17,76) = M1(4,52); M2(17,77) = M1(4,53); M2(17,80) = M1(4,54); M2(17,81) = M1(4,55); M2(17,82) = M1(4,56); M2(17,83) = M1(4,57); M2(17,86) = M1(4,58); M2(17,87) = M1(4,59); M2(17,88) = M1(4,60); M2(17,91) = M1(4,61); M2(17,92) = M1(4,62); M2(17,96) = M1(4,63); M2(17,102) = M1(4,64); M2(17,103) = M1(4,65); M2(17,104) = M1(4,66); M2(17,105) = M1(4,67); M2(17,108) = M1(4,68); M2(17,109) = M1(4,69); M2(17,110) = M1(4,70); M2(17,113) = M1(4,71); M2(17,114) = M1(4,72); M2(17,117) = M1(4,73); M2(17,123) = M1(4,74); M2(17,124) = M1(4,75); M2(17,125) = M1(4,76); M2(17,128) = M1(4,77); M2(17,129) = M1(4,78); M2(17,132) = M1(4,79); M2(17,138) = M1(4,80); M2(17,139) = M1(4,81); M2(17,142) = M1(4,82); M2(17,148) = M1(4,83); 
M2(18,3) = M1(5,5); M2(18,12) = M1(5,15); M2(18,13) = M1(5,16); M2(18,14) = M1(5,17); M2(18,17) = M1(5,18); M2(18,18) = M1(5,19); M2(18,19) = M1(5,20); M2(18,20) = M1(5,21); M2(18,23) = M1(5,22); M2(18,24) = M1(5,23); M2(18,25) = M1(5,24); M2(18,28) = M1(5,25); M2(18,29) = M1(5,26); M2(18,32) = M1(5,27); M2(18,38) = M1(5,28); M2(18,39) = M1(5,29); M2(18,40) = M1(5,30); M2(18,41) = M1(5,31); M2(18,42) = M1(5,32); M2(18,43) = M1(5,33); M2(18,46) = M1(5,34); M2(18,47) = M1(5,35); M2(18,48) = M1(5,36); M2(18,49) = M1(5,37); M2(18,50) = M1(5,38); M2(18,53) = M1(5,39); M2(18,54) = M1(5,40); M2(18,55) = M1(5,41); M2(18,56) = M1(5,42); M2(18,59) = M1(5,43); M2(18,60) = M1(5,44); M2(18,61) = M1(5,45); M2(18,64) = M1(5,46); M2(18,65) = M1(5,47); M2(18,68) = M1(5,48); M2(18,73) = M1(5,49); M2(18,74) = M1(5,50); M2(18,75) = M1(5,51); M2(18,76) = M1(5,52); M2(18,77) = M1(5,53); M2(18,80) = M1(5,54); M2(18,81) = M1(5,55); M2(18,82) = M1(5,56); M2(18,83) = M1(5,57); M2(18,86) = M1(5,58); M2(18,87) = M1(5,59); M2(18,88) = M1(5,60); M2(18,91) = M1(5,61); M2(18,92) = M1(5,62); M2(18,96) = M1(5,63); M2(18,102) = M1(5,64); M2(18,103) = M1(5,65); M2(18,104) = M1(5,66); M2(18,105) = M1(5,67); M2(18,108) = M1(5,68); M2(18,109) = M1(5,69); M2(18,110) = M1(5,70); M2(18,113) = M1(5,71); M2(18,114) = M1(5,72); M2(18,117) = M1(5,73); M2(18,123) = M1(5,74); M2(18,124) = M1(5,75); M2(18,125) = M1(5,76); M2(18,128) = M1(5,77); M2(18,129) = M1(5,78); M2(18,132) = M1(5,79); M2(18,138) = M1(5,80); M2(18,139) = M1(5,81); M2(18,142) = M1(5,82); M2(18,148) = M1(5,83); 
M2(19,4) = M1(7,7); M2(19,12) = M1(7,15); M2(19,13) = M1(7,16); M2(19,14) = M1(7,17); M2(19,17) = M1(7,18); M2(19,18) = M1(7,19); M2(19,19) = M1(7,20); M2(19,20) = M1(7,21); M2(19,23) = M1(7,22); M2(19,24) = M1(7,23); M2(19,25) = M1(7,24); M2(19,28) = M1(7,25); M2(19,29) = M1(7,26); M2(19,32) = M1(7,27); M2(19,38) = M1(7,28); M2(19,39) = M1(7,29); M2(19,40) = M1(7,30); M2(19,41) = M1(7,31); M2(19,42) = M1(7,32); M2(19,43) = M1(7,33); M2(19,46) = M1(7,34); M2(19,47) = M1(7,35); M2(19,48) = M1(7,36); M2(19,49) = M1(7,37); M2(19,50) = M1(7,38); M2(19,53) = M1(7,39); M2(19,54) = M1(7,40); M2(19,55) = M1(7,41); M2(19,56) = M1(7,42); M2(19,59) = M1(7,43); M2(19,60) = M1(7,44); M2(19,61) = M1(7,45); M2(19,64) = M1(7,46); M2(19,65) = M1(7,47); M2(19,68) = M1(7,48); M2(19,73) = M1(7,49); M2(19,74) = M1(7,50); M2(19,75) = M1(7,51); M2(19,76) = M1(7,52); M2(19,77) = M1(7,53); M2(19,80) = M1(7,54); M2(19,81) = M1(7,55); M2(19,82) = M1(7,56); M2(19,83) = M1(7,57); M2(19,86) = M1(7,58); M2(19,87) = M1(7,59); M2(19,88) = M1(7,60); M2(19,91) = M1(7,61); M2(19,92) = M1(7,62); M2(19,96) = M1(7,63); M2(19,102) = M1(7,64); M2(19,103) = M1(7,65); M2(19,104) = M1(7,66); M2(19,105) = M1(7,67); M2(19,108) = M1(7,68); M2(19,109) = M1(7,69); M2(19,110) = M1(7,70); M2(19,113) = M1(7,71); M2(19,114) = M1(7,72); M2(19,117) = M1(7,73); M2(19,123) = M1(7,74); M2(19,124) = M1(7,75); M2(19,125) = M1(7,76); M2(19,128) = M1(7,77); M2(19,129) = M1(7,78); M2(19,132) = M1(7,79); M2(19,138) = M1(7,80); M2(19,139) = M1(7,81); M2(19,142) = M1(7,82); M2(19,148) = M1(7,83); 
M2(20,5) = M1(8,8); M2(20,12) = M1(8,15); M2(20,13) = M1(8,16); M2(20,14) = M1(8,17); M2(20,17) = M1(8,18); M2(20,18) = M1(8,19); M2(20,19) = M1(8,20); M2(20,20) = M1(8,21); M2(20,23) = M1(8,22); M2(20,24) = M1(8,23); M2(20,25) = M1(8,24); M2(20,28) = M1(8,25); M2(20,29) = M1(8,26); M2(20,32) = M1(8,27); M2(20,38) = M1(8,28); M2(20,39) = M1(8,29); M2(20,40) = M1(8,30); M2(20,41) = M1(8,31); M2(20,42) = M1(8,32); M2(20,43) = M1(8,33); M2(20,46) = M1(8,34); M2(20,47) = M1(8,35); M2(20,48) = M1(8,36); M2(20,49) = M1(8,37); M2(20,50) = M1(8,38); M2(20,53) = M1(8,39); M2(20,54) = M1(8,40); M2(20,55) = M1(8,41); M2(20,56) = M1(8,42); M2(20,59) = M1(8,43); M2(20,60) = M1(8,44); M2(20,61) = M1(8,45); M2(20,64) = M1(8,46); M2(20,65) = M1(8,47); M2(20,68) = M1(8,48); M2(20,73) = M1(8,49); M2(20,74) = M1(8,50); M2(20,75) = M1(8,51); M2(20,76) = M1(8,52); M2(20,77) = M1(8,53); M2(20,80) = M1(8,54); M2(20,81) = M1(8,55); M2(20,82) = M1(8,56); M2(20,83) = M1(8,57); M2(20,86) = M1(8,58); M2(20,87) = M1(8,59); M2(20,88) = M1(8,60); M2(20,91) = M1(8,61); M2(20,92) = M1(8,62); M2(20,96) = M1(8,63); M2(20,102) = M1(8,64); M2(20,103) = M1(8,65); M2(20,104) = M1(8,66); M2(20,105) = M1(8,67); M2(20,108) = M1(8,68); M2(20,109) = M1(8,69); M2(20,110) = M1(8,70); M2(20,113) = M1(8,71); M2(20,114) = M1(8,72); M2(20,117) = M1(8,73); M2(20,123) = M1(8,74); M2(20,124) = M1(8,75); M2(20,125) = M1(8,76); M2(20,128) = M1(8,77); M2(20,129) = M1(8,78); M2(20,132) = M1(8,79); M2(20,138) = M1(8,80); M2(20,139) = M1(8,81); M2(20,142) = M1(8,82); M2(20,148) = M1(8,83); 
M2(21,6) = M1(9,9); M2(21,12) = M1(9,15); M2(21,13) = M1(9,16); M2(21,14) = M1(9,17); M2(21,17) = M1(9,18); M2(21,18) = M1(9,19); M2(21,19) = M1(9,20); M2(21,20) = M1(9,21); M2(21,23) = M1(9,22); M2(21,24) = M1(9,23); M2(21,25) = M1(9,24); M2(21,28) = M1(9,25); M2(21,29) = M1(9,26); M2(21,32) = M1(9,27); M2(21,38) = M1(9,28); M2(21,39) = M1(9,29); M2(21,40) = M1(9,30); M2(21,41) = M1(9,31); M2(21,42) = M1(9,32); M2(21,43) = M1(9,33); M2(21,46) = M1(9,34); M2(21,47) = M1(9,35); M2(21,48) = M1(9,36); M2(21,49) = M1(9,37); M2(21,50) = M1(9,38); M2(21,53) = M1(9,39); M2(21,54) = M1(9,40); M2(21,55) = M1(9,41); M2(21,56) = M1(9,42); M2(21,59) = M1(9,43); M2(21,60) = M1(9,44); M2(21,61) = M1(9,45); M2(21,64) = M1(9,46); M2(21,65) = M1(9,47); M2(21,68) = M1(9,48); M2(21,73) = M1(9,49); M2(21,74) = M1(9,50); M2(21,75) = M1(9,51); M2(21,76) = M1(9,52); M2(21,77) = M1(9,53); M2(21,80) = M1(9,54); M2(21,81) = M1(9,55); M2(21,82) = M1(9,56); M2(21,83) = M1(9,57); M2(21,86) = M1(9,58); M2(21,87) = M1(9,59); M2(21,88) = M1(9,60); M2(21,91) = M1(9,61); M2(21,92) = M1(9,62); M2(21,96) = M1(9,63); M2(21,102) = M1(9,64); M2(21,103) = M1(9,65); M2(21,104) = M1(9,66); M2(21,105) = M1(9,67); M2(21,108) = M1(9,68); M2(21,109) = M1(9,69); M2(21,110) = M1(9,70); M2(21,113) = M1(9,71); M2(21,114) = M1(9,72); M2(21,117) = M1(9,73); M2(21,123) = M1(9,74); M2(21,124) = M1(9,75); M2(21,125) = M1(9,76); M2(21,128) = M1(9,77); M2(21,129) = M1(9,78); M2(21,132) = M1(9,79); M2(21,138) = M1(9,80); M2(21,139) = M1(9,81); M2(21,142) = M1(9,82); M2(21,148) = M1(9,83); 
M2(22,7) = M1(10,10); M2(22,12) = M1(10,15); M2(22,13) = M1(10,16); M2(22,14) = M1(10,17); M2(22,17) = M1(10,18); M2(22,18) = M1(10,19); M2(22,19) = M1(10,20); M2(22,20) = M1(10,21); M2(22,23) = M1(10,22); M2(22,24) = M1(10,23); M2(22,25) = M1(10,24); M2(22,28) = M1(10,25); M2(22,29) = M1(10,26); M2(22,32) = M1(10,27); M2(22,38) = M1(10,28); M2(22,39) = M1(10,29); M2(22,40) = M1(10,30); M2(22,41) = M1(10,31); M2(22,42) = M1(10,32); M2(22,43) = M1(10,33); M2(22,46) = M1(10,34); M2(22,47) = M1(10,35); M2(22,48) = M1(10,36); M2(22,49) = M1(10,37); M2(22,50) = M1(10,38); M2(22,53) = M1(10,39); M2(22,54) = M1(10,40); M2(22,55) = M1(10,41); M2(22,56) = M1(10,42); M2(22,59) = M1(10,43); M2(22,60) = M1(10,44); M2(22,61) = M1(10,45); M2(22,64) = M1(10,46); M2(22,65) = M1(10,47); M2(22,68) = M1(10,48); M2(22,73) = M1(10,49); M2(22,74) = M1(10,50); M2(22,75) = M1(10,51); M2(22,76) = M1(10,52); M2(22,77) = M1(10,53); M2(22,80) = M1(10,54); M2(22,81) = M1(10,55); M2(22,82) = M1(10,56); M2(22,83) = M1(10,57); M2(22,86) = M1(10,58); M2(22,87) = M1(10,59); M2(22,88) = M1(10,60); M2(22,91) = M1(10,61); M2(22,92) = M1(10,62); M2(22,96) = M1(10,63); M2(22,102) = M1(10,64); M2(22,103) = M1(10,65); M2(22,104) = M1(10,66); M2(22,105) = M1(10,67); M2(22,108) = M1(10,68); M2(22,109) = M1(10,69); M2(22,110) = M1(10,70); M2(22,113) = M1(10,71); M2(22,114) = M1(10,72); M2(22,117) = M1(10,73); M2(22,123) = M1(10,74); M2(22,124) = M1(10,75); M2(22,125) = M1(10,76); M2(22,128) = M1(10,77); M2(22,129) = M1(10,78); M2(22,132) = M1(10,79); M2(22,138) = M1(10,80); M2(22,139) = M1(10,81); M2(22,142) = M1(10,82); M2(22,148) = M1(10,83); 
M2(23,8) = M1(11,11); M2(23,12) = M1(11,15); M2(23,13) = M1(11,16); M2(23,14) = M1(11,17); M2(23,17) = M1(11,18); M2(23,18) = M1(11,19); M2(23,19) = M1(11,20); M2(23,20) = M1(11,21); M2(23,23) = M1(11,22); M2(23,24) = M1(11,23); M2(23,25) = M1(11,24); M2(23,28) = M1(11,25); M2(23,29) = M1(11,26); M2(23,32) = M1(11,27); M2(23,38) = M1(11,28); M2(23,39) = M1(11,29); M2(23,40) = M1(11,30); M2(23,41) = M1(11,31); M2(23,42) = M1(11,32); M2(23,43) = M1(11,33); M2(23,46) = M1(11,34); M2(23,47) = M1(11,35); M2(23,48) = M1(11,36); M2(23,49) = M1(11,37); M2(23,50) = M1(11,38); M2(23,53) = M1(11,39); M2(23,54) = M1(11,40); M2(23,55) = M1(11,41); M2(23,56) = M1(11,42); M2(23,59) = M1(11,43); M2(23,60) = M1(11,44); M2(23,61) = M1(11,45); M2(23,64) = M1(11,46); M2(23,65) = M1(11,47); M2(23,68) = M1(11,48); M2(23,73) = M1(11,49); M2(23,74) = M1(11,50); M2(23,75) = M1(11,51); M2(23,76) = M1(11,52); M2(23,77) = M1(11,53); M2(23,80) = M1(11,54); M2(23,81) = M1(11,55); M2(23,82) = M1(11,56); M2(23,83) = M1(11,57); M2(23,86) = M1(11,58); M2(23,87) = M1(11,59); M2(23,88) = M1(11,60); M2(23,91) = M1(11,61); M2(23,92) = M1(11,62); M2(23,96) = M1(11,63); M2(23,102) = M1(11,64); M2(23,103) = M1(11,65); M2(23,104) = M1(11,66); M2(23,105) = M1(11,67); M2(23,108) = M1(11,68); M2(23,109) = M1(11,69); M2(23,110) = M1(11,70); M2(23,113) = M1(11,71); M2(23,114) = M1(11,72); M2(23,117) = M1(11,73); M2(23,123) = M1(11,74); M2(23,124) = M1(11,75); M2(23,125) = M1(11,76); M2(23,128) = M1(11,77); M2(23,129) = M1(11,78); M2(23,132) = M1(11,79); M2(23,138) = M1(11,80); M2(23,139) = M1(11,81); M2(23,142) = M1(11,82); M2(23,148) = M1(11,83); 
M2(24,9) = M1(12,12); M2(24,12) = M1(12,15); M2(24,13) = M1(12,16); M2(24,14) = M1(12,17); M2(24,17) = M1(12,18); M2(24,18) = M1(12,19); M2(24,19) = M1(12,20); M2(24,20) = M1(12,21); M2(24,23) = M1(12,22); M2(24,24) = M1(12,23); M2(24,25) = M1(12,24); M2(24,28) = M1(12,25); M2(24,29) = M1(12,26); M2(24,32) = M1(12,27); M2(24,38) = M1(12,28); M2(24,39) = M1(12,29); M2(24,40) = M1(12,30); M2(24,41) = M1(12,31); M2(24,42) = M1(12,32); M2(24,43) = M1(12,33); M2(24,46) = M1(12,34); M2(24,47) = M1(12,35); M2(24,48) = M1(12,36); M2(24,49) = M1(12,37); M2(24,50) = M1(12,38); M2(24,53) = M1(12,39); M2(24,54) = M1(12,40); M2(24,55) = M1(12,41); M2(24,56) = M1(12,42); M2(24,59) = M1(12,43); M2(24,60) = M1(12,44); M2(24,61) = M1(12,45); M2(24,64) = M1(12,46); M2(24,65) = M1(12,47); M2(24,68) = M1(12,48); M2(24,73) = M1(12,49); M2(24,74) = M1(12,50); M2(24,75) = M1(12,51); M2(24,76) = M1(12,52); M2(24,77) = M1(12,53); M2(24,80) = M1(12,54); M2(24,81) = M1(12,55); M2(24,82) = M1(12,56); M2(24,83) = M1(12,57); M2(24,86) = M1(12,58); M2(24,87) = M1(12,59); M2(24,88) = M1(12,60); M2(24,91) = M1(12,61); M2(24,92) = M1(12,62); M2(24,96) = M1(12,63); M2(24,102) = M1(12,64); M2(24,103) = M1(12,65); M2(24,104) = M1(12,66); M2(24,105) = M1(12,67); M2(24,108) = M1(12,68); M2(24,109) = M1(12,69); M2(24,110) = M1(12,70); M2(24,113) = M1(12,71); M2(24,114) = M1(12,72); M2(24,117) = M1(12,73); M2(24,123) = M1(12,74); M2(24,124) = M1(12,75); M2(24,125) = M1(12,76); M2(24,128) = M1(12,77); M2(24,129) = M1(12,78); M2(24,132) = M1(12,79); M2(24,138) = M1(12,80); M2(24,139) = M1(12,81); M2(24,142) = M1(12,82); M2(24,148) = M1(12,83); 
M2(25,10) = M1(13,13); M2(25,12) = M1(13,15); M2(25,13) = M1(13,16); M2(25,14) = M1(13,17); M2(25,17) = M1(13,18); M2(25,18) = M1(13,19); M2(25,19) = M1(13,20); M2(25,20) = M1(13,21); M2(25,23) = M1(13,22); M2(25,24) = M1(13,23); M2(25,25) = M1(13,24); M2(25,28) = M1(13,25); M2(25,29) = M1(13,26); M2(25,32) = M1(13,27); M2(25,38) = M1(13,28); M2(25,39) = M1(13,29); M2(25,40) = M1(13,30); M2(25,41) = M1(13,31); M2(25,42) = M1(13,32); M2(25,43) = M1(13,33); M2(25,46) = M1(13,34); M2(25,47) = M1(13,35); M2(25,48) = M1(13,36); M2(25,49) = M1(13,37); M2(25,50) = M1(13,38); M2(25,53) = M1(13,39); M2(25,54) = M1(13,40); M2(25,55) = M1(13,41); M2(25,56) = M1(13,42); M2(25,59) = M1(13,43); M2(25,60) = M1(13,44); M2(25,61) = M1(13,45); M2(25,64) = M1(13,46); M2(25,65) = M1(13,47); M2(25,68) = M1(13,48); M2(25,73) = M1(13,49); M2(25,74) = M1(13,50); M2(25,75) = M1(13,51); M2(25,76) = M1(13,52); M2(25,77) = M1(13,53); M2(25,80) = M1(13,54); M2(25,81) = M1(13,55); M2(25,82) = M1(13,56); M2(25,83) = M1(13,57); M2(25,86) = M1(13,58); M2(25,87) = M1(13,59); M2(25,88) = M1(13,60); M2(25,91) = M1(13,61); M2(25,92) = M1(13,62); M2(25,96) = M1(13,63); M2(25,102) = M1(13,64); M2(25,103) = M1(13,65); M2(25,104) = M1(13,66); M2(25,105) = M1(13,67); M2(25,108) = M1(13,68); M2(25,109) = M1(13,69); M2(25,110) = M1(13,70); M2(25,113) = M1(13,71); M2(25,114) = M1(13,72); M2(25,117) = M1(13,73); M2(25,123) = M1(13,74); M2(25,124) = M1(13,75); M2(25,125) = M1(13,76); M2(25,128) = M1(13,77); M2(25,129) = M1(13,78); M2(25,132) = M1(13,79); M2(25,138) = M1(13,80); M2(25,139) = M1(13,81); M2(25,142) = M1(13,82); M2(25,148) = M1(13,83); 
M2(26,11) = M1(14,14); M2(26,12) = M1(14,15); M2(26,13) = M1(14,16); M2(26,14) = M1(14,17); M2(26,17) = M1(14,18); M2(26,18) = M1(14,19); M2(26,19) = M1(14,20); M2(26,20) = M1(14,21); M2(26,23) = M1(14,22); M2(26,24) = M1(14,23); M2(26,25) = M1(14,24); M2(26,28) = M1(14,25); M2(26,29) = M1(14,26); M2(26,32) = M1(14,27); M2(26,38) = M1(14,28); M2(26,39) = M1(14,29); M2(26,40) = M1(14,30); M2(26,41) = M1(14,31); M2(26,42) = M1(14,32); M2(26,43) = M1(14,33); M2(26,46) = M1(14,34); M2(26,47) = M1(14,35); M2(26,48) = M1(14,36); M2(26,49) = M1(14,37); M2(26,50) = M1(14,38); M2(26,53) = M1(14,39); M2(26,54) = M1(14,40); M2(26,55) = M1(14,41); M2(26,56) = M1(14,42); M2(26,59) = M1(14,43); M2(26,60) = M1(14,44); M2(26,61) = M1(14,45); M2(26,64) = M1(14,46); M2(26,65) = M1(14,47); M2(26,68) = M1(14,48); M2(26,73) = M1(14,49); M2(26,74) = M1(14,50); M2(26,75) = M1(14,51); M2(26,76) = M1(14,52); M2(26,77) = M1(14,53); M2(26,80) = M1(14,54); M2(26,81) = M1(14,55); M2(26,82) = M1(14,56); M2(26,83) = M1(14,57); M2(26,86) = M1(14,58); M2(26,87) = M1(14,59); M2(26,88) = M1(14,60); M2(26,91) = M1(14,61); M2(26,92) = M1(14,62); M2(26,96) = M1(14,63); M2(26,102) = M1(14,64); M2(26,103) = M1(14,65); M2(26,104) = M1(14,66); M2(26,105) = M1(14,67); M2(26,108) = M1(14,68); M2(26,109) = M1(14,69); M2(26,110) = M1(14,70); M2(26,113) = M1(14,71); M2(26,114) = M1(14,72); M2(26,117) = M1(14,73); M2(26,123) = M1(14,74); M2(26,124) = M1(14,75); M2(26,125) = M1(14,76); M2(26,128) = M1(14,77); M2(26,129) = M1(14,78); M2(26,132) = M1(14,79); M2(26,138) = M1(14,80); M2(26,139) = M1(14,81); M2(26,142) = M1(14,82); M2(26,148) = M1(14,83); 
M2(27,0) = M1(3,3); M2(27,11) = M1(3,15); M2(27,12) = M1(3,16); M2(27,13) = M1(3,17); M2(27,16) = M1(3,18); M2(27,17) = M1(3,19); M2(27,18) = M1(3,20); M2(27,19) = M1(3,21); M2(27,22) = M1(3,22); M2(27,23) = M1(3,23); M2(27,24) = M1(3,24); M2(27,27) = M1(3,25); M2(27,28) = M1(3,26); M2(27,31) = M1(3,27); M2(27,37) = M1(3,28); M2(27,38) = M1(3,29); M2(27,39) = M1(3,30); M2(27,40) = M1(3,31); M2(27,41) = M1(3,32); M2(27,42) = M1(3,33); M2(27,45) = M1(3,34); M2(27,46) = M1(3,35); M2(27,47) = M1(3,36); M2(27,48) = M1(3,37); M2(27,49) = M1(3,38); M2(27,52) = M1(3,39); M2(27,53) = M1(3,40); M2(27,54) = M1(3,41); M2(27,55) = M1(3,42); M2(27,58) = M1(3,43); M2(27,59) = M1(3,44); M2(27,60) = M1(3,45); M2(27,63) = M1(3,46); M2(27,64) = M1(3,47); M2(27,67) = M1(3,48); M2(27,72) = M1(3,49); M2(27,73) = M1(3,50); M2(27,74) = M1(3,51); M2(27,75) = M1(3,52); M2(27,76) = M1(3,53); M2(27,79) = M1(3,54); M2(27,80) = M1(3,55); M2(27,81) = M1(3,56); M2(27,82) = M1(3,57); M2(27,85) = M1(3,58); M2(27,86) = M1(3,59); M2(27,87) = M1(3,60); M2(27,90) = M1(3,61); M2(27,91) = M1(3,62); M2(27,95) = M1(3,63); M2(27,101) = M1(3,64); M2(27,102) = M1(3,65); M2(27,103) = M1(3,66); M2(27,104) = M1(3,67); M2(27,107) = M1(3,68); M2(27,108) = M1(3,69); M2(27,109) = M1(3,70); M2(27,112) = M1(3,71); M2(27,113) = M1(3,72); M2(27,116) = M1(3,73); M2(27,122) = M1(3,74); M2(27,123) = M1(3,75); M2(27,124) = M1(3,76); M2(27,127) = M1(3,77); M2(27,128) = M1(3,78); M2(27,131) = M1(3,79); M2(27,137) = M1(3,80); M2(27,138) = M1(3,81); M2(27,141) = M1(3,82); M2(27,147) = M1(3,83); 
M2(28,1) = M1(4,4); M2(28,11) = M1(4,15); M2(28,12) = M1(4,16); M2(28,13) = M1(4,17); M2(28,16) = M1(4,18); M2(28,17) = M1(4,19); M2(28,18) = M1(4,20); M2(28,19) = M1(4,21); M2(28,22) = M1(4,22); M2(28,23) = M1(4,23); M2(28,24) = M1(4,24); M2(28,27) = M1(4,25); M2(28,28) = M1(4,26); M2(28,31) = M1(4,27); M2(28,37) = M1(4,28); M2(28,38) = M1(4,29); M2(28,39) = M1(4,30); M2(28,40) = M1(4,31); M2(28,41) = M1(4,32); M2(28,42) = M1(4,33); M2(28,45) = M1(4,34); M2(28,46) = M1(4,35); M2(28,47) = M1(4,36); M2(28,48) = M1(4,37); M2(28,49) = M1(4,38); M2(28,52) = M1(4,39); M2(28,53) = M1(4,40); M2(28,54) = M1(4,41); M2(28,55) = M1(4,42); M2(28,58) = M1(4,43); M2(28,59) = M1(4,44); M2(28,60) = M1(4,45); M2(28,63) = M1(4,46); M2(28,64) = M1(4,47); M2(28,67) = M1(4,48); M2(28,72) = M1(4,49); M2(28,73) = M1(4,50); M2(28,74) = M1(4,51); M2(28,75) = M1(4,52); M2(28,76) = M1(4,53); M2(28,79) = M1(4,54); M2(28,80) = M1(4,55); M2(28,81) = M1(4,56); M2(28,82) = M1(4,57); M2(28,85) = M1(4,58); M2(28,86) = M1(4,59); M2(28,87) = M1(4,60); M2(28,90) = M1(4,61); M2(28,91) = M1(4,62); M2(28,95) = M1(4,63); M2(28,101) = M1(4,64); M2(28,102) = M1(4,65); M2(28,103) = M1(4,66); M2(28,104) = M1(4,67); M2(28,107) = M1(4,68); M2(28,108) = M1(4,69); M2(28,109) = M1(4,70); M2(28,112) = M1(4,71); M2(28,113) = M1(4,72); M2(28,116) = M1(4,73); M2(28,122) = M1(4,74); M2(28,123) = M1(4,75); M2(28,124) = M1(4,76); M2(28,127) = M1(4,77); M2(28,128) = M1(4,78); M2(28,131) = M1(4,79); M2(28,137) = M1(4,80); M2(28,138) = M1(4,81); M2(28,141) = M1(4,82); M2(28,147) = M1(4,83); 
M2(29,2) = M1(5,5); M2(29,11) = M1(5,15); M2(29,12) = M1(5,16); M2(29,13) = M1(5,17); M2(29,16) = M1(5,18); M2(29,17) = M1(5,19); M2(29,18) = M1(5,20); M2(29,19) = M1(5,21); M2(29,22) = M1(5,22); M2(29,23) = M1(5,23); M2(29,24) = M1(5,24); M2(29,27) = M1(5,25); M2(29,28) = M1(5,26); M2(29,31) = M1(5,27); M2(29,37) = M1(5,28); M2(29,38) = M1(5,29); M2(29,39) = M1(5,30); M2(29,40) = M1(5,31); M2(29,41) = M1(5,32); M2(29,42) = M1(5,33); M2(29,45) = M1(5,34); M2(29,46) = M1(5,35); M2(29,47) = M1(5,36); M2(29,48) = M1(5,37); M2(29,49) = M1(5,38); M2(29,52) = M1(5,39); M2(29,53) = M1(5,40); M2(29,54) = M1(5,41); M2(29,55) = M1(5,42); M2(29,58) = M1(5,43); M2(29,59) = M1(5,44); M2(29,60) = M1(5,45); M2(29,63) = M1(5,46); M2(29,64) = M1(5,47); M2(29,67) = M1(5,48); M2(29,72) = M1(5,49); M2(29,73) = M1(5,50); M2(29,74) = M1(5,51); M2(29,75) = M1(5,52); M2(29,76) = M1(5,53); M2(29,79) = M1(5,54); M2(29,80) = M1(5,55); M2(29,81) = M1(5,56); M2(29,82) = M1(5,57); M2(29,85) = M1(5,58); M2(29,86) = M1(5,59); M2(29,87) = M1(5,60); M2(29,90) = M1(5,61); M2(29,91) = M1(5,62); M2(29,95) = M1(5,63); M2(29,101) = M1(5,64); M2(29,102) = M1(5,65); M2(29,103) = M1(5,66); M2(29,104) = M1(5,67); M2(29,107) = M1(5,68); M2(29,108) = M1(5,69); M2(29,109) = M1(5,70); M2(29,112) = M1(5,71); M2(29,113) = M1(5,72); M2(29,116) = M1(5,73); M2(29,122) = M1(5,74); M2(29,123) = M1(5,75); M2(29,124) = M1(5,76); M2(29,127) = M1(5,77); M2(29,128) = M1(5,78); M2(29,131) = M1(5,79); M2(29,137) = M1(5,80); M2(29,138) = M1(5,81); M2(29,141) = M1(5,82); M2(29,147) = M1(5,83); 
M2(30,3) = M1(6,6); M2(30,11) = M1(6,15); M2(30,12) = M1(6,16); M2(30,13) = M1(6,17); M2(30,16) = M1(6,18); M2(30,17) = M1(6,19); M2(30,18) = M1(6,20); M2(30,19) = M1(6,21); M2(30,22) = M1(6,22); M2(30,23) = M1(6,23); M2(30,24) = M1(6,24); M2(30,27) = M1(6,25); M2(30,28) = M1(6,26); M2(30,31) = M1(6,27); M2(30,37) = M1(6,28); M2(30,38) = M1(6,29); M2(30,39) = M1(6,30); M2(30,40) = M1(6,31); M2(30,41) = M1(6,32); M2(30,42) = M1(6,33); M2(30,45) = M1(6,34); M2(30,46) = M1(6,35); M2(30,47) = M1(6,36); M2(30,48) = M1(6,37); M2(30,49) = M1(6,38); M2(30,52) = M1(6,39); M2(30,53) = M1(6,40); M2(30,54) = M1(6,41); M2(30,55) = M1(6,42); M2(30,58) = M1(6,43); M2(30,59) = M1(6,44); M2(30,60) = M1(6,45); M2(30,63) = M1(6,46); M2(30,64) = M1(6,47); M2(30,67) = M1(6,48); M2(30,72) = M1(6,49); M2(30,73) = M1(6,50); M2(30,74) = M1(6,51); M2(30,75) = M1(6,52); M2(30,76) = M1(6,53); M2(30,79) = M1(6,54); M2(30,80) = M1(6,55); M2(30,81) = M1(6,56); M2(30,82) = M1(6,57); M2(30,85) = M1(6,58); M2(30,86) = M1(6,59); M2(30,87) = M1(6,60); M2(30,90) = M1(6,61); M2(30,91) = M1(6,62); M2(30,95) = M1(6,63); M2(30,101) = M1(6,64); M2(30,102) = M1(6,65); M2(30,103) = M1(6,66); M2(30,104) = M1(6,67); M2(30,107) = M1(6,68); M2(30,108) = M1(6,69); M2(30,109) = M1(6,70); M2(30,112) = M1(6,71); M2(30,113) = M1(6,72); M2(30,116) = M1(6,73); M2(30,122) = M1(6,74); M2(30,123) = M1(6,75); M2(30,124) = M1(6,76); M2(30,127) = M1(6,77); M2(30,128) = M1(6,78); M2(30,131) = M1(6,79); M2(30,137) = M1(6,80); M2(30,138) = M1(6,81); M2(30,141) = M1(6,82); M2(30,147) = M1(6,83); 
M2(31,4) = M1(8,8); M2(31,11) = M1(8,15); M2(31,12) = M1(8,16); M2(31,13) = M1(8,17); M2(31,16) = M1(8,18); M2(31,17) = M1(8,19); M2(31,18) = M1(8,20); M2(31,19) = M1(8,21); M2(31,22) = M1(8,22); M2(31,23) = M1(8,23); M2(31,24) = M1(8,24); M2(31,27) = M1(8,25); M2(31,28) = M1(8,26); M2(31,31) = M1(8,27); M2(31,37) = M1(8,28); M2(31,38) = M1(8,29); M2(31,39) = M1(8,30); M2(31,40) = M1(8,31); M2(31,41) = M1(8,32); M2(31,42) = M1(8,33); M2(31,45) = M1(8,34); M2(31,46) = M1(8,35); M2(31,47) = M1(8,36); M2(31,48) = M1(8,37); M2(31,49) = M1(8,38); M2(31,52) = M1(8,39); M2(31,53) = M1(8,40); M2(31,54) = M1(8,41); M2(31,55) = M1(8,42); M2(31,58) = M1(8,43); M2(31,59) = M1(8,44); M2(31,60) = M1(8,45); M2(31,63) = M1(8,46); M2(31,64) = M1(8,47); M2(31,67) = M1(8,48); M2(31,72) = M1(8,49); M2(31,73) = M1(8,50); M2(31,74) = M1(8,51); M2(31,75) = M1(8,52); M2(31,76) = M1(8,53); M2(31,79) = M1(8,54); M2(31,80) = M1(8,55); M2(31,81) = M1(8,56); M2(31,82) = M1(8,57); M2(31,85) = M1(8,58); M2(31,86) = M1(8,59); M2(31,87) = M1(8,60); M2(31,90) = M1(8,61); M2(31,91) = M1(8,62); M2(31,95) = M1(8,63); M2(31,101) = M1(8,64); M2(31,102) = M1(8,65); M2(31,103) = M1(8,66); M2(31,104) = M1(8,67); M2(31,107) = M1(8,68); M2(31,108) = M1(8,69); M2(31,109) = M1(8,70); M2(31,112) = M1(8,71); M2(31,113) = M1(8,72); M2(31,116) = M1(8,73); M2(31,122) = M1(8,74); M2(31,123) = M1(8,75); M2(31,124) = M1(8,76); M2(31,127) = M1(8,77); M2(31,128) = M1(8,78); M2(31,131) = M1(8,79); M2(31,137) = M1(8,80); M2(31,138) = M1(8,81); M2(31,141) = M1(8,82); M2(31,147) = M1(8,83); 
M2(32,5) = M1(9,9); M2(32,11) = M1(9,15); M2(32,12) = M1(9,16); M2(32,13) = M1(9,17); M2(32,16) = M1(9,18); M2(32,17) = M1(9,19); M2(32,18) = M1(9,20); M2(32,19) = M1(9,21); M2(32,22) = M1(9,22); M2(32,23) = M1(9,23); M2(32,24) = M1(9,24); M2(32,27) = M1(9,25); M2(32,28) = M1(9,26); M2(32,31) = M1(9,27); M2(32,37) = M1(9,28); M2(32,38) = M1(9,29); M2(32,39) = M1(9,30); M2(32,40) = M1(9,31); M2(32,41) = M1(9,32); M2(32,42) = M1(9,33); M2(32,45) = M1(9,34); M2(32,46) = M1(9,35); M2(32,47) = M1(9,36); M2(32,48) = M1(9,37); M2(32,49) = M1(9,38); M2(32,52) = M1(9,39); M2(32,53) = M1(9,40); M2(32,54) = M1(9,41); M2(32,55) = M1(9,42); M2(32,58) = M1(9,43); M2(32,59) = M1(9,44); M2(32,60) = M1(9,45); M2(32,63) = M1(9,46); M2(32,64) = M1(9,47); M2(32,67) = M1(9,48); M2(32,72) = M1(9,49); M2(32,73) = M1(9,50); M2(32,74) = M1(9,51); M2(32,75) = M1(9,52); M2(32,76) = M1(9,53); M2(32,79) = M1(9,54); M2(32,80) = M1(9,55); M2(32,81) = M1(9,56); M2(32,82) = M1(9,57); M2(32,85) = M1(9,58); M2(32,86) = M1(9,59); M2(32,87) = M1(9,60); M2(32,90) = M1(9,61); M2(32,91) = M1(9,62); M2(32,95) = M1(9,63); M2(32,101) = M1(9,64); M2(32,102) = M1(9,65); M2(32,103) = M1(9,66); M2(32,104) = M1(9,67); M2(32,107) = M1(9,68); M2(32,108) = M1(9,69); M2(32,109) = M1(9,70); M2(32,112) = M1(9,71); M2(32,113) = M1(9,72); M2(32,116) = M1(9,73); M2(32,122) = M1(9,74); M2(32,123) = M1(9,75); M2(32,124) = M1(9,76); M2(32,127) = M1(9,77); M2(32,128) = M1(9,78); M2(32,131) = M1(9,79); M2(32,137) = M1(9,80); M2(32,138) = M1(9,81); M2(32,141) = M1(9,82); M2(32,147) = M1(9,83); 
M2(33,6) = M1(10,10); M2(33,11) = M1(10,15); M2(33,12) = M1(10,16); M2(33,13) = M1(10,17); M2(33,16) = M1(10,18); M2(33,17) = M1(10,19); M2(33,18) = M1(10,20); M2(33,19) = M1(10,21); M2(33,22) = M1(10,22); M2(33,23) = M1(10,23); M2(33,24) = M1(10,24); M2(33,27) = M1(10,25); M2(33,28) = M1(10,26); M2(33,31) = M1(10,27); M2(33,37) = M1(10,28); M2(33,38) = M1(10,29); M2(33,39) = M1(10,30); M2(33,40) = M1(10,31); M2(33,41) = M1(10,32); M2(33,42) = M1(10,33); M2(33,45) = M1(10,34); M2(33,46) = M1(10,35); M2(33,47) = M1(10,36); M2(33,48) = M1(10,37); M2(33,49) = M1(10,38); M2(33,52) = M1(10,39); M2(33,53) = M1(10,40); M2(33,54) = M1(10,41); M2(33,55) = M1(10,42); M2(33,58) = M1(10,43); M2(33,59) = M1(10,44); M2(33,60) = M1(10,45); M2(33,63) = M1(10,46); M2(33,64) = M1(10,47); M2(33,67) = M1(10,48); M2(33,72) = M1(10,49); M2(33,73) = M1(10,50); M2(33,74) = M1(10,51); M2(33,75) = M1(10,52); M2(33,76) = M1(10,53); M2(33,79) = M1(10,54); M2(33,80) = M1(10,55); M2(33,81) = M1(10,56); M2(33,82) = M1(10,57); M2(33,85) = M1(10,58); M2(33,86) = M1(10,59); M2(33,87) = M1(10,60); M2(33,90) = M1(10,61); M2(33,91) = M1(10,62); M2(33,95) = M1(10,63); M2(33,101) = M1(10,64); M2(33,102) = M1(10,65); M2(33,103) = M1(10,66); M2(33,104) = M1(10,67); M2(33,107) = M1(10,68); M2(33,108) = M1(10,69); M2(33,109) = M1(10,70); M2(33,112) = M1(10,71); M2(33,113) = M1(10,72); M2(33,116) = M1(10,73); M2(33,122) = M1(10,74); M2(33,123) = M1(10,75); M2(33,124) = M1(10,76); M2(33,127) = M1(10,77); M2(33,128) = M1(10,78); M2(33,131) = M1(10,79); M2(33,137) = M1(10,80); M2(33,138) = M1(10,81); M2(33,141) = M1(10,82); M2(33,147) = M1(10,83); 
M2(34,7) = M1(11,11); M2(34,11) = M1(11,15); M2(34,12) = M1(11,16); M2(34,13) = M1(11,17); M2(34,16) = M1(11,18); M2(34,17) = M1(11,19); M2(34,18) = M1(11,20); M2(34,19) = M1(11,21); M2(34,22) = M1(11,22); M2(34,23) = M1(11,23); M2(34,24) = M1(11,24); M2(34,27) = M1(11,25); M2(34,28) = M1(11,26); M2(34,31) = M1(11,27); M2(34,37) = M1(11,28); M2(34,38) = M1(11,29); M2(34,39) = M1(11,30); M2(34,40) = M1(11,31); M2(34,41) = M1(11,32); M2(34,42) = M1(11,33); M2(34,45) = M1(11,34); M2(34,46) = M1(11,35); M2(34,47) = M1(11,36); M2(34,48) = M1(11,37); M2(34,49) = M1(11,38); M2(34,52) = M1(11,39); M2(34,53) = M1(11,40); M2(34,54) = M1(11,41); M2(34,55) = M1(11,42); M2(34,58) = M1(11,43); M2(34,59) = M1(11,44); M2(34,60) = M1(11,45); M2(34,63) = M1(11,46); M2(34,64) = M1(11,47); M2(34,67) = M1(11,48); M2(34,72) = M1(11,49); M2(34,73) = M1(11,50); M2(34,74) = M1(11,51); M2(34,75) = M1(11,52); M2(34,76) = M1(11,53); M2(34,79) = M1(11,54); M2(34,80) = M1(11,55); M2(34,81) = M1(11,56); M2(34,82) = M1(11,57); M2(34,85) = M1(11,58); M2(34,86) = M1(11,59); M2(34,87) = M1(11,60); M2(34,90) = M1(11,61); M2(34,91) = M1(11,62); M2(34,95) = M1(11,63); M2(34,101) = M1(11,64); M2(34,102) = M1(11,65); M2(34,103) = M1(11,66); M2(34,104) = M1(11,67); M2(34,107) = M1(11,68); M2(34,108) = M1(11,69); M2(34,109) = M1(11,70); M2(34,112) = M1(11,71); M2(34,113) = M1(11,72); M2(34,116) = M1(11,73); M2(34,122) = M1(11,74); M2(34,123) = M1(11,75); M2(34,124) = M1(11,76); M2(34,127) = M1(11,77); M2(34,128) = M1(11,78); M2(34,131) = M1(11,79); M2(34,137) = M1(11,80); M2(34,138) = M1(11,81); M2(34,141) = M1(11,82); M2(34,147) = M1(11,83); 
M2(35,8) = M1(12,12); M2(35,11) = M1(12,15); M2(35,12) = M1(12,16); M2(35,13) = M1(12,17); M2(35,16) = M1(12,18); M2(35,17) = M1(12,19); M2(35,18) = M1(12,20); M2(35,19) = M1(12,21); M2(35,22) = M1(12,22); M2(35,23) = M1(12,23); M2(35,24) = M1(12,24); M2(35,27) = M1(12,25); M2(35,28) = M1(12,26); M2(35,31) = M1(12,27); M2(35,37) = M1(12,28); M2(35,38) = M1(12,29); M2(35,39) = M1(12,30); M2(35,40) = M1(12,31); M2(35,41) = M1(12,32); M2(35,42) = M1(12,33); M2(35,45) = M1(12,34); M2(35,46) = M1(12,35); M2(35,47) = M1(12,36); M2(35,48) = M1(12,37); M2(35,49) = M1(12,38); M2(35,52) = M1(12,39); M2(35,53) = M1(12,40); M2(35,54) = M1(12,41); M2(35,55) = M1(12,42); M2(35,58) = M1(12,43); M2(35,59) = M1(12,44); M2(35,60) = M1(12,45); M2(35,63) = M1(12,46); M2(35,64) = M1(12,47); M2(35,67) = M1(12,48); M2(35,72) = M1(12,49); M2(35,73) = M1(12,50); M2(35,74) = M1(12,51); M2(35,75) = M1(12,52); M2(35,76) = M1(12,53); M2(35,79) = M1(12,54); M2(35,80) = M1(12,55); M2(35,81) = M1(12,56); M2(35,82) = M1(12,57); M2(35,85) = M1(12,58); M2(35,86) = M1(12,59); M2(35,87) = M1(12,60); M2(35,90) = M1(12,61); M2(35,91) = M1(12,62); M2(35,95) = M1(12,63); M2(35,101) = M1(12,64); M2(35,102) = M1(12,65); M2(35,103) = M1(12,66); M2(35,104) = M1(12,67); M2(35,107) = M1(12,68); M2(35,108) = M1(12,69); M2(35,109) = M1(12,70); M2(35,112) = M1(12,71); M2(35,113) = M1(12,72); M2(35,116) = M1(12,73); M2(35,122) = M1(12,74); M2(35,123) = M1(12,75); M2(35,124) = M1(12,76); M2(35,127) = M1(12,77); M2(35,128) = M1(12,78); M2(35,131) = M1(12,79); M2(35,137) = M1(12,80); M2(35,138) = M1(12,81); M2(35,141) = M1(12,82); M2(35,147) = M1(12,83); 
M2(36,10) = M1(14,14); M2(36,11) = M1(14,15); M2(36,12) = M1(14,16); M2(36,13) = M1(14,17); M2(36,16) = M1(14,18); M2(36,17) = M1(14,19); M2(36,18) = M1(14,20); M2(36,19) = M1(14,21); M2(36,22) = M1(14,22); M2(36,23) = M1(14,23); M2(36,24) = M1(14,24); M2(36,27) = M1(14,25); M2(36,28) = M1(14,26); M2(36,31) = M1(14,27); M2(36,37) = M1(14,28); M2(36,38) = M1(14,29); M2(36,39) = M1(14,30); M2(36,40) = M1(14,31); M2(36,41) = M1(14,32); M2(36,42) = M1(14,33); M2(36,45) = M1(14,34); M2(36,46) = M1(14,35); M2(36,47) = M1(14,36); M2(36,48) = M1(14,37); M2(36,49) = M1(14,38); M2(36,52) = M1(14,39); M2(36,53) = M1(14,40); M2(36,54) = M1(14,41); M2(36,55) = M1(14,42); M2(36,58) = M1(14,43); M2(36,59) = M1(14,44); M2(36,60) = M1(14,45); M2(36,63) = M1(14,46); M2(36,64) = M1(14,47); M2(36,67) = M1(14,48); M2(36,72) = M1(14,49); M2(36,73) = M1(14,50); M2(36,74) = M1(14,51); M2(36,75) = M1(14,52); M2(36,76) = M1(14,53); M2(36,79) = M1(14,54); M2(36,80) = M1(14,55); M2(36,81) = M1(14,56); M2(36,82) = M1(14,57); M2(36,85) = M1(14,58); M2(36,86) = M1(14,59); M2(36,87) = M1(14,60); M2(36,90) = M1(14,61); M2(36,91) = M1(14,62); M2(36,95) = M1(14,63); M2(36,101) = M1(14,64); M2(36,102) = M1(14,65); M2(36,103) = M1(14,66); M2(36,104) = M1(14,67); M2(36,107) = M1(14,68); M2(36,108) = M1(14,69); M2(36,109) = M1(14,70); M2(36,112) = M1(14,71); M2(36,113) = M1(14,72); M2(36,116) = M1(14,73); M2(36,122) = M1(14,74); M2(36,123) = M1(14,75); M2(36,124) = M1(14,76); M2(36,127) = M1(14,77); M2(36,128) = M1(14,78); M2(36,131) = M1(14,79); M2(36,137) = M1(14,80); M2(36,138) = M1(14,81); M2(36,141) = M1(14,82); M2(36,147) = M1(14,83); 
M2(37,48) = M1(3,3); M2(37,60) = M1(3,15); M2(37,61) = M1(3,16); M2(37,62) = M1(3,17); M2(37,63) = M1(3,18); M2(37,64) = M1(3,19); M2(37,65) = M1(3,20); M2(37,66) = M1(3,21); M2(37,67) = M1(3,22); M2(37,68) = M1(3,23); M2(37,69) = M1(3,24); M2(37,70) = M1(3,25); M2(37,71) = M1(3,26); M2(37,79) = M1(3,28); M2(37,80) = M1(3,29); M2(37,81) = M1(3,30); M2(37,82) = M1(3,31); M2(37,83) = M1(3,32); M2(37,84) = M1(3,33); M2(37,85) = M1(3,34); M2(37,86) = M1(3,35); M2(37,87) = M1(3,36); M2(37,88) = M1(3,37); M2(37,89) = M1(3,38); M2(37,90) = M1(3,39); M2(37,91) = M1(3,40); M2(37,92) = M1(3,41); M2(37,93) = M1(3,27); M2(37,94) = M1(3,42); M2(37,95) = M1(3,43); M2(37,96) = M1(3,44); M2(37,97) = M1(3,45); M2(37,98) = M1(3,46); M2(37,99) = M1(3,47); M2(37,100) = M1(3,48); M2(37,107) = M1(3,49); M2(37,108) = M1(3,50); M2(37,109) = M1(3,51); M2(37,110) = M1(3,52); M2(37,111) = M1(3,53); M2(37,112) = M1(3,54); M2(37,113) = M1(3,55); M2(37,114) = M1(3,56); M2(37,115) = M1(3,57); M2(37,116) = M1(3,58); M2(37,117) = M1(3,59); M2(37,118) = M1(3,60); M2(37,119) = M1(3,61); M2(37,120) = M1(3,62); M2(37,121) = M1(3,63); M2(37,127) = M1(3,64); M2(37,128) = M1(3,65); M2(37,129) = M1(3,66); M2(37,130) = M1(3,67); M2(37,131) = M1(3,68); M2(37,132) = M1(3,69); M2(37,133) = M1(3,70); M2(37,134) = M1(3,71); M2(37,135) = M1(3,72); M2(37,136) = M1(3,73); M2(37,141) = M1(3,74); M2(37,142) = M1(3,75); M2(37,143) = M1(3,76); M2(37,144) = M1(3,77); M2(37,145) = M1(3,78); M2(37,146) = M1(3,79); M2(37,150) = M1(3,80); M2(37,151) = M1(3,81); M2(37,152) = M1(3,82); M2(37,155) = M1(3,83); 
M2(38,49) = M1(4,4); M2(38,60) = M1(4,15); M2(38,61) = M1(4,16); M2(38,62) = M1(4,17); M2(38,63) = M1(4,18); M2(38,64) = M1(4,19); M2(38,65) = M1(4,20); M2(38,66) = M1(4,21); M2(38,67) = M1(4,22); M2(38,68) = M1(4,23); M2(38,69) = M1(4,24); M2(38,70) = M1(4,25); M2(38,71) = M1(4,26); M2(38,79) = M1(4,28); M2(38,80) = M1(4,29); M2(38,81) = M1(4,30); M2(38,82) = M1(4,31); M2(38,83) = M1(4,32); M2(38,84) = M1(4,33); M2(38,85) = M1(4,34); M2(38,86) = M1(4,35); M2(38,87) = M1(4,36); M2(38,88) = M1(4,37); M2(38,89) = M1(4,38); M2(38,90) = M1(4,39); M2(38,91) = M1(4,40); M2(38,92) = M1(4,41); M2(38,93) = M1(4,27); M2(38,94) = M1(4,42); M2(38,95) = M1(4,43); M2(38,96) = M1(4,44); M2(38,97) = M1(4,45); M2(38,98) = M1(4,46); M2(38,99) = M1(4,47); M2(38,100) = M1(4,48); M2(38,107) = M1(4,49); M2(38,108) = M1(4,50); M2(38,109) = M1(4,51); M2(38,110) = M1(4,52); M2(38,111) = M1(4,53); M2(38,112) = M1(4,54); M2(38,113) = M1(4,55); M2(38,114) = M1(4,56); M2(38,115) = M1(4,57); M2(38,116) = M1(4,58); M2(38,117) = M1(4,59); M2(38,118) = M1(4,60); M2(38,119) = M1(4,61); M2(38,120) = M1(4,62); M2(38,121) = M1(4,63); M2(38,127) = M1(4,64); M2(38,128) = M1(4,65); M2(38,129) = M1(4,66); M2(38,130) = M1(4,67); M2(38,131) = M1(4,68); M2(38,132) = M1(4,69); M2(38,133) = M1(4,70); M2(38,134) = M1(4,71); M2(38,135) = M1(4,72); M2(38,136) = M1(4,73); M2(38,141) = M1(4,74); M2(38,142) = M1(4,75); M2(38,143) = M1(4,76); M2(38,144) = M1(4,77); M2(38,145) = M1(4,78); M2(38,146) = M1(4,79); M2(38,150) = M1(4,80); M2(38,151) = M1(4,81); M2(38,152) = M1(4,82); M2(38,155) = M1(4,83); 
M2(39,50) = M1(5,5); M2(39,60) = M1(5,15); M2(39,61) = M1(5,16); M2(39,62) = M1(5,17); M2(39,63) = M1(5,18); M2(39,64) = M1(5,19); M2(39,65) = M1(5,20); M2(39,66) = M1(5,21); M2(39,67) = M1(5,22); M2(39,68) = M1(5,23); M2(39,69) = M1(5,24); M2(39,70) = M1(5,25); M2(39,71) = M1(5,26); M2(39,79) = M1(5,28); M2(39,80) = M1(5,29); M2(39,81) = M1(5,30); M2(39,82) = M1(5,31); M2(39,83) = M1(5,32); M2(39,84) = M1(5,33); M2(39,85) = M1(5,34); M2(39,86) = M1(5,35); M2(39,87) = M1(5,36); M2(39,88) = M1(5,37); M2(39,89) = M1(5,38); M2(39,90) = M1(5,39); M2(39,91) = M1(5,40); M2(39,92) = M1(5,41); M2(39,93) = M1(5,27); M2(39,94) = M1(5,42); M2(39,95) = M1(5,43); M2(39,96) = M1(5,44); M2(39,97) = M1(5,45); M2(39,98) = M1(5,46); M2(39,99) = M1(5,47); M2(39,100) = M1(5,48); M2(39,107) = M1(5,49); M2(39,108) = M1(5,50); M2(39,109) = M1(5,51); M2(39,110) = M1(5,52); M2(39,111) = M1(5,53); M2(39,112) = M1(5,54); M2(39,113) = M1(5,55); M2(39,114) = M1(5,56); M2(39,115) = M1(5,57); M2(39,116) = M1(5,58); M2(39,117) = M1(5,59); M2(39,118) = M1(5,60); M2(39,119) = M1(5,61); M2(39,120) = M1(5,62); M2(39,121) = M1(5,63); M2(39,127) = M1(5,64); M2(39,128) = M1(5,65); M2(39,129) = M1(5,66); M2(39,130) = M1(5,67); M2(39,131) = M1(5,68); M2(39,132) = M1(5,69); M2(39,133) = M1(5,70); M2(39,134) = M1(5,71); M2(39,135) = M1(5,72); M2(39,136) = M1(5,73); M2(39,141) = M1(5,74); M2(39,142) = M1(5,75); M2(39,143) = M1(5,76); M2(39,144) = M1(5,77); M2(39,145) = M1(5,78); M2(39,146) = M1(5,79); M2(39,150) = M1(5,80); M2(39,151) = M1(5,81); M2(39,152) = M1(5,82); M2(39,155) = M1(5,83); 
M2(40,51) = M1(6,6); M2(40,60) = M1(6,15); M2(40,61) = M1(6,16); M2(40,62) = M1(6,17); M2(40,63) = M1(6,18); M2(40,64) = M1(6,19); M2(40,65) = M1(6,20); M2(40,66) = M1(6,21); M2(40,67) = M1(6,22); M2(40,68) = M1(6,23); M2(40,69) = M1(6,24); M2(40,70) = M1(6,25); M2(40,71) = M1(6,26); M2(40,79) = M1(6,28); M2(40,80) = M1(6,29); M2(40,81) = M1(6,30); M2(40,82) = M1(6,31); M2(40,83) = M1(6,32); M2(40,84) = M1(6,33); M2(40,85) = M1(6,34); M2(40,86) = M1(6,35); M2(40,87) = M1(6,36); M2(40,88) = M1(6,37); M2(40,89) = M1(6,38); M2(40,90) = M1(6,39); M2(40,91) = M1(6,40); M2(40,92) = M1(6,41); M2(40,93) = M1(6,27); M2(40,94) = M1(6,42); M2(40,95) = M1(6,43); M2(40,96) = M1(6,44); M2(40,97) = M1(6,45); M2(40,98) = M1(6,46); M2(40,99) = M1(6,47); M2(40,100) = M1(6,48); M2(40,107) = M1(6,49); M2(40,108) = M1(6,50); M2(40,109) = M1(6,51); M2(40,110) = M1(6,52); M2(40,111) = M1(6,53); M2(40,112) = M1(6,54); M2(40,113) = M1(6,55); M2(40,114) = M1(6,56); M2(40,115) = M1(6,57); M2(40,116) = M1(6,58); M2(40,117) = M1(6,59); M2(40,118) = M1(6,60); M2(40,119) = M1(6,61); M2(40,120) = M1(6,62); M2(40,121) = M1(6,63); M2(40,127) = M1(6,64); M2(40,128) = M1(6,65); M2(40,129) = M1(6,66); M2(40,130) = M1(6,67); M2(40,131) = M1(6,68); M2(40,132) = M1(6,69); M2(40,133) = M1(6,70); M2(40,134) = M1(6,71); M2(40,135) = M1(6,72); M2(40,136) = M1(6,73); M2(40,141) = M1(6,74); M2(40,142) = M1(6,75); M2(40,143) = M1(6,76); M2(40,144) = M1(6,77); M2(40,145) = M1(6,78); M2(40,146) = M1(6,79); M2(40,150) = M1(6,80); M2(40,151) = M1(6,81); M2(40,152) = M1(6,82); M2(40,155) = M1(6,83); 
M2(41,52) = M1(7,7); M2(41,60) = M1(7,15); M2(41,61) = M1(7,16); M2(41,62) = M1(7,17); M2(41,63) = M1(7,18); M2(41,64) = M1(7,19); M2(41,65) = M1(7,20); M2(41,66) = M1(7,21); M2(41,67) = M1(7,22); M2(41,68) = M1(7,23); M2(41,69) = M1(7,24); M2(41,70) = M1(7,25); M2(41,71) = M1(7,26); M2(41,79) = M1(7,28); M2(41,80) = M1(7,29); M2(41,81) = M1(7,30); M2(41,82) = M1(7,31); M2(41,83) = M1(7,32); M2(41,84) = M1(7,33); M2(41,85) = M1(7,34); M2(41,86) = M1(7,35); M2(41,87) = M1(7,36); M2(41,88) = M1(7,37); M2(41,89) = M1(7,38); M2(41,90) = M1(7,39); M2(41,91) = M1(7,40); M2(41,92) = M1(7,41); M2(41,93) = M1(7,27); M2(41,94) = M1(7,42); M2(41,95) = M1(7,43); M2(41,96) = M1(7,44); M2(41,97) = M1(7,45); M2(41,98) = M1(7,46); M2(41,99) = M1(7,47); M2(41,100) = M1(7,48); M2(41,107) = M1(7,49); M2(41,108) = M1(7,50); M2(41,109) = M1(7,51); M2(41,110) = M1(7,52); M2(41,111) = M1(7,53); M2(41,112) = M1(7,54); M2(41,113) = M1(7,55); M2(41,114) = M1(7,56); M2(41,115) = M1(7,57); M2(41,116) = M1(7,58); M2(41,117) = M1(7,59); M2(41,118) = M1(7,60); M2(41,119) = M1(7,61); M2(41,120) = M1(7,62); M2(41,121) = M1(7,63); M2(41,127) = M1(7,64); M2(41,128) = M1(7,65); M2(41,129) = M1(7,66); M2(41,130) = M1(7,67); M2(41,131) = M1(7,68); M2(41,132) = M1(7,69); M2(41,133) = M1(7,70); M2(41,134) = M1(7,71); M2(41,135) = M1(7,72); M2(41,136) = M1(7,73); M2(41,141) = M1(7,74); M2(41,142) = M1(7,75); M2(41,143) = M1(7,76); M2(41,144) = M1(7,77); M2(41,145) = M1(7,78); M2(41,146) = M1(7,79); M2(41,150) = M1(7,80); M2(41,151) = M1(7,81); M2(41,152) = M1(7,82); M2(41,155) = M1(7,83); 
M2(42,53) = M1(8,8); M2(42,60) = M1(8,15); M2(42,61) = M1(8,16); M2(42,62) = M1(8,17); M2(42,63) = M1(8,18); M2(42,64) = M1(8,19); M2(42,65) = M1(8,20); M2(42,66) = M1(8,21); M2(42,67) = M1(8,22); M2(42,68) = M1(8,23); M2(42,69) = M1(8,24); M2(42,70) = M1(8,25); M2(42,71) = M1(8,26); M2(42,79) = M1(8,28); M2(42,80) = M1(8,29); M2(42,81) = M1(8,30); M2(42,82) = M1(8,31); M2(42,83) = M1(8,32); M2(42,84) = M1(8,33); M2(42,85) = M1(8,34); M2(42,86) = M1(8,35); M2(42,87) = M1(8,36); M2(42,88) = M1(8,37); M2(42,89) = M1(8,38); M2(42,90) = M1(8,39); M2(42,91) = M1(8,40); M2(42,92) = M1(8,41); M2(42,93) = M1(8,27); M2(42,94) = M1(8,42); M2(42,95) = M1(8,43); M2(42,96) = M1(8,44); M2(42,97) = M1(8,45); M2(42,98) = M1(8,46); M2(42,99) = M1(8,47); M2(42,100) = M1(8,48); M2(42,107) = M1(8,49); M2(42,108) = M1(8,50); M2(42,109) = M1(8,51); M2(42,110) = M1(8,52); M2(42,111) = M1(8,53); M2(42,112) = M1(8,54); M2(42,113) = M1(8,55); M2(42,114) = M1(8,56); M2(42,115) = M1(8,57); M2(42,116) = M1(8,58); M2(42,117) = M1(8,59); M2(42,118) = M1(8,60); M2(42,119) = M1(8,61); M2(42,120) = M1(8,62); M2(42,121) = M1(8,63); M2(42,127) = M1(8,64); M2(42,128) = M1(8,65); M2(42,129) = M1(8,66); M2(42,130) = M1(8,67); M2(42,131) = M1(8,68); M2(42,132) = M1(8,69); M2(42,133) = M1(8,70); M2(42,134) = M1(8,71); M2(42,135) = M1(8,72); M2(42,136) = M1(8,73); M2(42,141) = M1(8,74); M2(42,142) = M1(8,75); M2(42,143) = M1(8,76); M2(42,144) = M1(8,77); M2(42,145) = M1(8,78); M2(42,146) = M1(8,79); M2(42,150) = M1(8,80); M2(42,151) = M1(8,81); M2(42,152) = M1(8,82); M2(42,155) = M1(8,83); 
M2(43,54) = M1(9,9); M2(43,60) = M1(9,15); M2(43,61) = M1(9,16); M2(43,62) = M1(9,17); M2(43,63) = M1(9,18); M2(43,64) = M1(9,19); M2(43,65) = M1(9,20); M2(43,66) = M1(9,21); M2(43,67) = M1(9,22); M2(43,68) = M1(9,23); M2(43,69) = M1(9,24); M2(43,70) = M1(9,25); M2(43,71) = M1(9,26); M2(43,79) = M1(9,28); M2(43,80) = M1(9,29); M2(43,81) = M1(9,30); M2(43,82) = M1(9,31); M2(43,83) = M1(9,32); M2(43,84) = M1(9,33); M2(43,85) = M1(9,34); M2(43,86) = M1(9,35); M2(43,87) = M1(9,36); M2(43,88) = M1(9,37); M2(43,89) = M1(9,38); M2(43,90) = M1(9,39); M2(43,91) = M1(9,40); M2(43,92) = M1(9,41); M2(43,93) = M1(9,27); M2(43,94) = M1(9,42); M2(43,95) = M1(9,43); M2(43,96) = M1(9,44); M2(43,97) = M1(9,45); M2(43,98) = M1(9,46); M2(43,99) = M1(9,47); M2(43,100) = M1(9,48); M2(43,107) = M1(9,49); M2(43,108) = M1(9,50); M2(43,109) = M1(9,51); M2(43,110) = M1(9,52); M2(43,111) = M1(9,53); M2(43,112) = M1(9,54); M2(43,113) = M1(9,55); M2(43,114) = M1(9,56); M2(43,115) = M1(9,57); M2(43,116) = M1(9,58); M2(43,117) = M1(9,59); M2(43,118) = M1(9,60); M2(43,119) = M1(9,61); M2(43,120) = M1(9,62); M2(43,121) = M1(9,63); M2(43,127) = M1(9,64); M2(43,128) = M1(9,65); M2(43,129) = M1(9,66); M2(43,130) = M1(9,67); M2(43,131) = M1(9,68); M2(43,132) = M1(9,69); M2(43,133) = M1(9,70); M2(43,134) = M1(9,71); M2(43,135) = M1(9,72); M2(43,136) = M1(9,73); M2(43,141) = M1(9,74); M2(43,142) = M1(9,75); M2(43,143) = M1(9,76); M2(43,144) = M1(9,77); M2(43,145) = M1(9,78); M2(43,146) = M1(9,79); M2(43,150) = M1(9,80); M2(43,151) = M1(9,81); M2(43,152) = M1(9,82); M2(43,155) = M1(9,83); 
M2(44,55) = M1(10,10); M2(44,60) = M1(10,15); M2(44,61) = M1(10,16); M2(44,62) = M1(10,17); M2(44,63) = M1(10,18); M2(44,64) = M1(10,19); M2(44,65) = M1(10,20); M2(44,66) = M1(10,21); M2(44,67) = M1(10,22); M2(44,68) = M1(10,23); M2(44,69) = M1(10,24); M2(44,70) = M1(10,25); M2(44,71) = M1(10,26); M2(44,79) = M1(10,28); M2(44,80) = M1(10,29); M2(44,81) = M1(10,30); M2(44,82) = M1(10,31); M2(44,83) = M1(10,32); M2(44,84) = M1(10,33); M2(44,85) = M1(10,34); M2(44,86) = M1(10,35); M2(44,87) = M1(10,36); M2(44,88) = M1(10,37); M2(44,89) = M1(10,38); M2(44,90) = M1(10,39); M2(44,91) = M1(10,40); M2(44,92) = M1(10,41); M2(44,93) = M1(10,27); M2(44,94) = M1(10,42); M2(44,95) = M1(10,43); M2(44,96) = M1(10,44); M2(44,97) = M1(10,45); M2(44,98) = M1(10,46); M2(44,99) = M1(10,47); M2(44,100) = M1(10,48); M2(44,107) = M1(10,49); M2(44,108) = M1(10,50); M2(44,109) = M1(10,51); M2(44,110) = M1(10,52); M2(44,111) = M1(10,53); M2(44,112) = M1(10,54); M2(44,113) = M1(10,55); M2(44,114) = M1(10,56); M2(44,115) = M1(10,57); M2(44,116) = M1(10,58); M2(44,117) = M1(10,59); M2(44,118) = M1(10,60); M2(44,119) = M1(10,61); M2(44,120) = M1(10,62); M2(44,121) = M1(10,63); M2(44,127) = M1(10,64); M2(44,128) = M1(10,65); M2(44,129) = M1(10,66); M2(44,130) = M1(10,67); M2(44,131) = M1(10,68); M2(44,132) = M1(10,69); M2(44,133) = M1(10,70); M2(44,134) = M1(10,71); M2(44,135) = M1(10,72); M2(44,136) = M1(10,73); M2(44,141) = M1(10,74); M2(44,142) = M1(10,75); M2(44,143) = M1(10,76); M2(44,144) = M1(10,77); M2(44,145) = M1(10,78); M2(44,146) = M1(10,79); M2(44,150) = M1(10,80); M2(44,151) = M1(10,81); M2(44,152) = M1(10,82); M2(44,155) = M1(10,83); 
M2(45,56) = M1(11,11); M2(45,60) = M1(11,15); M2(45,61) = M1(11,16); M2(45,62) = M1(11,17); M2(45,63) = M1(11,18); M2(45,64) = M1(11,19); M2(45,65) = M1(11,20); M2(45,66) = M1(11,21); M2(45,67) = M1(11,22); M2(45,68) = M1(11,23); M2(45,69) = M1(11,24); M2(45,70) = M1(11,25); M2(45,71) = M1(11,26); M2(45,79) = M1(11,28); M2(45,80) = M1(11,29); M2(45,81) = M1(11,30); M2(45,82) = M1(11,31); M2(45,83) = M1(11,32); M2(45,84) = M1(11,33); M2(45,85) = M1(11,34); M2(45,86) = M1(11,35); M2(45,87) = M1(11,36); M2(45,88) = M1(11,37); M2(45,89) = M1(11,38); M2(45,90) = M1(11,39); M2(45,91) = M1(11,40); M2(45,92) = M1(11,41); M2(45,93) = M1(11,27); M2(45,94) = M1(11,42); M2(45,95) = M1(11,43); M2(45,96) = M1(11,44); M2(45,97) = M1(11,45); M2(45,98) = M1(11,46); M2(45,99) = M1(11,47); M2(45,100) = M1(11,48); M2(45,107) = M1(11,49); M2(45,108) = M1(11,50); M2(45,109) = M1(11,51); M2(45,110) = M1(11,52); M2(45,111) = M1(11,53); M2(45,112) = M1(11,54); M2(45,113) = M1(11,55); M2(45,114) = M1(11,56); M2(45,115) = M1(11,57); M2(45,116) = M1(11,58); M2(45,117) = M1(11,59); M2(45,118) = M1(11,60); M2(45,119) = M1(11,61); M2(45,120) = M1(11,62); M2(45,121) = M1(11,63); M2(45,127) = M1(11,64); M2(45,128) = M1(11,65); M2(45,129) = M1(11,66); M2(45,130) = M1(11,67); M2(45,131) = M1(11,68); M2(45,132) = M1(11,69); M2(45,133) = M1(11,70); M2(45,134) = M1(11,71); M2(45,135) = M1(11,72); M2(45,136) = M1(11,73); M2(45,141) = M1(11,74); M2(45,142) = M1(11,75); M2(45,143) = M1(11,76); M2(45,144) = M1(11,77); M2(45,145) = M1(11,78); M2(45,146) = M1(11,79); M2(45,150) = M1(11,80); M2(45,151) = M1(11,81); M2(45,152) = M1(11,82); M2(45,155) = M1(11,83); 
M2(46,57) = M1(12,12); M2(46,60) = M1(12,15); M2(46,61) = M1(12,16); M2(46,62) = M1(12,17); M2(46,63) = M1(12,18); M2(46,64) = M1(12,19); M2(46,65) = M1(12,20); M2(46,66) = M1(12,21); M2(46,67) = M1(12,22); M2(46,68) = M1(12,23); M2(46,69) = M1(12,24); M2(46,70) = M1(12,25); M2(46,71) = M1(12,26); M2(46,79) = M1(12,28); M2(46,80) = M1(12,29); M2(46,81) = M1(12,30); M2(46,82) = M1(12,31); M2(46,83) = M1(12,32); M2(46,84) = M1(12,33); M2(46,85) = M1(12,34); M2(46,86) = M1(12,35); M2(46,87) = M1(12,36); M2(46,88) = M1(12,37); M2(46,89) = M1(12,38); M2(46,90) = M1(12,39); M2(46,91) = M1(12,40); M2(46,92) = M1(12,41); M2(46,93) = M1(12,27); M2(46,94) = M1(12,42); M2(46,95) = M1(12,43); M2(46,96) = M1(12,44); M2(46,97) = M1(12,45); M2(46,98) = M1(12,46); M2(46,99) = M1(12,47); M2(46,100) = M1(12,48); M2(46,107) = M1(12,49); M2(46,108) = M1(12,50); M2(46,109) = M1(12,51); M2(46,110) = M1(12,52); M2(46,111) = M1(12,53); M2(46,112) = M1(12,54); M2(46,113) = M1(12,55); M2(46,114) = M1(12,56); M2(46,115) = M1(12,57); M2(46,116) = M1(12,58); M2(46,117) = M1(12,59); M2(46,118) = M1(12,60); M2(46,119) = M1(12,61); M2(46,120) = M1(12,62); M2(46,121) = M1(12,63); M2(46,127) = M1(12,64); M2(46,128) = M1(12,65); M2(46,129) = M1(12,66); M2(46,130) = M1(12,67); M2(46,131) = M1(12,68); M2(46,132) = M1(12,69); M2(46,133) = M1(12,70); M2(46,134) = M1(12,71); M2(46,135) = M1(12,72); M2(46,136) = M1(12,73); M2(46,141) = M1(12,74); M2(46,142) = M1(12,75); M2(46,143) = M1(12,76); M2(46,144) = M1(12,77); M2(46,145) = M1(12,78); M2(46,146) = M1(12,79); M2(46,150) = M1(12,80); M2(46,151) = M1(12,81); M2(46,152) = M1(12,82); M2(46,155) = M1(12,83); 
M2(47,58) = M1(13,13); M2(47,60) = M1(13,15); M2(47,61) = M1(13,16); M2(47,62) = M1(13,17); M2(47,63) = M1(13,18); M2(47,64) = M1(13,19); M2(47,65) = M1(13,20); M2(47,66) = M1(13,21); M2(47,67) = M1(13,22); M2(47,68) = M1(13,23); M2(47,69) = M1(13,24); M2(47,70) = M1(13,25); M2(47,71) = M1(13,26); M2(47,79) = M1(13,28); M2(47,80) = M1(13,29); M2(47,81) = M1(13,30); M2(47,82) = M1(13,31); M2(47,83) = M1(13,32); M2(47,84) = M1(13,33); M2(47,85) = M1(13,34); M2(47,86) = M1(13,35); M2(47,87) = M1(13,36); M2(47,88) = M1(13,37); M2(47,89) = M1(13,38); M2(47,90) = M1(13,39); M2(47,91) = M1(13,40); M2(47,92) = M1(13,41); M2(47,93) = M1(13,27); M2(47,94) = M1(13,42); M2(47,95) = M1(13,43); M2(47,96) = M1(13,44); M2(47,97) = M1(13,45); M2(47,98) = M1(13,46); M2(47,99) = M1(13,47); M2(47,100) = M1(13,48); M2(47,107) = M1(13,49); M2(47,108) = M1(13,50); M2(47,109) = M1(13,51); M2(47,110) = M1(13,52); M2(47,111) = M1(13,53); M2(47,112) = M1(13,54); M2(47,113) = M1(13,55); M2(47,114) = M1(13,56); M2(47,115) = M1(13,57); M2(47,116) = M1(13,58); M2(47,117) = M1(13,59); M2(47,118) = M1(13,60); M2(47,119) = M1(13,61); M2(47,120) = M1(13,62); M2(47,121) = M1(13,63); M2(47,127) = M1(13,64); M2(47,128) = M1(13,65); M2(47,129) = M1(13,66); M2(47,130) = M1(13,67); M2(47,131) = M1(13,68); M2(47,132) = M1(13,69); M2(47,133) = M1(13,70); M2(47,134) = M1(13,71); M2(47,135) = M1(13,72); M2(47,136) = M1(13,73); M2(47,141) = M1(13,74); M2(47,142) = M1(13,75); M2(47,143) = M1(13,76); M2(47,144) = M1(13,77); M2(47,145) = M1(13,78); M2(47,146) = M1(13,79); M2(47,150) = M1(13,80); M2(47,151) = M1(13,81); M2(47,152) = M1(13,82); M2(47,155) = M1(13,83); 
M2(48,59) = M1(14,14); M2(48,60) = M1(14,15); M2(48,61) = M1(14,16); M2(48,62) = M1(14,17); M2(48,63) = M1(14,18); M2(48,64) = M1(14,19); M2(48,65) = M1(14,20); M2(48,66) = M1(14,21); M2(48,67) = M1(14,22); M2(48,68) = M1(14,23); M2(48,69) = M1(14,24); M2(48,70) = M1(14,25); M2(48,71) = M1(14,26); M2(48,79) = M1(14,28); M2(48,80) = M1(14,29); M2(48,81) = M1(14,30); M2(48,82) = M1(14,31); M2(48,83) = M1(14,32); M2(48,84) = M1(14,33); M2(48,85) = M1(14,34); M2(48,86) = M1(14,35); M2(48,87) = M1(14,36); M2(48,88) = M1(14,37); M2(48,89) = M1(14,38); M2(48,90) = M1(14,39); M2(48,91) = M1(14,40); M2(48,92) = M1(14,41); M2(48,93) = M1(14,27); M2(48,94) = M1(14,42); M2(48,95) = M1(14,43); M2(48,96) = M1(14,44); M2(48,97) = M1(14,45); M2(48,98) = M1(14,46); M2(48,99) = M1(14,47); M2(48,100) = M1(14,48); M2(48,107) = M1(14,49); M2(48,108) = M1(14,50); M2(48,109) = M1(14,51); M2(48,110) = M1(14,52); M2(48,111) = M1(14,53); M2(48,112) = M1(14,54); M2(48,113) = M1(14,55); M2(48,114) = M1(14,56); M2(48,115) = M1(14,57); M2(48,116) = M1(14,58); M2(48,117) = M1(14,59); M2(48,118) = M1(14,60); M2(48,119) = M1(14,61); M2(48,120) = M1(14,62); M2(48,121) = M1(14,63); M2(48,127) = M1(14,64); M2(48,128) = M1(14,65); M2(48,129) = M1(14,66); M2(48,130) = M1(14,67); M2(48,131) = M1(14,68); M2(48,132) = M1(14,69); M2(48,133) = M1(14,70); M2(48,134) = M1(14,71); M2(48,135) = M1(14,72); M2(48,136) = M1(14,73); M2(48,141) = M1(14,74); M2(48,142) = M1(14,75); M2(48,143) = M1(14,76); M2(48,144) = M1(14,77); M2(48,145) = M1(14,78); M2(48,146) = M1(14,79); M2(48,150) = M1(14,80); M2(48,151) = M1(14,81); M2(48,152) = M1(14,82); M2(48,155) = M1(14,83); 
M2(49,39) = M1(1,1); M2(49,55) = M1(1,15); M2(49,56) = M1(1,16); M2(49,57) = M1(1,17); M2(49,59) = M1(1,18); M2(49,60) = M1(1,19); M2(49,61) = M1(1,20); M2(49,62) = M1(1,21); M2(49,64) = M1(1,22); M2(49,65) = M1(1,23); M2(49,66) = M1(1,24); M2(49,68) = M1(1,25); M2(49,69) = M1(1,26); M2(49,71) = M1(1,27); M2(49,73) = M1(1,28); M2(49,74) = M1(1,29); M2(49,75) = M1(1,30); M2(49,76) = M1(1,31); M2(49,77) = M1(1,32); M2(49,78) = M1(1,33); M2(49,80) = M1(1,34); M2(49,81) = M1(1,35); M2(49,82) = M1(1,36); M2(49,83) = M1(1,37); M2(49,84) = M1(1,38); M2(49,86) = M1(1,39); M2(49,87) = M1(1,40); M2(49,88) = M1(1,41); M2(49,89) = M1(1,42); M2(49,91) = M1(1,43); M2(49,92) = M1(1,44); M2(49,94) = M1(1,45); M2(49,96) = M1(1,46); M2(49,97) = M1(1,47); M2(49,99) = M1(1,48); M2(49,102) = M1(1,49); M2(49,103) = M1(1,50); M2(49,104) = M1(1,51); M2(49,105) = M1(1,52); M2(49,106) = M1(1,53); M2(49,108) = M1(1,54); M2(49,109) = M1(1,55); M2(49,110) = M1(1,56); M2(49,111) = M1(1,57); M2(49,113) = M1(1,58); M2(49,114) = M1(1,59); M2(49,115) = M1(1,60); M2(49,117) = M1(1,61); M2(49,118) = M1(1,62); M2(49,120) = M1(1,63); M2(49,123) = M1(1,64); M2(49,124) = M1(1,65); M2(49,125) = M1(1,66); M2(49,126) = M1(1,67); M2(49,128) = M1(1,68); M2(49,129) = M1(1,69); M2(49,130) = M1(1,70); M2(49,132) = M1(1,71); M2(49,133) = M1(1,72); M2(49,135) = M1(1,73); M2(49,138) = M1(1,74); M2(49,139) = M1(1,75); M2(49,140) = M1(1,76); M2(49,142) = M1(1,77); M2(49,143) = M1(1,78); M2(49,145) = M1(1,79); M2(49,148) = M1(1,80); M2(49,149) = M1(1,81); M2(49,151) = M1(1,82); M2(49,154) = M1(1,83); 
M2(50,40) = M1(2,2); M2(50,55) = M1(2,15); M2(50,56) = M1(2,16); M2(50,57) = M1(2,17); M2(50,59) = M1(2,18); M2(50,60) = M1(2,19); M2(50,61) = M1(2,20); M2(50,62) = M1(2,21); M2(50,64) = M1(2,22); M2(50,65) = M1(2,23); M2(50,66) = M1(2,24); M2(50,68) = M1(2,25); M2(50,69) = M1(2,26); M2(50,71) = M1(2,27); M2(50,73) = M1(2,28); M2(50,74) = M1(2,29); M2(50,75) = M1(2,30); M2(50,76) = M1(2,31); M2(50,77) = M1(2,32); M2(50,78) = M1(2,33); M2(50,80) = M1(2,34); M2(50,81) = M1(2,35); M2(50,82) = M1(2,36); M2(50,83) = M1(2,37); M2(50,84) = M1(2,38); M2(50,86) = M1(2,39); M2(50,87) = M1(2,40); M2(50,88) = M1(2,41); M2(50,89) = M1(2,42); M2(50,91) = M1(2,43); M2(50,92) = M1(2,44); M2(50,94) = M1(2,45); M2(50,96) = M1(2,46); M2(50,97) = M1(2,47); M2(50,99) = M1(2,48); M2(50,102) = M1(2,49); M2(50,103) = M1(2,50); M2(50,104) = M1(2,51); M2(50,105) = M1(2,52); M2(50,106) = M1(2,53); M2(50,108) = M1(2,54); M2(50,109) = M1(2,55); M2(50,110) = M1(2,56); M2(50,111) = M1(2,57); M2(50,113) = M1(2,58); M2(50,114) = M1(2,59); M2(50,115) = M1(2,60); M2(50,117) = M1(2,61); M2(50,118) = M1(2,62); M2(50,120) = M1(2,63); M2(50,123) = M1(2,64); M2(50,124) = M1(2,65); M2(50,125) = M1(2,66); M2(50,126) = M1(2,67); M2(50,128) = M1(2,68); M2(50,129) = M1(2,69); M2(50,130) = M1(2,70); M2(50,132) = M1(2,71); M2(50,133) = M1(2,72); M2(50,135) = M1(2,73); M2(50,138) = M1(2,74); M2(50,139) = M1(2,75); M2(50,140) = M1(2,76); M2(50,142) = M1(2,77); M2(50,143) = M1(2,78); M2(50,145) = M1(2,79); M2(50,148) = M1(2,80); M2(50,149) = M1(2,81); M2(50,151) = M1(2,82); M2(50,154) = M1(2,83); 
M2(51,41) = M1(3,3); M2(51,55) = M1(3,15); M2(51,56) = M1(3,16); M2(51,57) = M1(3,17); M2(51,59) = M1(3,18); M2(51,60) = M1(3,19); M2(51,61) = M1(3,20); M2(51,62) = M1(3,21); M2(51,64) = M1(3,22); M2(51,65) = M1(3,23); M2(51,66) = M1(3,24); M2(51,68) = M1(3,25); M2(51,69) = M1(3,26); M2(51,71) = M1(3,27); M2(51,73) = M1(3,28); M2(51,74) = M1(3,29); M2(51,75) = M1(3,30); M2(51,76) = M1(3,31); M2(51,77) = M1(3,32); M2(51,78) = M1(3,33); M2(51,80) = M1(3,34); M2(51,81) = M1(3,35); M2(51,82) = M1(3,36); M2(51,83) = M1(3,37); M2(51,84) = M1(3,38); M2(51,86) = M1(3,39); M2(51,87) = M1(3,40); M2(51,88) = M1(3,41); M2(51,89) = M1(3,42); M2(51,91) = M1(3,43); M2(51,92) = M1(3,44); M2(51,94) = M1(3,45); M2(51,96) = M1(3,46); M2(51,97) = M1(3,47); M2(51,99) = M1(3,48); M2(51,102) = M1(3,49); M2(51,103) = M1(3,50); M2(51,104) = M1(3,51); M2(51,105) = M1(3,52); M2(51,106) = M1(3,53); M2(51,108) = M1(3,54); M2(51,109) = M1(3,55); M2(51,110) = M1(3,56); M2(51,111) = M1(3,57); M2(51,113) = M1(3,58); M2(51,114) = M1(3,59); M2(51,115) = M1(3,60); M2(51,117) = M1(3,61); M2(51,118) = M1(3,62); M2(51,120) = M1(3,63); M2(51,123) = M1(3,64); M2(51,124) = M1(3,65); M2(51,125) = M1(3,66); M2(51,126) = M1(3,67); M2(51,128) = M1(3,68); M2(51,129) = M1(3,69); M2(51,130) = M1(3,70); M2(51,132) = M1(3,71); M2(51,133) = M1(3,72); M2(51,135) = M1(3,73); M2(51,138) = M1(3,74); M2(51,139) = M1(3,75); M2(51,140) = M1(3,76); M2(51,142) = M1(3,77); M2(51,143) = M1(3,78); M2(51,145) = M1(3,79); M2(51,148) = M1(3,80); M2(51,149) = M1(3,81); M2(51,151) = M1(3,82); M2(51,154) = M1(3,83); 
M2(52,42) = M1(4,4); M2(52,55) = M1(4,15); M2(52,56) = M1(4,16); M2(52,57) = M1(4,17); M2(52,59) = M1(4,18); M2(52,60) = M1(4,19); M2(52,61) = M1(4,20); M2(52,62) = M1(4,21); M2(52,64) = M1(4,22); M2(52,65) = M1(4,23); M2(52,66) = M1(4,24); M2(52,68) = M1(4,25); M2(52,69) = M1(4,26); M2(52,71) = M1(4,27); M2(52,73) = M1(4,28); M2(52,74) = M1(4,29); M2(52,75) = M1(4,30); M2(52,76) = M1(4,31); M2(52,77) = M1(4,32); M2(52,78) = M1(4,33); M2(52,80) = M1(4,34); M2(52,81) = M1(4,35); M2(52,82) = M1(4,36); M2(52,83) = M1(4,37); M2(52,84) = M1(4,38); M2(52,86) = M1(4,39); M2(52,87) = M1(4,40); M2(52,88) = M1(4,41); M2(52,89) = M1(4,42); M2(52,91) = M1(4,43); M2(52,92) = M1(4,44); M2(52,94) = M1(4,45); M2(52,96) = M1(4,46); M2(52,97) = M1(4,47); M2(52,99) = M1(4,48); M2(52,102) = M1(4,49); M2(52,103) = M1(4,50); M2(52,104) = M1(4,51); M2(52,105) = M1(4,52); M2(52,106) = M1(4,53); M2(52,108) = M1(4,54); M2(52,109) = M1(4,55); M2(52,110) = M1(4,56); M2(52,111) = M1(4,57); M2(52,113) = M1(4,58); M2(52,114) = M1(4,59); M2(52,115) = M1(4,60); M2(52,117) = M1(4,61); M2(52,118) = M1(4,62); M2(52,120) = M1(4,63); M2(52,123) = M1(4,64); M2(52,124) = M1(4,65); M2(52,125) = M1(4,66); M2(52,126) = M1(4,67); M2(52,128) = M1(4,68); M2(52,129) = M1(4,69); M2(52,130) = M1(4,70); M2(52,132) = M1(4,71); M2(52,133) = M1(4,72); M2(52,135) = M1(4,73); M2(52,138) = M1(4,74); M2(52,139) = M1(4,75); M2(52,140) = M1(4,76); M2(52,142) = M1(4,77); M2(52,143) = M1(4,78); M2(52,145) = M1(4,79); M2(52,148) = M1(4,80); M2(52,149) = M1(4,81); M2(52,151) = M1(4,82); M2(52,154) = M1(4,83); 
M2(53,43) = M1(5,5); M2(53,55) = M1(5,15); M2(53,56) = M1(5,16); M2(53,57) = M1(5,17); M2(53,59) = M1(5,18); M2(53,60) = M1(5,19); M2(53,61) = M1(5,20); M2(53,62) = M1(5,21); M2(53,64) = M1(5,22); M2(53,65) = M1(5,23); M2(53,66) = M1(5,24); M2(53,68) = M1(5,25); M2(53,69) = M1(5,26); M2(53,71) = M1(5,27); M2(53,73) = M1(5,28); M2(53,74) = M1(5,29); M2(53,75) = M1(5,30); M2(53,76) = M1(5,31); M2(53,77) = M1(5,32); M2(53,78) = M1(5,33); M2(53,80) = M1(5,34); M2(53,81) = M1(5,35); M2(53,82) = M1(5,36); M2(53,83) = M1(5,37); M2(53,84) = M1(5,38); M2(53,86) = M1(5,39); M2(53,87) = M1(5,40); M2(53,88) = M1(5,41); M2(53,89) = M1(5,42); M2(53,91) = M1(5,43); M2(53,92) = M1(5,44); M2(53,94) = M1(5,45); M2(53,96) = M1(5,46); M2(53,97) = M1(5,47); M2(53,99) = M1(5,48); M2(53,102) = M1(5,49); M2(53,103) = M1(5,50); M2(53,104) = M1(5,51); M2(53,105) = M1(5,52); M2(53,106) = M1(5,53); M2(53,108) = M1(5,54); M2(53,109) = M1(5,55); M2(53,110) = M1(5,56); M2(53,111) = M1(5,57); M2(53,113) = M1(5,58); M2(53,114) = M1(5,59); M2(53,115) = M1(5,60); M2(53,117) = M1(5,61); M2(53,118) = M1(5,62); M2(53,120) = M1(5,63); M2(53,123) = M1(5,64); M2(53,124) = M1(5,65); M2(53,125) = M1(5,66); M2(53,126) = M1(5,67); M2(53,128) = M1(5,68); M2(53,129) = M1(5,69); M2(53,130) = M1(5,70); M2(53,132) = M1(5,71); M2(53,133) = M1(5,72); M2(53,135) = M1(5,73); M2(53,138) = M1(5,74); M2(53,139) = M1(5,75); M2(53,140) = M1(5,76); M2(53,142) = M1(5,77); M2(53,143) = M1(5,78); M2(53,145) = M1(5,79); M2(53,148) = M1(5,80); M2(53,149) = M1(5,81); M2(53,151) = M1(5,82); M2(53,154) = M1(5,83); 
M2(54,44) = M1(6,6); M2(54,55) = M1(6,15); M2(54,56) = M1(6,16); M2(54,57) = M1(6,17); M2(54,59) = M1(6,18); M2(54,60) = M1(6,19); M2(54,61) = M1(6,20); M2(54,62) = M1(6,21); M2(54,64) = M1(6,22); M2(54,65) = M1(6,23); M2(54,66) = M1(6,24); M2(54,68) = M1(6,25); M2(54,69) = M1(6,26); M2(54,71) = M1(6,27); M2(54,73) = M1(6,28); M2(54,74) = M1(6,29); M2(54,75) = M1(6,30); M2(54,76) = M1(6,31); M2(54,77) = M1(6,32); M2(54,78) = M1(6,33); M2(54,80) = M1(6,34); M2(54,81) = M1(6,35); M2(54,82) = M1(6,36); M2(54,83) = M1(6,37); M2(54,84) = M1(6,38); M2(54,86) = M1(6,39); M2(54,87) = M1(6,40); M2(54,88) = M1(6,41); M2(54,89) = M1(6,42); M2(54,91) = M1(6,43); M2(54,92) = M1(6,44); M2(54,94) = M1(6,45); M2(54,96) = M1(6,46); M2(54,97) = M1(6,47); M2(54,99) = M1(6,48); M2(54,102) = M1(6,49); M2(54,103) = M1(6,50); M2(54,104) = M1(6,51); M2(54,105) = M1(6,52); M2(54,106) = M1(6,53); M2(54,108) = M1(6,54); M2(54,109) = M1(6,55); M2(54,110) = M1(6,56); M2(54,111) = M1(6,57); M2(54,113) = M1(6,58); M2(54,114) = M1(6,59); M2(54,115) = M1(6,60); M2(54,117) = M1(6,61); M2(54,118) = M1(6,62); M2(54,120) = M1(6,63); M2(54,123) = M1(6,64); M2(54,124) = M1(6,65); M2(54,125) = M1(6,66); M2(54,126) = M1(6,67); M2(54,128) = M1(6,68); M2(54,129) = M1(6,69); M2(54,130) = M1(6,70); M2(54,132) = M1(6,71); M2(54,133) = M1(6,72); M2(54,135) = M1(6,73); M2(54,138) = M1(6,74); M2(54,139) = M1(6,75); M2(54,140) = M1(6,76); M2(54,142) = M1(6,77); M2(54,143) = M1(6,78); M2(54,145) = M1(6,79); M2(54,148) = M1(6,80); M2(54,149) = M1(6,81); M2(54,151) = M1(6,82); M2(54,154) = M1(6,83); 
M2(55,46) = M1(7,7); M2(55,55) = M1(7,15); M2(55,56) = M1(7,16); M2(55,57) = M1(7,17); M2(55,59) = M1(7,18); M2(55,60) = M1(7,19); M2(55,61) = M1(7,20); M2(55,62) = M1(7,21); M2(55,64) = M1(7,22); M2(55,65) = M1(7,23); M2(55,66) = M1(7,24); M2(55,68) = M1(7,25); M2(55,69) = M1(7,26); M2(55,71) = M1(7,27); M2(55,73) = M1(7,28); M2(55,74) = M1(7,29); M2(55,75) = M1(7,30); M2(55,76) = M1(7,31); M2(55,77) = M1(7,32); M2(55,78) = M1(7,33); M2(55,80) = M1(7,34); M2(55,81) = M1(7,35); M2(55,82) = M1(7,36); M2(55,83) = M1(7,37); M2(55,84) = M1(7,38); M2(55,86) = M1(7,39); M2(55,87) = M1(7,40); M2(55,88) = M1(7,41); M2(55,89) = M1(7,42); M2(55,91) = M1(7,43); M2(55,92) = M1(7,44); M2(55,94) = M1(7,45); M2(55,96) = M1(7,46); M2(55,97) = M1(7,47); M2(55,99) = M1(7,48); M2(55,102) = M1(7,49); M2(55,103) = M1(7,50); M2(55,104) = M1(7,51); M2(55,105) = M1(7,52); M2(55,106) = M1(7,53); M2(55,108) = M1(7,54); M2(55,109) = M1(7,55); M2(55,110) = M1(7,56); M2(55,111) = M1(7,57); M2(55,113) = M1(7,58); M2(55,114) = M1(7,59); M2(55,115) = M1(7,60); M2(55,117) = M1(7,61); M2(55,118) = M1(7,62); M2(55,120) = M1(7,63); M2(55,123) = M1(7,64); M2(55,124) = M1(7,65); M2(55,125) = M1(7,66); M2(55,126) = M1(7,67); M2(55,128) = M1(7,68); M2(55,129) = M1(7,69); M2(55,130) = M1(7,70); M2(55,132) = M1(7,71); M2(55,133) = M1(7,72); M2(55,135) = M1(7,73); M2(55,138) = M1(7,74); M2(55,139) = M1(7,75); M2(55,140) = M1(7,76); M2(55,142) = M1(7,77); M2(55,143) = M1(7,78); M2(55,145) = M1(7,79); M2(55,148) = M1(7,80); M2(55,149) = M1(7,81); M2(55,151) = M1(7,82); M2(55,154) = M1(7,83); 
M2(56,47) = M1(8,8); M2(56,55) = M1(8,15); M2(56,56) = M1(8,16); M2(56,57) = M1(8,17); M2(56,59) = M1(8,18); M2(56,60) = M1(8,19); M2(56,61) = M1(8,20); M2(56,62) = M1(8,21); M2(56,64) = M1(8,22); M2(56,65) = M1(8,23); M2(56,66) = M1(8,24); M2(56,68) = M1(8,25); M2(56,69) = M1(8,26); M2(56,71) = M1(8,27); M2(56,73) = M1(8,28); M2(56,74) = M1(8,29); M2(56,75) = M1(8,30); M2(56,76) = M1(8,31); M2(56,77) = M1(8,32); M2(56,78) = M1(8,33); M2(56,80) = M1(8,34); M2(56,81) = M1(8,35); M2(56,82) = M1(8,36); M2(56,83) = M1(8,37); M2(56,84) = M1(8,38); M2(56,86) = M1(8,39); M2(56,87) = M1(8,40); M2(56,88) = M1(8,41); M2(56,89) = M1(8,42); M2(56,91) = M1(8,43); M2(56,92) = M1(8,44); M2(56,94) = M1(8,45); M2(56,96) = M1(8,46); M2(56,97) = M1(8,47); M2(56,99) = M1(8,48); M2(56,102) = M1(8,49); M2(56,103) = M1(8,50); M2(56,104) = M1(8,51); M2(56,105) = M1(8,52); M2(56,106) = M1(8,53); M2(56,108) = M1(8,54); M2(56,109) = M1(8,55); M2(56,110) = M1(8,56); M2(56,111) = M1(8,57); M2(56,113) = M1(8,58); M2(56,114) = M1(8,59); M2(56,115) = M1(8,60); M2(56,117) = M1(8,61); M2(56,118) = M1(8,62); M2(56,120) = M1(8,63); M2(56,123) = M1(8,64); M2(56,124) = M1(8,65); M2(56,125) = M1(8,66); M2(56,126) = M1(8,67); M2(56,128) = M1(8,68); M2(56,129) = M1(8,69); M2(56,130) = M1(8,70); M2(56,132) = M1(8,71); M2(56,133) = M1(8,72); M2(56,135) = M1(8,73); M2(56,138) = M1(8,74); M2(56,139) = M1(8,75); M2(56,140) = M1(8,76); M2(56,142) = M1(8,77); M2(56,143) = M1(8,78); M2(56,145) = M1(8,79); M2(56,148) = M1(8,80); M2(56,149) = M1(8,81); M2(56,151) = M1(8,82); M2(56,154) = M1(8,83); 
M2(57,48) = M1(9,9); M2(57,55) = M1(9,15); M2(57,56) = M1(9,16); M2(57,57) = M1(9,17); M2(57,59) = M1(9,18); M2(57,60) = M1(9,19); M2(57,61) = M1(9,20); M2(57,62) = M1(9,21); M2(57,64) = M1(9,22); M2(57,65) = M1(9,23); M2(57,66) = M1(9,24); M2(57,68) = M1(9,25); M2(57,69) = M1(9,26); M2(57,71) = M1(9,27); M2(57,73) = M1(9,28); M2(57,74) = M1(9,29); M2(57,75) = M1(9,30); M2(57,76) = M1(9,31); M2(57,77) = M1(9,32); M2(57,78) = M1(9,33); M2(57,80) = M1(9,34); M2(57,81) = M1(9,35); M2(57,82) = M1(9,36); M2(57,83) = M1(9,37); M2(57,84) = M1(9,38); M2(57,86) = M1(9,39); M2(57,87) = M1(9,40); M2(57,88) = M1(9,41); M2(57,89) = M1(9,42); M2(57,91) = M1(9,43); M2(57,92) = M1(9,44); M2(57,94) = M1(9,45); M2(57,96) = M1(9,46); M2(57,97) = M1(9,47); M2(57,99) = M1(9,48); M2(57,102) = M1(9,49); M2(57,103) = M1(9,50); M2(57,104) = M1(9,51); M2(57,105) = M1(9,52); M2(57,106) = M1(9,53); M2(57,108) = M1(9,54); M2(57,109) = M1(9,55); M2(57,110) = M1(9,56); M2(57,111) = M1(9,57); M2(57,113) = M1(9,58); M2(57,114) = M1(9,59); M2(57,115) = M1(9,60); M2(57,117) = M1(9,61); M2(57,118) = M1(9,62); M2(57,120) = M1(9,63); M2(57,123) = M1(9,64); M2(57,124) = M1(9,65); M2(57,125) = M1(9,66); M2(57,126) = M1(9,67); M2(57,128) = M1(9,68); M2(57,129) = M1(9,69); M2(57,130) = M1(9,70); M2(57,132) = M1(9,71); M2(57,133) = M1(9,72); M2(57,135) = M1(9,73); M2(57,138) = M1(9,74); M2(57,139) = M1(9,75); M2(57,140) = M1(9,76); M2(57,142) = M1(9,77); M2(57,143) = M1(9,78); M2(57,145) = M1(9,79); M2(57,148) = M1(9,80); M2(57,149) = M1(9,81); M2(57,151) = M1(9,82); M2(57,154) = M1(9,83); 
M2(58,49) = M1(10,10); M2(58,55) = M1(10,15); M2(58,56) = M1(10,16); M2(58,57) = M1(10,17); M2(58,59) = M1(10,18); M2(58,60) = M1(10,19); M2(58,61) = M1(10,20); M2(58,62) = M1(10,21); M2(58,64) = M1(10,22); M2(58,65) = M1(10,23); M2(58,66) = M1(10,24); M2(58,68) = M1(10,25); M2(58,69) = M1(10,26); M2(58,71) = M1(10,27); M2(58,73) = M1(10,28); M2(58,74) = M1(10,29); M2(58,75) = M1(10,30); M2(58,76) = M1(10,31); M2(58,77) = M1(10,32); M2(58,78) = M1(10,33); M2(58,80) = M1(10,34); M2(58,81) = M1(10,35); M2(58,82) = M1(10,36); M2(58,83) = M1(10,37); M2(58,84) = M1(10,38); M2(58,86) = M1(10,39); M2(58,87) = M1(10,40); M2(58,88) = M1(10,41); M2(58,89) = M1(10,42); M2(58,91) = M1(10,43); M2(58,92) = M1(10,44); M2(58,94) = M1(10,45); M2(58,96) = M1(10,46); M2(58,97) = M1(10,47); M2(58,99) = M1(10,48); M2(58,102) = M1(10,49); M2(58,103) = M1(10,50); M2(58,104) = M1(10,51); M2(58,105) = M1(10,52); M2(58,106) = M1(10,53); M2(58,108) = M1(10,54); M2(58,109) = M1(10,55); M2(58,110) = M1(10,56); M2(58,111) = M1(10,57); M2(58,113) = M1(10,58); M2(58,114) = M1(10,59); M2(58,115) = M1(10,60); M2(58,117) = M1(10,61); M2(58,118) = M1(10,62); M2(58,120) = M1(10,63); M2(58,123) = M1(10,64); M2(58,124) = M1(10,65); M2(58,125) = M1(10,66); M2(58,126) = M1(10,67); M2(58,128) = M1(10,68); M2(58,129) = M1(10,69); M2(58,130) = M1(10,70); M2(58,132) = M1(10,71); M2(58,133) = M1(10,72); M2(58,135) = M1(10,73); M2(58,138) = M1(10,74); M2(58,139) = M1(10,75); M2(58,140) = M1(10,76); M2(58,142) = M1(10,77); M2(58,143) = M1(10,78); M2(58,145) = M1(10,79); M2(58,148) = M1(10,80); M2(58,149) = M1(10,81); M2(58,151) = M1(10,82); M2(58,154) = M1(10,83); 
M2(59,50) = M1(11,11); M2(59,55) = M1(11,15); M2(59,56) = M1(11,16); M2(59,57) = M1(11,17); M2(59,59) = M1(11,18); M2(59,60) = M1(11,19); M2(59,61) = M1(11,20); M2(59,62) = M1(11,21); M2(59,64) = M1(11,22); M2(59,65) = M1(11,23); M2(59,66) = M1(11,24); M2(59,68) = M1(11,25); M2(59,69) = M1(11,26); M2(59,71) = M1(11,27); M2(59,73) = M1(11,28); M2(59,74) = M1(11,29); M2(59,75) = M1(11,30); M2(59,76) = M1(11,31); M2(59,77) = M1(11,32); M2(59,78) = M1(11,33); M2(59,80) = M1(11,34); M2(59,81) = M1(11,35); M2(59,82) = M1(11,36); M2(59,83) = M1(11,37); M2(59,84) = M1(11,38); M2(59,86) = M1(11,39); M2(59,87) = M1(11,40); M2(59,88) = M1(11,41); M2(59,89) = M1(11,42); M2(59,91) = M1(11,43); M2(59,92) = M1(11,44); M2(59,94) = M1(11,45); M2(59,96) = M1(11,46); M2(59,97) = M1(11,47); M2(59,99) = M1(11,48); M2(59,102) = M1(11,49); M2(59,103) = M1(11,50); M2(59,104) = M1(11,51); M2(59,105) = M1(11,52); M2(59,106) = M1(11,53); M2(59,108) = M1(11,54); M2(59,109) = M1(11,55); M2(59,110) = M1(11,56); M2(59,111) = M1(11,57); M2(59,113) = M1(11,58); M2(59,114) = M1(11,59); M2(59,115) = M1(11,60); M2(59,117) = M1(11,61); M2(59,118) = M1(11,62); M2(59,120) = M1(11,63); M2(59,123) = M1(11,64); M2(59,124) = M1(11,65); M2(59,125) = M1(11,66); M2(59,126) = M1(11,67); M2(59,128) = M1(11,68); M2(59,129) = M1(11,69); M2(59,130) = M1(11,70); M2(59,132) = M1(11,71); M2(59,133) = M1(11,72); M2(59,135) = M1(11,73); M2(59,138) = M1(11,74); M2(59,139) = M1(11,75); M2(59,140) = M1(11,76); M2(59,142) = M1(11,77); M2(59,143) = M1(11,78); M2(59,145) = M1(11,79); M2(59,148) = M1(11,80); M2(59,149) = M1(11,81); M2(59,151) = M1(11,82); M2(59,154) = M1(11,83); 
M2(60,51) = M1(12,12); M2(60,55) = M1(12,15); M2(60,56) = M1(12,16); M2(60,57) = M1(12,17); M2(60,59) = M1(12,18); M2(60,60) = M1(12,19); M2(60,61) = M1(12,20); M2(60,62) = M1(12,21); M2(60,64) = M1(12,22); M2(60,65) = M1(12,23); M2(60,66) = M1(12,24); M2(60,68) = M1(12,25); M2(60,69) = M1(12,26); M2(60,71) = M1(12,27); M2(60,73) = M1(12,28); M2(60,74) = M1(12,29); M2(60,75) = M1(12,30); M2(60,76) = M1(12,31); M2(60,77) = M1(12,32); M2(60,78) = M1(12,33); M2(60,80) = M1(12,34); M2(60,81) = M1(12,35); M2(60,82) = M1(12,36); M2(60,83) = M1(12,37); M2(60,84) = M1(12,38); M2(60,86) = M1(12,39); M2(60,87) = M1(12,40); M2(60,88) = M1(12,41); M2(60,89) = M1(12,42); M2(60,91) = M1(12,43); M2(60,92) = M1(12,44); M2(60,94) = M1(12,45); M2(60,96) = M1(12,46); M2(60,97) = M1(12,47); M2(60,99) = M1(12,48); M2(60,102) = M1(12,49); M2(60,103) = M1(12,50); M2(60,104) = M1(12,51); M2(60,105) = M1(12,52); M2(60,106) = M1(12,53); M2(60,108) = M1(12,54); M2(60,109) = M1(12,55); M2(60,110) = M1(12,56); M2(60,111) = M1(12,57); M2(60,113) = M1(12,58); M2(60,114) = M1(12,59); M2(60,115) = M1(12,60); M2(60,117) = M1(12,61); M2(60,118) = M1(12,62); M2(60,120) = M1(12,63); M2(60,123) = M1(12,64); M2(60,124) = M1(12,65); M2(60,125) = M1(12,66); M2(60,126) = M1(12,67); M2(60,128) = M1(12,68); M2(60,129) = M1(12,69); M2(60,130) = M1(12,70); M2(60,132) = M1(12,71); M2(60,133) = M1(12,72); M2(60,135) = M1(12,73); M2(60,138) = M1(12,74); M2(60,139) = M1(12,75); M2(60,140) = M1(12,76); M2(60,142) = M1(12,77); M2(60,143) = M1(12,78); M2(60,145) = M1(12,79); M2(60,148) = M1(12,80); M2(60,149) = M1(12,81); M2(60,151) = M1(12,82); M2(60,154) = M1(12,83); 
M2(61,53) = M1(13,13); M2(61,55) = M1(13,15); M2(61,56) = M1(13,16); M2(61,57) = M1(13,17); M2(61,59) = M1(13,18); M2(61,60) = M1(13,19); M2(61,61) = M1(13,20); M2(61,62) = M1(13,21); M2(61,64) = M1(13,22); M2(61,65) = M1(13,23); M2(61,66) = M1(13,24); M2(61,68) = M1(13,25); M2(61,69) = M1(13,26); M2(61,71) = M1(13,27); M2(61,73) = M1(13,28); M2(61,74) = M1(13,29); M2(61,75) = M1(13,30); M2(61,76) = M1(13,31); M2(61,77) = M1(13,32); M2(61,78) = M1(13,33); M2(61,80) = M1(13,34); M2(61,81) = M1(13,35); M2(61,82) = M1(13,36); M2(61,83) = M1(13,37); M2(61,84) = M1(13,38); M2(61,86) = M1(13,39); M2(61,87) = M1(13,40); M2(61,88) = M1(13,41); M2(61,89) = M1(13,42); M2(61,91) = M1(13,43); M2(61,92) = M1(13,44); M2(61,94) = M1(13,45); M2(61,96) = M1(13,46); M2(61,97) = M1(13,47); M2(61,99) = M1(13,48); M2(61,102) = M1(13,49); M2(61,103) = M1(13,50); M2(61,104) = M1(13,51); M2(61,105) = M1(13,52); M2(61,106) = M1(13,53); M2(61,108) = M1(13,54); M2(61,109) = M1(13,55); M2(61,110) = M1(13,56); M2(61,111) = M1(13,57); M2(61,113) = M1(13,58); M2(61,114) = M1(13,59); M2(61,115) = M1(13,60); M2(61,117) = M1(13,61); M2(61,118) = M1(13,62); M2(61,120) = M1(13,63); M2(61,123) = M1(13,64); M2(61,124) = M1(13,65); M2(61,125) = M1(13,66); M2(61,126) = M1(13,67); M2(61,128) = M1(13,68); M2(61,129) = M1(13,69); M2(61,130) = M1(13,70); M2(61,132) = M1(13,71); M2(61,133) = M1(13,72); M2(61,135) = M1(13,73); M2(61,138) = M1(13,74); M2(61,139) = M1(13,75); M2(61,140) = M1(13,76); M2(61,142) = M1(13,77); M2(61,143) = M1(13,78); M2(61,145) = M1(13,79); M2(61,148) = M1(13,80); M2(61,149) = M1(13,81); M2(61,151) = M1(13,82); M2(61,154) = M1(13,83); 
M2(62,54) = M1(14,14); M2(62,55) = M1(14,15); M2(62,56) = M1(14,16); M2(62,57) = M1(14,17); M2(62,59) = M1(14,18); M2(62,60) = M1(14,19); M2(62,61) = M1(14,20); M2(62,62) = M1(14,21); M2(62,64) = M1(14,22); M2(62,65) = M1(14,23); M2(62,66) = M1(14,24); M2(62,68) = M1(14,25); M2(62,69) = M1(14,26); M2(62,71) = M1(14,27); M2(62,73) = M1(14,28); M2(62,74) = M1(14,29); M2(62,75) = M1(14,30); M2(62,76) = M1(14,31); M2(62,77) = M1(14,32); M2(62,78) = M1(14,33); M2(62,80) = M1(14,34); M2(62,81) = M1(14,35); M2(62,82) = M1(14,36); M2(62,83) = M1(14,37); M2(62,84) = M1(14,38); M2(62,86) = M1(14,39); M2(62,87) = M1(14,40); M2(62,88) = M1(14,41); M2(62,89) = M1(14,42); M2(62,91) = M1(14,43); M2(62,92) = M1(14,44); M2(62,94) = M1(14,45); M2(62,96) = M1(14,46); M2(62,97) = M1(14,47); M2(62,99) = M1(14,48); M2(62,102) = M1(14,49); M2(62,103) = M1(14,50); M2(62,104) = M1(14,51); M2(62,105) = M1(14,52); M2(62,106) = M1(14,53); M2(62,108) = M1(14,54); M2(62,109) = M1(14,55); M2(62,110) = M1(14,56); M2(62,111) = M1(14,57); M2(62,113) = M1(14,58); M2(62,114) = M1(14,59); M2(62,115) = M1(14,60); M2(62,117) = M1(14,61); M2(62,118) = M1(14,62); M2(62,120) = M1(14,63); M2(62,123) = M1(14,64); M2(62,124) = M1(14,65); M2(62,125) = M1(14,66); M2(62,126) = M1(14,67); M2(62,128) = M1(14,68); M2(62,129) = M1(14,69); M2(62,130) = M1(14,70); M2(62,132) = M1(14,71); M2(62,133) = M1(14,72); M2(62,135) = M1(14,73); M2(62,138) = M1(14,74); M2(62,139) = M1(14,75); M2(62,140) = M1(14,76); M2(62,142) = M1(14,77); M2(62,143) = M1(14,78); M2(62,145) = M1(14,79); M2(62,148) = M1(14,80); M2(62,149) = M1(14,81); M2(62,151) = M1(14,82); M2(62,154) = M1(14,83); 
M2(63,37) = M1(0,0); M2(63,54) = M1(0,15); M2(63,55) = M1(0,16); M2(63,56) = M1(0,17); M2(63,58) = M1(0,18); M2(63,59) = M1(0,19); M2(63,60) = M1(0,20); M2(63,61) = M1(0,21); M2(63,63) = M1(0,22); M2(63,64) = M1(0,23); M2(63,65) = M1(0,24); M2(63,67) = M1(0,25); M2(63,68) = M1(0,26); M2(63,70) = M1(0,27); M2(63,72) = M1(0,28); M2(63,73) = M1(0,29); M2(63,74) = M1(0,30); M2(63,75) = M1(0,31); M2(63,76) = M1(0,32); M2(63,77) = M1(0,33); M2(63,79) = M1(0,34); M2(63,80) = M1(0,35); M2(63,81) = M1(0,36); M2(63,82) = M1(0,37); M2(63,83) = M1(0,38); M2(63,85) = M1(0,39); M2(63,86) = M1(0,40); M2(63,87) = M1(0,41); M2(63,88) = M1(0,42); M2(63,90) = M1(0,43); M2(63,91) = M1(0,44); M2(63,92) = M1(0,45); M2(63,95) = M1(0,46); M2(63,96) = M1(0,47); M2(63,98) = M1(0,48); M2(63,101) = M1(0,49); M2(63,102) = M1(0,50); M2(63,103) = M1(0,51); M2(63,104) = M1(0,52); M2(63,105) = M1(0,53); M2(63,107) = M1(0,54); M2(63,108) = M1(0,55); M2(63,109) = M1(0,56); M2(63,110) = M1(0,57); M2(63,112) = M1(0,58); M2(63,113) = M1(0,59); M2(63,114) = M1(0,60); M2(63,116) = M1(0,61); M2(63,117) = M1(0,62); M2(63,119) = M1(0,63); M2(63,122) = M1(0,64); M2(63,123) = M1(0,65); M2(63,124) = M1(0,66); M2(63,125) = M1(0,67); M2(63,127) = M1(0,68); M2(63,128) = M1(0,69); M2(63,129) = M1(0,70); M2(63,131) = M1(0,71); M2(63,132) = M1(0,72); M2(63,134) = M1(0,73); M2(63,137) = M1(0,74); M2(63,138) = M1(0,75); M2(63,139) = M1(0,76); M2(63,141) = M1(0,77); M2(63,142) = M1(0,78); M2(63,144) = M1(0,79); M2(63,147) = M1(0,80); M2(63,148) = M1(0,81); M2(63,150) = M1(0,82); M2(63,153) = M1(0,83); 
M2(64,38) = M1(1,1); M2(64,54) = M1(1,15); M2(64,55) = M1(1,16); M2(64,56) = M1(1,17); M2(64,58) = M1(1,18); M2(64,59) = M1(1,19); M2(64,60) = M1(1,20); M2(64,61) = M1(1,21); M2(64,63) = M1(1,22); M2(64,64) = M1(1,23); M2(64,65) = M1(1,24); M2(64,67) = M1(1,25); M2(64,68) = M1(1,26); M2(64,70) = M1(1,27); M2(64,72) = M1(1,28); M2(64,73) = M1(1,29); M2(64,74) = M1(1,30); M2(64,75) = M1(1,31); M2(64,76) = M1(1,32); M2(64,77) = M1(1,33); M2(64,79) = M1(1,34); M2(64,80) = M1(1,35); M2(64,81) = M1(1,36); M2(64,82) = M1(1,37); M2(64,83) = M1(1,38); M2(64,85) = M1(1,39); M2(64,86) = M1(1,40); M2(64,87) = M1(1,41); M2(64,88) = M1(1,42); M2(64,90) = M1(1,43); M2(64,91) = M1(1,44); M2(64,92) = M1(1,45); M2(64,95) = M1(1,46); M2(64,96) = M1(1,47); M2(64,98) = M1(1,48); M2(64,101) = M1(1,49); M2(64,102) = M1(1,50); M2(64,103) = M1(1,51); M2(64,104) = M1(1,52); M2(64,105) = M1(1,53); M2(64,107) = M1(1,54); M2(64,108) = M1(1,55); M2(64,109) = M1(1,56); M2(64,110) = M1(1,57); M2(64,112) = M1(1,58); M2(64,113) = M1(1,59); M2(64,114) = M1(1,60); M2(64,116) = M1(1,61); M2(64,117) = M1(1,62); M2(64,119) = M1(1,63); M2(64,122) = M1(1,64); M2(64,123) = M1(1,65); M2(64,124) = M1(1,66); M2(64,125) = M1(1,67); M2(64,127) = M1(1,68); M2(64,128) = M1(1,69); M2(64,129) = M1(1,70); M2(64,131) = M1(1,71); M2(64,132) = M1(1,72); M2(64,134) = M1(1,73); M2(64,137) = M1(1,74); M2(64,138) = M1(1,75); M2(64,139) = M1(1,76); M2(64,141) = M1(1,77); M2(64,142) = M1(1,78); M2(64,144) = M1(1,79); M2(64,147) = M1(1,80); M2(64,148) = M1(1,81); M2(64,150) = M1(1,82); M2(64,153) = M1(1,83); 
M2(65,39) = M1(2,2); M2(65,54) = M1(2,15); M2(65,55) = M1(2,16); M2(65,56) = M1(2,17); M2(65,58) = M1(2,18); M2(65,59) = M1(2,19); M2(65,60) = M1(2,20); M2(65,61) = M1(2,21); M2(65,63) = M1(2,22); M2(65,64) = M1(2,23); M2(65,65) = M1(2,24); M2(65,67) = M1(2,25); M2(65,68) = M1(2,26); M2(65,70) = M1(2,27); M2(65,72) = M1(2,28); M2(65,73) = M1(2,29); M2(65,74) = M1(2,30); M2(65,75) = M1(2,31); M2(65,76) = M1(2,32); M2(65,77) = M1(2,33); M2(65,79) = M1(2,34); M2(65,80) = M1(2,35); M2(65,81) = M1(2,36); M2(65,82) = M1(2,37); M2(65,83) = M1(2,38); M2(65,85) = M1(2,39); M2(65,86) = M1(2,40); M2(65,87) = M1(2,41); M2(65,88) = M1(2,42); M2(65,90) = M1(2,43); M2(65,91) = M1(2,44); M2(65,92) = M1(2,45); M2(65,95) = M1(2,46); M2(65,96) = M1(2,47); M2(65,98) = M1(2,48); M2(65,101) = M1(2,49); M2(65,102) = M1(2,50); M2(65,103) = M1(2,51); M2(65,104) = M1(2,52); M2(65,105) = M1(2,53); M2(65,107) = M1(2,54); M2(65,108) = M1(2,55); M2(65,109) = M1(2,56); M2(65,110) = M1(2,57); M2(65,112) = M1(2,58); M2(65,113) = M1(2,59); M2(65,114) = M1(2,60); M2(65,116) = M1(2,61); M2(65,117) = M1(2,62); M2(65,119) = M1(2,63); M2(65,122) = M1(2,64); M2(65,123) = M1(2,65); M2(65,124) = M1(2,66); M2(65,125) = M1(2,67); M2(65,127) = M1(2,68); M2(65,128) = M1(2,69); M2(65,129) = M1(2,70); M2(65,131) = M1(2,71); M2(65,132) = M1(2,72); M2(65,134) = M1(2,73); M2(65,137) = M1(2,74); M2(65,138) = M1(2,75); M2(65,139) = M1(2,76); M2(65,141) = M1(2,77); M2(65,142) = M1(2,78); M2(65,144) = M1(2,79); M2(65,147) = M1(2,80); M2(65,148) = M1(2,81); M2(65,150) = M1(2,82); M2(65,153) = M1(2,83); 
M2(66,40) = M1(3,3); M2(66,54) = M1(3,15); M2(66,55) = M1(3,16); M2(66,56) = M1(3,17); M2(66,58) = M1(3,18); M2(66,59) = M1(3,19); M2(66,60) = M1(3,20); M2(66,61) = M1(3,21); M2(66,63) = M1(3,22); M2(66,64) = M1(3,23); M2(66,65) = M1(3,24); M2(66,67) = M1(3,25); M2(66,68) = M1(3,26); M2(66,70) = M1(3,27); M2(66,72) = M1(3,28); M2(66,73) = M1(3,29); M2(66,74) = M1(3,30); M2(66,75) = M1(3,31); M2(66,76) = M1(3,32); M2(66,77) = M1(3,33); M2(66,79) = M1(3,34); M2(66,80) = M1(3,35); M2(66,81) = M1(3,36); M2(66,82) = M1(3,37); M2(66,83) = M1(3,38); M2(66,85) = M1(3,39); M2(66,86) = M1(3,40); M2(66,87) = M1(3,41); M2(66,88) = M1(3,42); M2(66,90) = M1(3,43); M2(66,91) = M1(3,44); M2(66,92) = M1(3,45); M2(66,95) = M1(3,46); M2(66,96) = M1(3,47); M2(66,98) = M1(3,48); M2(66,101) = M1(3,49); M2(66,102) = M1(3,50); M2(66,103) = M1(3,51); M2(66,104) = M1(3,52); M2(66,105) = M1(3,53); M2(66,107) = M1(3,54); M2(66,108) = M1(3,55); M2(66,109) = M1(3,56); M2(66,110) = M1(3,57); M2(66,112) = M1(3,58); M2(66,113) = M1(3,59); M2(66,114) = M1(3,60); M2(66,116) = M1(3,61); M2(66,117) = M1(3,62); M2(66,119) = M1(3,63); M2(66,122) = M1(3,64); M2(66,123) = M1(3,65); M2(66,124) = M1(3,66); M2(66,125) = M1(3,67); M2(66,127) = M1(3,68); M2(66,128) = M1(3,69); M2(66,129) = M1(3,70); M2(66,131) = M1(3,71); M2(66,132) = M1(3,72); M2(66,134) = M1(3,73); M2(66,137) = M1(3,74); M2(66,138) = M1(3,75); M2(66,139) = M1(3,76); M2(66,141) = M1(3,77); M2(66,142) = M1(3,78); M2(66,144) = M1(3,79); M2(66,147) = M1(3,80); M2(66,148) = M1(3,81); M2(66,150) = M1(3,82); M2(66,153) = M1(3,83); 
M2(67,41) = M1(4,4); M2(67,54) = M1(4,15); M2(67,55) = M1(4,16); M2(67,56) = M1(4,17); M2(67,58) = M1(4,18); M2(67,59) = M1(4,19); M2(67,60) = M1(4,20); M2(67,61) = M1(4,21); M2(67,63) = M1(4,22); M2(67,64) = M1(4,23); M2(67,65) = M1(4,24); M2(67,67) = M1(4,25); M2(67,68) = M1(4,26); M2(67,70) = M1(4,27); M2(67,72) = M1(4,28); M2(67,73) = M1(4,29); M2(67,74) = M1(4,30); M2(67,75) = M1(4,31); M2(67,76) = M1(4,32); M2(67,77) = M1(4,33); M2(67,79) = M1(4,34); M2(67,80) = M1(4,35); M2(67,81) = M1(4,36); M2(67,82) = M1(4,37); M2(67,83) = M1(4,38); M2(67,85) = M1(4,39); M2(67,86) = M1(4,40); M2(67,87) = M1(4,41); M2(67,88) = M1(4,42); M2(67,90) = M1(4,43); M2(67,91) = M1(4,44); M2(67,92) = M1(4,45); M2(67,95) = M1(4,46); M2(67,96) = M1(4,47); M2(67,98) = M1(4,48); M2(67,101) = M1(4,49); M2(67,102) = M1(4,50); M2(67,103) = M1(4,51); M2(67,104) = M1(4,52); M2(67,105) = M1(4,53); M2(67,107) = M1(4,54); M2(67,108) = M1(4,55); M2(67,109) = M1(4,56); M2(67,110) = M1(4,57); M2(67,112) = M1(4,58); M2(67,113) = M1(4,59); M2(67,114) = M1(4,60); M2(67,116) = M1(4,61); M2(67,117) = M1(4,62); M2(67,119) = M1(4,63); M2(67,122) = M1(4,64); M2(67,123) = M1(4,65); M2(67,124) = M1(4,66); M2(67,125) = M1(4,67); M2(67,127) = M1(4,68); M2(67,128) = M1(4,69); M2(67,129) = M1(4,70); M2(67,131) = M1(4,71); M2(67,132) = M1(4,72); M2(67,134) = M1(4,73); M2(67,137) = M1(4,74); M2(67,138) = M1(4,75); M2(67,139) = M1(4,76); M2(67,141) = M1(4,77); M2(67,142) = M1(4,78); M2(67,144) = M1(4,79); M2(67,147) = M1(4,80); M2(67,148) = M1(4,81); M2(67,150) = M1(4,82); M2(67,153) = M1(4,83); 
M2(68,42) = M1(5,5); M2(68,54) = M1(5,15); M2(68,55) = M1(5,16); M2(68,56) = M1(5,17); M2(68,58) = M1(5,18); M2(68,59) = M1(5,19); M2(68,60) = M1(5,20); M2(68,61) = M1(5,21); M2(68,63) = M1(5,22); M2(68,64) = M1(5,23); M2(68,65) = M1(5,24); M2(68,67) = M1(5,25); M2(68,68) = M1(5,26); M2(68,70) = M1(5,27); M2(68,72) = M1(5,28); M2(68,73) = M1(5,29); M2(68,74) = M1(5,30); M2(68,75) = M1(5,31); M2(68,76) = M1(5,32); M2(68,77) = M1(5,33); M2(68,79) = M1(5,34); M2(68,80) = M1(5,35); M2(68,81) = M1(5,36); M2(68,82) = M1(5,37); M2(68,83) = M1(5,38); M2(68,85) = M1(5,39); M2(68,86) = M1(5,40); M2(68,87) = M1(5,41); M2(68,88) = M1(5,42); M2(68,90) = M1(5,43); M2(68,91) = M1(5,44); M2(68,92) = M1(5,45); M2(68,95) = M1(5,46); M2(68,96) = M1(5,47); M2(68,98) = M1(5,48); M2(68,101) = M1(5,49); M2(68,102) = M1(5,50); M2(68,103) = M1(5,51); M2(68,104) = M1(5,52); M2(68,105) = M1(5,53); M2(68,107) = M1(5,54); M2(68,108) = M1(5,55); M2(68,109) = M1(5,56); M2(68,110) = M1(5,57); M2(68,112) = M1(5,58); M2(68,113) = M1(5,59); M2(68,114) = M1(5,60); M2(68,116) = M1(5,61); M2(68,117) = M1(5,62); M2(68,119) = M1(5,63); M2(68,122) = M1(5,64); M2(68,123) = M1(5,65); M2(68,124) = M1(5,66); M2(68,125) = M1(5,67); M2(68,127) = M1(5,68); M2(68,128) = M1(5,69); M2(68,129) = M1(5,70); M2(68,131) = M1(5,71); M2(68,132) = M1(5,72); M2(68,134) = M1(5,73); M2(68,137) = M1(5,74); M2(68,138) = M1(5,75); M2(68,139) = M1(5,76); M2(68,141) = M1(5,77); M2(68,142) = M1(5,78); M2(68,144) = M1(5,79); M2(68,147) = M1(5,80); M2(68,148) = M1(5,81); M2(68,150) = M1(5,82); M2(68,153) = M1(5,83); 
M2(69,43) = M1(6,6); M2(69,54) = M1(6,15); M2(69,55) = M1(6,16); M2(69,56) = M1(6,17); M2(69,58) = M1(6,18); M2(69,59) = M1(6,19); M2(69,60) = M1(6,20); M2(69,61) = M1(6,21); M2(69,63) = M1(6,22); M2(69,64) = M1(6,23); M2(69,65) = M1(6,24); M2(69,67) = M1(6,25); M2(69,68) = M1(6,26); M2(69,70) = M1(6,27); M2(69,72) = M1(6,28); M2(69,73) = M1(6,29); M2(69,74) = M1(6,30); M2(69,75) = M1(6,31); M2(69,76) = M1(6,32); M2(69,77) = M1(6,33); M2(69,79) = M1(6,34); M2(69,80) = M1(6,35); M2(69,81) = M1(6,36); M2(69,82) = M1(6,37); M2(69,83) = M1(6,38); M2(69,85) = M1(6,39); M2(69,86) = M1(6,40); M2(69,87) = M1(6,41); M2(69,88) = M1(6,42); M2(69,90) = M1(6,43); M2(69,91) = M1(6,44); M2(69,92) = M1(6,45); M2(69,95) = M1(6,46); M2(69,96) = M1(6,47); M2(69,98) = M1(6,48); M2(69,101) = M1(6,49); M2(69,102) = M1(6,50); M2(69,103) = M1(6,51); M2(69,104) = M1(6,52); M2(69,105) = M1(6,53); M2(69,107) = M1(6,54); M2(69,108) = M1(6,55); M2(69,109) = M1(6,56); M2(69,110) = M1(6,57); M2(69,112) = M1(6,58); M2(69,113) = M1(6,59); M2(69,114) = M1(6,60); M2(69,116) = M1(6,61); M2(69,117) = M1(6,62); M2(69,119) = M1(6,63); M2(69,122) = M1(6,64); M2(69,123) = M1(6,65); M2(69,124) = M1(6,66); M2(69,125) = M1(6,67); M2(69,127) = M1(6,68); M2(69,128) = M1(6,69); M2(69,129) = M1(6,70); M2(69,131) = M1(6,71); M2(69,132) = M1(6,72); M2(69,134) = M1(6,73); M2(69,137) = M1(6,74); M2(69,138) = M1(6,75); M2(69,139) = M1(6,76); M2(69,141) = M1(6,77); M2(69,142) = M1(6,78); M2(69,144) = M1(6,79); M2(69,147) = M1(6,80); M2(69,148) = M1(6,81); M2(69,150) = M1(6,82); M2(69,153) = M1(6,83); 
M2(70,45) = M1(7,7); M2(70,54) = M1(7,15); M2(70,55) = M1(7,16); M2(70,56) = M1(7,17); M2(70,58) = M1(7,18); M2(70,59) = M1(7,19); M2(70,60) = M1(7,20); M2(70,61) = M1(7,21); M2(70,63) = M1(7,22); M2(70,64) = M1(7,23); M2(70,65) = M1(7,24); M2(70,67) = M1(7,25); M2(70,68) = M1(7,26); M2(70,70) = M1(7,27); M2(70,72) = M1(7,28); M2(70,73) = M1(7,29); M2(70,74) = M1(7,30); M2(70,75) = M1(7,31); M2(70,76) = M1(7,32); M2(70,77) = M1(7,33); M2(70,79) = M1(7,34); M2(70,80) = M1(7,35); M2(70,81) = M1(7,36); M2(70,82) = M1(7,37); M2(70,83) = M1(7,38); M2(70,85) = M1(7,39); M2(70,86) = M1(7,40); M2(70,87) = M1(7,41); M2(70,88) = M1(7,42); M2(70,90) = M1(7,43); M2(70,91) = M1(7,44); M2(70,92) = M1(7,45); M2(70,95) = M1(7,46); M2(70,96) = M1(7,47); M2(70,98) = M1(7,48); M2(70,101) = M1(7,49); M2(70,102) = M1(7,50); M2(70,103) = M1(7,51); M2(70,104) = M1(7,52); M2(70,105) = M1(7,53); M2(70,107) = M1(7,54); M2(70,108) = M1(7,55); M2(70,109) = M1(7,56); M2(70,110) = M1(7,57); M2(70,112) = M1(7,58); M2(70,113) = M1(7,59); M2(70,114) = M1(7,60); M2(70,116) = M1(7,61); M2(70,117) = M1(7,62); M2(70,119) = M1(7,63); M2(70,122) = M1(7,64); M2(70,123) = M1(7,65); M2(70,124) = M1(7,66); M2(70,125) = M1(7,67); M2(70,127) = M1(7,68); M2(70,128) = M1(7,69); M2(70,129) = M1(7,70); M2(70,131) = M1(7,71); M2(70,132) = M1(7,72); M2(70,134) = M1(7,73); M2(70,137) = M1(7,74); M2(70,138) = M1(7,75); M2(70,139) = M1(7,76); M2(70,141) = M1(7,77); M2(70,142) = M1(7,78); M2(70,144) = M1(7,79); M2(70,147) = M1(7,80); M2(70,148) = M1(7,81); M2(70,150) = M1(7,82); M2(70,153) = M1(7,83); 
M2(71,46) = M1(8,8); M2(71,54) = M1(8,15); M2(71,55) = M1(8,16); M2(71,56) = M1(8,17); M2(71,58) = M1(8,18); M2(71,59) = M1(8,19); M2(71,60) = M1(8,20); M2(71,61) = M1(8,21); M2(71,63) = M1(8,22); M2(71,64) = M1(8,23); M2(71,65) = M1(8,24); M2(71,67) = M1(8,25); M2(71,68) = M1(8,26); M2(71,70) = M1(8,27); M2(71,72) = M1(8,28); M2(71,73) = M1(8,29); M2(71,74) = M1(8,30); M2(71,75) = M1(8,31); M2(71,76) = M1(8,32); M2(71,77) = M1(8,33); M2(71,79) = M1(8,34); M2(71,80) = M1(8,35); M2(71,81) = M1(8,36); M2(71,82) = M1(8,37); M2(71,83) = M1(8,38); M2(71,85) = M1(8,39); M2(71,86) = M1(8,40); M2(71,87) = M1(8,41); M2(71,88) = M1(8,42); M2(71,90) = M1(8,43); M2(71,91) = M1(8,44); M2(71,92) = M1(8,45); M2(71,95) = M1(8,46); M2(71,96) = M1(8,47); M2(71,98) = M1(8,48); M2(71,101) = M1(8,49); M2(71,102) = M1(8,50); M2(71,103) = M1(8,51); M2(71,104) = M1(8,52); M2(71,105) = M1(8,53); M2(71,107) = M1(8,54); M2(71,108) = M1(8,55); M2(71,109) = M1(8,56); M2(71,110) = M1(8,57); M2(71,112) = M1(8,58); M2(71,113) = M1(8,59); M2(71,114) = M1(8,60); M2(71,116) = M1(8,61); M2(71,117) = M1(8,62); M2(71,119) = M1(8,63); M2(71,122) = M1(8,64); M2(71,123) = M1(8,65); M2(71,124) = M1(8,66); M2(71,125) = M1(8,67); M2(71,127) = M1(8,68); M2(71,128) = M1(8,69); M2(71,129) = M1(8,70); M2(71,131) = M1(8,71); M2(71,132) = M1(8,72); M2(71,134) = M1(8,73); M2(71,137) = M1(8,74); M2(71,138) = M1(8,75); M2(71,139) = M1(8,76); M2(71,141) = M1(8,77); M2(71,142) = M1(8,78); M2(71,144) = M1(8,79); M2(71,147) = M1(8,80); M2(71,148) = M1(8,81); M2(71,150) = M1(8,82); M2(71,153) = M1(8,83); 
M2(72,47) = M1(9,9); M2(72,54) = M1(9,15); M2(72,55) = M1(9,16); M2(72,56) = M1(9,17); M2(72,58) = M1(9,18); M2(72,59) = M1(9,19); M2(72,60) = M1(9,20); M2(72,61) = M1(9,21); M2(72,63) = M1(9,22); M2(72,64) = M1(9,23); M2(72,65) = M1(9,24); M2(72,67) = M1(9,25); M2(72,68) = M1(9,26); M2(72,70) = M1(9,27); M2(72,72) = M1(9,28); M2(72,73) = M1(9,29); M2(72,74) = M1(9,30); M2(72,75) = M1(9,31); M2(72,76) = M1(9,32); M2(72,77) = M1(9,33); M2(72,79) = M1(9,34); M2(72,80) = M1(9,35); M2(72,81) = M1(9,36); M2(72,82) = M1(9,37); M2(72,83) = M1(9,38); M2(72,85) = M1(9,39); M2(72,86) = M1(9,40); M2(72,87) = M1(9,41); M2(72,88) = M1(9,42); M2(72,90) = M1(9,43); M2(72,91) = M1(9,44); M2(72,92) = M1(9,45); M2(72,95) = M1(9,46); M2(72,96) = M1(9,47); M2(72,98) = M1(9,48); M2(72,101) = M1(9,49); M2(72,102) = M1(9,50); M2(72,103) = M1(9,51); M2(72,104) = M1(9,52); M2(72,105) = M1(9,53); M2(72,107) = M1(9,54); M2(72,108) = M1(9,55); M2(72,109) = M1(9,56); M2(72,110) = M1(9,57); M2(72,112) = M1(9,58); M2(72,113) = M1(9,59); M2(72,114) = M1(9,60); M2(72,116) = M1(9,61); M2(72,117) = M1(9,62); M2(72,119) = M1(9,63); M2(72,122) = M1(9,64); M2(72,123) = M1(9,65); M2(72,124) = M1(9,66); M2(72,125) = M1(9,67); M2(72,127) = M1(9,68); M2(72,128) = M1(9,69); M2(72,129) = M1(9,70); M2(72,131) = M1(9,71); M2(72,132) = M1(9,72); M2(72,134) = M1(9,73); M2(72,137) = M1(9,74); M2(72,138) = M1(9,75); M2(72,139) = M1(9,76); M2(72,141) = M1(9,77); M2(72,142) = M1(9,78); M2(72,144) = M1(9,79); M2(72,147) = M1(9,80); M2(72,148) = M1(9,81); M2(72,150) = M1(9,82); M2(72,153) = M1(9,83); 
M2(73,48) = M1(10,10); M2(73,54) = M1(10,15); M2(73,55) = M1(10,16); M2(73,56) = M1(10,17); M2(73,58) = M1(10,18); M2(73,59) = M1(10,19); M2(73,60) = M1(10,20); M2(73,61) = M1(10,21); M2(73,63) = M1(10,22); M2(73,64) = M1(10,23); M2(73,65) = M1(10,24); M2(73,67) = M1(10,25); M2(73,68) = M1(10,26); M2(73,70) = M1(10,27); M2(73,72) = M1(10,28); M2(73,73) = M1(10,29); M2(73,74) = M1(10,30); M2(73,75) = M1(10,31); M2(73,76) = M1(10,32); M2(73,77) = M1(10,33); M2(73,79) = M1(10,34); M2(73,80) = M1(10,35); M2(73,81) = M1(10,36); M2(73,82) = M1(10,37); M2(73,83) = M1(10,38); M2(73,85) = M1(10,39); M2(73,86) = M1(10,40); M2(73,87) = M1(10,41); M2(73,88) = M1(10,42); M2(73,90) = M1(10,43); M2(73,91) = M1(10,44); M2(73,92) = M1(10,45); M2(73,95) = M1(10,46); M2(73,96) = M1(10,47); M2(73,98) = M1(10,48); M2(73,101) = M1(10,49); M2(73,102) = M1(10,50); M2(73,103) = M1(10,51); M2(73,104) = M1(10,52); M2(73,105) = M1(10,53); M2(73,107) = M1(10,54); M2(73,108) = M1(10,55); M2(73,109) = M1(10,56); M2(73,110) = M1(10,57); M2(73,112) = M1(10,58); M2(73,113) = M1(10,59); M2(73,114) = M1(10,60); M2(73,116) = M1(10,61); M2(73,117) = M1(10,62); M2(73,119) = M1(10,63); M2(73,122) = M1(10,64); M2(73,123) = M1(10,65); M2(73,124) = M1(10,66); M2(73,125) = M1(10,67); M2(73,127) = M1(10,68); M2(73,128) = M1(10,69); M2(73,129) = M1(10,70); M2(73,131) = M1(10,71); M2(73,132) = M1(10,72); M2(73,134) = M1(10,73); M2(73,137) = M1(10,74); M2(73,138) = M1(10,75); M2(73,139) = M1(10,76); M2(73,141) = M1(10,77); M2(73,142) = M1(10,78); M2(73,144) = M1(10,79); M2(73,147) = M1(10,80); M2(73,148) = M1(10,81); M2(73,150) = M1(10,82); M2(73,153) = M1(10,83); 
M2(74,49) = M1(11,11); M2(74,54) = M1(11,15); M2(74,55) = M1(11,16); M2(74,56) = M1(11,17); M2(74,58) = M1(11,18); M2(74,59) = M1(11,19); M2(74,60) = M1(11,20); M2(74,61) = M1(11,21); M2(74,63) = M1(11,22); M2(74,64) = M1(11,23); M2(74,65) = M1(11,24); M2(74,67) = M1(11,25); M2(74,68) = M1(11,26); M2(74,70) = M1(11,27); M2(74,72) = M1(11,28); M2(74,73) = M1(11,29); M2(74,74) = M1(11,30); M2(74,75) = M1(11,31); M2(74,76) = M1(11,32); M2(74,77) = M1(11,33); M2(74,79) = M1(11,34); M2(74,80) = M1(11,35); M2(74,81) = M1(11,36); M2(74,82) = M1(11,37); M2(74,83) = M1(11,38); M2(74,85) = M1(11,39); M2(74,86) = M1(11,40); M2(74,87) = M1(11,41); M2(74,88) = M1(11,42); M2(74,90) = M1(11,43); M2(74,91) = M1(11,44); M2(74,92) = M1(11,45); M2(74,95) = M1(11,46); M2(74,96) = M1(11,47); M2(74,98) = M1(11,48); M2(74,101) = M1(11,49); M2(74,102) = M1(11,50); M2(74,103) = M1(11,51); M2(74,104) = M1(11,52); M2(74,105) = M1(11,53); M2(74,107) = M1(11,54); M2(74,108) = M1(11,55); M2(74,109) = M1(11,56); M2(74,110) = M1(11,57); M2(74,112) = M1(11,58); M2(74,113) = M1(11,59); M2(74,114) = M1(11,60); M2(74,116) = M1(11,61); M2(74,117) = M1(11,62); M2(74,119) = M1(11,63); M2(74,122) = M1(11,64); M2(74,123) = M1(11,65); M2(74,124) = M1(11,66); M2(74,125) = M1(11,67); M2(74,127) = M1(11,68); M2(74,128) = M1(11,69); M2(74,129) = M1(11,70); M2(74,131) = M1(11,71); M2(74,132) = M1(11,72); M2(74,134) = M1(11,73); M2(74,137) = M1(11,74); M2(74,138) = M1(11,75); M2(74,139) = M1(11,76); M2(74,141) = M1(11,77); M2(74,142) = M1(11,78); M2(74,144) = M1(11,79); M2(74,147) = M1(11,80); M2(74,148) = M1(11,81); M2(74,150) = M1(11,82); M2(74,153) = M1(11,83); 
M2(75,50) = M1(12,12); M2(75,54) = M1(12,15); M2(75,55) = M1(12,16); M2(75,56) = M1(12,17); M2(75,58) = M1(12,18); M2(75,59) = M1(12,19); M2(75,60) = M1(12,20); M2(75,61) = M1(12,21); M2(75,63) = M1(12,22); M2(75,64) = M1(12,23); M2(75,65) = M1(12,24); M2(75,67) = M1(12,25); M2(75,68) = M1(12,26); M2(75,70) = M1(12,27); M2(75,72) = M1(12,28); M2(75,73) = M1(12,29); M2(75,74) = M1(12,30); M2(75,75) = M1(12,31); M2(75,76) = M1(12,32); M2(75,77) = M1(12,33); M2(75,79) = M1(12,34); M2(75,80) = M1(12,35); M2(75,81) = M1(12,36); M2(75,82) = M1(12,37); M2(75,83) = M1(12,38); M2(75,85) = M1(12,39); M2(75,86) = M1(12,40); M2(75,87) = M1(12,41); M2(75,88) = M1(12,42); M2(75,90) = M1(12,43); M2(75,91) = M1(12,44); M2(75,92) = M1(12,45); M2(75,95) = M1(12,46); M2(75,96) = M1(12,47); M2(75,98) = M1(12,48); M2(75,101) = M1(12,49); M2(75,102) = M1(12,50); M2(75,103) = M1(12,51); M2(75,104) = M1(12,52); M2(75,105) = M1(12,53); M2(75,107) = M1(12,54); M2(75,108) = M1(12,55); M2(75,109) = M1(12,56); M2(75,110) = M1(12,57); M2(75,112) = M1(12,58); M2(75,113) = M1(12,59); M2(75,114) = M1(12,60); M2(75,116) = M1(12,61); M2(75,117) = M1(12,62); M2(75,119) = M1(12,63); M2(75,122) = M1(12,64); M2(75,123) = M1(12,65); M2(75,124) = M1(12,66); M2(75,125) = M1(12,67); M2(75,127) = M1(12,68); M2(75,128) = M1(12,69); M2(75,129) = M1(12,70); M2(75,131) = M1(12,71); M2(75,132) = M1(12,72); M2(75,134) = M1(12,73); M2(75,137) = M1(12,74); M2(75,138) = M1(12,75); M2(75,139) = M1(12,76); M2(75,141) = M1(12,77); M2(75,142) = M1(12,78); M2(75,144) = M1(12,79); M2(75,147) = M1(12,80); M2(75,148) = M1(12,81); M2(75,150) = M1(12,82); M2(75,153) = M1(12,83); 
M2(76,52) = M1(13,13); M2(76,54) = M1(13,15); M2(76,55) = M1(13,16); M2(76,56) = M1(13,17); M2(76,58) = M1(13,18); M2(76,59) = M1(13,19); M2(76,60) = M1(13,20); M2(76,61) = M1(13,21); M2(76,63) = M1(13,22); M2(76,64) = M1(13,23); M2(76,65) = M1(13,24); M2(76,67) = M1(13,25); M2(76,68) = M1(13,26); M2(76,70) = M1(13,27); M2(76,72) = M1(13,28); M2(76,73) = M1(13,29); M2(76,74) = M1(13,30); M2(76,75) = M1(13,31); M2(76,76) = M1(13,32); M2(76,77) = M1(13,33); M2(76,79) = M1(13,34); M2(76,80) = M1(13,35); M2(76,81) = M1(13,36); M2(76,82) = M1(13,37); M2(76,83) = M1(13,38); M2(76,85) = M1(13,39); M2(76,86) = M1(13,40); M2(76,87) = M1(13,41); M2(76,88) = M1(13,42); M2(76,90) = M1(13,43); M2(76,91) = M1(13,44); M2(76,92) = M1(13,45); M2(76,95) = M1(13,46); M2(76,96) = M1(13,47); M2(76,98) = M1(13,48); M2(76,101) = M1(13,49); M2(76,102) = M1(13,50); M2(76,103) = M1(13,51); M2(76,104) = M1(13,52); M2(76,105) = M1(13,53); M2(76,107) = M1(13,54); M2(76,108) = M1(13,55); M2(76,109) = M1(13,56); M2(76,110) = M1(13,57); M2(76,112) = M1(13,58); M2(76,113) = M1(13,59); M2(76,114) = M1(13,60); M2(76,116) = M1(13,61); M2(76,117) = M1(13,62); M2(76,119) = M1(13,63); M2(76,122) = M1(13,64); M2(76,123) = M1(13,65); M2(76,124) = M1(13,66); M2(76,125) = M1(13,67); M2(76,127) = M1(13,68); M2(76,128) = M1(13,69); M2(76,129) = M1(13,70); M2(76,131) = M1(13,71); M2(76,132) = M1(13,72); M2(76,134) = M1(13,73); M2(76,137) = M1(13,74); M2(76,138) = M1(13,75); M2(76,139) = M1(13,76); M2(76,141) = M1(13,77); M2(76,142) = M1(13,78); M2(76,144) = M1(13,79); M2(76,147) = M1(13,80); M2(76,148) = M1(13,81); M2(76,150) = M1(13,82); M2(76,153) = M1(13,83); 
M2(77,53) = M1(14,14); M2(77,54) = M1(14,15); M2(77,55) = M1(14,16); M2(77,56) = M1(14,17); M2(77,58) = M1(14,18); M2(77,59) = M1(14,19); M2(77,60) = M1(14,20); M2(77,61) = M1(14,21); M2(77,63) = M1(14,22); M2(77,64) = M1(14,23); M2(77,65) = M1(14,24); M2(77,67) = M1(14,25); M2(77,68) = M1(14,26); M2(77,70) = M1(14,27); M2(77,72) = M1(14,28); M2(77,73) = M1(14,29); M2(77,74) = M1(14,30); M2(77,75) = M1(14,31); M2(77,76) = M1(14,32); M2(77,77) = M1(14,33); M2(77,79) = M1(14,34); M2(77,80) = M1(14,35); M2(77,81) = M1(14,36); M2(77,82) = M1(14,37); M2(77,83) = M1(14,38); M2(77,85) = M1(14,39); M2(77,86) = M1(14,40); M2(77,87) = M1(14,41); M2(77,88) = M1(14,42); M2(77,90) = M1(14,43); M2(77,91) = M1(14,44); M2(77,92) = M1(14,45); M2(77,95) = M1(14,46); M2(77,96) = M1(14,47); M2(77,98) = M1(14,48); M2(77,101) = M1(14,49); M2(77,102) = M1(14,50); M2(77,103) = M1(14,51); M2(77,104) = M1(14,52); M2(77,105) = M1(14,53); M2(77,107) = M1(14,54); M2(77,108) = M1(14,55); M2(77,109) = M1(14,56); M2(77,110) = M1(14,57); M2(77,112) = M1(14,58); M2(77,113) = M1(14,59); M2(77,114) = M1(14,60); M2(77,116) = M1(14,61); M2(77,117) = M1(14,62); M2(77,119) = M1(14,63); M2(77,122) = M1(14,64); M2(77,123) = M1(14,65); M2(77,124) = M1(14,66); M2(77,125) = M1(14,67); M2(77,127) = M1(14,68); M2(77,128) = M1(14,69); M2(77,129) = M1(14,70); M2(77,131) = M1(14,71); M2(77,132) = M1(14,72); M2(77,134) = M1(14,73); M2(77,137) = M1(14,74); M2(77,138) = M1(14,75); M2(77,139) = M1(14,76); M2(77,141) = M1(14,77); M2(77,142) = M1(14,78); M2(77,144) = M1(14,79); M2(77,147) = M1(14,80); M2(77,148) = M1(14,81); M2(77,150) = M1(14,82); M2(77,153) = M1(14,83); 
M2(78,72) = M1(0,0); M2(78,87) = M1(0,15); M2(78,88) = M1(0,16); M2(78,89) = M1(0,17); M2(78,90) = M1(0,18); M2(78,91) = M1(0,19); M2(78,92) = M1(0,20); M2(78,94) = M1(0,21); M2(78,95) = M1(0,22); M2(78,96) = M1(0,23); M2(78,97) = M1(0,24); M2(78,98) = M1(0,25); M2(78,99) = M1(0,26); M2(78,100) = M1(0,27); M2(78,101) = M1(0,28); M2(78,102) = M1(0,29); M2(78,103) = M1(0,30); M2(78,104) = M1(0,31); M2(78,105) = M1(0,32); M2(78,106) = M1(0,33); M2(78,107) = M1(0,34); M2(78,108) = M1(0,35); M2(78,109) = M1(0,36); M2(78,110) = M1(0,37); M2(78,111) = M1(0,38); M2(78,112) = M1(0,39); M2(78,113) = M1(0,40); M2(78,114) = M1(0,41); M2(78,115) = M1(0,42); M2(78,116) = M1(0,43); M2(78,117) = M1(0,44); M2(78,118) = M1(0,45); M2(78,119) = M1(0,46); M2(78,120) = M1(0,47); M2(78,121) = M1(0,48); M2(78,122) = M1(0,49); M2(78,123) = M1(0,50); M2(78,124) = M1(0,51); M2(78,125) = M1(0,52); M2(78,126) = M1(0,53); M2(78,127) = M1(0,54); M2(78,128) = M1(0,55); M2(78,129) = M1(0,56); M2(78,130) = M1(0,57); M2(78,131) = M1(0,58); M2(78,132) = M1(0,59); M2(78,133) = M1(0,60); M2(78,134) = M1(0,61); M2(78,135) = M1(0,62); M2(78,136) = M1(0,63); M2(78,137) = M1(0,64); M2(78,138) = M1(0,65); M2(78,139) = M1(0,66); M2(78,140) = M1(0,67); M2(78,141) = M1(0,68); M2(78,142) = M1(0,69); M2(78,143) = M1(0,70); M2(78,144) = M1(0,71); M2(78,145) = M1(0,72); M2(78,146) = M1(0,73); M2(78,147) = M1(0,74); M2(78,148) = M1(0,75); M2(78,149) = M1(0,76); M2(78,150) = M1(0,77); M2(78,151) = M1(0,78); M2(78,152) = M1(0,79); M2(78,153) = M1(0,80); M2(78,154) = M1(0,81); M2(78,155) = M1(0,82); M2(78,156) = M1(0,83); 
M2(79,73) = M1(1,1); M2(79,87) = M1(1,15); M2(79,88) = M1(1,16); M2(79,89) = M1(1,17); M2(79,90) = M1(1,18); M2(79,91) = M1(1,19); M2(79,92) = M1(1,20); M2(79,94) = M1(1,21); M2(79,95) = M1(1,22); M2(79,96) = M1(1,23); M2(79,97) = M1(1,24); M2(79,98) = M1(1,25); M2(79,99) = M1(1,26); M2(79,100) = M1(1,27); M2(79,101) = M1(1,28); M2(79,102) = M1(1,29); M2(79,103) = M1(1,30); M2(79,104) = M1(1,31); M2(79,105) = M1(1,32); M2(79,106) = M1(1,33); M2(79,107) = M1(1,34); M2(79,108) = M1(1,35); M2(79,109) = M1(1,36); M2(79,110) = M1(1,37); M2(79,111) = M1(1,38); M2(79,112) = M1(1,39); M2(79,113) = M1(1,40); M2(79,114) = M1(1,41); M2(79,115) = M1(1,42); M2(79,116) = M1(1,43); M2(79,117) = M1(1,44); M2(79,118) = M1(1,45); M2(79,119) = M1(1,46); M2(79,120) = M1(1,47); M2(79,121) = M1(1,48); M2(79,122) = M1(1,49); M2(79,123) = M1(1,50); M2(79,124) = M1(1,51); M2(79,125) = M1(1,52); M2(79,126) = M1(1,53); M2(79,127) = M1(1,54); M2(79,128) = M1(1,55); M2(79,129) = M1(1,56); M2(79,130) = M1(1,57); M2(79,131) = M1(1,58); M2(79,132) = M1(1,59); M2(79,133) = M1(1,60); M2(79,134) = M1(1,61); M2(79,135) = M1(1,62); M2(79,136) = M1(1,63); M2(79,137) = M1(1,64); M2(79,138) = M1(1,65); M2(79,139) = M1(1,66); M2(79,140) = M1(1,67); M2(79,141) = M1(1,68); M2(79,142) = M1(1,69); M2(79,143) = M1(1,70); M2(79,144) = M1(1,71); M2(79,145) = M1(1,72); M2(79,146) = M1(1,73); M2(79,147) = M1(1,74); M2(79,148) = M1(1,75); M2(79,149) = M1(1,76); M2(79,150) = M1(1,77); M2(79,151) = M1(1,78); M2(79,152) = M1(1,79); M2(79,153) = M1(1,80); M2(79,154) = M1(1,81); M2(79,155) = M1(1,82); M2(79,156) = M1(1,83); 
M2(80,74) = M1(2,2); M2(80,87) = M1(2,15); M2(80,88) = M1(2,16); M2(80,89) = M1(2,17); M2(80,90) = M1(2,18); M2(80,91) = M1(2,19); M2(80,92) = M1(2,20); M2(80,94) = M1(2,21); M2(80,95) = M1(2,22); M2(80,96) = M1(2,23); M2(80,97) = M1(2,24); M2(80,98) = M1(2,25); M2(80,99) = M1(2,26); M2(80,100) = M1(2,27); M2(80,101) = M1(2,28); M2(80,102) = M1(2,29); M2(80,103) = M1(2,30); M2(80,104) = M1(2,31); M2(80,105) = M1(2,32); M2(80,106) = M1(2,33); M2(80,107) = M1(2,34); M2(80,108) = M1(2,35); M2(80,109) = M1(2,36); M2(80,110) = M1(2,37); M2(80,111) = M1(2,38); M2(80,112) = M1(2,39); M2(80,113) = M1(2,40); M2(80,114) = M1(2,41); M2(80,115) = M1(2,42); M2(80,116) = M1(2,43); M2(80,117) = M1(2,44); M2(80,118) = M1(2,45); M2(80,119) = M1(2,46); M2(80,120) = M1(2,47); M2(80,121) = M1(2,48); M2(80,122) = M1(2,49); M2(80,123) = M1(2,50); M2(80,124) = M1(2,51); M2(80,125) = M1(2,52); M2(80,126) = M1(2,53); M2(80,127) = M1(2,54); M2(80,128) = M1(2,55); M2(80,129) = M1(2,56); M2(80,130) = M1(2,57); M2(80,131) = M1(2,58); M2(80,132) = M1(2,59); M2(80,133) = M1(2,60); M2(80,134) = M1(2,61); M2(80,135) = M1(2,62); M2(80,136) = M1(2,63); M2(80,137) = M1(2,64); M2(80,138) = M1(2,65); M2(80,139) = M1(2,66); M2(80,140) = M1(2,67); M2(80,141) = M1(2,68); M2(80,142) = M1(2,69); M2(80,143) = M1(2,70); M2(80,144) = M1(2,71); M2(80,145) = M1(2,72); M2(80,146) = M1(2,73); M2(80,147) = M1(2,74); M2(80,148) = M1(2,75); M2(80,149) = M1(2,76); M2(80,150) = M1(2,77); M2(80,151) = M1(2,78); M2(80,152) = M1(2,79); M2(80,153) = M1(2,80); M2(80,154) = M1(2,81); M2(80,155) = M1(2,82); M2(80,156) = M1(2,83); 
M2(81,75) = M1(3,3); M2(81,87) = M1(3,15); M2(81,88) = M1(3,16); M2(81,89) = M1(3,17); M2(81,90) = M1(3,18); M2(81,91) = M1(3,19); M2(81,92) = M1(3,20); M2(81,94) = M1(3,21); M2(81,95) = M1(3,22); M2(81,96) = M1(3,23); M2(81,97) = M1(3,24); M2(81,98) = M1(3,25); M2(81,99) = M1(3,26); M2(81,100) = M1(3,27); M2(81,101) = M1(3,28); M2(81,102) = M1(3,29); M2(81,103) = M1(3,30); M2(81,104) = M1(3,31); M2(81,105) = M1(3,32); M2(81,106) = M1(3,33); M2(81,107) = M1(3,34); M2(81,108) = M1(3,35); M2(81,109) = M1(3,36); M2(81,110) = M1(3,37); M2(81,111) = M1(3,38); M2(81,112) = M1(3,39); M2(81,113) = M1(3,40); M2(81,114) = M1(3,41); M2(81,115) = M1(3,42); M2(81,116) = M1(3,43); M2(81,117) = M1(3,44); M2(81,118) = M1(3,45); M2(81,119) = M1(3,46); M2(81,120) = M1(3,47); M2(81,121) = M1(3,48); M2(81,122) = M1(3,49); M2(81,123) = M1(3,50); M2(81,124) = M1(3,51); M2(81,125) = M1(3,52); M2(81,126) = M1(3,53); M2(81,127) = M1(3,54); M2(81,128) = M1(3,55); M2(81,129) = M1(3,56); M2(81,130) = M1(3,57); M2(81,131) = M1(3,58); M2(81,132) = M1(3,59); M2(81,133) = M1(3,60); M2(81,134) = M1(3,61); M2(81,135) = M1(3,62); M2(81,136) = M1(3,63); M2(81,137) = M1(3,64); M2(81,138) = M1(3,65); M2(81,139) = M1(3,66); M2(81,140) = M1(3,67); M2(81,141) = M1(3,68); M2(81,142) = M1(3,69); M2(81,143) = M1(3,70); M2(81,144) = M1(3,71); M2(81,145) = M1(3,72); M2(81,146) = M1(3,73); M2(81,147) = M1(3,74); M2(81,148) = M1(3,75); M2(81,149) = M1(3,76); M2(81,150) = M1(3,77); M2(81,151) = M1(3,78); M2(81,152) = M1(3,79); M2(81,153) = M1(3,80); M2(81,154) = M1(3,81); M2(81,155) = M1(3,82); M2(81,156) = M1(3,83); 
M2(82,76) = M1(4,4); M2(82,87) = M1(4,15); M2(82,88) = M1(4,16); M2(82,89) = M1(4,17); M2(82,90) = M1(4,18); M2(82,91) = M1(4,19); M2(82,92) = M1(4,20); M2(82,94) = M1(4,21); M2(82,95) = M1(4,22); M2(82,96) = M1(4,23); M2(82,97) = M1(4,24); M2(82,98) = M1(4,25); M2(82,99) = M1(4,26); M2(82,100) = M1(4,27); M2(82,101) = M1(4,28); M2(82,102) = M1(4,29); M2(82,103) = M1(4,30); M2(82,104) = M1(4,31); M2(82,105) = M1(4,32); M2(82,106) = M1(4,33); M2(82,107) = M1(4,34); M2(82,108) = M1(4,35); M2(82,109) = M1(4,36); M2(82,110) = M1(4,37); M2(82,111) = M1(4,38); M2(82,112) = M1(4,39); M2(82,113) = M1(4,40); M2(82,114) = M1(4,41); M2(82,115) = M1(4,42); M2(82,116) = M1(4,43); M2(82,117) = M1(4,44); M2(82,118) = M1(4,45); M2(82,119) = M1(4,46); M2(82,120) = M1(4,47); M2(82,121) = M1(4,48); M2(82,122) = M1(4,49); M2(82,123) = M1(4,50); M2(82,124) = M1(4,51); M2(82,125) = M1(4,52); M2(82,126) = M1(4,53); M2(82,127) = M1(4,54); M2(82,128) = M1(4,55); M2(82,129) = M1(4,56); M2(82,130) = M1(4,57); M2(82,131) = M1(4,58); M2(82,132) = M1(4,59); M2(82,133) = M1(4,60); M2(82,134) = M1(4,61); M2(82,135) = M1(4,62); M2(82,136) = M1(4,63); M2(82,137) = M1(4,64); M2(82,138) = M1(4,65); M2(82,139) = M1(4,66); M2(82,140) = M1(4,67); M2(82,141) = M1(4,68); M2(82,142) = M1(4,69); M2(82,143) = M1(4,70); M2(82,144) = M1(4,71); M2(82,145) = M1(4,72); M2(82,146) = M1(4,73); M2(82,147) = M1(4,74); M2(82,148) = M1(4,75); M2(82,149) = M1(4,76); M2(82,150) = M1(4,77); M2(82,151) = M1(4,78); M2(82,152) = M1(4,79); M2(82,153) = M1(4,80); M2(82,154) = M1(4,81); M2(82,155) = M1(4,82); M2(82,156) = M1(4,83); 
M2(83,77) = M1(5,5); M2(83,87) = M1(5,15); M2(83,88) = M1(5,16); M2(83,89) = M1(5,17); M2(83,90) = M1(5,18); M2(83,91) = M1(5,19); M2(83,92) = M1(5,20); M2(83,94) = M1(5,21); M2(83,95) = M1(5,22); M2(83,96) = M1(5,23); M2(83,97) = M1(5,24); M2(83,98) = M1(5,25); M2(83,99) = M1(5,26); M2(83,100) = M1(5,27); M2(83,101) = M1(5,28); M2(83,102) = M1(5,29); M2(83,103) = M1(5,30); M2(83,104) = M1(5,31); M2(83,105) = M1(5,32); M2(83,106) = M1(5,33); M2(83,107) = M1(5,34); M2(83,108) = M1(5,35); M2(83,109) = M1(5,36); M2(83,110) = M1(5,37); M2(83,111) = M1(5,38); M2(83,112) = M1(5,39); M2(83,113) = M1(5,40); M2(83,114) = M1(5,41); M2(83,115) = M1(5,42); M2(83,116) = M1(5,43); M2(83,117) = M1(5,44); M2(83,118) = M1(5,45); M2(83,119) = M1(5,46); M2(83,120) = M1(5,47); M2(83,121) = M1(5,48); M2(83,122) = M1(5,49); M2(83,123) = M1(5,50); M2(83,124) = M1(5,51); M2(83,125) = M1(5,52); M2(83,126) = M1(5,53); M2(83,127) = M1(5,54); M2(83,128) = M1(5,55); M2(83,129) = M1(5,56); M2(83,130) = M1(5,57); M2(83,131) = M1(5,58); M2(83,132) = M1(5,59); M2(83,133) = M1(5,60); M2(83,134) = M1(5,61); M2(83,135) = M1(5,62); M2(83,136) = M1(5,63); M2(83,137) = M1(5,64); M2(83,138) = M1(5,65); M2(83,139) = M1(5,66); M2(83,140) = M1(5,67); M2(83,141) = M1(5,68); M2(83,142) = M1(5,69); M2(83,143) = M1(5,70); M2(83,144) = M1(5,71); M2(83,145) = M1(5,72); M2(83,146) = M1(5,73); M2(83,147) = M1(5,74); M2(83,148) = M1(5,75); M2(83,149) = M1(5,76); M2(83,150) = M1(5,77); M2(83,151) = M1(5,78); M2(83,152) = M1(5,79); M2(83,153) = M1(5,80); M2(83,154) = M1(5,81); M2(83,155) = M1(5,82); M2(83,156) = M1(5,83); 
M2(84,78) = M1(6,6); M2(84,87) = M1(6,15); M2(84,88) = M1(6,16); M2(84,89) = M1(6,17); M2(84,90) = M1(6,18); M2(84,91) = M1(6,19); M2(84,92) = M1(6,20); M2(84,94) = M1(6,21); M2(84,95) = M1(6,22); M2(84,96) = M1(6,23); M2(84,97) = M1(6,24); M2(84,98) = M1(6,25); M2(84,99) = M1(6,26); M2(84,100) = M1(6,27); M2(84,101) = M1(6,28); M2(84,102) = M1(6,29); M2(84,103) = M1(6,30); M2(84,104) = M1(6,31); M2(84,105) = M1(6,32); M2(84,106) = M1(6,33); M2(84,107) = M1(6,34); M2(84,108) = M1(6,35); M2(84,109) = M1(6,36); M2(84,110) = M1(6,37); M2(84,111) = M1(6,38); M2(84,112) = M1(6,39); M2(84,113) = M1(6,40); M2(84,114) = M1(6,41); M2(84,115) = M1(6,42); M2(84,116) = M1(6,43); M2(84,117) = M1(6,44); M2(84,118) = M1(6,45); M2(84,119) = M1(6,46); M2(84,120) = M1(6,47); M2(84,121) = M1(6,48); M2(84,122) = M1(6,49); M2(84,123) = M1(6,50); M2(84,124) = M1(6,51); M2(84,125) = M1(6,52); M2(84,126) = M1(6,53); M2(84,127) = M1(6,54); M2(84,128) = M1(6,55); M2(84,129) = M1(6,56); M2(84,130) = M1(6,57); M2(84,131) = M1(6,58); M2(84,132) = M1(6,59); M2(84,133) = M1(6,60); M2(84,134) = M1(6,61); M2(84,135) = M1(6,62); M2(84,136) = M1(6,63); M2(84,137) = M1(6,64); M2(84,138) = M1(6,65); M2(84,139) = M1(6,66); M2(84,140) = M1(6,67); M2(84,141) = M1(6,68); M2(84,142) = M1(6,69); M2(84,143) = M1(6,70); M2(84,144) = M1(6,71); M2(84,145) = M1(6,72); M2(84,146) = M1(6,73); M2(84,147) = M1(6,74); M2(84,148) = M1(6,75); M2(84,149) = M1(6,76); M2(84,150) = M1(6,77); M2(84,151) = M1(6,78); M2(84,152) = M1(6,79); M2(84,153) = M1(6,80); M2(84,154) = M1(6,81); M2(84,155) = M1(6,82); M2(84,156) = M1(6,83); 
M2(85,79) = M1(7,7); M2(85,87) = M1(7,15); M2(85,88) = M1(7,16); M2(85,89) = M1(7,17); M2(85,90) = M1(7,18); M2(85,91) = M1(7,19); M2(85,92) = M1(7,20); M2(85,94) = M1(7,21); M2(85,95) = M1(7,22); M2(85,96) = M1(7,23); M2(85,97) = M1(7,24); M2(85,98) = M1(7,25); M2(85,99) = M1(7,26); M2(85,100) = M1(7,27); M2(85,101) = M1(7,28); M2(85,102) = M1(7,29); M2(85,103) = M1(7,30); M2(85,104) = M1(7,31); M2(85,105) = M1(7,32); M2(85,106) = M1(7,33); M2(85,107) = M1(7,34); M2(85,108) = M1(7,35); M2(85,109) = M1(7,36); M2(85,110) = M1(7,37); M2(85,111) = M1(7,38); M2(85,112) = M1(7,39); M2(85,113) = M1(7,40); M2(85,114) = M1(7,41); M2(85,115) = M1(7,42); M2(85,116) = M1(7,43); M2(85,117) = M1(7,44); M2(85,118) = M1(7,45); M2(85,119) = M1(7,46); M2(85,120) = M1(7,47); M2(85,121) = M1(7,48); M2(85,122) = M1(7,49); M2(85,123) = M1(7,50); M2(85,124) = M1(7,51); M2(85,125) = M1(7,52); M2(85,126) = M1(7,53); M2(85,127) = M1(7,54); M2(85,128) = M1(7,55); M2(85,129) = M1(7,56); M2(85,130) = M1(7,57); M2(85,131) = M1(7,58); M2(85,132) = M1(7,59); M2(85,133) = M1(7,60); M2(85,134) = M1(7,61); M2(85,135) = M1(7,62); M2(85,136) = M1(7,63); M2(85,137) = M1(7,64); M2(85,138) = M1(7,65); M2(85,139) = M1(7,66); M2(85,140) = M1(7,67); M2(85,141) = M1(7,68); M2(85,142) = M1(7,69); M2(85,143) = M1(7,70); M2(85,144) = M1(7,71); M2(85,145) = M1(7,72); M2(85,146) = M1(7,73); M2(85,147) = M1(7,74); M2(85,148) = M1(7,75); M2(85,149) = M1(7,76); M2(85,150) = M1(7,77); M2(85,151) = M1(7,78); M2(85,152) = M1(7,79); M2(85,153) = M1(7,80); M2(85,154) = M1(7,81); M2(85,155) = M1(7,82); M2(85,156) = M1(7,83); 
M2(86,80) = M1(8,8); M2(86,87) = M1(8,15); M2(86,88) = M1(8,16); M2(86,89) = M1(8,17); M2(86,90) = M1(8,18); M2(86,91) = M1(8,19); M2(86,92) = M1(8,20); M2(86,94) = M1(8,21); M2(86,95) = M1(8,22); M2(86,96) = M1(8,23); M2(86,97) = M1(8,24); M2(86,98) = M1(8,25); M2(86,99) = M1(8,26); M2(86,100) = M1(8,27); M2(86,101) = M1(8,28); M2(86,102) = M1(8,29); M2(86,103) = M1(8,30); M2(86,104) = M1(8,31); M2(86,105) = M1(8,32); M2(86,106) = M1(8,33); M2(86,107) = M1(8,34); M2(86,108) = M1(8,35); M2(86,109) = M1(8,36); M2(86,110) = M1(8,37); M2(86,111) = M1(8,38); M2(86,112) = M1(8,39); M2(86,113) = M1(8,40); M2(86,114) = M1(8,41); M2(86,115) = M1(8,42); M2(86,116) = M1(8,43); M2(86,117) = M1(8,44); M2(86,118) = M1(8,45); M2(86,119) = M1(8,46); M2(86,120) = M1(8,47); M2(86,121) = M1(8,48); M2(86,122) = M1(8,49); M2(86,123) = M1(8,50); M2(86,124) = M1(8,51); M2(86,125) = M1(8,52); M2(86,126) = M1(8,53); M2(86,127) = M1(8,54); M2(86,128) = M1(8,55); M2(86,129) = M1(8,56); M2(86,130) = M1(8,57); M2(86,131) = M1(8,58); M2(86,132) = M1(8,59); M2(86,133) = M1(8,60); M2(86,134) = M1(8,61); M2(86,135) = M1(8,62); M2(86,136) = M1(8,63); M2(86,137) = M1(8,64); M2(86,138) = M1(8,65); M2(86,139) = M1(8,66); M2(86,140) = M1(8,67); M2(86,141) = M1(8,68); M2(86,142) = M1(8,69); M2(86,143) = M1(8,70); M2(86,144) = M1(8,71); M2(86,145) = M1(8,72); M2(86,146) = M1(8,73); M2(86,147) = M1(8,74); M2(86,148) = M1(8,75); M2(86,149) = M1(8,76); M2(86,150) = M1(8,77); M2(86,151) = M1(8,78); M2(86,152) = M1(8,79); M2(86,153) = M1(8,80); M2(86,154) = M1(8,81); M2(86,155) = M1(8,82); M2(86,156) = M1(8,83); 
M2(87,81) = M1(9,9); M2(87,87) = M1(9,15); M2(87,88) = M1(9,16); M2(87,89) = M1(9,17); M2(87,90) = M1(9,18); M2(87,91) = M1(9,19); M2(87,92) = M1(9,20); M2(87,94) = M1(9,21); M2(87,95) = M1(9,22); M2(87,96) = M1(9,23); M2(87,97) = M1(9,24); M2(87,98) = M1(9,25); M2(87,99) = M1(9,26); M2(87,100) = M1(9,27); M2(87,101) = M1(9,28); M2(87,102) = M1(9,29); M2(87,103) = M1(9,30); M2(87,104) = M1(9,31); M2(87,105) = M1(9,32); M2(87,106) = M1(9,33); M2(87,107) = M1(9,34); M2(87,108) = M1(9,35); M2(87,109) = M1(9,36); M2(87,110) = M1(9,37); M2(87,111) = M1(9,38); M2(87,112) = M1(9,39); M2(87,113) = M1(9,40); M2(87,114) = M1(9,41); M2(87,115) = M1(9,42); M2(87,116) = M1(9,43); M2(87,117) = M1(9,44); M2(87,118) = M1(9,45); M2(87,119) = M1(9,46); M2(87,120) = M1(9,47); M2(87,121) = M1(9,48); M2(87,122) = M1(9,49); M2(87,123) = M1(9,50); M2(87,124) = M1(9,51); M2(87,125) = M1(9,52); M2(87,126) = M1(9,53); M2(87,127) = M1(9,54); M2(87,128) = M1(9,55); M2(87,129) = M1(9,56); M2(87,130) = M1(9,57); M2(87,131) = M1(9,58); M2(87,132) = M1(9,59); M2(87,133) = M1(9,60); M2(87,134) = M1(9,61); M2(87,135) = M1(9,62); M2(87,136) = M1(9,63); M2(87,137) = M1(9,64); M2(87,138) = M1(9,65); M2(87,139) = M1(9,66); M2(87,140) = M1(9,67); M2(87,141) = M1(9,68); M2(87,142) = M1(9,69); M2(87,143) = M1(9,70); M2(87,144) = M1(9,71); M2(87,145) = M1(9,72); M2(87,146) = M1(9,73); M2(87,147) = M1(9,74); M2(87,148) = M1(9,75); M2(87,149) = M1(9,76); M2(87,150) = M1(9,77); M2(87,151) = M1(9,78); M2(87,152) = M1(9,79); M2(87,153) = M1(9,80); M2(87,154) = M1(9,81); M2(87,155) = M1(9,82); M2(87,156) = M1(9,83); 
M2(88,82) = M1(10,10); M2(88,87) = M1(10,15); M2(88,88) = M1(10,16); M2(88,89) = M1(10,17); M2(88,90) = M1(10,18); M2(88,91) = M1(10,19); M2(88,92) = M1(10,20); M2(88,94) = M1(10,21); M2(88,95) = M1(10,22); M2(88,96) = M1(10,23); M2(88,97) = M1(10,24); M2(88,98) = M1(10,25); M2(88,99) = M1(10,26); M2(88,100) = M1(10,27); M2(88,101) = M1(10,28); M2(88,102) = M1(10,29); M2(88,103) = M1(10,30); M2(88,104) = M1(10,31); M2(88,105) = M1(10,32); M2(88,106) = M1(10,33); M2(88,107) = M1(10,34); M2(88,108) = M1(10,35); M2(88,109) = M1(10,36); M2(88,110) = M1(10,37); M2(88,111) = M1(10,38); M2(88,112) = M1(10,39); M2(88,113) = M1(10,40); M2(88,114) = M1(10,41); M2(88,115) = M1(10,42); M2(88,116) = M1(10,43); M2(88,117) = M1(10,44); M2(88,118) = M1(10,45); M2(88,119) = M1(10,46); M2(88,120) = M1(10,47); M2(88,121) = M1(10,48); M2(88,122) = M1(10,49); M2(88,123) = M1(10,50); M2(88,124) = M1(10,51); M2(88,125) = M1(10,52); M2(88,126) = M1(10,53); M2(88,127) = M1(10,54); M2(88,128) = M1(10,55); M2(88,129) = M1(10,56); M2(88,130) = M1(10,57); M2(88,131) = M1(10,58); M2(88,132) = M1(10,59); M2(88,133) = M1(10,60); M2(88,134) = M1(10,61); M2(88,135) = M1(10,62); M2(88,136) = M1(10,63); M2(88,137) = M1(10,64); M2(88,138) = M1(10,65); M2(88,139) = M1(10,66); M2(88,140) = M1(10,67); M2(88,141) = M1(10,68); M2(88,142) = M1(10,69); M2(88,143) = M1(10,70); M2(88,144) = M1(10,71); M2(88,145) = M1(10,72); M2(88,146) = M1(10,73); M2(88,147) = M1(10,74); M2(88,148) = M1(10,75); M2(88,149) = M1(10,76); M2(88,150) = M1(10,77); M2(88,151) = M1(10,78); M2(88,152) = M1(10,79); M2(88,153) = M1(10,80); M2(88,154) = M1(10,81); M2(88,155) = M1(10,82); M2(88,156) = M1(10,83); 
M2(89,83) = M1(11,11); M2(89,87) = M1(11,15); M2(89,88) = M1(11,16); M2(89,89) = M1(11,17); M2(89,90) = M1(11,18); M2(89,91) = M1(11,19); M2(89,92) = M1(11,20); M2(89,94) = M1(11,21); M2(89,95) = M1(11,22); M2(89,96) = M1(11,23); M2(89,97) = M1(11,24); M2(89,98) = M1(11,25); M2(89,99) = M1(11,26); M2(89,100) = M1(11,27); M2(89,101) = M1(11,28); M2(89,102) = M1(11,29); M2(89,103) = M1(11,30); M2(89,104) = M1(11,31); M2(89,105) = M1(11,32); M2(89,106) = M1(11,33); M2(89,107) = M1(11,34); M2(89,108) = M1(11,35); M2(89,109) = M1(11,36); M2(89,110) = M1(11,37); M2(89,111) = M1(11,38); M2(89,112) = M1(11,39); M2(89,113) = M1(11,40); M2(89,114) = M1(11,41); M2(89,115) = M1(11,42); M2(89,116) = M1(11,43); M2(89,117) = M1(11,44); M2(89,118) = M1(11,45); M2(89,119) = M1(11,46); M2(89,120) = M1(11,47); M2(89,121) = M1(11,48); M2(89,122) = M1(11,49); M2(89,123) = M1(11,50); M2(89,124) = M1(11,51); M2(89,125) = M1(11,52); M2(89,126) = M1(11,53); M2(89,127) = M1(11,54); M2(89,128) = M1(11,55); M2(89,129) = M1(11,56); M2(89,130) = M1(11,57); M2(89,131) = M1(11,58); M2(89,132) = M1(11,59); M2(89,133) = M1(11,60); M2(89,134) = M1(11,61); M2(89,135) = M1(11,62); M2(89,136) = M1(11,63); M2(89,137) = M1(11,64); M2(89,138) = M1(11,65); M2(89,139) = M1(11,66); M2(89,140) = M1(11,67); M2(89,141) = M1(11,68); M2(89,142) = M1(11,69); M2(89,143) = M1(11,70); M2(89,144) = M1(11,71); M2(89,145) = M1(11,72); M2(89,146) = M1(11,73); M2(89,147) = M1(11,74); M2(89,148) = M1(11,75); M2(89,149) = M1(11,76); M2(89,150) = M1(11,77); M2(89,151) = M1(11,78); M2(89,152) = M1(11,79); M2(89,153) = M1(11,80); M2(89,154) = M1(11,81); M2(89,155) = M1(11,82); M2(89,156) = M1(11,83); 
M2(90,84) = M1(12,12); M2(90,87) = M1(12,15); M2(90,88) = M1(12,16); M2(90,89) = M1(12,17); M2(90,90) = M1(12,18); M2(90,91) = M1(12,19); M2(90,92) = M1(12,20); M2(90,94) = M1(12,21); M2(90,95) = M1(12,22); M2(90,96) = M1(12,23); M2(90,97) = M1(12,24); M2(90,98) = M1(12,25); M2(90,99) = M1(12,26); M2(90,100) = M1(12,27); M2(90,101) = M1(12,28); M2(90,102) = M1(12,29); M2(90,103) = M1(12,30); M2(90,104) = M1(12,31); M2(90,105) = M1(12,32); M2(90,106) = M1(12,33); M2(90,107) = M1(12,34); M2(90,108) = M1(12,35); M2(90,109) = M1(12,36); M2(90,110) = M1(12,37); M2(90,111) = M1(12,38); M2(90,112) = M1(12,39); M2(90,113) = M1(12,40); M2(90,114) = M1(12,41); M2(90,115) = M1(12,42); M2(90,116) = M1(12,43); M2(90,117) = M1(12,44); M2(90,118) = M1(12,45); M2(90,119) = M1(12,46); M2(90,120) = M1(12,47); M2(90,121) = M1(12,48); M2(90,122) = M1(12,49); M2(90,123) = M1(12,50); M2(90,124) = M1(12,51); M2(90,125) = M1(12,52); M2(90,126) = M1(12,53); M2(90,127) = M1(12,54); M2(90,128) = M1(12,55); M2(90,129) = M1(12,56); M2(90,130) = M1(12,57); M2(90,131) = M1(12,58); M2(90,132) = M1(12,59); M2(90,133) = M1(12,60); M2(90,134) = M1(12,61); M2(90,135) = M1(12,62); M2(90,136) = M1(12,63); M2(90,137) = M1(12,64); M2(90,138) = M1(12,65); M2(90,139) = M1(12,66); M2(90,140) = M1(12,67); M2(90,141) = M1(12,68); M2(90,142) = M1(12,69); M2(90,143) = M1(12,70); M2(90,144) = M1(12,71); M2(90,145) = M1(12,72); M2(90,146) = M1(12,73); M2(90,147) = M1(12,74); M2(90,148) = M1(12,75); M2(90,149) = M1(12,76); M2(90,150) = M1(12,77); M2(90,151) = M1(12,78); M2(90,152) = M1(12,79); M2(90,153) = M1(12,80); M2(90,154) = M1(12,81); M2(90,155) = M1(12,82); M2(90,156) = M1(12,83); 
M2(91,85) = M1(13,13); M2(91,87) = M1(13,15); M2(91,88) = M1(13,16); M2(91,89) = M1(13,17); M2(91,90) = M1(13,18); M2(91,91) = M1(13,19); M2(91,92) = M1(13,20); M2(91,94) = M1(13,21); M2(91,95) = M1(13,22); M2(91,96) = M1(13,23); M2(91,97) = M1(13,24); M2(91,98) = M1(13,25); M2(91,99) = M1(13,26); M2(91,100) = M1(13,27); M2(91,101) = M1(13,28); M2(91,102) = M1(13,29); M2(91,103) = M1(13,30); M2(91,104) = M1(13,31); M2(91,105) = M1(13,32); M2(91,106) = M1(13,33); M2(91,107) = M1(13,34); M2(91,108) = M1(13,35); M2(91,109) = M1(13,36); M2(91,110) = M1(13,37); M2(91,111) = M1(13,38); M2(91,112) = M1(13,39); M2(91,113) = M1(13,40); M2(91,114) = M1(13,41); M2(91,115) = M1(13,42); M2(91,116) = M1(13,43); M2(91,117) = M1(13,44); M2(91,118) = M1(13,45); M2(91,119) = M1(13,46); M2(91,120) = M1(13,47); M2(91,121) = M1(13,48); M2(91,122) = M1(13,49); M2(91,123) = M1(13,50); M2(91,124) = M1(13,51); M2(91,125) = M1(13,52); M2(91,126) = M1(13,53); M2(91,127) = M1(13,54); M2(91,128) = M1(13,55); M2(91,129) = M1(13,56); M2(91,130) = M1(13,57); M2(91,131) = M1(13,58); M2(91,132) = M1(13,59); M2(91,133) = M1(13,60); M2(91,134) = M1(13,61); M2(91,135) = M1(13,62); M2(91,136) = M1(13,63); M2(91,137) = M1(13,64); M2(91,138) = M1(13,65); M2(91,139) = M1(13,66); M2(91,140) = M1(13,67); M2(91,141) = M1(13,68); M2(91,142) = M1(13,69); M2(91,143) = M1(13,70); M2(91,144) = M1(13,71); M2(91,145) = M1(13,72); M2(91,146) = M1(13,73); M2(91,147) = M1(13,74); M2(91,148) = M1(13,75); M2(91,149) = M1(13,76); M2(91,150) = M1(13,77); M2(91,151) = M1(13,78); M2(91,152) = M1(13,79); M2(91,153) = M1(13,80); M2(91,154) = M1(13,81); M2(91,155) = M1(13,82); M2(91,156) = M1(13,83); 
M2(92,86) = M1(14,14); M2(92,87) = M1(14,15); M2(92,88) = M1(14,16); M2(92,89) = M1(14,17); M2(92,90) = M1(14,18); M2(92,91) = M1(14,19); M2(92,92) = M1(14,20); M2(92,94) = M1(14,21); M2(92,95) = M1(14,22); M2(92,96) = M1(14,23); M2(92,97) = M1(14,24); M2(92,98) = M1(14,25); M2(92,99) = M1(14,26); M2(92,100) = M1(14,27); M2(92,101) = M1(14,28); M2(92,102) = M1(14,29); M2(92,103) = M1(14,30); M2(92,104) = M1(14,31); M2(92,105) = M1(14,32); M2(92,106) = M1(14,33); M2(92,107) = M1(14,34); M2(92,108) = M1(14,35); M2(92,109) = M1(14,36); M2(92,110) = M1(14,37); M2(92,111) = M1(14,38); M2(92,112) = M1(14,39); M2(92,113) = M1(14,40); M2(92,114) = M1(14,41); M2(92,115) = M1(14,42); M2(92,116) = M1(14,43); M2(92,117) = M1(14,44); M2(92,118) = M1(14,45); M2(92,119) = M1(14,46); M2(92,120) = M1(14,47); M2(92,121) = M1(14,48); M2(92,122) = M1(14,49); M2(92,123) = M1(14,50); M2(92,124) = M1(14,51); M2(92,125) = M1(14,52); M2(92,126) = M1(14,53); M2(92,127) = M1(14,54); M2(92,128) = M1(14,55); M2(92,129) = M1(14,56); M2(92,130) = M1(14,57); M2(92,131) = M1(14,58); M2(92,132) = M1(14,59); M2(92,133) = M1(14,60); M2(92,134) = M1(14,61); M2(92,135) = M1(14,62); M2(92,136) = M1(14,63); M2(92,137) = M1(14,64); M2(92,138) = M1(14,65); M2(92,139) = M1(14,66); M2(92,140) = M1(14,67); M2(92,141) = M1(14,68); M2(92,142) = M1(14,69); M2(92,143) = M1(14,70); M2(92,144) = M1(14,71); M2(92,145) = M1(14,72); M2(92,146) = M1(14,73); M2(92,147) = M1(14,74); M2(92,148) = M1(14,75); M2(92,149) = M1(14,76); M2(92,150) = M1(14,77); M2(92,151) = M1(14,78); M2(92,152) = M1(14,79); M2(92,153) = M1(14,80); M2(92,154) = M1(14,81); M2(92,155) = M1(14,82); M2(92,156) = M1(14,83); 

Eigen::PartialPivLU< Eigen::Matrix<double,93,93> > lu(M2.block<93,93>(0,0));
Eigen::Matrix<double,93,64> M3 = lu.solve(M2.block<93,64>(0,93));
Action = Eigen::Matrix<double,64,64>::Zero();
Action.row(0) -= M3.block<1,64>(36,0);
Action.row(1) -= M3.block<1,64>(66,0);
Action.row(2) -= M3.block<1,64>(67,0);
Action.row(3) -= M3.block<1,64>(68,0);
Action.row(4) -= M3.block<1,64>(69,0);
Action.row(5) -= M3.block<1,64>(70,0);
Action.row(6) -= M3.block<1,64>(71,0);
Action(7,0) = 1.0;
Action.row(8) -= M3.block<1,64>(79,0);
Action.row(9) -= M3.block<1,64>(80,0);
Action.row(10) -= M3.block<1,64>(81,0);
Action.row(11) -= M3.block<1,64>(82,0);
Action.row(12) -= M3.block<1,64>(83,0);
Action.row(13) -= M3.block<1,64>(84,0);
Action.row(14) -= M3.block<1,64>(85,0);
Action.row(15) -= M3.block<1,64>(86,0);
Action.row(16) -= M3.block<1,64>(87,0);
Action.row(17) -= M3.block<1,64>(88,0);
Action.row(18) -= M3.block<1,64>(89,0);
Action.row(19) -= M3.block<1,64>(90,0);
Action.row(20) -= M3.block<1,64>(91,0);
Action.row(21) -= M3.block<1,64>(92,0);
Action(22,1) = 1.0;
Action(23,2) = 1.0;
Action(24,3) = 1.0;
Action(25,4) = 1.0;
Action(26,5) = 1.0;
Action(27,6) = 1.0;
Action(28,7) = 1.0;
Action(29,14) = 1.0;
Action(30,15) = 1.0;
Action(31,16) = 1.0;
Action(32,17) = 1.0;
Action(33,18) = 1.0;
Action(34,19) = 1.0;
Action(35,20) = 1.0;
Action(36,21) = 1.0;
Action(37,22) = 1.0;
Action(38,23) = 1.0;
Action(39,24) = 1.0;
Action(40,25) = 1.0;
Action(41,26) = 1.0;
Action(42,27) = 1.0;
Action(43,28) = 1.0;
Action(44,34) = 1.0;
Action(45,35) = 1.0;
Action(46,36) = 1.0;
Action(47,37) = 1.0;
Action(48,38) = 1.0;
Action(49,39) = 1.0;
Action(50,40) = 1.0;
Action(51,41) = 1.0;
Action(52,42) = 1.0;
Action(53,43) = 1.0;
Action(54,48) = 1.0;
Action(55,49) = 1.0;
Action(56,50) = 1.0;
Action(57,51) = 1.0;
Action(58,52) = 1.0;
Action(59,53) = 1.0;
Action(60,57) = 1.0;
Action(61,58) = 1.0;
Action(62,59) = 1.0;
Action(63,62) = 1.0;
//columns of Action mean:
// x_3^7 x_2^3*x_3^3 x_1^2*x_3^4 x_1*x_2*x_3^4 x_2^2*x_3^4 x_1*x_3^5 x_2*x_3^5 x_3^6 x_1^5 x_1^4*x_2 x_1^3*x_2^2 x_1^2*x_2^3 x_1*x_2^4 x_2^5 x_1^4*x_3 x_1^3*x_2*x_3 x_1^2*x_2^2*x_3 x_1*x_2^3*x_3 x_2^4*x_3 x_1^3*x_3^2 x_1^2*x_2*x_3^2 x_1*x_2^2*x_3^2 x_2^3*x_3^2 x_1^2*x_3^3 x_1*x_2*x_3^3 x_2^2*x_3^3 x_1*x_3^4 x_2*x_3^4 x_3^5 x_1^4 x_1^3*x_2 x_1^2*x_2^2 x_1*x_2^3 x_2^4 x_1^3*x_3 x_1^2*x_2*x_3 x_1*x_2^2*x_3 x_2^3*x_3 x_1^2*x_3^2 x_1*x_2*x_3^2 x_2^2*x_3^2 x_1*x_3^3 x_2*x_3^3 x_3^4 x_1^3 x_1^2*x_2 x_1*x_2^2 x_2^3 x_1^2*x_3 x_1*x_2*x_3 x_2^2*x_3 x_1*x_3^2 x_2*x_3^2 x_3^3 x_1^2 x_1*x_2 x_2^2 x_1*x_3 x_2*x_3 x_3^2 x_1 x_2 x_3 1
}
