// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_VectorWithMagnitude_HeaderFile
#define _Geom_VectorWithMagnitude_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Geom_VectorWithMagnitude.hxx>

#include <Geom_Vector.hxx>
#include <Standard_Real.hxx>
#include <Handle_Geom_Vector.hxx>
#include <Handle_Geom_Geometry.hxx>
class Standard_ConstructionError;
class gp_Vec;
class gp_Pnt;
class Geom_Vector;
class gp_Trsf;
class Geom_Geometry;



//! Defines a vector with magnitude.
//! A vector with magnitude can have a zero length.
class Geom_VectorWithMagnitude : public Geom_Vector
{

public:

  
  //! Creates a transient copy of V.
  Standard_EXPORT Geom_VectorWithMagnitude(const gp_Vec& V);
  
  //! Creates a vector with three cartesian coordinates.
  Standard_EXPORT Geom_VectorWithMagnitude(const Standard_Real X, const Standard_Real Y, const Standard_Real Z);
  

  //! Creates a vector from the point P1 to the point P2.
  //! The magnitude of the vector is the distance between P1 and P2
  Standard_EXPORT Geom_VectorWithMagnitude(const gp_Pnt& P1, const gp_Pnt& P2);
  
  //! Assigns the values X, Y and Z to the coordinates of this vector.
  Standard_EXPORT   void SetCoord (const Standard_Real X, const Standard_Real Y, const Standard_Real Z) ;
  
  //! Converts the gp_Vec vector V into this vector.
  Standard_EXPORT   void SetVec (const gp_Vec& V) ;
  
  //! Changes the X coordinate of <me>.
  Standard_EXPORT   void SetX (const Standard_Real X) ;
  
  //! Changes the Y coordinate of <me>
  Standard_EXPORT   void SetY (const Standard_Real Y) ;
  
  //! Changes the Z coordinate of <me>.
  Standard_EXPORT   void SetZ (const Standard_Real Z) ;
  
  //! Returns the magnitude of <me>.
  Standard_EXPORT   Standard_Real Magnitude()  const;
  
  //! Returns the square magnitude of <me>.
  Standard_EXPORT   Standard_Real SquareMagnitude()  const;
  

  //! Adds the Vector Other to <me>.
  Standard_EXPORT   void Add (const Handle(Geom_Vector)& Other) ;
  

  //! Adds the vector Other to <me>.
  Standard_EXPORT   Handle(Geom_VectorWithMagnitude) Added (const Handle(Geom_Vector)& Other)  const;
  

  //! Computes the cross product  between <me> and Other
  //! <me> ^ Other.
  Standard_EXPORT   void Cross (const Handle(Geom_Vector)& Other) ;
  

  //! Computes the cross product  between <me> and Other
  //! <me> ^ Other. A new vector is returned.
  Standard_EXPORT   Handle(Geom_Vector) Crossed (const Handle(Geom_Vector)& Other)  const;
  

  //! Computes the triple vector product  <me> ^ (V1 ^ V2).
  Standard_EXPORT   void CrossCross (const Handle(Geom_Vector)& V1, const Handle(Geom_Vector)& V2) ;
  

  //! Computes the triple vector product  <me> ^ (V1 ^ V2).
  //! A new vector is returned.
  Standard_EXPORT   Handle(Geom_Vector) CrossCrossed (const Handle(Geom_Vector)& V1, const Handle(Geom_Vector)& V2)  const;
  
  //! Divides <me> by a scalar.
  Standard_EXPORT   void Divide (const Standard_Real Scalar) ;
  

  //! Divides <me> by a scalar. A new vector is returned.
  Standard_EXPORT   Handle(Geom_VectorWithMagnitude) Divided (const Standard_Real Scalar)  const;
  

  //! Computes the product of the vector <me> by a scalar.
  //! A new vector is returned.
  Standard_EXPORT   Handle(Geom_VectorWithMagnitude) Multiplied (const Standard_Real Scalar)  const;
  

  //! Computes the product of the vector <me> by a scalar.
  Standard_EXPORT   void Multiply (const Standard_Real Scalar) ;
  
  //! Normalizes <me>.
  //!
  //! Raised if the magnitude of the vector is lower or equal to
  //! Resolution from package gp.
  Standard_EXPORT   void Normalize() ;
  
  //! Returns a copy of <me> Normalized.
  //!
  //! Raised if the magnitude of the vector is lower or equal to
  //! Resolution from package gp.
  Standard_EXPORT   Handle(Geom_VectorWithMagnitude) Normalized()  const;
  
  //! Subtracts the Vector Other to <me>.
  Standard_EXPORT   void Subtract (const Handle(Geom_Vector)& Other) ;
  

  //! Subtracts the vector Other to <me>. A new vector is returned.
  Standard_EXPORT   Handle(Geom_VectorWithMagnitude) Subtracted (const Handle(Geom_Vector)& Other)  const;
  
  //! Applies the transformation T to this vector.
  Standard_EXPORT   void Transform (const gp_Trsf& T) ;
  
  //! Creates a new object which is a copy of this vector.
  Standard_EXPORT   Handle(Geom_Geometry) Copy()  const;




  DEFINE_STANDARD_RTTI(Geom_VectorWithMagnitude)

protected:




private: 




};







#endif // _Geom_VectorWithMagnitude_HeaderFile
