// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _math_FRPR_HeaderFile
#define _math_FRPR_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <math_Vector.hxx>
#include <Standard_Real.hxx>
#include <Standard_Integer.hxx>
#include <math_Status.hxx>
#include <Standard_OStream.hxx>
class Standard_DimensionError;
class StdFail_NotDone;
class math_MultipleVarFunctionWithGradient;



//! this class implements the Fletcher-Reeves-Polak_Ribiere minimization
//! algorithm of a function of multiple variables.
//! Knowledge of the function's gradient is required.
class math_FRPR 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Computes FRPR minimization function F from input vector
  //! StartingPoint. The solution F = Fi is found when 2.0 *
  //! abs(Fi - Fi-1) <= Tolerance * (abs(Fi) + abs(Fi-1) +
  //! ZEPS). The maximum number of iterations allowed is given
  //! by NbIterations.
  Standard_EXPORT math_FRPR(math_MultipleVarFunctionWithGradient& F, const math_Vector& StartingPoint, const Standard_Real Tolerance, const Standard_Integer NbIterations = 200, const Standard_Real ZEPS = 1.0e-12);
  
  //! Purpose
  //! Initializes the computation of the minimum of F.
  //! Warning
  //! A call to the Perform method must be made after this
  //! initialization to compute the minimum of the function.
  Standard_EXPORT math_FRPR(math_MultipleVarFunctionWithGradient& F, const Standard_Real Tolerance, const Standard_Integer NbIterations = 200, const Standard_Real ZEPS = 1.0e-12);
  
  Standard_EXPORT virtual   void Delete() ;
Standard_EXPORT virtual ~math_FRPR(){Delete();}
  
  //! Use this method after a call to the initialization constructor
  //! to compute the minimum of function F.
  //! Warning
  //! The initialization constructor must have been called before
  //! the Perform method is called
  Standard_EXPORT   void Perform (math_MultipleVarFunctionWithGradient& F, const math_Vector& StartingPoint) ;
  

  //! The solution F = Fi is found when :
  //! 2.0 * abs(Fi - Fi-1) <= Tolerance * (abs(Fi) + abs(Fi-1)) + ZEPS.
  //! The maximum number of iterations allowed is given by NbIterations.
  Standard_EXPORT virtual   Standard_Boolean IsSolutionReached (math_MultipleVarFunctionWithGradient& F) ;
  
  //! Returns true if the computations are successful, otherwise returns false.
      Standard_Boolean IsDone()  const;
  
  //! returns the location vector of the minimum.
  //! Exception NotDone is raised if the minimum was not found.
     const  math_Vector& Location()  const;
  
  //! outputs the location vector of the minimum in Loc.
  //! Exception NotDone is raised if the minimum was not found.
  //! Exception DimensionError is raised if the range of Loc is not
  //! equal to the range of the StartingPoint.
      void Location (math_Vector& Loc)  const;
  
  //! returns the value of the minimum.
  //! Exception NotDone is raised if the minimum was not found.
      Standard_Real Minimum()  const;
  
  //! returns the gradient vector at the minimum.
  //! Exception NotDone is raised if the minimum was not found.
     const  math_Vector& Gradient()  const;
  
  //! outputs the gradient vector at the minimum in Grad.
  //! Exception NotDone is raised if the minimum was not found.
  //! Exception DimensionError is raised if the range of Grad is not
  //! equal to the range of the StartingPoint.
      void Gradient (math_Vector& Grad)  const;
  
  //! returns the number of iterations really done during the
  //! computation of the minimum.
  //! Exception NotDone is raised if the minimum was not found.
      Standard_Integer NbIterations()  const;
  
  //! Prints on the stream o information on the current state
  //! of the object.
  //! Is used to redefine the operator <<.
  Standard_EXPORT   void Dump (Standard_OStream& o)  const;




protected:



  math_Vector TheLocation;
  math_Vector TheGradient;
  Standard_Real TheMinimum;
  Standard_Real PreviousMinimum;
  Standard_Real XTol;
  Standard_Real EPSZ;


private:



  Standard_Boolean Done;
  Standard_Integer Iter;
  Standard_Integer State;
  math_Status TheStatus;
  Standard_Integer Itermax;


};


#include <math_FRPR.lxx>





#endif // _math_FRPR_HeaderFile
