// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepBuilderAPI_Sewing_HeaderFile
#define _BRepBuilderAPI_Sewing_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_BRepBuilderAPI_Sewing_HeaderFile
#include <Handle_BRepBuilderAPI_Sewing.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopTools_IndexedDataMapOfShapeShape_HeaderFile
#include <TopTools_IndexedDataMapOfShapeShape.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopTools_IndexedMapOfShape_HeaderFile
#include <TopTools_IndexedMapOfShape.hxx>
#endif
#ifndef _TopTools_IndexedDataMapOfShapeListOfShape_HeaderFile
#include <TopTools_IndexedDataMapOfShapeListOfShape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
#ifndef _Handle_BRepTools_ReShape_HeaderFile
#include <Handle_BRepTools_ReShape.hxx>
#endif
#ifndef _TopTools_MapOfShape_HeaderFile
#include <TopTools_MapOfShape.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_Message_ProgressIndicator_HeaderFile
#include <Handle_Message_ProgressIndicator.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
class BRepTools_ReShape;
class Standard_OutOfRange;
class Standard_NoSuchObject;
class TopoDS_Shape;
class Message_ProgressIndicator;
class TopoDS_Edge;
class TopTools_ListOfShape;
class TopoDS_Face;
class TopTools_SequenceOfShape;
class TColStd_IndexedMapOfInteger;
class TColStd_SequenceOfInteger;
class Geom_Surface;
class TopLoc_Location;
class TopTools_MapOfShape;
class TColStd_Array1OfBoolean;
class TColStd_Array1OfReal;
class Geom2d_Curve;
class TColgp_Array1OfPnt;
class Geom_Curve;
class TopTools_IndexedMapOfShape;
class TColStd_SequenceOfReal;


//! Provides methods to <br>
//! <br>
//!          - identify possible contigous boundaries (for control <br>
//!            afterwards) <br>
//! <br>
//!          - assemble contigous shapes into one shape. <br>
//!            Only manifold shapes will be found. Sewing will not <br>
//!            be done in case of multiple edges. <br>
//! <br>
//!          For sewing, use this function as following: <br>
//!            - create an empty object <br>
//!                - default tolerance 1.E-06 <br>
//!                - with face analysis on <br>
//!                - with sewing operation on <br>
//!                - set the cutting option as you need (default True) <br>
//!            - define a tolerance <br>
//!            - add shapes to be sewed -> Add <br>
//!            - compute -> Perfom <br>
//!            - output the resulted shapes <br>
//!            - output free edges if necessary <br>
//!            - output multiple edges if necessary <br>
//!            - output the problems if any <br>
class BRepBuilderAPI_Sewing : public MMgt_TShared {

public:

  //! Creates an object with <br>
//!          tolerance of connexity <br>
//!          option for sewing (if false only control) <br>
//!          option for analysis of degenerated shapes <br>
//!          option for cutting of free edges. <br>
//!          option for non manifold processing <br>
  Standard_EXPORT   BRepBuilderAPI_Sewing(const Standard_Real tolerance = 1.0e-06,const Standard_Boolean option1 = Standard_True,const Standard_Boolean option2 = Standard_True,const Standard_Boolean option3 = Standard_True,const Standard_Boolean option4 = Standard_False);
  //! initialize the parameters if necessary <br>
  Standard_EXPORT     void Init(const Standard_Real tolerance = 1.0e-06,const Standard_Boolean option1 = Standard_True,const Standard_Boolean option2 = Standard_True,const Standard_Boolean option3 = Standard_True,const Standard_Boolean option4 = Standard_False) ;
  //! Loades the context shape. <br>
  Standard_EXPORT     void Load(const TopoDS_Shape& shape) ;
  //! Defines the shapes to be sewed or controlled <br>
  Standard_EXPORT     void Add(const TopoDS_Shape& shape) ;
  //! Computing <br>
//!          thePI - progress indicator of algorithm <br>
  Standard_EXPORT     void Perform(const Handle(Message_ProgressIndicator)& thePI = 0) ;
  //! Gives the sewed shape <br>
//!          a null shape if nothing constructed <br>
//!          may be a face, a shell, a solid or a compound <br>
  Standard_EXPORT    const TopoDS_Shape& SewedShape() const;
  //! set context <br>
  Standard_EXPORT     void SetContext(const Handle(BRepTools_ReShape)& theContext) ;
  //! return context <br>
  Standard_EXPORT    const Handle_BRepTools_ReShape& GetContext() const;
  //! Gives the number of free edges (edge shared by one face) <br>
  Standard_EXPORT     Standard_Integer NbFreeEdges() const;
  //! Gives each free edge <br>
  Standard_EXPORT    const TopoDS_Edge& FreeEdge(const Standard_Integer index) const;
  //! Gives the number of multiple edges <br>
//!          (edge shared by more than two faces) <br>
  Standard_EXPORT     Standard_Integer NbMultipleEdges() const;
  //! Gives each multiple edge <br>
  Standard_EXPORT    const TopoDS_Edge& MultipleEdge(const Standard_Integer index) const;
  //! Gives the number of contigous edges (edge shared by two faces) <br>
  Standard_EXPORT     Standard_Integer NbContigousEdges() const;
  //! Gives each contigous edge <br>
  Standard_EXPORT    const TopoDS_Edge& ContigousEdge(const Standard_Integer index) const;
  //! Gives the sections (edge) belonging to a contigous edge <br>
  Standard_EXPORT    const TopTools_ListOfShape& ContigousEdgeCouple(const Standard_Integer index) const;
  //! Indicates if a section is bound (before use SectionToBoundary) <br>
  Standard_EXPORT     Standard_Boolean IsSectionBound(const TopoDS_Edge& section) const;
  //! Gives the original edge (free boundary) which becomes the <br>
//!          the section. Remember that sections constitute  common edges. <br>
//!          This imformation is important for control because with <br>
//!          original edge we can find the surface to which the section <br>
//!          is attached. <br>
  Standard_EXPORT    const TopoDS_Edge& SectionToBoundary(const TopoDS_Edge& section) const;
  //! Gives the number of degenerated shapes <br>
  Standard_EXPORT     Standard_Integer NbDegeneratedShapes() const;
  //! Gives each degenerated shape <br>
  Standard_EXPORT    const TopoDS_Shape& DegeneratedShape(const Standard_Integer index) const;
  //! Indicates if a input shape is degenerated <br>
  Standard_EXPORT     Standard_Boolean IsDegenerated(const TopoDS_Shape& shape) const;
  //! Indicates if a input shape has been modified <br>
  Standard_EXPORT     Standard_Boolean IsModified(const TopoDS_Shape& shape) const;
  //! Gives a modifieded shape <br>
  Standard_EXPORT    const TopoDS_Shape& Modified(const TopoDS_Shape& shape) const;
  //! Indicates if a input subshape has been modified <br>
  Standard_EXPORT     Standard_Boolean IsModifiedSubShape(const TopoDS_Shape& shape) const;
  //! Gives a modifieded subshape <br>
  Standard_EXPORT     TopoDS_Shape ModifiedSubShape(const TopoDS_Shape& shape) const;
  //! print the informations <br>
  Standard_EXPORT     void Dump() const;
  //! Gives the number of deleted faces (faces smallest than tolerance) <br>
  Standard_EXPORT     Standard_Integer NbDeletedFaces() const;
  //! Gives each deleted face <br>
  Standard_EXPORT    const TopoDS_Face& DeletedFace(const Standard_Integer index) const;
  //! Gives a modified shape <br>
  Standard_EXPORT     TopoDS_Face WhichFace(const TopoDS_Edge& theEdg,const Standard_Integer index = 1) const;
  //! Gets same parameter mode. <br>
        Standard_Boolean SameParameterMode() const;
  //! Sets same parameter mode. <br>
        void SetSameParameterMode(const Standard_Boolean SameParameterMode) ;
  //! Gives set tolerance. <br>
        Standard_Real Tolerance() const;
  //! Sets tolerance <br>
        void SetTolerance(const Standard_Real theToler) ;
  //! Gives set min tolerance. <br>
        Standard_Real MinTolerance() const;
  //! Sets min tolerance <br>
        void SetMinTolerance(const Standard_Real theMinToler) ;
  //! Gives set max tolerance <br>
        Standard_Real MaxTolerance() const;
  //! Sets max tolerance. <br>
        void SetMaxTolerance(const Standard_Real theMaxToler) ;
  //! Returns mode for sewing faces By default - true. <br>
        Standard_Boolean FaceMode() const;
  //! Sets mode for sewing faces By default - true. <br>
        void SetFaceMode(const Standard_Boolean theFaceMode) ;
  //! Returns mode for sewing floating edges By default - false. <br>
        Standard_Boolean FloatingEdgesMode() const;
  //! Sets mode for sewing floating edges By default - false. <br>//! Returns mode for cutting floating edges By default - false. <br>//! Sets mode for cutting floating edges By default - false. <br>
        void SetFloatingEdgesMode(const Standard_Boolean theFloatingEdgesMode) ;
  //! Returns mode for accounting of local tolerances <br>
//!          of edges and vertices during of merging. <br>
        Standard_Boolean LocalTolerancesMode() const;
  //! Sets mode for accounting of local tolerances <br>
//!          of edges and vertices during of merging <br>
//!          in this case WorkTolerance = myTolerance + tolEdge1+ tolEdg2; <br>
        void SetLocalTolerancesMode(const Standard_Boolean theLocalTolerancesMode) ;
  //! Sets mode for non-manifold sewing. <br>
        void SetNonManifoldMode(const Standard_Boolean theNonManifoldMode) ;
  //! Gets mode for non-manifold sewing. <br>
//! <br>
//! INTERNAL FUCTIONS --- <br>
//! <br>
        Standard_Boolean NonManifoldMode() const;




  DEFINE_STANDARD_RTTI(BRepBuilderAPI_Sewing)

protected:

  //! Performs cutting of sections <br>
//!          thePI - progress indicator of processing <br>
  Standard_EXPORT     void Cutting(const Handle(Message_ProgressIndicator)& thePI = 0) ;
  
  Standard_EXPORT     void Merging(const Standard_Boolean passage,const Handle(Message_ProgressIndicator)& thePI = 0) ;
  
  Standard_EXPORT     Standard_Boolean IsMergedClosed(const TopoDS_Edge& Edge1,const TopoDS_Edge& Edge2,const TopoDS_Face& fase) const;
  
  Standard_EXPORT     Standard_Boolean FindCandidates(TopTools_SequenceOfShape& seqSections,TColStd_IndexedMapOfInteger& mapReference,TColStd_SequenceOfInteger& seqCandidates,TColStd_SequenceOfInteger& seqOrientations) ;
  
  Standard_EXPORT     void AnalysisNearestEdges(const TopTools_SequenceOfShape& sequenceSec,TColStd_SequenceOfInteger& seqIndCandidate,TColStd_SequenceOfInteger& seqOrientations,const Standard_Boolean evalDist = Standard_True) ;
  //! Merged nearest edges. <br>
  Standard_EXPORT     Standard_Boolean MergedNearestEdges(const TopoDS_Shape& edge,TopTools_SequenceOfShape& SeqMergedEdge,TColStd_SequenceOfInteger& SeqMergedOri) ;
  
  Standard_EXPORT     void EdgeProcessing(const Handle(Message_ProgressIndicator)& thePI = 0) ;
  
  Standard_EXPORT     void CreateOutputInformations() ;
  //! Defines if surface is U closed. <br>
  Standard_EXPORT   virtual  Standard_Boolean IsUClosedSurface(const Handle(Geom_Surface)& surf,const TopoDS_Shape& theEdge,const TopLoc_Location& theloc) const;
  //!Defines if surface is V closed. <br>
  Standard_EXPORT   virtual  Standard_Boolean IsVClosedSurface(const Handle(Geom_Surface)& surf,const TopoDS_Shape& theEdge,const TopLoc_Location& theloc) const;
  
//!          This method is called from Perform only <br>
//!          thePI - progress indicator of processing <br>
  Standard_EXPORT   virtual  void FaceAnalysis(const Handle(Message_ProgressIndicator)& thePI = 0) ;
  
//!          This method is called from Perform only <br>
  Standard_EXPORT   virtual  void FindFreeBoundaries() ;
  
//!          This method is called from Perform only <br>
//!          thePI - progress indicator of processing <br>
  Standard_EXPORT   virtual  void VerticesAssembling(const Handle(Message_ProgressIndicator)& thePI = 0) ;
  
//!          This method is called from Perform only <br>
  Standard_EXPORT   virtual  void CreateSewedShape() ;
  //! Get wire from free edges. <br>
//!          This method is called from EdgeProcessing only <br>
  Standard_EXPORT   virtual  void GetFreeWires(TopTools_MapOfShape& MapFreeEdges,TopTools_SequenceOfShape& seqWires) ;
  
//!          This method is called from MergingOfSections only <br>
  Standard_EXPORT   virtual  void EvaluateAngulars(TopTools_SequenceOfShape& sequenceSec,TColStd_Array1OfBoolean& secForward,TColStd_Array1OfReal& tabAng,const Standard_Integer indRef) const;
  
//!          This method is called from MergingOfSections only <br>
  Standard_EXPORT   virtual  void EvaluateDistances(TopTools_SequenceOfShape& sequenceSec,TColStd_Array1OfBoolean& secForward,TColStd_Array1OfReal& tabAng,TColStd_Array1OfReal& arrLen,TColStd_Array1OfReal& tabMinDist,const Standard_Integer indRef) const;
  
//!          This method is called from SameParameterEdge only <br>
  Standard_EXPORT   virtual  Handle_Geom2d_Curve SameRange(const Handle(Geom2d_Curve)& CurvePtr,const Standard_Real FirstOnCurve,const Standard_Real LastOnCurve,const Standard_Real RequestedFirst,const Standard_Real RequestedLast) const;
  
//!          This method is called from SameParameterEdge only <br>
  Standard_EXPORT   virtual  void SameParameter(const TopoDS_Edge& edge) const;
  
//!          This method is called from Merging only <br>
  Standard_EXPORT   virtual  TopoDS_Edge SameParameterEdge(const TopoDS_Shape& edge,const TopTools_SequenceOfShape& seqEdges,const TColStd_SequenceOfInteger& seqForward,TopTools_MapOfShape& mapMerged,const Handle(BRepTools_ReShape)& locReShape) ;
  
//!          This method is called from Merging only <br>
  Standard_EXPORT   virtual  TopoDS_Edge SameParameterEdge(const TopoDS_Edge& edge1,const TopoDS_Edge& edge2,const TopTools_ListOfShape& listFaces1,const TopTools_ListOfShape& listFaces2,const Standard_Boolean secForward,Standard_Integer& whichSec,const Standard_Boolean firstCall = Standard_True) ;
  //! Projects points on curve <br>
//!          This method is called from Cutting only <br>
  Standard_EXPORT     void ProjectPointsOnCurve(const TColgp_Array1OfPnt& arrPnt,const Handle(Geom_Curve)& Crv,const Standard_Real first,const Standard_Real last,TColStd_Array1OfReal& arrDist,TColStd_Array1OfReal& arrPara,TColgp_Array1OfPnt& arrProj,const Standard_Boolean isConsiderEnds) const;
  //! Creates cutting vertices on projections <br>
//!          This method is called from Cutting only <br>
  Standard_EXPORT   virtual  void CreateCuttingNodes(const TopTools_IndexedMapOfShape& MapVert,const TopoDS_Shape& bound,const TopoDS_Shape& vfirst,const TopoDS_Shape& vlast,const TColStd_Array1OfReal& arrDist,const TColStd_Array1OfReal& arrPara,const TColgp_Array1OfPnt& arrPnt,TopTools_SequenceOfShape& seqNode,TColStd_SequenceOfReal& seqPara) ;
  //! Performs cutting of bound <br>
//!          This method is called from Cutting only <br>
  Standard_EXPORT   virtual  void CreateSections(const TopoDS_Shape& bound,const TopTools_SequenceOfShape& seqNode,const TColStd_SequenceOfReal& seqPara,TopTools_ListOfShape& listEdge) ;
  //! Makes all edges from shape same parameter <br>
//!          if SameParameterMode is equal to Standard_True <br>
//!          This method is called from Perform only <br>
  Standard_EXPORT   virtual  void SameParameterShape() ;

Standard_Real myTolerance;
Standard_Boolean mySewing;
Standard_Boolean myAnalysis;
Standard_Boolean myCutting;
Standard_Boolean myNonmanifold;
TopTools_IndexedDataMapOfShapeShape myOldShapes;
TopoDS_Shape mySewedShape;
TopTools_IndexedMapOfShape myDegenerated;
TopTools_IndexedMapOfShape myFreeEdges;
TopTools_IndexedMapOfShape myMultipleEdges;
TopTools_IndexedDataMapOfShapeListOfShape myContigousEdges;
TopTools_DataMapOfShapeShape myContigSecBound;
Standard_Integer myNbShapes;
Standard_Integer myNbVertices;
Standard_Integer myNbEdges;
TopTools_IndexedDataMapOfShapeListOfShape myBoundFaces;
TopTools_DataMapOfShapeListOfShape myBoundSections;
TopTools_DataMapOfShapeShape mySectionBound;
TopTools_IndexedDataMapOfShapeShape myVertexNode;
TopTools_IndexedDataMapOfShapeShape myVertexNodeFree;
TopTools_DataMapOfShapeListOfShape myNodeSections;
TopTools_DataMapOfShapeListOfShape myCuttingNode;
TopTools_IndexedMapOfShape myLittleFace;
TopoDS_Shape myShape;
Handle_BRepTools_ReShape myReShape;


private: 


Standard_Boolean myFaceMode;
Standard_Boolean myFloatingEdgesMode;
Standard_Boolean mySameParameterMode;
Standard_Boolean myLocalToleranceMode;
Standard_Real myMinTolerance;
Standard_Real myMaxTolerance;
TopTools_MapOfShape myMergedEdges;


};


#include <BRepBuilderAPI_Sewing.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
