import argparse, ConfigParser

class UsageOrConfigError(Exception):
    pass

class UsageError(Exception):
    pass

class ConfigError(Exception):
    def __init__(self, config_file, config_section, msg):
	Exception.__init__(self,
		'In %s, section %s or DEFAULT: %s'
		% (config_file, config_section, msg))
	self.config_file = config_file
	self.config_section = config_section

class ConfigArgumentParser(argparse.ArgumentParser):

    def error(self, message):
	raise UsageError(message)

    def configure_defaults(self, config, defaults_section):
	"""Merge those configurations files in the list `config_paths` which
	exist and return the corresponding `ConfigParser` object.  Later files
	take presedence over former.  Variables from `defaults_section` will be
	used as defaults for the argument parser options."""

	if not isinstance(defaults_section, list):
	    defaults_section = [defaults_section]
	for section in defaults_section:
	    if config.has_section(section):
		defaults = [(var, config.get(section, var))
			    for var in config.options(section)]
		self.set_defaults(**dict(defaults))
		break

	# TODO: Validation can be refined. Ideally we should check each config
	# variable individually and report a) the variable name rather than
	# the option name and b) the line number of the bad value.
	try:
	    self.parse_args()
	except argparse.ArgumentTypeError, err:
	    raise ConfigError(
		    'The configuration corresponding to a command-line '
		    'option failed: %s' % err)
