# io.js TC Meeting 2014-12-17

## Links

* **Google Hangouts Video**: https://www.youtube.com/watch?v=7s-VJLQEWXg
* **GitHub Issue**: https://github.com/nodejs/io.js/issues/163
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1PoqGfxpfTFKv5GcKmhMM2siZpPjT9Ba-ooBi-ZbYNi0

## Agenda

Extracted from https://github.com/nodejs/io.js/labels/tc-agenda prior to meeting.

* Bundle tick processor with iojs #158 https://github.com/nodejs/io.js/issues/158
* Release Cycle Proposal #168 https://github.com/nodejs/io.js/issues/168
* Module search security #176 https://github.com/nodejs/io.js/pull/176 
* Dealing with feature requests 

## Review of last meeting

* Move readable-stream to io.js and flip authoritative flow of code, docs and issues
* Soft deprecation of domains, accept PR #15 as last feature addition
* Caine, discussion continued on GitHub
* Project name is “io.js”, binary name is “iojs”
* Extending options from prototype, discussion continued on GitHub
* Promises statement for issue #11
* Working with nvm, etc.

## Minutes

### Present

* Bert (TC)
* Chris (TC)
* Trevor (TC)
* Isaac (TC)
* Rod (build, facilitator)

### Bundle tick processor with iojs #158 

https://github.com/nodejs/io.js/issues/158

* Bert: important because it’s tied to the version of V8, not practical to put it in npm because one is needed for each version
* Isaac: this is minimal and shouldn’t set a standard for just adding more stuff to core (i.e. keep core minimal), so +1

+1 from Isaac, +1 from Bert, **no disagreement amongst group, consensus has been reached on bundling a tick processor with releases.**

### Release Cycle Proposal #168 

https://github.com/nodejs/io.js/issues/168

* Bert & Isaac discussed how this feeds into the ability to have frequent releases. Discussed semver plays into this.
* Rod: consensus seems to be around having stability, predictability, lead-time but more frequent releases.
* **Bert: Move discussion to #168. Still premature to discuss here.**

### Module search security #176

https://github.com/nodejs/io.js/pull/176 

* Limiting node_modules search path to $HOME as a top-level
* Isaac ~ -1 on this because EACCES already happens when you don’t have permission
* Isaac and Bert bikeshedded Windows C:\ writability and security on Windows. i.e. if someone can install code on a shared system above where a node application is running (e.g. C:\) then you could have untrusted code run by your application.
* Isaac: this PR is only addressing projects running in the home directory.
* Rod: module system is locked-down, TC needs to come to consensus that this is a _security_ issue and therefore warrants breaking it.
* Chris: `useradd node_modules` is a situation this could be a problem
* Isaac: not convinced this is a security problem, even the `useradd` situation requires root access on a system.
* Bert: this is an academic issue, it may _feel_ wrong but that doesn’t mean it’s strictly a security issue.
* Isaac: proposed the issue be closed as not a security issue.
* **No consensus that this is a security issue. Move discussion back to GitHub, potentially close issue, potentially bringing discussion back here. Encourage users to bring examples of real problems.**


### Dealing with feature requests

* Bert: asking for discussion about what to do with feature requests that come up but aren’t clearly something that are wanted.
* Bert: should we put a time limit on feature requests? Would like some guidelines for how to deal with these.
* Chris: have already been putting a 4-6 day window before closing them. If there is no code then it’s easier to close. If there is code then there could be more discussion.
* Isaac: this is a broader problem about the roadmap-setting process.
* Rod & Isaac: It’s up to someone on TC (or elsewhere) to start coming up with a roadmap, or at least start the discussion.
* **Agreed to start a GitHub discussion on roadmap and soliciting feedback from the community.**
* Rod: in an open model, it’s up to TC and those with commit access to take the initiative to just close things, given enough warning and chance for discussion and better arguments.
* Isaac: builtins (like Blog of FileReader) are TC39 / WhatWG groups out there that are doing this at the language & V8 level and we pull from there. It should be straightforward to close those issues.
* Bert: the roadmap shouldn’t be about locking down the dev process and tightly limiting scope of what’s added.
* **Agreed that feedback to all contributors (including TC), regarding closing issues: close issues that are instinctively bad and worth closing (close can be undone), anything potentially controversial can be flagged with a “will close” but give ~ 1 week for discussion, disagreement, lobbying etc.**


### Logos

* **Agreed that the release is the only _technical_ blocker from the TC’s perspective to a logo, so deferring discussion till then. Encourage interested parties from discussing this further on GitHub issue #37.**

### Next meeting

* Bert proposed 2014-12-30 as next meeting time
