# Jasmine Core 5.0.0-alpha.0 Release Notes

## Summary

This release primarily adds support for parallel execution via the `jasmine`
package. Please see its release notes and the 
[parallel documentation](https://jasmine.github.io/tutorials/running_specs_in_parallel)
for more information. Additionally, this release cleans up a few outdated
interfaces.

This is a pre-release for a major version. It contains breaking changes, and
there may be further breaking changes between this release and the final 5.0.0
release.

## Breaking changes

* Use addEventListener in browsers rather than setting window.onerror

  This simplifies error handling in browsers, makes Jasmine's own integration
  tests easier to debug, and provides stack traces for more unhandled
  exceptions. However, some browsers will provide less error information when
  the error comes from a file:// URL. Additionally, Jasmine will no longer
  override existing onerror handlers, and setting window.onerror will no longer
  override Jasmine's global error handling. (Use `jasmine.spyOnGlobalErrors`
  instead.)

* Made Env#execute async
* Env#execute no longer takes a callback
* The `boot` function exported by the core module returns the same object
  every time it's called.
* Removed node_boot.js. Use the exported `boot` function instead.

### Changes to supported environments

The following previously supported environments are no longer supported:

* Node <16.14
* Safari 14
* Firefox 91

Although this release may still work in some of those environments, we no
longer test against them and won't try to maintain compatibility with them in
future releases.

## New features

* Support for parallel execution in Node.js using the `jasmine` package

## Bug fixes

* The global error handler is uninstalled at the end of env execution.

## Supported environments

jasmine-core 5.0.0-alpha.0 has been tested in the following environments.

| Environment       | Supported versions |
|-------------------|--------------------|
| Node              | 16.14+,         18 |
| Safari            | 15-16              |
| Chrome            | 111                |
| Firefox           | 102, 111           |
| Edge              | 111                |


------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
