/*
 * Copyright (c) 2002, 2015 Jens Keiner, Stefan Kunis, Daniel Potts
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* $Id: simple_test.c 3509 2010-05-25 19:00:59Z keiner $ */

/* Standard headers. */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <complex.h>

#include "nfft3.h"
#include "infft.h"

static const R K4PI = K(12.56637061435917295385057353311801153678867759750042328389977837);

static const C f_hat[] =
{
  K(+0.5187910942199021924670496864804890704907465499076256014447361523) + K(+0.6861600946447911504923623532492162295422902396261547897329701272) * I,
  K(+0.8299196587702874048010066719687445427471337596497385288106773952) + K(-0.02336058203118977121512282256807911385554800846496188908300112029) * I,
  K(+0.2535610670457191642528195065724571230354782789119009392027906057) + K(-0.1952860327539096211791504860394444113670749093775417390039946022) * I,
  K(+0.8233146960103414274127930176425000268301469075510563344651605858) + K(-0.7401098161688255502164746480545707764069206396799531644428564878) * I,
  K(-0.9370479052931367101198820670270669249226036578733792472697887507) + K(+0.3685564581950387076305026464189030846263599859858994129020066626) * I,
  K(-0.5479875123363595835374373526131091671873251881279257144872344302) + K(-0.8064962606521500993462132489218952694760112802571794702866584276) * I,
  K(-0.3634232442807936931624532540997838599798713141491939821000665081) + K(-0.3012098209410735075489314869655329185447261365231500429319375168) * I,
  K(+0.7486556295464791390836878775840189020740705622417049999674216015) + K(+0.8092717517815122182830506236680668593679458648863592463284877158) * I,
  K(+0.0009093903742935279286611207900312913510273633514297437035778646867) + K(+0.8858293723046408467271407759245387811930851335020497268649538649) * I,
  K(+0.9024177599735620403183452242307173243589786099607003550348586779) + K(-0.3933811326460676205778615884005930742981154275458447360476424035) * I,
  K(+0.9141196146206810164846325531026988464164699058019777024111766505) + K(-0.5285651434877149120835011027630489239500301360038060588044365774) * I,
  K(-0.5858650845941639182516996186354812878252353014294256407338444282) + K(-0.8769736704686337617047102854803171611286915290307315235905955121) * I,
  K(+0.4736963350111976186097470904817340923188432410665667194320025691) + K(-0.1654956647152494517915882898122931602476701407106262094590785936) * I,
  K(+0.5979889069001015977889008233031918281253015839905385628885202230) + K(-0.2428696150109180254718295909047837563170666313129681389449269599) * I,
  K(+0.3142814446272417764813001639622132712860837183978526968577292864) + K(+0.1695443901301601562898453902673989624014693466214718940304827046) * I,
  K(+0.6476380074600053161359735870516252894326207339599861557426300418) + K(-0.9436025599423521695803140114586216666764288471433399221579126183) * I,
  K(-0.4181119723675847875057529730102122168041484011101782058226600312) + K(-0.6769128004489706239581619953954373698027873909606056137650781949) * I,
  K(+0.09454273770979170139206702616095394905974748643104775927554334832) + K(-0.8031447358139460619025200119291896009964220703625052024693549794) * I,
  K(-0.1496852056702927390360963880918193332263215234784601547957102818) + K(-0.2465307119481016189305526321857929056019791231535433593985116127) * I,
  K(-0.8896640940516886042683882550952119864912360275813168010228729265) + K(-0.7093638666894762905985568614336435539411395335703532799676707812) * I,
  K(+0.5448147841191301808090416204974602555736045387311502776127400733) + K(+0.04773226368541670743234606333319675309009309829557419204956611747) * I,
  K(+0.3906623911045387616209050198213951350167471866556469408974539601) + K(+0.6530762949186713747249940972639378357760787671935888322202906629) * I,
  K(-0.7101207883055357689932327859702284881788356394867546677972228081) + K(-0.5670022197932760837876426626051311218184692799044329839453349403) * I,
  K(+0.4065818372281019562419603361128888573211367815651883990736400313) + K(-0.3444216620060470899537486402571426138414915899245522869750191290) * I,
  K(+0.9226910849861955478394153888046094621630905239739427135672438219) + K(-0.3230025171084525875517660989291029775162198061465120450542978347) * I,
  K(+0.4452600526859432609778739319201135773536041336118662117358520817) + K(+0.7483099382556801857092978951844696847252788536446113141425895447) * I,
  K(-0.6467969941538605750524580688993145346472280815603254656083297236) + K(+0.4074494226735861776186423971831734423006513088720827445983674769) * I,
  K(-0.9095197883419727942980944738755914705719172168004082992075269478) + K(+0.8000522902303118445357579174836576277986412030392198738163824086) * I,
  K(-0.07609123206670422549589525297331010700546770724805390317619462215) + K(+0.5270135994575522059042031033407677565934525903791947742539445358) * I,
  K(-0.9751441225583376724603163808883725680469390969844274595460015624) + K(+0.1739954655703675885285071491784308233074263456350253032404141084) * I,
  K(+0.6639368842673528596272213486339934031143511056154451799015992522) + K(+0.6132568935934195578623142941529886747904646484832305968651301125) * I,
  K(-0.1802738636294117951998369685954592418628892032366140096842936431) + K(+0.7945644531144080212384322239965057632026769816230755173429795175) * I,
  K(+0.8193046974592595795104602365336356697581003476586701211747960545) + K(+0.7108200524533145115578075590900843641841786217877993895886555926) * I,
  K(-0.9145344594297042461495955392910633438857045496689126651115701903) + K(-0.4856631207165151881100381685038827674855193892217286933791300367) * I,
  K(+0.6877299089666235086488767431293637153759530009318287385058772064) + K(-0.5169313560293359578565926512675384042867578894260952246005758403) * I,
  K(+0.1596955867102727027433905154323718972532840563592043694648514857) + K(-0.5414178105510978309997267530493278846536977387727148145073744332) * I,
  K(-0.6747811337730093721288652045217423473732159901058759137085916899) + K(-0.8568631967414843337898082790965759873205758343817229919875694762) * I,
  K(+0.3646996714026809486792387516642745646617772828068105538716909459) + K(-0.5596928237741893456842894666766240321383310338488863206674898258) * I,
  K(+0.02061456438338309690140420354070795194329230512051279764558585385) + K(+0.4843548982452669513652677517470763467966440138936036906819700508) * I,
  K(+0.4275342076161847160624191184358062349668656354373351747732476501) + K(-0.5469573055604421909717854509073780452329807750122965576626535377) * I,
  K(+0.2431137168992355991882082288081185133603218012046746536220860429) + K(-0.9099033864847763514006197136868471784620451007061579557349004907) * I,
  K(+0.5888672211719146796501220696195063737607418028378171667223451331) + K(+0.01223270372896518193892191175649759920359095035177497113125844886) * I,
  K(+0.7421681919023358119961858280966848629653951858251681679099331550) + K(+0.3866521986820460918541165179335586839781083300360589211793629832) * I,
  K(-0.3325456363716838325521581600919102851100075349555949460650274647) + K(-0.1197676216436940259833561586516589777917740566874733594015648539) * I,
  K(+0.8019955191519129936697740919308824177602521906827251299147985284) + K(-0.8681668300076211599701871823454154203240662136248927050440108239) * I,
  K(+0.7637744170783317814837046336077807564594153641230798746234243376) + K(+0.9643462995015233247947929845440682791221398324164413372112487927) * I,
  K(-0.2310756097528814044952912028822037271275326335305930507654606435) + K(+0.1388641415461817265177948721257736172577538351223719324072921994) * I,
  K(-0.9655438117840325593283872532033553603159715502760342015667627005) + K(-0.6296668510321843295478076219946807945994177892014326799427540979) * I,
  K(+0.6675693886116659542655946067623955549591151354723777236171665728) + K(-0.1936281154562724107109611570159692227865515119179130225354689873) * I,
  K(-0.7893288322268184436134524007666926693931762801678871465861418609) + K(-0.7328379463303288477561867792131077403156498026289316258795655340) * I,
  K(-0.6640351047935882556355196309220606968400956297740973873383017338) + K(+0.3412905065763138969604056637074751803291969440638117238843261230) * I,
  K(+0.6037429429053351636480549763461253926406748935164762623221669559) + K(+0.1443912361814284534178522198954933358193634438175599266804917434) * I,
  K(+0.04049709968282266163459897886512329917197220682585409573189513545) + K(+0.4996157064315355326055163752802357217559261356722001044096151138) * I,
  K(+0.07083949369107481434408869927051740746544665609343821689998552144) + K(-0.6230831346564403465277960796640640381529425470993853422076473938) * I,
  K(+0.8089384237179930894022798826898087871131378771610462761899107267) + K(-0.9859718194302506453415194469799695492716899449266857330154068920) * I,
  K(-0.9323578235501902185081335535867230905428055056687366204156814546) + K(-0.9447972032542146762065085125544494444019838261409021171580265796) * I,
  K(+0.1296912582635094791159968741396517892619496286425923315469017315) + K(-0.2068263551412698141362146248853097226562808217145941255650250778) * I,
  K(-0.4468637969786996582440457059786106701273890489693164864223273276) + K(+0.3560647254240236998184132124783573327500294448009104919219221357) * I,
  K(+0.3473182787457166095655272011958304458769059245306263556237198093) + K(+0.1709539908168754281357471207538939126020549623807407322645739351) * I,
  K(+0.6730239803746776236331496603815032295495982893381947359651507448) + K(+0.6961549906664668387242721491814988874919253730885911841387184336) * I,
  K(+0.4693370738725782348011090850674669705181930016524837165135435547) + K(-0.7857951766509684715309721671093420092366735888479751894316716617) * I,
  K(+0.7326407917110484171912153866348997360576951272180219014691797793) + K(-0.9264042768404135962449498334767462274221149823539283099223698709) * I,
  K(+0.8896584626709136503743525653013008261806443874158277284018120149) + K(+0.4342083932680188831640137494112205832885344495616592824383241001) * I,
  K(-0.2265701660879125564721240884910281025669999083879807299439909758) + K(+0.5826965779329696556543948737595065286259539387891816832378451956) * I,
  K(+0.4708396089022274153436964883099718013373450222060073870567505239) + K(-0.07614560539976724478929507601837705779959296707361603096770812404) * I,
  K(-0.3467653307042932642135932397880869495315733369791291780688045235) + K(+0.08140391788934924007263340518620875310862880106717383821771833485) * I,
  K(-0.5080828524549865801764991771333278027282032135377193088826402342) + K(-0.9015993674808150849774257821193126837824674793523863303015074642) * I,
  K(+0.2534127692450978539956353315017964004415010066453586316790137267) + K(-0.4408773323563233079514746557081708900564805902213272281863940502) * I,
  K(-0.03784601056671346017278579674846485124513850380657478234018907258) + K(-0.8556794408837488879067989165186188363719860359427630650246464092) * I,
  K(-0.1638418577657418606013589935654438892709892566266603430609537648) + K(-0.9582949377915883573775653232736339745936825411875736736876614180) * I,
  K(+0.2304646108225628805612015119187584453941236526041793307050945163) + K(-0.6029359107416980190145886360033799209100879829213134524383822786) * I,
  K(+0.3443531342556848059435866028145119442400421416595575644797323295) + K(+0.01496506396355548904573416247400317308264553726521234859845012006) * I,
  K(-0.3457869024740416111401551370302798029445165812220497726264305890) + K(+0.08391466779977787090612693997014836974448247120368128925233716376) * I,
  K(+0.1930926810717222229941597550198194119738225445940276791441241131) + K(-0.8615879740724420315196410236519476092949888956183649241900032710) * I,
  K(+0.1394763583318256254690481032936703408345465656619632704870704652) + K(+0.4518687507167566315844465663142922149338378387358790932658507912) * I,
  K(+0.1734811767584588493722112843454839006131847531968834276506799479) + K(-0.3519446213002901954315438884132910866841259910544235976053197166) * I,
  K(-0.006389377188858164625004291454031199583005375394316488572042410186) + K(+0.8406952425953994624689167858277013624082316446263457797610685457) * I,
  K(+0.04042188419386758921108111037016068179441026426076429420003118806) + K(-0.5511105036718537388678847059130713045918163116954922262452667422) * I,
  K(+0.5290424316959729095787232531243315471095869567177665044555007757) + K(-0.9369076098347694150871004195370126676832052828756724957678320945) * I,
  K(-0.8131449470377295748647538680877719171494622875798434221364184453) + K(+0.1865431920288925081124660456222534502076700460628450382424736771) * I,
  K(-0.8551112470847734126088465165379136374761294369563813456440043335) + K(+0.1724267077608620610255127423878187619880739648930539245540379734) * I,
  K(+0.3438037656022972452255624303694813705797659620215279727199990343) + K(+0.6292400617267133394171991118950648279995056038191923434999974927) * I,
  K(+0.2076671620611933005854453300789753407975699653504255084724785072) + K(-0.3940350761215743064876552283822671451234281933607415834019211646) * I,
  K(+0.4782723342918177661894737172331898857214260534804273268576670473) + K(-0.7873481830931112487062234135143430200414313606422935291090562665) * I,
  K(-0.1365419284044311137981741470913920585828739955482983235498100413) + K(+0.01979324182253910239428328531642788054056233192086062572740415334) * I,
  K(-0.1142020128249069325364922542518282096886140193402810571046258690) + K(+0.8808689040178107728885237199542202440084305521600310781341333234) * I,
  K(+0.5772196721212842550449075982422857853077764389886736655472466258) + K(+0.5647848814787331057633058645807177893559968406779992012508706684) * I,
  K(-0.5849699012718161191104095422913651387303161200618405839797499872) + K(-0.9979878948392831992915905917696276707334175615661006184805564169) * I,
  K(+0.1888928043549689764569782403213440440643725262059280224142667585) + K(-0.9788324922333472874254730558201184176568187810186559998855343120) * I,
  K(+0.4052218317992207417273075483880724883796845221135309062520078607) + K(-0.1981236481466482635822654686939603544600803040554350154002461727) * I,
  K(-0.9192215529061250015326145277770822696646723479808599858909969171) + K(+0.6108165274595187458311821779561269734351748378186212890974597259) * I,
  K(+0.8018434417967885412662035783169008630633733548584016908753737702) + K(-0.07705998763162191656516599968429884635889954186727197087853471503) * I,
  K(+0.06206781597464059246795880669680164363633061547744939162006577336) + K(+0.02993154510954953354145925477199968114060055030768275499193064566) * I,
  K(-0.8478409021572409960427753187611909151848289136584503608354059073) + K(+0.6136637399013493530809671603827572679895516739809012955467591939) * I,
  K(-0.6250146186474650769000212251959050975121254692350090012887931340) + K(+0.5754142034524933105308155344505195268591305356676030743113648803) * I,
  K(+0.6205573885776820069655825458715568059164575797940385557341970054) + K(-0.6981033788711433173054682856985691369721004773585967029115307709) * I,
  K(+0.06534453683785326052325366365174581483514125376900657275261662701) + K(-0.3932515130681037026213466872703865718548695785813969475907322261) * I,
  K(+0.1694127646060695585348699897467356412201432935396842740970405741) + K(-0.04451881667192675644889270678720571833873178312878231316222156346) * I,
  K(-0.5618600155088621679510921558488675502357090070649825076145124501) + K(-0.9515818973925610266594858566793592879497042261230969910390836885) * I,
  K(-0.9690095469471989085486956886827710732445194863931686963475442566) + K(+0.3617447383200301817557974675565439736154627067488326269290933466) * I,
  K(+0.8572629232129391047139134088135219634926764157234453642201639856) + K(+0.7148090491237282187481034068230319449312511241080055705734489509) * I,
  K(+0.5251426649018816166492143000109868755140014128747404349390212514) + K(-0.7705262094531509858969250840978689758336987077085071141398432901) * I,
  K(-0.3112227765814012309389531999444809477409220877016387682960147221) + K(-0.7059254382674773269530157888190534605631883008804236332291267303) * I,
  K(-0.1508031116382738388499919406627025267853335971266846963418020964) + K(-0.9790827758692157248620714982187530552345714114141875594862256317) * I,
  K(+0.9644162511935579093241410903610234449652984515138670526753535487) + K(-0.3300933979029205070581868837032307671491602410428568658061422838) * I,
  K(+0.8521405037515876241502942769717282798536195310104325131155797457) + K(-0.4018532443016763802126594607694765668189549777995208300696981674) * I,
  K(-0.6616989662568875926935486720739743240441451485889619913070279419) + K(+0.1106632389482720323570183639094837864199309989985204657569386781) * I,
  K(+0.4066037513692233654172581507155154374314137083450641696011272285) + K(+0.7944701691804542025804611341958793933232857160964086586096090746) * I,
  K(+0.6555384736609781936246354536182731154410552362109741497450337459) + K(-0.09347895492525980007064936261740540768138616119732087566916865686) * I,
  K(-0.3062548083981121374551717781528451594217189478801249843162446131) + K(-0.7549451847938184775282979602818789314889296048298785034509814848) * I,
  K(+0.09693733538351156542198772991808467561689422215688338699916029741) + K(-0.4325374975324868612249314307964406940577604645687650910486764276) * I,
  K(-0.3953730369067839939025678351163433726843498618331996791064572633) + K(-0.1481209826829122869442724836024370478720100718734625865837328739) * I,
  K(-0.8909075632084579104972519473780447582097296816226607600844510230) + K(+0.5443026481842977101227459082948349013897221766614285932236914388) * I,
  K(+0.7324515197119674695950532085286097597014647221989440804528415170) + K(-0.6483952163292400890725867874641597701679666306732292092935423536) * I,
  K(+0.9298428832549888827470214333528791268939604138080126422205147584) + K(+0.7295553166679149168559999960541258881624278233648573378609410868) * I,
  K(+0.9866189002085929815363116037727884673722755122816265613022807405) + K(+0.2345589322127484248475399866653133861552638764992621813196012142) * I,
  K(+0.7850749482551828369144922482310461811523194674450306812941750626) + K(+0.4222609768553549893337035220781628115693499265744915130233561170) * I,
  K(+0.8473313704979348423690430550253950963739845206209727361818441613) + K(-0.7058213189750876882784962377025562886070969746714085869120359815) * I,
  K(-0.7015477631821363528973032011331148578366560189759559257587070329) + K(-0.4678151251570461185220450417195603655282374460267727063923184869) * I,
  K(+0.9261008939016042282125265374430537333496961921863980038002663555) + K(+0.3033194798850245050720691754277763011325749053279687123743684340) * I,
  K(-0.9982961753453067726975817420485761642922690149624467530302722732) + K(-0.9661000027497713376194619967015662405602761560357887374779637831) * I,
  K(-0.3373408769160774173199442927404934035294014389477070592559712480) + K(-0.3539998147342716162036845617135787367304380999586616637095942376) * I,
  K(+0.6925686242456340293221353925572444605578662584450055717589210690) + K(-0.4312481380563532132255271591339366155841250211925300720459257583) * I,
  K(+0.1244988561614427901956887203947039988974857473254855233673339541) + K(-0.7376501584337611540176798704234296969331603580606360589562884345) * I,
  K(+0.8348642341925357467587412651280331583645526161800388121955944327) + K(+0.2448800135253409401132382069711438429556679213456775074236767732) * I,
  K(+0.9071404040655905638015823676672702555127105698911383552968686913) + K(-0.005390798646370928931558152976433350276179014523526193286637032564) * I,
  K(-0.4485791310506140313661511856722369706396616968946054310335516606) + K(+0.5305869128011832005628464629735554948019258297823854065804029224) * I,
  K(+0.02296531453518727018499295787989688236570420865308323667226251677) + K(-0.3546889388045263115201821193724516329615318407633450403999584633) * I,
  K(+0.2571571858769719645280353042023686021396404232149522806678415201) + K(-0.5196981062176394831660974508864543990781722450216841206152752956) * I,
  K(-0.2307401239396443061949151945522591068358529420486258439951760912) + K(+0.08891360119399596749884386376529052312480731555438530279414948641) * I,
  K(-0.1342069542757424570889506220804300782167771869040928865305092826) + K(-0.7162405317677616445759686152639890518140606338662859288203074203) * I,
  K(-0.2528496487022831361795387010549624842982228156795355232683589084) + K(+0.01097081486694913046329099199600130944852874001487329289340421640) * I,
  K(-0.7451856743184566574405465713014591450519492744910662728708856573) + K(+0.6576174759707479419100295251684078172003798452629633230485438672) * I,
  K(+0.2543645739475612600439757972588590264699481099408823209823142925) + K(-0.1152031912838220239702623578024932918867337277239785412695777898) * I,
  K(+0.2472555789201360550686257951292662452385647036333260933435509671) + K(+0.05245042717790917458338056175938960598088600910415918752345759920) * I,
  K(+0.3337231699634354797215160161197761736246922727732086976307169695) + K(-0.5555861231462383289960488924860942243538652113685037026073990591) * I,
  K(-0.5773466842176447866256908821098953036429099146248960570815957811) + K(-0.7847218887597644352059090550947579197271395022745509599737087632) * I,
  K(+0.2310346465611621969647520443384695821111293520347316095369545366) + K(+0.6956624279796197387618692909472051404486569551084813077232512469) * I,
  K(+0.6668633589786994854311594511774044702273391217635839618266072895) + K(+0.6498438902749584443043090023704876089942234142271587995706071709) * I,
  K(-0.9567569409193584166336988696719511473510196591417440409163517444) + K(-0.8809561712540304841609081467247258426632924926410909273025548033) * I,
  K(+0.9688749205485018857292047054041581856523121758909548374836674962) + K(-0.7952478494851968971642566979060614170579052655852728439415056084) * I,
  K(+0.6352177265635140095795868496708024562667660013438182052342682753) + K(-0.7428299034420465839178969045913238182889230859983319084116283251) * I,
  K(-0.2011328964589948209368317545591699835338171429877527955615168024) + K(+0.9392076940542956663888882908664805201226201845255448292135651628) * I,
  K(-0.6251595245871862967804957813297773042420193169743309028776758475) + K(+0.06189756252861603684689724983590021886000380034854631981022293682) * I,
  K(+0.09958929032822524965431295995672428566484487885466648573242138998) + K(-0.9479092212057874303742952491892763559406324982893557721924263134) * I,
  K(-0.6548250927996704791993841791963935369691196202328559186170531977) + K(-0.6774470530952922706938977456071820360494862715433203350871163601) * I,
  K(-0.1222708078487543466539141904111687683463100917284779078957517826) + K(+0.2901413574157255190558096379521242964394348055815385325533885466) * I,
  K(-0.1489839842647844448320755804314126165090837119634106272724291281) + K(-0.8317482771405245622522832896218640067621352296321130930574801187) * I,
  K(+0.1298191609392687271919613046672102405872535141345336215662879925) + K(-0.2319169219609306735783966251244987646549816731661911398556730043) * I,
  K(+0.02431372439121580012791414673697527956550112906979694782406572505) + K(+0.4015807188184378592733930827235484910711746851266315629701124662) * I,
  K(-0.7097754767273637854590364191009000421935977904952745136432081162) + K(+0.3983606831102441116706128321545902344390453985079732430356279124) * I,
  K(-0.9957684797248752746736940129939630778253672430942038331779982927) + K(-0.3668166453303815433290531550092607945677460654551416771804113898) * I,
  K(-0.6182503042738413386050260787479723999178060034437478740452453366) + K(+0.09848153275019795286181623277153625108257143217251844236822069969) * I,
  K(+0.9599350667164602097064987920208214616285567954936519920662590105) + K(-0.3612859986454879757492229483806880829267526972098848545626184323) * I,
  K(+0.2938262573278622798606035428895281871235906860027842501804078122) + K(+0.4520997210119139511132091679035065311548990860876907060840570798) * I,
  K(+0.5258811725739402665502120625997516993714558339921552447902711807) + K(-0.3248433774403433573677174145196778645659365686829040107056529750) * I,
  K(-0.6017446240243853447324554106585316749957745462851488959156372559) + K(+0.6158091913990509274726377492059084001924163646376172758137036289) * I,
  K(+0.8502405079392475723053034582733293699634270002315523564420647975) + K(+0.1277177663725873721089550701598061124135124942429115327497292885) * I,
  K(+0.7596601021791837088293882557901637829046811541180956518259825667) + K(+0.2003646386404225383660209440859219360758706434181056568118487735) * I,
  K(-0.9653518389029426736260271523033784704684908317432304470169388053) + K(-0.01085032903578773102157671656829956959220004905360306543650121899) * I,
  K(-0.3447877142057833814343579612597239848506117417774848551473335705) + K(+0.3269173216759952020685171445083394207020867462620033061195229043) * I,
  K(+0.6650517004032010948747070011478036784757121648846766203973889979) + K(+0.5292890409368328221052826593043011503645261308795073568145839499) * I,
  K(-0.3535910303587964395641185395495097243975084716019640034063119228) + K(+0.5644753007073346040992897306120132956306638666901777220121106225) * I,
  K(-0.7951323625068113723158625935496970264433400875678422735692671894) + K(+0.4248856825427021893639314422686960891087367915837002306426661241) * I,
  K(-0.1164163635218733885246851203412551608400709152171000775797758439) + K(-0.3497765725638947964526168719398135900928182017448308756123207081) * I,
  K(-0.2942029355186264453936118835043250512215600572666184714405901126) + K(+0.2232559635425089903933183561345583265063465829199775869366449358) * I,
  K(+0.8509001730530253759462362437689576975783520658898955339651393362) + K(-0.8951850879115748535563858183506409808532639061179192890493077637) * I,
  K(-0.8583563710730539840595404254361122867157044618942922268688038280) + K(-0.5156200572063233297921970678900788442132562212799342541263029007) * I,
  K(-0.7983138879143760741165777669339430214612213030619354356597769169) + K(+0.07381299284602129402719582883608095054637386598916856560963249042) * I,
  K(+0.8095259082700107171825214339402396170926856278630581486532855943) + K(-0.2705955937709261461311881364790767699807898920233889944804275812) * I,
  K(-0.9224458007104349799706511279209716052610521255970061779066090306) + K(+0.1701743714578343780276363729743533048964877074513406538303746533) * I,
  K(+0.3394322851638336739753839484831558379886115435945768965354689785) + K(+0.2083077340151472716872031262762495807044554824469264848994359883) * I,
  K(+0.9592708062607786671867341804397778427014328983466680823177985734) + K(-0.8830716109505104881163683215736472373394084061209240597600807573) * I,
  K(-0.7361500204987354827490157786120413890780585017734432253015747555) + K(+0.4515621970640184006009306613134866509435019402910827592517462832) * I,
  K(-0.5945775652207438772872421266732388747714577236892427625979073499) + K(-0.9350901895046316704137671351529081079551929559810408453885780341) * I,
  K(-0.9482167693077142828553782579689823931927368907118077504734664596) + K(-0.06014891839315446042375796508204252279614678465899558674893192211) * I,
  K(-0.8166109672576379199658321777785070114678570932357195649257082196) + K(-0.8322292507511666964236897315919071736693250142412765563288625397) * I,
  K(-0.8244372338427646134526887365543127247760724230944755553883638929) + K(-0.3097367617767747009969098885351738264681578356128830149017959546) * I,
  K(+0.3160935609684555227620005885112973322847811500753654811048976874) + K(-0.3932590217832267674270885173801068685097437239396254095859130172) * I,
  K(+0.7537556732702545598037755307816387008523858589893845146513079447) + K(+0.03589903299902697372681527783652079084309925781511316554638379184) * I,
  K(+0.7055175301694533350324514606416264665249906551006279257194649495) + K(-0.4734988187050715352978552759397129451421822858370480333859491378) * I,
  K(-0.9094596141156307990470697479328808839868630070517247820115544511) + K(-0.03180779673909519120683353003896260513060889595487689457655802755) * I,
  K(-0.06309633695479189718314491183021402408972153342116631283455929289) + K(+0.6667190839018824472733919157821912050609170219749823266853561045) * I,
  K(+0.5096301034138135642295324762866955916648364748354415498780267537) + K(+0.1657033448993123801615300523169438639731064763271733682303346816) * I,
  K(+0.4784392820670900188042277752662579249802813350561614925974158665) + K(-0.9116984271075268200140080403800040441390874356893194571996765240) * I,
  K(-0.8832745491903480277294167035974233234878108195547885424491258980) + K(-0.4409284345784698461231017826670311180599415154657482035611726886) * I,
  K(-0.2235044780950896659720320589223489076669296160891597911620860387) + K(+0.2906902071434968474006719057101011707259425971827749629123515624) * I,
  K(+0.2241127793152276028598518125491148078608893287432865471648796650) + K(-0.8195644764520402901083661759295697710088549699896031861593312144) * I,
  K(+0.8425708874014594622936795546155085851105542484838902753378774203) + K(-0.9928576681491780376980595382359490863199305403871022043377442877) * I,
  K(-0.6448583262186071403692800723957111208495905332922426110718335219) + K(+0.4447068534697065596509877091171244265699795835563445923434174765) * I,
  K(-0.009096222817938798447368559581750977738176813515555690155708136475) + K(+0.06000374527444900304156712488412548935478079493483835200393857698) * I,
  K(+0.6439240211139871050454676568755036138864641896534656536833174923) + K(+0.4233055910440917594127092207415722625441085709802670696935971538) * I,
  K(-0.2500645366295277424248707218074136849617472158022633224285653688) + K(+0.7390308427210412932993638198868459665071679658796273933281117969) * I,
  K(-0.8405592967119205156062703873564502051459867138153736323654803287) + K(+0.7606606924418702225342212023405265844886932554854313707501699129) * I,
  K(-0.6452787623036607386464268288402643467181846890314108969120184718) + K(-0.4875499999879047033465693480588003906689922279559936394514942354) * I,
  K(+0.1282669030202716539681165302331304544553614643763319962048499166) + K(+0.4040838685885191404971545055639505506828808776499882025897575794) * I,
  K(-0.8375503487717622224530515119233160752709433789054117393489935270) + K(+0.01819552988102567371315746217525908318717662559635533046910024463) * I,
  K(+0.9800619815088495005996354235085856347194940108277983709439214836) + K(-0.8022565338902891692463093126129665410059919718974803332053920392) * I,
  K(+0.4380494524152227595681939796818601041513244437613887842968968894) + K(+0.007935176361027398825274389961977805470435163262100840467273486149) * I,
  K(+0.08860403266473917705997473675058673452219036585984281857398100964) + K(-0.9103765369423980609623388365646936837162501578207947370666162167) * I,
  K(+0.5099783530466409660867178049422041293288072164921230179972533788) + K(-0.005775606772744272719728035308191432976544591690191956847537297087) * I,
  K(-0.1596716064405435361152043802657858305115621048200548686276666879) + K(-0.4104169761460309101892155677824721508193050760494095959533155651) * I,
  K(-0.6810557409574377633097451350585899499802439706625932749162775062) + K(-0.2672276175585291039044541300200083430015505236929999237128608789) * I,
  K(+0.2489894426728731685118815269432622353079476003675018610526152843) + K(+0.8606166860535069609851397467177179575191425563461271252866415329) * I,
  K(+0.8506508397619027982676986275636725812248634004594272390818033044) + K(+0.04925914075178258188670177126518535766296770687510522032291611786) * I,
  K(-0.05947507624470946675021404865689200568851602857999843210093148656) + K(-0.7321112351852172635774151903219896168119668231550046709303383563) * I,
  K(+0.9739550579065299580026179673539750726156134485738574687578193572) + K(+0.7573586739881835663553509061561661211429331021710966417235025597) * I,
  K(+0.9255416027285865633734143409244548513747123269669616046090556392) + K(+0.06692102331778971506387180347450213823901628957126770811551281668) * I,
  K(+0.2392206264657781337054392851182162882202179548706184150867332207) + K(-0.9560574291342402036650276456641371374223618500088606827533152365) * I,
  K(-0.9011437036115681055925982237309768783773366301539393980908335471) + K(-0.5734871774994161290407387891657799592400717693363727526705717044) * I,
  K(-0.7364116985550050836854575743451371879865367048884298360591145752) + K(-0.6502361893143356816741534035616834106830328582687276322912511327) * I,
  K(-0.7572668484391989916622869154862089943468039294156966242481363471) + K(-0.3390496345913181316915634059207279968987837294137886615035143241) * I,
  K(-0.5772757533581359477539768791841518666026553845404247336899510608) + K(-0.1407996277506742695183923393177040881373826350132273991384504150) * I,
  K(+0.3637363714532628109880953579671515095090379764406796830332955141) + K(+0.4319126055482282087059540297349743866418348939894618813421636914) * I,
  K(+0.2967039646895491298595210172552598784054130309047168989638185730) + K(-0.8529782490843390708808993716234205390368916934862277934168273003) * I,
  K(+0.9773655530099821891917709850846236227747053148987299909373103499) + K(+0.1076681058547118329695770424062521306496232908705722611728754212) * I,
  K(-0.2313667531318478308766404005017050820112378838516306447500353098) + K(-0.9688553779592586660234357602846334819571612394430724270030022744) * I,
  K(+0.9221011090587491853074299184608533856791887035534760105044036080) + K(+0.4273753563252363722506001083241481757089457577370206234455951503) * I,
  K(-0.4157149990465158788962357806953067725682098597110283620326858431) + K(+0.3448127533851371742200294908978476145811438009908216554475142725) * I,
  K(+0.3939636621374263895022035626052702723626799445691976661240070720) + K(-0.2782997216973340522154667632940840329848679752855922290276363179) * I,
  K(-0.1695847389451206806370286993142181585708979023091295112089437044) + K(+0.3804655468858981830099213673571916436895322946479420243673486092) * I,
  K(-0.2720363613414129273507956938532410176859962782699311583776773530) + K(+0.4901136987732815252180365576465952446044351612716063836935767447) * I,
  K(+0.01042896653227312415023003305198045190524413866176498921615863500) + K(-0.9500138543105071607657499844068514527557249067263273194553627925) * I,
  K(+0.05730298688017074332797003099530047295791547822097203915116888290) + K(-0.6677147057008947997978090462949778552550312904587293752022212740) * I,
  K(-0.9944740368098729538564720451163954997845964076731012693030531368) + K(+0.1301059667627928323366118322595162057732697937911195935168118259) * I,
  K(+0.7223363942309820546013897292288598944499098603398871933686941530) + K(+0.3109567337117650810242672251153906975276952088139356801408242817) * I,
  K(+0.2807950223678356778024748159757154175656982095028802121175759831) + K(+0.9624729939306386106491113608371582294845898455313934176573633871) * I,
  K(+0.2051627517926630751722950664722997554009198638609211081063449128) + K(+0.8227511023476245321636672041212029169480725948106523194143947097) * I,
  K(+0.2187410207913535738951335139506203809947707722952831601168299341) + K(+0.06857079915236032101552301418427801356140527060725386012517610281) * I,
  K(-0.6164165868086236592260894736259595566725279984627557379719223825) + K(-0.4144343062532604380124792449338913708091404974995415854520558525) * I,
  K(+0.6633220658760418239885703169383728624828917778395079158952128337) + K(-0.6938479368619079653185757967341071840421423015975724810980976586) * I,
  K(-0.1401226563463201132974658766336975992782906666007252854894520535) + K(+0.2669205807983703246384708037823316978703172804706903825260674343) * I,
  K(-0.8710271730752299000861932767133074557709365404736968044117141263) + K(-0.1030381392252131734135396601986098588263147223589706666634583354) * I,
  K(+0.5806146371844275984952356122744968248161513666716592440990351930) + K(-0.7662104538087767128127052827146345783738526624114091171966895460) * I,
  K(-0.9232528808215254538102568763445122342893196327285120138315242355) + K(+0.07822225063291268771840315245812858693770368754568991927419757884) * I,
  K(-0.7717476468147440717400524588876320543604536938248605821389042652) + K(+0.04868395592980535257918463177540036613082145058925953340006569328) * I,
  K(-0.09909899962420227736000388821656662530128249742457994345772454248) + K(+0.3185803167934116390942394142718212675070175314206945944537126142) * I,
  K(+0.2065634397510256566978978622797194192545629267581350543005708970) + K(-0.1497960396825874727883558188352567944041731882888192554551963893) * I,
  K(-0.04790607170037866821113552300374560024536469447850458690626959412) + K(+0.3326658553703319287739090880891024148897212350736207490991064395) * I,
  K(-0.3017715161041522484001327408356279879116214544208747760105764048) + K(+0.1651496761435738514055086204484201239595318049898820669873525510) * I,
  K(-0.02730025281437285604135078302803574992234076002537705417273482767) + K(-0.1197610844347735620184039224012416659918097590630805295278783851) * I,
  K(-0.8962599574016225826405515715500817238829543725937689611558172487) + K(+0.5041804371853829391167543548710701715494935376019789219540291688) * I,
  K(-0.3039368340867884725625354676502652208704818053470346721587905592) + K(-0.5747557901399845616502227621038430323817805374029780906246134866) * I,
  K(+0.08976014121529817223922545544553050682338617171043437785454168847) + K(-0.4312550427102329358884985783819343673308683091188923201666152248) * I,
  K(+0.7836979184143426285194342455702802493290221421425950386092514047) + K(+0.4371158304540517221364928228755829093704678226914635218634428798) * I,
  K(+0.7866165265604333887028161515998284930776944521598201815074812703) + K(-0.5453044328965967526412157942275508057010273945963191815417557900) * I,
  K(-0.2959469127012690470715706308175813940683893420430018810083452182) + K(+0.9431316552809429993567505642794468014360760148701020862570117346) * I,
  K(+0.9839465311696166360938595256439479020333654757596118847584421407) + K(-0.9386795842403934923076133395046522634780454664377959414653495662) * I,
  K(-0.7295512424846779560526178451407277996420860385406456171211186842) + K(-0.9071322050344350214861663193920334031999359170624424161242870554) * I,
  K(-0.5734859340249927177041293109463920733156355640715107463723088987) + K(-0.7899106350378392670914653586156035657514616763611561402560358095) * I,
  K(-0.6802437960660276763587834566790933380788293104220584436370985977) + K(-0.1569661847222951873581934525868057792552201318035042747987729793) * I,
  K(+0.1497649113654655133783597828565588660607642167354116073123795869) + K(+0.4411421395682736498399796539382212959115078196976702672734105877) * I,
  K(+0.8867298774769700199925913188176541492635860358896736714239223747) + K(-0.7282083893935475813580241093579524626705319280407669578229726435) * I,
  K(-0.8752515215864305827151183877348399201587236639340144967611151338) + K(+0.7668939494832659319477805812566187192255503638370055257646007528) * I,
  K(-0.7201617293917598525296543346641416058512141219963494340616424667) + K(-0.1482159387526724783106655712239308395209421842855438555330688550) * I,
  K(+0.2690126032634582200019677184095852277949186263397302630218337021) + K(+0.03851070301456312909086271082716627532772248751809848643840744353) * I,
  K(-0.3730733704214551800640473712454784176332153517228811064648231567) + K(-0.8905316737567179038911762419651149343043729239953693969159610529) * I,
  K(+0.3082714695840894683576631824626028008928681276302798942725502314) + K(+0.1227251432811091391815534252907446987108550842196219932024255871) * I,
  K(-0.2987967105280014420073116046973414674468600923650387546130897510) + K(+0.2112038132526177108978486918470076731176035007959364022765155370) * I,
  K(-0.2000951134404436946095652040367275677128746370504197225789724850) + K(-0.1696273388660750077068783889700127372117263534988539280073553782) * I,
  K(+0.04408273980065905091197921561136354984723877628206147301652685496) + K(-0.7069282882938740622670070941643749925480013249861393551591332048) * I,
  K(-0.7297202043152315067044763430638620779328768044156804768966644531) + K(-0.4633651244671009157563364007007371689257529213752429659480918708) * I,
  K(-0.4457965002036897720847549424948006136603782944939037586465296909) + K(-0.2877319496209650714301600014612761880121340156534594863849840981) * I,
  K(+0.4340920733153823860505694247823687165841582489112064447855256833) + K(-0.8448984489729436155365934500291724225525584810348929979003036995) * I,
  K(+0.9511048506839730335733822809137841865931642174385739999991139200) + K(+0.1331344091257903087809795500520681993475416107848396617090004660) * I,
  K(-0.7401059429721667431273379499929477791865703625070894757010602088) + K(+0.8141531518361978273705091921873697146002364707890241726367901509) * I,
  K(-0.4092479608664280766380668991489306263757014395158398468963314903) + K(+0.9802412809915029360488331356355875020253585274966050582147144964) * I,
  K(-0.7313218163535299929527294922870077337926490435498704681755798878) + K(+0.1166608264503253163647784987040246029071163773372558630400367237) * I,
  K(+0.6110376183866484754920703112974249929219559684208111499218281493) + K(-0.1843354752611871910141291792123852776671618149701790823035651695) * I,
  K(-0.8862000322715966695327553532707558139300831354267283950147273015) + K(+0.3609667175193408363854574418356643584381060422172516610040031218) * I,
  K(+0.1630848742830569005817123509841830738097995985846930030237351073) + K(-0.01248374953972694388923344798818104877982877220723889129177300228) * I,
  K(+0.4014607910563290449550039502488821952766875489552562105895772781) + K(+0.3793020126418015177172134367837836608425738340129988242627070738) * I,
  K(-0.4566856311258568314471943703782753685871300455525628683770873783) + K(-0.1380156489095767121625602619461977921665529748250314893447804898) * I,
  K(+0.8281754994927412623254071984611693613289490561603509579518356070) + K(+0.4454813958597333657711394728649113659270502924620041791103340472) * I,
  K(+0.6760720797795224714675711686651709979749868244245466650721132681) + K(-0.8022564996513577190885076819346753150071354409843636941478617909) * I,
  K(+0.6607395831909333650594029817502785066839489139335307598992708434) + K(-0.7264025285247545096683502726147098986543268369166135759921519201) * I,
  K(-0.02210168988106958335639253976020663016518324665800641169662116698) + K(-0.06455311423882060254214968025310994085046619635227993859856120037) * I,
  K(-0.2245413655397294850293890745253334587186497994598627227893983885) + K(+0.1514621158454726655502411906531727105081305454011105348123075764) * I,
  K(+0.2436103488358762454423676628745265098394088465037428051938261616) + K(-0.2067930590214930064481697957237172113772695089772819617809094310) * I,
  K(-0.5683045746254675285626375278156614867357715694552444825191990224) + K(+0.4469792143900330016786640798072566885315433209117643485851388241) * I,
  K(-0.1415843488117874303011799917126425991790001175126813092000731312) + K(-0.3893281858513342338544726126284910753861028763176906714360667786) * I,
  K(-0.1540400652193158062147877024235246170914086837551876880427074560) + K(+0.5318143396763262475274064952124011066705325366138209806102776345) * I,
  K(+0.6700004281157037057859473264254934452077265563965601393495592711) + K(-0.2810925811250377189774845951773505917088094282808449896706296345) * I,
  K(+0.01363213233759045478522152671936645326270858597114263069749918319) + K(+0.3481465693910355045301822238051668299740263484449974634774890144) * I,
  K(+0.2757173211602678528086675606622744653854694186322805566074284564) + K(-0.6352668390573280172761060068177174083280359585777411541049770614) * I,
  K(+0.3395619426276593623455680156723507487006117022664333026524024864) + K(-0.9137700188358494788276582146806965633113065954845178714962394746) * I,
  K(-0.8964251963617578624580130200523512237161425272298893060792035169) + K(-0.2165887641996181497622927628473350034893711945610182849914293918) * I,
  K(-0.6798946221252043885769009469703837486455986916783420070178543833) + K(+0.5592183524119207401050142211908223369639587742344369099940210971) * I,
  K(-0.5650488736576005276525275636848646827425632923884710385620154131) + K(+0.3583740956051584066067786050408846001840802257276822321423096004) * I,
  K(+0.5163726848821795770226317592910073407765161266641398352921347851) + K(-0.9800526894289191923971923020670567607643434434441309143089297768) * I,
  K(+0.5712016304343972987746019299725399823665423238427686293021299908) + K(+0.1577226678519263735427921007103755059842224490723627677977511026) * I,
  K(-0.1768545480073226618712608429300708454315735533629761421780498913) + K(-0.1533530642318423731790017300729525169799848461238431835942470003) * I,
  K(+0.9038111625259216266440797340164586498546425158344144143221457528) + K(+0.4890607028327765859593392843696071090700227156999142044922209104) * I,
  K(-0.09443014234869123439569796704273088460916147516498649725915111030) + K(+0.5115795229074654639404752657256627225134088655004914132378922455) * I,
  K(-0.8462709327039094322602243221742571036980701996346912497983838355) + K(-0.3553487614663213329943700510818329222807510909363000123438466338) * I,
  K(+0.3801667858291253818463388391257814015297938378116846862854313997) + K(+0.4882164988161059411495467580071385684135547004120232008314618025) * I,
  K(-0.7298076590930508177860475802130057645853553425906179292055378156) + K(+0.5101171582194795210754380677842894725193597589092155469776581860) * I,
  K(-0.1361135925923655985153999475727062726486431859685153311868136665) + K(-0.4182989718755847073533114089157212657710712272129671427058450535) * I,
  K(-0.9501207102977787089608030250227278300703551667186336909388893908) + K(-0.8979401446636229706796706052977262614119521936125359622406003522) * I,
  K(+0.03159618310577205229868112671371156210259713657227168184962006250) + K(+0.8521337606838357290242633407070465798008937658083518086624832637) * I,
  K(-0.1338622456171996633020804026614394905621593515873135690993235824) + K(+0.8674147779153207009940356976175051202942378024237841391456145445) * I,
  K(-0.2691827143494725271011915296465645342090678244186001541943208857) + K(+0.4991559751598721951176619480014929469538037476328250592032746956) * I,
  K(-0.06843869380703630203346991722303087591182862647206557577869577947) + K(-0.3538694191006108653382993155410372522741913005564396438861895209) * I,
  K(+0.06618544899959273916942107249606960745312955716267114069997456756) + K(-0.6482557883646904030963231842438779590940961284000015552548540384) * I,
  K(+0.2503143545021830132728617721010718850634503200007392192211975089) + K(-0.4104248202847837335480681319586231553342002172172992614349360595) * I,
  K(+0.9516755357329593871720436832929372429186443596205698117495862253) + K(-0.3843484578236373385048234095163746488260096413975343055616577934) * I,
  K(-0.5665761135786829843970113615586623033421333593697455584134046694) + K(+0.09515149636410997937276692756709007681901186984387812347376609407) * I,
  K(-0.09881564805399776444847445809672243980035306673607891530045714759) + K(+0.04194633333622757809792261624399220884588360072311019958294699192) * I,
  K(-0.1520938944959151204142628659195121081358746367418747509260693222) + K(-0.7079066969822893391984862417641681236574923786349632853846533381) * I,
  K(-0.4628984694472276797358042597073693579628372033565860106172312820) + K(-0.7021046224530392114369883463504061044152308625053472397051830454) * I,
  K(+0.6882385322639036603283844386452917651967126100824798405655582575) + K(-0.6857380998360064336317049062272911674146618260835475604463065180) * I,
  K(-0.2200660423411483106611251501987288305955964430339835919248663955) + K(-0.4365242475453950013194456182037304690934408998997342169410360699) * I,
  K(-0.8734575310781055345506830691581707790328304003797002474221958986) + K(-0.2501976214094881624624623880530605025692350315374643097156204010) * I,
  K(+0.8083783047446051965329029065427292782149905420751194751531417995) + K(-0.7491747875107950469480221622523738895007844484921805658468992484) * I,
  K(-0.5720696231186340823930152667064808802482081896096684006905943630) + K(-0.2042321574996881028003469753380329870594387395208036049390362545) * I,
  K(+0.4942581777210745002423000961287494631037123385816629872124763187) + K(+0.2870846202865290683707218208265756399956084941885672546646651672) * I,
  K(+0.3576045438927104090305733600314668672810999408316528345525845623) + K(+0.9911313524953943509787153508065453650506023937154222495639123599) * I,
  K(-0.1842721945849529582993164314116476592942743423367264039018705868) + K(-0.4052382798534345748131741639962758685236582504626608658984113460) * I,
  K(+0.4557440020156115794221183385286260974154466317941839054282538176) + K(+0.3968602418728344360464171482124130094297960627813247221471943800) * I,
  K(-0.8292725622441489105412476265665201436850221048079459839221552979) + K(-0.9546200889232778028888064717952852638287920447533741484309926196) * I,
  K(+0.7526496059602092944702468292256074268148389120297763278702128042) + K(-0.5770343638133719621384014676538299263647530637637122801333886960) * I,
  K(+0.2055426077903897674634947232675150593437612905687105701079274989) + K(-0.4741247979594316213236064600433784492765033776667150379114007533) * I,
  K(+0.1877276971696165384144125198719093886539671074414140096665495110) + K(-0.9128696463888074089249629640837309709521519023134078641316022166) * I,
  K(-0.9397091884729801080334241081675713512304258906448567938715948657) + K(+0.7415282153523771802712770455350307203567117340861906371138701525) * I,
  K(-0.7290626735873727811447567924790290994196939828564252711039152327) + K(-0.7373269335397143232079677851416041229457458436008611972740017844) * I,
  K(+0.3436620584567753409227181044591500466809698862204544130285382641) + K(-0.7885652869331560367759899135031859542966977043538175546111055532) * I,
  K(+0.5329315450731112792243135741928445913070806578401126487872276586) + K(+0.9991005609104289742650630077116371071086898091460800933566173906) * I,
  K(-0.2941614885776499924820891270562008702218591376918530385305821791) + K(-0.7615763713973028230495908267851639321514158297531581284290317599) * I,
  K(-0.5882618839300487198663835756281318214086603492831213156604521858) + K(+0.05304898722662266886051489440731174842186155061628873404217530120) * I,
  K(+0.3957773068767623282272171816289733460502194335972310305504799291) + K(+0.6065075040186496664635412105174628448735771347524348968638249026) * I,
  K(-0.3327939012934247521929422134376887204482610468120138075797032341) + K(+0.4788108915602561633319640367591197710984751647562139437712836110) * I,
  K(-0.4868798069385043495143592138585186006001659380986309495892744818) + K(-0.01939278621255186222550052843313076974855187318043573346323392348) * I,
  K(-0.9155919954593639196892761194963676176194678260017847006434259121) + K(-0.9419701082891052493092108602944851034213138813467660788823810566) * I,
  K(-0.6444220979866274044070934268257803867553128017177457100042027412) + K(+0.7593285052308131871479566390143603269041091824321114300721752123) * I,
  K(-0.7713491861470832333315710283301443754324305875280853521889992790) + K(-0.4877483652477563635717813409013410964452371875715915224059840318) * I,
  K(+0.9250440745277792134920324831837016985576565251929850312239571350) + K(-0.02031546022878939331123155327122910944227217961699985567847319368) * I,
  K(+0.5170966008062976438874314326629582452487630590568851324961154794) + K(-0.2074145938376057741503719651539659249570946436216701148055404114) * I,
  K(-0.9065502266467108173132475564027714637435594748415552058966914812) + K(-0.3126653959246686594010143007642277623875655852704894180336975485) * I,
  K(-0.2905367033985758888140026326511953780930658881401448973019605240) + K(+0.4072556890800834684402400682429143421158478367485883131849237079) * I,
  K(-0.2467242887574960767922848618625677338694658842864107285233116432) + K(+0.4032591137190155176469664757463483640413368517579461617725847185) * I,
  K(-0.9145801211059790619049745849687860322232415161124709467637647816) + K(-0.5108121164824082103120323447228567593432013467085624301191994548) * I,
  K(-0.8675150324924925380945711423359425955593125246833503672108923480) + K(+0.1415784730356975097400691335497543948966071935533976347209319117) * I,
  K(+0.6167827160596026936549262601397045254832074626548829009885767397) + K(+0.3725966401207280210587993806770002179494249913276760591314698165) * I,
  K(-0.2565049745831414869217083361593043407538776801434412907510923540) + K(+0.6172421203376810354219264420127923526050968583743476695986736209) * I,
  K(-0.4526307703157022099150143144840328403486044363775766300250882872) + K(-0.7326273986866696635298031941516937915483838728471825558566788408) * I,
  K(+0.9812656990203720780963170706950085118197059090702668023927796767) + K(-0.3747341193822465015919372055663965642958892918222470319024259512) * I,
  K(-0.02238709691900161098778845763455345803494507927550647343981793496) + K(-0.3040257824066606119821115835040950067349147672739605207232724957) * I,
  K(-0.3872761700231253366358534387486325648202355215005657080724794988) + K(+0.1578731858984103322291147584093911021873976689740845308548268731) * I,
  K(-0.9193563679182356699188336811686296311105888544036355187589772037) + K(+0.2453445841406040663906191236403687135240291337477311050972034229) * I,
  K(+0.6314600290763893595698493212081883657997943533873592734641874991) + K(-0.3097903726992357828000764115456104940646792645738208309792432600) * I,
  K(+0.7486004425046300680359495088810315584401893147425827870063069930) + K(-0.7152494008309397587561549631612885347469880269701746361675820168) * I,
  K(+0.4177697705441441595956028295293302918912869963011895779160899137) + K(-0.4895249036287130770561240142823990222672192495372232515551592661) * I,
  K(+0.7396335445801478387859020010546979458246436349502851249288987786) + K(+0.1260995295823341251339878954245503870255838180068300711540124930) * I,
  K(-0.07352328718230905321884161880241235984668269361069852586583982559) + K(-0.6642293769805484768395388240252377490667161049119830442988981380) * I,
  K(-0.6702993800290650104800124131972417288809160338992876016034363041) + K(-0.9348445238396301471043223934506717215231840990113526231414989448) * I,
  K(+0.4210632877538638621728143964059824833285614307330518318518297300) + K(-0.6917364309809086576136631005641483069167021205057024741474672735) * I,
  K(-0.5682378593512904657710153449813991649615599269710977524104766506) + K(+0.4082147865448591582052777300569271445027810267736003962283828473) * I,
  K(+0.7680778094839316722272822278888724567189765094881269377317001446) + K(-0.8944999632728503577731631034233038949106041550252132923759837912) * I,
  K(-0.9994133117915292654879342752593618860125890294547443374409886461) + K(+0.2311219770578731073853769027435963311865674481994164988926241472) * I,
  K(-0.1105698931352317245439499206486337238547622255714499084097329764) + K(-0.07760146487211720834664836616117970884674185413330157539066350263) * I,
  K(+0.5666290727994814921785166003636085011091464356239162950929010430) + K(-0.9354809389737285069486147665165529793088170565449099889877962209) * I,
  K(-0.5016865596129103468462584829119291416209229443763799185986913123) + K(+0.2029236160018615280676959308336013032681499220601237066026180448) * I,
  K(+0.2618064177586527108512130528173447824405499903367418599753861242) + K(+0.8774412461315983424953269416864689758994587367414602482405197636) * I,
  K(+0.1629373853588442893940235869862622245828777615139674731681552184) + K(+0.7174585335892875504597631223187974094603243566394780135835334807) * I,
  K(+0.6911319189444447675712428888147945333937940301380797634112925152) + K(+0.6958163221909964863501154185191306961487505304153301747270005281) * I,
  K(-0.2270217078508394865090507826379186091110864274613834975225273754) + K(+0.008907836788665594646344447850392232016642296771511692936361982698) * I,
  K(+0.9212559468146364526231521485756329596121091489633449782055051373) + K(-0.3856186943371093655490268176235162418673880584995663441613142081) * I,
  K(+0.1702987579823588390048195574628203202351253546046653530020142267) + K(+0.2539557874199129933089169031445953065296773225101067726688199572) * I,
  K(-0.7684763991516999563139518687614718347063897698646568061097206508) + K(-0.7393204809038121208243826498625641886021482893677844495373140145) * I,
  K(-0.4672151443102925127062091016944772273171034440397527476442801566) + K(-0.8642407506095927869676604248418961967382082268947741172527595726) * I,
  K(-0.2418866856887109289496626109055442461325908322454009984401686051) + K(-0.5130519319648377615338038722193672224595580806862422610726804944) * I,
  K(-0.9220046037974919008804713090560035730649644552767261230159199280) + K(+0.7695068967378136351192697731307223380686969680445264399333567446) * I,
  K(+0.2935813213946611876923038492366822938508861386676449568438727074) + K(+0.3182172629769212800131539175159214028837015554826586652671897829) * I,
  K(-0.6805869494506066445179249024318091977746771571392553737501778402) + K(-0.7049025854900427205617449326486849761594889598890071797843237998) * I,
  K(-0.3401631819599555091735030015872024609094853132869541747184144474) + K(-0.3540786339516014995679167112875673489227327906787456411452001181) * I,
  K(+0.7267396265330587295579033141002343653605366530731102514843458849) + K(-0.6203305208554837638316050664011305745590656955881897307816187117) * I,
  K(-0.8588692983170300339766621900543999377940166948280474378238406105) + K(+0.4295851428142820550884898780525435005138417225651539185753135536) * I,
  K(+0.9061037247503422213300897598020481572427011345943724871697878028) + K(-0.9987843853683244098539107396029025821646079728078972985036696021) * I,
  K(-0.4957188186893372526987279293128150133785880898880836653278833173) + K(+0.4612906303277103719108416377331376258759991190715980097496435610) * I,
  K(+0.4086969723803085352752557693322557498688199711458954215566315444) + K(+0.9779685308428806071605578440591302891168295775886881284870577884) * I,
  K(+0.4540046336223921269643257870345496573320402689347703294011804110) + K(-0.3344574198436226891744369816134241046254929996841727866608904394) * I,
  K(+0.1376632018111228491355107050672554448223762348197723194916897363) + K(+0.9692718451553110737915847767057036095283576995283836191390683139) * I,
  K(-0.6912607478193528080905258617326608988096552964039401287349559703) + K(-0.7104176077120395779599579242182242987114254753507831477136999927) * I,
  K(+0.4985050896566418329812920047837636902593792336785375491932531230) + K(-0.5924365758687955347661417661458424297332488265832673334562734729) * I,
  K(-0.7831949848629160045215626040705855617440464636354717242270595384) + K(+0.4768169259086813346409226889784653625847428237133854693283259577) * I,
  K(-0.8990140064541207485004925981977412687365781980475312618099281068) + K(+0.1090683700027394438027541427545181955795208716710805810276645453) * I,
  K(+0.8962019828621576294802162162959281521347692205282695451830117567) + K(-0.3521426909834397325995772383793045174125024429193703006565892158) * I,
  K(-0.7293873114103472055077004026396959644809007625492648997271138418) + K(+0.7046642197680372869957966887672637529880734893599889747682122321) * I,
  K(-0.9033036197250120483361862812485160108044394263706838374640927605) + K(-0.04971296282528126558510414804726381550601231875852421232523598204) * I,
  K(-0.6358729911972543349604903916122599404047523391749605158616409626) + K(-0.3287282402940817632143134371470648476181872184661926814005417128) * I,
  K(-0.6050306720016446790679150072832012615974160019647142794444941017) + K(-0.4195104939815955952545032744566864435680392516293583614714703781) * I,
  K(-0.1155559353804391847936526382204519304530689046630813941284316797) + K(-0.1342018948598678034764048984726259446538923766278509730272143480) * I,
  K(+0.7760367952213508936785083875724467518325082903165384266363547967) + K(-0.9597717389556105999697809816230258537030801699391629090830195940) * I,
  K(+0.9270072404862044062222230329601110996842555428649107098067476795) + K(+0.08876987583918408909061894885816201033317717809200725407383383536) * I,
  K(+0.5104957184406321728149098885387164982701327400428902294981512804) + K(+0.03018492408063679249638559911667131281971324457286133980305677373) * I,
  K(+0.8204170398987068909809819072931422261926973231068272582542271765) + K(-0.9794987691966310388418623823574697529842879513456598204313051501) * I,
  K(-0.3215578706623855887402380500403755928392230705932612004098922232) + K(+0.07871318811696571550371188266072936730106428306263691202736310286) * I,
  K(+0.9958752269115317368620198226357257454188896114339582918193791184) + K(+0.8595628403863357796076104810584761683708835915306488481645493021) * I,
  K(-0.8948094090372067874571769103606843453547320714616156748136690047) + K(-0.8777419110470584518492388577721940242100156922507446464553438903) * I,
  K(+0.3098621689883239902805164500493087238905334877261860771423150904) + K(+0.5512132343864820646346282187182203731036283148387061399338285458) * I,
  K(+0.3159598453965445230137065518611402968445853601120306692155053968) + K(-0.4438565382489868486646912494910306504022708984432607639589062708) * I,
  K(-0.3677928574160760354881678377303334954251972663152701023010990440) + K(+0.9246521159836779584105375692353389361028728128527164589664825662) * I,
  K(-0.06170041845803751477560233320823353533406299897996963507927815531) + K(-0.8570037107886083550738437618613633504677579254950884195182946531) * I,
  K(+0.2342934258593672952341922087954759088179459447710826770857459565) + K(+0.2759435600968417048869908592554398137903544867178303783749285864) * I,
  K(+0.6641974987358021842336065184434664620170222397233693651048340160) + K(+0.9808692433633529589232188405960780264204193321183911776403976346) * I,
  K(+0.2787616691461004403941732117767720479896596039633377731316417855) + K(+0.4858708091148677601864496549741356427959468831022473125276964375) * I,
  K(+0.6956998910742789034822345837151387638738034644818822352967587299) + K(+0.3727515855765760241900682678165727433590455300757591655922605375) * I,
  K(-0.1868910559634402491001216878564720919091436538080838016561382711) + K(+0.1103197409325959527252243880355213168740825223642682149912925816) * I,
  K(-0.6351490934083920923396300892996683122320577697034988042802249776) + K(-0.4363314111439546356258738588496288474190494260108872229055834948) * I,
  K(+0.01733328715382547729796203142052213039106271212691799262376042947) + K(+0.7734483443143726490354790038584497222919664565102338471186525786) * I,
  K(-0.2139653576464025507797772256173860575067079212014914089649278139) + K(+0.8200505962255095836614703758086956823372759605751418327047913698) * I,
  K(+0.6130264889031828758992146750231742581851751799661188100900377721) + K(+0.2303430931951195386021233111389680321398559561267401943247190281) * I,
  K(-0.6995641013156027418813214037523977507903427632820874426936906400) + K(+0.6826295723912660503108297106173098875550044129299999035688986758) * I,
  K(-0.5355913694195772662422408549650625879884434057186887581129429780) + K(+0.8676620848030150945902427237548241931093790929948350732180988214) * I,
  K(-0.7476850666224824626356066115693632599578766930656994294002149072) + K(+0.4940330337471183543680316921838143571479261927985522057462432178) * I,
  K(-0.04820626581391157795202688745896353904724854781936746725580793558) + K(-0.9013240061169180751292856778473495054700178089895255010027079936) * I,
  K(-0.1966962831195654797651928866697593183476215762360747140445502715) + K(-0.9347764128376593655775455846967944032900010457766309969616849707) * I,
  K(+0.9281378318468456478076091413160503107936221129526707434606377358) + K(+0.2106005153122343054352243097624810793875925600442876197746263458) * I,
  K(+0.4842280599931284896470621917435150431456580238432673977132137755) + K(-0.7516485938327514133306914490883208459173837409045056497108900353) * I,
  K(-0.5472837488208118247117071650435724084354076986573259968410396111) + K(-0.8417224154504212888507944183332889702114012708467103610782280794) * I,
  K(-0.2586410402343641499823958834835435221001337193816425103250774244) + K(+0.1967910141689372665530369305272672244432318113809654449623603518) * I,
  K(-0.3796418158113016352895209133933301507892346819140153973969370930) + K(+0.3870659347828124461644498676076788251755897539364581496598418183) * I,
  K(-0.7963463537023835851176888657105417990615480856016629275600245623) + K(-0.1503573417195160964901221953426063907123900173508356930167482785) * I,
  K(-0.09616129827861225992024512714255628821739868171006413603111396108) + K(-0.2615642812602631426397010924048881502969357806195799395056650456) * I,
  K(+0.1790376186934244600334126512824849015111006223474826301014085370) + K(-0.6076270817310725541957483215446142196233585443753226100208277103) * I,
  K(-0.4605316576476571054109493139126990250143744036896205168050045221) + K(+0.7166598183628966070039674557909347520879132782069133652935637543) * I,
  K(-0.5544735338854627684363451060524023097288657326849169811045114678) + K(-0.5316885141334897589348449993528164902606602932770065797571940225) * I,
  K(+0.3657337017849054605291848841367393721344913778002341404860270628) + K(+0.7862113900208461220487959702026352369586212245879090349814314881) * I,
  K(+0.8664251076685818038401670107151518180645655253222298680526512156) + K(-0.8603469641133616146246121469817355678680024641793457543381402065) * I,
  K(+0.3503792969192140639965642658883906899484955968147429460937375229) + K(+0.4602523791241454875009043071799611837045974703594133402855268091) * I,
  K(+0.8992981482414206875584102838773417269499521543794277993308471482) + K(-0.001343679446893187094731835076928823283229832402171801051605039726) * I,
  K(+0.3761058270166232761749072194377461973130325853892203863061348554) + K(-0.1933666189616109963575891719147003086630091725308586943244644314) * I,
  K(+0.1410263371322216718523097534645914832785374084592399202138690032) + K(+0.1814368651568451686124285432300029351062851445737332517076227770) * I,
  K(+0.2128904100175200110045881127690079334360584064969759996619834084) + K(+0.03487862628042809356659585410740928160050551568370179898572773958) * I,
  K(+0.4507691181245620130581715203327594805436454449821793969949210471) + K(-0.4295399252242128203309955079148335876952512685680250973986150274) * I,
  K(+0.3492969206097731054028762931590489398788637789015644504274560331) + K(+0.3693407258399284446013199832837168576754549645427530119859096755) * I,
  K(+0.8650417612313888549681351931600418703181838867230682456813727694) + K(+0.6695882263329552647981617788892315950020987368298771857938369347) * I,
  K(-0.1330159458785796366841048302877355344690630465342918869225136422) + K(-0.9171589855177539074524766155065167382630219428438852243808092639) * I,
  K(-0.4033559989823588632829062770535782145959909210867355054581533363) + K(+0.3538387509853371912035863520107158761520423451401074112344087683) * I,
  K(+0.9783290497838670721123246728237338393635766520386674630227144429) + K(-0.5918341763309450063949026395724651193695762635335306742342091680) * I,
  K(+0.4184603418341436902365226856101409070036806375131127603660173436) + K(+0.3335878613273931368367215630891741890742991201097739615379262738) * I,
  K(+0.9180530118798605974000404239133595569843585370892613422179188198) + K(-0.06212199842027151486546752547500904964997651738167594019768191830) * I,
  K(+0.4681867481132565934595872388039579882346728384466023389767009955) + K(+0.1920367699353928252412554028262890904781624320690124001252855462) * I,
  K(-0.4942739735366962068170050127201858021211372292066745989403391337) + K(+0.07631535342395517625567156409215215352610850380888264788293330125) * I,
  K(-0.5490096289977710101808013418171248761306667605924801489887992352) + K(-0.9082467530471811094857127061665123806843806691377373422589516844) * I,
  K(+0.6875685053434594709057883111582189514327584922516453246541963980) + K(+0.04010347024940966389984518238381237591871022815998350441856374258) * I,
  K(+0.4201613555252044290517439934596988097798103314980509138749935503) + K(-0.1245151730865876686131415502483381923018057063424053329283575664) * I,
  K(-0.6134908202239578424414094966221913587095426986702919901732171752) + K(-0.6434507804178724136823527931853692313202939858642203203153734887) * I,
  K(-0.2242837600292000308002980339515005722754375211826529701305588370) + K(-0.01029755290047412999538054792741560730173324799922683205844289384) * I,
  K(+0.1078241736908751519756973714801717313698499549202597829757518266) + K(+0.6132208523600275130972532085451720975914641327865025620766466665) * I,
  K(-0.04031676455448718041715992569585194001783030609276653538855510170) + K(-0.1988543819076537789749176128089809636738244407837156602103808920) * I,
  K(+0.4839330201164067839693013019952851015388405411010453595419347996) + K(-0.8223891967945358592927816458364349144294040610166838295907257804) * I,
  K(+0.6433911655883402615798485870569141425666910405550301590682677239) + K(-0.4765768077604321065489470574703567537946937754161662072299544451) * I,
  K(-0.8740610995777948526105903233099813327025176179570710217579122911) + K(-0.06821127961900017649324341131026170841887986971464884464488117915) * I,
  K(+0.7909859052627031047735967360845921939834796628158481716875274039) + K(-0.1684037528898662083985780492324157642113561825938912894779829766) * I,
  K(+0.6354098200192527628914111119808250315151080189487321077245623957) + K(-0.04308604130606642178214289424519338008737994829634442908028714178) * I,
  K(+0.5899271466762738011600568455437589147862602318638343581936819506) + K(+0.7934201037748059155462471891440915884443282604824984881852090326) * I,
  K(-0.4558823462243831672303522855819397339297323463021545756999735568) + K(+0.6624217576421472116225316453085578738676413030477186922078273778) * I,
  K(-0.1729175660309261133440107086890287530786152062431811586409047441) + K(-0.4728853292098649229199057550708216910448594227575851827661059219) * I,
  K(+0.6302888331783718066526036914084777894966194077438196044816387246) + K(-0.6290433214223894565753416312856443967210701987933834367498954563) * I,
  K(+0.9162739632275587862260092703031544294058766733845498987674088356) + K(-0.4987031975273430285207341093336472885767477505963661316557523152) * I,
  K(+0.4363881437215215516350998381445881472656427070981973141000189593) + K(-0.9982516861280904122873346977136503654118245897216282235954868640) * I,
  K(-0.6484122838687255394995232341661476113480871485647714805889425392) + K(+0.4186207708843831044722050229855771181791055884631589205039094447) * I,
  K(-0.9968849873192832763157623385814354028415172914572754918685127339) + K(-0.1403044038744373581760170132236737741847413801000289215696134118) * I,
  K(-0.9534010519803048896882519505809242742716271835576343539237749252) + K(-0.1950980614311106523719244497184795109888810665528602068676395689) * I,
  K(-0.9373367639088301623981503444778831537931359314674094255714366280) + K(-0.6958713855934960203260203494709799844321392406830177244689863649) * I,
  K(+0.5885667473579219333671490269639827139610011778102641018916144241) + K(+0.7404833574736889943830519615585567556681801857159163135192609188) * I,
  K(-0.5952515118764742537908364002098862074021903656461053980814667442) + K(+0.9584197495125917607073368351630829906364149823504332658905948046) * I,
  K(+0.1190418314282995341934455337012099672407278019013650011057472094) + K(+0.08089980617140605752168224147725357786983304567767070856788763025) * I,
  K(+0.7443138339058520628786007807586225984862404813240074367351560902) + K(-0.1580069239436989936846451488645757705325776940244714138632622664) * I,
  K(-0.8029632209541450117775772212435795959963525284415060378038093415) + K(-0.5239932542604709677052961810332428063231142647764941331727990876) * I,
  K(+0.4131208456381353491450185846546566230181337282964616867056122884) + K(+0.8647019288818498193244014881648072785202743828828193646421573576) * I,
  K(-0.5561815933239741942343400476880640737001601449390745776852062706) + K(-0.8830510585260110685873199240005661835095605228376093969030915497) * I,
  K(-0.5167410481645399941191881931578101179727175253243295297230478639) + K(-0.4093498037413872270806838100787678488435692600675823823965112107) * I,
  K(+0.6730424659065933645717959010356858232061218971939746399491981380) + K(-0.5417152880472589466451269994732564577889737068500203192360484283) * I,
  K(+0.2215014027785240900669645201577949442386609402252327650555075715) + K(+0.8930358967306740448250583536107258317698222913806198391279734245) * I,
  K(-0.04609435091150120600943758314302773878674644454843618690129115061) + K(+0.1531627213384465323007970873255729477832016746098621139693760758) * I,
  K(+0.1645669120878402852868903794767545531226707668040799655444493491) + K(-0.3574157567583997898214010148160526200062108843208515221588632612) * I,
  K(-0.3037446171262969834140824734391425378056266672593970076168982646) + K(+0.7804132721351160537328277883602680647978761546267767994632095504) * I,
  K(+0.8515870282615757028727759714649077201485382111192051430177329529) + K(-0.2179143802250100363393239912437201969332108506183123968505647623) * I,
  K(+0.5319614510308273996258398234490275563517129750303962714291860700) + K(-0.7986783910846145318549322030891860784760280424774239467814263299) * I,
  K(-0.7929739019413495694106835961757434882044238781383873461941471630) + K(-0.4546384392954930450308618336889136600682024179129482373915109569) * I,
  K(-0.5672581488189720338238577588519340576665164845778513316668210641) + K(-0.9137851314663103482916606248700277899547306196256154222245248169) * I,
  K(-0.8265732570317464350933740711034140782674265641134018633936798933) + K(+0.1746553029038461204645417342920112337702640870208738315712526329) * I,
  K(-0.6901596186071516359924512820369044841565050271088942018359257835) + K(-0.8746274396239658332006004633925005324845981484259560493304241065) * I,
  K(-0.01979228945341833747467884910575070260336274853045742261644768367) + K(-0.5698282161350386694272741596893755543475527078576137315978030467) * I,
  K(-0.1951188606123486953091056099258212542689279342964680464912607099) + K(+0.4807055720460056270208825393446933924387017823558718533006423545) * I,
  K(+0.1363777523388211505660439937311676338291180675297893448715379333) + K(+0.3962891530306669429822652485922028195719181655678591856036789947) * I,
  K(+0.004465987962392687940799223405612120169638498689501925993367830418) + K(-0.1864354197400938920089500114282195613159280100830071269314203387) * I,
  K(+0.07817084650033459920680197308590414881671680503814493975924236019) + K(-0.3968888038422173072567764806711103772046534246658073424626562599) * I,
  K(-0.7543912422948843485389648322902410306938363564446800999027293683) + K(-0.1033324381144976803807398958496218140338422124216547274585948087) * I,
  K(-0.1082222642740784278002307166045929241397718267129730972196565795) + K(+0.7030449361387901694874757713877261858838987249061966257787613557) * I,
  K(+0.6838534585276111103924295099601714809784503040294965929155503789) + K(-0.4304796057786340694401296764096413870976418065958478514771706125) * I,
  K(+0.8642299219882527852389967973268114519710767826903641203511752161) + K(+0.7853803911310079980836218153309886103159619879954670231797468971) * I,
  K(-0.7706816301673345047460885751908616045267112862826732602405859557) + K(+0.2849625164797870807549761331653836596242314752925211786813497247) * I,
  K(+0.3170371459916901320572527802733871452370236978556501128012202292) + K(+0.9720058849666279536304828587546391059086275558990551094191395500) * I,
  K(-0.01748824403406788133097536694776655734763349646909567915764224592) + K(+0.01180448547315042160945933184275380301910021646476410255865210785) * I,
  K(+0.9281234652750614586470267724189638551271149202810966784733353909) + K(+0.03872155614811258488223561639227944499296732628302141511725063975) * I,
  K(-0.04838081218967662368012249512625755239470398158407988031687565955) + K(+0.04110682701054082677543634874910087711237862076225318042005746536) * I,
  K(+0.7332047533556445901301102107852191808355313316623187182929976127) + K(-0.7374765733885024909318467912317461226932109726855404969781685307) * I,
  K(-0.4794524670205544776750932889887060292595941089927385156796095718) + K(+0.5000439192198788716534511377198417962508684246108447461374567638) * I,
  K(-0.9865786685105799774885066937620660799572886211245945764957583059) + K(-0.2957781293030783561390868005735183874431847343764848751633007474) * I,
  K(+0.8372422447657714744756989943805054221254779084396746342781583693) + K(+0.9927903666821270820548820103364290308381828326876363888841816761) * I,
  K(-0.4417166906745064143775346874063013467716476594760647581761557453) + K(+0.3898454595117027466476362179105263432935230423712276757439354880) * I,
  K(-0.7205488244655741491601611538369181179468664269580473685527720373) + K(-0.5617304712342051414028892417913080938912018609066714873282026349) * I,
  K(+0.2815261543472967845935041473159211487737748078463470202449292652) + K(+0.7401928470810159563129614531652046233845237156760057307717496295) * I,
  K(+0.5174960448885232341515786560380347219917502017326115214684964880) + K(-0.04506916407923013330616584088898501760901826926963641228708260154) * I,
  K(+0.1559516584675741565557514559873538299621934362998849436823168103) + K(+0.7250564379365653486943759726683025979975721181461774008425681308) * I,
  K(+0.3263421144669247978315746849152002569741072724883078077048704702) + K(-0.7906392465367875843943807563904809589827886945139020559992731170) * I,
  K(-0.4929157286363817818172133581199182580732621839605316745625897241) + K(+0.02147862523689553556381605693097417501613239030668890571156768606) * I,
  K(+0.6141278639594728970188779871928445070551952170321541436008617310) + K(+0.2046556223426512272449000952468339458081297081639612848720451788) * I,
  K(-0.2374118174341923850945271023210975838711708011331183187023284200) + K(+0.2863386911086480209702993142314166907363784225523292212645113221) * I,
  K(+0.7519480088138910659288360917132951018937255419591763341200784703) + K(+0.1594798202779678456584867109265661834964842180782944691628446508) * I,
  K(+0.7718957447412108835227657904105536707369928688293302219476972780) + K(+0.1200100285573860958777664573072435338618236410670831973930149699) * I,
  K(-0.9582224449897466044521618377224060254592666251881976826213121218) + K(-0.5676655392922657637040409866262645854716731099840387643958962288) * I,
  K(+0.1881869084814430611201886208141572491797456050076713184561118729) + K(+0.3014184913113554504677166828140692983758625285024874845563167154) * I,
  K(+0.5706654357646353743764863152098476579651353211863139813095183594) + K(+0.5518251696664533448644768097661309985109666595312151840942669682) * I,
  K(+0.9085422175574979876290495391703267219574040311517456346552936639) + K(-0.9473806328429647327465940808512807035291973782196451227257946583) * I,
  K(+0.9433386185217242856923055770386766682922177613262824086064606459) + K(-0.01324991022157573518647987227465940330805825833772308375520487939) * I,
  K(+0.5536278848093752780037614035914609337567059537229917340464182657) + K(-0.07254783491264946635765468525572679766310050063433224414117172241) * I,
  K(+0.9818014289416607210227642897395802311857508448558338577946210500) + K(+0.7666792622403670166147132445068739435742362098716162577561486663) * I,
  K(-0.1055467797663273348961086375770872900869806723013259136705799209) + K(-0.2486124392343828084043924931871982058935152680100952030803305157) * I,
  K(+0.6196647263651191691812330359162118985187038609994434054115557078) + K(-0.3965178499960413837123797490109928019753710789241058868405520517) * I,
  K(-0.6396558421280489000363718188310881389988825306669617589899411725) + K(+0.8634873174001793117812836282249164200588772935969349125159740139) * I,
  K(-0.7030754011382638429572749194244751950279770883841531916627777123) + K(+0.07832459483270826725065770756472955450066955375354900238098233612) * I,
  K(+0.7049477117440265060283916018110044517923671357151579270097688216) + K(+0.1875098234576405085012032104802159301936745273804068291512136795) * I,
  K(-0.8049016426694294983632000383978477729504834119480955793096640645) + K(+0.6124173877567333457272881572345417469686434511000612292159597974) * I,
  K(-0.1093815347615159125824124740763687724077620947255442005136083888) + K(+0.8859736121741899242612531407243428289943443651896757449985670320) * I,
  K(-0.2072730619053660260431394233913532064378350155506149720831660311) + K(-0.6785400735410656436934514620673705441904939627986926836520842978) * I,
  K(+0.2885936572358518373970491239016484302235803169364620159877055661) + K(-0.5642259739477792008873466114306081834609838808309336363627189947) * I,
  K(+0.5292005384264007284146389611271141932177943933814378648630365296) + K(+0.9462381146561608322492926945884471962459114783756008697004027671) * I,
  K(-0.6250500537821770725864775904451892089049237240593252638033831764) + K(-0.7900509851971784079397109164844957950266078316773921216917254749) * I,
  K(-0.7882204460023338959532283471661007945284120010940056292533352692) + K(-0.5536207220305389768720243020069138969317452896181093817007624546) * I,
  K(+0.1692710847775583984408743416810363432125895898161767226307217567) + K(-0.1610692114756289644613129402788703963878084471938667555512097838) * I,
  K(-0.9518880367348230248608536480074681079515056481436357654344348340) + K(+0.3316593882602436482085928990428993858781771154698432349367717182) * I,
  K(+0.3129345334880581722501537016763519933496822851767210985208152240) + K(+0.9399644594585295297963421693813853435770815787300117803596684507) * I,
  K(-0.09789910697937671059639853180961580313396541747556697276630420756) + K(-0.2764470963388389181549775845967194401765324640336438746922502085) * I,
  K(+0.5805168585758493544671113605036732852756744748905627981465806899) + K(-0.1981034049438379006651056679283198963026511813889368075166074931) * I,
  K(+0.4364998504577406376253892253627396334334723201768264012613005404) + K(+0.7086115248305800690056876262777406931052664621111869154897459177) * I,
  K(+0.7355866210646285376921500698823827735218866238759895162904099933) + K(+0.2641344265459892721146992922746081222119172583505058614383667949) * I,
  K(+0.5572084541171624583681285541358225630004169762219713354408621636) + K(-0.2437018942755864807033523011813135635790204345730952294648050151) * I,
  K(+0.2893787395886493663987779466378917196307833923008006394721660980) + K(+0.4367526115799470263130400887982920985533732539338898393979101335) * I,
  K(-0.5639636598779108528561405222530608792428359923382055654493465870) + K(+0.5814332186818052244320370351469713822566700158679135577735047118) * I,
  K(-0.4089076733709597042984172502213789904778013855816624520836099919) + K(+0.6445201903055868986735537742585099962527699478698049926030008156) * I,
  K(-0.9997965467564057216475327908521172333652996356595505307758131829) + K(+0.6218434741285362973532507513058894488593202716551071103377843235) * I,
  K(-0.3155052979972371881950128145511246021937649107318926085301086533) + K(-0.2158460810551641993907684378296272096170553954971073519918195756) * I,
  K(+0.9407006004610520385748286546610755107199674461953795374572011747) + K(-0.4438147756123136040894139851025983037483286998170279431665819595) * I,
  K(+0.9588872984214709505145410805021104969810294454507068237492709436) + K(-0.03511993104517799380828514451492999463482329492976616987529391959) * I,
  K(+0.2304725619478993967692713187808478770952851079812184570294077601) + K(+0.8009882550811022509033279404856101208553451361341368071863866349) * I,
  K(-0.7256318565428838537589143370652667772182614690341398232367179956) + K(+0.6882459231851377975530560067289834043958532215259039730386267473) * I,
  K(+0.8320652453953516530684999047457210820600784431583929976931301928) + K(-0.2516097863372763576117129318769752051355677337758493321613683320) * I,
  K(-0.9860335907199208170434507368204798230363111424513971157142443891) + K(-0.9939478038085680107526215318366016621266186046866847828089410235) * I,
  K(+0.9790516377285112085770168615313303565335639282365217387978743761) + K(-0.009183400966008863044227465112905838510364509826782670363656987590) * I,
  K(+0.8769897190398631231818464736686279579829401032324480212557522136) + K(-0.2980541507309422178259279545930874939042834789732642298431174779) * I,
  K(-0.6862087676565811774205097725637535143583264146717051564569955787) + K(-0.3403136425921129677742030363260278938398315040994733529878377805) * I,
  K(+0.9218971431475612683150363706027284373753729193228682797937495133) + K(-0.5494616294392324934782699129530644027941423339320038534490825852) * I,
  K(+0.04044155054491831569632383175422726404855049525615401443619878879) + K(+0.9119550446921266288839011828782184037834662960448174079988580607) * I,
  K(-0.07062011336206730154212527872603615732270738943278927311976745462) + K(+0.1748156565722054624708901268246340540824930005068246675885000468) * I,
  K(+0.7314594726118731661987704368511420051403499686705481630860372894) + K(+0.8146573672710095003931104298901295466265969836449907611320037118) * I,
  K(+0.1938836581751577956351921772133313098951051069665421240121013257) + K(+0.3278181385731155091810739331814560761273636565555915521650556895) * I,
  K(+0.5718320027432586502150267992872115574657881252108418576934031785) + K(+0.8037341313326068010005422053293194782865090345152498228442250693) * I,
  K(-0.2432560459164173240486492603541417975366796584262065586208119530) + K(+0.5237937874668247601562481478504586158418059507461520370723832718) * I,
  K(-0.8971483377491173630939313916181810469324823601987470158809767665) + K(+0.7556088462728119842386303052215414610241945492576515265018672507) * I,
  K(-0.6176683163992439163784433472721981849785980301612751542944936060) + K(-0.4029005311299735501208389197646287223991116312890244499600097778) * I,
  K(-0.4763244014957225098812356159256717464515300140774586790748984632) + K(-0.2271040975519382696105694753903445529182685177489046464671477868) * I,
  K(-0.3449512055301327373911699217205801398683416349225429372084117829) + K(+0.6362016206155379017701833129278974983543066526281095057651263312) * I,
  K(+0.01893767570445554687740277001375769407239341866652356584795989280) + K(-0.8727123027116455952618512033616696169793276371529515733086281070) * I,
  K(-0.1968616387895902361245700383176863996726267209792910631093783984) + K(-0.5890249660015956507965291983652583998695741691399313586113478615) * I,
  K(-0.8863983756303306677637080794067260516978269080018540309921054623) + K(+0.1276087226938310265533357874384554133855296991375883200391085251) * I,
  K(+0.3071519430308110347322243525711880604069853138385413595284723212) + K(-0.8507129425071674880314572865281051703677274785663972103049335178) * I,
  K(-0.009195702402450042498757797167902076750935940935298673502558328552) + K(-0.6091211755634502531883085844623597404925841690229994736459466159) * I,
  K(-0.07725361405123836792540126728474054818078322208519819694100955780) + K(-0.1810005497353680203287607956925740152022644494275956197486318236) * I,
  K(+0.1672053271237698188125013028001958713652610440710199130688582337) + K(-0.2335416597870025493731859393989398266356857672188785622370790246) * I,
  K(+0.4192864502030762029645171144097299232398286335915712970176502071) + K(-0.7737834431818909273188738023018212101119009781318695564579689445) * I,
  K(+0.5926851030345713925965718890231967691563655518300918536104007173) + K(-0.07206468783397228955257257888407094270024557997674704942968914793) * I,
  K(+0.4684342868907384842586301640701767339493637687029201323271447237) + K(+0.6547722802061450634675002793347866374611663692231773615169564662) * I,
  K(+0.8278986569983924918025752156317519832305578556112079574179641768) + K(+0.5523924147272948953010790445945650741727973422191083478149854231) * I,
  K(-0.5936828943486070472826948795506305305459484487123474728494023626) + K(+0.7847672996027235189428130952958497700075003063112387551153135521) * I,
  K(-0.3300841047280081437980690693001763190382021259389999685585780281) + K(+0.7056696451692460342936400517564432953067042379262896150269727591) * I,
  K(-0.6323290668394719225038758109802882594178345426259963857163515093) + K(+0.2114595316966167032234217815557633282593854086298042881684160277) * I,
  K(-0.5776528747238483592545196496580213526556125659195011368705815258) + K(-0.9682393415854316620983422907023660976512088502333330900880086390) * I,
  K(-0.9409524293923860921041127319869339260139848647168095185209120152) + K(+0.8719812427657024063899646890051641066385678172403733882124605223) * I,
  K(+0.2953002170508770219809286019904202842527695310085836524734232129) + K(+0.1580087029405780597995566668508522457319992375298308152316038177) * I,
  K(-0.5073696768667651515978126119604155979795816909005784750907473642) + K(-0.5546781514575013460544359048711138610372673310055994106597843783) * I,
  K(-0.4263517325388219124173654481860105054963539881515772151511665697) + K(+0.6273653737521452961427136380523341116628694180777602390427631601) * I,
  K(-0.01639318315149397162041711281077139587301675843248389587755457984) + K(+0.3927753282382731979877388656850245574371206488338698325222788440) * I,
  K(-0.9433176203121414181783492177409093862852060327417650797322318358) + K(+0.1931602792697362116142513024101232793075922598902723029062995786) * I,
  K(+0.4091400902697634121216647161279008392475007472128202190972974001) + K(-0.9241411971442003049929150700039466560371121210172425599063467240) * I,
  K(+0.8996190943626299052495374843861321217581631180308148647910298609) + K(-0.2835319692706243765567264066942774895613561770891659388153874625) * I,
  K(-0.5734790240976182854395733753912762912816570781715590243601232245) + K(+0.9310689277229052431416094328956556359294137838878218294403802168) * I,
  K(-0.9706555760241429004452369839775968868325009660352686358541858893) + K(-0.7661135944914934028340295992335173239580823598379099061065560231) * I,
  K(-0.08551705064179311195834806157601824259776344227135051184347014775) + K(+0.8951261364134745717516723349075353359778764190538842239749043323) * I,
  K(+0.3101143534021302968229264340199635728255401469914649144400995486) + K(+0.4890754957079365610369747719257677967408109576116903642555316987) * I,
  K(-0.8467250373148320898084729714710572049986725165409336928016193854) + K(+0.4690849045941944434186410775704886003456339577163199004068876110) * I,
  K(+0.4528645394227646675749005040480913362190309491988875243760804171) + K(+0.9746827093954126827392614353158418173587259462640486865229155177) * I,
  K(-0.7890821770144572993523103936707637346134247540472534125883675515) + K(+0.03709866131113552390862917819559901689739295081604088903217680614) * I,
  K(-0.8261575059600968767638526138014192521308409989889249557722635191) + K(+0.2359215919059496429703961387303300861580884301020355166097979324) * I,
  K(+0.5517211641268242442649889948189371701125488590512932449035252266) + K(+0.8498100792393159342583604065849810363814350942457631023245556278) * I,
  K(+0.8597122161196648369699543115332541436334682626175497405833935785) + K(-0.5908570748801968544021087405528945991820264834295235931376341160) * I,
  K(-0.5621559666921444792741949379475728719081718370101072504326075359) + K(-0.3394036726112115999038309988220439922758864200763189401425854824) * I,
  K(+0.2467145697995531043026448621634628082958397196902502491846761382) + K(-0.4221317752506940828058884612740547423204890354901802995417505746) * I,
  K(+0.9426795330979194112279256118815420279480792909910404435412290894) + K(+0.6632502094175489640403173962281764793681088748856594130187933468) * I,
  K(+0.4925270152972272315190126986455880929248736197370189402545503169) + K(+0.6236121505872285421315656541097958756088750590702243615941899657) * I,
  K(+0.06491442586599827291154879428181059163788693143338726906030151322) + K(+0.2538882286215041655511631113239525226799811095726255883017672827) * I,
  K(+0.7694207568057503855858403639857784935063497504789357316278426790) + K(+0.7697371914758023316765145968475591314620610107301687016679409372) * I,
  K(+0.4578580077508486133673886137198041211065498764802183822671879953) + K(-0.6611387189964508047361810800188158333540172332410004586428307358) * I,
  K(-0.9922341369715278330574317761949493610647205346542696528399530039) + K(+0.01901682941281857407667930256356723681416184998755124608149978123) * I,
  K(+0.9443594822931952731985385166961356825026244038790098134999506109) + K(-0.7402663055316142017464011161728364916512354152061272424804940165) * I,
  K(+0.07941208160962145531799849086880618827903329121078299081088004325) + K(-0.3003058824228962844711808728880258290598725759724749436385693932) * I,
  K(+0.5407433408095482145535067738010232184802961482621087004376003791) + K(+0.4082747638388719699544297719047364845027827913795647311694146767) * I,
  K(-0.6179498895680464325463459471817040969639946253193465213210555194) + K(-0.9817063161900551409256887667979325507259737169854403579656423929) * I,
  K(-0.8137771950588244445060621048176992327733292633222021573639516827) + K(-0.1509747643567205295030066954464904392515344462212781631786195109) * I,
  K(-0.4291798167988418921153555872095462081060838146687814186322741603) + K(-0.7070783134489328270952958939658439257898088576719070955995669363) * I,
  K(+0.1052909420786459449757724989361434993051794206444355889068930361) + K(-0.6843197572469670035041195405914456824121636889358012358822234635) * I,
  K(+0.9752888327447117486299482738684836222986577066462479072605537034) + K(-0.1252288800308351328156577541043330065165842242291817354659882598) * I,
  K(-0.05898224894780123903486735206469564308508165845637693376145228451) + K(+0.4555347000565132235682525447544193574964904413301855844911355179) * I,
  K(-0.7760171393906860936217574749271766914976525717277739870766616673) + K(-0.01711170073314901178923106624672451563742424839692440419530460808) * I,
  K(-0.2021359284876537053739550998879673792571054603819347441270144133) + K(-0.9756254516897732607478509031003468406898651146363868254837667651) * I,
  K(-0.06259712693759936977413788191281391781952087080054461006306628836) + K(-0.01649946823644040039075506265213082967291360978727300140998007168) * I,
  K(-0.1666024683184612329704875959322736856710312289903139663553323365) + K(+0.1938646355001205575751542630371345537780783580850365415081533832) * I,
  K(+0.7779370736239963611356438927618855953622126535671201826256781063) + K(+0.7759063237095079317541380014855373755621157121929509603299697337) * I,
  K(+0.1047797964339250213384683402693543243317592129910780124830498670) + K(-0.3978244133745494540204079999190293233496927102840616799873530446) * I,
  K(-0.02682743297496726161183153902375716932903767051579817306495112256) + K(+0.9757939511522832771510226289335491526635587155806783959532354201) * I,
  K(-0.1924079225394107220177060393892821014522756536919337038881771441) + K(-0.02806334228246066914632099804340708888758884814906666094720448317) * I,
  K(-0.9949594728843700400668906637254056108564092296500698310050203921) + K(-0.01497505731760724216700280240763107270825594886331850608839808928) * I,
  K(+0.3170610482471332261668843084879323340332912510282978456687166235) + K(+0.9076285806727924752940347754614455175750973425084019393149451671) * I,
  K(+0.2528342594689791750676049977997500107301265183233189421057035230) + K(+0.4717430697770548322101175981507483526534106860087299910344269148) * I,
  K(+0.9594707127592607008774679622484525657744757278914395917439597196) + K(-0.3781633533200910175002703465321220042514135497545035761305689957) * I,
  K(+0.01181104976401880679890071626661922640689741291677064770854085772) + K(-0.2340063812773068022736532941650276805627857154920537092103750023) * I,
  K(+0.5336546130474137326679338240700937955689462563320224763423812716) + K(-0.9403461068115945953639344421862484209221625974278919794210286671) * I,
  K(-0.2384320202781195621829640075756284429989822583855363253759126964) + K(-0.6375834469676252068632350704555428411146489824020797621794745507) * I,
  K(+0.3151544174464479620616899540906004393005210502286013530209460055) + K(-0.3674135502537194516334765452729893774402409336605205611386182587) * I,
  K(+0.2425134587370060019295820715629684907618952841388965381386145696) + K(+0.6285966297073052650556955169730482559933316257019069961206537069) * I,
  K(+0.5429302725153566387907882080933370521221276732219980035800442639) + K(+0.7984157257557289033365054381431030357823051339595863045274158049) * I,
  K(-0.4694412265844583389584877526118118013772122687484860584361214185) + K(-0.8080795111937031348642406025465156077574277068549599191500835171) * I,
  K(-0.7198937142842759860216993112479011691306078055621192604849106966) + K(+0.6542457696203725363985378722041870722351967994537874593526787675) * I,
  K(+0.05913587966494643208917436156661987768847421669977811867235176890) + K(-0.7819364433317138058271996476017516508371669668215937874473877729) * I,
  K(-0.1929654899342841040817393623955425093685207043284746548880973208) + K(+0.5919912166551806055629493949917521452869905264697491706661086869) * I,
  K(+0.6714535322784693494022145169187178652857810313597247247634187365) + K(+0.8965822850041588056097277293607330656491505905440857808158555483) * I,
  K(+0.3026160436894358991234393062993557283036529935293930936819971303) + K(+0.7742603390930491701432481769693441319860278751879593385748104348) * I,
  K(+0.3670266786688800379072412590435965106264233003402312623275083141) + K(-0.3236124902129844500922905218460499865601478408956157724485708600) * I,
  K(-0.3668003319389510140806431126117748874573676075171322461333764892) + K(+0.8533020738941561795513934019213487153711274254680698363611653460) * I,
  K(+0.0004271887137844777455620245553337454502928829789748116840549878805) + K(+0.5237904961810530694460593827213056150961999221341571305574776201) * I,
  K(-0.08187402072286208568481041496702800385202452440190355026834496454) + K(-0.9100144039823849765000930250617136120486789200511933492280273104) * I,
  K(+0.8878807650040420385228182096566860718817093738008498745882819475) + K(+0.6868975032626913332258091640138748525095431506451101476928334304) * I,
  K(+0.2778760675835914365609363974334625977998810581586180753068985807) + K(+0.7903944642079020546832783837630987512542125781351363656469083102) * I,
  K(-0.6124581488778618071556939351347100622174071354507882438152411099) + K(-0.2396204378238201870372787700779659425767796145153268002682003163) * I,
  K(-0.07029357175091748970606590335310221142359726428024207094989178937) + K(-0.1700282200418301443535989437270522473164816159679521496604309972) * I,
  K(+0.6971883418498405851579399694995516458073731003277114067357175169) + K(-0.7656078348319731747803745745048996943922454278311870333316671185) * I,
  K(+0.7967144562809598211804137154122858188425582011480776505268289662) + K(-0.09792062099112865271060642474473284036594446890269058919979822147) * I,
  K(-0.9424360526077164599112040331424203817426864579630979609173961781) + K(-0.7827565416151953839421772962972032280768787040983789994288017147) * I,
  K(-0.4589410475888157689913941890735858498625729001680690344062873955) + K(-0.06146629320167094528306987512173546665830708996053455170751438403) * I,
  K(+0.4314139397147338478071132745016541073709545413186645136099963675) + K(-0.5186860155438391023928035550596309181571513884024943639495606354) * I,
  K(+0.3300125615626590153122645695451893127532890266545371854332962052) + K(+0.04494920605970584232554674303323482817839143433862911513672413790) * I,
  K(+0.3989228905967701791479828294307327178491289349440272361018145756) + K(+0.1210232432974380596226624524763155940757747906658475921519331651) * I,
  K(-0.3272726638360447288989563187245860621714712518062475127448980064) + K(+0.4152927978008980439621838333149110750456245589988984439060989672) * I,
  K(-0.5705581609674721154426677119426650141298998223361485025861006572) + K(+0.8405469954510073324220939129652571110153608816190884757134638014) * I,
  K(-0.8335808856938191240530331270612288738982438611762017019644927975) + K(+0.3059170926453890847698436814116433808088453460231847368928585937) * I,
  K(-0.9925337161371183131096421558705273531604705179459567921041209669) + K(+0.5289575398137468084257779605593141050621766227073799470046206626) * I,
  K(+0.9855027327896559751600530779456196073682502800659489524656244835) + K(-0.9321752446578894375177553794992071631792678438569453689697216340) * I,
  K(+0.3047958927402431333395045386831758591135010747581885958130910795) + K(-0.4939231943374644559594151509258493426482772456953455165095304065) * I,
  K(+0.3554034117455386686975218385243995400748926761613882612217522814) + K(-0.9900852218724664900428457182243358904608364881642465693859257371) * I,
  K(-0.4963765632657733866753461837743469348006513602315134832203660515) + K(+0.1936099386847394047941171895359674458484206458295643960274822937) * I,
  K(-0.8026988384115624782840343188864227150838701904326416833257949318) + K(-0.5038724013682314838712618722729434990509293796544208628709242662) * I,
  K(+0.6994547837757112746940809527671832441928906268710384904140209450) + K(+0.05061573166239406153699823058082640206642179856761473876002625252) * I,
  K(+0.9755325322619697159896946464455971060286259515821700231029353447) + K(+0.08203980377589163398313948645323587265091147479775444766183271412) * I,
  K(-0.6795288055383507664830703821411952434949810576171671197330939262) + K(+0.7150777617331951410964676512508229436929890168347974989996429537) * I,
  K(+0.2972125592316656690738463271397167042462699438211418096166226318) + K(-0.9976797831919179765373083319227377924458959013036464862574223293) * I,
  K(+0.5844836430495149294034374616578027919384773175667170444271728168) + K(-0.5035576803981960556231450009449586462362104936160563219848974490) * I,
  K(-0.1499157108226156262659879430092401527584695505235070239250545707) + K(-0.4055189460775662466882394747384967325177956654133505757604639300) * I,
  K(+0.6386588114500974933880818742348399620506770986491918070275239031) + K(+0.8713826000912526026041384099166139070209900868900373057711975428) * I,
  K(+0.1436641059557912885772539867527176029015379559053444561542810891) + K(+0.3824527624623557899626252772303734549960057802183182535998718345) * I,
  K(-0.5759732930699637873143935535748353697161098806055537732559482621) + K(+0.6571427252395388308947327878278251239948829086633162395045460771) * I,
  K(+0.1048383212970328154634345680434060956628006126092324286866352337) + K(-0.2946549134215997126305110605683468302276612423640508641539039696) * I,
  K(-0.3383109903260470879463212524445929249795505857054957805752659051) + K(-0.5774974286744795486659265612662577741586446125641785809891422872) * I,
  K(-0.6893081464022297659296471020771564908052836129720079117760102866) + K(-0.04411052518501927523222903115965352239272490604913655855763355272) * I,
  K(-0.6282011439369282063769302662523474859244375741290765278945358646) + K(+0.05606878446182798200342647028577909565531143452567770299451871051) * I,
  K(+0.7265794227921631042730867131181257811178661451567824809382539590) + K(+0.2507963447943717368760133521768680375287533174915806201859691707) * I,
  K(+0.7387906227717273339023920666761313938083607156289113310335744163) + K(-0.06651179952508666842538379426523046011212958332104205683199937149) * I,
  K(-0.09714175696279606609176968236497007204178927348722081359249088202) + K(+0.5606327721120352338916640679478869774862410250428710607076107942) * I,
  K(-0.03627651005684656776077295775641701793474480565752238725430265401) + K(+0.6706778972071400451562805952251030143590082975509319155584653179) * I,
  K(-0.2168067278276459168090042606813395925105945325313146806729780416) + K(-0.4187156839111979345123076334706603403912703127169310883457747817) * I,
  K(-0.5335891657673039105288411676464238660896110058643847675177328051) + K(-0.7287958786949843086425081912290379985569728926530885803758000663) * I,
  K(-0.9126250042169909523525835139303829075519532312949160475958900818) + K(+0.07326837789041899159063192739210530752936393138740357615965215660) * I,
  K(-0.6749664871981536754013495610077505466381224242184934039699276234) + K(-0.5092468887833067934955739243868912533037494782231201998568513683) * I,
  K(-0.7889313942672380788018638860627700784971515418796781335861780693) + K(-0.2039751709980185875794591563239623505288486211150876313347905593) * I,
  K(-0.8446976254317627394156872625957584371133402539563408686280818784) + K(-0.8330772101162191260362892038031737719946175581202895012658695443) * I,
  K(+0.8017151369813244166638582835976092993059228231829410307958153821) + K(-0.01551215745707757107170171402988581423170451910034377459832972390) * I,
  K(-0.5245288915366062055739392803830132679699890700797822755979224321) + K(+0.8177856652079935314025164541930791983539725384117321953015821579) * I,
  K(+0.4586577604448259791290225128478032513920194543862378252480784975) + K(-0.3634635865084329264281318787629495818855113136213577999031449291) * I,
  K(+0.06546124572606907042476198155983217547929498830873089970546476871) + K(-0.5487685093769550105679523855787200510124079885154167311451906148) * I,
  K(+0.2532054952484120984081223634386396853198512611895219178828744384) + K(-0.7518977955506366037289832033814401009931024786576833948761572381) * I,
  K(-0.8536111787748305910496495662284597274574713661041921336849023888) + K(+0.5388672070224975742998483137144152340316172278283126664617578215) * I,
  K(+0.8165728526061915500897859903858086797812467322161733589993288587) + K(+0.8357583377320063947395926061292912400776175648059994509562167241) * I,
  K(-0.4968003291175744252090699097826113734098405340046529806276090904) + K(+0.6455428593809199790112386414641355943544125634050765091591122008) * I,
  K(-0.5356148948504710790708273562594776768387583160850301904645300072) + K(+0.4892677177344431877829764022327290253412354307373669874444102503) * I,
  K(-0.9534913128788515636161123316307734458514496763104651760320384020) + K(+0.4792220083762453300153920390462602730050766740331380495001893149) * I,
  K(+0.7107398136509627069921458039049927598707480234405440537577920166) + K(+0.6338991153848931843938061880530442262046611376351085975880671782) * I,
  K(-0.8249136673756817282409390785787007705626159225874855967936269569) + K(-0.7141676712377349871412943132106639291705347577325126271794972266) * I,
  K(-0.6630294762773014358782780713589573454082275032043808471656319209) + K(-0.2448716603733432047830270091165720963287461096352280427006521937) * I,
  K(-0.9325736377308224136969199921783668787458632936193182964287497675) + K(+0.5853167365919005394593151545209808763084410723782778995473039738) * I,
  K(+0.4001575826987994770856624484358229300163447494043804419931744244) + K(-0.6195072899066788104221196784285096273143568259481730851945080706) * I,
  K(-0.6380156577734882433103665462064192941491521715611775375612348986) + K(-0.3796689843324607283904032819013585255191541615733948531742809904) * I,
  K(+0.8251005185343547461750764034637336558430609828186290494569865747) + K(-0.3211578574939984994727696455970628244320185760411605912885016132) * I,
  K(+0.6413931355610670507409243054328434901677309224085472852458198836) + K(+0.2488945759466593721444323203180303773048376746117835911948564611) * I,
  K(-0.9077147176005280056753476260933879201076110215547418406515032456) + K(-0.6125197538943758665556397234398715313722652802519289604125189889) * I,
  K(-0.6706070403358945189803071925983263102149446574542809299835727064) + K(+0.2082829775240114317123964543410189277547466169464841198192803111) * I,
  K(+0.1165516214791020294421410247074940184797534218492284517324623487) + K(+0.8259504918508803941337872238676226437420309998507400199555346464) * I,
  K(+0.2348256225284499338473768484518300107101858839700709844242113665) + K(+0.1817839761866678712611635146874533575448055786442928824834412828) * I,
  K(-0.9112299002745172669273198787689094011439316128023381735802376970) + K(-0.5492926059936056890236082914047749314917447831176350171406895659) * I,
  K(-0.5529023614884813346077776311912214420953774695304422984594925049) + K(-0.2600186716288097612699080971072274428085266673597272583040638566) * I,
  K(-0.9506469315333533579778035161369958866029320143204820199171917527) + K(+0.7824900529811818443153461150845980654886472495526910921625133887) * I,
  K(-0.6218280802116897468553100029322387618881137475664679346461276824) + K(-0.3378272644842715697175567334928393580823285803125397887353844466) * I,
  K(+0.01356526714352777288413228371070366566851199472603351105836234004) + K(+0.01366142939376199277634220805161571650463363474079464996021169952) * I,
  K(+0.4334125819861412550529606653827560134235419055280547766273132900) + K(+0.5508166893309810242537621179962841939093745877465005368095923177) * I,
  K(-0.6781621627715488356369344963566141972285059452539817076828217950) + K(-0.8950729692491324339041791824501042154455479116529046188240665834) * I,
  K(+0.6750998244737758347254296578013227455949239932995953394803954232) + K(+0.3100031744164934791528781351494402431130201138131756501074035705) * I,
  K(+0.8634096863718776554708327903840271408817425431582754052401473043) + K(-0.9533058329688239159105776627634862053479429828803350074039530658) * I,
  K(-0.8998809447567389835490706510861337226013520048613296406489812660) + K(+0.6986977826940162638199085721353358416348593304817550734684095762) * I,
  K(-0.9192452351315289256933069311404271369387375617798612123730730017) + K(+0.8892557550834155636230992491539799713873102487470026960734055051) * I,
  K(-0.003674644472635383105695479271598062700806123973295035387554262380) + K(-0.7316924659823447933471455861969063298583887356036092519485952291) * I,
  K(+0.5454848433221500355230060773019347920133018542553353635351970283) + K(+0.9547703702489051714514559231886447337916171734731375704820214552) * I,
  K(+0.06684027914345481389235477704940402462612686499789789140001129170) + K(-0.3907653387510639571441635270146744856334617519206958292322635073) * I,
  K(+0.9798781038635975409637105428259499994823875753833347065407910198) + K(+0.8433622274559261388850650172073972008259548184020191431115002504) * I,
  K(+0.3559867304535681494008348861460202354454010126219439024668831886) + K(-0.8440846898957816423486286651470640264378919302859116873055781357) * I,
  K(+0.2723284390144714097489628803894150315061371809981568757183296585) + K(+0.2892459018714724200465147087390530489763392727065803296591451722) * I,
  K(-0.5124475586935114536053498096373729988404110310570838847642077875) + K(-0.06397316383313470000295723675656698556890725012554526094240937862) * I,
  K(+0.4754678443341823815890012944367194361922553089426533856091624088) + K(+0.09434199001172037418621458925882885345284264637671326044983975660) * I,
  K(-0.6650383083283095926186659470191489013833159262167848883244799452) + K(-0.9393737482471094102476536738123487839673120103752222755596128649) * I,
  K(+0.5902991058701076032837179958976413528381439909684321410414067840) + K(+0.8929442531101652991585359084285857070472325741010467195888259713) * I,
  K(+0.1829939813202374034979364236079296977605290384128518298034933306) + K(+0.2047124084375247144199346192347685919797414724323364713197995311) * I,
  K(+0.1885370633823871739310168118636986348138511828611923641290968772) + K(+0.3018340187032519691172680933411381588465298483713201129015487600) * I,
  K(-0.6892111158398223232054853123476026737633001892394284932220435669) + K(+0.4887652011148550032322727957856023511840330413702067812452197560) * I,
  K(+0.9461009992824164672730615449251633196307780560130405372714007491) + K(-0.6335880209896600534360281460646646085038842433502042513681753563) * I,
  K(+0.4833118518662508906924235166552474137643038493293815754087792277) + K(-0.4483226382233222897967294663516340141339121909579012884133740847) * I,
  K(-0.3004943448495989281766672164415000848444153878274995952253263886) + K(-0.4085223471224998337746396251085352186343869200375060655836490916) * I,
  K(-0.7451988083161350259406974670856617193681026016111443642517872492) + K(-0.6629747363623946466274969345191221010613899822888364707034994312) * I,
  K(-0.1648849968111618674807979893319759454826855191596780066590224192) + K(-0.03777649025792399922886557033572234862729686024015495583906854029) * I,
  K(+0.2306011062054656295265883563486732077319381744258013602219967541) + K(-0.1647053734470942375607198132298097575422721568309553512412868601) * I,
  K(-0.9262188795573949158115859314466080244967132559543076529166320372) + K(+0.5940163910396123431157056440464889521107043342452052719867793533) * I,
  K(+0.7798866085599888968857083610441898875462935863073634562393974919) + K(+0.7517335220155972863325777934520828927844391420414886559133006518) * I,
  K(-0.1192199062395545666770588543896291569578296569024141822806510474) + K(+0.6309552703193023685813966009593377968371664683554102946046741424) * I,
  K(+0.5032840388614729717361101070711972297891875277456619037197140913) + K(+0.8133501345815104872146728945530214397185800645063983851990232402) * I,
  K(-0.5079743327224035418630093583198991739913266325590634455004141520) + K(-0.3663315374366981725877804145577504684166939645395072232485711667) * I,
  K(+0.2178664873168638860289771712596580315708682168640763920967932516) + K(-0.3579916317188788346603775790830235504155542842718204183629326250) * I,
  K(-0.1483409539215602340820076673958439731891585494425542620227552963) + K(-0.6566970045256221747695028275955890510036258593165834955110026043) * I,
  K(-0.6337578170128106867994636396266521716149313158896095401731507010) + K(+0.6324228587786825747459301038851999732122405060041797767780461594) * I,
  K(-0.4910347083621581870372613987015158509743193141324583730532304188) + K(-0.1584160550488556300248087276570818066880453700151335213740391945) * I,
  K(+0.6282688907429816122107265051905982032900903635549476641705827585) + K(-0.3589058563098184418994082021808159558166373173843632391001978079) * I,
  K(-0.05789152483302420384559312476410946833437607675139337638194936651) + K(-0.2083316894845250042355574216767440348964321640156855571015989785) * I,
  K(-0.9598541273941382562020510494306595974408089178701659267933594678) + K(-0.3942148407810254968651402511562710457489714782384456834586689444) * I,
  K(+0.6591032272906371197044358785496829060718818663221162669839838899) + K(+0.3700285651823920795710391288998722621262017782616722806938546520) * I,
  K(-0.6841847796171043201007793589198413361573122707222650137493385744) + K(-0.8892506955157015627586673016482794701315232492361331171805566342) * I,
  K(-0.4490382090113379021373358845335453044709703107312444369361269994) + K(-0.3427828787313490964113872534257667011417065426000327051523036358) * I,
  K(+0.5959767530088681246431914942336139151502265145148217885271404180) + K(-0.3311647754345311284810452963903860082176507661861942285158525766) * I,
  K(+0.7363287182327324719567350693686935825718194996961756739586744562) + K(-0.4497475317917644916512014385148277702116724424489191663479626462) * I,
  K(+0.6287591847609035515525283033789389342219852959522679117716113983) + K(+0.6087205673484584931404040415443699523171693622383527217267691607) * I,
  K(-0.5459506236385083333360732574631520402867007962637282180012784138) + K(-0.4115811594792363440834258455632796424919930613280140554470788500) * I,
  K(-0.3154884164731788649331953369010876058659159922637661095873392397) + K(+0.4594808885586875425210326968683968368964434371024059558437836780) * I,
  K(-0.7356079834968325519072737716960043789985936432123631497162464547) + K(+0.7107222920700186922184233267422899750994273989386050071707569100) * I,
  K(-0.7439937939085200596920771851854612500096266125182499257774690463) + K(-0.9834307112667122059938047261995183680166823206276998193508697584) * I,
  K(+0.2259741336229993901681417009012748802722968754989122002268213091) + K(-0.05881024942996154580328987453439301088551729100209210919510151306) * I,
  K(-0.4504972376487225968885246858575950279488610456963886233985691138) + K(+0.1804882686510839855580231337482566943183195681823601215649202008) * I,
  K(-0.3998193870049613563279720987455599306653729703919087588517795875) + K(-0.1491696174342642333410262224912757663609237454028680962451785192) * I,
  K(+0.8620428761980095707203776677055528706029654578895906569678604334) + K(+0.9574127402261596301911588233060301441321120212609399138711219452) * I,
  K(-0.3999594472795792489113496051183414726051219134180559318727897845) + K(+0.9526750071438631316246110280676630480983916031334289040262627220) * I,
  K(-0.5683496236745915059300657862338897855672643463670025251873552174) + K(-0.5581740122131536246852030759304634294336792577900494845808941858) * I,
  K(-0.4953163587712331766175861376254934702894822426084064353999022035) + K(+0.9056970150976877386824055684564488188904472004578304864402419229) * I,
  K(-0.3956584533022154473310841466588191797692618090897753648383519943) + K(-0.1866759605828296911565688241168747631072448806167862942658079731) * I,
  K(+0.6490730398663891702704071213748030377822129386984802236811118078) + K(+0.6897664921266076457367049239651198758874037925837440024990968393) * I,
  K(+0.6409129861614716486043933482232738006427515990620744560295911729) + K(+0.4415410295325248272690068789118962488980664431243294713525295832) * I,
  K(+0.4524204122204909398617470969312723093453645259460874600592837093) + K(-0.5520286702480049877424376966137284638421133618504988325998290465) * I,
  K(-0.5441405057638994721873863385679604597665542992216947318448070116) + K(+0.5652427575937872816249202601343444658504537918597921662097147502) * I,
  K(+0.9397330962272531775633434449179993874545865861022686731965759920) + K(-0.9583114144578589556015956315708583008375199990360430737388009113) * I,
  K(+0.8174282122000282777294431348985426664703982648984950899191029812) + K(-0.5644141518298841315185529691052828426308501947745428418129129080) * I,
  K(+0.7650528326687435807494094139025837401308682157417945752977003788) + K(+0.9605162745942351990878306802675246183005723477066574569819249804) * I,
  K(-0.8275415913742612370129017097156704362717934848531284915201158697) + K(+0.9572318094738380497537937020853007165493421426814415684618445487) * I,
  K(-0.5344205736705223881799463492737897118292436754996772261580187183) + K(+0.5810078558582824100856104992245709584145969464935581411817657853) * I,
  K(-0.8825805958693646149282592885541946576477028329605722157610083902) + K(+0.2611424860804339202936557825909397840191854251028091458127688102) * I,
  K(+0.8501598175389059661383119602791260742411506992108184778011644498) + K(+0.8047632441868277768588895792106603865660075238818651567796032066) * I,
  K(-0.03206786558957849515019832566430842021512540520763920998999733706) + K(-0.1416663824912807956324296750828754150570222102753468294528577087) * I,
  K(+0.2761266293345805744715036677646265855148255037626491960979338378) + K(-0.03310727247093293095289729002649789856427561682346238112819027401) * I,
  K(+0.5797977533388933253222951613155906369646791148641171722498975627) + K(+0.8337769391809389398939488302277621472580552905994408399370440954) * I,
  K(-0.6301986261336408698761878878611306862036125741990658971071103101) + K(-0.7261308877086333686778937450774281440664322189241936468419319883) * I,
  K(-0.4394771097465111922319557429099501803935899460081469047018581835) + K(-0.4557178634750971751702906056239773386653623487996337433702382805) * I,
  K(+0.01257776159826495283976432949616909049416429792023320005281444922) + K(-0.1577948514857954743861298114193711963240976178323527625330715503) * I,
  K(-0.1835485224672122724259108987896566438204647780797278952340150540) + K(-0.1013752416237176093692123584984723539700861932852539871318876100) * I,
  K(+0.6179505402995065171357704107898154449772474669193892960591234641) + K(+0.4508061769156545135493504841692422664040228521015550731304403311) * I,
  K(-0.3155120520033388513469003738092690286251880819299608662445677277) + K(-0.4076215490374446263972586004673857468937481887370355477041024666) * I,
  K(+0.6986283858316789125493235244191481788746296143090405846950937468) + K(-0.9700195332674329366610797417087486072247419419624494697821020415) * I,
  K(-0.4876563532476417657751796483987116509778485571581820494734743839) + K(-0.8708130110861858699317585051731156210414554322084777189878090155) * I,
  K(+0.8232644580576667390777726663349145812373613266685354075418201465) + K(+0.1604567427734488926693542624141268223027287022070858066740526676) * I,
  K(+0.8070846547687141361378739553290816808653249130598611636404845843) + K(-0.2235139265129202301070215025667430078702647154859136992474506936) * I,
  K(+0.8966295672688665100637233524003378759546944598051542827645567316) + K(-0.3303133032308624565971174149040708109200906003368840512765692704) * I,
  K(+0.1581799270080592282588536301293625116070980783459013925053828065) + K(-0.6480842105223432162460852557855317675791154443407106922249140424) * I,
  K(-0.7176104224474691168776778994369965125939606645748211106557194721) + K(-0.06524747399019433996288718012234906105857921475181832187159764645) * I,
  K(-0.6726166234623792373084697558143568296933464420576355313314945757) + K(-0.5576060156833500139405240035673658119377599436016214285717025316) * I,
  K(+0.9523396152023298654254897174757154850906582944014960012030679545) + K(+0.6381377533491732854464428134357223019844933539640957396971922435) * I,
  K(-0.7708351860880353592291986884926071351547298438465440794835725021) + K(+0.1614576823838883001652849668611700188222844936338259195240098388) * I,
  K(-0.03930973935207432850615318973213241736002619537926065211687982084) + K(-0.9874676652555534248418202699535837895482379952926406102324813110) * I,
  K(+0.2430787921682270251674914610595159213144763954023036371616835831) + K(+0.4791048328493252429275603951864256993772210852315395407073036761) * I,
  K(-0.8601958311715732361924852983110132399300858537143688326207084673) + K(-0.04181346067011184402633725829307484016990920092494969402403418739) * I,
  K(+0.5717185869632246201786178899837673196957609663681608046838913063) + K(+0.2989611103952239633979300623982969443516314582155577043730256953) * I,
  K(+0.9352901685006566693908410586177506588967342601446467801895342389) + K(+0.7778732565745188225251985991033026937128797632507563569923623951) * I,
  K(+0.01582166386401906574651472962064535462956580151304149938138758158) + K(-0.3068809154124639472167106576782145915508219432613048139299589623) * I,
  K(+0.7536288477157581037866281210429631551393667689421314023285404669) + K(-0.04106717323652871277400994434693569394710375031954091741457333216) * I,
  K(+0.4989798492403513452746484085383445579079231648129387523648696519) + K(+0.9793302102332378179253695863721121339119913939603157803966226561) * I,
  K(-0.4792741799376563234300656805703585023111489683932477821139729329) + K(-0.7854388639737844282290868079127730352399967124990821223802463410) * I,
  K(-0.1929402008861067064095768760161507488782372207109471497117171716) + K(+0.2923179818189228847236631906580915532900673112468254085381542392) * I,
  K(-0.4680809400801900828333929836612923353519237598313414573416754860) + K(+0.2755511969524253719068662041281434823269354083999666326323113864) * I,
  K(+0.1907563864448273473258766658129159285761111417357433078614243113) + K(-0.5012026075513546013401077246760946929686512238047013728525207218) * I,
  K(+0.8287842467802014519436223939195381128147158728946565676201108541) + K(+0.8733676498272390390377707882402549415195034726188723951164894571) * I,
  K(+0.1174888420915726259915401485812553368656991784532927351322970104) + K(-0.6121851226213113930417327738957374310029504330292791328144105082) * I,
  K(-0.5009961917093371792847251404544239181502334235864073547693084713) + K(+0.7301837750682651071556817683778808533148623194961119948417498666) * I,
  K(-0.5121399326570400508578424903207261388327176631817939505978972571) + K(+0.4045949011727621782800364954665618409036719100809085938546930896) * I,
  K(-0.6437340163758292626020246874118851364552161448604273058860421683) + K(+0.7921013104777253836710072186845396934843233968517973417977152655) * I,
  K(-0.9177377462686133267057642860420109158115432852625006782429209021) + K(-0.5274141921852231457233231177139101462718699729256100588999266131) * I,
  K(-0.6069543315842561763570369392772168744202778487586572261774702228) + K(-0.7666647535736805201745423005557477628002784597561157774452243667) * I,
  K(-0.6461759930446084249525616314260830230497178307544934672773376501) + K(+0.09513996718932546123316550161697750388237688034899079159815219686) * I,
  K(+0.2276878060391758356127983810819025559996049179420653681868271271) + K(-0.3574194026283994780014498877767281274554141992357751175624458205) * I,
  K(-0.6911095202587664920027220871222137989330007156670602042539098861) + K(-0.4939209203507022174650127829671756826296692447472437208993072812) * I,
  K(-0.3791385029050835644305941962878861413853976820836059306399678685) + K(-0.07618298482527548338314500068479928898895645437787759238249775626) * I,
  K(-0.9297950486172379886326272922097727589255018987288020195329061792) + K(+0.01584852297272254687809998042228455515777947396762877328241174920) * I,
  K(+0.5978120655302577897398179822615785183800970714451475546948192269) + K(+0.4396736175777181630721055479569884679454438653155446199204637311) * I,
  K(-0.2711169101968288477289403278799709715797466425987475511419715567) + K(-0.5911314949762001008761591052670895308415762896185862068692224440) * I,
  K(+0.3067884738128241023703748810226548349655210814883406744024888764) + K(+0.8896097564814875187837512680236413436619056022509304029420789135) * I,
  K(-0.1020589995988566621696963704190836086597222648461835033743029049) + K(+0.6551217217578445768719813077362897618175360407256364824777068574) * I,
  K(+0.2572868615782312303244645509127292235251321239052474556863317774) + K(-0.4017942813961258813231362944996574489980755499906050743104266630) * I,
  K(-0.3109036371364027922076093118943144688680297003351773705356497902) + K(+0.5801139602788147318825317805745513321698472884814526703283426126) * I,
  K(+0.5781816139922237659292895739603609400312924056221564121717109152) + K(-0.4797338850487356240644843228358421703418457910648023129657632606) * I,
  K(+0.1637532411037421836301013040933372166028978199642151357996411870) + K(-0.3348404315470130224126278531676835448506273165674038965071666047) * I,
  K(-0.05448346865052912314449269930630611497014180732878674418323384351) + K(-0.001221343337113800433409266435908640001189017507063563523457586689) * I,
  K(-0.7182891181958485604783683402050659218097400169801898727389994680) + K(+0.1156359317028952353193121051002322985986004018667113952765039832) * I,
  K(-0.6234802291417603063118021179695466593346766446573345951285145053) + K(-0.2054322857212639216653176795116408271500848234875000439708466729) * I,
  K(-0.04077210393193515591571693561563561382580682422487648705750388580) + K(-0.6029163230908826523920393959138752304849344029672835884674953741) * I,
  K(-0.1931959637343216600198072859033136267515159268341655254119195147) + K(+0.1704777831078669914939560146783668826179183867140297974581085959) * I,
  K(-0.1640562752177173000518388401473302715304021943460936270643564456) + K(-0.4098047345918440952767064586759969480183029327032473024839238377) * I,
  K(-0.7113952988171483521669109524935084591237692588100812878572445623) + K(+0.09802964954027621468624464416369499303955181797593605050999746028) * I,
  K(+0.7225552442665041942306400216887319747127650729772784736192486726) + K(-0.008288576868394157524240928994008764634165384301896122048524109687) * I,
  K(+0.6696559212496133843412202633582430830095341913580601757885840114) + K(-0.4694034906519090416234475776850826552069293984450469976131306363) * I,
  K(-0.2477573413433717239092284627923378760510256864737970881010058195) + K(+0.9656663992029872463818179063225894246510306993061011773318581499) * I,
  K(+0.7260888036640339539696167931497140025739595379178821590392729297) + K(-0.5305345842668020093947514773845955511665067768865307747352562913) * I,
  K(-0.2593999329831458312922569852142126949730768494663138411621727182) + K(+0.4299091082677700596049604883016930071099042727671826368541683530) * I,
  K(+0.7805731318555466806245478505839205910056169865196206435373175290) + K(+0.1735175920069565544162930111804844332352663985175385046650225985) * I,
  K(+0.2225972271804784069458834723146726056998779728849256282174146251) + K(+0.5587214476815798280178530629336354888118177014496821597625842675) * I,
  K(-0.9548941421504042602263566866670753004405806516772113490872266593) + K(-0.08340406497498829686284081970443719159644045126514658698714998018) * I,
  K(+0.1374554001477812795128965629201263587641134916889142713346840749) + K(-0.1823427917940288867599437050041642843645381848226470573828810133) * I,
  K(-0.7447813660569849007594756215088674043163676405884314159889590253) + K(+0.6625009798658174158696326987978538718391281574300854530864952129) * I,
  K(-0.1870528845751381055406447101233890683003167309561597870823274481) + K(+0.001102463069426490139188459625757231481544376828769031923382621509) * I,
  K(-0.2939813881255477328254936712754663933713604749486366402348107568) + K(+0.4088723066217878198131073304572117379570121370757559741669418714) * I,
  K(+0.04110760478900766139439728713399648104543220286883006383278374315) + K(+0.05338167976938323186113130853788908337021939328251002314697878551) * I,
  K(+0.4182510589252267745268345893766436817062183291983719521912907999) + K(-0.9047567657658759311690160502009445810146448514571007325387449230) * I,
  K(-0.2673667773031461832097277685641087337154290911804289027091375323) + K(-0.6518833669193621994145875437681347763766872362083762418737378616) * I,
  K(+0.6449452283775363122036755346257738777141700581176766723254851256) + K(+0.8062959490954535781650156248054874077324700516698196837392997867) * I,
  K(+0.4829533585013432144398090787958213048813114081647695323038258989) + K(-0.3790633506531557850527537678968941902222987060600304390599414408) * I,
  K(-0.08755497794836064768550464065217434290166596331366233981722270684) + K(-0.6691126254079243084008735144895281341476756029909966654650143480) * I,
  K(-0.9954997756541157164998715698525197081923318420942550944045491659) + K(-0.6683817932674617203370743321364206379458813837219662916382352883) * I,
  K(+0.8386261221527333989713766408159386657480295896174100980624903149) + K(-0.7147874364051116677352023678916013721814759480041934914674011485) * I,
  K(+0.3706416523112995975937180228551869912273234844900508767137904500) + K(+0.02812729673857212539387797400510173701979820247691828023019032465) * I,
  K(-0.5600959600099672344370766242433848454279358440226693818484528777) + K(+0.8578883406487974560083577217522867662231285915212865599494393160) * I,
  K(+0.8297736412128671086100613995472148055783982479247135711009337678) + K(+0.9067805316062881652030045961298147535346164756511802301521412293) * I,
  K(+0.8977055297316245102135797355537296142813523877680518590009014110) + K(-0.2815948643678193535474853824166422268419907636733657688598828517) * I,
  K(-0.5748197983543169624203191591434285631771190309195548827795692102) + K(-0.1042659890874534267426590419380487960187506763364665157101038917) * I,
  K(-0.5858409389326448395809133835855451350070387804813596723936703512) + K(+0.6553098806110065499549873014278104726229393160003347138387570865) * I,
  K(-0.5671838749074228774546140542483697483251436775346581730637971376) + K(+0.4933862050436535820294608065577586385277550091654140504047389386) * I,
  K(+0.2952568664180143864626295175022288018699455321585930507794665032) + K(+0.3363291776468052564679388108815347170771974621236444483492781348) * I,
  K(+0.5855294159377460607976319944754073739723999486547787547993774030) + K(-0.7117700245324564148022438345454695812058382984762417755266869072) * I,
  K(-0.7055600913032675386217255594879831116355925226714928690713485615) + K(+0.2258090140241147499932680835169857340298492238985038263347028561) * I,
  K(+0.5760242151078541779151257112162570330279408239873997232647912224) + K(-0.4033813727320000302455192868936090230874238500285433813234602349) * I,
  K(+0.9715114578623126201047702965434710253390063604361885324341892341) + K(+0.6879375330769172373119535275678240154773283854291540103838311325) * I,
  K(+0.3039337296565886128150504743929633802959698656670343605396412219) + K(-0.9112975399598570646267792030364316232472089185074412056869186788) * I,
  K(+0.6236819518961590929846135479960273156754367073817207644050176002) + K(-0.3607013878413097669346575028743143752168816068771476888837201271) * I,
  K(-0.1021056993426821348307935897306285673021901661096630313619218232) + K(+0.2425871604000264971221208469329499047338616965543816754028958637) * I,
  K(+0.8466162720288430485709519274383597069807088506835546500121602073) + K(-0.7087616502851563010492290961247569658643484234719292087244652051) * I,
  K(-0.9164882089543033870340315899504738014407219501993627157810897301) + K(-0.6131167343529433069430656830158589390437546455542959935005446339) * I,
  K(-0.7471369081337250169307950106724888822831609321138127864473358580) + K(-0.9075117425364026973558801801995100670441567351278968389136403765) * I,
  K(-0.2600172562419878647149957405453275593591751645918607919664288729) + K(-0.9904816234002496586495092462467362502947498311254471303986136975) * I,
  K(+0.8607156851539854223694233878388323728755628116120369654828929715) + K(-0.05330812308431931728504733011776707761236207290899697737458171277) * I,
  K(-0.7176948244425555148350261859077056953802775389924452361155185999) + K(-0.8801102863168725379873608800160169932936567490013417328394953225) * I,
  K(-0.2207841432558825941950723740995817288770028938321302067625149484) + K(+0.2137027323832541163066962905801071802915755403552583940938654725) * I,
  K(+0.2036491702001318699990411429390014676634458418153582557928198147) + K(+0.3246754114729342711760184362813163331733363833449700108785970231) * I,
  K(+0.7254894068823261178702877935658935391536551159020282383368875414) + K(-0.8659912861493832144978103366771227821495411376318371969710448016) * I,
  K(+0.0001368832398907043532254685713193012214855165503506159973402165058) + K(+0.4137222876012845945746502232607524135790244079086517518245857222) * I,
  K(+0.9403770858493412579735199702793868453979673282107468402972875089) + K(+0.7307895039196994918262572049899766008252535345400758283288540444) * I,
  K(+0.04493477000012427502508167160228754371573129967318448627165527691) + K(+0.6253764770426165547733541204791477897809960997138602075454043508) * I,
  K(+0.2102079086273819515000703150681247456068069917373940555095490500) + K(+0.4087514873231722614338811543024407547422641720961487394962518892) * I,
  K(-0.9298803913883027000250793538865301736872235899370902397802297405) + K(-0.2704178973356339872712451836668950778711166471653441265799186931) * I,
  K(+0.4195999016378148254846865060955021160332507084900216447329462822) + K(+0.8363430715994018422274207415377730140188115953297645291847740633) * I,
  K(+0.5592313747190898094101761584287532857788163390332779183914631326) + K(-0.2559862609303912542976594197848915459368820167192438627779639730) * I,
  K(+0.1310951125620758665159054012017163111810563122171212437642206389) + K(+0.6162230926057769086547780677049940219082763483085491444241175199) * I,
  K(+0.5720383186059179015293836428948150248475974704662851604059015451) + K(-0.8922868955044164563598849573370708504120673595669227993217237021) * I,
  K(-0.2664807881547990846148168222569395166570593995193586268032239580) + K(+0.3938680503936648418506789717427717053106663903484318321692351571) * I,
  K(+0.9567548826599194805036438899026483771002191542535671059856333142) + K(+0.6654347186164449151004644801831627545437328008844997923525666613) * I,
  K(+0.9639669575431064311765610481094274927853342650244440098324137926) + K(-0.09576122477954257199055166123505969585140980189998659824822674874) * I,
  K(-0.5843149770166105247872089022198883206400342117067963907790706706) + K(-0.9530843659695100292333594665837827773582165041769282203822400257) * I,
  K(+0.9884120198511198054043694914056082596373247994045952094544108377) + K(+0.1135860588033233284874678209451779361571050377102422757837015761) * I,
  K(-0.6126849877719582415423067589960941787401359579792483225486216042) + K(-0.3838871523031121229038477644714066220351875327445192886095377643) * I,
  K(-0.7574237137296950124583435249292134665057711622186176254730384605) + K(-0.01569622779753982869418345886106772242845745262096940801347486104) * I,
  K(+0.7376765835670458584693084052366192109490100576526167872883439128) + K(-0.6879576679557708895637642186160446385792902520635997654975427700) * I,
  K(+0.2848128248389625158436958687302029337407156719506329634098815253) + K(-0.9552979693894506687747072639881573174213290999022676783211061772) * I,
  K(-0.5778691962993075572816992415073791457417189498449348815609400543) + K(+0.9610245466208243539364683598681316310154407513246079140063910914) * I,
  K(-0.7244005741644250835326164733871163383449556747663495576951753607) + K(-0.3532650688563323866719318601753587572939170687588761942990622164) * I,
  K(-0.06675920661058512941191250157735681803297350651636083048644287513) + K(+0.2601631387913555854768528504797918892204892799877699394044705664) * I,
  K(+0.1177618192581597298410134357502041699293969049381355284559850824) + K(+0.1417321642096361400094481127274847082744916092401272061123426479) * I,
  K(-0.5563302181473310402291403940486311408427313461354609285215107939) + K(+0.02166026240185131097185602710108747360406028859813142595473886158) * I,
  K(-0.6617985790447350279645382353537002008421917879520491962285682083) + K(-0.9280405859401190525529632296217767721048293483348513048264198395) * I,
  K(-0.4162821597971221064242723905706637843852009913745963415374553533) + K(+0.5776416467982883356583938493221196028768526059917886346444840639) * I,
  K(+0.4820138301883054393141576127806079077747759726504906890512100561) + K(-0.9316417763528287411491181932964033717350145300560804495519946098) * I,
  K(+0.004255247053220032733109968076183306696979530937286497834222491587) + K(-0.3529425582001484393911110897416806033252735549311939242369336654) * I,
  K(+0.1702212073087114578891005139703021755706960385588359062587645359) + K(+0.9836744696029529772535675018848968948860805528914686830500823930) * I,
  K(+0.3492201903166792897606582549529303726835002744364714225960777363) + K(+0.4690022830874778526117835063929424866920162457383092345237313784) * I,
  K(+0.2950341085083625144858391440571195253962255308842413213260072360) + K(+0.3153167725551129057914307079782055213288763612802446610697150966) * I,
  K(+0.8817411976487832022386250885458485461947874354362967271606625680) + K(+0.3992932493642645396749806048792182222287471166498445115277424127) * I,
  K(-0.9913142038122318887175101420645499079035721368558987677182798986) + K(+0.2003648989407845649614662128142635437820350300906378237809205716) * I,
  K(+0.4056621228297783510852298470933760655190738059189800128296757785) + K(+0.6930316698342635795819711095739339106466593582867089083438891473) * I,
  K(+0.4951825335821132444426832318610140688740799897059683569028515011) + K(-0.7803797878244736004239822484473653547847709976862536174611242552) * I,
  K(+0.7541876323403302890759385032296350660836737967940228768367360635) + K(-0.4230524911386144075947787138970500460560429224208632883635712692) * I,
  K(+0.1154403845735876226285367678037051760585029706455607102866418308) + K(-0.4879808669019471117005411736030628669983733630465276368170121060) * I,
  K(-0.6773108910743919148428908835465406631786520563506936147642808556) + K(-0.2392202345573686580205754991380368640085414040740202231782988674) * I,
  K(-0.3440404316030513250214516061337961316399180197567395917780793606) + K(+0.4680243844056543233797514372563044210968103519317974008967064449) * I,
  K(-0.4835214079291459680041348477034756503050352875682696402043572250) + K(-0.3058404728669544191347587300829264620447714509872482957018684679) * I,
  K(+0.4583883887217367654468190824186113249319082216393782829925043607) + K(-0.1187521955303458372856205332315512366755539407892848329308175277) * I,
  K(+0.5626153000776218531308880362853089025203052816257419215761673255) + K(-0.3450584107813966831892246587606121877095653380895811106045244914) * I,
  K(-0.1984825026096906517970053518616383611014610057521533551432742001) + K(+0.3539323991083646039967531897317169810149461355207063695724839730) * I,
  K(+0.2001293712829955496281027176493135655461770764069048742599881716) + K(+0.3796978492521124007236534513230833894844456164259800541788180606) * I,
  K(-0.7933364966016296657172368430186170066778035863466470560903696300) + K(+0.7372984827894892001804118348103411083030461998335671164183190792) * I,
  K(+0.7474272552628260193077520196350425390620011373675336238370743960) + K(-0.3259560227622352616979362991553157464259907295880839733239754090) * I,
  K(+0.9105070415409436183147679714392474097629801242648314889768577416) + K(+0.6479597392421423158273985079728339050768519438135287361867844377) * I,
  K(-0.4455750654061535325860263327910666214476307756435216946392086129) + K(-0.8801272093921563140409147664131014021154801757042599774070380524) * I,
  K(-0.7393151719656929790853225464207293118367847750772866271760745836) + K(-0.6037326157807479627322010983103417517257158763200920218003518686) * I,
  K(-0.8023381170392978845440097238567938656282910285182366907984090584) + K(+0.3591708440228918192330845769552627971321577222600898654140601818) * I,
  K(-0.3498416194424712871074168055345207178514023575986328403056981536) + K(-0.6367066395016486091193409728466257845612710689444226883067927750) * I,
  K(+0.7348333999732120078731979425961267271533387596527125693688872047) + K(+0.2691727021113280217394430902657775380814964017899361193705907930) * I,
  K(-0.5291807182237820810013261247427895101370002221061189194972900456) + K(-0.5275826035040083565176801437000058836299383056186925822417718170) * I,
  K(+0.7267777914769065605424944956146937645485567314048136071435914573) + K(+0.6442662194838787342531718828591809289868448911186186448296598736) * I,
  K(+0.3140537704643467198080878308278790728967712941637956155281517007) + K(+0.09871207792452377148515934547171799351531064908968075802017648899) * I,
  K(+0.9398506125416071924001967503728978741933077768226998998159065363) + K(-0.5851717691694023250195705233074471363853099570708331297134892607) * I,
  K(+0.6310654306261877659425763417637926218486072576001186748720437079) + K(+0.2612239371958172077114157723531517910643533758318848104024883877) * I,
  K(+0.8767457066491292262650632249863209751105652304747330153126773346) + K(+0.5914937976659843398364849432034903606083830576979592520055074707) * I,
  K(-0.2806777633052923898059188891463204118578217014722535105523271493) + K(-0.3734114357045290282377637078065134906837841360920091866568663641) * I,
  K(-0.4484726215915789629605079818543250591853760812042439687028581504) + K(+0.8475313380862912974970594789883268263152652679751739244678499264) * I,
  K(-0.5957940449212178612885460078782669113691514470771051031534044261) + K(+0.6941235405550939957366363757459724334212139004996085065695961637) * I,
  K(-0.1657932712480679324352797531041065159378847115603247290836885338) + K(-0.03034484988590904808707314229739238966269245798571865636543993924) * I,
  K(+0.09232187768176115743944229184319486641603807890064141630737598904) + K(-0.9480930182023603056173694311234232184737178108893836343790971286) * I,
  K(+0.1253875232342447383796938611477966089682261736730071956338231397) + K(-0.7425846385245774327179650495207589919400582691924010818959182149) * I,
  K(-0.4635323255317475603508813562427079787299017046794849942111956036) + K(-0.03537968377738589823688866876629567820973904065244810234835023351) * I,
  K(-0.7768181024842233833284398099826805433398054952774188494839550183) + K(-0.9016687115546059425318489734628132177826442954169814098208693399) * I,
  K(-0.3438799569193803222211337395353172862382393282818176175935665882) + K(-0.2977870537957322952128400484933701687468364176141887213817439595) * I,
  K(+0.4516992926409223877087158531743767221838601004278000612713815507) + K(+0.7179256024826104756809388502414610518803852773697543777370880556) * I,
  K(+0.06666089616216685017821711060949166309479521338992049320098916741) + K(+0.2578890086557144458209523397057740208025579828901713342865254283) * I,
  K(-0.1745406578537533130602117469492874239100070406535786469124490986) + K(-0.1538504426879694241293139546303624621549667183032804898176081863) * I,
  K(+0.8211675763568450531722849319525263346104854682281883633768216488) + K(-0.2307910453579643547976952452546915717916751104424349676420690795) * I,
  K(+0.4556672055423659308087590752089369004817449581650773270885780705) + K(+0.2546454647595675145082163953022507320748140975955459065537243829) * I,
  K(-0.4995039033279936431425519391866789251685585749027530932505827939) + K(-0.5627386513209879192276006865283243984959107791591334740655090595) * I,
  K(+0.8726918846172992953568985227648794462831408981733530385539429495) + K(+0.3172412529050211791125503220835042951184598863173507010397573601) * I,
  K(-0.2346008186655847883513053142192702270585433371669589991501328480) + K(-0.1586956833080456155387417365683199407274623565735968982753106611) * I,
  K(-0.6799217978893501325058702819070483551330905935340946485672338179) + K(+0.3006699102360441987388613578200592186540499923773618183941223753) * I,
  K(-0.1566275246676648172927505477064560456764567953193360696104252779) + K(+0.07709024530773600332437714516318135498482923670266947953153545362) * I,
  K(+0.2370707305562640599555056826175380046193960207814309203259978418) + K(+0.4134879834212641577317767802950010968383157632812161963613138240) * I,
  K(+0.4190750763439876403782271893398677759708625309859749605273964293) + K(-0.1071245391943672166932573683035960154682817194098510730306118084) * I,
  K(+0.8656690846729821844479009939936558250400483585749301520792094913) + K(-0.4370803797545718192074627478647572327001408897946238915127669255) * I,
};
static const R theta[] =
{
  K(+0.1102202703479323805145168301609305669152039120584516034361295799),
  K(+0.1271285473847885856069543510575030313578684198153460258608787844),
  K(+0.4403435134132386719289768135025999653645447451457012165902032453),
  K(+0.27618565528554023737240665973166308716226576891795955849491721540),
  K(+0.0855181560519997970863110717072652858765138690709592875104975971),
  K(+0.3411871717397399216863014521446857987153814959592840937506670411),
  K(+0.4549256927522331018879408582428408534820816831200589934687863547),
  K(+0.4255777755350343208718220983105212368823939380616998562232777442),
  K(+0.251642649449612118417468259885841267648638172288578036365213866125),
  K(+0.29024084231327859346487450327043407701851850272568254773722799293),
  K(+0.3802332400978416093507334444258482999269323492295636122655514487),
  K(+0.258812459415050025130570004511585641466031160182387941642748595947),
  K(+0.0745481644826720184248005966641893328239195618353379158547687876),
  K(+0.20876218882248214361991064663458945129231635978905218098932017591),
  K(+0.26845316865029389547446135886425370038855639885617327387671531487),
  K(+0.17758380392930182441645863779476196081728620226880896730295616447),
  K(+0.1537663544225876943458518352973437573074073634725192614558804195),
  K(+0.1603838764889820806387513166912117314007089948937857189714875816),
  K(+0.3822894581444735109551965171567823524738656404534712931650942186),
  K(+0.19312208649287059132567463307343088054447415183928068143583596481),
  K(+0.1524709043828011755497502457270449191545200736045230854839374469),
  K(+0.3496343182975638907233474216741049580761422453041716318901223490),
  K(+0.0614135853182193900541946795230410211772958709179620113064857399),
  K(+0.1223939919092707397656894029196163706620894905935791478249732374),
  K(+0.20083420080303917299057851063495000056566495912820755104951176854),
  K(+0.26046880784174780226916203059104491893324777753166767231116686204),
  K(+0.1509968475691602094114703579879747258465863334316306040163244453),
  K(+0.22416712819088110584375417815093983273372492260521971160482754740),
  K(+0.29475059857583979503438536357673705366397356343684767581742970834),
  K(+0.1175139467936422265081530379474795940637614987095841856544070072),
  K(+0.30918395989862257382754626007951974394262510879069816893613588903),
  K(+0.30436558747157441207870240151244761013057831468440171202612038377),
  K(+0.16335843920336889952505262837603920988032836783101319358165367068),
  K(+0.018235306329421037023959187272450466102385081363804643945554125),
  K(+0.23083293853160920151225462459274982998398636006268470422495277069),
  K(+0.21308158827696647604310263462557844820251875464487400785684284700),
  K(+0.19505980041418677053720414073948653815333906153498612030626186261),
  K(+0.26157730741460507515552996845934769431196097612783677683011090739),
  K(+0.3826945585825174852086152895026332219671986308483916139769748530),
  K(+0.26367383273512137932043549841226575304445600231688061725694442569),
  K(+0.19839166480700702875301598575425929969591618351574145920554514194),
  K(+0.3678599469292105099613940315230452001254705096960309390392177420),
  K(+0.26190800589569515323039968370662983170143246426423413026757539360),
  K(+0.27340190820682386002804279256672240122431539662760022276608442077),
  K(+0.3641362601824372048494078768267815443245556452051234127596001840),
  K(+0.1455152251189896751618164671857073098309709180353786798801263620),
  K(+0.20710876549999682702509976374096470257868552460571432735829327407),
  K(+0.21994813681674842651147618282596827750443647883413351868116168083),
  K(+0.0478342886245372635928816837940767619042997252592497132917364056),
  K(+0.1341530848974077477036837339541019269295819831305522515449662494),
  K(+0.1578637510402700100457612624904403505394313754690279612275098031),
  K(+0.0630140106802822307115814597599578443574071722016592690358697735),
  K(+0.28392967767893647074113056487137708331124936879080758947090095439),
  K(+0.3670391539334339898368183945910795466718684106078089452416607083),
  K(+0.29533285432866338925582688613887507558308481349244833981545359940),
  K(+0.32129308503653073467602002849533397427646410421974554600197062065),
  K(+0.21470712014421357101850001558833653112269735648100146236137352209),
  K(+0.22889950797543803464572822729384509114472742079361142543262777573),
  K(+0.21171323234124120919904301862958245012356490227391138010981126139),
  K(+0.23117488282350765024619500323057739270919718180397211064733403783),
  K(+0.23100602193970910154278273307572415128234584383319728770848457946),
  K(+0.30197956768174386323729913916501698963957894813245985316149516592),
  K(+0.1303803264358597823325134730650867537198356481166323657069063299),
  K(+0.1293822186416369290514681824162118209703876019626047590860313980),
  K(+0.0286827917148287898798337172416768171901820277851493989656956277),
  K(+0.22287992955751474029253151589995817221197408588066223661744708057),
  K(+0.0602440191588066196501795457328085974710657622113932015437046735),
  K(+0.31545728014960312140479124662310769286042442256973379724645192843),
  K(+0.3708603959310984245118708976994523252054054739811262912338430496),
  K(+0.3939312316093710916392903069432718118849544195496914924034486946),
  K(+0.0699307270264075567993461920604964759951912891285123657853916869),
  K(+0.0622167200976900258471140551257675614441108555977612491912421638),
  K(+0.242755362004092169155417947391628270700202691736664411939727974169),
  K(+0.33809771519487760598709528249300898770214680055537340364961090949),
  K(+0.0313770756515132689613502862831478434985705953458100110564624908),
  K(+0.1065294438963848384173483883995637805593894805611513933925232023),
  K(+0.1152105866324449071325867820893737261017327942919143044634826962),
  K(+0.3657938150157387372698355168656284452921401223088906151449636847),
  K(+0.19513128668985705996431008372949537340531589864910914597595250814),
  K(+0.2498355970817017394222205688067152857948066730937989462845341558229),
  K(+0.4371751299267552086487121714984244352325215652408675432649111110),
  K(+0.257444434872726390857458014458364466051435417175373789485530692399),
  K(+0.4092659322251565191856624522942797705906746659448781215726695188),
  K(+0.28148232792991756824002318458067853730513454284520388601012638093),
  K(+0.31843611645816966517166724913249854518201853599393691741104084563),
  K(+0.1068474577793121512645421264269512374496022876410495187335924728),
  K(+0.1225736039133152222710302527336614773241930028791542891528833150),
  K(+0.19310328098249940976444930251490101294975454312024178818035810295),
  K(+0.1531498011398567108792849017344060034980572421636914519289367222),
  K(+0.4094231538849099511411437134273112041633672968226017195222238488),
  K(+0.3966504493936002871139242577930524928620955495379064422093742284),
  K(+0.21499249650873475139548253880080912031332486050429282251654854538),
  K(+0.1291699082896100617321522957196403990445404538449021663142093393),
  K(+0.29310619865969786363345229084996972349221590244000667381663888787),
  K(+0.247379900032726370799138874511536868417015668918002893584286344072),
  K(+0.21377646986438311660143320535004996666594582089373709163374420388),
  K(+0.3707623727830831989450017918689311531904613111505713157958312934),
  K(+0.4141026896113956651600914591832946110402660214169274712939113885),
  K(+0.245690836286469708462123338288941219232575068082250233631647161504),
  K(+0.255190522964832333712728706137671731381076771124906296681897119710),
};
static const R phi[] =
{
  K(-0.03092200440349678758089876113625405284234241102790752240170995867),
  K(+0.3361169344205493933115607004985232698349397958212933677318884514),
  K(-0.4203252596509423618663736198756620115799400359436276143569671743),
  K(+0.03309313121039681014022293940848452005886337420844264240563947853),
  K(+0.2008204635158070744539613201560587696308414375731567394324831547),
  K(-0.4567185271123117297142967071238859542007983840325890028299668627),
  K(-0.3359948017047255077758702593707913776715233262244309860565322317),
  K(-0.06712070214833023229904372705484889754342521622669259471237141435),
  K(+0.1067629440561841080056500621607769177947295587053597725572538283),
  K(-0.09634227888600589661866277235867018999986634301535763323341162400),
  K(-0.06090234980126294406090037604894808378422877470857494368997911408),
  K(+0.04278682199879546391487551674957176511976368684449756669014707988),
  K(-0.3843149551344242910106365819762762431995794507363771930199655127),
  K(-0.3887385513878564682038394294849540115576976745598898924425459123),
  K(-0.3312566477453613845845129421168601959212506456522974062399977625),
  K(+0.2792498736810452234285554969491296238964185619217025516095756467),
  K(-0.06996448155652493381885462447994985200392370758219401333690839407),
  K(-0.1159858503851951629087221470680375504985606415056059244151756362),
  K(-0.2924672299677401344450061872306006857968999939797358676956291436),
  K(-0.03863142444450581466792115691769308282556785956344564264577341096),
  K(+0.09092607301094126943579906992394685775098501553150940211338571267),
  K(-0.08025051953402872605976506829713242667652019092254588349366142426),
  K(-0.1441018421227669985074693165610147975288571258351910370413772842),
  K(-0.03974745719356598761347999596226737452065820292505978127333341063),
  K(+0.2992121844391718160955070141161786419228048027990712490449093596),
  K(-0.2289007896256224701173276208276697627166525417269514540440552373),
  K(+0.2623897238058930188004602502635484277359346377336119031710682230),
  K(+0.4257484510398507555869275673586692706643529819039508217093162055),
  K(+0.05005586004107106216150040201796842748022674118149945500996916562),
  K(-0.1432575282014992401304328745816304824490268322888120265221733871),
  K(+0.1028585594535703767497608485541703554884107304298063836375051336),
  K(+0.2287804590257474159975386781883272496658577322676320673619575465),
  K(-0.02617284683054200304171852899803055581679869986919501170908694192),
  K(+0.2862226359352744312826334459917105038605915651235635157547413810),
  K(+0.1371176472908139059439764423839564622648659783551733942372986428),
  K(+0.06324773467803718368079574758381721026538020597803175343988943740),
  K(+0.2740787428977923652494822812159717959255398461027228675450686341),
  K(-0.4152543135059829198442518462096450234268373858227844620510646789),
  K(-0.1996427182413306207439282141857147323881224786718767095017943232),
  K(-0.2805322229932953544322331043487516545898901743479106737341692064),
  K(+0.1942837376851896675215719784865509165748199425906736432804532437),
  K(+0.1200514940710144070759515858486651429687638659353145623487119440),
  K(+0.3582757725636044602247720804730017698945021759898143880332586441),
  K(+0.4329374674596440322426659610408741870088634781767694816457168426),
  K(+0.3775295618884241308975944628403518347328286682128834346472248391),
  K(+0.08937167218766910498075460183128652893989283356980758869046867857),
  K(+0.04724054365419404049543531578099956089625754697334441285476866921),
  K(+0.1870024343380386850240167257227580141434364941218169689524668426),
  K(+0.1865261306409289865609294140305715586230646553956657430113897909),
  K(-0.08549843284688762899703035729776347265090849356466344447029243560),
  K(+0.3488410479548235802567412332341857234042533539318246464509712988),
  K(-0.2039068915423461829867194194736849030704470903802979709700282199),
  K(+0.2947524429808661088875341239089729562628397578402702065708704245),
  K(+0.3656233563145571194524297808970227017419714963208946288457884984),
  K(-0.4295489400707232251438876516915128595053940400834460555331670508),
  K(+0.03918316143534728034903300484209298808472324033585670520075696303),
  K(+0.3354826394578492357295464213001389042103197200995900232310050194),
  K(+0.4213560485094652367076294235243690909701513654139858337653863919),
  K(-0.1881889356051118682790024945828209824088081402745986247305977383),
  K(+0.1027459187170693262912753694079583161713226629780739931114746058),
  K(+0.2809670835927340956971119165775638010150222053093250265251914446),
  K(-0.4984160466474178528765504817820208570029585139494347929209439550),
  K(+0.2523447125078985048361286910307850929959512734561601504209280199),
  K(+0.1260765519639791987192669910383550061162770057133442085522223848),
  K(+0.3431794087533919358203692071100763301850439937769526058576286505),
  K(-0.09181961204807972880470581814566836406980941445595189408428564575),
  K(-0.1924682171705802686152451166519551494771110624704539466204189152),
  K(+0.1873817536717609977969820792046229494148034457901654992224361193),
  K(+0.3031483755546383000646401101138754387124369722308800167823571557),
  K(-0.1455638701407401813702071939995795029035378905060822938578819297),
  K(+0.4803088838546701567561330219185480951462039882765790314841469770),
  K(+0.3231116632874269911631088619199380077304389243203505327033234588),
  K(-0.04024710269150724608972537801281734810485968737734618953890966120),
  K(-0.1729618342802585050044242170510327559965406976464761213677187941),
  K(+0.02784368053039960686921096849299934667930841498894184572297136979),
  K(-0.3436566291204077352703754855743266130301644295031024962682572260),
  K(-0.1876245081685698104204507006039062093241745149889023010330307321),
  K(+0.1692368107702939339168536549955626038730244486513254883662336913),
  K(-0.4684231791591372854999214424960986748590679746064362697981772796),
  K(-0.4248267074359445814441394509403662565032639928964951472345269249),
  K(-0.4113222374831253359536821117088764452615372265792487603121550550),
  K(+0.06870964745056010524662262765808722733712594370131534091838153316),
  K(+0.4478656769674399132178971453861077109479264117996318805804441006),
  K(-0.4052987879647885069330200645899099280223608155981433216786033678),
  K(-0.2809858060284832915975329324292633074809826863215260490104787159),
  K(-0.1101486456067479870309722474665914891407321720948068241624086836),
  K(+0.4732378396087974353937505734697108971310311804100573160962216871),
  K(+0.06175037728592614457558880248098035044722515979284601825712760237),
  K(+0.4924538372736380598379506831793054606469060630055502563048476786),
  K(-0.4161652408524438943874803871506529384954729754984279344948786517),
  K(+0.1977486207488651191220442180320561530318913863193357059077059736),
  K(-0.4519326616839637188373904115343849763674785179702738568551014002),
  K(-0.02548314058080589036975340705963794169671389762993080504722779661),
  K(+0.1872597313300373761104312724512164817684752957138886513543626399),
  K(-0.3982492158593685262061315520060468648440036597420602742672328154),
  K(+0.4588750348319494406292365452843751435847481552147902278501774172),
  K(+0.2282759387099164553919139978076351042420281113500330476062705263),
  K(+0.2754921479859968259231930168750633592435183805820074654572925997),
  K(+0.1734470466913161561184632422712661148498013155967556233221066797),
  K(+0.1577914575818329786445162599616450111854240803307200045611338947),
};
static const C f[] =
{
  K(+0.895796673833059606352522239055186067363332818049971054436794) + K(-6.150198126229928049237797566819916871092090167724864924439612) * I,
  K(-5.360868087863520590190910868826293610983704893202404695098367) + K(+0.970693778234946727078665613907827085731386457167491052601533) * I,
  K(-0.185099720855509428000257327484765057726071927976856655061427) + K(+2.633132905006778032711579155462980150093549525157393848012059) * I,
  K(+7.902794116791786375444116687667746730171533583827426309625171) + K(+3.757136195947480765981777519994999483739100060872600927883312) * I,
  K(+2.60363261244987982490060942830441018715811710634975877730586) + K(+0.83923453987068340483540110347019879189647299748081182574080) * I,
  K(-4.233087887371145427900824155614848337610439645193972108926477) + K(+1.080603870643411538154713460342912919075909548582510526662128) * I,
  K(-0.538558203655836116565814299745649124723147566696096546982334) + K(-4.377043463804750800824873804294968666996811048663082777811401) * I,
  K(-1.141401109916516274373168199175290203598902954287613383596174) + K(+3.014530096812745838467855202602099243409122867356130038672668) * I,
  K(+0.179113868553772291560630148558531003431244022945409390015663) + K(+6.757308392966856302968980112424996680622628984099386528850400) * I,
  K(-2.523370432670892198421173903841892084087667648866089685548835) + K(+4.598670640545996241569392135438458318136348688005716322094472) * I,
  K(+2.279236484730495623819151292562831801646158196156953440129355) + K(+1.411874776444752447931275199400865673543499594412306416737131) * I,
  K(+5.813416239615594162724594979670950492552122006927071054932802) + K(+0.496972490102587504751353430314593382131901171107389502180694) * I,
  K(+0.14759570205619379778745465148026419038469341464411120061859) + K(-6.28528629176607143555294502635625404618955827561604230217091) * I,
  K(+1.387368125508155211257054163441296219693360299253452897986431) + K(-1.574502267541238417222310197335570629095282019171448412005422) * I,
  K(+3.004474895997496633739154107679728969959319659139796030787733) + K(+1.151715161454107724592543483058864427953346322957234113446614) * I,
  K(+0.879418184609775121455800045159022073222374620064964670857455) + K(-3.298222444380474090295904886267633103125916423256191430955937) * I,
  K(-1.808230824210460105231205757292469938036414006696498762719485) + K(-0.180683411756329330254046449179575264975506935942583450206471) * I,
  K(+5.030709779233991109065082087705844891192203038448359865903025) + K(+5.483150957710974375554790803287646553072914444699988983996181) * I,
  K(+2.157886928657449487704378023876457972228052608357652297494298) + K(+5.075952761844698483027647072641076844397150360047645143476782) * I,
  K(+10.340422880851742531646962551631216976028914786124304304668100) + K(-1.894149572010005638626719337497686462515191657241162578806314) * I,
  K(+5.174624136093711145991471791642494525358248957750342282894162) + K(+2.339514163777538022176948421793761139445289165107526867307689) * I,
  K(-3.306637345037728609530784776361314516755462129048419236598644) + K(+3.729538553624396427715565804007097835949855557780760648089802) * I,
  K(+5.29612593998497566123094715309836235410373734323113142523289) + K(+1.49374203905707193322012760392202168841762787878978526247440) * I,
  K(+3.245721646279999270983633580289935314136233547217177839628631) + K(+0.307986133946363610130907872204683593885683094133486253114727) * I,
  K(+2.039127760895505950655722147125894900486963576482770748603556) + K(-2.555382661279289348069258913559768103442719487148412482611856) * I,
  K(-2.789532279857509260778505831789666751480988964433685805872141) + K(+0.784752435620605655919461253479524409823248992696580433804531) * I,
  K(-0.152730888548702068648401872713584784722900862531387693605436) + K(-0.585522002955035312012629898012439881691619344320006800703271) * I,
  K(-4.253299960174820247096357931045330893499224092498373274998721) + K(-3.409203011310227349155459796502387778728772111312808452707873) * I,
  K(+0.295917684711162736266470513282327224757715380096694032885797) + K(+4.720659278108400410238100059565888076726200002640880461819993) * I,
  K(+5.145347575947538139082611958818022207832228255415520293285049) + K(+0.704959110141710421214074224524609600957137183968141445850278) * I,
  K(-2.431709033445799036041889618442176482629142036416506636393704) + K(-1.025977583724905754333934640063845074431920567349459695895109) * I,
  K(+4.622623843541740858214514211756613553932426840290577889796867) + K(-2.461384370755209889439039554987200793473498840603642954833588) * I,
  K(-4.750331227006692254253674693320714941323854196193639099749711) + K(-2.387784328228534640122954719437015239823483399132644231938030) * I,
  K(-4.80494647248855283279348090896027144270012311365000995840030) + K(+8.38243280311861909034873134995386658956299968717485553377152) * I,
  K(-1.840825214697975674815119445133485205411922338974379991028431) + K(+3.252888811443108189834798614538535959313340131831809392073804) * I,
  K(+2.988018201282431451133483090082481982985139855544263782867480) + K(+0.597951394758384897117880152981938122384526096519992283272661) * I,
  K(+0.303430079088880102493025488743916105957081301185777958723715) + K(-1.005521833803776535691552376914154965136637790654154493329741) * I,
  K(-5.842899892374166281340307333149374378909577261191728520341785) + K(-1.769618803121240715620756315177927123386817789094968871600999) * I,
  K(+0.255421596057248933508248656971383030376795517800234119180724) + K(-0.206085773295622353662596902556398796459330238737135295680573) * I,
  K(+2.052769181961227137046975585267678743004892903114044056693979) + K(-7.195718903083524831053353695042941862268518307969715100893388) * I,
  K(-0.651991337047973114942798220278580398455469268208515062100063) + K(+2.758053597917697510875533376673255403419338023756306024161849) * I,
  K(+7.415919553341494711972101638293390253530031891429695077770572) + K(-1.304091926484196632304882686240210956248295952445642313279141) * I,
  K(-0.724401090586730289977210951189009399620851996685969864962924) + K(+0.980606004714394389461679057346616796934707668886736076913852) * I,
  K(+0.395952511404590092563081323832881891645822348451732778727260) + K(+1.819081058897862986354248449556939281184611494568153915251727) * I,
  K(-0.144018923958415140090326073120647538442098199603944258893871) + K(+2.818135438253310801047866325843016982167614750304582458107140) * I,
  K(+5.911773854496117263309452858801057972781170511575578872584015) + K(+3.422181778331020395482080992654345759666708429281308797473030) * I,
  K(+2.414200670331900051171121186869002726642234603751280170927579) + K(+5.634315087093719116583942505542009793832586143216760047801103) * I,
  K(+0.286404004070681115089526353314944256070842696939143906590958) + K(+4.036177995717441186666194878372708974052846520982325941618673) * I,
  K(-3.11821457829697477858457483778514577973731036020485813309602) + K(+5.16030967279629822025408429873754219560427442734298885302455) * I,
  K(-3.879645899160400866308859382556020706257173610046715100762711) + K(-0.830473682421343023953338757079678159321402406951934160003644) * I,
  K(+2.679827065861696127240952894667477942763513903255307232976219) + K(+6.470098459222250454231509663027767559842827706296526979304915) * I,
  K(+3.26633182018955609158618076466827494665617427055197124655422) + K(-4.09020631325346930402015092255626665630169830612147565105116) * I,
  K(+4.383532238701832720344007342352191740448913300368247712984026) + K(-0.232480158795766936248174213675023364046457009139062508741023) * I,
  K(+4.905119442134952287239586692161434455421780490126200895030394) + K(+0.679186710682476949866137385107344501836961308188901242607613) * I,
  K(-3.619133940686218188620604586964949907594366518988435911014369) + K(+5.176781247238190833608986606092008128899631205624527000767056) * I,
  K(+4.362067827760617914024650351428307710206397942762935183606124) + K(-2.094153325242015476763512754232171575112597538962258229126644) * I,
  K(+1.422025469751911035068943662055714283619068167639688494787016) + K(-0.524756791460485184991964069916925098238620258381093280982475) * I,
  K(-2.990724007790257097104722445793757184987710447048937311717160) + K(-3.242613467000074873143560682649417284813097278501295913095246) * I,
  K(+4.356397747667862148512349272653984690437619421093291524749026) + K(-0.331319706397479709673413487757727502734665013584398121745233) * I,
  K(-1.390279124904033180553119958501051577666722468359940282027944) + K(+1.248733110942313421472406923146719046651028992384695616375846) * I,
  K(-2.445394224645236283201398296176224459361226611181316284615751) + K(+2.933952768386040280815303379876007371971383077163136428704343) * I,
  K(+0.840020031132704443479406877805040644457221146395236333561227) + K(+1.814420026815609185594355789306082197913719925142661522442604) * I,
  K(+4.923088308089578563037325953063094654389622448711844776552669) + K(+4.189929625121217570365967263608519326016214380822945398717342) * I,
  K(-4.913097697957250929147205115373299546643073152232832006368944) + K(-0.684416075977564339262423142946212625716279622710808245469095) * I,
  K(+0.41059204398071901745990987073111648411567738374784967405189) + K(+7.56492152758522914445959288610738932030398467390464820785882) * I,
  K(+3.768224907507265469210586239922048789198648482577017052016181) + K(+2.397754212417839531622318511292028865308005162868996136566654) * I,
  K(+3.65863296815232128449723220440640424806770745182780949792397) + K(-3.55562246714430747224617714235283774846635888205155492500723) * I,
  K(+3.028878782150243492181511600859068658552200673742300635525511) + K(-1.282874077113681904739487202179917356822676831501437994873519) * I,
  K(+1.296521826369051598278958528072694013008824079179748849281043) + K(-2.845079867177437514497834098859436537583629319217970973839571) * I,
  K(-4.169190734605879776899200250345808738257689413487844599903648) + K(-2.233659853143078095745396306559841604196907307757792108245761) * I,
  K(+0.17177789248991635657240046515375389089716722963413837743523) + K(+0.48068691952585901828028946857838725086922201251645082129971) * I,
  K(+2.11669747989752203863397434956496136860594248296495691448281) + K(+3.73941967949906484504632786603116651851591938620225521967173) * I,
  K(+3.633212040740266500400203711058288835667680868047134109248566) + K(-3.354743650987717038994995132968396397503486932090922491417229) * I,
  K(+6.832413795377518814724382510613285368749238118701743439697761) + K(+5.871296229199738208963204941072699575375910751184508171774932) * I,
  K(+1.44685490525051620782568107690837231912151242985865907274607) + K(-5.54347043979730633209375084182752605977744125410181447113852) * I,
  K(+4.92654455706193836144399756456228244150822807311010315984994) + K(-2.56097626360979877349385266239578300324616582154721417161304) * I,
  K(-0.606718582208307283174485750862217595053132202181095142693251) + K(-4.376272892129323838711197254526031660940650030637323325756523) * I,
  K(+0.605086414836688611252207524353783570910017982141753614501017) + K(-3.221315184211993143796146798417121347476318044579427381874789) * I,
  K(+0.373916251922220300716651866612337867765542418318913539851465) + K(+3.477271935867257372497132499284260089077226656607646759093096) * I,
  K(-11.442537352758960159062465966002438986916237823644947411426843) + K(+9.924737481047026427709986693399680071512403038338007088464504) * I,
  K(-2.162874829719805443128844986414897643134862232743350778201105) + K(+1.639220527907457638491870817035756173219831793869398160172236) * I,
  K(+2.497612777958562990405394745059776596251792569871509780630738) + K(+3.747788743706163618218828280375948984109602934314047695535119) * I,
  K(-1.065772146286093542112846135379225402506066573919648901417775) + K(-2.511458986264725849408094582409864350009184643190415819896610) * I,
  K(+1.076984075853794637625081162474060623120087083692848658358487) + K(+4.553433055431738604908201351580028610849256181836705673272437) * I,
  K(+0.503634366873601745531615939811520364987562548430662790011236) + K(-3.635863712542620490212173552569777384519528175719236276630315) * I,
  K(-1.263822179135966153665641644999173275123419304172901978681626) + K(-5.35152117924617624516114280607065644897218084252721937730359) * I,
  K(-2.251089669957254620044950812921230876908329658054107453731659) + K(+0.691329618222431971705968218601800952296038060886716648523623) * I,
  K(+2.130243892816613972688526801509006888273926730085446156170745) + K(+2.244737441453728539673751173798017318744626765487809510169417) * I,
  K(-0.354548240994191782895405237765120976537882633312588020108021) + K(+6.016430082759202307423839954544251178281501463015224880945950) * I,
  K(-1.498302680583787275372576168199958372434996639398258037899997) + K(-2.409843316822186260696459153806003325022103678812502450796660) * I,
  K(+3.878114959506747881835234792067228240712176138414774815225164) + K(-1.087656678001344542636562384322827462944505573227953575504754) * I,
  K(+2.699054776753535622879316657503203022443398877516586244140186) + K(+8.493940063592534195835869912388438570387801930941859556007664) * I,
  K(+4.323133805820220479395871268964984824659036180497796471390437) + K(-1.205253316587947112920921643270839259282583841684370067964027) * I,
  K(-5.811136869514813895667820604908180671389054873748571802643494) + K(-0.101525627366856872978691406448632845422942989093443681292129) * I,
  K(-1.557559264767896720013980749670744248462227217736009489427921) + K(+2.525797951625748474089699249665990235866163277290499693865536) * I,
  K(+5.666308520835333729010965549240879739793682859009153748530017) + K(-3.260724139467643974399016852293584010110007359456370132344451) * I,
  K(+2.765973358720142725219252186698626643866599949500807234141686) + K(+2.092495183498174150664106034347059201141446681797307031979263) * I,
  K(+1.037133423211566704340076943094071507052199468416134635543217) + K(+1.379125823939207549374400750158211948917368668149626902988422) * I,
  K(+0.696786772619035086791290100235767216939833011840739546114882) + K(-1.002617447507837363213787469627027133942287259764359265188183) * I,
  K(-0.926123530865365101827346058585436562806460484870225278929546) + K(-0.316197385522818359866658207760541646253073654263053049007864) * I,
};

static void check_nfsft(void)
{
  const int M = sizeof(theta)/sizeof(theta[0]);
  const int N = sqrt((R)(sizeof(f_hat)/sizeof(f_hat[0]))) - 1 ;
  NFSFT(plan) p;
  int j, k, n;
  
  NFSFT(precompute)(N, 1000.0, 0U, 0U);

  NFSFT(init)(&p, N, M);

  /* Nodes. */
  for (j = 0; j < M; j++)
  {
    p.x[2*j] = phi[j];
    p.x[2*j+1] = theta[j];
  }

  NFSFT(precompute_x)(&p);

  /* Fourier coefficients. */
  for (k = 0, j = 0; k <= p.N; k++)
    for (n = -k; n <= k; n++, j++)
      p.f_hat[NFSFT_INDEX(k,n,&p)] = f_hat[j];

  NFSFT(trafo)(&p);

  /* debug */
  for (j = 0; j < M; j++)
    fprintf(stderr, "f[%2d] = " __FE__ " f[%2d] = " __FE__ " err = " __FE__ "\n", j,
      CREAL(f[j]), j, CREAL(p.f[j]), CABS(f[j] - p.f[j]) / CABS(f[j]));

  /* Standard NFFT error measure. */
  {
    R numerator = K(0.0);
    R denominator = K(0.0);
    for (j = 0; j < M; j++)
      numerator = MAX(numerator, CABS(f[j] - p.f[j]));
    for (k = 0, j = 0; k <= p.N; k++)
      for (n = -k; n <= k; n++, j++)
        denominator += (K4PI/(SQRT((R)(2*k + 1)))) * CABS(f_hat[j]);
    printf(__FE__ "\n", numerator/denominator);
  }
}

int main(void)
{
  check_nfsft();
  return EXIT_SUCCESS;
}
