/*

  xmunipack - common IDs


  Copyright © 2009-2013, 2018-9 F.Hroch (hroch@physics.muni.cz)

  This file is part of Munipack.

  Munipack is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Munipack is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Munipack.  If not, see <http://www.gnu.org/licenses/>.

*/


#ifndef _XMUNIPACK_ENUM_H_
#define _XMUNIPACK_ENUM_H_

#include <wx/wx.h>

enum {

  ID_LOWEST = wxID_HIGHEST + 10000,

  // IMPORTANT. The unique identifiers can interfere with
  // numbers generated by wxNewId function (which increase
  // value of a internal variable about one). Setting of the
  // specified diference limits number of generated items
  // by wxNewId on the value. Specifing of opposite tail
  // wxID_LOWEST does not works.

  ID_NULL, ID_FILE, ID_DIR, ID_EXPORT, ID_FILES,

  ID_VIEW,
  ID_NEW_BROWSER, ID_NEW_VIEW, ID_LOG, /*ID_UNLOAD,*/ ID_WARNING, ID_INFO,
  ID_INFO_OUTPUT, ID_MENU_OUTPUT, ID_TOOLZOOM, ID_CONE,
  ID_LABEL_FILENAME, ID_LABEL_OBJECT, ID_LABEL_DATEOBS, ID_LABEL_FILTER,
  ID_LABEL_EXPOSURE, ID_LABEL_KEY, ID_LABEL_NO,
  /*ID_VIEW_ICONS, ID_VIEW_LIST,*/ ID_VIEW_MARK,
  ID_SORT_FILENAME, ID_SORT_OBJECT, ID_SORT_DATEOBS, ID_SORT_FILTER,
  ID_SORT_EXPOSURE, ID_SORT_SIZE, ID_SORT_KEY, ID_SORT_REVERSE,
  //  ID_IMPORT_RAW, ID_IMPORT_ST,ID_EXPORT_PNG,ID_EXPORT_MPEG,ID_EXPORT_ASCII,
  //  ID_DESELECTALL, ID_SELECT_BY_NAME, ID_SELECT_BY_KEY, ID_SELECT_BY_TYPE,
  //  ID_TOOLBAR, ID_DTREE,
  //  ID_RANGE_MEAN, ID_RANGE_DEV, ID_RANGE_TYPE,ID_RANGE_RELATIVE,ID_RANGE_MUL,
  //  ID_RANGE_ZERO,
  //  ID_RANGE_ABSOLUTE, ID_RANGE_AUTO,
  //  ID_ZOOM_10, ID_ZOOM_25, ID_ZOOM_50, ID_ZOOM_200, ID_ZOOM_400,
  //  ID_ZOOM_1000,
  //  ID_OPEN_NEWDISPLAY,
  ID_CLIP_VALUE, ID_CLIP_COO,
  ID_MENU_RBAND, ID_MENU_GBAND, ID_MENU_BBAND, ID_MENU_LBAND,
  ID_MENU_INTENSITY, ID_MENU_INVERSE, ID_MENU_PALAUTO,
  ID_PAGE_SETUP,
  ID_FULLSCREEN, ID_CONTROLS, ID_EVENT_COO,
  ID_MENU_FULLSCREEN,
  ID_RENDER_SHRINK, ID_RENDER_TUNE, ID_SUBRENDER, ID_LOADER, ID_BUG,
  ID_MRENDER, ID_MRENDER_FIN,

  ID_MARK_SCI, ID_MARK_DARK, ID_MARK_FLAT, ID_MARK_BIAS,

  ID_BROWSER, ID_EXTERNAL, ID_ARCHIVE, ID_ARCHIVE_FINISH, ID_LIST,

  ID_FLATDARK,ID_DARKBAT,ID_FLATBAT,ID_COLORING,ID_FIND, ID_APHOT,
  ID_PHOTOMETRY,ID_PROFILE,ID_MATCH,
  ID_ASTROMETRY, ID_CALIBR, ID_GRID, ID_SOURCES,
  ID_KOMBINE,ID_ASTROMET, ID_DEKON,ID_AVERAGE,ID_ARITH, ID_LC, ID_CMD,
  //  ID_IMPORT_RAW, ID_IMPORT_ST, ID_EXPORT_PNG, ID_EXPORT_MPEG, ID_EXPORT_ASCII,
  ID_DESELECTALL, ID_SELECT_BY_NAME, ID_SELECT_BY_KEY, ID_SELECT_BY_TYPE,
  ID_SELECT_BY_ADVANCE, ID_COLLECTOR,
  ID_SCALE_ARCUAS, ID_SCALE_ARCMAS, ID_SCALE_ARCSEC, ID_SCALE_ARCMIN, ID_SCALE_ARCDEG,

  ID_TOOLBAR, ID_BOTTOMBAR, ID_TUNE, ID_DETAIL, ID_EXTLIST, ID_CAPTION,
  ID_MAGNIFIER,
  ID_PALETTE_TYPE, ID_PALETTE_INVERSE, ID_PALETTE_COLOR,
  ID_CYCLE_PAL, ID_TONE_BLACK, ID_TONE_SENSE, ID_TONE_QBLACK, ID_TONE_RSENSE,
  ID_ITT_TYPE, ID_ITT_AMP, ID_ITT_ZERO,
  ID_ZOOM_SCALE, ID_ZOOM_SIZE,
  ID_COLOR_SATUR, ID_COLOR_HUE, ID_CHOICE_COLORSPACE,
  ID_COLOR_MEAN, ID_COLOR_WEIGHT,
  ID_CHECK_NITE, ID_COLOR_NITEVISION,
  ID_COLOR_NITETHRESH, ID_COLOR_NITEWIDTH,

  ID_CHOICE_PAL, ID_CHECK_INVERSE,
  ID_CHOICE_ITT,

  ID_APHOT_SPIRAL, ID_APHOT_EQL,

  ID_MDARK_MROBUST, ID_MDARK_BROBUST, ID_MDARK_RESULT, ID_MDARK_FINISH,
  ID_RESULTS, /*ID_MFLAT_LEVEL,*/ ID_MFLAT_FILENAME, ID_OPTIONS, ID_MDARK_CREATE,
  ID_AFLAT_FINISH, ID_AFLAT_CREATE, ID_DARKBAT_FINISH, ID_DARKBAT_CREATE,

  ID_LOG_ALL, ID_LOG_LOGS, ID_LOG_ERRORS, ID_LOG_WRAP,

  ID_ZOOM,
  //  ID_XMED, ID_XMAD, ID_MAD, ID_MED,
  //  ID_AMP, ID_XAMP,
  //ID_XRED,ID_XGREEN,ID_XBLUE, ID_RBAL,ID_GBAL,ID_BBAL,
  //ID_XZOOM, ID_SZOOM,
  ID_RESET,

  // View->Detail
  ID_ZOOMX, ID_COOTYPE, ID_VALTYPE,

  // colorspaces
  ID_CSPACE_IDENTITY, ID_CSPACE_BVR,

  // astrometry reference type
  ID_ASTRO_REF, ID_ASTRO_CAT, ID_ASTRO_VO, ID_ASTRO_CH_RA, ID_ASTRO_CH_DEC,
  ID_ASTRO_CH_PMRA, ID_ASTRO_CH_PMDEC, ID_ASTRO_CH_MAG, ID_ASTRO_MATCH,
  ID_ASTRO_NEAR,

  ID_HIGHEST /*= wxID_LOWEST - does not works */

};

#endif
