/*
 * mainwindow.c
 * This file is part of mplinuxman
 *
 * Copyright (C) 2002-2006 - Tim O'Brien
 * Copyright (C) 2006 - Boško Andjelković
 *
 * mplinuxman is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * mplinuxman is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mplinuxman; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

/* Main Window code 

   A good example of how not to do things....
   firstly use glade to build the interface, (cuts out ALOT of lines of code)

*/

#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "dirdialog.h"
#include "mplinux.h"
#include "useful.h"
#include "f60lib/f60error.h"
#include "mp3util.h"
#include "logo.xpm"
#include "random.xpm"

GtkTooltips* tooltips;

enum foo{
     MP_LIST_NAME,
     MP_LIST_SIZE,
     MP_LIST_ORDER,
     MP_LIST_N_COLUMNS
};

void  mw_Destroy(GtkWidget* w, gpointer p) {
     gchar c[8];
     gint i;
     gchar* k;

//     menuitem_SavePlaylist(NULL,3,NULL);
     k = cfg_Read("options","mp3 stop command","killall mpg123");
     g_spawn_command_line_async(k,NULL);

     if (! MW_GET("win_maximized")) {
 		 snprintf(c,7,"%d",(gint)MW_GET("win_width"));
		 cfg_Write("geometry","window width",c);
		 snprintf(c,7,"%d",(gint)MW_GET("win_height"));
		 cfg_Write("geometry","window height",c);

		 i = gtk_paned_get_position(GTK_PANED(MW_GET("splitter")));
		 snprintf(c,7,"%d",i);
		 cfg_Write("geometry","splitter position",c);
		 
		 i = gtk_paned_get_position(GTK_PANED(MW_GET("splitter2")));
		 snprintf(c,7,"%d",i);
		 cfg_Write("geometry","splitter2 position",c);

		 i = gtk_tree_view_column_get_width(MW_GET("left_treeview_column"));
		 snprintf(c,7,"%d",i);
		 cfg_Write("geometry","playlist column width",c);

		 i = gtk_tree_view_column_get_width(MW_GET("right_flash_treeview_column"));
		 snprintf(c,7,"%d",i);
		 cfg_Write("geometry","flash column width",c);

		 i = gtk_tree_view_column_get_width(MW_GET("right_smartmedia_treeview_column"));
		 snprintf(c,7,"%d",i);
		 cfg_Write("geometry","smartmedia column width",c);

     }

     

     cfg_Save();
     mpl_CloseDevice();
     gtk_main_quit();

}

gboolean main_window_FrameEvent   (GtkWindow *window,
				   GdkEventConfigure *event,
				   gpointer user_data) {


     if (event->type == GDK_CONFIGURE) {
		 MW_SET("win_width",event->width);
		 MW_SET("win_height",event->height);
     }
     
     return FALSE;
}

gboolean  main_window_WindowStateEvent  (GtkWidget *widget,
					 GdkEventWindowState *event,
					 gpointer user_data) {

     if (event->type == GDK_WINDOW_STATE  ) {
 	  if (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED)
	       MW_SET("win_maximized",1);
	  else
	       MW_SET("win_maximized",0);
     }
     
     
     
     return FALSE;
}

void MplinuxError() {
     GtkWidget* dialog;
     gchar msg[512];
     gchar title[51];
     GtkStatusbar* sb;

     snprintf(msg,10," ");
     snprintf(title,50," ");

     switch (mpl_LastError()) {
     case F60_ERROR_NO_DEVICE:
	  snprintf(title,50,_("Error Connecting Device "));
	  snprintf(msg,511,_("%s\n\nMake sure the device is plugged into the USB port, or try reloading the USB module"),mpl_ErrorString());


	  sb = MW_GET("right_statusbar");
	  gtk_statusbar_pop(sb,0);
	  gtk_statusbar_push(sb,0,_("No device detected"));
	  break;
     case F60_ERROR_CMD:
	  snprintf(title,50,_("Error From Device"));
	  snprintf(msg,511,_("%s\n\nThe device reported an error"),mpl_ErrorString());
	  break;
     case F60_ERROR_OTHER:
	  snprintf(title,50,_("Error"));
	  snprintf(msg,511,_("%s\n\nMake sure the requested directory or temporary directory is accessible"),mpl_ErrorString());
	  break;
     case F60_ERROR_USB:
	  snprintf(title,50,_("USB Error"));
	  snprintf(msg,511,_("%s\n\nMake sure the USB device is working properly"),mpl_ErrorString());
	  break;
     case F60_ERROR_DEVICE_FULL:
	  snprintf(title,50,_("Error Copying File"));
	  snprintf(msg,511,_("%s\n\nMake the device is not full"),mpl_ErrorString());
	  break;
     case USER_CANCELED:
     return;
     break;
     default:
	  snprintf(title,50,_("Error"));
	  snprintf(msg,511,_("An unkown error occurred"));
	  break;
     }

     dialog = gtk_message_dialog_new (MainWindow,
				      GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
				      GTK_MESSAGE_ERROR,
				      GTK_BUTTONS_CLOSE,
				      "%s",msg);
     gtk_window_set_title(GTK_WINDOW(dialog),title);
     g_signal_connect_swapped (GTK_OBJECT (dialog), "response",
			       G_CALLBACK (gtk_widget_destroy),
			       GTK_OBJECT (dialog));
     gtk_dialog_set_has_separator (GTK_DIALOG(dialog),FALSE);
     gtk_widget_show_all(dialog);
}
	
void left_treeview_cell_RenderName (GtkTreeViewColumn *tree_column,
				    GtkCellRenderer   *cell,
				    GtkTreeModel      *model,
				    GtkTreeIter       *iter,
				    gpointer           data) {

     PlayListEntry* p;
     gchar* c;

     gtk_tree_model_get(model,iter,0,&p,-1);
     c = p->ID3name_utf8->str;

     g_object_set (GTK_CELL_RENDERER (cell),"text", c ,NULL);

}

void left_treeview_cell_RenderSize (GtkTreeViewColumn *tree_column,
				    GtkCellRenderer   *cell,
				    GtkTreeModel      *model,
				    GtkTreeIter       *iter,
				    gpointer           data) {


     PlayListEntry* p;
     gchar size_str[20];
     float size;
     
     
     gtk_tree_model_get(model,iter,0,&p,-1);
     size = (float)p->filesize /(float)1024;
     snprintf(size_str,20,"%.1f",size/(float)1024);
     g_object_set (GTK_CELL_RENDERER (cell),"text", size_str,NULL);

}


void treeview_GetLastSelected(GtkTreeModel *model,
		     GtkTreePath *path,
		     GtkTreeIter *iter,
		     gint ret[])
{
    PlayListEntry* p;
  
    
    gtk_tree_model_get(model,iter,0,&p,-1);
    ret[1] = ret[1] + p->filesize;
    ret[0] = ret[0] + 1;

}

void left_treeview_UpdateStatusbar(GtkTreeView* treeview) {
     GtkTreeSelection* selection;
     GtkStatusbar* stat;
     gint nsel_size[2] = {0,0};
    gchar output[51];
    
    selection = gtk_tree_view_get_selection(treeview);
    gtk_tree_selection_selected_foreach (selection,
					 (GtkTreeSelectionForeachFunc)treeview_GetLastSelected ,
					 nsel_size);
    
    snprintf(output,50,_("%d File(s) selected    %d,%03d k"),
	     nsel_size[0],(nsel_size[1]/1024) / 1000,  (nsel_size[1]/1024) % 1000);
    if (nsel_size[0] == 0)
	 output[0] = '\0';

    stat = MW_GET("left_statusbar");
    gtk_statusbar_pop(stat,0);
    gtk_statusbar_push(stat,0,output);

}


void left_treeview_SelectAll  (GtkTreeView *treeview,
			       gpointer user_data) {

     left_treeview_UpdateStatusbar(treeview);
     

}

gboolean left_treeview_ButtonEvent (GtkTreeView *treeview,
		      GdkEventButton *event,
		      gpointer user_data) {
     
     if (event->type != GDK_BUTTON_PRESS)
	  return FALSE;

     if (event->button != 3) 
	  return FALSE;

     gtk_menu_popup(GTK_MENU(user_data),NULL,NULL,NULL,NULL,event->button,event->time);

     return TRUE;
}


void right_list_Select(int a);

//try to refresh flash and smartmedia memory lists on startup
gboolean StartupConnect(gpointer data) {
	right_list_Select((int)SMART);
	right_treeview_Refresh(NULL,(gpointer)1);	
	right_list_Select((int)FLASH);	
	right_treeview_Refresh(NULL,NULL);
	
	return FALSE;
	
}

//timeout call runs only once, if user_data == 1 no error msg 
gboolean right_treeview_Refresh(GtkWidget *widgy,gpointer user_data) {
     GtkWidget* tv;
     GtkTreeModel* model;
     GtkTreeIter iter;
     GList* entries= NULL;
     GList* p;
     gint n, n2;
     gchar size_str[51];
     GtkStatusbar* stat;
     int i;
	 gsize bytes_read;
	 gsize bytes_written;
	 
     tv = MW_GET("right_treeview");
     model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
     gtk_list_store_clear (GTK_LIST_STORE(model));
	     
     p = entries = mpl_RefreshList();
     if (entries == (GList*)-1) {
	  if (user_data != (gpointer)1)
		  MplinuxError();
	  return FALSE;
     }

    stat = MW_GET("right_statusbar");

     n2= (gint) p->data;
     p = g_list_next(p); 
     n  = (gint) p->data;
     p = g_list_next(p);

     snprintf(size_str,60,"%d,%03d k  %s    %d,%03d k  %s    %%%.0f  %s",(n/1024)/1000,(n/1024)%1000
	      ,_("free"),(n2/1024)/1000,(n2/1024)%1000,_("total"),((float)(n2 - n)/(float)n2) * (float)100,_("used"));
     gtk_statusbar_pop(stat,0);
     gtk_statusbar_push(stat,0,size_str);
     
     for(i=0;p != NULL;p = g_list_next(p),i++) {
	  gtk_list_store_append(GTK_LIST_STORE(model),&iter);     
#ifdef NLS
	  gtk_list_store_set(GTK_LIST_STORE(model),&iter,MP_LIST_NAME,
	  							   convert_if_needed(p->data),-1);	
#else
	  gtk_list_store_set(GTK_LIST_STORE(model),&iter,MP_LIST_NAME,p->data,-1);
#endif
	  p = g_list_next(p);
	  n = (gint) p->data;
	  snprintf(size_str,20,"%.1f",(float) n /(float) 1024 /(float)1024);
	  gtk_list_store_set(GTK_LIST_STORE(model),&iter,MP_LIST_SIZE,size_str,-1);
	  gtk_list_store_set(GTK_LIST_STORE(model),&iter,MP_LIST_ORDER,(gchar)i,-1);
     }

     g_list_free(entries);

     return FALSE;
}

 

void right_treeview_selection_Changed (GtkTreeSelection *treeselection,
				       gpointer user_data) {

     right_list_Select((int)user_data);

}

void right_list_Select(int a) {
     GdkColor blue;
     GdkColor white;
     GtkWidget* flash_button;
     GtkWidget* flash_scroller;
     GtkWidget* flash_label;
     GtkWidget* smart_button;
     GtkWidget* smart_scroller;
     GtkWidget* smart_label;
     GtkRcStyle* rc_style;
     GtkWidget* flash_tv;
     GtkWidget* smart_tv;
     GtkStatusbar* stat;

     blue.pixel = 0x0; blue.red = 0x3d00; blue.green = 0x6500; blue.blue = 0x9900;
     white.pixel = 0x0; white.red = 0xffff; white.green = 0xffff; white.blue = 0xffff;

     flash_button = MW_GET("flash_memory_button");
     flash_scroller = MW_GET("flash_memory_scroller");
     flash_label = MW_GET("flash_memory_label");
     smart_button = MW_GET("smart_memory_button");
     smart_scroller = MW_GET("smart_memory_scroller");
     smart_label = MW_GET("smart_memory_label");
     
     stat = MW_GET("right_statusbar");
     
     flash_tv = MW_GET("right_flash_treeview");
     smart_tv = MW_GET("right_smartmedia_treeview");

     g_signal_handlers_disconnect_by_func(
	  gtk_tree_view_get_selection(GTK_TREE_VIEW(flash_tv)),
	  G_CALLBACK(right_treeview_selection_Changed),
	  (gpointer)FLASH);

     g_signal_handlers_disconnect_by_func(
	  gtk_tree_view_get_selection(GTK_TREE_VIEW(smart_tv)),
	  G_CALLBACK(right_treeview_selection_Changed),
	  (gpointer)SMART);

     rc_style = gtk_rc_style_new();
     gtk_widget_modify_style(flash_button,rc_style);
     gtk_widget_modify_style(flash_label,rc_style);
     gtk_widget_modify_style(flash_scroller,rc_style);
     gtk_widget_modify_style(smart_button,rc_style);
     gtk_widget_modify_style(smart_label,rc_style);
     gtk_widget_modify_style(smart_scroller,rc_style);
     g_object_unref(G_OBJECT(rc_style));

     if (a == FLASH) {
	  mpl_SelectMemory(FLASH);
	  gtk_button_set_relief(GTK_BUTTON(flash_button),GTK_RELIEF_NORMAL);
	  gtk_button_set_relief(GTK_BUTTON(smart_button),GTK_RELIEF_NONE);
	  gtk_widget_modify_bg (flash_button, GTK_STATE_NORMAL, &blue);
	  //gtk_widget_modify_fg (flash_label, GTK_STATE_NORMAL, &white);
	  gtk_widget_modify_bg (flash_scroller, GTK_STATE_NORMAL, &blue);
	  gtk_widget_modify_bg (flash_button, GTK_STATE_PRELIGHT, &blue);
	  gtk_widget_modify_fg (flash_label, GTK_STATE_PRELIGHT, &white);
	  gtk_widget_modify_bg (flash_scroller, GTK_STATE_PRELIGHT, &blue);
	  MW_SET("right_treeview",flash_tv);
	  gtk_tree_selection_unselect_all(
	       gtk_tree_view_get_selection(GTK_TREE_VIEW(smart_tv)) );
	  g_signal_connect(gtk_tree_view_get_selection(GTK_TREE_VIEW(smart_tv)),"changed",
			   G_CALLBACK(right_treeview_selection_Changed),
			   (gpointer)SMART);
	  gtk_statusbar_pop(stat,0);
	  gtk_statusbar_push(stat,0,_("Internal memory selected"));

     }

     if (a == SMART) {
	  mpl_SelectMemory(SMART);
	  gtk_button_set_relief(GTK_BUTTON(flash_button),GTK_RELIEF_NONE);
	  gtk_button_set_relief(GTK_BUTTON(smart_button),GTK_RELIEF_NORMAL);
	  gtk_widget_modify_bg (smart_button, GTK_STATE_NORMAL, &blue);
	  //gtk_widget_modify_fg (smart_label, GTK_STATE_NORMAL, &white);
	  gtk_widget_modify_bg (smart_scroller, GTK_STATE_NORMAL, &blue);
	  gtk_widget_modify_bg (smart_button, GTK_STATE_PRELIGHT, &blue);
	  gtk_widget_modify_fg (smart_label, GTK_STATE_PRELIGHT, &white);
	  gtk_widget_modify_bg (smart_scroller, GTK_STATE_PRELIGHT, &blue);
	  MW_SET("right_treeview",smart_tv);
	  gtk_tree_selection_unselect_all(
	       gtk_tree_view_get_selection(GTK_TREE_VIEW(flash_tv)) );
	  g_signal_connect(gtk_tree_view_get_selection(GTK_TREE_VIEW(flash_tv)),"changed",
			   G_CALLBACK(right_treeview_selection_Changed),
			   (gpointer)FLASH);
	  gtk_statusbar_pop(stat,0);
	  gtk_statusbar_push(stat,0,_("SmartMedia card selected"));

     }

}

void right_list_button_Clicked(GtkButton *button,gpointer user_data) {

     right_list_Select((gint)user_data);

}

gboolean popup_AddDirectory(GtkWidget *widget,
		      GdkEventButton *event,
		      gpointer user_data) {
	gchar* c;
	c = cfg_Read("paths","add directory","/");
	if (GTK_WIDGET_TYPE(user_data) == gtk_menu_get_type())
		gtk_menu_popdown(GTK_MENU(user_data));
	
	gchar *dirname;
	GtkWidget *dialog;
	dialog = gtk_file_chooser_dialog_new (_("Add directory..."),MainWindow,GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,NULL);
	gtk_file_chooser_set_filename   (GTK_FILE_CHOOSER (dialog),c);
	gint result = gtk_dialog_run (GTK_DIALOG (dialog));
	if(result == GTK_RESPONSE_ACCEPT)
	{
		gchar *selected_filename;
		selected_filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		dirname = dirsel_convert_if_needed (selected_filename);
		gtk_widget_destroy (dialog);
		GtkWidget* tv;
		GtkTreeModel* model;
		GtkTreeIter iter;
		GList* entries= NULL;
		GList* p;
		gint n;
		
		cfg_Write("paths","add directory",dirname);
		entries = CreateWaitDialog((GThreadFunc)pl_AddDirectory,dirname,pl_AddDirectoryCancel,NULL,_("Reading Directory"));
		//     entries = pl_AddDirectory(dirname);

		if (g_list_length(entries) == 0)
		{
			cfg_Write("paths","add directory","/");
	  		return;
		}

		tv = MW_GET("left_treeview");
		gtk_widget_grab_focus (tv);
		
		model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
		
		n = gtk_tree_model_iter_n_children(model,NULL);
		if (n)
			gtk_tree_model_iter_nth_child(model,&iter,NULL,n -1);
			
		for(p = entries;p;p = g_list_next(p))
		{
			gtk_list_store_append(GTK_LIST_STORE(model),&iter);     
			gtk_list_store_set(GTK_LIST_STORE(model),&iter,0,p->data,-1);
		}
		
     		g_list_free(entries);
		g_free (selected_filename);
	}
	else
	{
		gtk_widget_destroy (dialog);
	}

	return FALSE;
}

gboolean popup_AddFile(GtkWidget *widget,
		      GdkEventButton *event,
		      gpointer user_data) {
     	gchar* c;

    	gtk_menu_popdown(GTK_MENU(user_data));

     	c =  cfg_Read("paths","add file","/");

	GtkWidget *dialog;
	dialog = gtk_file_chooser_dialog_new (_("Add file..."),MainWindow,GTK_FILE_CHOOSER_ACTION_OPEN,GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,NULL);
	GtkFileFilter *filter;				   
	filter = gtk_file_filter_new ();
	gtk_file_filter_set_name (filter, _("Music Files"));
	gtk_file_filter_add_pattern (filter, "*.mp3");
	gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (dialog), filter);
	gtk_file_chooser_set_filename   (GTK_FILE_CHOOSER (dialog),c);
	gtk_window_set_modal(GTK_WINDOW(dialog),TRUE);  
	
	gint result = gtk_dialog_run (GTK_DIALOG (dialog));
	if(result == GTK_RESPONSE_ACCEPT)
	{
		char *selected_filename;
		selected_filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		PlayListEntry* p;
		GtkWidget* tv;
		GtkTreeModel* model;
     		GtkTreeIter iter;
     		gint n;

     		if (!pl_GetMp3Info(selected_filename) )
     		{
     			gtk_widget_destroy (dialog);
     			return;
     		}
     		p = pl_AddFile(selected_filename);

     		if (!p)
		{
    			gtk_widget_destroy (dialog);
	  		return;
	  	}

		cfg_Write("paths","add file",selected_filename);
		tv = MW_GET("left_treeview");
		gtk_widget_grab_focus (tv);
		model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));

		n = gtk_tree_model_iter_n_children(model,NULL);
		if (n)
			gtk_tree_model_iter_nth_child(model,&iter,NULL,n -1);
		gtk_list_store_append(GTK_LIST_STORE(model),&iter);     
		gtk_list_store_set(GTK_LIST_STORE(model),&iter,0,p,-1);

		g_free (selected_filename);
	}

	gtk_widget_destroy (dialog);
	return FALSE;
}

void menuitem_SendNonMp3 (gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {
	GtkWidget *dialog;
	dialog = gtk_file_chooser_dialog_new (_("Send non-Mp3 file..."),MainWindow,GTK_FILE_CHOOSER_ACTION_OPEN,GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,NULL);
	gtk_window_set_modal(GTK_WINDOW(dialog),TRUE);  
	
	gint result = gtk_dialog_run (GTK_DIALOG (dialog));
	if(result == GTK_RESPONSE_ACCEPT)
	{
		gchar *selected_filename;
		selected_filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		gtk_widget_destroy (dialog);
		gint ret;
		ret = (gint) CreateWaitDialog((GThreadFunc)mpl_SendFileNonMp3,selected_filename,NULL,mpl_GetReadWriteProgress,_("sending file"));
    		if (ret == MPL_ERROR)
    		{
			MplinuxError();
			return;
		}
    		right_treeview_Refresh(NULL,NULL);
		g_free (selected_filename);
	}
	else
		gtk_widget_destroy (dialog);
}



void left_treeview_NameSelectedFiles(GtkTreeModel *model,
		     GtkTreePath *path,
		     GtkTreeIter *iter,
		     GList** list)
{
    PlayListEntry* p;
    GList* l;

    l = *list;

    gtk_tree_model_get(model,iter,0,&p,-1);
    l = g_list_append(l,p->name->str);
    *list = l;
    
}


gboolean popup_Context(GtkWidget *widget,
		      gpointer user_data) {
     GtkWidget* tv;
     GtkTreeModel* model;
     GtkTreeSelection* selection;
     gint which;
     gchar* c;
     GList* files = NULL;
     GList* ptr;
     GString* cmd = g_string_new("");

     which = (gint) user_data;
     switch (which) {
     case 1:
	  tv = MW_GET("left_treeview");
	  model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
	  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
	  gtk_tree_selection_selected_foreach (selection,
					       (GtkTreeSelectionForeachFunc)left_treeview_NameSelectedFiles ,
					       &files);
	  if (files == NULL) 
	       break;

	  c = cfg_Read("options","mp3 stop command","killall mpg123");
	  g_spawn_command_line_async(c,NULL);
	  
	  c = cfg_Read("options","mp3 play command","mpg123 %f");

	 if (strstr(c,"%f") != NULL) {     
	      cmd = g_string_append_len(cmd,c,strstr(c,"%f") - c);
	      for(ptr=files;ptr;ptr = g_list_next(ptr)) {
		   cmd = g_string_append(cmd,"\"");
		   cmd = g_string_append(cmd,(gchar*)ptr->data);
		   cmd = g_string_append(cmd,"\" ");
		GString *fn = g_string_new("");
		GtkRecentManager *manager;
		GtkRecentData *recent_data;
		manager = gtk_recent_manager_new ();
		recent_data = g_new0 (GtkRecentData, 1);
		recent_data->mime_type = "audio/mpeg";
		recent_data->app_name = "mplinuxman";
		recent_data->app_exec = g_strjoin (" ", g_strsplit_set (c, " ", -1)[0], "%u", NULL);
		//recent_data->display_name = g_path_get_basename((gchar*)ptr->data);
		fn = g_string_append (fn,"file://");
		fn = g_string_append (fn,g_strescape ((gchar*)ptr->data,NULL));
		if (!gtk_recent_manager_add_full (manager,fn->str, recent_data))
		{
			/* warn about the error */
		}
		g_free (recent_data->app_exec);
		g_free (recent_data);
		g_object_unref (manager);
	      }
	      cmd = g_string_append(cmd,strstr(c,"%f") + 2);
	 }
	 else 
	      cmd = g_string_append(cmd,c);

	 g_spawn_command_line_async(cmd->str,NULL);
	 break;
     case 2:
	  c = cfg_Read("options","mp3 stop command","killall mpg123");
	  g_spawn_command_line_async(c,NULL);

	  break;
	  
     }

     g_string_free(cmd,TRUE);

     return TRUE;
}

gint one_arg_func(gchar* name) {

     return mpl_SendFile(name,MW_GET("i_need_an_arg"));
}

void left_treeview_SendSelectedFiles(GtkTreeModel *model,
		     GtkTreePath *path,
		     GtkTreeIter *iter,
		     gint* i)
{
    PlayListEntry* p;
    gint ret;
    gchar msg[101];

    if (*i == -1)
	 return;

    gtk_tree_model_get(model,iter,0,&p,-1);

    snprintf(msg,100,_("sending %s"),p->ID3name_utf8->str);
    MW_SET("i_need_an_arg",p->ID3name->str);
    ret = (gint) CreateWaitDialog((GThreadFunc)one_arg_func,p->name->str,mpl_cancel_operation,
															mpl_GetReadWriteProgress,msg);
    if (ret == MPL_ERROR) {
	 MplinuxError();
	 *i = -1;
    }

    right_treeview_Refresh(NULL,NULL);

}


void toolbar_SendFiles(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {

     GtkWidget* tv;
     GtkTreeModel* model;
     GtkTreeSelection* selection;
     gint i;

     if (mpl_CheckForDevice() == FALSE) {
	  MplinuxError();
	  return;
     }
     tv = MW_GET("left_treeview");
     model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
     selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
     i = 0;
     gtk_tree_selection_selected_foreach (selection,
				      (GtkTreeSelectionForeachFunc)left_treeview_SendSelectedFiles ,
					  &i);

}



gboolean toolbar_AddFiles(GtkWidget *widget,
		      GdkEventButton *event,
		      gpointer user_data) {

     if (event->type != GDK_BUTTON_PRESS)
	  return FALSE;
     
     //gtk_window_get_position(MainWindow,&x2,&y2);
     //gtk_widget_get_pointer(GTK_WIDGET(MainWindow),&x,&y);
     //x = x -35;
     //y = y +35;
     //gtk_item_factory_popup(GTK_ITEM_FACTORY(user_data),x +x2,
     //		    y +y2,event->button,event->time -1);

     gtk_menu_popup(GTK_MENU(user_data),NULL,NULL,NULL,NULL,event->button,event->time);
//     gtk_button_released(GTK_BUTTON(widget));
     return TRUE;
}



void left_treeview_RemoveSelection(GtkTreeModel *model,
		     GtkTreePath *path,
		     GtkTreeIter *iter,
		     GList** data)
{
     GtkTreeIter* iter_copy;

     iter_copy = gtk_tree_iter_copy(iter);
     *data = g_list_append(*data,iter_copy);

}

void toolbar_RemoveFiles(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {
     GtkWidget* tv;
     GtkTreeModel* model;
     GtkTreeSelection* selection;
     GList* remove_iters =NULL;
     GtkTreeIter iter2;
     PlayListEntry* p;

     tv = MW_GET("left_treeview");

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
    gtk_tree_selection_selected_foreach (selection,
				      (GtkTreeSelectionForeachFunc)left_treeview_RemoveSelection ,
				      &remove_iters);

    remove_iters = g_list_first(remove_iters);
    while (remove_iters) {
	 GtkTreeIter *iter = remove_iters->data;

	 gtk_tree_model_get(model,iter,0,&p,-1);
	 if (!g_list_next(remove_iters)) {
	      iter2 = *iter;
	      if (gtk_tree_model_iter_next (model,&iter2)) {
		   gtk_tree_selection_select_iter(selection,&iter2);
		   gtk_tree_view_set_cursor (GTK_TREE_VIEW(tv),
					     gtk_tree_model_get_path(model,&iter2),
					     NULL,FALSE);
	      }
	 }
	 gtk_list_store_remove (GTK_LIST_STORE(model),iter);
	 gtk_tree_iter_free(iter);
	 pl_Remove(p);
	 remove_iters = g_list_next(remove_iters);
    }
 }

 


void toolbar_FileProperties(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {

     create_file_info_window();

}

void toolbar_RandomList(gpointer callback_data,
		     guint  callback_action,
			GtkWidget *widget) {
     
     GtkWidget* tv;
     GtkTreeModel* model;
     GList* dir,*newlist,*p;
     GtkTreeIter iter;
     guint freemem;
     
     tv = MW_GET("left_treeview");
     model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
     
     dir = mpl_RefreshList();
     if (dir == (GList*)-1) {
	  MplinuxError();
	  return;
     }
     if (g_list_length(dir) == 0)
	  return;
     
     dir = g_list_next(dir);
     freemem = (guint) dir->data;
     g_list_free(dir);
     
     gtk_list_store_clear(GTK_LIST_STORE(model));

     newlist = pl_RandomizeList(freemem);

      for(p = newlist;p;p = g_list_next(p)) {
	   gtk_list_store_append(GTK_LIST_STORE(model),&iter);     
	   gtk_list_store_set(GTK_LIST_STORE(model),&iter,0,p->data,-1);
      }  
      gtk_widget_grab_focus (tv);
      g_signal_emit_by_name(tv,"select-all",0,NULL);
}

gint one_arg_func2(gint i) {

     return mpl_GetFile(i,MW_GET("i_need_an_arg2"));
}


void right_treeview_MpGetSelection (GtkTreeModel *model,
		     GtkTreePath *path,
		     GtkTreeIter *iter,
		     gchar* dirname)
{
     int ret;
     if (dirname[0] == '\0')
	  return;

     MW_SET("i_need_an_arg2",dirname);
     ret = (gint) CreateWaitDialog((GThreadFunc)one_arg_func2,
			    (gpointer)atoi(gtk_tree_path_to_string (path)),mpl_cancel_operation,
				mpl_GetReadWriteProgress,"Getting file");
     if ( ret == MPL_ERROR) {
	  dirname[0] = '\0';
	  MplinuxError();
	  return;
     }
}

void toolbar_GetFiles(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {
	gchar*c;
	c = cfg_Read("paths","save directory","/");

	GtkWidget *dialog;
	dialog = gtk_file_chooser_dialog_new (_("Select save directory..."),MainWindow,GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,NULL);
	gtk_window_set_transient_for(GTK_WINDOW(dialog),MainWindow);
	gtk_file_chooser_set_filename   (GTK_FILE_CHOOSER (dialog),c);
	gint result = gtk_dialog_run (GTK_DIALOG (dialog));
	if(result == GTK_RESPONSE_ACCEPT)
	{
		gchar *selected_filename;
		gchar *dirname;
		selected_filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		dirname = dirsel_convert_if_needed (selected_filename);
		
		GtkWidget* tv;
		GtkTreeModel* model;
		GtkTreeSelection* selection;
		cfg_Write("paths","save directory",dirname);
		tv = MW_GET("right_treeview");
		model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
		selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
		gtk_tree_selection_selected_foreach (selection,(GtkTreeSelectionForeachFunc)right_treeview_MpGetSelection ,dirname);
		gtk_widget_destroy (dialog);
		g_free (selected_filename);
	}
	else
	{
		gtk_widget_destroy (dialog);
	}          
}

void toolbar_Refresh(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {

     gtk_timeout_add (1000,(GtkFunction)right_treeview_Refresh,NULL);


}

void toolbar_Reorder(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {

     GtkTreeView *tv;
     GtkTreeModel* model;
     GtkTreeIter iter;
     guchar order[257];
     guchar i;

     tv = MW_GET("right_treeview");

     model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));

     if (gtk_tree_model_get_iter_first(model,&iter) == FALSE)
	  return;
     i = 0;
     
     do {
	  gtk_tree_model_get(model,&iter,MP_LIST_ORDER,&order[i+1],-1);
	  i++;
     } while(gtk_tree_model_iter_next (model,&iter));
	  
     order[0] = i;
     if (mpl_ReorderFiles(order,i) == MPL_ERROR)
	  MplinuxError();

     gtk_timeout_add (1000,(GtkFunction)right_treeview_Refresh,NULL);
}

void right_treeview_MpDeleteSelection (GtkTreeModel *model,
		     GtkTreePath *path,
		     GtkTreeIter *iter,
		     gint* i)
{

     if (*i == -1)
	  return

     g_print("%d\n",atoi(gtk_tree_path_to_string (path)) - *i);
     if (mpl_DeleteFile(atoi(gtk_tree_path_to_string (path)) - *i) == MPL_ERROR) {
	  *i = -1;
	  MplinuxError();
	  return;
     }
     *i = *i + 1;
}

void toolbar_MpDelete(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {
     GtkWidget* tv;
     GtkTreeModel* model;
     GtkTreeSelection* selection;
     gint i;

     tv = MW_GET("right_treeview");

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
    i = 0;
    gtk_tree_selection_selected_foreach (selection,
			      (GtkTreeSelectionForeachFunc)right_treeview_MpDeleteSelection ,
				      &i);

    right_treeview_Refresh(NULL,NULL);

}


gint left_treeview_Sort  (GtkTreeModel *model,
			      GtkTreeIter *a,
			      GtkTreeIter *b,
			      gpointer user_data) {

     PlayListEntry* p1, *p2;
     
     gtk_tree_model_get(model,a,0,&p1,-1);
     gtk_tree_model_get(model,b,0,&p2,-1);
     if (user_data == (gpointer) 10) {
	  gchar* c1;
	  gchar* c2;

	  c1 = p1->ID3name->str;     
	  c2 = p2->ID3name->str;     
	  
	  return strcasecmp(c1,c2);
     }
     if (user_data == (gpointer) 20) {
	  gint i1;
	  gint i2;

	  i1 = p1->filesize;     
	  i2 = p2->filesize;     
	  
	  return i1 - i2;
     }
     return 0;
}

// gtk_signal_emit_by_name seems to give a gtk error for some reason
void menuitem_SelectAll(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {

     GtkWidget* tv;

     tv = MW_GET("right_treeview");
     if (GTK_WIDGET_HAS_FOCUS(tv)) {
	  g_signal_emit_by_name(tv,"select-all",0,NULL);
     }
     else {
	  tv = MW_GET("left_treeview");
	  gtk_widget_grab_focus (tv);
	  g_signal_emit_by_name(tv,"select-all",0,NULL);
     }
	  
}

void menuitem_LoadPlaylist(gpointer callback_data,guint  callback_action,GtkWidget *widget)
{
	GtkWidget* tv;
	GtkTreeModel* model;
	GtkTreeSelection* selection;
	GtkTreeIter iter;
	GList* entries = NULL, *p =NULL;
	gchar* c;
	GtkWidget *dialog;
	GtkFileFilter *filter;		
			   
	tv = MW_GET("left_treeview");
	model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
	if ((gint) callback_action != 3)
	{
		dialog = gtk_file_chooser_dialog_new (_("Select playlist..."),MainWindow,GTK_FILE_CHOOSER_ACTION_OPEN,GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,NULL);
		filter = gtk_file_filter_new ();
		gtk_file_filter_set_name (filter, _("Playlists"));
		gtk_file_filter_add_pattern (filter, "*.m3u");
		gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (dialog), filter);
		c = cfg_Read("paths","playlist","/");
		gtk_file_chooser_set_filename   (GTK_FILE_CHOOSER (dialog),c);
		gtk_window_set_modal(GTK_WINDOW(dialog),TRUE);  
		gint result = gtk_dialog_run (GTK_DIALOG (dialog));
		if (result == GTK_RESPONSE_CANCEL)
		{
			gtk_widget_destroy (dialog);
			return;
		}
		c = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
	}
	else
		c = cfg_Read("paths","default playlist","");
		
	entries = CreateWaitDialog((GThreadFunc)pl_LoadList,c,NULL,pl_LoadListProgress, _("Loading Playlist"));
	if (g_list_length(entries) != 0)
	{
		if ((gint) callback_action != 3) cfg_Write("paths","playlist",c);	  
		if ((gint) callback_action == 1 )
		{
			gtk_tree_selection_select_all(selection);
			toolbar_RemoveFiles(NULL,0,NULL);
		}
	}
		if ((gint) callback_action != 3) gtk_widget_destroy (dialog);
		gtk_widget_grab_focus (tv);

	for(p = entries;p;p = g_list_next(p))
	{
		gtk_list_store_append(GTK_LIST_STORE(model),&iter);     
		gtk_list_store_set(GTK_LIST_STORE(model),&iter,0,p->data,-1);
	}
	tv = MW_GET("left_statusbar");
	gtk_statusbar_pop(GTK_STATUSBAR(tv),0);
	if (g_list_length(entries) !=0)
		gtk_statusbar_push(GTK_STATUSBAR(tv),0,_("Loaded Playlist"));
	else
	{
		if ((gint) callback_action != 3)
			gtk_statusbar_push(GTK_STATUSBAR(tv),0,_("Error Loading Playlist"));
	}
	g_list_free(entries);
}

void menuitem_SavePlaylist(gpointer callback_data,guint  callback_action,GtkWidget *widget)
{

	GtkWidget* tv;
	GtkTreeModel* model;
	GtkTreeIter iter;
	GList* entries = NULL, *p =NULL;
	gchar* c;
	GtkWidget *dialog;
	GtkFileFilter *filter;	
	
	tv = MW_GET("left_treeview");
	model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
	if ((gint) callback_action != 3)
	{
		dialog = gtk_file_chooser_dialog_new (_("Save playlist..."),MainWindow,GTK_FILE_CHOOSER_ACTION_SAVE,GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,NULL);
		filter = gtk_file_filter_new ();
		gtk_file_filter_set_name (filter, _("Playlists"));
		gtk_file_filter_add_pattern (filter, "*.m3u");
		gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (dialog), filter);
		c = cfg_Read("paths","playlist","/");
		gtk_file_chooser_set_filename   (GTK_FILE_CHOOSER (dialog),c);
		gtk_window_set_modal(GTK_WINDOW(dialog),TRUE);  
		gint result = gtk_dialog_run (GTK_DIALOG (dialog));
		
	  
	if (result == GTK_RESPONSE_CANCEL)
	{
		gtk_widget_destroy (dialog);
		return;
	}
		c = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
     }
     else
	  c = cfg_Read("paths","default playlist","");

     if (gtk_tree_model_get_iter_first(model,&iter) == FALSE) {
	   if ((gint) callback_action != 3) 
		gtk_widget_destroy (dialog);
	   else
		unlink(c);
	  return;
     }

     do {
	  gtk_tree_model_get(model,&iter,0,&p,-1);
	  entries = g_list_append(entries,p);
     } while(gtk_tree_model_iter_next (model,&iter));

     tv = MW_GET("left_statusbar");
     gtk_statusbar_pop(GTK_STATUSBAR(tv),0);
     if (pl_SaveList(entries,c)) {
	  if ((gint) callback_action != 3) cfg_Write("paths","playlist",c); 
	  gtk_statusbar_push(GTK_STATUSBAR(tv),0,_("Saved Playlist"));
	
     } else {
	  gtk_statusbar_push(GTK_STATUSBAR(tv),0,_("Error Saving Playlist"));
//	  g_print("saved\n");

     }
	 if ((gint) callback_action != 3)	gtk_widget_destroy (dialog);
     g_list_free(entries);

}

void menuitem_Options(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {


     create_options_window();
 

}

void menuitem_About(gpointer callback_data,
		     guint  callback_action,
		     GtkWidget *widget) {


     create_about_window();
 

}

gint format_thread(gpointer a) {
	return mpl_FormatMedia(0x4e);	
}
gint format_thread1(gpointer a) {
	return mpl_FormatMedia(0x44);	
}

void menuitem_FormatMem(gpointer callback_data,guint  callback_action,GtkWidget *widget) {
	gint ret;
	GtkWidget* dialog;
	
	if (callback_action == FLASH)
		{
		mpl_SelectMemory(FLASH);
		dialog = gtk_message_dialog_new (NULL,0,GTK_MESSAGE_WARNING,GTK_BUTTONS_YES_NO,
														_("This will delete all data in Flash Memory\nWould you like to continue?"));
	ret = gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
	if (ret == -9) return;
	ret = (gint)CreateWaitDialog( (GThreadFunc)format_thread,NULL,NULL,NULL,_("Formatting Internal Memory"));
		}
	else if (callback_action == SMART) 
		{
		dialog = gtk_message_dialog_new (NULL,0,GTK_MESSAGE_WARNING,GTK_BUTTONS_YES_NO, _("This will delete all data in SmartMedia\nWould you like to continue?"));
		mpl_SelectMemory(SMART);
		ret = gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		if (ret == -9) return;
		ret = (gint)CreateWaitDialog( (GThreadFunc)format_thread,NULL,NULL,NULL,_("Formatting SmartMedia"));
		}
	else if (callback_action == SMARTCAM) 
		{
		dialog = gtk_message_dialog_new (NULL,0,GTK_MESSAGE_WARNING,GTK_BUTTONS_YES_NO, _("This will format SmartMedia for camera\nWould you like to continue?"));
		mpl_SelectMemory(SMART);
		ret = gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		if (ret == -9) return;
		ret = (gint)CreateWaitDialog( (GThreadFunc)format_thread1,NULL,NULL,NULL,_("Formatting SmartMedia for camera"));
		}
	//ret = gtk_dialog_run (GTK_DIALOG (dialog));
	//gtk_widget_destroy (dialog);
	//if (ret == -9) return;
	//mpl_SelectMemory(callback_action);
	//ret = (gint)CreateWaitDialog( (GThreadFunc)format_thread,NULL,NULL,NULL,_("Formatting Internal Memory"));
	if (ret == MPL_ERROR) {
		MplinuxError();
		return;
	}
	
	right_treeview_Refresh(NULL,NULL);
	
}


static GtkItemFactoryEntry menu_items[] = {
	{ N_("/_File"),            NULL,         0,                     0, "<Branch>" },
     { N_("/File/_Add"),          NULL ,NULL,       0, "<Branch>"},
     { N_("/File/Add/Directory..."),          NULL ,G_CALLBACK(popup_AddDirectory),       0, "<Item>"},
     { N_("/File/Add/File..."),          NULL ,G_CALLBACK(popup_AddFile),       0, "<Item>"},
	 { N_("/File/sep1"),        NULL,NULL,       0, "<Separator>"},
     { N_("/File/_Send..."),        "Return",toolbar_SendFiles,       0, "<StockItem>", GTK_STOCK_GO_FORWARD },
   	 { N_("/File/_Remove"),   "Delete",toolbar_RemoveFiles,       0, "<StockItem>", GTK_STOCK_REMOVE },     
     { N_("/File/_Properties"),NULL,toolbar_FileProperties, 0, "<StockItem>", GTK_STOCK_PROPERTIES },
     { N_("/File/sep1"),        NULL,NULL,       0, "<Separator>"},
	 { N_("/File/Send non mp3 file..."), NULL,menuitem_SendNonMp3,       0, "<StockItem>", GTK_STOCK_FILE },
	 { N_("/File/sep1"),        NULL,NULL,       0, "<Separator>"},
     { N_("/File/_Quit"),       NULL ,mw_Destroy,       0, "<StockItem>", GTK_STOCK_QUIT },
     {N_("/_Mpman"),NULL,0,0,"<Branch>"},
     {N_("/Mpman/_Refresh"), "<control>r",toolbar_Refresh,0,"<StockItem>",GTK_STOCK_REFRESH},
     { N_("/Mpman/_Get..."), "<shift>Return",toolbar_GetFiles,       0, "<StockItem>", GTK_STOCK_GO_BACK },
     { N_("/Mpman/_Delete"), "<shift>Delete",toolbar_MpDelete,       0, "<StockItem>", GTK_STOCK_DELETE },
	 { N_("/Mpman/sep1"), NULL,NULL,       0, "<Separator>"},
	 { N_("/Mpman/Format Internal Memory"), NULL,menuitem_FormatMem, FLASH, "<Item>" },
	 { N_("/Mpman/Format SmartMedia card"), NULL,menuitem_FormatMem, SMART, "<Item>" },
	 { N_("/Mpman/Format SmartMedia for camera"), NULL,menuitem_FormatMem, SMARTCAM, "<Item>" },
     { N_("/_Edit"),            NULL,         0,                     0, "<Branch>" },
     {N_("/Edit/Select _All    Ctrl+A"), NULL,menuitem_SelectAll,0,"<Item>"},
     { N_("/Edit/sep1"),        NULL,NULL,       0, "<Separator>"},
     {N_("/Edit/_Options"), NULL,menuitem_Options,0,"<StockItem>",GTK_STOCK_PREFERENCES},
     { N_("/_Playlist"),            NULL,         0,                     0, "<Branch>" },
     { N_("/Playlist/_Load..."),        "<control>L",menuitem_LoadPlaylist,       1, "<StockItem>", GTK_STOCK_OPEN },
     { N_("/Playlist/_Add..."), NULL,menuitem_LoadPlaylist,       0, "<StockItem>", GTK_STOCK_ADD },
     { N_("/Playlist/sep1"),        NULL,NULL,       0, "<Separator>"},
     { N_("/Playlist/Sa_ve as..."),        "<control>S",menuitem_SavePlaylist,       0, "<StockItem>", GTK_STOCK_SAVE_AS },
     { N_("/Playlist/Save as Default"),   NULL,menuitem_SavePlaylist,       3, "<StockItem>", GTK_STOCK_SAVE_AS },
     { N_("/Help"),            NULL, 0,                     0, "<Branch>" },
     { N_("/Help/About"), NULL,menuitem_About,       0, "<StockItem>",GTK_STOCK_ABOUT },

};


/*
static GtkItemFactoryEntry popup_items[] = {
     {"/Add Directory", 0,popup_AddDirectory,0,"<Item>"},
     {"/Add File", 0,popup_AddFile,0,"<Item>"},
};
*/

GtkWidget* StockIcon(const gchar* id) {
    GdkPixbuf* icon;
    GtkWidget* image;

    icon = gtk_widget_render_icon(GTK_WIDGET(MainWindow),id,
				   GTK_ICON_SIZE_LARGE_TOOLBAR,
				   "yeah");
     image = gtk_image_new_from_pixbuf(icon);
     g_object_unref(icon);     
     return image;
}

void create_toolbar() {
     GtkWidget* toolbar;
     GtkWidget* w;
     GtkWidget* w2;
     GtkWidget* w3;
     GdkPixbuf* icon;
     GtkWidget* image;
     
     toolbar = MW_GET("left_toolbar");
												  
     gtk_toolbar_insert_item (GTK_TOOLBAR (toolbar),
			       _("Send"),
			       _("Send selected files to Mpman F60"),
			       NULL,
			      StockIcon(GTK_STOCK_GO_FORWARD),
			       G_CALLBACK (toolbar_SendFiles),
			       MainWindow, /* user data for callback */
			       -1);  /* -1 means "append" */
	 
     w2 = gtk_menu_new();
     w3 = gtk_menu_item_new_with_label(_("Add Directory"));
     g_signal_connect(w3,"button-release-event",G_CALLBACK(popup_AddDirectory),w2);
     gtk_menu_append(GTK_MENU(w2),w3);
     gtk_widget_show(w3);
     w3 = gtk_menu_item_new_with_label(_("Add File"));
     g_signal_connect(w3,"button-release-event",G_CALLBACK(popup_AddFile),w2);
     gtk_menu_append(GTK_MENU(w2),w3);
     gtk_widget_show(w3);

     
     w = gtk_toolbar_insert_item (GTK_TOOLBAR (toolbar),
			       _("Add"),
			       _("Add files to list"),
			       NULL,
			       StockIcon(GTK_STOCK_ADD),
				 NULL,
			       NULL, /* user data for callback */
			       -1);  /* -1 means "append" */

     g_signal_connect(w,"button-press-event",G_CALLBACK(toolbar_AddFiles),w2);

     gtk_toolbar_insert_item (GTK_TOOLBAR (toolbar),
			       _("Remove"),
			       _("Remove selected files from list"),
			       NULL,
				 StockIcon(GTK_STOCK_REMOVE),
			       G_CALLBACK (toolbar_RemoveFiles),
			       MainWindow, /* user data for callback */
			       -1);  /* -1 means "append" */

  gtk_toolbar_insert_item (GTK_TOOLBAR (toolbar),
			       _("Properties"),
			        _("Show file properties"),
			       NULL,
				 StockIcon(GTK_STOCK_PROPERTIES),
			       G_CALLBACK (toolbar_FileProperties),
			       MainWindow, 
			       -1);  
      
     icon = gdk_pixbuf_new_from_xpm_data((const char**)&random_xpm);
     image = gtk_image_new_from_pixbuf(icon);
     g_object_unref(icon);
     gtk_toolbar_insert_item (GTK_TOOLBAR (toolbar),
			       _("Random"),
			       _("Create random list to fill available memory"),
			      NULL,
			      image,
			      G_CALLBACK (toolbar_RandomList),
			      MainWindow, /* user data for callback */
			      -1);  /* -1 means "append" */
     

     toolbar = MW_GET("right_toolbar");


     gtk_toolbar_insert_item (GTK_TOOLBAR (toolbar),
			        _("Send"),
			        _("Send selected files to PC"),
			       NULL,
			       StockIcon(GTK_STOCK_GO_BACK),
			       G_CALLBACK (toolbar_GetFiles),
			       MainWindow, /* user data for callback */
			       -1);  /* -1 means "append" */
     
     gtk_toolbar_insert_item (GTK_TOOLBAR (toolbar),
			       _("Refresh List"),
			       _("Connect/Refresh index"),
			       NULL,
			      StockIcon(GTK_STOCK_REFRESH ),
			       G_CALLBACK (toolbar_Refresh),
			       MainWindow, /* user data for callback */
			       -1);  /* -1 means "append" */

     gtk_toolbar_insert_item (GTK_TOOLBAR (toolbar),
			      _("Reorder") ,			      
			       _("Update MP3 player with reordered list"),
			       NULL,
			      StockIcon(GTK_STOCK_CONVERT),
			       G_CALLBACK (toolbar_Reorder),
			       MainWindow, /* user data for callback */
			       -1);  /* -1 means "append" */

     gtk_toolbar_insert_item (GTK_TOOLBAR (toolbar),
			       _("Delete"),
			       _("Delete selected files"),
			       NULL,
				 StockIcon(GTK_STOCK_DELETE),
			       G_CALLBACK (toolbar_MpDelete),
			       MainWindow, /* user data for callback */
			       -1);  /* -1 means "append" */


}

void left_treeview_DragSelectedFiles(GtkTreeModel *model,
		     GtkTreePath *path,
		     GtkTreeIter *iter,
		     GString* i)
{
    PlayListEntry* p;
    gchar* fname;

    gtk_tree_model_get(model,iter,0,&p,-1);


    fname = g_filename_to_uri(p->name->str,NULL,NULL);
    g_string_append_printf(i,"%s\r\n",fname);

}

void left_treeview_DragDataGet(GtkWidget *widget,
                                           			     GdkDragContext *drag_context,
														 GtkSelectionData *data,
														 guint info,
														 guint time,
														 gpointer user_data) {

     GtkWidget* tv;
     GtkTreeModel* model;
     GtkTreeSelection* selection;
     GString* buffer;

     buffer = g_string_sized_new(80);
     tv = MW_GET("left_treeview");
     model = gtk_tree_view_get_model(GTK_TREE_VIEW(tv));
     selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
     gtk_tree_selection_selected_foreach (selection,
				      (GtkTreeSelectionForeachFunc)left_treeview_DragSelectedFiles ,
					  buffer);
    
    g_string_append_c(buffer,'\0');
    gtk_selection_data_set(data,data->type,8,buffer->str,buffer->len);
    g_string_free(buffer,TRUE);
}														 

const GtkTargetEntry targets[] = {{"STRING",0,5},{"text/plain",0,5}};


GtkWidget* create_pc_frame(gchar* name) {
     GtkWidget* frame;
     GtkWidget* scroller;
     GtkWidget* treeview;
     GtkWidget* vbox;
     GtkWidget *toolbar;
     GtkWidget* statusbar;
     gchar c[64];

      frame = gtk_frame_new("Directory");
      sprintf(c,"%s%s",name,"frame");
      MW_SET(c,frame);

      vbox = gtk_vbox_new(FALSE,0);
      gtk_container_add(GTK_CONTAINER(frame),vbox);
      toolbar = gtk_toolbar_new ();
      gtk_toolbar_set_style(GTK_TOOLBAR(toolbar),GTK_TOOLBAR_ICONS);
	  //gtk_container_set_border_width(GTK_CONTAINER(vbox),5);
      sprintf(c,"%s%s",name,"toolbar");
      MW_SET(c,toolbar);
      gtk_box_pack_start(GTK_BOX(vbox),toolbar,FALSE,FALSE,0);
      scroller = gtk_scrolled_window_new(NULL,NULL);
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroller),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
     gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scroller),GTK_SHADOW_IN);
     gtk_container_set_border_width(GTK_CONTAINER(scroller),0);
     
      gtk_box_pack_start(GTK_BOX(vbox),scroller,TRUE,TRUE,0);
      treeview = gtk_tree_view_new();
      sprintf(c,"%s%s",name,"treeview");
      MW_SET(c,treeview);
      gtk_container_add(GTK_CONTAINER(scroller),treeview);

      gtk_drag_source_set(treeview,GDK_BUTTON1_MASK,targets,2,GDK_ACTION_COPY);
	  g_signal_connect(treeview,"drag-data-get",G_CALLBACK(left_treeview_DragDataGet),NULL);

      statusbar = gtk_statusbar_new();
      sprintf(c,"%s%s",name,"statusbar");
      MW_SET(c,statusbar);
      if (strcmp("left_",name) == 0)
	   gtk_statusbar_set_has_resize_grip(GTK_STATUSBAR(statusbar),FALSE);
      gtk_box_pack_start(GTK_BOX(vbox),statusbar,FALSE,FALSE,0);

      return frame;
}


//this is really crap , but i cannot be fscked
void right_list_drag_data_received(GtkWidget *widget,
                                GdkDragContext *drag_context,
                                gint x,
                                gint y,
                                GtkSelectionData *data,
                                guint info,
                                guint time,
                                gpointer user_data)
{
    guchar* fname;
    guchar* c;
    GList* entries;
    PlayListEntry* p;
    int ret;
    static gchar msg[101];
    
    if ((data->length < 4) || (data->format != 8)) {
        gtk_drag_finish(drag_context,FALSE,FALSE,time);
        return;
    }
    
	right_list_Select((gint) user_data);
    
    if (mpl_CheckForDevice() == FALSE) {
        MplinuxError();
        gtk_drag_finish(drag_context,FALSE,FALSE,time);
        return;
    }

    pl_MegaHack(1);

    c = data->data;
   // CRLF rears its ugly head again, much like this code
    while (c = strchr(c,'\n')) {
        *c = '\0';
        *(c - 1) = '\0';
        c++;
    }   

    c = data->data;
    do {
        fname = g_filename_from_uri(c,NULL,NULL);

        if (g_file_test(fname,G_FILE_TEST_IS_DIR)) { 
            entries = CreateWaitDialog((GThreadFunc)pl_AddDirectory,fname,
                            pl_AddDirectoryCancel,NULL,_("Reading Directory"));
            if (entries)
                g_list_free(entries);
        } else {
        	if ( pl_GetMp3Info(fname) )
	            pl_AddFile(fname);
        }
        c = c + strlen(c) + 2;
    } while (c < (data->data + data->length));

    gtk_drag_finish(drag_context,TRUE,FALSE,time);

    for(entries = pl_GetPlayList();entries;entries = g_list_next(entries)) {
        p = (PlayListEntry*) entries->data;
        snprintf(msg,100,_("sending %s"),p->ID3name_utf8->str);
        MW_SET("i_need_an_arg",p->ID3name->str);
        ret = (gint) CreateWaitDialog((GThreadFunc)one_arg_func,p->name->str,mpl_cancel_operation,
							  		  mpl_GetReadWriteProgress,msg);
        if (ret == MPL_ERROR) {
            MplinuxError();
            break;
        }
        right_treeview_Refresh(NULL,NULL);
     }

    right_treeview_Refresh(NULL,NULL);

    pl_MegaHack(0);
}

GtkWidget* create_mp_frame(gchar* name) {
     GtkWidget* frame;
     GtkWidget* button;
     GtkWidget* scroller;
     GtkWidget* treeview;
     GtkWidget* vbox;
     GtkWidget* vbox2;
     GtkWidget *toolbar;
     GtkWidget* statusbar;
     GtkWidget* vpaned;
     GtkWidget* label;
     GtkTargetList* target_list;

     gchar c[64];

     tooltips = gtk_tooltips_new();

      frame = gtk_frame_new("Directory");
      sprintf(c,"%s%s",name,"frame");
      MW_SET(c,frame);

      vbox = gtk_vbox_new(FALSE,0);
      gtk_container_add(GTK_CONTAINER(frame),vbox);
      toolbar = gtk_toolbar_new ();
      gtk_toolbar_set_style(GTK_TOOLBAR(toolbar),GTK_TOOLBAR_ICONS);
      sprintf(c,"%s%s",name,"toolbar");
      MW_SET(c,toolbar);
      gtk_box_pack_start(GTK_BOX(vbox),toolbar,FALSE,FALSE,0);

      vpaned = gtk_vpaned_new();
      MW_SET("splitter2",vpaned);
      gtk_box_pack_start(GTK_BOX(vbox),vpaned,TRUE,TRUE,0);

      vbox2 = gtk_vbox_new(FALSE,0);
      gtk_paned_pack1(GTK_PANED(vpaned),vbox2,TRUE,TRUE);
      
      scroller = gtk_scrolled_window_new(NULL,NULL);
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroller),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
     gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scroller),GTK_SHADOW_IN);
     gtk_container_set_border_width(GTK_CONTAINER(vbox2),0);
	
     button = gtk_button_new();
     label = gtk_label_new(_("Flash Memory"));
     gtk_container_add(GTK_CONTAINER(button),label);
     gtk_widget_set_size_request(button,1,20);
     gtk_tooltips_set_tip(tooltips,button,_("Select internal flash memory"),"");
     gtk_button_set_relief(GTK_BUTTON(button),GTK_RELIEF_NONE);
     gtk_box_pack_start(GTK_BOX(vbox2),button,FALSE,TRUE,0);
     
 
    gtk_box_pack_start(GTK_BOX(vbox2),scroller,TRUE,TRUE,0);
    MW_SET("flash_memory_button",button);
    MW_SET("flash_memory_scroller",scroller);
    MW_SET("flash_memory_label",label);
    g_signal_connect(button,"clicked",G_CALLBACK(right_list_button_Clicked),(gpointer)FLASH);

    treeview = gtk_tree_view_new();
    sprintf(c,"%s%s",name,"flash_treeview");
    MW_SET(c,treeview);
    gtk_container_add(GTK_CONTAINER(scroller),treeview);
																													  
	//gtk_drag_dest_set(scroller,GTK_DEST_DEFAULT_ALL,&drag_types[0],1,GDK_ACTION_COPY  );																													 
    gtk_drag_dest_set(scroller,GTK_DEST_DEFAULT_ALL,targets,2,GDK_ACTION_COPY);
    target_list = gtk_target_list_new(targets,2);
    gtk_drag_dest_set_target_list(scroller,target_list);
    g_signal_connect(scroller,"drag-data-received",G_CALLBACK(right_list_drag_data_received),(gpointer)FLASH);

    vbox2 = gtk_vbox_new(FALSE,0);
    gtk_paned_pack2(GTK_PANED(vpaned),vbox2,TRUE,TRUE);
    
    scroller = gtk_scrolled_window_new(NULL,NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroller),
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scroller),GTK_SHADOW_IN);
    gtk_container_set_border_width(GTK_CONTAINER(vbox2),0);

     button = gtk_button_new();
     label = gtk_label_new(_("SmartMedia"));
     gtk_container_add(GTK_CONTAINER(button),label);
     gtk_widget_set_size_request(button,1,20);
     gtk_tooltips_set_tip(tooltips,button,_("Select SmartMedia card memory"),"");
     gtk_button_set_relief(GTK_BUTTON(button),GTK_RELIEF_NONE);
     gtk_box_pack_start(GTK_BOX(vbox2),button,FALSE,TRUE,0);
  
  
    gtk_box_pack_start(GTK_BOX(vbox2),scroller,TRUE,TRUE,0);
    MW_SET("smart_memory_button",button);
    MW_SET("smart_memory_scroller",scroller);
    MW_SET("smart_memory_label",label);
    g_signal_connect(button,"clicked",G_CALLBACK(right_list_button_Clicked),(gpointer)SMART);


      treeview = gtk_tree_view_new();
      sprintf(c,"%s%s",name,"smartmedia_treeview");
      MW_SET(c,treeview);
      gtk_container_add(GTK_CONTAINER(scroller),treeview);

      gtk_drag_dest_set(scroller,GTK_DEST_DEFAULT_ALL,targets,2,GDK_ACTION_COPY);
      gtk_drag_dest_set_target_list(scroller,target_list);
      g_signal_connect(scroller,"drag-data-received",G_CALLBACK(right_list_drag_data_received),(gpointer)SMART);

	  //gtk_drag_dest_set(scroller,GTK_DEST_DEFAULT_ALL,&drag_types[1],1,GDK_ACTION_COPY  );

      statusbar = gtk_statusbar_new();
      sprintf(c,"%s%s",name,"statusbar");
      MW_SET(c,statusbar);
      if (strcmp("left_",name) == 0)
	   gtk_statusbar_set_has_resize_grip(GTK_STATUSBAR(statusbar),FALSE);
      gtk_box_pack_start(GTK_BOX(vbox),statusbar,FALSE,FALSE,0);

      right_list_Select(FLASH);

      return frame;
}


void create_play_list_view() {
     GtkWidget* tv;
     GtkCellRenderer* renderer;
     GtkTreeViewColumn *column;
     GtkListStore* list_store;
     GtkTreeSelection* selection;
     GtkWidget* w2;
     GtkWidget* w3;

     tv = MW_GET("left_treeview");
     list_store = gtk_list_store_new(1,G_TYPE_POINTER);
     gtk_tree_view_set_model(GTK_TREE_VIEW(tv),GTK_TREE_MODEL(list_store));
     gtk_tree_view_set_reorderable (GTK_TREE_VIEW(tv),TRUE);
     column = gtk_tree_view_column_new();
	 MW_SET("left_treeview_column",column);
     gtk_tree_view_column_set_title(column,_("Name"));
     renderer = gtk_cell_renderer_text_new();
     gtk_tree_view_column_pack_start (column,renderer,TRUE);
     gtk_tree_view_column_set_sizing(column,GTK_TREE_VIEW_COLUMN_FIXED);
     gtk_tree_view_column_set_resizable(column,TRUE);
     gtk_tree_view_column_set_fixed_width(column,250);
     gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(list_store),
				     0,left_treeview_Sort,(gpointer)10,NULL);
     gtk_tree_view_column_set_sort_column_id(column,0); 
     gtk_tree_view_column_set_cell_data_func (column, renderer,
					       left_treeview_cell_RenderName, NULL, NULL);
     gtk_tree_view_append_column (GTK_TREE_VIEW (tv),column);

     column = gtk_tree_view_column_new();
     gtk_tree_view_column_set_title(column,_("size"));
     renderer = gtk_cell_renderer_text_new();
	 g_object_set(renderer,"xalign",1.0,NULL);    
	 gtk_tree_view_column_pack_start (column,renderer,TRUE);
     gtk_tree_view_column_set_sizing(column,GTK_TREE_VIEW_COLUMN_FIXED);
     gtk_tree_view_column_set_resizable(column,FALSE);
	 gtk_tree_view_column_set_fixed_width(column,20);
     gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(list_store),
				     1,left_treeview_Sort,(gpointer)20,NULL);
     gtk_tree_view_column_set_sort_column_id(column,1); 
     gtk_tree_view_column_set_cell_data_func (column, renderer,
					       left_treeview_cell_RenderSize, NULL, NULL);
     gtk_tree_view_append_column (GTK_TREE_VIEW (tv),column);
     
     selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
     gtk_tree_selection_set_mode(selection,GTK_SELECTION_MULTIPLE);

     g_signal_connect_swapped(selection,"changed",G_CALLBACK(left_treeview_UpdateStatusbar),tv);

     w2 = gtk_menu_new();
     w3 = gtk_menu_item_new_with_label(_("Play Files"));
     g_signal_connect(w3,"activate",G_CALLBACK(popup_Context),(gpointer)1);
     gtk_menu_append(GTK_MENU(w2),w3);
     gtk_widget_show(w3);
     w3 = gtk_menu_item_new_with_label(_("Stop playing"));
     g_signal_connect(w3,"activate",G_CALLBACK(popup_Context),(gpointer)2);
     gtk_menu_append(GTK_MENU(w2),w3);
     gtk_widget_show(w3);
     w3 = gtk_menu_item_new_with_label(_("Send Files to Mpman"));
     g_signal_connect(w3,"activate",G_CALLBACK(toolbar_SendFiles),0);
     gtk_menu_append(GTK_MENU(w2),w3);
     gtk_widget_show(w3);
     w3 = gtk_menu_item_new_with_label(_("Remove Files"));
     g_signal_connect(w3,"activate",G_CALLBACK(toolbar_RemoveFiles),0);
     gtk_menu_append(GTK_MENU(w2),w3);
     gtk_widget_show(w3);
     w3 = gtk_menu_item_new_with_label(_("File Properties"));
     g_signal_connect(w3,"activate",G_CALLBACK(toolbar_FileProperties),0);
     gtk_menu_append(GTK_MENU(w2),w3);
     gtk_widget_show(w3);

     g_signal_connect(tv,"button-press-event",G_CALLBACK(left_treeview_ButtonEvent),w2);

}

void create_mp_list_view() {
     GtkWidget* tv;
     GtkCellRenderer* renderer;
     GtkTreeViewColumn *column;
     GtkListStore* list_store;
     GtkTreeSelection* selection;

     tv = MW_GET("right_flash_treeview");
     list_store = gtk_list_store_new(MP_LIST_N_COLUMNS,G_TYPE_STRING,
				     G_TYPE_STRING,G_TYPE_UCHAR);
     gtk_tree_view_set_model(GTK_TREE_VIEW(tv),GTK_TREE_MODEL(list_store));
     gtk_tree_view_set_reorderable (GTK_TREE_VIEW(tv),TRUE);     

     renderer = gtk_cell_renderer_text_new();
     column = gtk_tree_view_column_new_with_attributes (_("Name"),
							renderer,
							"text", MP_LIST_NAME,
							NULL);
     MW_SET("right_flash_treeview_column",column);
     gtk_tree_view_column_set_sizing(column,GTK_TREE_VIEW_COLUMN_FIXED);
     gtk_tree_view_column_set_resizable(column,TRUE);
     gtk_tree_view_column_set_fixed_width(column,250);
     gtk_tree_view_append_column (GTK_TREE_VIEW (tv),column);
     renderer = gtk_cell_renderer_text_new();
	 g_object_set(renderer,"xalign",1.0,NULL);
     column = gtk_tree_view_column_new_with_attributes (_("size"),
							renderer,
							"text", MP_LIST_SIZE,
							NULL);
     gtk_tree_view_column_set_sizing(column,GTK_TREE_VIEW_COLUMN_FIXED);
     gtk_tree_view_column_set_resizable(column,TRUE);
     gtk_tree_view_append_column (GTK_TREE_VIEW (tv),column);
     selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
     gtk_tree_selection_set_mode(selection,GTK_SELECTION_MULTIPLE);     

}

void create_smartmedia_list_view() {
     GtkWidget* tv;
     GtkCellRenderer* renderer;
     GtkTreeViewColumn *column;
     GtkListStore* list_store;
     GtkTreeSelection* selection;

     tv = MW_GET("right_smartmedia_treeview");
     list_store = gtk_list_store_new(MP_LIST_N_COLUMNS,G_TYPE_STRING,
				     G_TYPE_STRING,G_TYPE_UCHAR);
     gtk_tree_view_set_model(GTK_TREE_VIEW(tv),GTK_TREE_MODEL(list_store));
     gtk_tree_view_set_reorderable (GTK_TREE_VIEW(tv),TRUE);     

     renderer = gtk_cell_renderer_text_new();
     column = gtk_tree_view_column_new_with_attributes (_("Name"),
							renderer,
							"text", MP_LIST_NAME,
							NULL);
	 MW_SET("right_smartmedia_treeview_column",column);
     gtk_tree_view_column_set_sizing(column,GTK_TREE_VIEW_COLUMN_FIXED);
     gtk_tree_view_column_set_resizable(column,TRUE);
     gtk_tree_view_column_set_fixed_width(column,250);
     gtk_tree_view_append_column (GTK_TREE_VIEW (tv),column);
     renderer = gtk_cell_renderer_text_new();
	 g_object_set(renderer,"xalign",1.0,NULL);
     column = gtk_tree_view_column_new_with_attributes (_("size"),
							renderer,
							"text", MP_LIST_SIZE,
							NULL);
     gtk_tree_view_column_set_sizing(column,GTK_TREE_VIEW_COLUMN_FIXED);
     gtk_tree_view_column_set_resizable(column,TRUE);
     gtk_tree_view_append_column (GTK_TREE_VIEW (tv),column);
     selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(tv));
     gtk_tree_selection_set_mode(selection,GTK_SELECTION_MULTIPLE);

}

void create_main_window(GtkWindow** return_window) {
     GtkWidget* window;
     GtkWidget* vbox;
     GtkWidget* hpaned;
     GtkWidget* gen;
     GtkItemFactory *item_factory;
     GtkAccelGroup *accel_group;   
     GList* icons =NULL;
     GdkPixbuf* p;
  //   GtkItemFactoryEntry* t_menu_items;
     int i;
     
     window = gtk_widget_new(GTK_TYPE_WINDOW,
			     "type",GTK_WINDOW_TOPLEVEL,
			     "title","Mplinuxman",
			     "allow_grow",TRUE,
			     "allow_shrink",FALSE,
			     "default-width",650,
			     "default-height",450,
			     NULL);

	 if (strstr(MP_VERSION,"beta") != NULL) {
		char buffer[30];
		snprintf(buffer,29,"Mplinuxman %s",MP_VERSION);
		gtk_window_set_title(GTK_WINDOW(window),buffer);
	 }
	 
     *return_window = GTK_WINDOW(window);
     g_signal_connect(window,"destroy",G_CALLBACK(mw_Destroy),NULL);

     vbox = gtk_vbox_new(FALSE,5);
     gtk_container_add(GTK_CONTAINER(window),vbox);

     accel_group = gtk_accel_group_new ();
     gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
     g_object_unref (accel_group);    

     item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", accel_group);
     
//     t_menu_items = g_malloc(sizeof(GtkItemFactoryEntry)*G_N_ELEMENTS(menu_items));
     for(i=0;i<G_N_ELEMENTS(menu_items);i++) {
	     menu_items[i].path = gettext(menu_items[i].path);
/* 	 	    t_menu_items[i].path = _(menu_items[i].path);
		    t_menu_items[i].accelerator = menu_items[i].accelerator;
		    t_menu_items[i].callback = menu_items[i].callback;
		    t_menu_items[i].callback_action = menu_items[i].callback_action;
		    t_menu_items[i].item_type = menu_items[i].item_type;
		    t_menu_items[i].extra_data = menu_items[i].extra_data;
 */     }
     
     gtk_item_factory_create_items (item_factory, G_N_ELEMENTS (menu_items),
                                     menu_items, window);

      gtk_box_pack_start(GTK_BOX(vbox),gtk_item_factory_get_widget (item_factory, "<main>"),
			                                                                    FALSE,FALSE,0);
     
      hpaned = gtk_hpaned_new();
      MW_SET("splitter",hpaned);
      gtk_box_pack_start(GTK_BOX(vbox),hpaned,TRUE,TRUE,0);
      gtk_container_set_border_width(GTK_CONTAINER(hpaned),0);

      gtk_paned_pack1(GTK_PANED(hpaned),create_pc_frame("left_"),TRUE,TRUE);
      gtk_paned_pack2(GTK_PANED(hpaned),create_mp_frame("right_"),TRUE,TRUE);

       gen = MW_GET("left_frame");
      gtk_frame_set_label(GTK_FRAME(gen),"PC");
	  //gtk_frame_set_shadow_type(GTK_FRAME(gen),GTK_SHADOW_NONE);
      gen = MW_GET("right_frame");
      gtk_frame_set_label(GTK_FRAME(gen),"MpMan");
	  //gtk_frame_set_shadow_type(GTK_FRAME(gen),GTK_SHADOW_NONE);
 
     g_signal_connect(MainWindow,"configure_event",G_CALLBACK(main_window_FrameEvent),
			    NULL);

     g_signal_connect(MainWindow,"window-state-event",G_CALLBACK(main_window_WindowStateEvent),
			    NULL);

      create_toolbar();
      create_play_list_view();
      create_mp_list_view();
      create_smartmedia_list_view();

      p = gdk_pixbuf_new_from_xpm_data((const char**)&logo);	  
      MW_SET("mp_icon",p);
      icons = g_list_append(icons,p);
      gtk_window_set_default_icon_list (icons);
	  
	  //store the current locale
#ifdef NLS	  
	  MW_SET("current_locle",setlocale(LC_ALL,NULL));
#endif
}


