
/*
 * $Header: /cvsroot/mpdist/mpdist/common/option.h,v 1.2 2002/10/15 19:09:32 richbastard Exp $
 * 
 * Copyright (c) 1987-2002 Rich Burridge, Sun Microsystems Inc.
 * All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MP_OPTION_H__
#define __MP_OPTION_H__

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <X11/Xlib.h>
#include <X11/Xresource.h>

#define  FCLOSE   (void) fclose
#define  FPRINTF  (void) fprintf
#define  FPUTS    (void) fputs
#define  FREE     (void) free
#define  PCLOSE   (void) pclose
#define  PUTC     (void) putc
#define  SSCANF   (void) sscanf
#define  SPRINTF  (void) sprintf
#define  STRCAT   (void) strcat
#define  STRCPY   (void) strcpy
#define  STRNCPY  (void) strncpy
#define  UNGETC   (void) ungetc

#define  DEFCOLUMNS    1    /* Number of columns per page. */
#define  DEFCOPIES     1    /* Number of copies of each file. */
#define  DEFMARGIN     8    /* Default margin size (in points). */
#define  LINELENGTH    80   /* Number of characters per line. */
#define  MAXCOPIES     500  /* Maximum number of copies to print. */
#define  MAXHDRS       64   /* Maximum number of -addhdr or -remhdr options. */
#define  MAXLINE       256  /* Maximum string length. */
#define  MAXMARGIN     500  /* Maximum margin size (in points). */
#define  MAXNAMES      512  /* Maximum number of files from command line. */
#define  MAXRESOURCES  42   /* Maximum number of mp X resources. */
#define  NAMEFIELDS    3    /* Default no. of "words" from passwd gecos. */
#define  NAMELENGTH    40   /* Maximum allowable real user name. */
#define  PAGELENGTH    72   /* Number of lines per page. */
#define  TABSIZE       8    /* Number of spaces in a tab char. */

#define  ARG_EQUAL(s, n)      (!argcmp(argv[i], s, n))
#define  CASE_EQUAL(a, b)     (!strcasecmp(a, b))
#define  EQUAL(a, b)          (!strcmp(a, b))
#define  OLD_ARG_EQ(s)        (!strcmp(argv[i], s))

#ifndef  MAXPATHLEN
#define  MAXPATHLEN   1024
#endif /* MAXPATHLEN */

#ifndef  PROLOGDIR          /* PostScript prologue file. */
#define  PROLOGDIR          "/usr/local/lib/mp"
#endif /* PROLOGDIR */

#define  PRO_FILOFAX       "mp.pro.ff.ps"
#define  PRO_FILOFAXP      "mp.pro.ffp.ps"
#define  PRO_FRANKLIN      "mp.pro.fp.ps"
#define  PRO_LANDSCAPE     "mp.pro.l.ps"
#define  PRO_LANDSCAPE_C1  "mp.pro.l.c1.ps"
#define  PRO_NORMAL        "mp.pro.ps"
#define  PRO_OTHER         "other"
#define  PRO_PRO_PLAN      "mp.pro.pp.ps"
#define  PRO_TIME_MANAGER  "mp.pro.tm.ps"
#define  PRO_TS_INTL       "mp.pro.tsi.ps"
#define  PRO_TS_PARTNER    "mp.pro.tsp.ps"

enum header_type {
    H_ADD, H_REMOVE
};

enum margin_type {
    M_BOTTOM, M_LEFT, M_RIGHT, M_TOP
};

enum opt_type {
    O_ADDHDRN,  O_ALIAS,     O_ALLHDRS,  O_APPNAME,
    O_ARTICLE,  O_BANNERS,   O_BSDPRINT, O_BURSTPAGE,
    O_CONTENT,  O_COPIES,    O_DIGEST,   O_DUPLEX, 
    O_ELM,      O_FLIP,      O_FOLDER,   O_FORCEPAGE, 
    O_GSUBJECT, O_LANDSCAPE, O_LLEN,     O_MODTIME, 
    O_NAMEF,    O_NAMELEN,   O_NEWPAGE,  O_NUMBER, 
    O_NUMCOLS,  O_NUMNAMES,
#ifdef MIME_SUPPORT
    O_PAGIN,
#endif /* MIME_SUPPORT */
    O_PLEN,     O_PR_NAME,   O_PR_ORIG,  O_PRINT_PS,
    O_REMHDRN,  O_TABSIZE,   O_TEXTDOC,  O_TOPRINT,
    O_TUMBLE,   O_WRAPW,     O_TOOLTIP
};

enum paper_type {
    P_NONE, P_A4, P_US
};

enum res_type {
    R_FTYPE,    R_OTYPE,    R_ORGANISER, R_PSIZE,
    R_HDRPAGE,  R_MAIL_FDR, R_MAIL_DIG,  R_SUBJECT,
    R_LLENGTH,  R_PLENGTH,  R_COPIES,    R_PNAME,
    R_DSIDED,   R_ADDHDRS,  R_REMHDRS,   R_PROLOG,
    R_ALIAS,    R_NCOLUMNS, R_TABSIZE,   R_NAMEC,
    R_NAMEW,    R_WRAP,     R_FLIP,      R_FORCEPAGE,
    R_ELM,      R_NUMBER,   R_FROM,      R_CONTENT,
    R_MOD,      R_TUMBLE,   R_ALLHDRS,   R_BSDPRINT,
    R_BMARGIN,  R_LMARGIN,  R_RMARGIN,   R_TMARGIN,
#ifdef MIME_SUPPORT
    R_BOUNDARY, R_TYPESIZE, R_PAGINATE,
#endif /* MIME_SUPPORT */
    R_BANNERS,  R_NEWPAGE,  R_TOOLTIP
};

extern char *prologue;                /* Name of PostScript prologue file. */
extern char proname[MAXPATHLEN];      /* Full pathname of the prologue file. */
extern char *ptype;                   /* Prologue type. */

extern enum paper_type paper_size;    /* Paper size - default None. */

#ifdef MIME_SUPPORT
extern char *boundary;
extern int  typesize;
extern int  paginate;
#endif /* MIME_SUPPORT */

extern char *get_filename        (int);
extern char *get_hdr             (enum header_type, int);
extern char *str_opt_val         (enum opt_type);

extern int  get_margin           (enum margin_type);
extern int  int_opt_val          (enum opt_type);
extern int  is_opt_given         (enum opt_type);

extern void adjust_paper_size    (void);
extern void free_hdr             (enum header_type, int);
extern void get_appname          (int, char **);
extern void get_hdr_arg          (char *, enum header_type, int *);
extern void get_options          (int, char **);
extern void Option               (void);
extern void set_int_opt_val      (enum opt_type, int);
extern void set_margin           (enum margin_type, int);
extern void set_str_opt_val      (enum opt_type, char *);
extern void read_resources       (void);
extern void write_resources      (void);

#endif /* __MP_OPTION_H__ */
