/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.BooleanExpr;
import com.jclark.xsl.expr.CloneableNodeIterator;
import com.jclark.xsl.expr.CloneableNodeIteratorImpl;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.ExtensionContext;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

class FilterNodeIterator
implements NodeIterator,
ExprContext {
    private int pos = 0;
    private int lastPos = 0;
    private NodeIterator iter;
    private final ExprContext origContext;
    private final BooleanExpr predicate;

    public Variant getSystemProperty(Name name) {
        return this.origContext.getSystemProperty(name);
    }

    public Variant getLocalVariableValue(Name name) throws XSLException {
        return this.origContext.getLocalVariableValue(name);
    }

    FilterNodeIterator(NodeIterator nodeIterator, ExprContext exprContext, BooleanExpr booleanExpr) {
        this.iter = nodeIterator;
        this.origContext = exprContext;
        this.predicate = booleanExpr;
    }

    public Variant getGlobalVariableValue(Name name) throws XSLException {
        return this.origContext.getGlobalVariableValue(name);
    }

    public Node next() throws XSLException {
        Node node;
        while ((node = this.iter.next()) != null) {
            ++this.pos;
            if (!this.predicate.eval(node, this)) continue;
            return node;
        }
        return null;
    }

    public int getPosition() {
        return this.pos;
    }

    public int getLastPosition() throws XSLException {
        if (this.lastPos == 0) {
            CloneableNodeIterator cloneableNodeIterator = this.iter instanceof CloneableNodeIterator ? (CloneableNodeIterator)this.iter : new CloneableNodeIteratorImpl(this.iter);
            this.iter = (NodeIterator)cloneableNodeIterator.clone();
            int n = this.pos;
            try {
                while (this.next() != null) {
                }
                this.lastPos = this.pos;
            }
            finally {
                Object var4_3 = null;
                this.pos = n;
                this.iter = cloneableNodeIterator;
            }
        }
        return this.lastPos;
    }

    public ExtensionContext getExtensionContext(String string) throws XSLException {
        return this.origContext.getExtensionContext(string);
    }
}

