/* A Bison parser, made by GNU Bison 3.5.1.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.5.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 26 "src/p.y"


/*
 * DESCRIPTION
 *   Simple context-free grammar for parsing the control file.
 *
 */

#include "config.h"

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif

#ifdef HAVE_PWD_H
#include <pwd.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#ifdef HAVE_TIME_H
#include <time.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifdef HAVE_ASM_PARAM_H
#include <asm/param.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif

#ifdef HAVE_NETINET_IN_SYSTM_H
#include <netinet/in_systm.h>
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#ifdef HAVE_NETINET_IP_H
#include <netinet/ip.h>
#endif

#ifdef HAVE_NETINET_IP_ICMP_H
#include <netinet/ip_icmp.h>
#endif

#ifdef HAVE_REGEX_H
#include <regex.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_OPENSSL
#include <openssl/ssl.h>
#endif

#include "monit.h"
#include "protocol.h"
#include "engine.h"
#include "alert.h"
#include "ProcessTree.h"
#include "device.h"
#include "processor.h"
#include "md5.h"
#include "sha1.h"
#include "checksum.h"
#include "process_sysdep.h"

// libmonit
#include "io/File.h"
#include "util/Str.h"
#include "thread/Thread.h"


/* ------------------------------------------------------------- Definitions */


struct precedence_t {
        bool daemon;
        bool logfile;
        bool pidfile;
};

struct rate_t {
        unsigned int count;
        unsigned int cycles;
};

/* yacc interface */
void  yyerror(const char *,...) __attribute__((format (printf, 1, 2)));
void  yyerror2(const char *,...) __attribute__((format (printf, 1, 2)));
void  yywarning(const char *,...) __attribute__((format (printf, 1, 2)));
void  yywarning2(const char *,...) __attribute__((format (printf, 1, 2)));

/* lexer interface */
int yylex(void);
extern FILE *yyin;
extern int lineno;
extern int arglineno;
extern char *yytext;
extern char *argyytext;
extern char *currentfile;
extern char *argcurrentfile;
extern int buffer_stack_ptr;

/* Local variables */
static int cfg_errflag = 0;
static Service_T tail = NULL;
static Service_T current = NULL;
static Request_T urlrequest = NULL;
static command_t command = NULL;
static command_t command1 = NULL;
static command_t command2 = NULL;
static Service_T depend_list = NULL;
static struct Uid_T uidset = {};
static struct Gid_T gidset = {};
static struct Pid_T pidset = {};
static struct Pid_T ppidset = {};
static struct FsFlag_T fsflagset = {};
static struct NonExist_T nonexistset = {};
static struct Exist_T existset = {};
static struct Status_T statusset = {};
static struct Perm_T permset = {};
static struct Size_T sizeset = {};
static struct Uptime_T uptimeset = {};
static struct ResponseTime_T responsetimeset = {};
static struct LinkStatus_T linkstatusset = {};
static struct LinkSpeed_T linkspeedset = {};
static struct LinkSaturation_T linksaturationset = {};
static struct Bandwidth_T bandwidthset = {};
static struct Match_T matchset = {};
static struct Icmp_T icmpset = {};
static struct Mail_T mailset = {};
static struct SslOptions_T sslset = {};
static struct Port_T portset = {};
static struct MailServer_T mailserverset = {};
static struct Mmonit_T mmonitset = {};
static struct FileSystem_T filesystemset = {};
static struct Resource_T resourceset = {};
static struct Checksum_T checksumset = {};
static struct Timestamp_T timestampset = {};
static struct ActionRate_T actionrateset = {};
static struct precedence_t ihp = {false, false, false};
static struct rate_t rate = {1, 1};
static struct rate_t rate1 = {1, 1};
static struct rate_t rate2 = {1, 1};
static char * htpasswd_file = NULL;
static unsigned int repeat = 0;
static unsigned int repeat1 = 0;
static unsigned int repeat2 = 0;
static Digest_Type digesttype = Digest_Cleartext;

#define BITMAP_MAX (sizeof(long long) * 8)


/* -------------------------------------------------------------- Prototypes */

static void  preparse(void);
static void  postparse(void);
static bool _parseOutgoingAddress(char *ip, Outgoing_T *outgoing);
static void  addmail(char *, Mail_T, Mail_T *);
static Service_T createservice(Service_Type, char *, char *, State_Type (*)(Service_T));
static void  addservice(Service_T);
static void  adddependant(char *);
static void  addservicegroup(char *);
static void  addport(Port_T *, Port_T);
static void  addhttpheader(Port_T, char *);
static void  addresource(Resource_T);
static void  addtimestamp(Timestamp_T);
static void  addactionrate(ActionRate_T);
static void  addsize(Size_T);
static void  adduptime(Uptime_T);
static void  addpid(Pid_T);
static void  addppid(Pid_T);
static void  addfsflag(FsFlag_T);
static void  addnonexist(NonExist_T);
static void  addexist(Exist_T);
static void  addlinkstatus(Service_T, LinkStatus_T);
static void  addlinkspeed(Service_T, LinkSpeed_T);
static void  addlinksaturation(Service_T, LinkSaturation_T);
static void  addbandwidth(Bandwidth_T *, Bandwidth_T);
static void  addfilesystem(FileSystem_T);
static void  addicmp(Icmp_T);
static void  addgeneric(Port_T, char*, char*);
static void  addcommand(int, unsigned);
static void  addargument(char *);
static void  addmmonit(Mmonit_T);
static void  addmailserver(MailServer_T);
static bool addcredentials(char *, char *, Digest_Type, bool);
#ifdef HAVE_LIBPAM
static void  addpamauth(char *, int);
#endif
static void  addhtpasswdentry(char *, char *, Digest_Type);
static uid_t get_uid(char *, uid_t);
static gid_t get_gid(char *, gid_t);
static void  addchecksum(Checksum_T);
static void  addperm(Perm_T);
static void  addmatch(Match_T, int, int);
static void  addmatchpath(Match_T, Action_Type);
static void  addstatus(Status_T);
static Uid_T adduid(Uid_T);
static Gid_T addgid(Gid_T);
static void  addeuid(uid_t);
static void  addegid(gid_t);
static void  addeventaction(EventAction_T *, Action_Type, Action_Type);
static void  prepare_urlrequest(URL_T U);
static void  seturlrequest(int, char *);
static void  setlogfile(char *);
static void  setpidfile(char *);
static void  reset_sslset(void);
static void  reset_mailset(void);
static void  reset_mailserverset(void);
static void  reset_mmonitset(void);
static void  reset_portset(void);
static void  reset_resourceset(void);
static void  reset_timestampset(void);
static void  reset_actionrateset(void);
static void  reset_sizeset(void);
static void  reset_uptimeset(void);
static void  reset_responsetimeset(void);
static void  reset_pidset(void);
static void  reset_ppidset(void);
static void  reset_fsflagset(void);
static void  reset_nonexistset(void);
static void  reset_existset(void);
static void  reset_linkstatusset(void);
static void  reset_linkspeedset(void);
static void  reset_linksaturationset(void);
static void  reset_bandwidthset(void);
static void  reset_checksumset(void);
static void  reset_permset(void);
static void  reset_uidset(void);
static void  reset_gidset(void);
static void  reset_statusset(void);
static void  reset_filesystemset(void);
static void  reset_icmpset(void);
static void  reset_rateset(struct rate_t *);
static void  check_name(char *);
static int   check_perm(int);
static void  check_exec(char *);
static int   cleanup_hash_string(char *);
static void  check_depend(void);
static void  setsyslog(char *);
static command_t copycommand(command_t);
static int verifyMaxForward(int);
static void _setPEM(char **store, char *path, const char *description, bool isFile);
static void _setSSLOptions(SslOptions_T options);
#ifdef HAVE_OPENSSL
static void _setSSLVersion(short version);
#endif
static void _unsetSSLVersion(short version);
static void addsecurityattribute(char *, Action_Type, Action_Type);
static void addfiledescriptors(Operator_Type, bool, long long, float, Action_Type, Action_Type);
static void _sanityCheckEveryStatement(Service_T s);


#line 369 "src/y.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_SRC_Y_TAB_H_INCLUDED
# define YY_YY_SRC_Y_TAB_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    IF = 258,
    ELSE = 259,
    THEN = 260,
    FAILED = 261,
    SET = 262,
    LOGFILE = 263,
    FACILITY = 264,
    DAEMON = 265,
    SYSLOG = 266,
    MAILSERVER = 267,
    HTTPD = 268,
    ALLOW = 269,
    REJECTOPT = 270,
    ADDRESS = 271,
    INIT = 272,
    TERMINAL = 273,
    BATCH = 274,
    READONLY = 275,
    CLEARTEXT = 276,
    MD5HASH = 277,
    SHA1HASH = 278,
    CRYPT = 279,
    DELAY = 280,
    PEMFILE = 281,
    PEMKEY = 282,
    PEMCHAIN = 283,
    ENABLE = 284,
    DISABLE = 285,
    SSLTOKEN = 286,
    CIPHER = 287,
    CLIENTPEMFILE = 288,
    ALLOWSELFCERTIFICATION = 289,
    SELFSIGNED = 290,
    VERIFY = 291,
    CERTIFICATE = 292,
    CACERTIFICATEFILE = 293,
    CACERTIFICATEPATH = 294,
    VALID = 295,
    INTERFACE = 296,
    LINK = 297,
    PACKET = 298,
    BYTEIN = 299,
    BYTEOUT = 300,
    PACKETIN = 301,
    PACKETOUT = 302,
    SPEED = 303,
    SATURATION = 304,
    UPLOAD = 305,
    DOWNLOAD = 306,
    TOTAL = 307,
    UP = 308,
    DOWN = 309,
    IDFILE = 310,
    STATEFILE = 311,
    SEND = 312,
    EXPECT = 313,
    CYCLE = 314,
    COUNT = 315,
    REMINDER = 316,
    REPEAT = 317,
    LIMITS = 318,
    SENDEXPECTBUFFER = 319,
    EXPECTBUFFER = 320,
    FILECONTENTBUFFER = 321,
    HTTPCONTENTBUFFER = 322,
    PROGRAMOUTPUT = 323,
    NETWORKTIMEOUT = 324,
    PROGRAMTIMEOUT = 325,
    STARTTIMEOUT = 326,
    STOPTIMEOUT = 327,
    RESTARTTIMEOUT = 328,
    PIDFILE = 329,
    START = 330,
    STOP = 331,
    PATHTOK = 332,
    RSAKEY = 333,
    HOST = 334,
    HOSTNAME = 335,
    PORT = 336,
    IPV4 = 337,
    IPV6 = 338,
    TYPE = 339,
    UDP = 340,
    TCP = 341,
    TCPSSL = 342,
    PROTOCOL = 343,
    CONNECTION = 344,
    ALERT = 345,
    NOALERT = 346,
    MAILFORMAT = 347,
    UNIXSOCKET = 348,
    SIGNATURE = 349,
    TIMEOUT = 350,
    RETRY = 351,
    RESTART = 352,
    CHECKSUM = 353,
    EVERY = 354,
    NOTEVERY = 355,
    DEFAULT = 356,
    HTTP = 357,
    HTTPS = 358,
    APACHESTATUS = 359,
    FTP = 360,
    SMTP = 361,
    SMTPS = 362,
    POP = 363,
    POPS = 364,
    IMAP = 365,
    IMAPS = 366,
    CLAMAV = 367,
    NNTP = 368,
    NTP3 = 369,
    MYSQL = 370,
    MYSQLS = 371,
    DNS = 372,
    WEBSOCKET = 373,
    MQTT = 374,
    SSH = 375,
    DWP = 376,
    LDAP2 = 377,
    LDAP3 = 378,
    RDATE = 379,
    RSYNC = 380,
    TNS = 381,
    PGSQL = 382,
    POSTFIXPOLICY = 383,
    SIP = 384,
    LMTP = 385,
    GPS = 386,
    RADIUS = 387,
    MEMCACHE = 388,
    REDIS = 389,
    MONGODB = 390,
    SIEVE = 391,
    SPAMASSASSIN = 392,
    FAIL2BAN = 393,
    STRING = 394,
    PATH = 395,
    MAILADDR = 396,
    MAILFROM = 397,
    MAILREPLYTO = 398,
    MAILSUBJECT = 399,
    MAILBODY = 400,
    SERVICENAME = 401,
    STRINGNAME = 402,
    NUMBER = 403,
    PERCENT = 404,
    LOGLIMIT = 405,
    CLOSELIMIT = 406,
    DNSLIMIT = 407,
    KEEPALIVELIMIT = 408,
    REPLYLIMIT = 409,
    REQUESTLIMIT = 410,
    STARTLIMIT = 411,
    WAITLIMIT = 412,
    GRACEFULLIMIT = 413,
    CLEANUPLIMIT = 414,
    REAL = 415,
    CHECKPROC = 416,
    CHECKFILESYS = 417,
    CHECKFILE = 418,
    CHECKDIR = 419,
    CHECKHOST = 420,
    CHECKSYSTEM = 421,
    CHECKFIFO = 422,
    CHECKPROGRAM = 423,
    CHECKNET = 424,
    THREADS = 425,
    CHILDREN = 426,
    METHOD = 427,
    GET = 428,
    HEAD = 429,
    STATUS = 430,
    ORIGIN = 431,
    VERSIONOPT = 432,
    READ = 433,
    WRITE = 434,
    OPERATION = 435,
    SERVICETIME = 436,
    DISK = 437,
    RESOURCE = 438,
    MEMORY = 439,
    TOTALMEMORY = 440,
    LOADAVG1 = 441,
    LOADAVG5 = 442,
    LOADAVG15 = 443,
    SWAP = 444,
    MODE = 445,
    ACTIVE = 446,
    PASSIVE = 447,
    MANUAL = 448,
    ONREBOOT = 449,
    NOSTART = 450,
    LASTSTATE = 451,
    CORE = 452,
    CPU = 453,
    TOTALCPU = 454,
    CPUUSER = 455,
    CPUSYSTEM = 456,
    CPUWAIT = 457,
    CPUNICE = 458,
    CPUHARDIRQ = 459,
    CPUSOFTIRQ = 460,
    CPUSTEAL = 461,
    CPUGUEST = 462,
    CPUGUESTNICE = 463,
    GROUP = 464,
    REQUEST = 465,
    DEPENDS = 466,
    BASEDIR = 467,
    SLOT = 468,
    EVENTQUEUE = 469,
    SECRET = 470,
    HOSTHEADER = 471,
    UID = 472,
    EUID = 473,
    GID = 474,
    MMONIT = 475,
    INSTANCE = 476,
    USERNAME = 477,
    PASSWORD = 478,
    DATABASE = 479,
    TIME = 480,
    ATIME = 481,
    CTIME = 482,
    MTIME = 483,
    CHANGED = 484,
    MILLISECOND = 485,
    SECOND = 486,
    MINUTE = 487,
    HOUR = 488,
    DAY = 489,
    MONTH = 490,
    SSLV2 = 491,
    SSLV3 = 492,
    TLSV1 = 493,
    TLSV11 = 494,
    TLSV12 = 495,
    TLSV13 = 496,
    CERTMD5 = 497,
    AUTO = 498,
    NOSSLV2 = 499,
    NOSSLV3 = 500,
    NOTLSV1 = 501,
    NOTLSV11 = 502,
    NOTLSV12 = 503,
    NOTLSV13 = 504,
    BYTE = 505,
    KILOBYTE = 506,
    MEGABYTE = 507,
    GIGABYTE = 508,
    INODE = 509,
    SPACE = 510,
    TFREE = 511,
    PERMISSION = 512,
    SIZE = 513,
    MATCH = 514,
    NOT = 515,
    IGNORE = 516,
    ACTION = 517,
    UPTIME = 518,
    RESPONSETIME = 519,
    EXEC = 520,
    UNMONITOR = 521,
    PING = 522,
    PING4 = 523,
    PING6 = 524,
    ICMP = 525,
    ICMPECHO = 526,
    NONEXIST = 527,
    EXIST = 528,
    INVALID = 529,
    DATA = 530,
    RECOVERED = 531,
    PASSED = 532,
    SUCCEEDED = 533,
    URL = 534,
    CONTENT = 535,
    PID = 536,
    PPID = 537,
    FSFLAG = 538,
    REGISTER = 539,
    CREDENTIALS = 540,
    URLOBJECT = 541,
    ADDRESSOBJECT = 542,
    TARGET = 543,
    TIMESPEC = 544,
    HTTPHEADER = 545,
    MAXFORWARD = 546,
    FIPS = 547,
    SECURITY = 548,
    ATTRIBUTE = 549,
    FILEDESCRIPTORS = 550,
    GREATER = 551,
    GREATEROREQUAL = 552,
    LESS = 553,
    LESSOREQUAL = 554,
    EQUAL = 555,
    NOTEQUAL = 556
  };
#endif
/* Tokens.  */
#define IF 258
#define ELSE 259
#define THEN 260
#define FAILED 261
#define SET 262
#define LOGFILE 263
#define FACILITY 264
#define DAEMON 265
#define SYSLOG 266
#define MAILSERVER 267
#define HTTPD 268
#define ALLOW 269
#define REJECTOPT 270
#define ADDRESS 271
#define INIT 272
#define TERMINAL 273
#define BATCH 274
#define READONLY 275
#define CLEARTEXT 276
#define MD5HASH 277
#define SHA1HASH 278
#define CRYPT 279
#define DELAY 280
#define PEMFILE 281
#define PEMKEY 282
#define PEMCHAIN 283
#define ENABLE 284
#define DISABLE 285
#define SSLTOKEN 286
#define CIPHER 287
#define CLIENTPEMFILE 288
#define ALLOWSELFCERTIFICATION 289
#define SELFSIGNED 290
#define VERIFY 291
#define CERTIFICATE 292
#define CACERTIFICATEFILE 293
#define CACERTIFICATEPATH 294
#define VALID 295
#define INTERFACE 296
#define LINK 297
#define PACKET 298
#define BYTEIN 299
#define BYTEOUT 300
#define PACKETIN 301
#define PACKETOUT 302
#define SPEED 303
#define SATURATION 304
#define UPLOAD 305
#define DOWNLOAD 306
#define TOTAL 307
#define UP 308
#define DOWN 309
#define IDFILE 310
#define STATEFILE 311
#define SEND 312
#define EXPECT 313
#define CYCLE 314
#define COUNT 315
#define REMINDER 316
#define REPEAT 317
#define LIMITS 318
#define SENDEXPECTBUFFER 319
#define EXPECTBUFFER 320
#define FILECONTENTBUFFER 321
#define HTTPCONTENTBUFFER 322
#define PROGRAMOUTPUT 323
#define NETWORKTIMEOUT 324
#define PROGRAMTIMEOUT 325
#define STARTTIMEOUT 326
#define STOPTIMEOUT 327
#define RESTARTTIMEOUT 328
#define PIDFILE 329
#define START 330
#define STOP 331
#define PATHTOK 332
#define RSAKEY 333
#define HOST 334
#define HOSTNAME 335
#define PORT 336
#define IPV4 337
#define IPV6 338
#define TYPE 339
#define UDP 340
#define TCP 341
#define TCPSSL 342
#define PROTOCOL 343
#define CONNECTION 344
#define ALERT 345
#define NOALERT 346
#define MAILFORMAT 347
#define UNIXSOCKET 348
#define SIGNATURE 349
#define TIMEOUT 350
#define RETRY 351
#define RESTART 352
#define CHECKSUM 353
#define EVERY 354
#define NOTEVERY 355
#define DEFAULT 356
#define HTTP 357
#define HTTPS 358
#define APACHESTATUS 359
#define FTP 360
#define SMTP 361
#define SMTPS 362
#define POP 363
#define POPS 364
#define IMAP 365
#define IMAPS 366
#define CLAMAV 367
#define NNTP 368
#define NTP3 369
#define MYSQL 370
#define MYSQLS 371
#define DNS 372
#define WEBSOCKET 373
#define MQTT 374
#define SSH 375
#define DWP 376
#define LDAP2 377
#define LDAP3 378
#define RDATE 379
#define RSYNC 380
#define TNS 381
#define PGSQL 382
#define POSTFIXPOLICY 383
#define SIP 384
#define LMTP 385
#define GPS 386
#define RADIUS 387
#define MEMCACHE 388
#define REDIS 389
#define MONGODB 390
#define SIEVE 391
#define SPAMASSASSIN 392
#define FAIL2BAN 393
#define STRING 394
#define PATH 395
#define MAILADDR 396
#define MAILFROM 397
#define MAILREPLYTO 398
#define MAILSUBJECT 399
#define MAILBODY 400
#define SERVICENAME 401
#define STRINGNAME 402
#define NUMBER 403
#define PERCENT 404
#define LOGLIMIT 405
#define CLOSELIMIT 406
#define DNSLIMIT 407
#define KEEPALIVELIMIT 408
#define REPLYLIMIT 409
#define REQUESTLIMIT 410
#define STARTLIMIT 411
#define WAITLIMIT 412
#define GRACEFULLIMIT 413
#define CLEANUPLIMIT 414
#define REAL 415
#define CHECKPROC 416
#define CHECKFILESYS 417
#define CHECKFILE 418
#define CHECKDIR 419
#define CHECKHOST 420
#define CHECKSYSTEM 421
#define CHECKFIFO 422
#define CHECKPROGRAM 423
#define CHECKNET 424
#define THREADS 425
#define CHILDREN 426
#define METHOD 427
#define GET 428
#define HEAD 429
#define STATUS 430
#define ORIGIN 431
#define VERSIONOPT 432
#define READ 433
#define WRITE 434
#define OPERATION 435
#define SERVICETIME 436
#define DISK 437
#define RESOURCE 438
#define MEMORY 439
#define TOTALMEMORY 440
#define LOADAVG1 441
#define LOADAVG5 442
#define LOADAVG15 443
#define SWAP 444
#define MODE 445
#define ACTIVE 446
#define PASSIVE 447
#define MANUAL 448
#define ONREBOOT 449
#define NOSTART 450
#define LASTSTATE 451
#define CORE 452
#define CPU 453
#define TOTALCPU 454
#define CPUUSER 455
#define CPUSYSTEM 456
#define CPUWAIT 457
#define CPUNICE 458
#define CPUHARDIRQ 459
#define CPUSOFTIRQ 460
#define CPUSTEAL 461
#define CPUGUEST 462
#define CPUGUESTNICE 463
#define GROUP 464
#define REQUEST 465
#define DEPENDS 466
#define BASEDIR 467
#define SLOT 468
#define EVENTQUEUE 469
#define SECRET 470
#define HOSTHEADER 471
#define UID 472
#define EUID 473
#define GID 474
#define MMONIT 475
#define INSTANCE 476
#define USERNAME 477
#define PASSWORD 478
#define DATABASE 479
#define TIME 480
#define ATIME 481
#define CTIME 482
#define MTIME 483
#define CHANGED 484
#define MILLISECOND 485
#define SECOND 486
#define MINUTE 487
#define HOUR 488
#define DAY 489
#define MONTH 490
#define SSLV2 491
#define SSLV3 492
#define TLSV1 493
#define TLSV11 494
#define TLSV12 495
#define TLSV13 496
#define CERTMD5 497
#define AUTO 498
#define NOSSLV2 499
#define NOSSLV3 500
#define NOTLSV1 501
#define NOTLSV11 502
#define NOTLSV12 503
#define NOTLSV13 504
#define BYTE 505
#define KILOBYTE 506
#define MEGABYTE 507
#define GIGABYTE 508
#define INODE 509
#define SPACE 510
#define TFREE 511
#define PERMISSION 512
#define SIZE 513
#define MATCH 514
#define NOT 515
#define IGNORE 516
#define ACTION 517
#define UPTIME 518
#define RESPONSETIME 519
#define EXEC 520
#define UNMONITOR 521
#define PING 522
#define PING4 523
#define PING6 524
#define ICMP 525
#define ICMPECHO 526
#define NONEXIST 527
#define EXIST 528
#define INVALID 529
#define DATA 530
#define RECOVERED 531
#define PASSED 532
#define SUCCEEDED 533
#define URL 534
#define CONTENT 535
#define PID 536
#define PPID 537
#define FSFLAG 538
#define REGISTER 539
#define CREDENTIALS 540
#define URLOBJECT 541
#define ADDRESSOBJECT 542
#define TARGET 543
#define TIMESPEC 544
#define HTTPHEADER 545
#define MAXFORWARD 546
#define FIPS 547
#define SECURITY 548
#define ATTRIBUTE 549
#define FILEDESCRIPTORS 550
#define GREATER 551
#define GREATEROREQUAL 552
#define LESS 553
#define LESSOREQUAL 554
#define EQUAL 555
#define NOTEQUAL 556

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 325 "src/p.y"

        URL_T url;
        Address_T address;
        float real;
        int   number;
        char *string;

#line 1031 "src/y.tab.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_SRC_Y_TAB_H_INCLUDED  */



#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))

/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  69
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1972

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  308
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  251
/* YYNRULES -- Number of rules.  */
#define YYNRULES  838
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1626

#define YYUNDEFTOK  2
#define YYMAXUTOK   556


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   304,     2,
       2,     2,     2,     2,   305,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   306,     2,   307,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   302,     2,   303,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   379,   379,   380,   383,   384,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   416,   417,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   446,
     447,   450,   451,   452,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,   465,   466,   467,   470,
     471,   474,   475,   476,   477,   478,   479,   480,   481,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   496,   497,   500,   501,   502,   503,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   517,   518,
     521,   522,   523,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   536,   537,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     557,   558,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,   573,   576,   577,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
     593,   594,   597,   598,   601,   602,   603,   604,   605,   606,
     607,   608,   609,   610,   611,   612,   615,   619,   622,   628,
     638,   643,   646,   651,   656,   659,   662,   667,   673,   676,
     677,   680,   683,   686,   689,   692,   695,   698,   701,   704,
     707,   710,   713,   716,   719,   724,   729,   737,   740,   745,
     748,   752,   758,   763,   768,   776,   779,   780,   783,   789,
     790,   793,   796,   797,   798,   799,   802,   803,   808,   813,
     816,   819,   820,   823,   827,   831,   835,   839,   842,   846,
     849,   852,   855,   858,   861,   866,   872,   873,   876,   890,
     897,   906,   907,   910,   911,   914,   921,   924,   931,   934,
     941,   944,   951,   954,   961,   964,   971,   974,   985,   994,
    1001,  1016,  1017,  1020,  1029,  1040,  1041,  1044,  1047,  1050,
    1051,  1052,  1053,  1056,  1083,  1084,  1087,  1088,  1089,  1090,
    1091,  1092,  1093,  1094,  1095,  1099,  1105,  1111,  1117,  1124,
    1130,  1131,  1134,  1139,  1144,  1148,  1152,  1156,  1161,  1162,
    1165,  1166,  1169,  1172,  1177,  1186,  1189,  1197,  1201,  1205,
    1209,  1213,  1213,  1220,  1220,  1227,  1227,  1234,  1234,  1241,
    1248,  1249,  1252,  1258,  1261,  1266,  1269,  1272,  1279,  1288,
    1293,  1296,  1301,  1306,  1311,  1319,  1325,  1340,  1345,  1351,
    1359,  1362,  1367,  1370,  1376,  1379,  1384,  1385,  1388,  1389,
    1392,  1395,  1400,  1404,  1408,  1411,  1416,  1419,  1424,  1429,
    1434,  1437,  1442,  1452,  1462,  1463,  1466,  1467,  1468,  1469,
    1470,  1471,  1472,  1473,  1474,  1475,  1476,  1477,  1480,  1488,
    1498,  1499,  1502,  1503,  1504,  1505,  1506,  1507,  1510,  1517,
    1526,  1527,  1530,  1531,  1532,  1533,  1534,  1535,  1538,  1547,
    1553,  1559,  1565,  1574,  1580,  1586,  1594,  1595,  1598,  1599,
    1600,  1601,  1604,  1607,  1612,  1617,  1623,  1626,  1631,  1634,
    1638,  1643,  1644,  1647,  1648,  1651,  1656,  1659,  1662,  1665,
    1668,  1671,  1674,  1677,  1680,  1683,  1688,  1691,  1696,  1699,
    1702,  1705,  1708,  1711,  1714,  1717,  1721,  1724,  1728,  1731,
    1734,  1739,  1742,  1745,  1748,  1751,  1754,  1757,  1760,  1763,
    1768,  1771,  1774,  1777,  1782,  1790,  1800,  1801,  1804,  1807,
    1810,  1813,  1818,  1819,  1822,  1825,  1830,  1831,  1834,  1837,
    1842,  1843,  1846,  1849,  1852,  1865,  1871,  1879,  1880,  1883,
    1886,  1889,  1894,  1897,  1902,  1907,  1908,  1911,  1914,  1919,
    1920,  1923,  1926,  1929,  1930,  1931,  1932,  1933,  1934,  1937,
    1947,  1950,  1955,  1959,  1965,  1970,  1976,  1977,  1982,  1987,
    1988,  1991,  1996,  1997,  2000,  2003,  2006,  2009,  2013,  2017,
    2021,  2025,  2029,  2033,  2037,  2041,  2045,  2051,  2055,  2062,
    2068,  2074,  2082,  2086,  2092,  2097,  2107,  2112,  2117,  2120,
    2125,  2128,  2133,  2136,  2141,  2144,  2149,  2152,  2157,  2162,
    2167,  2173,  2181,  2187,  2188,  2191,  2195,  2198,  2202,  2207,
    2210,  2213,  2214,  2217,  2218,  2219,  2220,  2221,  2222,  2223,
    2224,  2225,  2226,  2227,  2228,  2229,  2230,  2231,  2232,  2233,
    2234,  2235,  2236,  2237,  2238,  2239,  2240,  2241,  2242,  2243,
    2244,  2245,  2246,  2249,  2250,  2253,  2254,  2257,  2258,  2259,
    2260,  2263,  2268,  2273,  2280,  2283,  2286,  2292,  2295,  2299,
    2304,  2311,  2314,  2315,  2318,  2321,  2328,  2337,  2343,  2344,
    2347,  2348,  2349,  2350,  2351,  2352,  2353,  2356,  2362,  2363,
    2366,  2367,  2368,  2369,  2372,  2377,  2384,  2391,  2397,  2403,
    2409,  2415,  2421,  2427,  2433,  2439,  2445,  2450,  2455,  2462,
    2467,  2472,  2477,  2484,  2489,  2496,  2503,  2510,  2530,  2531,
    2532,  2535,  2536,  2540,  2545,  2550,  2557,  2562,  2567,  2574,
    2575,  2578,  2579,  2580,  2581,  2584,  2591,  2599,  2600,  2601,
    2602,  2603,  2604,  2605,  2606,  2609,  2610,  2611,  2612,  2613,
    2614,  2617,  2618,  2619,  2621,  2622,  2624,  2627,  2630,  2638,
    2641,  2644,  2648,  2651,  2654,  2657,  2662,  2673,  2684,  2694,
    2706,  2707,  2712,  2719,  2720,  2725,  2732,  2735,  2738,  2741,
    2744,  2749,  2752,  2755,  2760,  2764,  2771,  2777,  2778,  2779,
    2782,  2789,  2796,  2803,  2812,  2819,  2826,  2833,  2842,  2849,
    2858,  2865,  2874,  2881,  2890,  2896,  2897,  2898,  2899,  2900,
    2903,  2908,  2915,  2924,  2932,  2939,  2947,  2955,  2962,  2968,
    2975,  2983,  2986,  2992,  2998,  3005,  3011,  3018,  3024,  3031,
    3034,  3039,  3045,  3053,  3059,  3067,  3075,  3081,  3088,  3092,
    3097,  3104,  3109,  3117,  3125,  3133,  3141,  3149,  3157,  3167,
    3175,  3183,  3191,  3199,  3207,  3217,  3220,  3221,  3222
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IF", "ELSE", "THEN", "FAILED", "SET",
  "LOGFILE", "FACILITY", "DAEMON", "SYSLOG", "MAILSERVER", "HTTPD",
  "ALLOW", "REJECTOPT", "ADDRESS", "INIT", "TERMINAL", "BATCH", "READONLY",
  "CLEARTEXT", "MD5HASH", "SHA1HASH", "CRYPT", "DELAY", "PEMFILE",
  "PEMKEY", "PEMCHAIN", "ENABLE", "DISABLE", "SSLTOKEN", "CIPHER",
  "CLIENTPEMFILE", "ALLOWSELFCERTIFICATION", "SELFSIGNED", "VERIFY",
  "CERTIFICATE", "CACERTIFICATEFILE", "CACERTIFICATEPATH", "VALID",
  "INTERFACE", "LINK", "PACKET", "BYTEIN", "BYTEOUT", "PACKETIN",
  "PACKETOUT", "SPEED", "SATURATION", "UPLOAD", "DOWNLOAD", "TOTAL", "UP",
  "DOWN", "IDFILE", "STATEFILE", "SEND", "EXPECT", "CYCLE", "COUNT",
  "REMINDER", "REPEAT", "LIMITS", "SENDEXPECTBUFFER", "EXPECTBUFFER",
  "FILECONTENTBUFFER", "HTTPCONTENTBUFFER", "PROGRAMOUTPUT",
  "NETWORKTIMEOUT", "PROGRAMTIMEOUT", "STARTTIMEOUT", "STOPTIMEOUT",
  "RESTARTTIMEOUT", "PIDFILE", "START", "STOP", "PATHTOK", "RSAKEY",
  "HOST", "HOSTNAME", "PORT", "IPV4", "IPV6", "TYPE", "UDP", "TCP",
  "TCPSSL", "PROTOCOL", "CONNECTION", "ALERT", "NOALERT", "MAILFORMAT",
  "UNIXSOCKET", "SIGNATURE", "TIMEOUT", "RETRY", "RESTART", "CHECKSUM",
  "EVERY", "NOTEVERY", "DEFAULT", "HTTP", "HTTPS", "APACHESTATUS", "FTP",
  "SMTP", "SMTPS", "POP", "POPS", "IMAP", "IMAPS", "CLAMAV", "NNTP",
  "NTP3", "MYSQL", "MYSQLS", "DNS", "WEBSOCKET", "MQTT", "SSH", "DWP",
  "LDAP2", "LDAP3", "RDATE", "RSYNC", "TNS", "PGSQL", "POSTFIXPOLICY",
  "SIP", "LMTP", "GPS", "RADIUS", "MEMCACHE", "REDIS", "MONGODB", "SIEVE",
  "SPAMASSASSIN", "FAIL2BAN", "STRING", "PATH", "MAILADDR", "MAILFROM",
  "MAILREPLYTO", "MAILSUBJECT", "MAILBODY", "SERVICENAME", "STRINGNAME",
  "NUMBER", "PERCENT", "LOGLIMIT", "CLOSELIMIT", "DNSLIMIT",
  "KEEPALIVELIMIT", "REPLYLIMIT", "REQUESTLIMIT", "STARTLIMIT",
  "WAITLIMIT", "GRACEFULLIMIT", "CLEANUPLIMIT", "REAL", "CHECKPROC",
  "CHECKFILESYS", "CHECKFILE", "CHECKDIR", "CHECKHOST", "CHECKSYSTEM",
  "CHECKFIFO", "CHECKPROGRAM", "CHECKNET", "THREADS", "CHILDREN", "METHOD",
  "GET", "HEAD", "STATUS", "ORIGIN", "VERSIONOPT", "READ", "WRITE",
  "OPERATION", "SERVICETIME", "DISK", "RESOURCE", "MEMORY", "TOTALMEMORY",
  "LOADAVG1", "LOADAVG5", "LOADAVG15", "SWAP", "MODE", "ACTIVE", "PASSIVE",
  "MANUAL", "ONREBOOT", "NOSTART", "LASTSTATE", "CORE", "CPU", "TOTALCPU",
  "CPUUSER", "CPUSYSTEM", "CPUWAIT", "CPUNICE", "CPUHARDIRQ", "CPUSOFTIRQ",
  "CPUSTEAL", "CPUGUEST", "CPUGUESTNICE", "GROUP", "REQUEST", "DEPENDS",
  "BASEDIR", "SLOT", "EVENTQUEUE", "SECRET", "HOSTHEADER", "UID", "EUID",
  "GID", "MMONIT", "INSTANCE", "USERNAME", "PASSWORD", "DATABASE", "TIME",
  "ATIME", "CTIME", "MTIME", "CHANGED", "MILLISECOND", "SECOND", "MINUTE",
  "HOUR", "DAY", "MONTH", "SSLV2", "SSLV3", "TLSV1", "TLSV11", "TLSV12",
  "TLSV13", "CERTMD5", "AUTO", "NOSSLV2", "NOSSLV3", "NOTLSV1", "NOTLSV11",
  "NOTLSV12", "NOTLSV13", "BYTE", "KILOBYTE", "MEGABYTE", "GIGABYTE",
  "INODE", "SPACE", "TFREE", "PERMISSION", "SIZE", "MATCH", "NOT",
  "IGNORE", "ACTION", "UPTIME", "RESPONSETIME", "EXEC", "UNMONITOR",
  "PING", "PING4", "PING6", "ICMP", "ICMPECHO", "NONEXIST", "EXIST",
  "INVALID", "DATA", "RECOVERED", "PASSED", "SUCCEEDED", "URL", "CONTENT",
  "PID", "PPID", "FSFLAG", "REGISTER", "CREDENTIALS", "URLOBJECT",
  "ADDRESSOBJECT", "TARGET", "TIMESPEC", "HTTPHEADER", "MAXFORWARD",
  "FIPS", "SECURITY", "ATTRIBUTE", "FILEDESCRIPTORS", "GREATER",
  "GREATEROREQUAL", "LESS", "LESSOREQUAL", "EQUAL", "NOTEQUAL", "'{'",
  "'}'", "':'", "'@'", "'['", "']'", "$accept", "cfgfile",
  "statement_list", "statement", "optproclist", "optproc", "optfilelist",
  "optfile", "optfilesyslist", "optfilesys", "optdirlist", "optdir",
  "opthostlist", "opthost", "optnetlist", "optnet", "optsystemlist",
  "optsystem", "optfifolist", "optfifo", "optprogramlist", "optprogram",
  "setalert", "setdaemon", "setterminal", "startdelay", "setinit",
  "setonreboot", "setexpectbuffer", "setlimits", "limitlist", "limit",
  "setfips", "setlog", "seteventqueue", "setidfile", "setstatefile",
  "setpid", "setmmonits", "mmonitlist", "mmonit", "mmonitoptlist",
  "mmonitopt", "credentials", "setssl", "ssl", "ssloptionlist",
  "ssloption", "sslexpire", "expireoperator", "sslchecksum",
  "checksumoperator", "sslversionlist", "sslversion", "certmd5",
  "setmailservers", "setmailformat", "mailserverlist", "mailserver",
  "mailserveroptlist", "mailserveropt", "sethttpd", "httpdlist",
  "httpdoption", "pemfile", "clientpemfile", "allowselfcert", "httpdport",
  "httpdsocket", "httpdsocketoptionlist", "httpdsocketoption", "sigenable",
  "sigdisable", "signature", "bindaddress", "allow", "$@1", "$@2", "$@3",
  "$@4", "allowuserlist", "allowuser", "readonly", "checkproc",
  "checkfile", "checkfilesys", "checkdir", "checkhost", "checknet",
  "checksystem", "checkfifo", "checkprogram", "start", "stop", "restart",
  "argumentlist", "useroptionlist", "argument", "useroption", "username",
  "password", "database", "hostname", "connection", "connectionoptlist",
  "connectionopt", "connectionurl", "connectionurloptlist",
  "connectionurlopt", "connectionunix", "connectionuxoptlist",
  "connectionuxopt", "icmp", "icmpoptlist", "icmpopt", "host", "port",
  "unixsocket", "ip", "type", "typeoptlist", "typeopt", "outgoing",
  "protocol", "sendexpect", "websocketlist", "websocket", "smtplist",
  "smtp", "mqttlist", "mqtt", "mysqllist", "mysql", "postgresqllist",
  "postgresql", "target", "maxforward", "siplist", "sip", "httplist",
  "http", "status", "method", "request", "responsesum", "hostheader",
  "httpheaderlist", "secret", "radiuslist", "radius", "apache_stat_list",
  "apache_stat", "exist", "pid", "ppid", "uptime", "responsetime",
  "icmpcount", "icmpsize", "icmptimeout", "icmpoutgoing", "stoptimeout",
  "starttimeout", "restarttimeout", "programtimeout", "nettimeout",
  "connectiontimeout", "retry", "actionrate", "urloption", "urloperator",
  "alert", "alertmail", "noalertmail", "eventoptionlist", "eventoption",
  "formatlist", "formatoptionlist", "formatoption", "every", "mode",
  "onreboot", "group", "depend", "dependlist", "dependant", "statusvalue",
  "resourceprocess", "resourceprocesslist", "resourceprocessopt",
  "resourcesystem", "resourcesystemlist", "resourcesystemopt",
  "resourcecpuproc", "resourcecpu", "resourcecpuid", "resourcemem",
  "resourcememproc", "resourceswap", "resourcethreads", "resourcechild",
  "resourceload", "resourceloadavg", "coremultiplier", "resourceread",
  "resourcewrite", "value", "timestamptype", "timestamp", "operator",
  "time", "totaltime", "currenttime", "repeat", "action", "action1",
  "action2", "rateXcycles", "rateXYcycles", "rate1", "rate2",
  "recovery_success", "recovery_failure", "checksum", "hashtype", "inode",
  "space", "read", "write", "servicetime", "fsflag", "unit", "permission",
  "programmatch", "match", "matchflagnot", "size", "uid", "euid",
  "secattr", "filedescriptorssystem", "filedescriptorsprocess",
  "filedescriptorsprocesstotal", "gid", "linkstatus", "linkspeed",
  "linksaturation", "upload", "download", "icmptype", "reminder", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   123,   125,    58,    64,    91,    93
};
# endif

#define YYPACT_NINF (-1350)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-751)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     459,    42,    -7,     0,    75,   166,   184,   200,   229,   242,
     249,   428,   459, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350,    59,   -44,   294, -1350, -1350,   142,   139,   332,   334,
     176,   288,   345,   370,   214,   393,   306,   243, -1350,   -43,
     -35,   445,   467,   475,   541, -1350,   483,   486,    76, -1350,
   -1350,   826,   105,  1047,  1328,  1529,  1567,  1630,  1328,  1659,
     569, -1350,   495,   525,   -19, -1350,  1236, -1350, -1350, -1350,
   -1350, -1350,   788, -1350, -1350,   936, -1350, -1350, -1350,   469,
     471, -1350,   243,   360,   346,   363,  1527,   622,   545,   555,
     114,   410,   591,   597,   605,   629,   456,   632,   634,   104,
     456,   456,   638,   456,   -62,   494,   571,   466,   646,   645,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350,   -41, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350,    96,  -149, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,   169, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
     233, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350,    29, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350,   161, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,   869,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
     -42, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350,   673,   794, -1350,   656,   716,   674,
   -1350,   747,     8,   703,   704,   752,   756,   601,   726, -1350,
     762,   772,   651, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350,    86,   431, -1350, -1350, -1350,
   -1350, -1350,   637,   649, -1350, -1350,    49, -1350,   708, -1350,
     935,   360,   647, -1350,   936,  1527, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350,   435, -1350,   799, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350,   535, -1350, -1350, -1350,   252,   654,   883,   644,
     644,   644,   644,   561,   644,   644, -1350, -1350, -1350,   644,
     644,   474,   678,   644,   860,    22,   644,  1584, -1350, -1350,
   -1350, -1350, -1350, -1350,   777, -1350, -1350,   606,   666, -1350,
     694,   941, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350,   645, -1350,   717,  1527,   622,   151, -1350, -1350,
   -1350, -1350,   356,   644,   678,   514,   644,   766, -1350,   514,
     773,   188,   644,   644,   644,  -131,   804,   912,   665,   258,
     286,   992,   706,   644,   644,   644,   781,   994,   644,   644,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
     644,  1627, -1350, -1350,   644, -1350, -1350, -1350,   644,   870,
     514, -1350,   911, -1350,   956,   197,   922, -1350, -1350, -1350,
   -1350, -1350, -1350,   924, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,   834,   955,
   -1350,   973,   975,   991,   829,  1001,  1004, -1350, -1350, -1350,
   -1350, -1350, -1350,  1125, -1350, -1350, -1350,   844,   857,   861,
     862,   863,   865,   866,   890,   894,   895, -1350, -1350,   897,
     899,   900,   902,   910,   918,   929,   930,   931, -1350, -1350,
   -1350, -1350, -1350, -1350,  1045,  1052, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350,   259,   624,  1123, -1350,  1177,  1090,    87,
      98,    -1, -1350, -1350, -1350,  1100,  1102,   296,   328,   357,
     954,   949,  1163, -1350,   644,  1097, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350,  1099,  1101,   203,   203,   644,   644,   203,
     203,   203,   203,   860,   860,   860,  1106,     3, -1350, -1350,
    1243,   969,  1163, -1350,   223, -1350,  1254, -1350,   644,  1116,
      41, -1350,  1120,    89, -1350,  1124,   317, -1350, -1350, -1350,
    1527,  1107, -1350, -1350, -1350,  1126,  1173,   860,   860,   860,
    1175,  1131, -1350, -1350,   735,  1133,   775,   779,   854,   224,
     232,   283,   860,   644,   444,   644,   203, -1350, -1350, -1350,
    1200, -1350, -1350, -1350,  1200,   860,   860,   860,  1138,  1139,
    1141,   644,   644,   860,   203,   203,   536, -1350,  1292,   203,
    1150,   860,  1160, -1350,   716,    11, -1350, -1350, -1350, -1350,
   -1350, -1350,  1161,  1162,  1164,  1165,  1166,  1125,   127, -1350,
   -1350,    28,  1167,  1168,  1172,  1174,  1176,  1013,  1022,  1178,
    1179, -1350,  1185,  1186,  1187,  1188,  1189,  1191,  1196,  1197,
    1199, -1350,  1083, -1350,  1123,   622, -1350,  1084, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350,   860,   860,   860,   860,
     860,   860, -1350,   953,  1201, -1350,   463,  1202,  1261, -1350,
   -1350, -1350, -1350,   788,   788,   546,   551,   436,   602,  1206,
    1208,  1316,  1317,  1318,   852, -1350,  1266,   500, -1350, -1350,
     463,    72,  1210,   500,   203,  1096, -1350,  1130, -1350,  1132,
   -1350,  1413,  1123,   860,   -13,  1368,  1369,  1370,   860,   788,
     860,   860,   852,   860,   860, -1350, -1350, -1350, -1350,  1198,
     788,  1203,   788,  1146,  1153,  1380,   554,    72,  1237,   203,
     739,    77,    77,    77,  1121, -1350,    77,    77,    77, -1350,
    1386,  1388,  1389,  1246,    -2,    14,  1249,  1251,  1396,   746,
     751,    72,  1256,   500,  1257,   860,  1402,   860,  1108,  1108,
   -1350,  1270,  1166,  1166,  1166,  1125, -1350,  1166, -1350, -1350,
   -1350, -1350,   464,   581,  1263, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350,  1306,   788,   788,
     788,   788,   867,   877,   880,   889,   896, -1350,   622, -1350,
   -1350,  1407,  1408,  1409,  1412,  1415,  1416,   133,   860,   860,
   -1350,   369,  1283,  1284,   884,  1770,  1276,  1281,   644, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350,  1428,   860,  1430,  1209,
    1209,  1259,   788,  1262,   788, -1350, -1350, -1350, -1350, -1350,
   -1350,   500,   500,   500, -1350, -1350, -1350, -1350, -1350,   860,
   -1350, -1350, -1350, -1350, -1350,   456, -1350, -1350,  1439,   133,
     369,  1441,  1445,   860,  1439, -1350, -1350, -1350, -1350,  1123,
     622,  1446,  1313,  1448,   500,   500,   500,  1449,   860,  1458,
    1459,   860,  1460,  1462,   860,  1209,   860,  1209,   860,   860,
     500,    72,  1319,  1464,   860,   771,   860,   860,  1346,  1338,
    1339,  1340, -1350, -1350, -1350, -1350, -1350,  1484,  1485,  1488,
   -1350,    77,  1489,  1492,  1494,    77,   500,   500,   500,   860,
    1209,  1209,  1209,  1209,   236,   262,   500, -1350, -1350, -1350,
   -1350,  1495,   860,  1439, -1350,  1498,   500,  1499,  1366,  1367,
   -1350,  1166,  1166,  1166, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350,   500,   500,   500,
     500,   500,   500,    25,   514, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350,  1502,  1504,  1505,  1373, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350,  1509, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
    1073, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350,   -32, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350,  1285, -1350,  1372,   500,  1510,
     342, -1350, -1350, -1350, -1350,  1209, -1350,  1209, -1350, -1350,
    1439,  1516,   506,    53, -1350,  1519,  1523,   500,   500,  1524,
   -1350,   622, -1350,   500,   860,   500,  1439, -1350, -1350,   500,
    1525,   500,   500,  1526,   500,   500,  1536,   860,  1551,   860,
    1552,  1553, -1350,  1554,   860,   500,  1555,   860,   860,  1556,
    1559, -1350, -1350,  1334, -1350,   500,   500,   500,  1561,   500,
     500,   500,  1572,  1439,  1574,  1439,  1575,   860,   860,   860,
     860,   425,   516,   564,   576,  1439,   500,  1577, -1350,   500,
   -1350,   500, -1350, -1350,  1439,  1439,  1439,  1439,  1439,  1439,
    1288,  1447,   500,   500,   500, -1350,   500,  1235,   -34,   -34,
    1450,   644,   644,   644,   644,   644,   644,   644,   644,   644,
     644, -1350, -1350,  1073, -1350,   906,   906,   -25,   -25,  1452,
    1453,  1454,  1461,   -32, -1350,   906,   754,   134,  1374, -1350,
     905,  1439,   500, -1350, -1350, -1350, -1350, -1350,   500,  1501,
      13, -1350,   710, -1350, -1350,   500,   500,  1574,  1439,   500,
   -1350,  1439,  1582,  1439, -1350, -1350,   500, -1350, -1350,   500,
   -1350, -1350,   500,  1589,   500,  1593,   500,   500,   500,  1598,
    1439,   500,  1605,  1606,   500,   500, -1350,  1439,  1439,  1439,
     500,  1574,  1574,  1574,   500, -1350,    93, -1350, -1350,   500,
    1607,  1608,  1609,  1610,   815, -1350, -1350, -1350,   860,   815,
     860,   815,   860,   815,   860, -1350,  1439,   500,  1439, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350,  1469, -1350,  1439,
    1439,  1439,  1439, -1350, -1350, -1350,  1479,   986,   644,  1023,
    1482, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350,  1475,  1476,  1483,  1487,  1491,  1493,  1496,  1497,  1500,
    1503, -1350, -1350, -1350, -1350,  1538, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350,  1507, -1350, -1350,
   -1350, -1350,   270,  1506, -1350, -1350, -1350,  1508, -1350, -1350,
   -1350, -1350, -1350,  1439,  1439,    23, -1350,   860,   860,   860,
    1574,  1574, -1350, -1350,  1439, -1350,   500, -1350,  1439,  1439,
    1439,   500,  1439,   500,  1439,  1439,  1439,   500, -1350,  1439,
     500,   500,  1439,  1439, -1350, -1350, -1350,  1439, -1350, -1350,
   -1350,  1574,  1621, -1350,  1439,   500,   500,   500,   500,   860,
    1632,   860,  1635,   860,  1644,   860,  1648, -1350,  1439, -1350,
    1421, -1350, -1350, -1350, -1350, -1350, -1350, -1350,  1511, -1350,
   -1350, -1350,  -150,  1512,  1514,  1520,  1528,  1530,  1531,  1532,
    1533,  1535,  1540,    15, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350,  1597, -1350, -1350,  1655,  1660,  1663, -1350, -1350,
   -1350,  1439, -1350, -1350, -1350,  1439, -1350,  1439, -1350, -1350,
   -1350,  1439, -1350,  1439,  1439, -1350, -1350, -1350, -1350,   860,
   -1350,  1439,  1439,  1439,  1439,  1667,   500,  1668,   500,  1669,
     500,  1685,   500, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,  1108,  1108,
    1558, -1350,   500,   500,   500, -1350, -1350, -1350, -1350, -1350,
   -1350,  1686, -1350, -1350, -1350, -1350,   500,  1439,   500,  1439,
     500,  1439,   500,  1439,  1560,  1562, -1350, -1350, -1350, -1350,
     500,  1439, -1350,  1439, -1350,  1439, -1350,  1439, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     3,     4,     6,     8,     9,    20,    22,    19,
      21,    23,    10,    11,    17,    18,    16,    12,     7,    13,
      14,    15,    33,    59,    79,   101,   118,   133,   150,   165,
     182,     0,     0,     0,   304,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   225,   633,
       0,     0,     0,     0,     0,   366,     0,     0,     0,     1,
       5,    24,    25,    26,    27,    28,    32,    29,    30,    31,
     227,   226,   201,   295,   586,   291,   303,   200,   251,   232,
     233,   209,   785,   234,   599,     0,   204,   205,   206,     0,
       0,   239,   235,   246,     0,     0,     0,   836,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      34,    35,    36,    37,    48,    49,    50,    38,    39,    40,
      47,    51,    52,   633,   598,    53,    54,    55,    56,    57,
      58,    41,    42,    43,    44,    45,    46,   801,   801,    60,
      61,    62,    63,    64,    66,    68,    67,    75,    76,    77,
      78,    65,    72,    69,    74,    73,    70,    71,     0,    80,
      81,    82,    83,    84,    85,    87,    86,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,    88,    89,    90,
       0,   102,   103,   104,   105,   106,   108,   110,   109,   114,
     115,   116,   117,   107,   111,   112,   113,     0,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,     0,   134,   135,   136,   137,   143,   147,   144,
     145,   146,   148,   149,   138,   139,   140,   141,   142,     0,
     151,   152,   153,   154,   163,   155,   156,   157,   158,   159,
     160,   161,   162,   164,   166,   167,   168,   169,   170,   172,
     174,   173,   178,   179,   180,   181,   171,   175,   176,   177,
       0,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,     0,     0,   199,     0,   293,     0,
     292,   390,     0,     0,     0,     0,     0,   249,     0,   317,
       0,     0,     0,   306,   305,   307,   308,   309,   313,   314,
     332,   333,   310,   311,   312,     0,     0,   786,   787,   788,
     789,   207,     0,     0,   639,   640,     0,   635,   229,   231,
     238,   246,     0,   236,     0,     0,   617,   604,   605,   619,
     620,   627,   625,   607,   629,   606,   628,   624,   631,   613,
     615,   630,   621,   626,   603,   632,   610,   614,   618,   611,
     616,   609,   608,   622,   623,   612,     0,   601,     0,   196,
     355,   356,   357,   358,   361,   360,   359,   362,   363,   367,
     380,   381,   584,   376,   364,   365,   442,     0,     0,   717,
     717,   717,   717,     0,   717,   717,   698,   699,   700,   717,
     717,     0,     0,   717,   750,   442,   717,   750,   658,   660,
     661,   662,   663,   664,   701,   665,   666,   580,   578,   600,
     582,     0,   642,   643,   644,   645,   646,   647,   648,   649,
     650,   654,   651,   652,     0,     0,   836,   767,   711,   712,
     713,   714,   767,   717,   802,     0,   717,     0,   802,     0,
       0,     0,   717,   717,   717,     0,   717,   717,     0,   442,
     442,     0,     0,   717,   717,   717,     0,     0,   717,   717,
     686,   677,   678,   679,   680,   681,   682,   683,   684,   685,
     717,   750,   668,   673,   717,   671,   672,   670,   717,     0,
       0,   228,     0,   295,     0,     0,     0,   275,   277,   279,
     281,   283,   285,     0,   287,   276,   278,   280,   282,   284,
     286,   299,   300,   301,   302,   296,   297,   298,     0,     0,
     289,     0,     0,     0,   349,   337,     0,   334,   315,   329,
     331,   251,   316,   353,   320,   328,   330,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   248,   252,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   208,   210,
     637,   638,   290,   636,     0,     0,   240,   242,   243,   244,
     245,   237,   247,     0,     0,   633,   602,   837,     0,     0,
       0,   584,   377,   378,   368,     0,     0,     0,     0,     0,
       0,     0,     0,   420,   717,     0,   724,   718,   719,   720,
     721,   722,   723,     0,     0,     0,     0,   717,   717,     0,
       0,     0,     0,   750,   750,   750,     0,     0,   751,   752,
       0,     0,     0,   420,     0,   659,     0,   702,   717,     0,
     580,   370,     0,   578,   372,     0,   582,   374,   641,   653,
       0,     0,   595,   768,   769,     0,     0,   750,   750,   750,
       0,     0,   593,   594,     0,     0,     0,     0,     0,     0,
       0,     0,   750,   717,     0,   717,     0,   436,   436,   436,
       0,   436,   436,   436,     0,   750,   750,   750,     0,     0,
       0,   717,   717,   750,     0,     0,     0,   669,     0,     0,
       0,   750,     0,   202,   294,   271,   387,   386,   388,   288,
     587,   391,   338,   339,   340,     0,     0,   353,     0,   354,
     318,   319,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   273,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   230,     0,   634,   633,   836,   838,     0,   382,   384,
     383,   385,   379,   369,   443,   445,   750,   750,   750,   750,
     750,   750,   410,     0,     0,   394,   750,     0,     0,   695,
     696,   710,   709,   785,   785,     0,     0,   785,   785,     0,
       0,     0,     0,     0,   725,   748,     0,     0,   410,   394,
     750,   710,     0,     0,     0,     0,   371,     0,   373,     0,
     375,     0,   633,   750,   750,     0,     0,     0,   750,   785,
     750,   750,   725,   750,   750,   796,   795,   800,   799,   710,
     785,   710,   785,   710,     0,     0,     0,   710,     0,     0,
     785,   750,   750,   750,     0,   436,   750,   750,   750,   436,
       0,     0,     0,     0,   785,   785,     0,     0,     0,   785,
     785,   710,     0,     0,     0,   750,     0,   750,   271,   271,
     272,     0,     0,     0,     0,   353,   352,   342,   350,   336,
     250,   327,     0,     0,     0,   321,   259,   261,   260,   258,
     262,   255,   256,   253,   254,   263,   264,   257,   785,   785,
     785,   785,     0,     0,     0,     0,     0,   241,   836,   197,
     585,     0,     0,     0,     0,     0,     0,   750,   750,   750,
     444,   750,     0,     0,     0,     0,     0,     0,   717,   421,
     422,   423,   424,   426,   425,   427,     0,   750,     0,   734,
     734,   710,   785,   710,   785,   690,   689,   692,   691,   674,
     675,     0,     0,     0,   726,   727,   728,   729,   730,   750,
     749,   743,   744,   739,   742,     0,   745,   746,   756,   750,
     750,     0,     0,   750,   756,   697,   581,   579,   583,   633,
     836,     0,     0,     0,     0,     0,     0,     0,   750,     0,
       0,   750,     0,     0,   750,   734,   750,   734,   750,   750,
       0,   710,     0,     0,   750,   785,   750,   750,     0,     0,
       0,     0,   437,   438,   439,   440,   441,     0,     0,     0,
     835,   750,     0,     0,     0,   750,     0,     0,     0,   750,
     734,   734,   734,   734,   785,   785,     0,   688,   687,   694,
     693,     0,   750,   756,   676,     0,     0,     0,     0,     0,
     268,   344,   346,   348,   335,   351,   322,   324,   323,   325,
     326,   274,   211,   212,   213,   214,   215,   216,   217,   218,
     221,   222,   219,   220,   223,   224,   198,     0,     0,     0,
       0,     0,     0,     0,     0,   415,   417,   416,   411,   413,
     414,   412,     0,     0,     0,     0,   446,   447,   405,   407,
     406,   395,   396,   397,   403,   398,   399,   402,   401,   404,
     400,     0,   494,   495,   450,   448,   451,   458,   529,   529,
       0,   462,   502,   502,   479,   480,   466,   467,   457,   476,
     477,   510,   510,   459,     0,   506,   491,   460,   468,   469,
     483,   485,   492,   517,   481,   525,   470,   463,   549,   471,
     484,   472,   486,   490,   461,     0,   589,     0,     0,     0,
       0,   735,   703,   706,   705,   734,   708,   734,   569,   570,
     756,     0,   736,     0,   568,     0,     0,     0,     0,     0,
     657,   836,   596,     0,   750,     0,   756,   804,   716,     0,
       0,     0,     0,     0,     0,     0,     0,   750,     0,   750,
       0,     0,   784,     0,   750,     0,     0,   750,   750,     0,
       0,   577,   574,     0,   575,     0,     0,     0,     0,     0,
       0,     0,     0,   756,   761,   756,     0,   750,   750,   750,
     750,     0,     0,     0,     0,   756,     0,     0,   667,     0,
     656,     0,   269,   270,   756,   756,   756,   756,   756,   756,
     266,     0,     0,     0,     0,   455,     0,   449,   464,   465,
       0,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   554,   555,   456,   552,   488,   489,   474,   475,     0,
       0,     0,     0,   493,   496,   473,   478,   487,   482,   588,
       0,   756,     0,   591,   590,   704,   707,   567,     0,     0,
     736,   740,     0,   747,   757,     0,     0,   761,   756,     0,
     597,   756,     0,   756,   791,   766,     0,   794,   793,     0,
     798,   797,     0,     0,     0,     0,     0,     0,     0,     0,
     756,     0,     0,     0,     0,     0,   576,   756,   756,   756,
       0,   761,   761,   761,     0,   818,     0,   820,   819,     0,
       0,     0,     0,     0,     0,   731,   732,   733,   750,     0,
     750,     0,   750,     0,   750,   821,   756,     0,   756,   792,
     805,   806,   807,   808,   816,   817,   267,     0,   592,   756,
     756,   756,   756,   453,   454,   452,     0,     0,   717,     0,
       0,   546,   531,   532,   530,   535,   536,   533,   534,   537,
     556,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   553,   504,   505,   503,     0,   512,   513,   511,   500,
     498,   501,   499,   497,   508,   509,   507,     0,   519,   520,
     521,   518,     0,     0,   527,   528,   526,     0,   551,   550,
     572,   573,   418,   756,   756,     0,   741,   753,   753,   753,
     761,   761,   419,   813,   756,   790,     0,   764,   756,   756,
     756,     0,   756,     0,   756,   756,   756,     0,   770,   756,
       0,     0,   756,   756,   429,   430,   431,   756,   433,   434,
     435,   761,     0,   762,   756,     0,     0,     0,     0,   750,
       0,   750,     0,   750,     0,   750,     0,   811,   756,   655,
       0,   408,   809,   810,   392,   544,   540,   541,     0,   543,
     542,   545,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   271,   389,   523,   522,   524,   548,   815,
     571,   737,     0,   754,   755,     0,     0,     0,   409,   393,
     814,   756,   803,   715,   779,   756,   781,   756,   782,   783,
     772,   756,   771,   756,   756,   775,   774,   428,   432,   753,
     822,   756,   756,   756,   756,     0,     0,     0,     0,     0,
       0,     0,     0,   812,   265,   539,   547,   538,   557,   558,
     559,   560,   561,   562,   563,   564,   565,   566,   271,   271,
       0,   738,     0,     0,     0,   765,   778,   780,   773,   777,
     776,     0,   826,   823,   832,   829,     0,   756,     0,   756,
       0,   756,     0,   756,     0,     0,   514,   758,   759,   760,
       0,   756,   827,   756,   824,   756,   833,   756,   830,   515,
     516,   763,   828,   825,   834,   831
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1350, -1350, -1350,  1680, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
    1596, -1350, -1350,  1359, -1350,   -83,  1170, -1350,  -811, -1350,
    -320,  -846, -1350,  -339,  -338, -1350, -1350, -1350,  1619,  1204,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
     227,  -681,  -651, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350, -1350,  1113,  1782,  1837,  -104,  -404,  -384,  -555,  -481,
    -428, -1350, -1350,  1629,   919, -1350,  1634,   926, -1350, -1350,
    1079, -1350, -1350,   -47, -1350,  -328,  1085,  1300, -1350,  -802,
   -1350, -1350, -1350,  -781,  -726, -1350,   449,   611, -1350, -1350,
   -1350,   596, -1350, -1350, -1350, -1350, -1350, -1350, -1350,   616,
   -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350,   465,   806, -1350, -1350,  1649,  -640, -1350, -1350, -1350,
   -1350,  1088,  1093,  1091,  1145, -1350,  -269,  -256,  1845,  -634,
    -437,  1853,  1738, -1350,  -318,  -351,  -139,  1397,  -296,  1861,
    1869,  1877,  1885,  1893, -1350,  1303, -1350, -1350, -1350,  1330,
   -1350, -1350,  1260, -1350, -1350, -1350, -1350, -1350, -1350, -1350,
   -1350,  -218, -1350, -1350, -1350, -1350,   672,  -237,   279,  -395,
     948,  -623,  -344,   477, -1135,  -200, -1255,  -983,  -899,  -417,
   -1349,   -18,  -824, -1350,  1301, -1350, -1350, -1350, -1350, -1350,
   -1350,   718,   220, -1350, -1350,  1615, -1350,   856, -1350, -1350,
   -1350, -1350, -1350,   940, -1350, -1350, -1350, -1350, -1350,  1080,
    -435
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    11,    12,    13,    71,   130,    72,   159,    73,   179,
      74,   201,    75,   218,    76,   233,    77,   250,    78,   264,
      79,   281,    14,    15,    16,   296,    17,    18,    19,    20,
     326,   569,    21,    22,    23,    24,    25,    26,    27,   102,
     103,   340,   576,   343,    28,   521,   325,   558,  1076,  1367,
     522,   861,   887,   523,   524,    29,    30,    84,    85,   298,
     525,    31,    86,   314,   315,   316,   317,   318,   319,   721,
     875,   320,   321,   322,   323,   324,   716,   862,   863,   864,
     867,   868,   720,    32,    33,    34,    35,    36,    37,    38,
      39,    40,   131,   132,   133,   392,   591,   393,   593,   526,
     527,  1420,   530,   134,   911,  1091,   135,   907,  1078,   136,
     766,   919,   224,   831,  1002,   602,   765,   603,  1092,   920,
    1247,  1375,  1094,   921,   922,  1273,  1274,  1265,  1404,  1275,
    1416,  1267,  1408,  1276,  1421,  1424,  1425,  1277,  1426,  1248,
    1384,  1385,  1386,  1387,  1388,  1389,  1502,  1428,  1278,  1429,
    1263,  1264,   137,   138,   139,   140,   923,  1003,  1004,  1005,
    1006,   644,   641,   647,   594,   301,   924,   925,   141,  1081,
     664,   142,   143,   144,   376,   377,   107,   336,   337,   145,
     146,   147,   148,   149,   442,   443,   292,   150,   417,   418,
     262,   491,   492,   419,   493,   494,   495,   420,   496,   421,
     422,   423,   424,   638,   425,   426,   773,   456,   171,   613,
     949,  1348,  1152,  1291,   957,   958,  1294,   628,   629,   630,
    1525,  1164,  1337,   172,   656,   191,   192,   193,   194,   195,
     196,   331,   173,   293,   174,   457,   175,   151,   152,   153,
     263,   154,   155,   156,   244,   245,   246,   247,   248,   835,
     379
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     636,   579,   580,   313,   446,   614,   615,   616,   592,   619,
     620,   652,  1038,  1039,   621,   622,   427,   428,   626,   430,
     578,   634,   667,   640,   643,   586,   646,   584,  1293,   531,
     532,   497,   533,   858,   859,   469,   752,  1578,  1579,   108,
     573,  1020,   109,   592,   592,   972,   592,  1269,   871,   104,
      41,   104,    42,  1405,    43,    44,  1292,  1022,   661,    45,
      46,   665,   785,   702,  1376,  1240,   869,   669,   670,   671,
      80,   674,   676,    47,   698,  1289,   299,  -750,   688,   689,
     690,  1473,  1521,   694,   695,   752,   431,   632,   752,  1526,
    1527,   752,   117,   998,   588,   696,  1472,    48,    49,   699,
    1089,   595,   447,   700,    82,    50,   398,    51,   157,  1093,
     396,   458,   547,   548,   549,   596,    52,   118,   550,   551,
      83,   552,   553,   705,   554,   555,   657,   651,   951,   952,
    1095,   459,    53,   498,    54,   627,   639,   999,  1377,    60,
    1566,  1378,   632,   953,  1270,  1271,    61,   534,   535,  1089,
     954,   786,   672,   547,   548,   549,   397,  1567,  1093,   550,
     551,    87,   552,   553,   307,   554,   555,   471,   951,   952,
    1073,  1522,  1000,   653,   654,   461,  1379,   398,  1272,  1095,
     120,   121,  1380,   953,   642,  1096,  1045,   499,   505,   506,
     954,   332,   333,   334,   335,    53,   122,   505,   506,    81,
    1591,  1293,   123,   472,   124,   125,   781,   782,   783,   767,
     473,   474,   475,   476,  1044,   659,   589,   105,   590,   444,
     627,    62,   775,   776,   110,   627,   748,   432,   916,   917,
     589,   659,   590,   586,  1096,   749,    55,   750,   500,   461,
     805,   806,   807,   794,   398,   872,   751,   873,   327,   328,
     329,   330,   398,   382,   383,   825,    56,   577,   589,   106,
     590,   445,    57,   556,   327,   328,   329,   330,   840,   841,
     842,  1097,  1381,   497,   399,   400,   848,  1100,   826,  1221,
     829,   627,   401,   402,   856,   874,   403,   573,   404,   405,
     406,   407,   408,   197,   214,   126,   846,   847,   277,   127,
     586,   631,   409,   410,   556,  1223,   589,   470,   590,   398,
     899,   860,    63,   536,   128,   860,   129,   398,   955,   956,
    1097,   448,   449,   450,   451,   452,  1100,  1607,  1608,  1609,
      64,   595,   801,   411,    58,  1001,   706,   595,   707,   901,
     902,   903,   904,   905,   906,   596,    65,   462,   463,   926,
     464,   771,   572,   213,   453,  1621,   454,   276,   955,   956,
    1045,  1045,  1045,   772,   412,   595,   158,   413,   597,   414,
     599,   791,   819,   961,   962,    66,   455,   414,   653,   654,
     821,   398,   415,   772,   772,  1085,   971,   973,    67,   557,
     477,   977,   772,   979,   980,    68,   982,   983,   465,   416,
     307,   332,   333,   334,   335,   597,  1073,   599,   655,  1515,
     993,  1516,   645,  1074,  1007,  1008,  1009,   951,   952,  1012,
    1013,  1014,  1422,   466,   467,  1423,   912,   913,    69,   412,
     870,   823,   953,    83,  1031,   756,    92,  1283,  1035,   954,
    1037,    88,   414,   772,   757,   655,   745,  1293,  1293,  1293,
     586,  1086,  1087,   914,  1523,  1523,  1523,   915,   448,   449,
     450,   451,   468,  1066,   916,   917,     1,   758,    96,   597,
     598,   599,    89,  1442,    90,  1293,   759,   346,    91,   347,
     348,   349,   350,   351,   352,    93,   327,   328,   329,   330,
    1082,  1083,  1084,   412,  1101,   559,   760,   560,   561,   562,
     563,   564,   565,   566,   567,   761,   414,  1468,  1469,  1470,
    1149,    94,   327,   328,   329,   330,    95,   627,    99,   100,
     912,   913,   111,  1147,   353,   677,   678,   679,   680,   101,
     354,   600,  1161,   355,   589,  1172,   590,   600,  1524,  1524,
    1524,   437,  1165,  1166,   112,   601,  1169,   914,  1051,   384,
     385,   915,   113,   681,   682,   683,   684,   114,   916,   917,
     115,  1180,   743,   116,  1183,   631,  1523,  1186,  1289,  1188,
     295,  1190,  1191,  1344,  1193,   951,   952,  1196,   294,  1199,
    1200,   448,   449,   450,   451,   935,  1153,  1077,    97,    98,
     953,  1090,   827,   964,  1208,   390,   391,   954,  1212,  1350,
    1352,  1354,  1216,  1046,   772,   898,   297,   955,   956,   338,
     356,   627,  1047,   657,   658,  1227,  1528,  1529,   357,   339,
       2,     3,     4,     5,     6,     7,     8,     9,    10,  1261,
     588,   832,   833,   918,   836,   837,   838,  1241,  1079,  1077,
    1090,  1187,  1098,  1189,   342,   390,   391,  1548,   344,  1074,
    1524,  1080,   358,  1033,   359,  1099,   360,  1345,  1346,  1347,
     361,   438,   439,   970,  1349,   345,   346,  1580,   347,   348,
     349,   350,   351,   352,   390,   391,  1217,  1218,  1219,  1220,
     545,   546,  1262,   378,   851,   380,   327,   328,   329,   330,
    1079,  1098,   362,   363,   931,   381,   772,   364,   365,   933,
     366,   639,   991,  1080,  1099,   367,   772,   368,   369,   370,
     371,   772,  1351,   353,   772,   372,   373,   374,   375,   354,
    1048,  1479,   355,   589,  1353,   590,  1481,   918,  1483,  1049,
    1485,   386,  1604,  1605,   568,   752,  1300,   387,   585,   617,
     618,  1158,  1159,  1160,   388,   390,   391,   307,  1345,  1346,
    1347,   937,   589,   504,   590,   623,   624,  1302,  1290,   686,
     687,   642,   434,   435,   436,   955,   956,  1382,  1382,   389,
    1313,   394,  1315,   395,  1176,  1177,  1178,  1319,   592,   429,
    1322,  1323,  1261,   433,  1402,  1402,  1406,  1406,  1011,   645,
    1192,   441,  1015,   440,  1414,  1418,  1345,  1346,  1347,   356,
    1340,  1341,  1342,  1343,   503,   390,   391,   357,  1345,  1346,
    1347,  1285,   501,  1286,   662,   663,  1213,  1214,  1215,   502,
    1383,  1383,   528,   589,  1075,   590,  1225,   529,  1088,   119,
    1171,   691,   692,   390,   391,  1262,  1230,  1403,  1403,  1407,
    1407,   358,   537,   359,   538,   360,   539,  1415,  1419,   361,
     540,  1162,   327,   328,   329,   330,  1391,  1392,  1393,  1394,
    1395,  1396,  1397,  1398,  1399,  1400,   542,  1234,  1235,  1236,
    1237,  1238,  1239,   606,   810,   811,  1075,  1088,   163,   183,
     205,   362,   363,   589,   268,   590,   364,   365,   996,   366,
     448,   449,   450,   451,   367,  1027,   368,   369,   370,   371,
    1029,   120,   121,   541,   372,   373,   374,   375,  1373,  1374,
     543,   589,   544,   590,   813,   814,    53,   122,   815,   816,
    1197,   574,   657,   123,   570,   124,   125,   744,   176,   198,
     215,  1480,   582,  1482,   278,  1484,   571,  1486,   505,   506,
     607,   608,   609,   610,   611,   612,  1170,   587,  1281,   604,
    1284,   625,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   307,  1297,  1298,  1104,
    1105,  1106,   504,  1301,   637,  1303,   505,   506,  1417,  1305,
     605,  1307,  1308,  1498,  1310,  1311,  1437,  1438,  1439,   327,
     328,   329,   330,   817,   818,  1320,   327,   328,   329,   330,
     648,   327,   328,   329,   330,  1327,  1328,  1329,   627,  1331,
    1332,  1333,   177,   199,   216,  1228,   126,   398,   279,   650,
     127,   327,   328,   329,   330,   666,  1356,   881,   882,  1358,
     575,  1359,   668,   606,   685,   128,   693,   129,   327,   328,
     329,   330,  1369,  1370,  1371,   701,  1372,  1345,  1346,  1347,
     178,   883,   884,   478,   705,   406,   407,   408,   479,   703,
     673,   708,  1555,   709,  1557,   710,  1559,   480,  1561,   481,
     482,   483,   484,   485,   486,   487,   488,   489,   332,   333,
     334,   335,  1433,   944,   945,   946,   947,   948,  1434,  1041,
    1042,  1043,   908,   909,   711,  1440,  1441,  1056,  1057,  1444,
     607,   608,   609,   610,   611,   612,  1448,  1058,  1059,  1449,
    1060,  1061,  1450,   712,  1452,   713,  1454,  1455,  1456,  1062,
    1063,  1459,   120,   121,  1462,  1463,  1064,  1065,   505,   506,
    1467,   714,   413,   715,  1471,  1430,  1431,    53,   122,  1474,
    -341,   606,  1287,   717,   123,   719,   124,   125,   722,   346,
    1250,   347,   348,   349,   350,   351,   352,  1488,  1304,  1496,
    1497,   723,  1499,  1500,   490,   724,   725,   726,   675,   727,
     728,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   160,   180,   202,   219,   234,
     251,   265,   282,   741,   729,  1335,   353,  1338,   730,   731,
     742,   732,   354,   733,   734,   355,   735,  1355,   607,   608,
     609,   610,   611,   612,   736,   104,  1360,  1361,  1362,  1363,
    1364,  1365,   737,  1251,  1252,  1253,  1254,  1255,  1256,  1257,
    1258,  1259,  1260,   738,   739,   740,   746,   126,   747,   754,
     762,   127,   755,   763,   764,   768,  1531,   769,   787,   770,
     302,  1535,   303,  1537,   784,   788,   128,  1541,   129,   793,
    1543,  1544,   304,  1432,   795,   305,   306,   307,   797,   308,
     309,   804,   799,   808,   803,  1551,  1552,  1553,  1554,   809,
    1443,   812,   356,  1445,   834,  1447,   843,   844,   774,   845,
     357,   777,   778,   779,   780,   505,   506,   853,   855,   857,
    -343,  -345,  1458,  -347,   865,   866,   792,   876,   877,  1464,
    1465,  1466,   878,   879,   897,   900,   880,   310,   885,   886,
     928,   941,   942,   943,   358,   950,   359,   966,   360,   311,
     312,   200,   361,   888,   889,   890,   891,   892,  1487,   893,
    1489,   820,   822,   824,   894,   895,   828,   896,   830,   910,
     927,  1491,  1492,  1493,  1494,   939,  1597,   940,  1599,   963,
    1601,   967,  1603,   968,   362,   363,   849,   850,   852,   364,
     365,   854,   366,   974,   975,   976,   988,   367,   984,   368,
     369,   370,   371,   986,   989,   990,   994,   372,   373,   374,
     375,  1016,  1010,  1017,  1018,  1019,  1611,  1024,  1613,  1025,
    1615,  1026,  1617,   120,   121,  1032,  1034,  1036,   860,  1040,
     802,  1050,  1067,  1068,  1069,  1519,  1520,  1070,    53,   122,
    1071,  1072,  1102,  1103,  1145,   123,  1530,   124,   125,  1146,
    1532,  1533,  1534,  1148,  1536,  1150,  1538,  1539,  1540,  1154,
    1151,  1542,  1156,  1163,  1545,  1546,  1167,   932,   934,  1547,
    1168,  1173,  1174,  1175,  1179,   346,  1550,   347,   348,   349,
     350,   351,   352,  1181,  1182,  1184,   965,  1185,  1194,  1195,
    1563,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,  1201,  1202,  1203,  1204,  1205,
    1206,   929,   930,  1207,  1209,   936,   938,  1210,   992,  1211,
    1226,   995,   353,  1229,  1231,  1232,  1233,  1242,   354,  1243,
    1244,   355,  1245,  1585,  1246,  1282,  1279,  1586,   126,  1587,
    1280,  1288,   127,  1588,  1295,  1589,  1590,   978,  1296,  1299,
    1306,  1309,   217,  1592,  1593,  1594,  1595,   128,   985,   129,
     987,  1312,   507,   508,   509,   510,   511,   512,   997,   514,
     515,   516,   517,   518,   519,   520,  1314,  1316,  1317,  1318,
    1321,  1324,  1021,  1023,  1325,  1326,  1330,  1028,  1030,   346,
     232,   347,   348,   349,   350,   351,   352,  1334,  1336,  1612,
    1339,  1614,  1357,  1616,  1366,  1618,  1368,  1446,   356,  1427,
    1390,  1409,  1410,  1622,  1451,  1623,   357,  1624,  1453,  1625,
    1435,  1412,  1411,  1457,   120,   121,  1052,  1053,  1054,  1055,
    1460,  1461,  1475,  1476,  1477,  1478,   353,  1490,  1495,    53,
     122,  1501,   354,  1503,  1504,   355,   123,  1549,   124,   125,
     358,  1505,   359,   249,   360,  1506,  1513,  1556,   361,  1507,
    1558,  1508,   120,   121,  1509,  1510,  1514,  1518,  1511,  1560,
    1155,  1512,  1157,  1562,  1517,  1564,  1581,    53,   122,  1565,
    1582,  1568,   280,  1569,   123,  1583,   124,   125,  1584,  1570,
     362,   363,  1596,  1598,  1600,   364,   365,  1571,   366,  1572,
    1573,  1574,  1575,   367,  1576,   368,   369,   370,   371,  1577,
    1602,  1610,    70,   372,   373,   374,   375,  1606,   341,  1619,
     581,  1620,   356,   300,   222,   120,   121,   704,   960,   223,
     357,   718,   790,  1198,   959,   633,   969,   789,  1268,   126,
      53,   122,  1413,   127,  1266,  1249,   254,   123,  1401,   124,
     125,   798,   627,   796,   120,   121,   753,   800,   128,    59,
     129,   583,  1222,  1224,   358,   649,   359,   635,   360,    53,
     122,   697,   361,   660,   399,   400,   123,   126,   124,   125,
     981,   127,   401,   402,   839,     0,   403,  1436,   404,   405,
     406,   407,   408,   460,     0,   627,   128,     0,   129,     0,
       0,     0,   409,   410,   362,   363,     0,     0,     0,   364,
     365,     0,   366,     0,     0,     0,     0,   367,     0,   368,
     369,   370,   371,     0,     0,     0,     0,   372,   373,   374,
     375,   478,     0,   406,   407,   408,   479,     0,     0,     0,
     126,     0,     0,     0,   127,   480,     0,   481,   482,   483,
     484,   485,   486,   487,   488,   489,     0,     0,     0,   128,
       0,   129,     0,     0,     0,     0,     0,     0,     0,   126,
       0,     0,     0,   127,   161,   181,   203,   220,   235,   252,
     266,   283,     0,     0,     0,     0,     0,     0,   128,     0,
     129,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,  1115,
    1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,  1124,  1125,
    1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,  1135,
    1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,   162,
     182,   204,   221,   236,   253,   267,   284,   164,   184,   206,
     225,   237,   255,   269,   285,   165,   185,   207,   226,   238,
     256,   270,   286,   166,   186,   208,   227,   239,   257,   271,
     287,   167,   187,   209,   228,   240,   258,   272,   288,   168,
     188,   210,   229,   241,   259,   273,   289,   169,   189,   211,
     230,   242,   260,   274,   290,   170,   190,   212,   231,   243,
     261,   275,   291
};

static const yytype_int16 yycheck[] =
{
     417,   340,   340,    86,   143,   400,   401,   402,   392,   404,
     405,   446,   858,   859,   409,   410,   120,   121,   413,   123,
     340,   416,   459,   427,   428,   376,   430,   345,  1163,    21,
      22,   249,    24,    22,    23,     6,   591,    22,    23,    74,
     336,    43,    77,   427,   428,    58,   430,    79,    20,    92,
       8,    92,    10,    78,    12,    13,     3,    43,   453,    17,
      18,   456,    59,   500,    98,    40,   717,   462,   463,   464,
      11,   466,   467,    31,   491,    62,    95,     5,   473,   474,
     475,  1336,    59,   478,   479,   640,   148,   415,   643,  1438,
    1439,   646,    16,    16,    95,   490,     3,    55,    56,   494,
     911,    79,     6,   498,   148,    63,   148,    65,     3,   911,
       6,   260,    26,    27,    28,    93,    74,    41,    32,    33,
     139,    35,    36,    98,    38,    39,   257,   445,    75,    76,
     911,   280,    90,   175,    92,   148,    95,    60,   172,   146,
     290,   175,   470,    90,   176,   177,   146,   139,   140,   960,
      97,   148,   283,    26,    27,    28,    52,   307,   960,    32,
      33,    19,    35,    36,    31,    38,    39,     6,    75,    76,
      37,   148,    95,    22,    23,     6,   210,   148,   210,   960,
      75,    76,   216,    90,    95,   911,   867,   229,   222,   223,
      97,   142,   143,   144,   145,    90,    91,   222,   223,   140,
    1549,  1336,    97,    42,    99,   100,   623,   624,   625,   604,
      49,    50,    51,    52,   865,   452,   217,   260,   219,   260,
     148,   146,   617,   618,   259,   148,   139,   289,    95,    96,
     217,   468,   219,   584,   960,   148,   194,   139,   280,     6,
     657,   658,   659,   638,   148,   217,   148,   219,   250,   251,
     252,   253,   148,   139,   140,   672,   214,   340,   217,   302,
     219,   302,   220,   177,   250,   251,   252,   253,   685,   686,
     687,   911,   306,   491,   170,   171,   693,   911,   673,    43,
     675,   148,   178,   179,   701,   257,   182,   583,   184,   185,
     186,   187,   188,    73,    74,   190,   691,   692,    78,   194,
     651,   279,   198,   199,   177,    43,   217,   278,   219,   148,
     745,   300,   146,   305,   209,   300,   211,   148,   265,   266,
     960,   225,   226,   227,   228,   229,   960,  1582,  1583,  1584,
     146,    79,   650,   229,   292,   258,   139,    79,   141,   756,
     757,   758,   759,   760,   761,    93,   146,   178,   179,   766,
     181,   148,   303,    74,   258,  1610,   260,    78,   265,   266,
    1041,  1042,  1043,   160,   260,    79,   261,   263,   217,   273,
     219,   148,   148,   790,   791,   146,   280,   273,    22,    23,
     148,   148,   278,   160,   160,    16,   803,   804,   146,   303,
     229,   808,   160,   810,   811,   146,   813,   814,   229,   295,
      31,   142,   143,   144,   145,   217,    37,   219,   257,   139,
     827,   141,    95,   280,   831,   832,   833,    75,    76,   836,
     837,   838,   288,   254,   255,   291,    57,    58,     0,   260,
     303,   148,    90,   139,   851,   139,   148,    95,   855,    97,
     857,   302,   273,   160,   148,   257,   585,  1582,  1583,  1584,
     801,    82,    83,    84,  1437,  1438,  1439,    88,   225,   226,
     227,   228,   229,   898,    95,    96,     7,   139,    75,   217,
     218,   219,   140,  1297,   140,  1610,   148,    42,   302,    44,
      45,    46,    47,    48,    49,   140,   250,   251,   252,   253,
     907,   908,   909,   260,   911,    64,   139,    66,    67,    68,
      69,    70,    71,    72,    73,   148,   273,  1331,  1332,  1333,
     927,   141,   250,   251,   252,   253,   302,   148,   212,   213,
      57,    58,    77,   918,    89,   267,   268,   269,   270,   286,
      95,   279,   949,    98,   217,   970,   219,   279,  1437,  1438,
    1439,    75,   959,   960,    77,   293,   963,    84,   887,   139,
     140,    88,    77,   267,   268,   269,   270,    16,    95,    96,
      77,   978,   303,    77,   981,   279,  1549,   984,    62,   986,
      75,   988,   989,   148,   991,    75,    76,   994,     9,   996,
     997,   225,   226,   227,   228,   149,   930,   907,   195,   196,
      90,   911,   148,   793,  1011,   139,   140,    97,  1015,  1222,
    1223,  1224,  1019,   139,   160,   744,    81,   265,   266,   140,
     175,   148,   148,   257,   258,  1032,  1440,  1441,   183,   148,
     161,   162,   163,   164,   165,   166,   167,   168,   169,  1110,
      95,   678,   679,   264,   681,   682,   683,  1074,   907,   959,
     960,   985,   911,   987,   284,   139,   140,  1471,   302,   280,
    1549,   907,   217,   853,   219,   911,   221,   232,   233,   234,
     225,   195,   196,   802,   148,   302,    42,  1513,    44,    45,
      46,    47,    48,    49,   139,   140,  1020,  1021,  1022,  1023,
      29,    30,  1110,    61,   148,   140,   250,   251,   252,   253,
     959,   960,   257,   258,   148,   140,   160,   262,   263,   148,
     265,    95,   148,   959,   960,   270,   160,   272,   273,   274,
     275,   160,   148,    89,   160,   280,   281,   282,   283,    95,
     139,  1344,    98,   217,   148,   219,  1349,   264,  1351,   148,
    1353,   140,  1578,  1579,   303,  1290,  1171,   140,   303,   178,
     179,   941,   942,   943,   139,   139,   140,    31,   232,   233,
     234,   149,   217,    37,   219,   281,   282,  1174,  1162,    53,
      54,    95,   191,   192,   193,   265,   266,  1248,  1249,   140,
    1187,   139,  1189,   139,   974,   975,   976,  1194,  1162,   141,
    1197,  1198,  1263,   289,  1265,  1266,  1267,  1268,   835,    95,
     990,   146,   839,   147,  1275,  1276,   232,   233,   234,   175,
    1217,  1218,  1219,  1220,   148,   139,   140,   183,   232,   233,
     234,  1155,   139,  1157,   300,   301,  1016,  1017,  1018,    25,
    1248,  1249,   148,   217,   907,   219,  1026,    80,   911,     3,
     969,    50,    51,   139,   140,  1263,  1036,  1265,  1266,  1267,
    1268,   217,   139,   219,   140,   221,    94,  1275,  1276,   225,
      94,   955,   250,   251,   252,   253,  1251,  1252,  1253,  1254,
    1255,  1256,  1257,  1258,  1259,  1260,   140,  1067,  1068,  1069,
    1070,  1071,  1072,   229,   139,   140,   959,   960,    72,    73,
      74,   257,   258,   217,    78,   219,   262,   263,   149,   265,
     225,   226,   227,   228,   270,   149,   272,   273,   274,   275,
     149,    75,    76,   302,   280,   281,   282,   283,  1247,  1247,
     148,   217,   140,   219,   139,   140,    90,    91,   139,   140,
     149,   213,   257,    97,   287,    99,   100,   303,    72,    73,
      74,  1348,   285,  1350,    78,  1352,   287,  1354,   222,   223,
     296,   297,   298,   299,   300,   301,   964,   148,  1148,   295,
    1150,   273,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,    31,  1167,  1168,    85,
      86,    87,    37,  1173,   197,  1175,   222,   223,   224,  1179,
      97,  1181,  1182,  1378,  1184,  1185,   276,   277,   278,   250,
     251,   252,   253,   139,   140,  1195,   250,   251,   252,   253,
      59,   250,   251,   252,   253,  1205,  1206,  1207,   148,  1209,
    1210,  1211,    72,    73,    74,  1033,   190,   148,    78,   302,
     194,   250,   251,   252,   253,   259,  1226,    14,    15,  1229,
      95,  1231,   259,   229,    42,   209,    42,   211,   250,   251,
     252,   253,  1242,  1243,  1244,   175,  1246,   232,   233,   234,
       3,    29,    30,   184,    98,   186,   187,   188,   189,   148,
     256,   139,  1479,   139,  1481,   231,  1483,   198,  1485,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   142,   143,
     144,   145,  1282,   231,   232,   233,   234,   235,  1288,   862,
     863,   864,   139,   140,   139,  1295,  1296,   230,   231,  1299,
     296,   297,   298,   299,   300,   301,  1306,   230,   231,  1309,
     230,   231,  1312,   140,  1314,   140,  1316,  1317,  1318,   230,
     231,  1321,    75,    76,  1324,  1325,   230,   231,   222,   223,
    1330,   140,   263,   304,  1334,   230,   231,    90,    91,  1339,
     139,   229,  1160,   139,    97,    20,    99,   100,   304,    42,
      77,    44,    45,    46,    47,    48,    49,  1357,  1176,   173,
     174,   304,   139,   140,   295,   304,   304,   304,   256,   304,
     304,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,    72,    73,    74,    75,    76,
      77,    78,    79,   148,   304,  1213,    89,  1215,   304,   304,
     148,   304,    95,   304,   304,    98,   304,  1225,   296,   297,
     298,   299,   300,   301,   304,    92,  1234,  1235,  1236,  1237,
    1238,  1239,   304,   150,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   304,   304,   304,    59,   190,   148,   139,
     286,   194,   140,   294,    81,   148,  1446,   148,     5,   148,
      14,  1451,    16,  1453,   148,   286,   209,  1457,   211,     5,
    1460,  1461,    26,  1281,   148,    29,    30,    31,   148,    33,
      34,    98,   148,    98,   148,  1475,  1476,  1477,  1478,   148,
    1298,   148,   175,  1301,    84,  1303,   148,   148,   616,   148,
     183,   619,   620,   621,   622,   222,   223,     5,   148,   139,
     139,   139,  1320,   139,   139,   139,   634,   140,   140,  1327,
    1328,  1329,   140,   139,   231,   231,   140,    81,   140,   140,
      59,     5,     5,     5,   217,    59,   219,   231,   221,    93,
      94,     3,   225,   148,   148,   148,   148,   148,  1356,   148,
    1358,   669,   670,   671,   148,   148,   674,   148,   676,   148,
     148,  1369,  1370,  1371,  1372,   149,  1556,   149,  1558,   149,
    1560,   231,  1562,   231,   257,   258,   694,   695,   696,   262,
     263,   699,   265,     5,     5,     5,   230,   270,   180,   272,
     273,   274,   275,   180,   231,     5,   149,   280,   281,   282,
     283,     5,   271,     5,     5,   149,  1596,   148,  1598,   148,
    1600,     5,  1602,    75,    76,   149,   149,     5,   300,   139,
     303,   148,     5,     5,     5,  1433,  1434,     5,    90,    91,
       5,     5,   139,   139,   148,    97,  1444,    99,   100,   148,
    1448,  1449,  1450,     5,  1452,     5,  1454,  1455,  1456,   180,
     231,  1459,   180,     4,  1462,  1463,     5,   775,   776,  1467,
       5,     5,   139,     5,     5,    42,  1474,    44,    45,    46,
      47,    48,    49,     5,     5,     5,   794,     5,   149,     5,
    1488,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   139,   148,   148,   148,     5,
       5,   773,   774,     5,     5,   777,   778,     5,   826,     5,
       5,   829,    89,     5,     5,   139,   139,     5,    95,     5,
       5,    98,   139,  1531,     5,     5,   231,  1535,   190,  1537,
     148,     5,   194,  1541,     5,  1543,  1544,   809,     5,     5,
       5,     5,     3,  1551,  1552,  1553,  1554,   209,   820,   211,
     822,     5,   236,   237,   238,   239,   240,   241,   830,   243,
     244,   245,   246,   247,   248,   249,     5,     5,     5,     5,
       5,     5,   844,   845,     5,   231,     5,   849,   850,    42,
       3,    44,    45,    46,    47,    48,    49,     5,     4,  1597,
       5,  1599,     5,  1601,   296,  1603,   139,     5,   175,   215,
     140,   139,   139,  1611,     5,  1613,   183,  1615,     5,  1617,
      99,   140,   148,     5,    75,    76,   888,   889,   890,   891,
       5,     5,     5,     5,     5,     5,    89,   148,   139,    90,
      91,   139,    95,   148,   148,    98,    97,     6,    99,   100,
     217,   148,   219,     3,   221,   148,    98,     5,   225,   148,
       5,   148,    75,    76,   148,   148,   139,   139,   148,     5,
     932,   148,   934,     5,   148,   234,    59,    90,    91,   148,
       5,   149,     3,   149,    97,     5,    99,   100,     5,   149,
     257,   258,     5,     5,     5,   262,   263,   149,   265,   149,
     149,   149,   149,   270,   149,   272,   273,   274,   275,   149,
       5,     5,    12,   280,   281,   282,   283,   139,   102,   139,
     341,   139,   175,    84,    75,    75,    76,   503,   789,    75,
     183,   541,   633,   995,   788,   415,   303,   632,  1122,   190,
      90,    91,  1273,   194,  1113,  1109,    77,    97,  1263,    99,
     100,   643,   148,   640,    75,    76,   591,   646,   209,     1,
     211,   344,  1024,  1025,   217,   442,   219,   417,   221,    90,
      91,   491,   225,   452,   170,   171,    97,   190,    99,   100,
     812,   194,   178,   179,   684,    -1,   182,  1290,   184,   185,
     186,   187,   188,   158,    -1,   148,   209,    -1,   211,    -1,
      -1,    -1,   198,   199,   257,   258,    -1,    -1,    -1,   262,
     263,    -1,   265,    -1,    -1,    -1,    -1,   270,    -1,   272,
     273,   274,   275,    -1,    -1,    -1,    -1,   280,   281,   282,
     283,   184,    -1,   186,   187,   188,   189,    -1,    -1,    -1,
     190,    -1,    -1,    -1,   194,   198,    -1,   200,   201,   202,
     203,   204,   205,   206,   207,   208,    -1,    -1,    -1,   209,
      -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   190,
      -1,    -1,    -1,   194,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    -1,    -1,    -1,    -1,    -1,   209,    -1,
     211,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,    72,
      73,    74,    75,    76,    77,    78,    79,    72,    73,    74,
      75,    76,    77,    78,    79,    72,    73,    74,    75,    76,
      77,    78,    79,    72,    73,    74,    75,    76,    77,    78,
      79,    72,    73,    74,    75,    76,    77,    78,    79,    72,
      73,    74,    75,    76,    77,    78,    79,    72,    73,    74,
      75,    76,    77,    78,    79,    72,    73,    74,    75,    76,
      77,    78,    79
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,     7,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   309,   310,   311,   330,   331,   332,   334,   335,   336,
     337,   340,   341,   342,   343,   344,   345,   346,   352,   363,
     364,   369,   391,   392,   393,   394,   395,   396,   397,   398,
     399,     8,    10,    12,    13,    17,    18,    31,    55,    56,
      63,    65,    74,    90,    92,   194,   214,   220,   292,   480,
     146,   146,   146,   146,   146,   146,   146,   146,   146,     0,
     311,   312,   314,   316,   318,   320,   322,   324,   326,   328,
      11,   140,   148,   139,   365,   366,   370,    19,   302,   140,
     140,   302,   148,   140,   141,   302,    75,   195,   196,   212,
     213,   286,   347,   348,    92,   260,   302,   484,    74,    77,
     259,    77,    77,    77,    16,    77,    77,    16,    41,     3,
      75,    76,    91,    97,    99,   100,   190,   194,   209,   211,
     313,   400,   401,   402,   411,   414,   417,   460,   461,   462,
     463,   476,   479,   480,   481,   487,   488,   489,   490,   491,
     495,   545,   546,   547,   549,   550,   551,     3,   261,   315,
     400,   401,   402,   460,   476,   479,   487,   488,   489,   490,
     491,   516,   531,   540,   542,   544,   545,   551,     3,   317,
     400,   401,   402,   460,   476,   479,   487,   488,   489,   490,
     491,   533,   534,   535,   536,   537,   538,   540,   545,   551,
       3,   319,   400,   401,   402,   460,   476,   479,   487,   488,
     489,   490,   491,   516,   540,   545,   551,     3,   321,   400,
     401,   402,   411,   414,   420,   476,   479,   487,   488,   489,
     490,   491,     3,   323,   400,   401,   402,   476,   479,   487,
     488,   489,   490,   491,   552,   553,   554,   555,   556,     3,
     325,   400,   401,   402,   463,   476,   479,   487,   488,   489,
     490,   491,   498,   548,   327,   400,   401,   402,   460,   476,
     479,   487,   488,   489,   490,   491,   516,   540,   545,   551,
       3,   329,   400,   401,   402,   476,   479,   487,   488,   489,
     490,   491,   494,   541,     9,    75,   333,    81,   367,    95,
     366,   473,    14,    16,    26,    29,    30,    31,    33,    34,
      81,    93,    94,   353,   371,   372,   373,   374,   375,   376,
     379,   380,   381,   382,   383,   354,   338,   250,   251,   252,
     253,   539,   142,   143,   144,   145,   485,   486,   140,   148,
     349,   348,   284,   351,   302,   302,    42,    44,    45,    46,
      47,    48,    49,    89,    95,    98,   175,   183,   217,   219,
     221,   225,   257,   258,   262,   263,   265,   270,   272,   273,
     274,   275,   280,   281,   282,   283,   482,   483,    61,   558,
     140,   140,   139,   140,   139,   140,   140,   140,   139,   140,
     139,   140,   403,   405,   139,   139,     6,    52,   148,   170,
     171,   178,   179,   182,   184,   185,   186,   187,   188,   198,
     199,   229,   260,   263,   273,   278,   295,   496,   497,   501,
     505,   507,   508,   509,   510,   512,   513,   403,   403,   141,
     403,   148,   289,   289,   191,   192,   193,    75,   195,   196,
     147,   146,   492,   493,   260,   302,   484,     6,   225,   226,
     227,   228,   229,   258,   260,   280,   515,   543,   260,   280,
     543,     6,   178,   179,   181,   229,   254,   255,   229,     6,
     278,     6,    42,    49,    50,    51,    52,   229,   184,   189,
     198,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     295,   499,   500,   502,   503,   504,   506,   509,   175,   229,
     280,   139,    25,   148,    37,   222,   223,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   353,   358,   361,   362,   368,   407,   408,   148,    80,
     410,    21,    22,    24,   139,   140,   305,   139,   140,    94,
      94,   302,   140,   148,   140,    29,    30,    26,    27,    28,
      32,    33,    35,    36,    38,    39,   177,   303,   355,    64,
      66,    67,    68,    69,    70,    71,    72,    73,   303,   339,
     287,   287,   303,   486,   213,    95,   350,   353,   358,   361,
     362,   351,   285,   485,   482,   303,   483,   148,    95,   217,
     219,   404,   405,   406,   472,    79,    93,   217,   218,   219,
     279,   293,   423,   425,   295,    97,   229,   296,   297,   298,
     299,   300,   301,   517,   517,   517,   517,   178,   179,   517,
     517,   517,   517,   281,   282,   273,   517,   148,   525,   526,
     527,   279,   423,   425,   517,   497,   527,   197,   511,    95,
     404,   470,    95,   404,   469,    95,   404,   471,    59,   493,
     302,   482,   558,    22,    23,   257,   532,   257,   258,   515,
     532,   517,   300,   301,   478,   517,   259,   478,   259,   517,
     517,   517,   283,   256,   517,   256,   517,   267,   268,   269,
     270,   267,   268,   269,   270,    42,    53,    54,   517,   517,
     517,    50,    51,    42,   517,   517,   517,   500,   527,   517,
     517,   175,   478,   148,   367,    98,   139,   141,   139,   139,
     231,   139,   140,   140,   140,   304,   384,   139,   354,    20,
     390,   377,   304,   304,   304,   304,   304,   304,   304,   304,
     304,   304,   304,   304,   304,   304,   304,   304,   304,   304,
     304,   148,   148,   303,   303,   484,    59,   148,   139,   148,
     139,   148,   406,   472,   139,   140,   139,   148,   139,   148,
     139,   148,   286,   294,    81,   424,   418,   517,   148,   148,
     148,   148,   160,   514,   514,   517,   517,   514,   514,   514,
     514,   527,   527,   527,   148,    59,   148,     5,   286,   424,
     418,   148,   514,     5,   517,   148,   470,   148,   469,   148,
     471,   482,   303,   148,    98,   527,   527,   527,    98,   148,
     139,   140,   148,   139,   140,   139,   140,   139,   140,   148,
     514,   148,   514,   148,   514,   527,   517,   148,   514,   517,
     514,   421,   421,   421,    84,   557,   421,   421,   421,   557,
     527,   527,   527,   148,   148,   148,   517,   517,   527,   514,
     514,   148,   514,     5,   514,   148,   527,   139,    22,    23,
     300,   359,   385,   386,   387,   139,   139,   388,   389,   390,
     303,    20,   217,   219,   257,   378,   140,   140,   140,   139,
     140,    14,    15,    29,    30,   140,   140,   360,   148,   148,
     148,   148,   148,   148,   148,   148,   148,   231,   484,   558,
     231,   527,   527,   527,   527,   527,   527,   415,   139,   140,
     148,   412,    57,    58,    84,    88,    95,    96,   264,   419,
     427,   431,   432,   464,   474,   475,   527,   148,    59,   539,
     539,   148,   514,   148,   514,   149,   539,   149,   539,   149,
     149,     5,     5,     5,   231,   232,   233,   234,   235,   518,
      59,    75,    76,    90,    97,   265,   266,   522,   523,   415,
     412,   527,   527,   149,   523,   514,   231,   231,   231,   303,
     484,   527,    58,   527,     5,     5,     5,   527,   539,   527,
     527,   518,   527,   527,   180,   539,   180,   539,   230,   231,
       5,   148,   514,   527,   149,   514,   149,   539,    16,    60,
      95,   258,   422,   465,   466,   467,   468,   527,   527,   527,
     271,   421,   527,   527,   527,   421,     5,     5,     5,   149,
      43,   539,    43,   539,   148,   148,     5,   149,   539,   149,
     539,   527,   149,   523,   149,   527,     5,   527,   359,   359,
     139,   388,   388,   388,   390,   389,   139,   148,   139,   148,
     148,   361,   539,   539,   539,   539,   230,   231,   230,   231,
     230,   231,   230,   231,   230,   231,   558,     5,     5,     5,
       5,     5,     5,    37,   280,   353,   356,   358,   416,   474,
     475,   477,   527,   527,   527,    16,    82,    83,   353,   356,
     358,   413,   426,   427,   430,   431,   432,   464,   474,   475,
     477,   527,   139,   139,    85,    86,    87,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   148,   148,   517,     5,   527,
       5,   231,   520,   520,   180,   539,   180,   539,   523,   523,
     523,   527,   403,     4,   529,   527,   527,     5,     5,   527,
     529,   484,   558,     5,   139,     5,   523,   523,   523,     5,
     527,     5,     5,   527,     5,     5,   527,   520,   527,   520,
     527,   527,   523,   527,   149,     5,   527,   149,   539,   527,
     527,   139,   148,   148,   148,     5,     5,     5,   527,     5,
       5,     5,   527,   523,   523,   523,   527,   520,   520,   520,
     520,    43,   539,    43,   539,   523,     5,   527,   529,     5,
     523,     5,   139,   139,   523,   523,   523,   523,   523,   523,
      40,   478,     5,     5,     5,   139,     5,   428,   447,   447,
      77,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   407,   408,   458,   459,   435,   435,   439,   439,    79,
     176,   177,   210,   433,   434,   437,   441,   445,   456,   231,
     148,   523,     5,    95,   523,   520,   520,   529,     5,    62,
     404,   521,     3,   522,   524,     5,     5,   523,   523,     5,
     558,   523,   527,   523,   529,   523,     5,   523,   523,     5,
     523,   523,     5,   527,     5,   527,     5,     5,     5,   527,
     523,     5,   527,   527,     5,     5,   231,   523,   523,   523,
       5,   523,   523,   523,     5,   529,     4,   530,   529,     5,
     527,   527,   527,   527,   148,   232,   233,   234,   519,   148,
     519,   148,   519,   148,   519,   529,   523,     5,   523,   523,
     529,   529,   529,   529,   529,   529,   296,   357,   139,   523,
     523,   523,   523,   361,   362,   429,    98,   172,   175,   210,
     216,   306,   407,   408,   448,   449,   450,   451,   452,   453,
     140,   517,   517,   517,   517,   517,   517,   517,   517,   517,
     517,   459,   407,   408,   436,    78,   407,   408,   440,   139,
     139,   148,   140,   434,   407,   408,   438,   224,   407,   408,
     409,   442,   288,   291,   443,   444,   446,   215,   455,   457,
     230,   231,   529,   523,   523,    99,   521,   276,   277,   278,
     523,   523,   530,   529,   523,   529,     5,   529,   523,   523,
     523,     5,   523,     5,   523,   523,   523,     5,   529,   523,
       5,     5,   523,   523,   529,   529,   529,   523,   530,   530,
     530,   523,     3,   524,   523,     5,     5,     5,     5,   519,
     527,   519,   527,   519,   527,   519,   527,   529,   523,   529,
     148,   529,   529,   529,   529,   139,   173,   174,   517,   139,
     140,   139,   454,   148,   148,   148,   148,   148,   148,   148,
     148,   148,   148,    98,   139,   139,   141,   148,   139,   529,
     529,    59,   148,   525,   526,   528,   528,   528,   530,   530,
     529,   523,   529,   529,   529,   523,   529,   523,   529,   529,
     529,   523,   529,   523,   523,   529,   529,   529,   530,     6,
     529,   523,   523,   523,   523,   527,     5,   527,     5,   527,
       5,   527,     5,   529,   234,   148,   290,   307,   149,   149,
     149,   149,   149,   149,   149,   149,   149,   149,    22,    23,
     359,    59,     5,     5,     5,   529,   529,   529,   529,   529,
     529,   528,   529,   529,   529,   529,     5,   523,     5,   523,
       5,   523,     5,   523,   359,   359,   139,   524,   524,   524,
       5,   523,   529,   523,   529,   523,   529,   523,   529,   139,
     139,   524,   529,   529,   529,   529
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int16 yyr1[] =
{
       0,   308,   309,   309,   310,   310,   311,   311,   311,   311,
     311,   311,   311,   311,   311,   311,   311,   311,   311,   311,
     311,   311,   311,   311,   311,   311,   311,   311,   311,   311,
     311,   311,   311,   312,   312,   313,   313,   313,   313,   313,
     313,   313,   313,   313,   313,   313,   313,   313,   313,   313,
     313,   313,   313,   313,   313,   313,   313,   313,   313,   314,
     314,   315,   315,   315,   315,   315,   315,   315,   315,   315,
     315,   315,   315,   315,   315,   315,   315,   315,   315,   316,
     316,   317,   317,   317,   317,   317,   317,   317,   317,   317,
     317,   317,   317,   317,   317,   317,   317,   317,   317,   317,
     317,   318,   318,   319,   319,   319,   319,   319,   319,   319,
     319,   319,   319,   319,   319,   319,   319,   319,   320,   320,
     321,   321,   321,   321,   321,   321,   321,   321,   321,   321,
     321,   321,   321,   322,   322,   323,   323,   323,   323,   323,
     323,   323,   323,   323,   323,   323,   323,   323,   323,   323,
     324,   324,   325,   325,   325,   325,   325,   325,   325,   325,
     325,   325,   325,   325,   325,   326,   326,   327,   327,   327,
     327,   327,   327,   327,   327,   327,   327,   327,   327,   327,
     327,   327,   328,   328,   329,   329,   329,   329,   329,   329,
     329,   329,   329,   329,   329,   329,   330,   330,   330,   331,
     332,   333,   333,   334,   335,   335,   335,   336,   337,   338,
     338,   339,   339,   339,   339,   339,   339,   339,   339,   339,
     339,   339,   339,   339,   339,   340,   341,   341,   341,   342,
     342,   342,   343,   344,   345,   346,   347,   347,   348,   349,
     349,   350,   350,   350,   350,   350,   351,   351,   352,   353,
     353,   354,   354,   355,   355,   355,   355,   355,   355,   355,
     355,   355,   355,   355,   355,   356,   357,   357,   358,   358,
     358,   359,   359,   360,   360,   361,   361,   361,   361,   361,
     361,   361,   361,   361,   361,   361,   361,   361,   362,   363,
     364,   365,   365,   366,   366,   367,   367,   368,   368,   368,
     368,   368,   368,   369,   370,   370,   371,   371,   371,   371,
     371,   371,   371,   371,   371,   372,   373,   374,   375,   376,
     377,   377,   378,   378,   378,   378,   378,   378,   379,   379,
     380,   380,   381,   381,   382,   383,   383,   383,   383,   383,
     383,   384,   383,   385,   383,   386,   383,   387,   383,   383,
     388,   388,   389,   390,   390,   391,   391,   391,   391,   392,
     393,   393,   394,   395,   396,   396,   397,   398,   399,   399,
     400,   400,   401,   401,   402,   402,   403,   403,   404,   404,
     405,   405,   406,   406,   406,   406,   407,   407,   408,   409,
     410,   410,   411,   411,   412,   412,   413,   413,   413,   413,
     413,   413,   413,   413,   413,   413,   413,   413,   414,   414,
     415,   415,   416,   416,   416,   416,   416,   416,   417,   417,
     418,   418,   419,   419,   419,   419,   419,   419,   420,   420,
     420,   420,   420,   420,   420,   420,   421,   421,   422,   422,
     422,   422,   423,   423,   424,   425,   426,   426,   427,   427,
     427,   428,   428,   429,   429,   430,   431,   431,   431,   431,
     431,   431,   431,   431,   431,   431,   431,   431,   431,   431,
     431,   431,   431,   431,   431,   431,   431,   431,   431,   431,
     431,   431,   431,   431,   431,   431,   431,   431,   431,   431,
     431,   431,   431,   431,   432,   432,   433,   433,   434,   434,
     434,   434,   435,   435,   436,   436,   437,   437,   438,   438,
     439,   439,   440,   440,   440,   440,   440,   441,   441,   442,
     442,   442,   443,   443,   444,   445,   445,   446,   446,   447,
     447,   448,   448,   448,   448,   448,   448,   448,   448,   449,
     450,   450,   451,   451,   452,   453,   454,   454,   455,   456,
     456,   457,   458,   458,   459,   459,   459,   459,   459,   459,
     459,   459,   459,   459,   459,   459,   459,   460,   460,   461,
     462,   463,   464,   464,   465,   466,   467,   468,   469,   469,
     470,   470,   471,   471,   472,   472,   473,   473,   474,   475,
     476,   476,   477,   478,   478,   479,   479,   479,   479,   480,
     481,   482,   482,   483,   483,   483,   483,   483,   483,   483,
     483,   483,   483,   483,   483,   483,   483,   483,   483,   483,
     483,   483,   483,   483,   483,   483,   483,   483,   483,   483,
     483,   483,   483,   484,   484,   485,   485,   486,   486,   486,
     486,   487,   487,   487,   488,   488,   488,   489,   489,   489,
     490,   491,   492,   492,   493,   494,   494,   495,   496,   496,
     497,   497,   497,   497,   497,   497,   497,   498,   499,   499,
     500,   500,   500,   500,   501,   501,   502,   503,   503,   503,
     503,   503,   503,   503,   503,   503,   503,   504,   504,   505,
     505,   505,   505,   506,   506,   507,   508,   509,   510,   510,
     510,   511,   511,   512,   512,   512,   513,   513,   513,   514,
     514,   515,   515,   515,   515,   516,   516,   517,   517,   517,
     517,   517,   517,   517,   517,   518,   518,   518,   518,   518,
     518,   519,   519,   519,   520,   520,   521,   521,   521,   522,
     522,   522,   522,   522,   522,   522,   523,   524,   525,   526,
     527,   527,   527,   528,   528,   528,   529,   529,   529,   529,
     529,   530,   530,   530,   531,   531,   531,   532,   532,   532,
     533,   533,   533,   533,   534,   534,   534,   534,   535,   535,
     536,   536,   537,   537,   538,   539,   539,   539,   539,   539,
     540,   540,   541,   542,   542,   542,   542,   542,   542,   542,
     542,   543,   543,   544,   544,   545,   545,   546,   546,   547,
     547,   548,   548,   549,   549,   550,   551,   551,   552,   552,
     552,   553,   554,   555,   555,   555,   555,   555,   555,   556,
     556,   556,   556,   556,   556,   557,   558,   558,   558
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     7,     8,     4,
       3,     0,     3,     2,     3,     3,     3,     4,     5,     0,
       2,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     2,     3,     3,     5,     4,
       6,     4,     3,     3,     3,     3,     2,     3,     2,     0,
       2,     3,     1,     1,     1,     1,     0,     2,     5,     1,
       4,     0,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     0,     1,     4,     5,
       5,     0,     1,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       5,     1,     2,     2,     4,     0,     2,     1,     1,     1,
       1,     1,     1,     3,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     3,     3,
       0,     2,     2,     2,     2,     2,     2,     1,     2,     2,
       2,     2,     1,     1,     2,     5,     4,     2,     3,     3,
       3,     0,     4,     0,     5,     0,     5,     0,     5,     2,
       1,     2,     1,     0,     1,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     2,     4,     5,     6,
       3,     4,     3,     4,     3,     4,     1,     2,     1,     2,
       1,     1,     2,     2,     2,     2,     2,     2,     2,     2,
       0,     2,     9,     9,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     9,     9,
       0,     2,     1,     1,     1,     1,     1,     1,     8,     8,
       0,     2,     1,     1,     1,     1,     1,     1,     9,     8,
       8,     8,     9,     8,     8,     8,     0,     2,     1,     1,
       1,     1,     0,     2,     2,     2,     1,     1,     2,     3,
       2,     0,     2,     1,     1,     2,     3,     2,     2,     2,
       2,     2,     2,     2,     3,     3,     2,     2,     2,     2,
       2,     2,     2,     3,     3,     3,     2,     2,     3,     2,
       2,     2,     3,     2,     2,     2,     2,     3,     3,     3,
       2,     2,     2,     3,     2,     2,     1,     2,     2,     2,
       2,     2,     0,     2,     1,     1,     0,     2,     1,     1,
       0,     2,     1,     1,     4,     5,     5,     0,     2,     1,
       1,     1,     2,     2,     2,     0,     2,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       2,     2,     2,     2,     2,     2,     0,     2,     2,     0,
       2,     1,     1,     2,     1,     1,     2,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     7,     6,     6,
       6,     9,     4,     4,     2,     2,     3,     2,     0,     3,
       0,     3,     0,     3,     0,     3,     0,     3,     3,     2,
       7,     7,     3,     1,     1,     3,     6,     7,     1,     2,
       2,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     4,     1,     2,     2,     2,     1,
       1,     3,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     1,     2,     1,     8,     6,     6,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     6,     1,     2,
       1,     1,     1,     1,     4,     4,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     4,     4,
       4,     4,     4,     4,     4,     3,     3,     4,     1,     1,
       1,     0,     1,     5,     6,     5,     5,     6,     5,     1,
       1,     1,     1,     1,     1,     9,     6,     0,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     0,     3,     4,     1,
       3,     4,     1,     1,     1,     1,     1,     1,     2,     3,
       0,     1,     1,     0,     1,     1,     0,     2,     6,     6,
       6,     0,     2,     6,     8,    10,     7,     0,     1,     1,
       8,     9,     9,    10,     9,     9,    10,    10,    10,     9,
      10,     9,     9,     9,     6,     0,     1,     1,     1,     1,
       8,     7,     7,     7,     7,     4,     4,     7,     7,     4,
       4,     0,     1,     9,     6,     8,     8,     8,     8,     9,
       9,     8,     9,     8,     9,     9,     8,     8,     7,     7,
       7,     7,     9,    10,    11,    12,    10,    11,    12,    10,
      11,    12,    10,    11,    12,     2,     0,     2,     3
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyo, yytype, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[+yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
#  else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                yy_state_t *yyssp, int yytoken)
{
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Actual size of YYARG. */
  int yycount = 0;
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[+*yyssp];
      YYPTRDIFF_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
      yysize = yysize0;
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYPTRDIFF_T yysize1
                    = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    /* Don't count the "%s"s in the final size, but reserve room for
       the terminator.  */
    YYPTRDIFF_T yysize1 = yysize + (yystrlen (yyformat) - 2 * yycount) + 1;
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss;
    yy_state_t *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYPTRDIFF_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 196:
#line 615 "src/p.y"
                                                    {
                        mailset.events = Event_All;
                        addmail((yyvsp[-2].string), &mailset, &Run.maillist);
                  }
#line 3534 "src/y.tab.c"
    break;

  case 197:
#line 619 "src/p.y"
                                                                            {
                        addmail((yyvsp[-5].string), &mailset, &Run.maillist);
                  }
#line 3542 "src/y.tab.c"
    break;

  case 198:
#line 622 "src/p.y"
                                                                                {
                        mailset.events = ~mailset.events;
                        addmail((yyvsp[-6].string), &mailset, &Run.maillist);
                  }
#line 3551 "src/y.tab.c"
    break;

  case 199:
#line 628 "src/p.y"
                                               {
                        if (! (Run.flags & Run_Daemon) || ihp.daemon) {
                                ihp.daemon     = true;
                                Run.flags      |= Run_Daemon;
                                Run.polltime   = (yyvsp[-1].number);
                                Run.startdelay = (yyvsp[0].number);
                        }
                  }
#line 3564 "src/y.tab.c"
    break;

  case 200:
#line 638 "src/p.y"
                                     {
                        Run.flags |= Run_Batch;
                  }
#line 3572 "src/y.tab.c"
    break;

  case 201:
#line 643 "src/p.y"
                              {
                        (yyval.number) = 0;
                  }
#line 3580 "src/y.tab.c"
    break;

  case 202:
#line 646 "src/p.y"
                                     {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 3588 "src/y.tab.c"
    break;

  case 203:
#line 651 "src/p.y"
                           {
                        Run.flags |= Run_Foreground;
                  }
#line 3596 "src/y.tab.c"
    break;

  case 204:
#line 656 "src/p.y"
                                     {
                        Run.onreboot = Onreboot_Start;
                  }
#line 3604 "src/y.tab.c"
    break;

  case 205:
#line 659 "src/p.y"
                                       {
                        Run.onreboot = Onreboot_Nostart;
                  }
#line 3612 "src/y.tab.c"
    break;

  case 206:
#line 662 "src/p.y"
                                         {
                        Run.onreboot = Onreboot_Laststate;
                  }
#line 3620 "src/y.tab.c"
    break;

  case 207:
#line 667 "src/p.y"
                                               {
                        // Note: deprecated (replaced by "set limits" statement's "sendExpectBuffer" option)
                        Run.limits.sendExpectBuffer = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3629 "src/y.tab.c"
    break;

  case 211:
#line 680 "src/p.y"
                                                   {
                        Run.limits.sendExpectBuffer = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3637 "src/y.tab.c"
    break;

  case 212:
#line 683 "src/p.y"
                                                    {
                        Run.limits.fileContentBuffer = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3645 "src/y.tab.c"
    break;

  case 213:
#line 686 "src/p.y"
                                                    {
                        Run.limits.httpContentBuffer = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3653 "src/y.tab.c"
    break;

  case 214:
#line 689 "src/p.y"
                                                {
                        Run.limits.programOutput = (yyvsp[-1].number) * (yyvsp[0].number);
                  }
#line 3661 "src/y.tab.c"
    break;

  case 215:
#line 692 "src/p.y"
                                                        {
                        Run.limits.networkTimeout = (yyvsp[-1].number);
                  }
#line 3669 "src/y.tab.c"
    break;

  case 216:
#line 695 "src/p.y"
                                                   {
                        Run.limits.networkTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3677 "src/y.tab.c"
    break;

  case 217:
#line 698 "src/p.y"
                                                        {
                        Run.limits.programTimeout = (yyvsp[-1].number);
                  }
#line 3685 "src/y.tab.c"
    break;

  case 218:
#line 701 "src/p.y"
                                                   {
                        Run.limits.programTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3693 "src/y.tab.c"
    break;

  case 219:
#line 704 "src/p.y"
                                                     {
                        Run.limits.stopTimeout = (yyvsp[-1].number);
                  }
#line 3701 "src/y.tab.c"
    break;

  case 220:
#line 707 "src/p.y"
                                                {
                        Run.limits.stopTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3709 "src/y.tab.c"
    break;

  case 221:
#line 710 "src/p.y"
                                                      {
                        Run.limits.startTimeout = (yyvsp[-1].number);
                  }
#line 3717 "src/y.tab.c"
    break;

  case 222:
#line 713 "src/p.y"
                                                 {
                        Run.limits.startTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3725 "src/y.tab.c"
    break;

  case 223:
#line 716 "src/p.y"
                                                        {
                        Run.limits.restartTimeout = (yyvsp[-1].number);
                  }
#line 3733 "src/y.tab.c"
    break;

  case 224:
#line 719 "src/p.y"
                                                   {
                        Run.limits.restartTimeout = (yyvsp[-1].number) * 1000;
                  }
#line 3741 "src/y.tab.c"
    break;

  case 225:
#line 724 "src/p.y"
                           {
                        Run.flags |= Run_FipsEnabled;
                  }
#line 3749 "src/y.tab.c"
    break;

  case 226:
#line 729 "src/p.y"
                                     {
                        if (! Run.files.log || ihp.logfile) {
                                ihp.logfile = true;
                                setlogfile((yyvsp[0].string));
                                Run.flags &= ~Run_UseSyslog;
                                Run.flags |= Run_Log;
                        }
                  }
#line 3762 "src/y.tab.c"
    break;

  case 227:
#line 737 "src/p.y"
                                     {
                        setsyslog(NULL);
                  }
#line 3770 "src/y.tab.c"
    break;

  case 228:
#line 740 "src/p.y"
                                                     {
                        setsyslog((yyvsp[0].string)); FREE((yyvsp[0].string));
                  }
#line 3778 "src/y.tab.c"
    break;

  case 229:
#line 745 "src/p.y"
                                              {
                        Run.eventlist_dir = (yyvsp[0].string);
                  }
#line 3786 "src/y.tab.c"
    break;

  case 230:
#line 748 "src/p.y"
                                                          {
                        Run.eventlist_dir = (yyvsp[-2].string);
                        Run.eventlist_slots = (yyvsp[0].number);
                  }
#line 3795 "src/y.tab.c"
    break;

  case 231:
#line 752 "src/p.y"
                                             {
                        Run.eventlist_dir = Str_dup(MYEVENTLISTBASE);
                        Run.eventlist_slots = (yyvsp[0].number);
                  }
#line 3804 "src/y.tab.c"
    break;

  case 232:
#line 758 "src/p.y"
                                  {
                        Run.files.id = (yyvsp[0].string);
                  }
#line 3812 "src/y.tab.c"
    break;

  case 233:
#line 763 "src/p.y"
                                     {
                        Run.files.state = (yyvsp[0].string);
                  }
#line 3820 "src/y.tab.c"
    break;

  case 234:
#line 768 "src/p.y"
                                   {
                        if (! Run.files.pid || ihp.pidfile) {
                                ihp.pidfile = true;
                                setpidfile((yyvsp[0].string));
                        }
                  }
#line 3831 "src/y.tab.c"
    break;

  case 238:
#line 783 "src/p.y"
                                          {
                        mmonitset.url = (yyvsp[-1].url);
                        addmmonit(&mmonitset);
                  }
#line 3840 "src/y.tab.c"
    break;

  case 241:
#line 793 "src/p.y"
                                        {
                        mmonitset.timeout = (yyvsp[-1].number) * 1000; // net timeout is in milliseconds internally
                  }
#line 3848 "src/y.tab.c"
    break;

  case 247:
#line 803 "src/p.y"
                                       {
                        Run.flags &= ~Run_MmonitCredentials;
                  }
#line 3856 "src/y.tab.c"
    break;

  case 248:
#line 808 "src/p.y"
                                                     {
                        _setSSLOptions(&(Run.ssl));
                  }
#line 3864 "src/y.tab.c"
    break;

  case 249:
#line 813 "src/p.y"
                           {
                        sslset.flags = SSL_Enabled;
                  }
#line 3872 "src/y.tab.c"
    break;

  case 253:
#line 823 "src/p.y"
                                    {
                        sslset.flags = SSL_Enabled;
                        sslset.verify = true;
                  }
#line 3881 "src/y.tab.c"
    break;

  case 254:
#line 827 "src/p.y"
                                     {
                        sslset.flags = SSL_Enabled;
                        sslset.verify = false;
                  }
#line 3890 "src/y.tab.c"
    break;

  case 255:
#line 831 "src/p.y"
                                       {
                        sslset.flags = SSL_Enabled;
                        sslset.allowSelfSigned = true;
                  }
#line 3899 "src/y.tab.c"
    break;

  case 256:
#line 835 "src/p.y"
                                           {
                        sslset.flags = SSL_Enabled;
                        sslset.allowSelfSigned = false;
                  }
#line 3908 "src/y.tab.c"
    break;

  case 257:
#line 839 "src/p.y"
                                                {
                        sslset.flags = SSL_Enabled;
                  }
#line 3916 "src/y.tab.c"
    break;

  case 258:
#line 842 "src/p.y"
                                    {
                        FREE(sslset.ciphers);
                        sslset.ciphers = (yyvsp[0].string);
                  }
#line 3925 "src/y.tab.c"
    break;

  case 259:
#line 846 "src/p.y"
                                   {
                        _setPEM(&(sslset.pemfile), (yyvsp[0].string), "SSL server PEM file", true);
                  }
#line 3933 "src/y.tab.c"
    break;

  case 260:
#line 849 "src/p.y"
                                    {
                        _setPEM(&(sslset.pemchain), (yyvsp[0].string), "SSL certificate chain PEM file", true);
                  }
#line 3941 "src/y.tab.c"
    break;

  case 261:
#line 852 "src/p.y"
                                  {
                        _setPEM(&(sslset.pemkey), (yyvsp[0].string), "SSL server private key PEM file", true);
                  }
#line 3949 "src/y.tab.c"
    break;

  case 262:
#line 855 "src/p.y"
                                         {
                        _setPEM(&(sslset.clientpemfile), (yyvsp[0].string), "SSL client PEM file", true);
                  }
#line 3957 "src/y.tab.c"
    break;

  case 263:
#line 858 "src/p.y"
                                             {
                        _setPEM(&(sslset.CACertificateFile), (yyvsp[0].string), "SSL CA certificates file", true);
                  }
#line 3965 "src/y.tab.c"
    break;

  case 264:
#line 861 "src/p.y"
                                             {
                        _setPEM(&(sslset.CACertificatePath), (yyvsp[0].string), "SSL CA certificates directory", false);
                  }
#line 3973 "src/y.tab.c"
    break;

  case 265:
#line 866 "src/p.y"
                                                              {
                        sslset.flags = SSL_Enabled;
                        portset.target.net.ssl.certificate.minimumDays = (yyvsp[-1].number);
                  }
#line 3982 "src/y.tab.c"
    break;

  case 268:
#line 876 "src/p.y"
                                                               {
                        sslset.flags = SSL_Enabled;
                        sslset.checksum = (yyvsp[0].string);
                        switch (cleanup_hash_string(sslset.checksum)) {
                                case 32:
                                        sslset.checksumType = Hash_Md5;
                                        break;
                                case 40:
                                        sslset.checksumType = Hash_Sha1;
                                        break;
                                default:
                                        yyerror2("Unknown checksum type: [%s] is not MD5 nor SHA1", sslset.checksum);
                        }
                  }
#line 4001 "src/y.tab.c"
    break;

  case 269:
#line 890 "src/p.y"
                                                                       {
                        sslset.flags = SSL_Enabled;
                        sslset.checksum = (yyvsp[0].string);
                        if (cleanup_hash_string(sslset.checksum) != 32)
                                yyerror2("Unknown checksum type: [%s] is not MD5", sslset.checksum);
                        sslset.checksumType = Hash_Md5;
                  }
#line 4013 "src/y.tab.c"
    break;

  case 270:
#line 897 "src/p.y"
                                                                        {
                        sslset.flags = SSL_Enabled;
                        sslset.checksum = (yyvsp[0].string);
                        if (cleanup_hash_string(sslset.checksum) != 40)
                                yyerror2("Unknown checksum type: [%s] is not SHA1", sslset.checksum);
                        sslset.checksumType = Hash_Sha1;
                  }
#line 4025 "src/y.tab.c"
    break;

  case 275:
#line 914 "src/p.y"
                        {
#if defined OPENSSL_NO_SSL2 || ! defined HAVE_SSLV2 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support SSL version 2");
#else
                        _setSSLVersion(SSL_V2);
#endif
                  }
#line 4037 "src/y.tab.c"
    break;

  case 276:
#line 921 "src/p.y"
                          {
                        _unsetSSLVersion(SSL_V2);
                  }
#line 4045 "src/y.tab.c"
    break;

  case 277:
#line 924 "src/p.y"
                        {
#if defined OPENSSL_NO_SSL3 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support SSL version 3");
#else
                        _setSSLVersion(SSL_V3);
#endif
                  }
#line 4057 "src/y.tab.c"
    break;

  case 278:
#line 931 "src/p.y"
                          {
                        _unsetSSLVersion(SSL_V3);
                  }
#line 4065 "src/y.tab.c"
    break;

  case 279:
#line 934 "src/p.y"
                        {
#if defined OPENSSL_NO_TLS1_METHOD || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support TLS version 1.0");
#else
                        _setSSLVersion(SSL_TLSV1);
#endif
                  }
#line 4077 "src/y.tab.c"
    break;

  case 280:
#line 941 "src/p.y"
                          {
                        _unsetSSLVersion(SSL_TLSV1);
                  }
#line 4085 "src/y.tab.c"
    break;

  case 281:
#line 944 "src/p.y"
                         {
#if defined OPENSSL_NO_TLS1_1_METHOD || ! defined HAVE_TLSV1_1 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support TLS version 1.1");
#else
                        _setSSLVersion(SSL_TLSV11);
#endif
                }
#line 4097 "src/y.tab.c"
    break;

  case 282:
#line 951 "src/p.y"
                           {
                        _unsetSSLVersion(SSL_TLSV11);
                  }
#line 4105 "src/y.tab.c"
    break;

  case 283:
#line 954 "src/p.y"
                         {
#if defined OPENSSL_NO_TLS1_2_METHOD || ! defined HAVE_TLSV1_2 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support TLS version 1.2");
#else
                        _setSSLVersion(SSL_TLSV12);
#endif
                }
#line 4117 "src/y.tab.c"
    break;

  case 284:
#line 961 "src/p.y"
                           {
                        _unsetSSLVersion(SSL_TLSV12);
                  }
#line 4125 "src/y.tab.c"
    break;

  case 285:
#line 964 "src/p.y"
                         {
#if defined OPENSSL_NO_TLS1_3_METHOD || ! defined HAVE_TLSV1_3 || ! defined HAVE_OPENSSL
                        yyerror("Your SSL Library does not support TLS version 1.3");
#else
                        _setSSLVersion(SSL_TLSV13);
#endif
                }
#line 4137 "src/y.tab.c"
    break;

  case 286:
#line 971 "src/p.y"
                           {
                        _unsetSSLVersion(SSL_TLSV13);
                  }
#line 4145 "src/y.tab.c"
    break;

  case 287:
#line 974 "src/p.y"
                       {
                        // Enable just TLS 1.2 and 1.3 by default
#if ! defined OPENSSL_NO_TLS1_2_METHOD && defined HAVE_TLSV1_2 && defined HAVE_OPENSSL
                        _setSSLVersion(SSL_TLSV12);
#endif
#if ! defined OPENSSL_NO_TLS1_3_METHOD && defined HAVE_TLSV1_3 && defined HAVE_OPENSSL
                        _setSSLVersion(SSL_TLSV13);
#endif
                  }
#line 4159 "src/y.tab.c"
    break;

  case 288:
#line 985 "src/p.y"
                                 { // Backward compatibility
                        sslset.flags = SSL_Enabled;
                        sslset.checksum = (yyvsp[0].string);
                        if (cleanup_hash_string(sslset.checksum) != 32)
                                yyerror2("Unknown checksum type: [%s] is not MD5", sslset.checksum);
                        sslset.checksumType = Hash_Md5;
                  }
#line 4171 "src/y.tab.c"
    break;

  case 289:
#line 994 "src/p.y"
                                                                    {
                        if (((yyvsp[-1].number)) > SMTP_TIMEOUT)
                                Run.mailserver_timeout = (yyvsp[-1].number);
                        Run.mail_hostname = (yyvsp[0].string);
                  }
#line 4181 "src/y.tab.c"
    break;

  case 290:
#line 1001 "src/p.y"
                                                          {
                        if (mailset.from) {
                                Run.MailFormat.from = mailset.from;
                        } else {
                                Run.MailFormat.from = Address_new();
                                Run.MailFormat.from->address = Str_dup(ALERT_FROM);
                        }
                        if (mailset.replyto)
                                Run.MailFormat.replyto = mailset.replyto;
                        Run.MailFormat.subject = mailset.subject ?  mailset.subject : Str_dup(ALERT_SUBJECT);
                        Run.MailFormat.message = mailset.message ?  mailset.message : Str_dup(ALERT_MESSAGE);
                        reset_mailset();
                  }
#line 4199 "src/y.tab.c"
    break;

  case 293:
#line 1020 "src/p.y"
                                           {
                        /* Restore the current text overridden by lookahead */
                        FREE(argyytext);
                        argyytext = Str_dup((yyvsp[-1].string));

                        mailserverset.host = (yyvsp[-1].string);
                        mailserverset.port = PORT_SMTP;
                        addmailserver(&mailserverset);
                  }
#line 4213 "src/y.tab.c"
    break;

  case 294:
#line 1029 "src/p.y"
                                                       {
                        /* Restore the current text overridden by lookahead */
                        FREE(argyytext);
                        argyytext = Str_dup((yyvsp[-3].string));

                        mailserverset.host = (yyvsp[-3].string);
                        mailserverset.port = (yyvsp[-1].number);
                        addmailserver(&mailserverset);
                  }
#line 4227 "src/y.tab.c"
    break;

  case 297:
#line 1044 "src/p.y"
                           {
                        mailserverset.username = (yyvsp[0].string);
                  }
#line 4235 "src/y.tab.c"
    break;

  case 298:
#line 1047 "src/p.y"
                           {
                        mailserverset.password = (yyvsp[0].string);
                  }
#line 4243 "src/y.tab.c"
    break;

  case 303:
#line 1056 "src/p.y"
                                      {
                        if (sslset.flags & SSL_Enabled) {
#ifdef HAVE_OPENSSL
                                if (sslset.pemfile) {
                                        if (sslset.pemchain || sslset.pemkey) {
                                                yyerror("SSL server option pemfile and pemchain|pemkey are mutually exclusive");
                                        } else if (! file_checkStat(sslset.pemfile, "SSL server PEM file", S_IRWXU | S_IRGRP | S_IXGRP)) {
                                                yyerror("SSL server PEM file permissions check failed");
                                        } else {
                                                _setSSLOptions(&(Run.httpd.socket.net.ssl));
                                        }
                                } else if (sslset.pemchain && sslset.pemkey) {
                                        if (! file_checkStat(sslset.pemkey, "SSL server private key PEM file", S_IRWXU | S_IRGRP | S_IXGRP)) {
                                                yyerror("SSL server private key PEM file permissions check failed");
                                        } else {
                                                _setSSLOptions(&(Run.httpd.socket.net.ssl));
                                        }
                                } else {
                                        yyerror("SSL server PEM file is required (please use ssl pemfile option)");
                                }
#else
                                yyerror("SSL is not supported");
#endif
                        }
                  }
#line 4273 "src/y.tab.c"
    break;

  case 315:
#line 1099 "src/p.y"
                               {
                        _setPEM(&(sslset.pemfile), (yyvsp[0].string), "SSL server PEM file", true);
                  }
#line 4281 "src/y.tab.c"
    break;

  case 316:
#line 1105 "src/p.y"
                                     {
                        _setPEM(&(sslset.clientpemfile), (yyvsp[0].string), "SSL client PEM file", true);
                  }
#line 4289 "src/y.tab.c"
    break;

  case 317:
#line 1111 "src/p.y"
                                         {
                        sslset.flags = SSL_Enabled;
                        sslset.allowSelfSigned = true;
                  }
#line 4298 "src/y.tab.c"
    break;

  case 318:
#line 1117 "src/p.y"
                                       {
                        Run.httpd.flags |= Httpd_Net;
                        Run.httpd.socket.net.port = (yyvsp[-1].number);
                        Run.httpd.socket.net.readonly = (yyvsp[0].number);
                  }
#line 4308 "src/y.tab.c"
    break;

  case 319:
#line 1124 "src/p.y"
                                                        {
                        Run.httpd.flags |= Httpd_Unix;
                        Run.httpd.socket.unix.path = (yyvsp[-1].string);
                  }
#line 4317 "src/y.tab.c"
    break;

  case 322:
#line 1134 "src/p.y"
                               {
                        Run.httpd.flags |= Httpd_UnixUid;
                        Run.httpd.socket.unix.uid = get_uid((yyvsp[0].string), 0);
                        FREE((yyvsp[0].string));
                    }
#line 4327 "src/y.tab.c"
    break;

  case 323:
#line 1139 "src/p.y"
                               {
                        Run.httpd.flags |= Httpd_UnixGid;
                        Run.httpd.socket.unix.gid = get_gid((yyvsp[0].string), 0);
                        FREE((yyvsp[0].string));
                    }
#line 4337 "src/y.tab.c"
    break;

  case 324:
#line 1144 "src/p.y"
                               {
                        Run.httpd.flags |= Httpd_UnixUid;
                        Run.httpd.socket.unix.uid = get_uid(NULL, (yyvsp[0].number));
                    }
#line 4346 "src/y.tab.c"
    break;

  case 325:
#line 1148 "src/p.y"
                               {
                        Run.httpd.flags |= Httpd_UnixGid;
                        Run.httpd.socket.unix.gid = get_gid(NULL, (yyvsp[0].number));
                    }
#line 4355 "src/y.tab.c"
    break;

  case 326:
#line 1152 "src/p.y"
                                      {
                        Run.httpd.flags |= Httpd_UnixPermission;
                        Run.httpd.socket.unix.permission = check_perm((yyvsp[0].number));
                    }
#line 4364 "src/y.tab.c"
    break;

  case 327:
#line 1156 "src/p.y"
                             {
                        Run.httpd.socket.unix.readonly = true;
                    }
#line 4372 "src/y.tab.c"
    break;

  case 332:
#line 1169 "src/p.y"
                             {
                        Run.httpd.flags |= Httpd_Signature;
                  }
#line 4380 "src/y.tab.c"
    break;

  case 333:
#line 1172 "src/p.y"
                             {
                        Run.httpd.flags &= ~Httpd_Signature;
                  }
#line 4388 "src/y.tab.c"
    break;

  case 334:
#line 1177 "src/p.y"
                                 {
                        if (Run.httpd.socket.net.address) {
                                yywarning2("The 'address' option can be specified only once, the last value will be used\n");
                                FREE(Run.httpd.socket.net.address);
                        }
                        Run.httpd.socket.net.address = (yyvsp[0].string);
                  }
#line 4400 "src/y.tab.c"
    break;

  case 335:
#line 1186 "src/p.y"
                                                 {
                        addcredentials((yyvsp[-3].string), (yyvsp[-1].string), Digest_Cleartext, (yyvsp[0].number));
                  }
#line 4408 "src/y.tab.c"
    break;

  case 336:
#line 1189 "src/p.y"
                                           {
#ifdef HAVE_LIBPAM
                        addpamauth((yyvsp[-1].string), (yyvsp[0].number));
#else
                        yyerror("PAM is not supported");
                        FREE((yyvsp[-1].string));
#endif
                  }
#line 4421 "src/y.tab.c"
    break;

  case 337:
#line 1197 "src/p.y"
                             {
                        addhtpasswdentry((yyvsp[0].string), NULL, Digest_Cleartext);
                        FREE((yyvsp[0].string));
                  }
#line 4430 "src/y.tab.c"
    break;

  case 338:
#line 1201 "src/p.y"
                                       {
                        addhtpasswdentry((yyvsp[0].string), NULL, Digest_Cleartext);
                        FREE((yyvsp[0].string));
                  }
#line 4439 "src/y.tab.c"
    break;

  case 339:
#line 1205 "src/p.y"
                                     {
                        addhtpasswdentry((yyvsp[0].string), NULL, Digest_Md5);
                        FREE((yyvsp[0].string));
                  }
#line 4448 "src/y.tab.c"
    break;

  case 340:
#line 1209 "src/p.y"
                                   {
                        addhtpasswdentry((yyvsp[0].string), NULL, Digest_Crypt);
                        FREE((yyvsp[0].string));
                  }
#line 4457 "src/y.tab.c"
    break;

  case 341:
#line 1213 "src/p.y"
                             {
                        htpasswd_file = (yyvsp[0].string);
                        digesttype = Digest_Cleartext;
                  }
#line 4466 "src/y.tab.c"
    break;

  case 342:
#line 1217 "src/p.y"
                                {
                        FREE(htpasswd_file);
                  }
#line 4474 "src/y.tab.c"
    break;

  case 343:
#line 1220 "src/p.y"
                                       {
                        htpasswd_file = (yyvsp[0].string);
                        digesttype = Digest_Cleartext;
                  }
#line 4483 "src/y.tab.c"
    break;

  case 344:
#line 1224 "src/p.y"
                                {
                        FREE(htpasswd_file);
                  }
#line 4491 "src/y.tab.c"
    break;

  case 345:
#line 1227 "src/p.y"
                                     {
                        htpasswd_file = (yyvsp[0].string);
                        digesttype = Digest_Md5;
                  }
#line 4500 "src/y.tab.c"
    break;

  case 346:
#line 1231 "src/p.y"
                                {
                        FREE(htpasswd_file);
                  }
#line 4508 "src/y.tab.c"
    break;

  case 347:
#line 1234 "src/p.y"
                                   {
                        htpasswd_file = (yyvsp[0].string);
                        digesttype = Digest_Crypt;
                  }
#line 4517 "src/y.tab.c"
    break;

  case 348:
#line 1238 "src/p.y"
                                {
                        FREE(htpasswd_file);
                  }
#line 4525 "src/y.tab.c"
    break;

  case 349:
#line 1241 "src/p.y"
                               {
                        if (! Engine_addAllow((yyvsp[0].string)))
                                yywarning2("invalid allow option: %s", (yyvsp[0].string));
                        FREE((yyvsp[0].string));
                  }
#line 4535 "src/y.tab.c"
    break;

  case 352:
#line 1252 "src/p.y"
                         {
                        addhtpasswdentry(htpasswd_file, (yyvsp[0].string), digesttype);
                        FREE((yyvsp[0].string));
                  }
#line 4544 "src/y.tab.c"
    break;

  case 353:
#line 1258 "src/p.y"
                              {
                        (yyval.number) = false;
                  }
#line 4552 "src/y.tab.c"
    break;

  case 354:
#line 1261 "src/p.y"
                           {
                        (yyval.number) = true;
                  }
#line 4560 "src/y.tab.c"
    break;

  case 355:
#line 1266 "src/p.y"
                                                     {
                        createservice(Service_Process, (yyvsp[-2].string), (yyvsp[0].string), check_process);
                  }
#line 4568 "src/y.tab.c"
    break;

  case 356:
#line 1269 "src/p.y"
                                                     {
                        createservice(Service_Process, (yyvsp[-2].string), (yyvsp[0].string), check_process);
                  }
#line 4576 "src/y.tab.c"
    break;

  case 357:
#line 1272 "src/p.y"
                                                     {
                        createservice(Service_Process, (yyvsp[-2].string), (yyvsp[0].string), check_process);
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = Str_dup((yyvsp[0].string));
                        addmatch(&matchset, Action_Ignored, 0);
                  }
#line 4588 "src/y.tab.c"
    break;

  case 358:
#line 1279 "src/p.y"
                                                   {
                        createservice(Service_Process, (yyvsp[-2].string), (yyvsp[0].string), check_process);
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = Str_dup((yyvsp[0].string));
                        addmatch(&matchset, Action_Ignored, 0);
                  }
#line 4600 "src/y.tab.c"
    break;

  case 359:
#line 1288 "src/p.y"
                                                     {
                        createservice(Service_File, (yyvsp[-2].string), (yyvsp[0].string), check_file);
                  }
#line 4608 "src/y.tab.c"
    break;

  case 360:
#line 1293 "src/p.y"
                                                        {
                        createservice(Service_Filesystem, (yyvsp[-2].string), (yyvsp[0].string), check_filesystem);
                  }
#line 4616 "src/y.tab.c"
    break;

  case 361:
#line 1296 "src/p.y"
                                                          {
                        createservice(Service_Filesystem, (yyvsp[-2].string), (yyvsp[0].string), check_filesystem);
                  }
#line 4624 "src/y.tab.c"
    break;

  case 362:
#line 1301 "src/p.y"
                                                    {
                        createservice(Service_Directory, (yyvsp[-2].string), (yyvsp[0].string), check_directory);
                  }
#line 4632 "src/y.tab.c"
    break;

  case 363:
#line 1306 "src/p.y"
                                                       {
                        createservice(Service_Host, (yyvsp[-2].string), (yyvsp[0].string), check_remote_host);
                  }
#line 4640 "src/y.tab.c"
    break;

  case 364:
#line 1311 "src/p.y"
                                                      {
                        if (Link_isGetByAddressSupported()) {
                                createservice(Service_Net, (yyvsp[-2].string), (yyvsp[0].string), check_net);
                                current->inf.net->stats = Link_createForAddress((yyvsp[0].string));
                        } else {
                                yyerror("Network monitoring by IP address is not supported on this platform, please use 'check network <foo> with interface <bar>' instead");
                        }
                  }
#line 4653 "src/y.tab.c"
    break;

  case 365:
#line 1319 "src/p.y"
                                                        {
                        createservice(Service_Net, (yyvsp[-2].string), (yyvsp[0].string), check_net);
                        current->inf.net->stats = Link_createForInterface((yyvsp[0].string));
                  }
#line 4662 "src/y.tab.c"
    break;

  case 366:
#line 1325 "src/p.y"
                                          {
                        char *servicename = (yyvsp[0].string);
                        if (Str_sub(servicename, "$HOST")) {
                                char hostname[STRLEN];
                                if (gethostname(hostname, sizeof(hostname))) {
                                        Log_error("System hostname error -- %s\n", STRERROR);
                                        cfg_errflag++;
                                } else {
                                        Util_replaceString(&servicename, "$HOST", hostname);
                                }
                        }
                        Run.system = createservice(Service_System, servicename, NULL, check_system); // The name given in the 'check system' statement overrides system hostname
                  }
#line 4680 "src/y.tab.c"
    break;

  case 367:
#line 1340 "src/p.y"
                                                     {
                        createservice(Service_Fifo, (yyvsp[-2].string), (yyvsp[0].string), check_fifo);
                  }
#line 4688 "src/y.tab.c"
    break;

  case 368:
#line 1345 "src/p.y"
                                                                               {
                        createservice(Service_Program, (yyvsp[-3].string), NULL, check_program);
                        current->program->timeout = (yyvsp[0].number);
                        current->program->lastOutput = StringBuffer_create(64);
                        current->program->inprogressOutput = StringBuffer_create(64);
                 }
#line 4699 "src/y.tab.c"
    break;

  case 369:
#line 1351 "src/p.y"
                                                                                              {
                        createservice(Service_Program, (yyvsp[-4].string), NULL, check_program);
                        current->program->timeout = (yyvsp[0].number);
                        current->program->lastOutput = StringBuffer_create(64);
                        current->program->inprogressOutput = StringBuffer_create(64);
                 }
#line 4710 "src/y.tab.c"
    break;

  case 370:
#line 1359 "src/p.y"
                                                  {
                        addcommand(START, (yyvsp[0].number));
                  }
#line 4718 "src/y.tab.c"
    break;

  case 371:
#line 1362 "src/p.y"
                                                                 {
                        addcommand(START, (yyvsp[0].number));
                  }
#line 4726 "src/y.tab.c"
    break;

  case 372:
#line 1367 "src/p.y"
                                                {
                        addcommand(STOP, (yyvsp[0].number));
                  }
#line 4734 "src/y.tab.c"
    break;

  case 373:
#line 1370 "src/p.y"
                                                               {
                        addcommand(STOP, (yyvsp[0].number));
                  }
#line 4742 "src/y.tab.c"
    break;

  case 374:
#line 1376 "src/p.y"
                                                      {
                        addcommand(RESTART, (yyvsp[0].number));
                  }
#line 4750 "src/y.tab.c"
    break;

  case 375:
#line 1379 "src/p.y"
                                                                     {
                        addcommand(RESTART, (yyvsp[0].number));
                  }
#line 4758 "src/y.tab.c"
    break;

  case 380:
#line 1392 "src/p.y"
                         {
                        addargument((yyvsp[0].string));
                  }
#line 4766 "src/y.tab.c"
    break;

  case 381:
#line 1395 "src/p.y"
                       {
                        addargument((yyvsp[0].string));
                  }
#line 4774 "src/y.tab.c"
    break;

  case 382:
#line 1400 "src/p.y"
                             {
                        addeuid(get_uid((yyvsp[0].string), 0));
                        FREE((yyvsp[0].string));
                  }
#line 4783 "src/y.tab.c"
    break;

  case 383:
#line 1404 "src/p.y"
                             {
                        addegid(get_gid((yyvsp[0].string), 0));
                        FREE((yyvsp[0].string));
                  }
#line 4792 "src/y.tab.c"
    break;

  case 384:
#line 1408 "src/p.y"
                             {
                        addeuid(get_uid(NULL, (yyvsp[0].number)));
                  }
#line 4800 "src/y.tab.c"
    break;

  case 385:
#line 1411 "src/p.y"
                             {
                        addegid(get_gid(NULL, (yyvsp[0].number)));
                  }
#line 4808 "src/y.tab.c"
    break;

  case 386:
#line 1416 "src/p.y"
                                    {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4816 "src/y.tab.c"
    break;

  case 387:
#line 1419 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4824 "src/y.tab.c"
    break;

  case 388:
#line 1424 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4832 "src/y.tab.c"
    break;

  case 389:
#line 1429 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4840 "src/y.tab.c"
    break;

  case 390:
#line 1434 "src/p.y"
                                  {
                        (yyval.string) = NULL;
                  }
#line 4848 "src/y.tab.c"
    break;

  case 391:
#line 1437 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 4856 "src/y.tab.c"
    break;

  case 392:
#line 1442 "src/p.y"
                                                                                            {
                        /* This is a workaround to support content match without having to create an URL object. 'urloption' creates the Request_T object we need minus the URL object, but with enough information to perform content test.
                           TODO: Parser is in need of refactoring */
                        portset.url_request = urlrequest;
                        portset.check_invers = false;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->portlist), &portset);
                  }
#line 4871 "src/y.tab.c"
    break;

  case 393:
#line 1452 "src/p.y"
                                                                                               {
                        portset.url_request = urlrequest;
                        portset.check_invers = true;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->portlist), &portset);
                  }
#line 4884 "src/y.tab.c"
    break;

  case 408:
#line 1480 "src/p.y"
                                                                                                   {
                        portset.check_invers = false;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        prepare_urlrequest((yyvsp[-5].url));
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->portlist), &portset);
                  }
#line 4897 "src/y.tab.c"
    break;

  case 409:
#line 1488 "src/p.y"
                                                                                                      {
                        portset.check_invers = true;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        prepare_urlrequest((yyvsp[-5].url));
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->portlist), &portset);
                  }
#line 4910 "src/y.tab.c"
    break;

  case 418:
#line 1510 "src/p.y"
                                                                                               {
                        portset.check_invers = false;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->socketlist), &portset);
                  }
#line 4922 "src/y.tab.c"
    break;

  case 419:
#line 1517 "src/p.y"
                                                                                                  {
                        portset.check_invers = true;
                        portset.responsetime.operator = responsetimeset.operator;
                        portset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(portset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addport(&(current->socketlist), &portset);
                  }
#line 4934 "src/y.tab.c"
    break;

  case 428:
#line 1538 "src/p.y"
                                                                                          {
                        icmpset.family = Socket_Ip;
                        icmpset.check_invers = false;
                        icmpset.type = (yyvsp[-5].number);
                        icmpset.responsetime.operator = responsetimeset.operator;
                        icmpset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                  }
#line 4948 "src/y.tab.c"
    break;

  case 429:
#line 1547 "src/p.y"
                                                                                 {
                        icmpset.family = Socket_Ip;
                        icmpset.check_invers = false;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 4959 "src/y.tab.c"
    break;

  case 430:
#line 1553 "src/p.y"
                                                                                  {
                        icmpset.family = Socket_Ip4;
                        icmpset.check_invers = false;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 4970 "src/y.tab.c"
    break;

  case 431:
#line 1559 "src/p.y"
                                                                                  {
                        icmpset.family = Socket_Ip6;
                        icmpset.check_invers = false;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 4981 "src/y.tab.c"
    break;

  case 432:
#line 1565 "src/p.y"
                                                                                             {
                        icmpset.family = Socket_Ip;
                        icmpset.check_invers = true;
                        icmpset.type = (yyvsp[-5].number);
                        icmpset.responsetime.operator = responsetimeset.operator;
                        icmpset.responsetime.limit = responsetimeset.limit;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                  }
#line 4995 "src/y.tab.c"
    break;

  case 433:
#line 1574 "src/p.y"
                                                                                    {
                        icmpset.family = Socket_Ip;
                        icmpset.check_invers = true;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 5006 "src/y.tab.c"
    break;

  case 434:
#line 1580 "src/p.y"
                                                                                     {
                        icmpset.family = Socket_Ip4;
                        icmpset.check_invers = true;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 5017 "src/y.tab.c"
    break;

  case 435:
#line 1586 "src/p.y"
                                                                                     {
                        icmpset.family = Socket_Ip6;
                        icmpset.check_invers = true;
                        addeventaction(&(icmpset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addicmp(&icmpset);
                 }
#line 5028 "src/y.tab.c"
    break;

  case 442:
#line 1604 "src/p.y"
                              {
                        portset.hostname = Str_dup(current->type == Service_Host ? current->path : LOCALHOST);
                  }
#line 5036 "src/y.tab.c"
    break;

  case 443:
#line 1607 "src/p.y"
                              {
                        portset.hostname = (yyvsp[0].string);
                  }
#line 5044 "src/y.tab.c"
    break;

  case 444:
#line 1612 "src/p.y"
                              {
                        portset.target.net.port = (yyvsp[0].number);
                  }
#line 5052 "src/y.tab.c"
    break;

  case 445:
#line 1617 "src/p.y"
                                  {
                        portset.family = Socket_Unix;
                        portset.target.unix.pathname = (yyvsp[0].string);
                  }
#line 5061 "src/y.tab.c"
    break;

  case 446:
#line 1623 "src/p.y"
                       {
                        portset.family = Socket_Ip4;
                  }
#line 5069 "src/y.tab.c"
    break;

  case 447:
#line 1626 "src/p.y"
                       {
                        portset.family = Socket_Ip6;
                  }
#line 5077 "src/y.tab.c"
    break;

  case 448:
#line 1631 "src/p.y"
                           {
                        portset.type = Socket_Tcp;
                  }
#line 5085 "src/y.tab.c"
    break;

  case 449:
#line 1634 "src/p.y"
                                          { // The typelist is kept for backward compatibility (replaced by ssloptionlist)
                        portset.type = Socket_Tcp;
                        sslset.flags = SSL_Enabled;
                  }
#line 5094 "src/y.tab.c"
    break;

  case 450:
#line 1638 "src/p.y"
                           {
                        portset.type = Socket_Udp;
                  }
#line 5102 "src/y.tab.c"
    break;

  case 455:
#line 1651 "src/p.y"
                                 {
                        _parseOutgoingAddress((yyvsp[0].string), &(portset.outgoing));
                  }
#line 5110 "src/y.tab.c"
    break;

  case 456:
#line 1656 "src/p.y"
                                                         {
                        portset.protocol = Protocol_get(Protocol_APACHESTATUS);
                  }
#line 5118 "src/y.tab.c"
    break;

  case 457:
#line 1659 "src/p.y"
                                  {
                        portset.protocol = Protocol_get(Protocol_CLAMAV);
                  }
#line 5126 "src/y.tab.c"
    break;

  case 458:
#line 1662 "src/p.y"
                                   {
                        portset.protocol = Protocol_get(Protocol_DEFAULT);
                  }
#line 5134 "src/y.tab.c"
    break;

  case 459:
#line 1665 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_DNS);
                  }
#line 5142 "src/y.tab.c"
    break;

  case 460:
#line 1668 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_DWP);
                  }
#line 5150 "src/y.tab.c"
    break;

  case 461:
#line 1671 "src/p.y"
                                    {
                        portset.protocol = Protocol_get(Protocol_FAIL2BAN);
                }
#line 5158 "src/y.tab.c"
    break;

  case 462:
#line 1674 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_FTP);
                  }
#line 5166 "src/y.tab.c"
    break;

  case 463:
#line 1677 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_GPS);
                  }
#line 5174 "src/y.tab.c"
    break;

  case 464:
#line 1680 "src/p.y"
                                         {
                        portset.protocol = Protocol_get(Protocol_HTTP);
                  }
#line 5182 "src/y.tab.c"
    break;

  case 465:
#line 1683 "src/p.y"
                                          {
                        sslset.flags = SSL_Enabled;
                        portset.type = Socket_Tcp;
                        portset.protocol = Protocol_get(Protocol_HTTP);
                 }
#line 5192 "src/y.tab.c"
    break;

  case 466:
#line 1688 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_IMAP);
                  }
#line 5200 "src/y.tab.c"
    break;

  case 467:
#line 1691 "src/p.y"
                                 {
                        sslset.flags = SSL_Enabled;
                        portset.type = Socket_Tcp;
                        portset.protocol = Protocol_get(Protocol_IMAP);
                  }
#line 5210 "src/y.tab.c"
    break;

  case 468:
#line 1696 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_LDAP2);
                  }
#line 5218 "src/y.tab.c"
    break;

  case 469:
#line 1699 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_LDAP3);
                  }
#line 5226 "src/y.tab.c"
    break;

  case 470:
#line 1702 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_LMTP);
                  }
#line 5234 "src/y.tab.c"
    break;

  case 471:
#line 1705 "src/p.y"
                                    {
                        portset.protocol = Protocol_get(Protocol_MEMCACHE);
                  }
#line 5242 "src/y.tab.c"
    break;

  case 472:
#line 1708 "src/p.y"
                                    {
                        portset.protocol = Protocol_get(Protocol_MONGODB);
                  }
#line 5250 "src/y.tab.c"
    break;

  case 473:
#line 1711 "src/p.y"
                                         {
                        portset.protocol = Protocol_get(Protocol_MQTT);
                  }
#line 5258 "src/y.tab.c"
    break;

  case 474:
#line 1714 "src/p.y"
                                           {
                        portset.protocol = Protocol_get(Protocol_MYSQL);
                  }
#line 5266 "src/y.tab.c"
    break;

  case 475:
#line 1717 "src/p.y"
                                            {
                        sslset.flags = SSL_StartTLS;
                        portset.protocol = Protocol_get(Protocol_MYSQL);
                  }
#line 5275 "src/y.tab.c"
    break;

  case 476:
#line 1721 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_NNTP);
                  }
#line 5283 "src/y.tab.c"
    break;

  case 477:
#line 1724 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_NTP3);
                        portset.type = Socket_Udp;
                  }
#line 5292 "src/y.tab.c"
    break;

  case 478:
#line 1728 "src/p.y"
                                                {
                        portset.protocol = Protocol_get(Protocol_PGSQL);
                  }
#line 5300 "src/y.tab.c"
    break;

  case 479:
#line 1731 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_POP);
                  }
#line 5308 "src/y.tab.c"
    break;

  case 480:
#line 1734 "src/p.y"
                                {
                        sslset.flags = SSL_Enabled;
                        portset.type = Socket_Tcp;
                        portset.protocol = Protocol_get(Protocol_POP);
                  }
#line 5318 "src/y.tab.c"
    break;

  case 481:
#line 1739 "src/p.y"
                                         {
                        portset.protocol = Protocol_get(Protocol_POSTFIXPOLICY);
                  }
#line 5326 "src/y.tab.c"
    break;

  case 482:
#line 1742 "src/p.y"
                                             {
                        portset.protocol = Protocol_get(Protocol_RADIUS);
                  }
#line 5334 "src/y.tab.c"
    break;

  case 483:
#line 1745 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_RDATE);
                  }
#line 5342 "src/y.tab.c"
    break;

  case 484:
#line 1748 "src/p.y"
                                  {
                        portset.protocol = Protocol_get(Protocol_REDIS);
                  }
#line 5350 "src/y.tab.c"
    break;

  case 485:
#line 1751 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_RSYNC);
                  }
#line 5358 "src/y.tab.c"
    break;

  case 486:
#line 1754 "src/p.y"
                                 {
                        portset.protocol = Protocol_get(Protocol_SIEVE);
                  }
#line 5366 "src/y.tab.c"
    break;

  case 487:
#line 1757 "src/p.y"
                                       {
                        portset.protocol = Protocol_get(Protocol_SIP);
                  }
#line 5374 "src/y.tab.c"
    break;

  case 488:
#line 1760 "src/p.y"
                                         {
                        portset.protocol = Protocol_get(Protocol_SMTP);
                  }
#line 5382 "src/y.tab.c"
    break;

  case 489:
#line 1763 "src/p.y"
                                          {
                        sslset.flags = SSL_Enabled;
                        portset.type = Socket_Tcp;
                        portset.protocol = Protocol_get(Protocol_SMTP);
                 }
#line 5392 "src/y.tab.c"
    break;

  case 490:
#line 1768 "src/p.y"
                                        {
                        portset.protocol = Protocol_get(Protocol_SPAMASSASSIN);
                  }
#line 5400 "src/y.tab.c"
    break;

  case 491:
#line 1771 "src/p.y"
                                {
                        portset.protocol = Protocol_get(Protocol_SSH);
                  }
#line 5408 "src/y.tab.c"
    break;

  case 492:
#line 1774 "src/p.y"
                               {
                        portset.protocol = Protocol_get(Protocol_TNS);
                  }
#line 5416 "src/y.tab.c"
    break;

  case 493:
#line 1777 "src/p.y"
                                                   {
                        portset.protocol = Protocol_get(Protocol_WEBSOCKET);
                  }
#line 5424 "src/y.tab.c"
    break;

  case 494:
#line 1782 "src/p.y"
                              {
                        if (portset.protocol->check == check_default || portset.protocol->check == check_generic) {
                                portset.protocol = Protocol_get(Protocol_GENERIC);
                                addgeneric(&portset, (yyvsp[0].string), NULL);
                        } else {
                                yyerror("The SEND statement is not allowed in the %s protocol context", portset.protocol->name);
                        }
                  }
#line 5437 "src/y.tab.c"
    break;

  case 495:
#line 1790 "src/p.y"
                                {
                        if (portset.protocol->check == check_default || portset.protocol->check == check_generic) {
                                portset.protocol = Protocol_get(Protocol_GENERIC);
                                addgeneric(&portset, NULL, (yyvsp[0].string));
                        } else {
                                yyerror("The EXPECT statement is not allowed in the %s protocol context", portset.protocol->name);
                        }
                  }
#line 5450 "src/y.tab.c"
    break;

  case 498:
#line 1804 "src/p.y"
                                {
                        portset.parameters.websocket.origin = (yyvsp[0].string);
                  }
#line 5458 "src/y.tab.c"
    break;

  case 499:
#line 1807 "src/p.y"
                               {
                        portset.parameters.websocket.request = (yyvsp[0].string);
                  }
#line 5466 "src/y.tab.c"
    break;

  case 500:
#line 1810 "src/p.y"
                              {
                        portset.parameters.websocket.host = (yyvsp[0].string);
                  }
#line 5474 "src/y.tab.c"
    break;

  case 501:
#line 1813 "src/p.y"
                                    {
                        portset.parameters.websocket.version = (yyvsp[0].number);
                  }
#line 5482 "src/y.tab.c"
    break;

  case 504:
#line 1822 "src/p.y"
                           {
                        portset.parameters.smtp.username = (yyvsp[0].string);
                  }
#line 5490 "src/y.tab.c"
    break;

  case 505:
#line 1825 "src/p.y"
                           {
                        portset.parameters.smtp.password = (yyvsp[0].string);
                  }
#line 5498 "src/y.tab.c"
    break;

  case 508:
#line 1834 "src/p.y"
                           {
                        portset.parameters.mqtt.username = (yyvsp[0].string);
                  }
#line 5506 "src/y.tab.c"
    break;

  case 509:
#line 1837 "src/p.y"
                           {
                        portset.parameters.mqtt.password = (yyvsp[0].string);
                  }
#line 5514 "src/y.tab.c"
    break;

  case 512:
#line 1846 "src/p.y"
                           {
                        portset.parameters.mysql.username = (yyvsp[0].string);
                  }
#line 5522 "src/y.tab.c"
    break;

  case 513:
#line 1849 "src/p.y"
                           {
                        portset.parameters.mysql.password = (yyvsp[0].string);
                  }
#line 5530 "src/y.tab.c"
    break;

  case 514:
#line 1852 "src/p.y"
                                                          {
                        portset.parameters.mysql.rsaChecksum = (yyvsp[0].string);
                        switch (cleanup_hash_string(portset.parameters.mysql.rsaChecksum)) {
                                case 32:
                                        portset.parameters.mysql.rsaChecksumType = Hash_Md5;
                                        break;
                                case 40:
                                        portset.parameters.mysql.rsaChecksumType = Hash_Sha1;
                                        break;
                                default:
                                        yyerror2("Unknown checksum type: [%s] is not MD5 nor SHA1", portset.parameters.mysql.rsaChecksum);
                        }
                  }
#line 5548 "src/y.tab.c"
    break;

  case 515:
#line 1865 "src/p.y"
                                                                  {
                        portset.parameters.mysql.rsaChecksum = (yyvsp[0].string);
                        if (cleanup_hash_string(portset.parameters.mysql.rsaChecksum) != 32)
                                yyerror2("Unknown checksum type: [%s] is not MD5", portset.parameters.mysql.rsaChecksum);
                        portset.parameters.mysql.rsaChecksumType = Hash_Md5;
                  }
#line 5559 "src/y.tab.c"
    break;

  case 516:
#line 1871 "src/p.y"
                                                                   {
                        portset.parameters.mysql.rsaChecksum = (yyvsp[0].string);
                        if (cleanup_hash_string(portset.parameters.mysql.rsaChecksum) != 40)
                                yyerror2("Unknown checksum type: [%s] is not SHA1", portset.parameters.mysql.rsaChecksum);
                        portset.parameters.mysql.rsaChecksumType = Hash_Sha1;
                  }
#line 5570 "src/y.tab.c"
    break;

  case 519:
#line 1883 "src/p.y"
                           {
                        portset.parameters.postgresql.username = (yyvsp[0].string);
                  }
#line 5578 "src/y.tab.c"
    break;

  case 520:
#line 1886 "src/p.y"
                           {
                        portset.parameters.postgresql.password = (yyvsp[0].string);
                  }
#line 5586 "src/y.tab.c"
    break;

  case 521:
#line 1889 "src/p.y"
                           {
                        portset.parameters.postgresql.database = (yyvsp[0].string);
                  }
#line 5594 "src/y.tab.c"
    break;

  case 522:
#line 1894 "src/p.y"
                                  {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 5602 "src/y.tab.c"
    break;

  case 523:
#line 1897 "src/p.y"
                                {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 5610 "src/y.tab.c"
    break;

  case 524:
#line 1902 "src/p.y"
                                    {
                        (yyval.number) = verifyMaxForward((yyvsp[0].number));
                  }
#line 5618 "src/y.tab.c"
    break;

  case 527:
#line 1911 "src/p.y"
                         {
                        portset.parameters.sip.target = (yyvsp[0].string);
                  }
#line 5626 "src/y.tab.c"
    break;

  case 528:
#line 1914 "src/p.y"
                             {
                        portset.parameters.sip.maxforward = (yyvsp[0].number);
                  }
#line 5634 "src/y.tab.c"
    break;

  case 531:
#line 1923 "src/p.y"
                           {
                        portset.parameters.http.username = (yyvsp[0].string);
                  }
#line 5642 "src/y.tab.c"
    break;

  case 532:
#line 1926 "src/p.y"
                           {
                        portset.parameters.http.password = (yyvsp[0].string);
                  }
#line 5650 "src/y.tab.c"
    break;

  case 539:
#line 1937 "src/p.y"
                                         {
                        if ((yyvsp[0].number) < 0) {
                                yyerror2("The status value must be greater or equal to 0");
                        }
                        portset.parameters.http.operator = (yyvsp[-1].number);
                        portset.parameters.http.status = (yyvsp[0].number);
                        portset.parameters.http.hasStatus = true;
                  }
#line 5663 "src/y.tab.c"
    break;

  case 540:
#line 1947 "src/p.y"
                             {
                        portset.parameters.http.method = Http_Get;
                  }
#line 5671 "src/y.tab.c"
    break;

  case 541:
#line 1950 "src/p.y"
                              {
                        portset.parameters.http.method = Http_Head;
                  }
#line 5679 "src/y.tab.c"
    break;

  case 542:
#line 1955 "src/p.y"
                               {
                        portset.parameters.http.request = Util_urlEncode((yyvsp[0].string), false);
                        FREE((yyvsp[0].string));
                  }
#line 5688 "src/y.tab.c"
    break;

  case 543:
#line 1959 "src/p.y"
                                 {
                        portset.parameters.http.request = Util_urlEncode((yyvsp[0].string), false);
                        FREE((yyvsp[0].string));
                  }
#line 5697 "src/y.tab.c"
    break;

  case 544:
#line 1965 "src/p.y"
                                  {
                        portset.parameters.http.checksum = (yyvsp[0].string);
                  }
#line 5705 "src/y.tab.c"
    break;

  case 545:
#line 1970 "src/p.y"
                                    {
                        addhttpheader(&portset, Str_cat("Host:%s", (yyvsp[0].string)));
                        FREE((yyvsp[0].string));
                  }
#line 5714 "src/y.tab.c"
    break;

  case 547:
#line 1977 "src/p.y"
                                            {
                        addhttpheader(&portset, (yyvsp[0].string));
                 }
#line 5722 "src/y.tab.c"
    break;

  case 548:
#line 1982 "src/p.y"
                                {
                        (yyval.string) = (yyvsp[0].string);
                  }
#line 5730 "src/y.tab.c"
    break;

  case 551:
#line 1991 "src/p.y"
                         {
                        portset.parameters.radius.secret = (yyvsp[0].string);
                  }
#line 5738 "src/y.tab.c"
    break;

  case 554:
#line 2000 "src/p.y"
                           {
                        portset.parameters.apachestatus.username = (yyvsp[0].string);
                  }
#line 5746 "src/y.tab.c"
    break;

  case 555:
#line 2003 "src/p.y"
                           {
                        portset.parameters.apachestatus.password = (yyvsp[0].string);
                  }
#line 5754 "src/y.tab.c"
    break;

  case 556:
#line 2006 "src/p.y"
                               {
                        portset.parameters.apachestatus.path = (yyvsp[0].string);
                  }
#line 5762 "src/y.tab.c"
    break;

  case 557:
#line 2009 "src/p.y"
                                                   {
                        portset.parameters.apachestatus.loglimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.loglimit = (yyvsp[-1].number);
                  }
#line 5771 "src/y.tab.c"
    break;

  case 558:
#line 2013 "src/p.y"
                                                     {
                        portset.parameters.apachestatus.closelimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.closelimit = (yyvsp[-1].number);
                  }
#line 5780 "src/y.tab.c"
    break;

  case 559:
#line 2017 "src/p.y"
                                                   {
                        portset.parameters.apachestatus.dnslimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.dnslimit = (yyvsp[-1].number);
                  }
#line 5789 "src/y.tab.c"
    break;

  case 560:
#line 2021 "src/p.y"
                                                         {
                        portset.parameters.apachestatus.keepalivelimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.keepalivelimit = (yyvsp[-1].number);
                  }
#line 5798 "src/y.tab.c"
    break;

  case 561:
#line 2025 "src/p.y"
                                                     {
                        portset.parameters.apachestatus.replylimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.replylimit = (yyvsp[-1].number);
                  }
#line 5807 "src/y.tab.c"
    break;

  case 562:
#line 2029 "src/p.y"
                                                       {
                        portset.parameters.apachestatus.requestlimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.requestlimit = (yyvsp[-1].number);
                  }
#line 5816 "src/y.tab.c"
    break;

  case 563:
#line 2033 "src/p.y"
                                                     {
                        portset.parameters.apachestatus.startlimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.startlimit = (yyvsp[-1].number);
                  }
#line 5825 "src/y.tab.c"
    break;

  case 564:
#line 2037 "src/p.y"
                                                    {
                        portset.parameters.apachestatus.waitlimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.waitlimit = (yyvsp[-1].number);
                  }
#line 5834 "src/y.tab.c"
    break;

  case 565:
#line 2041 "src/p.y"
                                                        {
                        portset.parameters.apachestatus.gracefullimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.gracefullimit = (yyvsp[-1].number);
                  }
#line 5843 "src/y.tab.c"
    break;

  case 566:
#line 2045 "src/p.y"
                                                       {
                        portset.parameters.apachestatus.cleanuplimitOP = (yyvsp[-2].number);
                        portset.parameters.apachestatus.cleanuplimit = (yyvsp[-1].number);
                  }
#line 5852 "src/y.tab.c"
    break;

  case 567:
#line 2051 "src/p.y"
                                                                   {
                        addeventaction(&(nonexistset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addnonexist(&nonexistset);
                  }
#line 5861 "src/y.tab.c"
    break;

  case 568:
#line 2055 "src/p.y"
                                                               {
                        addeventaction(&(existset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addexist(&existset);
                  }
#line 5870 "src/y.tab.c"
    break;

  case 569:
#line 2062 "src/p.y"
                                                    {
                        addeventaction(&(pidset).action, (yyvsp[0].number), Action_Ignored);
                        addpid(&pidset);
                  }
#line 5879 "src/y.tab.c"
    break;

  case 570:
#line 2068 "src/p.y"
                                                     {
                        addeventaction(&(ppidset).action, (yyvsp[0].number), Action_Ignored);
                        addppid(&ppidset);
                  }
#line 5888 "src/y.tab.c"
    break;

  case 571:
#line 2074 "src/p.y"
                                                                                     {
                        uptimeset.operator = (yyvsp[-6].number);
                        uptimeset.uptime = ((unsigned long long)(yyvsp[-5].number) * (yyvsp[-4].number));
                        addeventaction(&(uptimeset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        adduptime(&uptimeset);
                  }
#line 5899 "src/y.tab.c"
    break;

  case 572:
#line 2082 "src/p.y"
                                                           {
                        responsetimeset.operator = (yyvsp[-2].number);
                        responsetimeset.limit = (yyvsp[-1].number);
                  }
#line 5908 "src/y.tab.c"
    break;

  case 573:
#line 2086 "src/p.y"
                                                      {
                        responsetimeset.operator = (yyvsp[-2].number);
                        responsetimeset.limit = (yyvsp[-1].number) * 1000;
                  }
#line 5917 "src/y.tab.c"
    break;

  case 574:
#line 2092 "src/p.y"
                               {
                        icmpset.count = (yyvsp[0].number);
                 }
#line 5925 "src/y.tab.c"
    break;

  case 575:
#line 2097 "src/p.y"
                              {
                        icmpset.size = (yyvsp[0].number);
                        if (icmpset.size < 8) {
                                yyerror2("The minimum ping size is 8 bytes");
                        } else if (icmpset.size > 1492) {
                                yyerror2("The maximum ping size is 1492 bytes");
                        }
                 }
#line 5938 "src/y.tab.c"
    break;

  case 576:
#line 2107 "src/p.y"
                                        {
                        icmpset.timeout = (yyvsp[-1].number) * 1000; // timeout is in milliseconds internally
                    }
#line 5946 "src/y.tab.c"
    break;

  case 577:
#line 2112 "src/p.y"
                                 {
                        _parseOutgoingAddress((yyvsp[0].string), &(icmpset.outgoing));
                  }
#line 5954 "src/y.tab.c"
    break;

  case 578:
#line 2117 "src/p.y"
                              {
                        (yyval.number) = Run.limits.stopTimeout;
                  }
#line 5962 "src/y.tab.c"
    break;

  case 579:
#line 2120 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // milliseconds internally
                  }
#line 5970 "src/y.tab.c"
    break;

  case 580:
#line 2125 "src/p.y"
                              {
                        (yyval.number) = Run.limits.startTimeout;
                  }
#line 5978 "src/y.tab.c"
    break;

  case 581:
#line 2128 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // milliseconds internally
                  }
#line 5986 "src/y.tab.c"
    break;

  case 582:
#line 2133 "src/p.y"
                              {
                        (yyval.number) = Run.limits.restartTimeout;
                  }
#line 5994 "src/y.tab.c"
    break;

  case 583:
#line 2136 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // milliseconds internally
                  }
#line 6002 "src/y.tab.c"
    break;

  case 584:
#line 2141 "src/p.y"
                              {
                        (yyval.number) = Run.limits.programTimeout;
                  }
#line 6010 "src/y.tab.c"
    break;

  case 585:
#line 2144 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // milliseconds internally
                  }
#line 6018 "src/y.tab.c"
    break;

  case 586:
#line 2149 "src/p.y"
                              {
                        (yyval.number) = Run.limits.networkTimeout;
                  }
#line 6026 "src/y.tab.c"
    break;

  case 587:
#line 2152 "src/p.y"
                                        {
                        (yyval.number) = (yyvsp[-1].number) * 1000; // net timeout is in milliseconds internally
                  }
#line 6034 "src/y.tab.c"
    break;

  case 588:
#line 2157 "src/p.y"
                                          {
                        portset.timeout = (yyvsp[-1].number) * 1000; // timeout is in milliseconds internally
                    }
#line 6042 "src/y.tab.c"
    break;

  case 589:
#line 2162 "src/p.y"
                               {
                        portset.retry = (yyvsp[0].number);
                  }
#line 6050 "src/y.tab.c"
    break;

  case 590:
#line 2167 "src/p.y"
                                                              {
                        actionrateset.count = (yyvsp[-5].number);
                        actionrateset.cycle = (yyvsp[-3].number);
                        addeventaction(&(actionrateset).action, (yyvsp[0].number), Action_Alert);
                        addactionrate(&actionrateset);
                  }
#line 6061 "src/y.tab.c"
    break;

  case 591:
#line 2173 "src/p.y"
                                                              {
                        actionrateset.count = (yyvsp[-5].number);
                        actionrateset.cycle = (yyvsp[-3].number);
                        addeventaction(&(actionrateset).action, Action_Unmonitor, Action_Alert);
                        addactionrate(&actionrateset);
                  }
#line 6072 "src/y.tab.c"
    break;

  case 592:
#line 2181 "src/p.y"
                                             {
                        seturlrequest((yyvsp[-1].number), (yyvsp[0].string));
                        FREE((yyvsp[0].string));
                  }
#line 6081 "src/y.tab.c"
    break;

  case 593:
#line 2187 "src/p.y"
                           { (yyval.number) = Operator_Equal; }
#line 6087 "src/y.tab.c"
    break;

  case 594:
#line 2188 "src/p.y"
                           { (yyval.number) = Operator_NotEqual; }
#line 6093 "src/y.tab.c"
    break;

  case 595:
#line 2191 "src/p.y"
                                                {
                        mailset.events = Event_All;
                        addmail((yyvsp[-2].string), &mailset, &current->maillist);
                  }
#line 6102 "src/y.tab.c"
    break;

  case 596:
#line 2195 "src/p.y"
                                                                        {
                        addmail((yyvsp[-5].string), &mailset, &current->maillist);
                  }
#line 6110 "src/y.tab.c"
    break;

  case 597:
#line 2198 "src/p.y"
                                                                            {
                        mailset.events = ~mailset.events;
                        addmail((yyvsp[-6].string), &mailset, &current->maillist);
                  }
#line 6119 "src/y.tab.c"
    break;

  case 598:
#line 2202 "src/p.y"
                              {
                        addmail((yyvsp[0].string), &mailset, &current->maillist);
                  }
#line 6127 "src/y.tab.c"
    break;

  case 599:
#line 2207 "src/p.y"
                                 { (yyval.string) = (yyvsp[0].string); }
#line 6133 "src/y.tab.c"
    break;

  case 600:
#line 2210 "src/p.y"
                                   { (yyval.string) = (yyvsp[0].string); }
#line 6139 "src/y.tab.c"
    break;

  case 603:
#line 2217 "src/p.y"
                                  { mailset.events |= Event_Action; }
#line 6145 "src/y.tab.c"
    break;

  case 604:
#line 2218 "src/p.y"
                                  { mailset.events |= Event_ByteIn; }
#line 6151 "src/y.tab.c"
    break;

  case 605:
#line 2219 "src/p.y"
                                  { mailset.events |= Event_ByteOut; }
#line 6157 "src/y.tab.c"
    break;

  case 606:
#line 2220 "src/p.y"
                                  { mailset.events |= Event_Checksum; }
#line 6163 "src/y.tab.c"
    break;

  case 607:
#line 2221 "src/p.y"
                                  { mailset.events |= Event_Connection; }
#line 6169 "src/y.tab.c"
    break;

  case 608:
#line 2222 "src/p.y"
                                  { mailset.events |= Event_Content; }
#line 6175 "src/y.tab.c"
    break;

  case 609:
#line 2223 "src/p.y"
                                  { mailset.events |= Event_Data; }
#line 6181 "src/y.tab.c"
    break;

  case 610:
#line 2224 "src/p.y"
                                  { mailset.events |= Event_Exec; }
#line 6187 "src/y.tab.c"
    break;

  case 611:
#line 2225 "src/p.y"
                                  { mailset.events |= Event_Exist; }
#line 6193 "src/y.tab.c"
    break;

  case 612:
#line 2226 "src/p.y"
                                  { mailset.events |= Event_FsFlag; }
#line 6199 "src/y.tab.c"
    break;

  case 613:
#line 2227 "src/p.y"
                                  { mailset.events |= Event_Gid; }
#line 6205 "src/y.tab.c"
    break;

  case 614:
#line 2228 "src/p.y"
                                  { mailset.events |= Event_Icmp; }
#line 6211 "src/y.tab.c"
    break;

  case 615:
#line 2229 "src/p.y"
                                  { mailset.events |= Event_Instance; }
#line 6217 "src/y.tab.c"
    break;

  case 616:
#line 2230 "src/p.y"
                                  { mailset.events |= Event_Invalid; }
#line 6223 "src/y.tab.c"
    break;

  case 617:
#line 2231 "src/p.y"
                                  { mailset.events |= Event_Link; }
#line 6229 "src/y.tab.c"
    break;

  case 618:
#line 2232 "src/p.y"
                                  { mailset.events |= Event_NonExist; }
#line 6235 "src/y.tab.c"
    break;

  case 619:
#line 2233 "src/p.y"
                                  { mailset.events |= Event_PacketIn; }
#line 6241 "src/y.tab.c"
    break;

  case 620:
#line 2234 "src/p.y"
                                  { mailset.events |= Event_PacketOut; }
#line 6247 "src/y.tab.c"
    break;

  case 621:
#line 2235 "src/p.y"
                                  { mailset.events |= Event_Permission; }
#line 6253 "src/y.tab.c"
    break;

  case 622:
#line 2236 "src/p.y"
                                  { mailset.events |= Event_Pid; }
#line 6259 "src/y.tab.c"
    break;

  case 623:
#line 2237 "src/p.y"
                                  { mailset.events |= Event_PPid; }
#line 6265 "src/y.tab.c"
    break;

  case 624:
#line 2238 "src/p.y"
                                  { mailset.events |= Event_Resource; }
#line 6271 "src/y.tab.c"
    break;

  case 625:
#line 2239 "src/p.y"
                                  { mailset.events |= Event_Saturation; }
#line 6277 "src/y.tab.c"
    break;

  case 626:
#line 2240 "src/p.y"
                                  { mailset.events |= Event_Size; }
#line 6283 "src/y.tab.c"
    break;

  case 627:
#line 2241 "src/p.y"
                                  { mailset.events |= Event_Speed; }
#line 6289 "src/y.tab.c"
    break;

  case 628:
#line 2242 "src/p.y"
                                  { mailset.events |= Event_Status; }
#line 6295 "src/y.tab.c"
    break;

  case 629:
#line 2243 "src/p.y"
                                  { mailset.events |= Event_Timeout; }
#line 6301 "src/y.tab.c"
    break;

  case 630:
#line 2244 "src/p.y"
                                  { mailset.events |= Event_Timestamp; }
#line 6307 "src/y.tab.c"
    break;

  case 631:
#line 2245 "src/p.y"
                                  { mailset.events |= Event_Uid; }
#line 6313 "src/y.tab.c"
    break;

  case 632:
#line 2246 "src/p.y"
                                  { mailset.events |= Event_Uptime; }
#line 6319 "src/y.tab.c"
    break;

  case 637:
#line 2257 "src/p.y"
                                         { mailset.from = (yyvsp[-1].address); }
#line 6325 "src/y.tab.c"
    break;

  case 638:
#line 2258 "src/p.y"
                                            { mailset.replyto = (yyvsp[-1].address); }
#line 6331 "src/y.tab.c"
    break;

  case 639:
#line 2259 "src/p.y"
                              { mailset.subject = (yyvsp[0].string); }
#line 6337 "src/y.tab.c"
    break;

  case 640:
#line 2260 "src/p.y"
                           { mailset.message = (yyvsp[0].string); }
#line 6343 "src/y.tab.c"
    break;

  case 641:
#line 2263 "src/p.y"
                                     {
                        _sanityCheckEveryStatement(current);
                        current->every.type = Every_SkipCycles;
                        current->every.spec.cycle.counter = current->every.spec.cycle.number = (yyvsp[-1].number);
                 }
#line 6353 "src/y.tab.c"
    break;

  case 642:
#line 2268 "src/p.y"
                                 {
                        _sanityCheckEveryStatement(current);
                        current->every.type = Every_Cron;
                        current->every.spec.cron = (yyvsp[0].string);
                 }
#line 6363 "src/y.tab.c"
    break;

  case 643:
#line 2273 "src/p.y"
                                    {
                        _sanityCheckEveryStatement(current);
                        current->every.type = Every_NotInCron;
                        current->every.spec.cron = (yyvsp[0].string);
                 }
#line 6373 "src/y.tab.c"
    break;

  case 644:
#line 2280 "src/p.y"
                              {
                        current->mode = Monitor_Active;
                  }
#line 6381 "src/y.tab.c"
    break;

  case 645:
#line 2283 "src/p.y"
                               {
                        current->mode = Monitor_Passive;
                  }
#line 6389 "src/y.tab.c"
    break;

  case 646:
#line 2286 "src/p.y"
                              {
                        // Deprecated since monit 5.18
                        current->onreboot = Onreboot_Laststate;
                  }
#line 6398 "src/y.tab.c"
    break;

  case 647:
#line 2292 "src/p.y"
                                 {
                        current->onreboot = Onreboot_Start;
                  }
#line 6406 "src/y.tab.c"
    break;

  case 648:
#line 2295 "src/p.y"
                                   {
                        current->onreboot = Onreboot_Nostart;
                        current->monitor = Monitor_Not;
                  }
#line 6415 "src/y.tab.c"
    break;

  case 649:
#line 2299 "src/p.y"
                                     {
                        current->onreboot = Onreboot_Laststate;
                  }
#line 6423 "src/y.tab.c"
    break;

  case 650:
#line 2304 "src/p.y"
                                   {
                        addservicegroup((yyvsp[0].string));
                        FREE((yyvsp[0].string));
                  }
#line 6432 "src/y.tab.c"
    break;

  case 654:
#line 2318 "src/p.y"
                              { adddependant((yyvsp[0].string)); }
#line 6438 "src/y.tab.c"
    break;

  case 655:
#line 2321 "src/p.y"
                                                                                {
                        statusset.initialized = true;
                        statusset.operator = (yyvsp[-5].number);
                        statusset.return_value = (yyvsp[-4].number);
                        addeventaction(&(statusset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addstatus(&statusset);
                   }
#line 6450 "src/y.tab.c"
    break;

  case 656:
#line 2328 "src/p.y"
                                                       {
                        statusset.initialized = false;
                        statusset.operator = Operator_Changed;
                        statusset.return_value = 0;
                        addeventaction(&(statusset).action, (yyvsp[0].number), Action_Ignored);
                        addstatus(&statusset);
                   }
#line 6462 "src/y.tab.c"
    break;

  case 657:
#line 2337 "src/p.y"
                                                                             {
                        addeventaction(&(resourceset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addresource(&resourceset);
                   }
#line 6471 "src/y.tab.c"
    break;

  case 667:
#line 2356 "src/p.y"
                                                                            {
                        addeventaction(&(resourceset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addresource(&resourceset);
                   }
#line 6480 "src/y.tab.c"
    break;

  case 674:
#line 2372 "src/p.y"
                                             {
                        resourceset.resource_id = Resource_CpuPercent;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6490 "src/y.tab.c"
    break;

  case 675:
#line 2377 "src/p.y"
                                                  {
                        resourceset.resource_id = Resource_CpuPercentTotal;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6500 "src/y.tab.c"
    break;

  case 676:
#line 2384 "src/p.y"
                                                       {
                        resourceset.resource_id = (yyvsp[-3].number);
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6510 "src/y.tab.c"
    break;

  case 677:
#line 2391 "src/p.y"
                          {
                        if (systeminfo.statisticsAvailable & Statistics_CpuUser)
                                (yyval.number) = Resource_CpuUser;
                        else
                                yywarning2("The CPU user usage statistics is not available on this system\n");
                  }
#line 6521 "src/y.tab.c"
    break;

  case 678:
#line 2397 "src/p.y"
                            {
                        if (systeminfo.statisticsAvailable & Statistics_CpuSystem)
                                (yyval.number) = Resource_CpuSystem;
                        else
                                yywarning2("The CPU system usage statistics is not available on this system\n");
                  }
#line 6532 "src/y.tab.c"
    break;

  case 679:
#line 2403 "src/p.y"
                          {
                        if (systeminfo.statisticsAvailable & Statistics_CpuIOWait)
                                (yyval.number) = Resource_CpuWait;
                        else
                                yywarning2("The CPU I/O wait usage statistics is not available on this system\n");
                  }
#line 6543 "src/y.tab.c"
    break;

  case 680:
#line 2409 "src/p.y"
                          {
                        if (systeminfo.statisticsAvailable & Statistics_CpuNice)
                                (yyval.number) = Resource_CpuNice;
                        else
                                yywarning2("The CPU nice usage statistics is not available on this system\n");
                  }
#line 6554 "src/y.tab.c"
    break;

  case 681:
#line 2415 "src/p.y"
                             {
                        if (systeminfo.statisticsAvailable & Statistics_CpuHardIRQ)
                                (yyval.number) = Resource_CpuHardIRQ;
                        else
                                yywarning2("The CPU hardware IRQ usage statistics is not available on this system\n");
                  }
#line 6565 "src/y.tab.c"
    break;

  case 682:
#line 2421 "src/p.y"
                             {
                        if (systeminfo.statisticsAvailable & Statistics_CpuSoftIRQ)
                                (yyval.number) = Resource_CpuSoftIRQ;
                        else
                                yywarning2("The CPU software IRQ usage statistics is not available on this system\n");
                  }
#line 6576 "src/y.tab.c"
    break;

  case 683:
#line 2427 "src/p.y"
                           {
                        if (systeminfo.statisticsAvailable & Statistics_CpuSteal)
                                (yyval.number) = Resource_CpuSteal;
                        else
                                yywarning2("The CPU steal usage statistics is not available on this system\n");
                  }
#line 6587 "src/y.tab.c"
    break;

  case 684:
#line 2433 "src/p.y"
                           {
                        if (systeminfo.statisticsAvailable & Statistics_CpuGuest)
                                (yyval.number) = Resource_CpuGuest;
                        else
                                yywarning2("The CPU guest usage statistics is not available on this system\n");
                  }
#line 6598 "src/y.tab.c"
    break;

  case 685:
#line 2439 "src/p.y"
                               {
                        if (systeminfo.statisticsAvailable & Statistics_CpuGuestNice)
                                (yyval.number) = Resource_CpuGuestNice;
                        else
                                yywarning2("The CPU guest nice usage statistics is not available on this system\n");
                  }
#line 6609 "src/y.tab.c"
    break;

  case 686:
#line 2445 "src/p.y"
                      {
                        (yyval.number) = Resource_CpuPercent;
                  }
#line 6617 "src/y.tab.c"
    break;

  case 687:
#line 2450 "src/p.y"
                                             {
                        resourceset.resource_id = Resource_MemoryKbyte;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real) * (yyvsp[0].number);
                  }
#line 6627 "src/y.tab.c"
    break;

  case 688:
#line 2455 "src/p.y"
                                                {
                        resourceset.resource_id = Resource_MemoryPercent;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6637 "src/y.tab.c"
    break;

  case 689:
#line 2462 "src/p.y"
                                             {
                        resourceset.resource_id = Resource_MemoryKbyte;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real) * (yyvsp[0].number);
                  }
#line 6647 "src/y.tab.c"
    break;

  case 690:
#line 2467 "src/p.y"
                                                {
                        resourceset.resource_id = Resource_MemoryPercent;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6657 "src/y.tab.c"
    break;

  case 691:
#line 2472 "src/p.y"
                                                  {
                        resourceset.resource_id = Resource_MemoryKbyteTotal;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real) * (yyvsp[0].number);
                  }
#line 6667 "src/y.tab.c"
    break;

  case 692:
#line 2477 "src/p.y"
                                                      {
                        resourceset.resource_id = Resource_MemoryPercentTotal;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6677 "src/y.tab.c"
    break;

  case 693:
#line 2484 "src/p.y"
                                           {
                        resourceset.resource_id = Resource_SwapKbyte;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real) * (yyvsp[0].number);
                  }
#line 6687 "src/y.tab.c"
    break;

  case 694:
#line 2489 "src/p.y"
                                              {
                        resourceset.resource_id = Resource_SwapPercent;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].real);
                  }
#line 6697 "src/y.tab.c"
    break;

  case 695:
#line 2496 "src/p.y"
                                          {
                        resourceset.resource_id = Resource_Threads;
                        resourceset.operator = (yyvsp[-1].number);
                        resourceset.limit = (yyvsp[0].number);
                  }
#line 6707 "src/y.tab.c"
    break;

  case 696:
#line 2503 "src/p.y"
                                           {
                        resourceset.resource_id = Resource_Children;
                        resourceset.operator = (yyvsp[-1].number);
                        resourceset.limit = (yyvsp[0].number);
                  }
#line 6717 "src/y.tab.c"
    break;

  case 697:
#line 2510 "src/p.y"
                                                                {
                        switch ((yyvsp[-3].number)) {
                                case Resource_LoadAverage1m:
                                        resourceset.resource_id = (yyvsp[-2].number) > 1 ? Resource_LoadAveragePerCore1m : (yyvsp[-3].number);
                                        break;
                                case Resource_LoadAverage5m:
                                        resourceset.resource_id = (yyvsp[-2].number) > 1 ? Resource_LoadAveragePerCore5m : (yyvsp[-3].number);
                                        break;
                                case Resource_LoadAverage15m:
                                        resourceset.resource_id = (yyvsp[-2].number) > 1 ? Resource_LoadAveragePerCore15m : (yyvsp[-3].number);
                                        break;
                                default:
                                        resourceset.resource_id = (yyvsp[-3].number);
                                        break;
                        }
                        resourceset.operator = (yyvsp[-1].number);
                        resourceset.limit = (yyvsp[0].real);
                  }
#line 6740 "src/y.tab.c"
    break;

  case 698:
#line 2530 "src/p.y"
                            { (yyval.number) = Resource_LoadAverage1m; }
#line 6746 "src/y.tab.c"
    break;

  case 699:
#line 2531 "src/p.y"
                            { (yyval.number) = Resource_LoadAverage5m; }
#line 6752 "src/y.tab.c"
    break;

  case 700:
#line 2532 "src/p.y"
                            { (yyval.number) = Resource_LoadAverage15m; }
#line 6758 "src/y.tab.c"
    break;

  case 701:
#line 2535 "src/p.y"
                              { (yyval.number) = 1; }
#line 6764 "src/y.tab.c"
    break;

  case 702:
#line 2536 "src/p.y"
                              { (yyval.number) = systeminfo.cpu.count; }
#line 6770 "src/y.tab.c"
    break;

  case 703:
#line 2540 "src/p.y"
                                                       {
                        resourceset.resource_id = Resource_ReadBytes;
                        resourceset.operator = (yyvsp[-3].number);
                        resourceset.limit = (yyvsp[-2].real) * (yyvsp[-1].number);
                  }
#line 6780 "src/y.tab.c"
    break;

  case 704:
#line 2545 "src/p.y"
                                                            {
                        resourceset.resource_id = Resource_ReadBytesPhysical;
                        resourceset.operator = (yyvsp[-3].number);
                        resourceset.limit = (yyvsp[-2].real) * (yyvsp[-1].number);
                  }
#line 6790 "src/y.tab.c"
    break;

  case 705:
#line 2550 "src/p.y"
                                                      {
                        resourceset.resource_id = Resource_ReadOperations;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].number);
                  }
#line 6800 "src/y.tab.c"
    break;

  case 706:
#line 2557 "src/p.y"
                                                        {
                        resourceset.resource_id = Resource_WriteBytes;
                        resourceset.operator = (yyvsp[-3].number);
                        resourceset.limit = (yyvsp[-2].real) * (yyvsp[-1].number);
                  }
#line 6810 "src/y.tab.c"
    break;

  case 707:
#line 2562 "src/p.y"
                                                             {
                        resourceset.resource_id = Resource_WriteBytesPhysical;
                        resourceset.operator = (yyvsp[-3].number);
                        resourceset.limit = (yyvsp[-2].real) * (yyvsp[-1].number);
                  }
#line 6820 "src/y.tab.c"
    break;

  case 708:
#line 2567 "src/p.y"
                                                       {
                        resourceset.resource_id = Resource_WriteOperations;
                        resourceset.operator = (yyvsp[-2].number);
                        resourceset.limit = (yyvsp[-1].number);
                  }
#line 6830 "src/y.tab.c"
    break;

  case 709:
#line 2574 "src/p.y"
                       { (yyval.real) = (yyvsp[0].real); }
#line 6836 "src/y.tab.c"
    break;

  case 710:
#line 2575 "src/p.y"
                         { (yyval.real) = (float) (yyvsp[0].number); }
#line 6842 "src/y.tab.c"
    break;

  case 711:
#line 2578 "src/p.y"
                        { (yyval.number) = Timestamp_Default; }
#line 6848 "src/y.tab.c"
    break;

  case 712:
#line 2579 "src/p.y"
                        { (yyval.number) = Timestamp_Access; }
#line 6854 "src/y.tab.c"
    break;

  case 713:
#line 2580 "src/p.y"
                        { (yyval.number) = Timestamp_Change; }
#line 6860 "src/y.tab.c"
    break;

  case 714:
#line 2581 "src/p.y"
                        { (yyval.number) = Timestamp_Modification; }
#line 6866 "src/y.tab.c"
    break;

  case 715:
#line 2584 "src/p.y"
                                                                                            {
                        timestampset.type = (yyvsp[-7].number);
                        timestampset.operator = (yyvsp[-6].number);
                        timestampset.time = ((yyvsp[-5].number) * (yyvsp[-4].number));
                        addeventaction(&(timestampset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addtimestamp(&timestampset);
                  }
#line 6878 "src/y.tab.c"
    break;

  case 716:
#line 2591 "src/p.y"
                                                              {
                        timestampset.type = (yyvsp[-3].number);
                        timestampset.test_changes = true;
                        addeventaction(&(timestampset).action, (yyvsp[0].number), Action_Ignored);
                        addtimestamp(&timestampset);
                  }
#line 6889 "src/y.tab.c"
    break;

  case 717:
#line 2599 "src/p.y"
                                 { (yyval.number) = Operator_Equal; }
#line 6895 "src/y.tab.c"
    break;

  case 718:
#line 2600 "src/p.y"
                                 { (yyval.number) = Operator_Greater; }
#line 6901 "src/y.tab.c"
    break;

  case 719:
#line 2601 "src/p.y"
                                 { (yyval.number) = Operator_GreaterOrEqual; }
#line 6907 "src/y.tab.c"
    break;

  case 720:
#line 2602 "src/p.y"
                                 { (yyval.number) = Operator_Less; }
#line 6913 "src/y.tab.c"
    break;

  case 721:
#line 2603 "src/p.y"
                                 { (yyval.number) = Operator_LessOrEqual; }
#line 6919 "src/y.tab.c"
    break;

  case 722:
#line 2604 "src/p.y"
                                 { (yyval.number) = Operator_Equal; }
#line 6925 "src/y.tab.c"
    break;

  case 723:
#line 2605 "src/p.y"
                                 { (yyval.number) = Operator_NotEqual; }
#line 6931 "src/y.tab.c"
    break;

  case 724:
#line 2606 "src/p.y"
                                 { (yyval.number) = Operator_Changed; }
#line 6937 "src/y.tab.c"
    break;

  case 725:
#line 2609 "src/p.y"
                              { (yyval.number) = Time_Second; }
#line 6943 "src/y.tab.c"
    break;

  case 726:
#line 2610 "src/p.y"
                              { (yyval.number) = Time_Second; }
#line 6949 "src/y.tab.c"
    break;

  case 727:
#line 2611 "src/p.y"
                              { (yyval.number) = Time_Minute; }
#line 6955 "src/y.tab.c"
    break;

  case 728:
#line 2612 "src/p.y"
                              { (yyval.number) = Time_Hour; }
#line 6961 "src/y.tab.c"
    break;

  case 729:
#line 2613 "src/p.y"
                              { (yyval.number) = Time_Day; }
#line 6967 "src/y.tab.c"
    break;

  case 730:
#line 2614 "src/p.y"
                              { (yyval.number) = Time_Month; }
#line 6973 "src/y.tab.c"
    break;

  case 731:
#line 2617 "src/p.y"
                              { (yyval.number) = Time_Minute; }
#line 6979 "src/y.tab.c"
    break;

  case 732:
#line 2618 "src/p.y"
                              { (yyval.number) = Time_Hour; }
#line 6985 "src/y.tab.c"
    break;

  case 733:
#line 2619 "src/p.y"
                              { (yyval.number) = Time_Day; }
#line 6991 "src/y.tab.c"
    break;

  case 734:
#line 2621 "src/p.y"
                              { (yyval.number) = Time_Second; }
#line 6997 "src/y.tab.c"
    break;

  case 735:
#line 2622 "src/p.y"
                              { (yyval.number) = Time_Second; }
#line 7003 "src/y.tab.c"
    break;

  case 736:
#line 2624 "src/p.y"
                              {
                        repeat = 0;
                  }
#line 7011 "src/y.tab.c"
    break;

  case 737:
#line 2627 "src/p.y"
                                     {
                        repeat = 1;
                  }
#line 7019 "src/y.tab.c"
    break;

  case 738:
#line 2630 "src/p.y"
                                            {
                        if ((yyvsp[-1].number) < 0) {
                                yyerror2("The number of repeat cycles must be greater or equal to 0");
                        }
                        repeat = (yyvsp[-1].number);
                  }
#line 7030 "src/y.tab.c"
    break;

  case 739:
#line 2638 "src/p.y"
                        {
                        (yyval.number) = Action_Alert;
                  }
#line 7038 "src/y.tab.c"
    break;

  case 740:
#line 2641 "src/p.y"
                                           {
                        (yyval.number) = Action_Exec;
                  }
#line 7046 "src/y.tab.c"
    break;

  case 741:
#line 2645 "src/p.y"
                  {
                        (yyval.number) = Action_Exec;
                  }
#line 7054 "src/y.tab.c"
    break;

  case 742:
#line 2648 "src/p.y"
                          {
                        (yyval.number) = Action_Restart;
                  }
#line 7062 "src/y.tab.c"
    break;

  case 743:
#line 2651 "src/p.y"
                        {
                        (yyval.number) = Action_Start;
                  }
#line 7070 "src/y.tab.c"
    break;

  case 744:
#line 2654 "src/p.y"
                       {
                        (yyval.number) = Action_Stop;
                  }
#line 7078 "src/y.tab.c"
    break;

  case 745:
#line 2657 "src/p.y"
                            {
                        (yyval.number) = Action_Unmonitor;
                  }
#line 7086 "src/y.tab.c"
    break;

  case 746:
#line 2662 "src/p.y"
                         {
                        (yyval.number) = (yyvsp[0].number);
                        if ((yyvsp[0].number) == Action_Exec && command) {
                                repeat1 = repeat;
                                repeat = 0;
                                command1 = command;
                                command = NULL;
                        }
                  }
#line 7100 "src/y.tab.c"
    break;

  case 747:
#line 2673 "src/p.y"
                         {
                        (yyval.number) = (yyvsp[0].number);
                        if ((yyvsp[0].number) == Action_Exec && command) {
                                repeat2 = repeat;
                                repeat = 0;
                                command2 = command;
                                command = NULL;
                        }
                  }
#line 7114 "src/y.tab.c"
    break;

  case 748:
#line 2684 "src/p.y"
                               {
                        if ((yyvsp[-1].number) < 1 || (unsigned long)(yyvsp[-1].number) > BITMAP_MAX) {
                                yyerror2("The number of cycles must be between 1 and %zu", BITMAP_MAX);
                        } else {
                                rate.count  = (yyvsp[-1].number);
                                rate.cycles = (yyvsp[-1].number);
                        }
                  }
#line 7127 "src/y.tab.c"
    break;

  case 749:
#line 2694 "src/p.y"
                                      {
                        if ((yyvsp[-1].number) < 1 || (unsigned long)(yyvsp[-1].number) > BITMAP_MAX) {
                                yyerror2("The number of cycles must be between 1 and %zu", BITMAP_MAX);
                        } else if ((yyvsp[-2].number) < 1 || (yyvsp[-2].number) > (yyvsp[-1].number)) {
                                yyerror2("The number of events must be between 1 and less then poll cycles");
                        } else {
                                rate.count  = (yyvsp[-2].number);
                                rate.cycles = (yyvsp[-1].number);
                        }
                  }
#line 7142 "src/y.tab.c"
    break;

  case 751:
#line 2707 "src/p.y"
                              {
                        rate1.count = rate.count;
                        rate1.cycles = rate.cycles;
                        reset_rateset(&rate);
                  }
#line 7152 "src/y.tab.c"
    break;

  case 752:
#line 2712 "src/p.y"
                               {
                        rate1.count = rate.count;
                        rate1.cycles = rate.cycles;
                        reset_rateset(&rate);
                }
#line 7162 "src/y.tab.c"
    break;

  case 754:
#line 2720 "src/p.y"
                              {
                        rate2.count = rate.count;
                        rate2.cycles = rate.cycles;
                        reset_rateset(&rate);
                  }
#line 7172 "src/y.tab.c"
    break;

  case 755:
#line 2725 "src/p.y"
                               {
                        rate2.count = rate.count;
                        rate2.cycles = rate.cycles;
                        reset_rateset(&rate);
                }
#line 7182 "src/y.tab.c"
    break;

  case 756:
#line 2732 "src/p.y"
                               {
                        (yyval.number) = Action_Alert;
                  }
#line 7190 "src/y.tab.c"
    break;

  case 757:
#line 2735 "src/p.y"
                               {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7198 "src/y.tab.c"
    break;

  case 758:
#line 2738 "src/p.y"
                                                       {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7206 "src/y.tab.c"
    break;

  case 759:
#line 2741 "src/p.y"
                                                    {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7214 "src/y.tab.c"
    break;

  case 760:
#line 2744 "src/p.y"
                                                       {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7222 "src/y.tab.c"
    break;

  case 761:
#line 2749 "src/p.y"
                               {
                        (yyval.number) = Action_Alert;
                  }
#line 7230 "src/y.tab.c"
    break;

  case 762:
#line 2752 "src/p.y"
                               {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7238 "src/y.tab.c"
    break;

  case 763:
#line 2755 "src/p.y"
                                                    {
                        (yyval.number) = (yyvsp[0].number);
                  }
#line 7246 "src/y.tab.c"
    break;

  case 764:
#line 2760 "src/p.y"
                                                                                  {
                        addeventaction(&(checksumset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addchecksum(&checksumset);
                  }
#line 7255 "src/y.tab.c"
    break;

  case 765:
#line 2765 "src/p.y"
                                   {
                        snprintf(checksumset.hash, sizeof(checksumset.hash), "%s", (yyvsp[-4].string));
                        FREE((yyvsp[-4].string));
                        addeventaction(&(checksumset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addchecksum(&checksumset);
                  }
#line 7266 "src/y.tab.c"
    break;

  case 766:
#line 2771 "src/p.y"
                                                                  {
                        checksumset.test_changes = true;
                        addeventaction(&(checksumset).action, (yyvsp[0].number), Action_Ignored);
                        addchecksum(&checksumset);
                  }
#line 7276 "src/y.tab.c"
    break;

  case 767:
#line 2777 "src/p.y"
                              { checksumset.type = Hash_Unknown; }
#line 7282 "src/y.tab.c"
    break;

  case 768:
#line 2778 "src/p.y"
                              { checksumset.type = Hash_Md5; }
#line 7288 "src/y.tab.c"
    break;

  case 769:
#line 2779 "src/p.y"
                              { checksumset.type = Hash_Sha1; }
#line 7294 "src/y.tab.c"
    break;

  case 770:
#line 2782 "src/p.y"
                                                                               {
                        filesystemset.resource = Resource_Inode;
                        filesystemset.operator = (yyvsp[-5].number);
                        filesystemset.limit_absolute = (yyvsp[-4].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7306 "src/y.tab.c"
    break;

  case 771:
#line 2789 "src/p.y"
                                                                                      {
                        filesystemset.resource = Resource_Inode;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_percent = (yyvsp[-5].real);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7318 "src/y.tab.c"
    break;

  case 772:
#line 2796 "src/p.y"
                                                                                     {
                        filesystemset.resource = Resource_InodeFree;
                        filesystemset.operator = (yyvsp[-5].number);
                        filesystemset.limit_absolute = (yyvsp[-4].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7330 "src/y.tab.c"
    break;

  case 773:
#line 2803 "src/p.y"
                                                                                            {
                        filesystemset.resource = Resource_InodeFree;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_percent = (yyvsp[-5].real);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7342 "src/y.tab.c"
    break;

  case 774:
#line 2812 "src/p.y"
                                                                                   {
                        filesystemset.resource = Resource_Space;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].real) * (yyvsp[-4].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7354 "src/y.tab.c"
    break;

  case 775:
#line 2819 "src/p.y"
                                                                                      {
                        filesystemset.resource = Resource_Space;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_percent = (yyvsp[-5].real);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7366 "src/y.tab.c"
    break;

  case 776:
#line 2826 "src/p.y"
                                                                                         {
                        filesystemset.resource = Resource_SpaceFree;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].real) * (yyvsp[-4].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7378 "src/y.tab.c"
    break;

  case 777:
#line 2833 "src/p.y"
                                                                                            {
                        filesystemset.resource = Resource_SpaceFree;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_percent = (yyvsp[-5].real);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7390 "src/y.tab.c"
    break;

  case 778:
#line 2842 "src/p.y"
                                                                                              {
                        filesystemset.resource = Resource_ReadBytes;
                        filesystemset.operator = (yyvsp[-7].number);
                        filesystemset.limit_absolute = (yyvsp[-6].real) * (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7402 "src/y.tab.c"
    break;

  case 779:
#line 2849 "src/p.y"
                                                                                        {
                        filesystemset.resource = Resource_ReadOperations;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7414 "src/y.tab.c"
    break;

  case 780:
#line 2858 "src/p.y"
                                                                                               {
                        filesystemset.resource = Resource_WriteBytes;
                        filesystemset.operator = (yyvsp[-7].number);
                        filesystemset.limit_absolute = (yyvsp[-6].real) * (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7426 "src/y.tab.c"
    break;

  case 781:
#line 2865 "src/p.y"
                                                                                         {
                        filesystemset.resource = Resource_WriteOperations;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7438 "src/y.tab.c"
    break;

  case 782:
#line 2874 "src/p.y"
                                                                                                 {
                        filesystemset.resource = Resource_ServiceTime;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].number);
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7450 "src/y.tab.c"
    break;

  case 783:
#line 2881 "src/p.y"
                                                                                           {
                        filesystemset.resource = Resource_ServiceTime;
                        filesystemset.operator = (yyvsp[-6].number);
                        filesystemset.limit_absolute = (yyvsp[-5].real) * 1000;
                        addeventaction(&(filesystemset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addfilesystem(&filesystemset);
                  }
#line 7462 "src/y.tab.c"
    break;

  case 784:
#line 2890 "src/p.y"
                                                       {
                        addeventaction(&(fsflagset).action, (yyvsp[0].number), Action_Ignored);
                        addfsflag(&fsflagset);
                  }
#line 7471 "src/y.tab.c"
    break;

  case 785:
#line 2896 "src/p.y"
                               { (yyval.number) = Unit_Byte; }
#line 7477 "src/y.tab.c"
    break;

  case 786:
#line 2897 "src/p.y"
                               { (yyval.number) = Unit_Byte; }
#line 7483 "src/y.tab.c"
    break;

  case 787:
#line 2898 "src/p.y"
                               { (yyval.number) = Unit_Kilobyte; }
#line 7489 "src/y.tab.c"
    break;

  case 788:
#line 2899 "src/p.y"
                               { (yyval.number) = Unit_Megabyte; }
#line 7495 "src/y.tab.c"
    break;

  case 789:
#line 2900 "src/p.y"
                               { (yyval.number) = Unit_Gigabyte; }
#line 7501 "src/y.tab.c"
    break;

  case 790:
#line 2903 "src/p.y"
                                                                                  {
                        permset.perm = check_perm((yyvsp[-4].number));
                        addeventaction(&(permset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addperm(&permset);
                  }
#line 7511 "src/y.tab.c"
    break;

  case 791:
#line 2908 "src/p.y"
                                                                            {
                        permset.test_changes = true;
                        addeventaction(&(permset).action, (yyvsp[-1].number), Action_Ignored);
                        addperm(&permset);
                  }
#line 7521 "src/y.tab.c"
    break;

  case 792:
#line 2915 "src/p.y"
                                                                   {
                        matchset.not = (yyvsp[-4].number) == Operator_Equal ? false : true;
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[-3].string);
                        addmatch(&matchset, (yyvsp[0].number), 0);
                  }
#line 7533 "src/y.tab.c"
    break;

  case 793:
#line 2924 "src/p.y"
                                                                 {
                        matchset.not = (yyvsp[-4].number) == Operator_Equal ? false : true;
                        matchset.ignore = false;
                        matchset.match_path = (yyvsp[-3].string);
                        matchset.match_string = NULL;
                        addmatchpath(&matchset, (yyvsp[0].number));
                        FREE((yyvsp[-3].string));
                  }
#line 7546 "src/y.tab.c"
    break;

  case 794:
#line 2932 "src/p.y"
                                                                   {
                        matchset.not = (yyvsp[-4].number) == Operator_Equal ? false : true;
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[-3].string);
                        addmatch(&matchset, (yyvsp[0].number), 0);
                  }
#line 7558 "src/y.tab.c"
    break;

  case 795:
#line 2939 "src/p.y"
                                                  {
                        matchset.not = (yyvsp[-1].number) == Operator_Equal ? false : true;
                        matchset.ignore = true;
                        matchset.match_path = (yyvsp[0].string);
                        matchset.match_string = NULL;
                        addmatchpath(&matchset, Action_Ignored);
                        FREE((yyvsp[0].string));
                  }
#line 7571 "src/y.tab.c"
    break;

  case 796:
#line 2947 "src/p.y"
                                                    {
                        matchset.not = (yyvsp[-1].number) == Operator_Equal ? false : true;
                        matchset.ignore = true;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[0].string);
                        addmatch(&matchset, Action_Ignored, 0);
                  }
#line 7583 "src/y.tab.c"
    break;

  case 797:
#line 2955 "src/p.y"
                                                                {
                        matchset.ignore = false;
                        matchset.match_path = (yyvsp[-3].string);
                        matchset.match_string = NULL;
                        addmatchpath(&matchset, (yyvsp[0].number));
                        FREE((yyvsp[-3].string));
                  }
#line 7595 "src/y.tab.c"
    break;

  case 798:
#line 2962 "src/p.y"
                                                                  {
                        matchset.ignore = false;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[-3].string);
                        addmatch(&matchset, (yyvsp[0].number), 0);
                  }
#line 7606 "src/y.tab.c"
    break;

  case 799:
#line 2968 "src/p.y"
                                                 {
                        matchset.ignore = true;
                        matchset.match_path = (yyvsp[0].string);
                        matchset.match_string = NULL;
                        addmatchpath(&matchset, Action_Ignored);
                        FREE((yyvsp[0].string));
                  }
#line 7618 "src/y.tab.c"
    break;

  case 800:
#line 2975 "src/p.y"
                                                   {
                        matchset.ignore = true;
                        matchset.match_path = NULL;
                        matchset.match_string = (yyvsp[0].string);
                        addmatch(&matchset, Action_Ignored, 0);
                  }
#line 7629 "src/y.tab.c"
    break;

  case 801:
#line 2983 "src/p.y"
                              {
                        matchset.not = false;
                  }
#line 7637 "src/y.tab.c"
    break;

  case 802:
#line 2986 "src/p.y"
                      {
                        matchset.not = true;
                  }
#line 7645 "src/y.tab.c"
    break;

  case 803:
#line 2992 "src/p.y"
                                                                                   {
                        sizeset.operator = (yyvsp[-6].number);
                        sizeset.size = ((unsigned long long)(yyvsp[-5].number) * (yyvsp[-4].number));
                        addeventaction(&(sizeset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addsize(&sizeset);
                  }
#line 7656 "src/y.tab.c"
    break;

  case 804:
#line 2998 "src/p.y"
                                                     {
                        sizeset.test_changes = true;
                        addeventaction(&(sizeset).action, (yyvsp[0].number), Action_Ignored);
                        addsize(&sizeset);
                  }
#line 7666 "src/y.tab.c"
    break;

  case 805:
#line 3005 "src/p.y"
                                                                           {
                        uidset.uid = get_uid((yyvsp[-4].string), 0);
                        addeventaction(&(uidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->uid = adduid(&uidset);
                        FREE((yyvsp[-4].string));
                  }
#line 7677 "src/y.tab.c"
    break;

  case 806:
#line 3011 "src/p.y"
                                                                           {
                    uidset.uid = get_uid(NULL, (yyvsp[-4].number));
                    addeventaction(&(uidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                    current->uid = adduid(&uidset);
                  }
#line 7687 "src/y.tab.c"
    break;

  case 807:
#line 3018 "src/p.y"
                                                                            {
                        uidset.uid = get_uid((yyvsp[-4].string), 0);
                        addeventaction(&(uidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->euid = adduid(&uidset);
                        FREE((yyvsp[-4].string));
                  }
#line 7698 "src/y.tab.c"
    break;

  case 808:
#line 3024 "src/p.y"
                                                                            {
                        uidset.uid = get_uid(NULL, (yyvsp[-4].number));
                        addeventaction(&(uidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->euid = adduid(&uidset);
                  }
#line 7708 "src/y.tab.c"
    break;

  case 809:
#line 3031 "src/p.y"
                                                                                          {
                        addsecurityattribute((yyvsp[-4].string), (yyvsp[-1].number), (yyvsp[0].number));
                  }
#line 7716 "src/y.tab.c"
    break;

  case 810:
#line 3034 "src/p.y"
                                                                                        {
                        addsecurityattribute((yyvsp[-4].string), (yyvsp[-1].number), (yyvsp[0].number));
                  }
#line 7724 "src/y.tab.c"
    break;

  case 811:
#line 3039 "src/p.y"
                                                                                               {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerSystem)
                                addfiledescriptors((yyvsp[-5].number), false, (long long)(yyvsp[-4].number), -1., (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-system filedescriptors statistics is not available on this system\n");
                  }
#line 7735 "src/y.tab.c"
    break;

  case 812:
#line 3045 "src/p.y"
                                                                                                {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerSystem)
                                addfiledescriptors((yyvsp[-6].number), false, -1LL, (yyvsp[-5].real), (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-system filedescriptors statistics is not available on this system\n");
                  }
#line 7746 "src/y.tab.c"
    break;

  case 813:
#line 3053 "src/p.y"
                                                                                                {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerProcess)
                                addfiledescriptors((yyvsp[-5].number), false, (long long)(yyvsp[-4].number), -1., (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-process filedescriptors statistics is not available on this system\n");
                  }
#line 7757 "src/y.tab.c"
    break;

  case 814:
#line 3059 "src/p.y"
                                                                                                {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerProcessMax)
                                addfiledescriptors((yyvsp[-6].number), false, -1LL, (yyvsp[-5].real), (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-process filedescriptors maximum is not exposed on this system, so we cannot compute usage %%, please use the test with absolute value\n");
                  }
#line 7768 "src/y.tab.c"
    break;

  case 815:
#line 3067 "src/p.y"
                                                                                                           {
                        if (systeminfo.statisticsAvailable & Statistics_FiledescriptorsPerProcess)
                                addfiledescriptors((yyvsp[-5].number), true, (long long)(yyvsp[-4].number), -1., (yyvsp[-1].number), (yyvsp[0].number));
                        else
                                yywarning("The per-process filedescriptors statistics is not available on this system\n");
                  }
#line 7779 "src/y.tab.c"
    break;

  case 816:
#line 3075 "src/p.y"
                                                                           {
                        gidset.gid = get_gid((yyvsp[-4].string), 0);
                        addeventaction(&(gidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->gid = addgid(&gidset);
                        FREE((yyvsp[-4].string));
                  }
#line 7790 "src/y.tab.c"
    break;

  case 817:
#line 3081 "src/p.y"
                                                                           {
                        gidset.gid = get_gid(NULL, (yyvsp[-4].number));
                        addeventaction(&(gidset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        current->gid = addgid(&gidset);
                  }
#line 7800 "src/y.tab.c"
    break;

  case 818:
#line 3088 "src/p.y"
                                                                  { /* Deprecated */
                        addeventaction(&(linkstatusset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinkstatus(current, &linkstatusset);
                  }
#line 7809 "src/y.tab.c"
    break;

  case 819:
#line 3092 "src/p.y"
                                                                {
                        linkstatusset.check_invers = false;
                        addeventaction(&(linkstatusset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinkstatus(current, &linkstatusset);
                  }
#line 7819 "src/y.tab.c"
    break;

  case 820:
#line 3097 "src/p.y"
                                                              {
                        linkstatusset.check_invers = true;
                        addeventaction(&(linkstatusset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinkstatus(current, &linkstatusset);
                  }
#line 7829 "src/y.tab.c"
    break;

  case 821:
#line 3104 "src/p.y"
                                                                   {
                        addeventaction(&(linkspeedset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinkspeed(current, &linkspeedset);
                  }
#line 7838 "src/y.tab.c"
    break;

  case 822:
#line 3109 "src/p.y"
                                                                                           {
                        linksaturationset.operator = (yyvsp[-6].number);
                        linksaturationset.limit = (unsigned long long)(yyvsp[-5].number);
                        addeventaction(&(linksaturationset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addlinksaturation(current, &linksaturationset);
                  }
#line 7849 "src/y.tab.c"
    break;

  case 823:
#line 3117 "src/p.y"
                                                                                                 {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-6].number) * (yyvsp[-5].number));
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadbyteslist), &bandwidthset);
                  }
#line 7862 "src/y.tab.c"
    break;

  case 824:
#line 3125 "src/p.y"
                                                                                                     {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-6].number) * (yyvsp[-5].number));
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadbyteslist), &bandwidthset);
                  }
#line 7875 "src/y.tab.c"
    break;

  case 825:
#line 3133 "src/p.y"
                                                                                                            {
                        bandwidthset.operator = (yyvsp[-8].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-7].number) * (yyvsp[-6].number));
                        bandwidthset.rangecount = (yyvsp[-5].number);
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadbyteslist), &bandwidthset);
                  }
#line 7888 "src/y.tab.c"
    break;

  case 826:
#line 3141 "src/p.y"
                                                                                                   {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-6].number);
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadpacketslist), &bandwidthset);
                  }
#line 7901 "src/y.tab.c"
    break;

  case 827:
#line 3149 "src/p.y"
                                                                                                       {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-6].number);
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadpacketslist), &bandwidthset);
                  }
#line 7914 "src/y.tab.c"
    break;

  case 828:
#line 3157 "src/p.y"
                                                                                                              {
                        bandwidthset.operator = (yyvsp[-8].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-7].number);
                        bandwidthset.rangecount = (yyvsp[-5].number);
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->uploadpacketslist), &bandwidthset);
                  }
#line 7927 "src/y.tab.c"
    break;

  case 829:
#line 3167 "src/p.y"
                                                                                                   {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-6].number) * (yyvsp[-5].number));
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadbyteslist), &bandwidthset);
                  }
#line 7940 "src/y.tab.c"
    break;

  case 830:
#line 3175 "src/p.y"
                                                                                                       {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-6].number) * (yyvsp[-5].number));
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadbyteslist), &bandwidthset);
                  }
#line 7953 "src/y.tab.c"
    break;

  case 831:
#line 3183 "src/p.y"
                                                                                                              {
                        bandwidthset.operator = (yyvsp[-8].number);
                        bandwidthset.limit = ((unsigned long long)(yyvsp[-7].number) * (yyvsp[-6].number));
                        bandwidthset.rangecount = (yyvsp[-5].number);
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadbyteslist), &bandwidthset);
                  }
#line 7966 "src/y.tab.c"
    break;

  case 832:
#line 3191 "src/p.y"
                                                                                                     {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-6].number);
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadpacketslist), &bandwidthset);
                  }
#line 7979 "src/y.tab.c"
    break;

  case 833:
#line 3199 "src/p.y"
                                                                                                         {
                        bandwidthset.operator = (yyvsp[-7].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-6].number);
                        bandwidthset.rangecount = 1;
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadpacketslist), &bandwidthset);
                  }
#line 7992 "src/y.tab.c"
    break;

  case 834:
#line 3207 "src/p.y"
                                                                                                                {
                        bandwidthset.operator = (yyvsp[-8].number);
                        bandwidthset.limit = (unsigned long long)(yyvsp[-7].number);
                        bandwidthset.rangecount = (yyvsp[-5].number);
                        bandwidthset.range = (yyvsp[-4].number);
                        addeventaction(&(bandwidthset).action, (yyvsp[-1].number), (yyvsp[0].number));
                        addbandwidth(&(current->downloadpacketslist), &bandwidthset);
                  }
#line 8005 "src/y.tab.c"
    break;

  case 835:
#line 3217 "src/p.y"
                                { (yyval.number) = ICMP_ECHO; }
#line 8011 "src/y.tab.c"
    break;

  case 836:
#line 3220 "src/p.y"
                                        { mailset.reminder = 0; }
#line 8017 "src/y.tab.c"
    break;

  case 837:
#line 3221 "src/p.y"
                                        { mailset.reminder = (yyvsp[0].number); }
#line 8023 "src/y.tab.c"
    break;

  case 838:
#line 3222 "src/p.y"
                                        { mailset.reminder = (yyvsp[-1].number); }
#line 8029 "src/y.tab.c"
    break;


#line 8033 "src/y.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *, YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[+*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 3225 "src/p.y"



/* -------------------------------------------------------- Parser interface */


/**
 * Syntactic error routine
 *
 * This routine is automatically called by the lexer!
 */
void yyerror(const char *s, ...) {
        ASSERT(s);
        char *msg = NULL;
        va_list ap;
        va_start(ap, s);
        msg = Str_vcat(s, ap);
        va_end(ap);
        Log_error("%s:%i: %s '%s'\n", currentfile, lineno, msg, yytext);
        cfg_errflag++;
        FREE(msg);
}


/**
 * Syntactical warning routine
 */
void yywarning(const char *s, ...) {
        ASSERT(s);
        char *msg = NULL;
        va_list ap;
        va_start(ap, s);
        msg = Str_vcat(s, ap);
        va_end(ap);
        Log_warning("%s:%i: %s '%s'\n", currentfile, lineno, msg, yytext);
        FREE(msg);
}


/**
 * Argument error routine
 */
void yyerror2(const char *s, ...) {
        ASSERT(s);
        char *msg = NULL;
        va_list ap;
        va_start(ap, s);
        msg = Str_vcat(s, ap);
        va_end(ap);
        Log_error("%s:%i: %s '%s'\n", argcurrentfile, arglineno, msg, argyytext);
        cfg_errflag++;
        FREE(msg);
}


/**
 * Argument warning routine
 */
void yywarning2(const char *s, ...) {
        ASSERT(s);
        char *msg = NULL;
        va_list ap;
        va_start(ap, s);
        msg = Str_vcat(s, ap);
        va_end(ap);
        Log_warning("%s:%i: %s '%s'\n", argcurrentfile, arglineno, msg, argyytext);
        FREE(msg);
}


/*
 * The Parser hook - start parsing the control file
 * Returns true if parsing succeeded, otherwise false
 */
bool parse(char *controlfile) {
        ASSERT(controlfile);

        if ((yyin = fopen(controlfile,"r")) == (FILE *)NULL) {
                Log_error("Cannot open the control file '%s' -- %s\n", controlfile, STRERROR);
                return false;
        }

        currentfile = Str_dup(controlfile);

        available_statistics(&systeminfo);

        /*
         * Creation of the global service list is synchronized
         */
        LOCK(Run.mutex)
        {
                preparse();
                yyparse();
                fclose(yyin);
                postparse();
        }
        END_LOCK;

        FREE(currentfile);

        if (argyytext != NULL)
                FREE(argyytext);

        /*
         * Secure check the monitrc file. The run control file must have the
         * same uid as the REAL uid of this process, it must have permissions
         * no greater than 700 and it must not be a symbolic link.
         */
        if (! file_checkStat(controlfile, "control file", S_IRUSR|S_IWUSR|S_IXUSR))
                return false;

        return cfg_errflag == 0;
}


/* ----------------------------------------------------------------- Private */


/**
 * Initialize objects used by the parser.
 */
static void preparse() {
        servicelist = tail = current = NULL;
        /* Set instance incarnation ID */
        time(&Run.incarnation);
        /* Reset lexer */
        buffer_stack_ptr            = 0;
        lineno                      = 1;
        arglineno                   = 1;
        argcurrentfile              = NULL;
        argyytext                   = NULL;
        /* Reset parser */
        Run.limits.sendExpectBuffer  = LIMIT_SENDEXPECTBUFFER;
        Run.limits.fileContentBuffer = LIMIT_FILECONTENTBUFFER;
        Run.limits.httpContentBuffer = LIMIT_HTTPCONTENTBUFFER;
        Run.limits.programOutput     = LIMIT_PROGRAMOUTPUT;
        Run.limits.networkTimeout    = LIMIT_NETWORKTIMEOUT;
        Run.limits.programTimeout    = LIMIT_PROGRAMTIMEOUT;
        Run.limits.stopTimeout       = LIMIT_STOPTIMEOUT;
        Run.limits.startTimeout      = LIMIT_STARTTIMEOUT;
        Run.limits.restartTimeout    = LIMIT_RESTARTTIMEOUT;
        Run.onreboot                 = Onreboot_Start;
        Run.mmonitcredentials        = NULL;
        Run.httpd.flags              = Httpd_Disabled | Httpd_Signature;
        Run.httpd.credentials        = NULL;
        memset(&(Run.httpd.socket), 0, sizeof(Run.httpd.socket));
        Run.mailserver_timeout       = SMTP_TIMEOUT;
        Run.eventlist_dir            = NULL;
        Run.eventlist_slots          = -1;
        Run.system                   = NULL;
        Run.mmonits                  = NULL;
        Run.maillist                 = NULL;
        Run.mailservers              = NULL;
        Run.MailFormat.from          = NULL;
        Run.MailFormat.replyto       = NULL;
        Run.MailFormat.subject       = NULL;
        Run.MailFormat.message       = NULL;
        depend_list                  = NULL;
        Run.flags |= Run_HandlerInit | Run_MmonitCredentials;
        for (int i = 0; i <= Handler_Max; i++)
                Run.handler_queue[i] = 0;

        /*
         * Initialize objects
         */
        reset_uidset();
        reset_gidset();
        reset_statusset();
        reset_sizeset();
        reset_mailset();
        reset_sslset();
        reset_mailserverset();
        reset_mmonitset();
        reset_responsetimeset();
        reset_portset();
        reset_permset();
        reset_icmpset();
        reset_linkstatusset();
        reset_linkspeedset();
        reset_linksaturationset();
        reset_bandwidthset();
        reset_rateset(&rate);
        reset_rateset(&rate1);
        reset_rateset(&rate2);
        reset_filesystemset();
        reset_resourceset();
        reset_checksumset();
        reset_timestampset();
        reset_actionrateset();
}


/*
 * Check that values are reasonable after parsing
 */
static void postparse() {
        if (cfg_errflag)
                return;

        /* If defined - add the last service to the service list */
        if (current) {
                addservice(current);
                current = NULL;
        }

        /* Check that we do not start monit in daemon mode without having a poll time */
        if (! Run.polltime && ((Run.flags & Run_Daemon) || (Run.flags & Run_Foreground))) {
                Log_error("Poll time is invalid or not defined. Please define poll time in the control file\nas a number (> 0)  or use the -d option when starting monit\n");
                cfg_errflag++;
        }

        if (Run.files.log)
                Run.flags |= Run_Log;

        /* Add the default general system service if not specified explicitly: service name default to hostname */
        if (! Run.system) {
                char hostname[STRLEN];
                if (gethostname(hostname, sizeof(hostname))) {
                        Log_error("Cannot get system hostname -- please add 'check system <name>'\n");
                        cfg_errflag++;
                }
                if (Util_existService(hostname)) {
                        Log_error("'check system' not defined in control file, failed to add automatic configuration (service name %s is used already) -- please add 'check system <name>' manually\n", hostname);
                        cfg_errflag++;
                }
                Run.system = createservice(Service_System, Str_dup(hostname), NULL, check_system);
                addservice(Run.system);
        }
        addeventaction(&(Run.system->action_MONIT_START), Action_Start, Action_Ignored);
        addeventaction(&(Run.system->action_MONIT_STOP), Action_Stop,  Action_Ignored);

        if (Run.mmonits) {
                if (Run.httpd.flags & Httpd_Net) {
                        if (Run.flags & Run_MmonitCredentials) {
                                Auth_T c;
                                for (c = Run.httpd.credentials; c; c = c->next) {
                                        if (c->digesttype == Digest_Cleartext && ! c->is_readonly) {
                                                Run.mmonitcredentials = c;
                                                break;
                                        }
                                }
                                if (! Run.mmonitcredentials)
                                        Log_warning("M/Monit registration with credentials enabled, but no suitable credentials found in monit configuration file -- please add 'allow user:password' option to 'set httpd' statement\n");
                        }
                } else if (Run.httpd.flags & Httpd_Unix) {
                        Log_warning("M/Monit enabled but Monit httpd is using unix socket -- please change 'set httpd' statement to use TCP port in order to be able to manage services on Monit\n");
                } else {
                        Log_warning("M/Monit enabled but no httpd allowed -- please add 'set httpd' statement\n");
                }
        }

        /* Check the sanity of any dependency graph */
        check_depend();

#if defined HAVE_OPENSSL && defined OPENSSL_FIPS
        Ssl_setFipsMode(Run.flags & Run_FipsEnabled);
#endif

        Processor_setHttpPostLimit();
}


static bool _parseOutgoingAddress(char *ip, Outgoing_T *outgoing) {
        struct addrinfo *result, hints = {.ai_flags = AI_NUMERICHOST};
        int status = getaddrinfo(ip, NULL, &hints, &result);
        if (status == 0) {
                outgoing->ip = ip;
                outgoing->addrlen = result->ai_addrlen;
                memcpy(&(outgoing->addr), result->ai_addr, result->ai_addrlen);
                freeaddrinfo(result);
                return true;
        } else {
                yyerror2("IP address parsing failed for %s -- %s", ip, status == EAI_SYSTEM ? STRERROR : gai_strerror(status));
        }
        return false;
}


/*
 * Create a new service object and add any current objects to the
 * service list.
 */
static Service_T createservice(Service_Type type, char *name, char *value, State_Type (*check)(Service_T s)) {
        ASSERT(name);

        check_name(name);

        if (current)
                addservice(current);

        NEW(current);
        current->type = type;
        switch (type) {
                case Service_Directory:
                        NEW(current->inf.directory);
                        break;
                case Service_Fifo:
                        NEW(current->inf.fifo);
                        break;
                case Service_File:
                        NEW(current->inf.file);
                        break;
                case Service_Filesystem:
                        NEW(current->inf.filesystem);
                        break;
                case Service_Net:
                        NEW(current->inf.net);
                        break;
                case Service_Process:
                        NEW(current->inf.process);
                        break;
                default:
                        break;
        }
        Util_resetInfo(current);

        if (type == Service_Program) {
                NEW(current->program);
                current->program->args = command;
                command = NULL;
                current->program->timeout = Run.limits.programTimeout;
        }

        /* Set default values */
        current->onrebootRestored = false;
        current->mode     = Monitor_Active;
        current->monitor  = Monitor_Init;
        current->onreboot = Run.onreboot;
        current->name     = name;
        current->name_urlescaped = Util_urlEncode(name, false);
        current->name_htmlescaped = escapeHTML(StringBuffer_create(16), name);
        current->check    = check;
        current->path     = value;

        /* Initialize general event handlers */
        addeventaction(&(current)->action_DATA,     Action_Alert,     Action_Alert);
        addeventaction(&(current)->action_EXEC,     Action_Alert,     Action_Alert);
        addeventaction(&(current)->action_INVALID,  Action_Restart,   Action_Alert);

        /* Initialize internal event handlers */
        addeventaction(&(current)->action_ACTION,       Action_Alert, Action_Ignored);

        gettimeofday(&current->collected, NULL);

        return current;
}


/*
 * Add a service object to the servicelist
 */
static void addservice(Service_T s) {
        ASSERT(s);

        // Test sanity check
        switch (s->type) {
                case Service_Host:
                        // Verify that a remote service has a port or an icmp list
                        if (! s->portlist && ! s->icmplist) {
                                Log_error("'check host' statement is incomplete: Please specify a port number to test\n or an icmp test at the remote host: '%s'\n", s->name);
                                cfg_errflag++;
                        }
                        break;
                case Service_Program:
                        // Verify that a program test has a status test
                        if (! s->statuslist && ! s->matchlist) {
                                Log_error("'check program %s' is incomplete: Please add a 'status' or 'content' test\n", s->name);
                                cfg_errflag++;
                        }
                        char program[PATH_MAX];
                        strncpy(program, s->program->args->arg[0], sizeof(program) - 1);
                        // Require that the program exist before creating the Command object
                        if (File_isExecutable(program)) {
                                s->program->C = Command_new(program, NULL);
                                for (int i = 1; i < s->program->args->length; i++) {
                                        Command_appendArgument(s->program->C, s->program->args->arg[i]);
                                        snprintf(program + strlen(program), sizeof(program) - strlen(program) - 1, " %s", s->program->args->arg[i]);
                                }
                                s->path = Str_dup(program);
                                if (s->program->args->has_uid)
                                        Command_setUid(s->program->C, s->program->args->uid);
                                if (s->program->args->has_gid)
                                        Command_setGid(s->program->C, s->program->args->gid);
                                // Set environment
                                Command_setEnv(s->program->C, "MONIT_SERVICE", s->name);
                        } else {
                                Log_error("A 'check program' statement requires the program to exist '%s'\n", program);
                                cfg_errflag++;
                        }
                        break;
                case Service_Net:
                        if (! s->linkstatuslist) {
                                // Add link status test if not defined
                                addeventaction(&(linkstatusset).action, Action_Alert, Action_Alert);
                                addlinkstatus(s, &linkstatusset);
                        }
                        break;
                case Service_Filesystem:
                        if (! s->nonexistlist && ! s->existlist) {
                                // Add non-existence test if not defined
                                addeventaction(&(nonexistset).action, Action_Restart, Action_Alert);
                                addnonexist(&nonexistset);
                        }
                        if (! s->fsflaglist) {
                                // Add filesystem flags change test if not defined
                                addeventaction(&(fsflagset).action, Action_Alert, Action_Ignored);
                                addfsflag(&fsflagset);
                        }
                        break;
                case Service_Directory:
                case Service_Fifo:
                case Service_File:
                case Service_Process:
                        if (! s->nonexistlist && ! s->existlist) {
                                // Add existence test if not defined
                                addeventaction(&(nonexistset).action, Action_Restart, Action_Alert);
                                addnonexist(&nonexistset);
                        }
                        break;
                default:
                        break;
        }

        // No "every" statement was used, monitor each cycle
        if (s->every.type == Every_Initializing)
                s->every.type = Every_Cycle;

        /* Add the service to the end of the service list */
        if (tail != NULL) {
                tail->next = s;
                tail->next_conf = s;
        } else {
                servicelist = s;
                servicelist_conf = s;
        }
        tail = s;
}


/*
 * Add entry to service group list
 */
static void addservicegroup(char *name) {
        ServiceGroup_T g;

        ASSERT(name);

        /* Check if service group with the same name is defined already */
        for (g = servicegrouplist; g; g = g->next)
                if (IS(g->name, name))
                        break;

        if (! g) {
                NEW(g);
                g->name = Str_dup(name);
                g->members = List_new();
                g->next = servicegrouplist;
                servicegrouplist = g;
        }

        List_append(g->members, current);
}


/*
 * Add a dependant entry to the current service dependant list
 */
static void adddependant(char *dependant) {
        Dependant_T d;

        ASSERT(dependant);

        NEW(d);

        if (current->dependantlist)
                d->next = current->dependantlist;

        d->dependant = dependant;
        d->dependant_urlescaped = Util_urlEncode(dependant, false);
        d->dependant_htmlescaped = escapeHTML(StringBuffer_create(16), dependant);
        current->dependantlist = d;

}


/*
 * Add the given mailaddress with the appropriate alert notification
 * values and mail attributes to the given mailinglist.
 */
static void addmail(char *mailto, Mail_T f, Mail_T *l) {
        Mail_T m;

        ASSERT(mailto);

        NEW(m);
        m->to       = mailto;
        m->from     = f->from;
        m->replyto  = f->replyto;
        m->subject  = f->subject;
        m->message  = f->message;
        m->events   = f->events;
        m->reminder = f->reminder;

        m->next = *l;
        *l = m;

        reset_mailset();
}


/*
 * Add the given portset to the current service's portlist
 */
static void addport(Port_T *list, Port_T port) {
        ASSERT(port);

        if (port->protocol->check == check_radius && port->type != Socket_Udp)
                yyerror("Radius protocol test supports UDP only");

        Port_T p;
        NEW(p);
        p->is_available       = Connection_Init;
        p->check_invers       = port->check_invers;
        p->type               = port->type;
        p->socket             = port->socket;
        p->family             = port->family;
        p->action             = port->action;
        p->timeout            = port->timeout;
        p->retry              = port->retry;
        p->protocol           = port->protocol;
        p->hostname           = port->hostname;
        p->url_request        = port->url_request;
        p->outgoing           = port->outgoing;

        if (p->family == Socket_Unix) {
                p->target.unix.pathname = port->target.unix.pathname;
        } else {
                p->target.net.port = port->target.net.port;
                if (sslset.flags) {
#ifdef HAVE_OPENSSL
                        p->target.net.ssl.certificate.minimumDays = port->target.net.ssl.certificate.minimumDays;
                        if (sslset.flags && (p->target.net.port == 25 || p->target.net.port == 143 || p->target.net.port == 587))
                                sslset.flags = SSL_StartTLS;
                        _setSSLOptions(&(p->target.net.ssl.options));
#else
                        yyerror("SSL check cannot be activated -- Monit was not built with SSL support");
#endif
                }
        }
        memcpy(&p->parameters, &port->parameters, sizeof(port->parameters));

        if (p->protocol->check == check_http) {
                if (p->parameters.http.checksum) {
                        cleanup_hash_string(p->parameters.http.checksum);
                        if (strlen(p->parameters.http.checksum) == 32)
                                p->parameters.http.hashtype = Hash_Md5;
                        else if (strlen(p->parameters.http.checksum) == 40)
                                p->parameters.http.hashtype = Hash_Sha1;
                        else
                                yyerror2("invalid checksum [%s]", p->parameters.http.checksum);
                } else {
                        p->parameters.http.hashtype = Hash_Unknown;
                }
                if (! p->parameters.http.method) {
                        p->parameters.http.method = Http_Get;
                } else if (p->parameters.http.method == Http_Head) {
                        // Sanity check: if content or checksum test is used, the method Http_Head is not allowed, as we need the content
                        if ((p->url_request && p->url_request->regex) || p->parameters.http.checksum) {
                                yyerror2("if response content or checksum test is enabled, the HEAD method is not allowed");
                        }
                }
        } else if (p->protocol->check == check_mysql) {
                if (p->parameters.mysql.rsaChecksum) {
                        if (! p->parameters.mysql.username)
                                yyerror2("the rsakey checksum test requires credentials to be defined");
                        if (p->target.net.ssl.options.flags != SSL_Disabled)
                                yyerror2("the rsakey checksum test can be used just with unsecured mysql protocol");
                }
        }

        p->responsetime.limit    = responsetimeset.limit;
        p->responsetime.current  = responsetimeset.current;
        p->responsetime.operator = responsetimeset.operator;

        p->next = *list;
        *list = p;

        reset_sslset();
        reset_responsetimeset();
        reset_portset();

}


static void addhttpheader(Port_T port, char *header) {
        if (! port->parameters.http.headers) {
                port->parameters.http.headers = List_new();
        }
        if (Str_startsWith(header, "Connection:") && ! Str_sub(header, "close")) {
                yywarning("We don't recommend setting the Connection header. Monit will always close the connection even if 'keep-alive' is set\n");
        }
        List_append(port->parameters.http.headers, header);
}


/*
 * Add a new resource object to the current service resource list
 */
static void addresource(Resource_T rr) {
        ASSERT(rr);
        if (Run.flags & Run_ProcessEngineEnabled) {
                Resource_T r;
                NEW(r);
                r->resource_id = rr->resource_id;
                r->limit       = rr->limit;
                r->action      = rr->action;
                r->operator    = rr->operator;
                r->next        = current->resourcelist;
                current->resourcelist = r;
        } else {
                yywarning("Cannot activate service check. The process status engine was disabled. On certain systems you must run monit as root to utilize this feature)\n");
        }
        reset_resourceset();
}


/*
 * Add a new file object to the current service timestamp list
 */
static void addtimestamp(Timestamp_T ts) {
        ASSERT(ts);

        Timestamp_T t;
        NEW(t);
        t->type         = ts->type;
        t->operator     = ts->operator;
        t->time         = ts->time;
        t->action       = ts->action;
        t->test_changes = ts->test_changes;

        t->next = current->timestamplist;
        current->timestamplist = t;

        reset_timestampset();
}


/*
 * Add a new object to the current service actionrate list
 */
static void addactionrate(ActionRate_T ar) {
        ActionRate_T a;

        ASSERT(ar);

        if (ar->count > ar->cycle)
                yyerror2("The number of restarts must be less than poll cycles");
        if (ar->count <= 0 || ar->cycle <= 0)
                yyerror2("Zero or negative values not allowed in a action rate statement");

        NEW(a);
        a->count  = ar->count;
        a->cycle  = ar->cycle;
        a->action = ar->action;

        a->next = current->actionratelist;
        current->actionratelist = a;

        reset_actionrateset();
}



/*
 * Add a new Size object to the current service size list
 */
static void addsize(Size_T ss) {
        Size_T s;
        struct stat buf;

        ASSERT(ss);

        NEW(s);
        s->operator     = ss->operator;
        s->size         = ss->size;
        s->action       = ss->action;
        s->test_changes = ss->test_changes;
        /* Get the initial size for future comparison, if the file exists */
        if (s->test_changes) {
                s->initialized = ! stat(current->path, &buf);
                if (s->initialized)
                        s->size = (unsigned long long)buf.st_size;
        }

        s->next = current->sizelist;
        current->sizelist = s;

        reset_sizeset();
}


/*
 * Add a new Uptime object to the current service uptime list
 */
static void adduptime(Uptime_T uu) {
        Uptime_T u;

        ASSERT(uu);

        NEW(u);
        u->operator = uu->operator;
        u->uptime = uu->uptime;
        u->action = uu->action;

        u->next = current->uptimelist;
        current->uptimelist = u;

        reset_uptimeset();
}


/*
 * Add a new Pid object to the current service pid list
 */
static void addpid(Pid_T pp) {
        ASSERT(pp);

        Pid_T p;
        NEW(p);
        p->action = pp->action;

        p->next = current->pidlist;
        current->pidlist = p;

        reset_pidset();
}


/*
 * Add a new PPid object to the current service ppid list
 */
static void addppid(Pid_T pp) {
        ASSERT(pp);

        Pid_T p;
        NEW(p);
        p->action = pp->action;

        p->next = current->ppidlist;
        current->ppidlist = p;

        reset_ppidset();
}


/*
 * Add a new Fsflag object to the current service fsflag list
 */
static void addfsflag(FsFlag_T ff) {
        ASSERT(ff);

        FsFlag_T f;
        NEW(f);
        f->action = ff->action;

        f->next = current->fsflaglist;
        current->fsflaglist = f;

        reset_fsflagset();
}


/*
 * Add a new Nonexist object to the current service list
 */
static void addnonexist(NonExist_T ff) {
        ASSERT(ff);

        NonExist_T f;
        NEW(f);
        f->action = ff->action;

        f->next = current->nonexistlist;
        current->nonexistlist = f;

        reset_nonexistset();
}


static void addexist(Exist_T rule) {
        ASSERT(rule);
        Exist_T r;
        NEW(r);
        r->action = rule->action;
        r->next = current->existlist;
        current->existlist = r;
        reset_existset();
}


/*
 * Set Checksum object in the current service
 */
static void addchecksum(Checksum_T cs) {
        ASSERT(cs);

        cs->initialized = true;

        if (STR_UNDEF(cs->hash)) {
                if (cs->type == Hash_Unknown)
                        cs->type = Hash_Default;
                if (! (Checksum_getChecksum(current->path, cs->type, cs->hash, sizeof(cs->hash)))) {
                        /* If the file doesn't exist, set dummy value */
                        snprintf(cs->hash, sizeof(cs->hash), cs->type == Hash_Md5 ? "00000000000000000000000000000000" : "0000000000000000000000000000000000000000");
                        cs->initialized = false;
                        yywarning2("Cannot compute a checksum for file %s", current->path);
                }
        }

        int len = cleanup_hash_string(cs->hash);
        if (cs->type == Hash_Unknown) {
                if (len == 32) {
                        cs->type = Hash_Md5;
                } else if (len == 40) {
                        cs->type = Hash_Sha1;
                } else {
                        yyerror2("Unknown checksum type [%s] for file %s", cs->hash, current->path);
                        reset_checksumset();
                        return;
                }
        } else if ((cs->type == Hash_Md5 && len != 32) || (cs->type == Hash_Sha1 && len != 40)) {
                yyerror2("Invalid checksum [%s] for file %s", cs->hash, current->path);
                reset_checksumset();
                return;
        }

        Checksum_T c;
        NEW(c);
        c->type         = cs->type;
        c->test_changes = cs->test_changes;
        c->initialized  = cs->initialized;
        c->action       = cs->action;
        snprintf(c->hash, sizeof(c->hash), "%s", cs->hash);

        current->checksum = c;

        reset_checksumset();

}


/*
 * Set Perm object in the current service
 */
static void addperm(Perm_T ps) {
        ASSERT(ps);

        Perm_T p;
        NEW(p);
        p->action = ps->action;
        p->test_changes = ps->test_changes;
        if (p->test_changes) {
                if (! File_exist(current->path))
                        DEBUG("The path '%s' used in the PERMISSION statement refer to a non-existing object\n", current->path);
                else if ((p->perm = File_mod(current->path)) < 0)
                        yyerror2("Cannot get the timestamp for '%s'", current->path);
                else
                        p->perm &= 07777;
        } else {
                p->perm = ps->perm;
        }
        current->perm = p;
        reset_permset();
}


static void addlinkstatus(Service_T s, LinkStatus_T L) {
        ASSERT(L);

        LinkStatus_T l;

        // Sanity check: we don't support link up/down tests mix
        for (l = s->linkstatuslist; l; l = l->next) {
                if (l->check_invers != L->check_invers)
                        yyerror2("Mixing link up and down tests is not supported");
        }
                        
        if (L->check_invers)
                s->inverseStatus = true;

        NEW(l);
        l->check_invers = L->check_invers;
        l->action = L->action;

        l->next = s->linkstatuslist;
        s->linkstatuslist = l;

        reset_linkstatusset();
}


static void addlinkspeed(Service_T s, LinkSpeed_T L) {
        ASSERT(L);

        LinkSpeed_T l;
        NEW(l);
        l->action = L->action;

        l->next = s->linkspeedlist;
        s->linkspeedlist = l;

        reset_linkspeedset();
}


static void addlinksaturation(Service_T s, LinkSaturation_T L) {
        ASSERT(L);

        LinkSaturation_T l;
        NEW(l);
        l->operator = L->operator;
        l->limit = L->limit;
        l->action = L->action;

        l->next = s->linksaturationlist;
        s->linksaturationlist = l;

        reset_linksaturationset();
}


/*
 * Return Bandwidth object
 */
static void addbandwidth(Bandwidth_T *list, Bandwidth_T b) {
        ASSERT(list);
        ASSERT(b);

        if (b->rangecount * b->range > 24 * Time_Hour) {
                yyerror2("Maximum range for total test is 24 hours");
        } else if (b->range == Time_Minute && b->rangecount > 60) {
                yyerror2("Maximum value for [minute(s)] unit is 60");
        } else if (b->range == Time_Hour && b->rangecount > 24) {
                yyerror2("Maximum value for [hour(s)] unit is 24");
        } else if (b->range == Time_Day && b->rangecount > 1) {
                yyerror2("Maximum value for [day(s)] unit is 1");
        } else {
                if (b->range == Time_Day) {
                        // translate last day -> last 24 hours
                        b->rangecount = 24;
                        b->range = Time_Hour;
                }
                Bandwidth_T bandwidth;
                NEW(bandwidth);
                bandwidth->operator = b->operator;
                bandwidth->limit = b->limit;
                bandwidth->rangecount = b->rangecount;
                bandwidth->range = b->range;
                bandwidth->action = b->action;
                bandwidth->next = *list;
                *list = bandwidth;
        }
        reset_bandwidthset();
}


static void appendmatch(Match_T *list, Match_T item) {
        if (*list) {
                /* Find the end of the list (keep the same patterns order as in the config file) */
                Match_T last;
                for (last = *list; last->next; last = last->next)
                        ;
                last->next = item;
        } else {
                *list = item;
        }
}


/*
 * Set Match object in the current service
 */
static void addmatch(Match_T ms, int actionnumber, int linenumber) {
        Match_T m;

        ASSERT(ms);

        NEW(m);
        NEW(m->regex_comp);

        m->match_string = ms->match_string;
        m->match_path   = ms->match_path ? Str_dup(ms->match_path) : NULL;
        m->action       = ms->action;
        m->not          = ms->not;
        m->ignore       = ms->ignore;
        m->next         = NULL;

        addeventaction(&(m->action), actionnumber, Action_Ignored);

        int reg_return = regcomp(m->regex_comp, ms->match_string, REG_NOSUB|REG_EXTENDED);

        if (reg_return != 0) {
                char errbuf[STRLEN];
                regerror(reg_return, ms->regex_comp, errbuf, STRLEN);
                if (m->match_path != NULL)
                        yyerror2("Regex parsing error: %s on line %i of", errbuf, linenumber);
                else
                        yyerror2("Regex parsing error: %s", errbuf);
        }
        appendmatch(m->ignore ? &current->matchignorelist : &current->matchlist, m);
}


static void addmatchpath(Match_T ms, Action_Type actionnumber) {
        ASSERT(ms->match_path);

        FILE *handle = fopen(ms->match_path, "r");
        if (handle == NULL) {
                yyerror2("Cannot read regex match file (%s)", ms->match_path);
                return;
        }

        // The addeventaction() called from addmatch() will reset the command1 to NULL, but we need to duplicate the command for each line, thus need to save it here
        command_t savecommand = command1;
        for (int linenumber = 1; ! feof(handle); linenumber++) {
                char buf[2048];

                if (! fgets(buf, sizeof(buf), handle))
                        continue;

                size_t len = strlen(buf);

                if (len == 0 || buf[0] == '\n')
                        continue;

                if (buf[len - 1] == '\n')
                        buf[len - 1] = 0;

                ms->match_string = Str_dup(buf);

                if (actionnumber == Action_Exec) {
                        if (command1 == NULL) {
                                ASSERT(savecommand);
                                command1 = copycommand(savecommand);
                        }
                }

                addmatch(ms, actionnumber, linenumber);
        }
        if (actionnumber == Action_Exec && savecommand)
                gccmd(&savecommand);

        fclose(handle);
}


/*
 * Set exit status test object in the current service
 */
static void addstatus(Status_T status) {
        Status_T s;
        ASSERT(status);
        NEW(s);
        s->initialized = status->initialized;
        s->return_value = status->return_value;
        s->operator = status->operator;
        s->action = status->action;
        s->next = current->statuslist;
        current->statuslist = s;

        reset_statusset();
}


/*
 * Set Uid object in the current service
 */
static Uid_T adduid(Uid_T u) {
        ASSERT(u);

        Uid_T uid;
        NEW(uid);
        uid->uid = u->uid;
        uid->action = u->action;
        reset_uidset();
        return uid;
}


/*
 * Set Gid object in the current service
 */
static Gid_T addgid(Gid_T g) {
        ASSERT(g);

        Gid_T gid;
        NEW(gid);
        gid->gid = g->gid;
        gid->action = g->action;
        reset_gidset();
        return gid;
}


/*
 * Add a new filesystem to the current service's filesystem list
 */
static void addfilesystem(FileSystem_T ds) {
        FileSystem_T dev;

        ASSERT(ds);

        NEW(dev);
        dev->resource           = ds->resource;
        dev->operator           = ds->operator;
        dev->limit_absolute     = ds->limit_absolute;
        dev->limit_percent      = ds->limit_percent;
        dev->action             = ds->action;

        dev->next               = current->filesystemlist;
        current->filesystemlist = dev;

        reset_filesystemset();

}


/*
 * Add a new icmp object to the current service's icmp list
 */
static void addicmp(Icmp_T is) {
        Icmp_T icmp;

        ASSERT(is);

        NEW(icmp);
        icmp->family        = is->family;
        icmp->type          = is->type;
        icmp->size          = is->size;
        icmp->count         = is->count;
        icmp->timeout       = is->timeout;
        icmp->action        = is->action;
        icmp->outgoing      = is->outgoing;
        icmp->check_invers  = is->check_invers;
        icmp->is_available  = Connection_Init;

        icmp->responsetime.limit    = responsetimeset.limit;
        icmp->responsetime.current  = responsetimeset.current;
        icmp->responsetime.operator = responsetimeset.operator;

        icmp->next          = current->icmplist;
        current->icmplist   = icmp;

        reset_responsetimeset();
        reset_icmpset();
}


/*
 * Set EventAction object
 */
static void addeventaction(EventAction_T *_ea, Action_Type failed, Action_Type succeeded) {
        EventAction_T ea;

        ASSERT(_ea);

        NEW(ea);
        NEW(ea->failed);
        NEW(ea->succeeded);

        ea->failed->id = failed;
        ea->failed->repeat = repeat1;
        ea->failed->count = rate1.count;
        ea->failed->cycles = rate1.cycles;
        if (failed == Action_Exec) {
                ASSERT(command1);
                ea->failed->exec = command1;
                command1 = NULL;
        }

        ea->succeeded->id = succeeded;
        ea->succeeded->repeat = repeat2;
        ea->succeeded->count = rate2.count;
        ea->succeeded->cycles = rate2.cycles;
        if (succeeded == Action_Exec) {
                ASSERT(command2);
                ea->succeeded->exec = command2;
                command2 = NULL;
        }
        *_ea = ea;
        reset_rateset(&rate);
        reset_rateset(&rate1);
        reset_rateset(&rate2);
        repeat = repeat1 = repeat2 = 0;
}


/*
 * Add a generic protocol handler to
 */
static void addgeneric(Port_T port, char *send, char *expect) {
        Generic_T g = port->parameters.generic.sendexpect;
        if (! g) {
                NEW(g);
                port->parameters.generic.sendexpect = g;
        } else {
                while (g->next)
                        g = g->next;
                NEW(g->next);
                g = g->next;
        }
        if (send) {
                g->send = send;
                g->expect = NULL;
        } else if (expect) {
                int reg_return;
                NEW(g->expect);
                reg_return = regcomp(g->expect, expect, REG_NOSUB|REG_EXTENDED);
                FREE(expect);
                if (reg_return != 0) {
                        char errbuf[STRLEN];
                        regerror(reg_return, g->expect, errbuf, STRLEN);
                        yyerror2("Regex parsing error: %s", errbuf);
                }
                g->send = NULL;
        }
}


/*
 * Add the current command object to the current service object's
 * start or stop program.
 */
static void addcommand(int what, unsigned int timeout) {

        switch (what) {
                case START:   current->start = command; break;
                case STOP:    current->stop = command; break;
                case RESTART: current->restart = command; break;
        }

        command->timeout = timeout;

        command = NULL;

}


/*
 * Add a new argument to the argument list
 */
static void addargument(char *argument) {

        ASSERT(argument);

        if (! command) {
                check_exec(argument);
                NEW(command);
        }

        command->arg[command->length++] = argument;
        command->arg[command->length] = NULL;

        if (command->length >= ARGMAX)
                yyerror("Exceeded maximum number of program arguments");

}


/*
 * Setup a url request for the current port object
 */
static void prepare_urlrequest(URL_T U) {

        ASSERT(U);

        /* Only the HTTP protocol is supported for URLs currently. See also the lexer if this is to be changed in the future */
        portset.protocol = Protocol_get(Protocol_HTTP);

        if (urlrequest == NULL)
                NEW(urlrequest);
        urlrequest->url = U;
        portset.hostname = Str_dup(U->hostname);
        portset.target.net.port = U->port;
        portset.url_request = urlrequest;
        portset.type = Socket_Tcp;
        portset.parameters.http.request = Str_cat("%s%s%s", U->path, U->query ? "?" : "", U->query ? U->query : "");
        if (IS(U->protocol, "https"))
                sslset.flags = SSL_Enabled;
}


/*
 * Set the url request for a port
 */
static void  seturlrequest(int operator, char *regex) {

        ASSERT(regex);

        if (! urlrequest)
                NEW(urlrequest);
        urlrequest->operator = operator;
        int reg_return;
        NEW(urlrequest->regex);
        reg_return = regcomp(urlrequest->regex, regex, REG_NOSUB|REG_EXTENDED);
        if (reg_return != 0) {
                char errbuf[STRLEN];
                regerror(reg_return, urlrequest->regex, errbuf, STRLEN);
                yyerror2("Regex parsing error: %s", errbuf);
        }
}


/*
 * Add a new data recipient server to the mmonit server list
 */
static void addmmonit(Mmonit_T mmonit) {
        ASSERT(mmonit->url);

        Mmonit_T c;
        NEW(c);
        c->url = mmonit->url;
        c->compress = MmonitCompress_Init;
        _setSSLOptions(&(c->ssl));
        if (IS(c->url->protocol, "https")) {
#ifdef HAVE_OPENSSL
                c->ssl.flags = SSL_Enabled;
#else
                yyerror("SSL check cannot be activated -- SSL disabled");
#endif
        }
        c->timeout = mmonit->timeout;
        c->next = NULL;

        if (Run.mmonits) {
                Mmonit_T C;
                for (C = Run.mmonits; C->next; C = C->next)
                        /* Empty */ ;
                C->next = c;
        } else {
                Run.mmonits = c;
        }
        reset_sslset();
        reset_mmonitset();
}


/*
 * Add a new smtp server to the mail server list
 */
static void addmailserver(MailServer_T mailserver) {

        MailServer_T s;

        ASSERT(mailserver->host);

        NEW(s);
        s->host        = mailserver->host;
        s->port        = mailserver->port;
        s->username    = mailserver->username;
        s->password    = mailserver->password;

        if (sslset.flags && (mailserver->port == 25 || mailserver->port == 587))
                sslset.flags = SSL_StartTLS;
        _setSSLOptions(&(s->ssl));

        s->next = NULL;

        if (Run.mailservers) {
                MailServer_T l;
                for (l = Run.mailservers; l->next; l = l->next)
                        /* empty */;
                l->next = s;
        } else {
                Run.mailservers = s;
        }
        reset_mailserverset();
}


/*
 * Return uid if found on the system. If the parameter user is NULL
 * the uid parameter is used for looking up the user id on the system,
 * otherwise the user parameter is used.
 */
static uid_t get_uid(char *user, uid_t uid) {
        char buf[4096];
        struct passwd pwd, *result = NULL;
        if (user) {
                if (getpwnam_r(user, &pwd, buf, sizeof(buf), &result) != 0 || ! result) {
                        yyerror2("Requested user not found on the system");
                        return(0);
                }
        } else {
                if (getpwuid_r(uid, &pwd, buf, sizeof(buf), &result) != 0 || ! result) {
                        yyerror2("Requested uid not found on the system");
                        return(0);
                }
        }
        return(pwd.pw_uid);
}


/*
 * Return gid if found on the system. If the parameter group is NULL
 * the gid parameter is used for looking up the group id on the system,
 * otherwise the group parameter is used.
 */
static gid_t get_gid(char *group, gid_t gid) {
        struct group *grd;

        if (group) {
                grd = getgrnam(group);

                if (! grd) {
                        yyerror2("Requested group not found on the system");
                        return(0);
                }

        } else {

                if (! (grd = getgrgid(gid))) {
                        yyerror2("Requested gid not found on the system");
                        return(0);
                }

        }

        return(grd->gr_gid);

}


/*
 * Add a new user id to the current command object.
 */
static void addeuid(uid_t uid) {
        if (! getuid()) {
                command->has_uid = true;
                command->uid = uid;
        } else {
                yyerror("UID statement requires root privileges");
        }
}


/*
 * Add a new group id to the current command object.
 */
static void addegid(gid_t gid) {
        if (! getuid()) {
                command->has_gid = true;
                command->gid = gid;
        } else {
                yyerror("GID statement requires root privileges");
        }
}


/*
 * Reset the logfile if changed
 */
static void setlogfile(char *logfile) {
        if (Run.files.log) {
                if (IS(Run.files.log, logfile)) {
                        FREE(logfile);
                        return;
                } else {
                        FREE(Run.files.log);
                }
        }
        Run.files.log = logfile;
}


/*
 * Reset the pidfile if changed
 */
static void setpidfile(char *pidfile) {
        if (Run.files.pid) {
                if (IS(Run.files.pid, pidfile)) {
                        FREE(pidfile);
                        return;
                } else {
                        FREE(Run.files.pid);
                }
        }
        Run.files.pid = pidfile;
}


/*
 * Read a apache htpasswd file and add credentials found for username
 */
static void addhtpasswdentry(char *filename, char *username, Digest_Type dtype) {
        char *ht_username = NULL;
        char *ht_passwd = NULL;
        char buf[STRLEN];
        FILE *handle = NULL;
        int credentials_added = 0;

        ASSERT(filename);

        handle = fopen(filename, "r");

        if (handle == NULL) {
                if (username != NULL)
                        yyerror2("Cannot read htpasswd (%s) for user %s", filename, username);
                else
                        yyerror2("Cannot read htpasswd (%s)", filename);
                return;
        }

        while (! feof(handle)) {
                char *colonindex = NULL;

                if (! fgets(buf, STRLEN, handle))
                        continue;

                Str_rtrim(buf);
                Str_curtail(buf, "#");

                if (NULL == (colonindex = strchr(buf, ':')))
                continue;

                ht_passwd = Str_dup(colonindex+1);
                *colonindex = '\0';

                /* In case we have a file in /etc/passwd or /etc/shadow style we
                 *  want to remove ":.*$" and Crypt and MD5 hashed dont have a colon
                 */

                if ((NULL != (colonindex = strchr(ht_passwd, ':'))) && (dtype != Digest_Cleartext))
                        *colonindex = '\0';

                ht_username = Str_dup(buf);

                if (username == NULL) {
                        if (addcredentials(ht_username, ht_passwd, dtype, false))
                                credentials_added++;
                } else if (Str_cmp(username, ht_username) == 0)  {
                        if (addcredentials(ht_username, ht_passwd, dtype, false))
                                credentials_added++;
                } else {
                        FREE(ht_passwd);
                        FREE(ht_username);
                }
        }

        if (credentials_added == 0) {
                if (username == NULL)
                        yywarning2("htpasswd file (%s) has no usable credentials", filename);
                else
                        yywarning2("htpasswd file (%s) has no usable credentials for user %s", filename, username);
        }
        fclose(handle);
}


#ifdef HAVE_LIBPAM
static void addpamauth(char* groupname, int readonly) {
        Auth_T prev = NULL;

        ASSERT(groupname);

        if (! Run.httpd.credentials)
                NEW(Run.httpd.credentials);

        Auth_T c = Run.httpd.credentials;
        do {
                if (c->groupname != NULL && IS(c->groupname, groupname)) {
                        yywarning2("PAM group %s was added already, entry ignored", groupname);
                        FREE(groupname);
                        return;
                }
                prev = c;
                c = c->next;
        } while (c != NULL);

        NEW(prev->next);
        c = prev->next;

        c->next        = NULL;
        c->uname       = NULL;
        c->passwd      = NULL;
        c->groupname   = groupname;
        c->digesttype  = Digest_Pam;
        c->is_readonly = readonly;

        DEBUG("Adding PAM group '%s'\n", groupname);

        return;
}
#endif


/*
 * Add Basic Authentication credentials
 */
static bool addcredentials(char *uname, char *passwd, Digest_Type dtype, bool readonly) {
        Auth_T c;

        ASSERT(uname);
        ASSERT(passwd);

        if (strlen(passwd) > Str_compareConstantTimeStringLength) {
                yyerror2("Password for user %s is too long, maximum %d allowed", uname, Str_compareConstantTimeStringLength);
                FREE(uname);
                FREE(passwd);
                return false;
        }

        if (! Run.httpd.credentials) {
                NEW(Run.httpd.credentials);
                c = Run.httpd.credentials;
        } else {
                if (Util_getUserCredentials(uname) != NULL) {
                        yywarning2("Credentials for user %s were already added, entry ignored", uname);
                        FREE(uname);
                        FREE(passwd);
                        return false;
                }
                c = Run.httpd.credentials;
                while (c->next != NULL)
                        c = c->next;
                NEW(c->next);
                c = c->next;
        }

        c->next        = NULL;
        c->uname       = uname;
        c->passwd      = passwd;
        c->groupname   = NULL;
        c->digesttype  = dtype;
        c->is_readonly = readonly;

        DEBUG("Adding credentials for user '%s'\n", uname);

        return true;

}


/*
 * Set the syslog and the facilities to be used
 */
static void setsyslog(char *facility) {

        if (! Run.files.log || ihp.logfile) {
                ihp.logfile = true;
                setlogfile(Str_dup("syslog"));
                Run.flags |= Run_UseSyslog;
                Run.flags |= Run_Log;
        }

        if (facility) {
                if (IS(facility,"log_local0"))
                        Run.facility = LOG_LOCAL0;
                else if (IS(facility, "log_local1"))
                        Run.facility = LOG_LOCAL1;
                else if (IS(facility, "log_local2"))
                        Run.facility = LOG_LOCAL2;
                else if (IS(facility, "log_local3"))
                        Run.facility = LOG_LOCAL3;
                else if (IS(facility, "log_local4"))
                        Run.facility = LOG_LOCAL4;
                else if (IS(facility, "log_local5"))
                        Run.facility = LOG_LOCAL5;
                else if (IS(facility, "log_local6"))
                        Run.facility = LOG_LOCAL6;
                else if (IS(facility, "log_local7"))
                        Run.facility = LOG_LOCAL7;
                else if (IS(facility, "log_daemon"))
                        Run.facility = LOG_DAEMON;
                else
                        yyerror2("Invalid syslog facility");
        } else {
                Run.facility = LOG_USER;
        }

}


/*
 * Reset the current sslset for reuse
 */
static void reset_sslset() {
        memset(&sslset, 0, sizeof(struct SslOptions_T));
        sslset.version = sslset.verify = sslset.allowSelfSigned = -1;
}


/*
 * Reset the current mailset for reuse
 */
static void reset_mailset() {
        memset(&mailset, 0, sizeof(struct Mail_T));
}


/*
 * Reset the mailserver set to default values
 */
static void reset_mailserverset() {
        memset(&mailserverset, 0, sizeof(struct MailServer_T));
        mailserverset.port = PORT_SMTP;
}


/*
 * Reset the mmonit set to default values
 */
static void reset_mmonitset() {
        memset(&mmonitset, 0, sizeof(struct Mmonit_T));
        mmonitset.timeout = Run.limits.networkTimeout;
}


/*
 * Reset the Port set to default values
 */
static void reset_portset() {
        memset(&portset, 0, sizeof(struct Port_T));
        portset.check_invers = false;
        portset.socket = -1;
        portset.type = Socket_Tcp;
        portset.family = Socket_Ip;
        portset.timeout = Run.limits.networkTimeout;
        portset.retry = 1;
        portset.protocol = Protocol_get(Protocol_DEFAULT);
        urlrequest = NULL;
}


/*
 * Reset the Proc set to default values
 */
static void reset_resourceset() {
        resourceset.resource_id = 0;
        resourceset.limit = 0;
        resourceset.action = NULL;
        resourceset.operator = Operator_Equal;
}


/*
 * Reset the Timestamp set to default values
 */
static void reset_timestampset() {
        timestampset.type = Timestamp_Default;
        timestampset.operator = Operator_Equal;
        timestampset.time = 0;
        timestampset.test_changes = false;
        timestampset.initialized = false;
        timestampset.action = NULL;
}


/*
 * Reset the ActionRate set to default values
 */
static void reset_actionrateset() {
        actionrateset.count = 0;
        actionrateset.cycle = 0;
        actionrateset.action = NULL;
}


/*
 * Reset the Size set to default values
 */
static void reset_sizeset() {
        sizeset.operator = Operator_Equal;
        sizeset.size = 0;
        sizeset.test_changes = false;
        sizeset.action = NULL;
}


/*
 * Reset the Uptime set to default values
 */
static void reset_uptimeset() {
        uptimeset.operator = Operator_Equal;
        uptimeset.uptime = 0;
        uptimeset.action = NULL;
}


static void reset_responsetimeset() {
        responsetimeset.operator = Operator_Less;
        responsetimeset.current = 0.;
        responsetimeset.limit = -1.;
}


static void reset_linkstatusset() {
        linkstatusset.check_invers = false;
        linkstatusset.action = NULL;
}


static void reset_linkspeedset() {
        linkspeedset.action = NULL;
}


static void reset_linksaturationset() {
        linksaturationset.limit = 0.;
        linksaturationset.operator = Operator_Equal;
        linksaturationset.action = NULL;
}


/*
 * Reset the Bandwidth set to default values
 */
static void reset_bandwidthset() {
        bandwidthset.operator = Operator_Equal;
        bandwidthset.limit = 0ULL;
        bandwidthset.action = NULL;
}


/*
 * Reset the Pid set to default values
 */
static void reset_pidset() {
        pidset.action = NULL;
}


/*
 * Reset the PPid set to default values
 */
static void reset_ppidset() {
        ppidset.action = NULL;
}


/*
 * Reset the Fsflag set to default values
 */
static void reset_fsflagset() {
        fsflagset.action = NULL;
}


/*
 * Reset the Nonexist set to default values
 */
static void reset_nonexistset() {
        nonexistset.action = NULL;
}


static void reset_existset() {
        existset.action = NULL;
}


/*
 * Reset the Checksum set to default values
 */
static void reset_checksumset() {
        checksumset.type         = Hash_Unknown;
        checksumset.test_changes = false;
        checksumset.action       = NULL;
        *checksumset.hash        = 0;
}


/*
 * Reset the Perm set to default values
 */
static void reset_permset() {
        permset.test_changes = false;
        permset.perm = 0;
        permset.action = NULL;
}


/*
 * Reset the Status set to default values
 */
static void reset_statusset() {
        statusset.initialized = false;
        statusset.return_value = 0;
        statusset.operator = Operator_Equal;
        statusset.action = NULL;
}


/*
 * Reset the Uid set to default values
 */
static void reset_uidset() {
        uidset.uid = 0;
        uidset.action = NULL;
}


/*
 * Reset the Gid set to default values
 */
static void reset_gidset() {
        gidset.gid = 0;
        gidset.action = NULL;
}


/*
 * Reset the Filesystem set to default values
 */
static void reset_filesystemset() {
        filesystemset.resource = 0;
        filesystemset.operator = Operator_Equal;
        filesystemset.limit_absolute = -1;
        filesystemset.limit_percent = -1.;
        filesystemset.action = NULL;
}


/*
 * Reset the ICMP set to default values
 */
static void reset_icmpset() {
        icmpset.type = ICMP_ECHO;
        icmpset.size = ICMP_SIZE;
        icmpset.count = ICMP_ATTEMPT_COUNT;
        icmpset.timeout = Run.limits.networkTimeout;
        icmpset.check_invers = false;
        icmpset.action = NULL;
}


/*
 * Reset the Rate set to default values
 */
static void reset_rateset(struct rate_t *r) {
        r->count = 1;
        r->cycles = 1;
}


/* ---------------------------------------------------------------- Checkers */


/*
 * Check for unique service name
 */
static void check_name(char *name) {
        ASSERT(name);

        if (Util_existService(name) || (current && IS(name, current->name)))
                yyerror2("Service name conflict, %s already defined", name);
        if (name && *name == '/')
                yyerror2("Service name '%s' must not start with '/' -- ", name);
}


/*
 * Permission statement semantic check
 */
static int check_perm(int perm) {
        int result;
        char *status;
        char buf[STRLEN];

        snprintf(buf, STRLEN, "%d", perm);

        result = (int)strtol(buf, &status, 8);

        if (*status != '\0' || result < 0 || result > 07777)
                yyerror2("Permission statements must have an octal value between 0 and 7777");

        return result;
}


/*
 * Check the dependency graph for errors
 * by doing a topological sort, thereby finding any cycles.
 * Assures that graph is a Directed Acyclic Graph (DAG).
 */
static void check_depend() {
        Service_T depends_on = NULL;
        Service_T* dlt = &depend_list; /* the current tail of it                                 */
        bool done;                /* no unvisited nodes left?                               */
        bool found_some;          /* last iteration found anything new ?                    */
        depend_list = NULL;            /* depend_list will be the topological sorted servicelist */

        do {
                done = true;
                found_some = false;
                for (Service_T s = servicelist; s; s = s->next) {
                        Dependant_T d;
                        if (s->visited)
                                continue;
                        done = false; // still unvisited nodes
                        depends_on = NULL;
                        for (d = s->dependantlist; d; d = d->next) {
                                Service_T dp = Util_getService(d->dependant);
                                if (! dp) {
                                        Log_error("Depending service '%s' is not defined in the control file\n", d->dependant);
                                        exit(1);
                                }
                                if (! dp->visited) {
                                        depends_on = dp;
                                }
                        }

                        if (! depends_on) {
                                s->visited = true;
                                found_some = true;
                                *dlt = s;
                                dlt = &s->next_depend;
                        }
                }
        } while (found_some && ! done);

        if (! done) {
                ASSERT(depends_on);
                Log_error("Found a depend loop in the control file involving the service '%s'\n", depends_on->name);
                exit(1);
        }

        ASSERT(depend_list);
        servicelist = depend_list;

        for (Service_T s = depend_list; s; s = s->next_depend)
                s->next = s->next_depend;
}


// Check and warn if the executable does not exist
static void check_exec(char *exec) {
        if (! File_exist(exec))
                yywarning2("Program does not exist:");
        else if (! File_isExecutable(exec))
                yywarning2("Program is not executable:");
}


/* Return a valid max forward value for SIP header */
static int verifyMaxForward(int mf) {
        if (mf == 0) {
                return INT_MAX; // Differentiate uninitialized (0) and explicit zero
        } else if (mf > 0 && mf <= 255) {
                return mf;
        }
        yywarning2("SIP max forward is outside the range [0..255]. Setting max forward to 70");
        return 70;
}


/* -------------------------------------------------------------------- Misc */


/*
 * Cleans up a hash string, tolower and remove byte separators
 */
static int cleanup_hash_string(char *hashstring) {
        int i = 0, j = 0;

        ASSERT(hashstring);

        while (hashstring[i]) {
                if (isxdigit((int)hashstring[i])) {
                        hashstring[j] = tolower((int)hashstring[i]);
                        j++;
                }
                i++;
        }
        hashstring[j] = 0;
        return j;
}


/* Return deep copy of the command */
static command_t copycommand(command_t source) {
        int i;
        command_t copy = NULL;

        NEW(copy);
        copy->length = source->length;
        copy->has_uid = source->has_uid;
        copy->uid = source->uid;
        copy->has_gid = source->has_gid;
        copy->gid = source->gid;
        copy->timeout = source->timeout;
        for (i = 0; i < copy->length; i++)
                copy->arg[i] = Str_dup(source->arg[i]);
        copy->arg[copy->length] = NULL;

        return copy;
}


static void _setPEM(char **store, char *path, const char *description, bool isFile) {
        if (*store) {
                yyerror2("Duplicate %s", description);
                FREE(path);
        } else if (! File_exist(path)) {
                yyerror2("%s doesn't exist", description);
                FREE(path);
        } else if (! (isFile ? File_isFile(path) : File_isDirectory(path))) {
                yyerror2("%s is not a %s", description, isFile ? "file" : "directory");
                FREE(path);
        } else if (! File_isReadable(path)) {
                yyerror2("Cannot read %s", description);
                FREE(path);
        } else {
                sslset.flags = SSL_Enabled;
                *store = path;
        }
}


static void _setSSLOptions(SslOptions_T options) {
        options->allowSelfSigned = sslset.allowSelfSigned;
        options->CACertificateFile = sslset.CACertificateFile;
        options->CACertificatePath = sslset.CACertificatePath;
        options->checksum = sslset.checksum;
        options->checksumType = sslset.checksumType;
        options->ciphers = sslset.ciphers;
        options->clientpemfile = sslset.clientpemfile;
        options->flags = sslset.flags;
        options->pemfile = sslset.pemfile;
        options->pemchain = sslset.pemchain;
        options->pemkey = sslset.pemkey;
        options->verify = sslset.verify;
        options->version = sslset.version;
        reset_sslset();
}


#ifdef HAVE_OPENSSL
static void _setSSLVersion(short version) {
        sslset.flags = SSL_Enabled;
        if (sslset.version == -1)
                sslset.version = version;
        else
                sslset.version |= version;
}
#endif


static void _unsetSSLVersion(short version) {
        if (sslset.version != -1)
                sslset.version &= ~version;
}


static void addsecurityattribute(char *value, Action_Type failed, Action_Type succeeded) {
        SecurityAttribute_T attr;
        NEW(attr);
        addeventaction(&(attr->action), failed, succeeded);
        attr->attribute = value;
        attr->next = current->secattrlist;
        current->secattrlist = attr;
}


static void addfiledescriptors(Operator_Type operator, bool total, long long value_absolute, float value_percent, Action_Type failed, Action_Type succeeded) {
        Filedescriptors_T fds;
        NEW(fds);
        addeventaction(&(fds->action), failed, succeeded);
        fds->total = total;
        fds->limit_absolute = value_absolute;
        fds->limit_percent = value_percent;
        fds->operator = operator;
        fds->next = current->filedescriptorslist;
        current->filedescriptorslist = fds;
}

static void _sanityCheckEveryStatement(Service_T s) {
        if (s->every.type != Every_Initializing) {
                yywarning2("The 'every' statement can be specified only once, the last value will be used\n");
                switch (s->every.type) {
                        case Every_Cron:
                        case Every_NotInCron:
                                FREE(s->every.spec.cron);
                                break;
                        default:
                                break;
                }
        }
}

