<!-- $Id: mh.php 598 2006-05-31 21:34:20Z wohler $ -->

<?
$jerryCopyrightHolder
   = "<a href=\"http://www.jpeek.com/contact.html\">Jerry Peek</a>";
$oreillyCopyrightHolder =
   "<a href=\"http://www.oreilly.com/\">O'Reilly Media, Inc.</a>";
$billCopyrightHolder =
   "<a href=\"http://www.newt.com/wohler/\">Bill Wohler</a>";
$bookVersion = 'May, 2006';

/**
 * includeHeader(string $previous, string $next[, $back])
 *
 * Includes the MH book header. The arguments $previous and $next are
 * href targets. Optional argument $back replaces the previous and
 * next link with a back link.
 *
 * The global variable $book is used to find the book's files.
 *
 * For example:
 *
 * <body>
 *   <?
 *      $book = '.';
 *      include "$book/mh.php";
 *      includeHeader('ack.html', 'whaema.html');
 *   ?>
 *   ...
 *
 * Thanks to http://www.newt.com/, http://www.bytemobile.com/ and
 * http://www.ravenflow.com/ for ideas.
 */

function includeHeader($previous, $next, $back = '') {
    GLOBAL $bookVersion;
    GLOBAL $book;
?>

<div class="headliner"></div>

<div class="small-logo">
  <img src="<?=$book?>/overall/figs/mh-octopus.png"
       alt="MH book cover"
       width=110 height=88>
</div>

<div style="margin-left: 230px">
  <h1 style="margin-bottom: 0px">
    MH &amp; nmh: Email for Users &amp; Programmers
  </h1>

  <div class="book-version"><?=$bookVersion?></div>
</div>

<!-- Navigation Bar -->
<div class="navbar">
<?
   if ($back) {
?>
  <a class="navbar" href="<?=$back?>">Back</a>
<?
   } else {
?>
  <a class="navbar" href="<?=$next?>">Next</a>
  <a class="navbar" href="<?=$previous?>">Previous</a>
<?
   }
?>
  <a class="navbar" href="<?=$book?>/index.html">Table of Contents</a>
  <a class="navbar" href="<?=$book?>/index/">Index</a>
  <!-- SiteSearch Google -->
  <form method="GET" action="http://www.google.com/search"
        class="navbar-search">
    <input type=hidden name=ie value=UTF-8>
    <input type=hidden name=oe value=UTF-8>
    <input type=hidden name=sitesearch value="rand-mh.sourceforge.net">
    <input type=text name=q size=25 maxlength=255 value="Google Search"
           class="navbar-search-text">
    <input type=image name=btnG
           src="<?=$book?>/overall/figs/search-arrow.png" alt="Search"
           class="navbar-search-button">
  </form>
  <!-- SiteSearch Google -->
</div>

<?
}

/**
 * includeFooter(string $lastModified, string $copyright)
 *
 * Includes the MH book footer. The $lastModified date can come
 * directly from Subversion--the label and dollar signs will be
 * stripped. The $copyright is in the form ENTRY[; ENTRY]... where ENTRY is
 * of the form HOLDER: YEAR[, YEAR].... HOLDER is one of: "Jerry", "Bill",
 * "OReilly".
 *
 * For example:
 *
 *     ...
 *     <?
 *       includeFooter('$Date: 2006-05-31 14:34:20 -0700 (Wed, 31 May 2006) $',
 *                     'OReilly: 1991, 1992, 1995; Bill: 2006');
 *     ?>
 *   </body>
 * </html>
 *
 * The global variable $book is used to find the book's files but is
 * only needed if $copyright is non-empty. See includeHeader.
 */

function includeFooter($lastModified, $copyright) {
   GLOBAL $book;
   GLOBAL $oreillyCopyrightHolder;
   GLOBAL $jerryCopyrightHolder;
   GLOBAL $billCopyrightHolder;

   // Clean up lastModified string.
   // $Date is interpreted as a variable and will be empty.
   $lastModified = ereg_replace('^(\\$Date)?: ', '', $lastModified);
   $lastModified = ereg_replace(' *\\([^)]+\\) *\\$', '', $lastModified);

   $copyright = strtolower($copyright);
   $copyrightCount = 0;
   if (preg_match('/oreilly: ([0-9, ]+)/', $copyright, $matches)) {
       $copyrightHolderUrl[$copyrightCount] = $oreillyCopyrightHolder;
       $copyrightYears[$copyrightCount++] = $matches[1];
   }
   if (preg_match('/jerry: ([0-9, ]+)/', $copyright, $matches)) {
       $copyrightHolderUrl[$copyrightCount] = $jerryCopyrightHolder;
       $copyrightYears[$copyrightCount++] = $matches[1];
   }
   if (preg_match('/bill: ([0-9, ]+)/', $copyright, $matches)) {
       $copyrightHolderUrl[$copyrightCount] = $billCopyrightHolder;
       $copyrightYears[$copyrightCount++] = $matches[1];
   }
?>

<hr class="clear">

<p class="copyright">

<?
   if (preg_match('/oreilly/', $copyright)) {
?>

This file is from the third edition of the book <i>MH &amp; xmh: Email
for Users &amp; Programmers</i>, ISBN 1-56592-093-7, by Jerry Peek.

<?
   } elseif (preg_match('/jerry/', $copyright)) {
?>

This file first appeared in the updated online edition of the
book <i>MH &amp; nmh: Email for Users &amp; Programmers</i>, by Jerry
Peek.

<?
   }
   if ($copyright) {
?>

It is freely available; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation. For more information,
see <a href="<?=$book?>/copying.html">COPYING</a>.

<?
   }
?>

<table width="100%">
  <tr>

    <td class="copyright" style="width:50%;padding-top: 5px">
<?
      for ($i = 0; $i < $copyrightCount; $i++) {
          print("Copyright &copy; $copyrightYears[$i] " .
                "$copyrightHolderUrl[$i] <br>\n");
      }
?>
      <strong><i>Last modified</i></strong>: <?=$lastModified?>
    </td>

    <td valign="top">
      <a href="http://www.anybrowser.org/campaign/">
        <img src="http://www.anybrowser.org/campaign/bvgraphics/dankarran.gif"
             alt="Best Viewed With YOUR Browser"
             width="88" height="31" style="margin-top: 5px">
      </a>
      <a href="http://validator.w3.org/check?uri=referer">
        <img src="http://www.w3.org/Icons/valid-html401"
             alt="Valid HTML 4.01!"
             width="88" height="31" style="margin-top: 5px">
      </a>
      <a href="http://jigsaw.w3.org/css-validator/">
        <img src="http://jigsaw.w3.org/css-validator/images/vcss" 
             alt="Valid CSS!"
             width="88" height="31" style="margin-top: 5px">
      </a>
      <a href="http://sourceforge.net">
        <img src="http://sflogo.sourceforge.net/sflogo.php?group_id=143658&amp;type=1"
             alt="SourceForge.net Logo"
             width="88" height="31" style="margin-top: 5px"/>
      </a>
    </td>
  </tr>
</table>

<?
}

function includeOutline($filename) {
   if (!is_file($filename)) {
       return false;
   }
   
   $contents = quoteHtmlChars($filename);

   // Section headings.
   $contents = preg_replace('/^\* (.+)$/m', '<h2>$1</h2>', $contents);   
   $contents = preg_replace('/^\*\* (.+)$/m', '<h3>$1</h3>', $contents);   

   // Replace blank lines with paragraphs.
   $contents = preg_replace('/^$/m', '<p>', $contents);   

   // Insert breaks before footnotes, except for the first which
   // already has a paragraph marker in front of it.
   $contents = preg_replace('/^(([02-9]+|1[0-9]+)\.)/m', '<br>$1', 
       $contents);   

   // Suppress form feeds and Emacs local variables.
   $contents = preg_replace('/^\f/m', '', $contents);   
   $contents = preg_replace('/Local variables[\t-~]+/', '',
       $contents);   

   echo $contents;

   return true;
}

function quoteHtmlChars($filename) {
   if (!is_file($filename)) {
       return false;
   }

   ob_start();
   include $filename;
   $contents = ob_get_contents();
   ob_end_clean();
   $contents = htmlspecialchars($contents);

   return $contents;
}
?>
