/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <Xm/TextF.h>

#ifndef GridDrawer_H
#include "GridDrawer.h"
#endif

#ifndef EditorDrawerFactory_H
#include "EditorDrawerFactory.h"
#endif

#ifndef ViewEditor_H
#include "ViewEditor.h"
#endif

#ifndef XMText_H
#include "XMText.h"
#endif


GridDrawer::GridDrawer(ViewEditor& e):
	XEditorDrawer<UIGridDrawer_c>(e),
	editor_(e),
	cm_x_(false),
	cm_y_(false)
{
}

GridDrawer::~GridDrawer()
{
}

void GridDrawer::edit(IconObject*)
{
	setGrid();
}

void GridDrawer::setGrid()
{
	double x,y;
	editor_.getGrid(x,y);

	double h,v;
	editor_.getPaperSize(h,v);

	if(cm_x_) x = h * x; else x *= 100; 
	if(cm_y_) y = v * y; else y *= 100;

	XMText(x_).set(x);
	XMText(y_).set(y);
}

void GridDrawer::setCB(Widget w,XtPointer)
{
	double x,y;

	XMText(x_).get(x);
	XMText(y_).get(y);

	double h,v;
	editor_.getPaperSize(h,v);

	if(cm_x_) x = x / h ; else x /= 100.0;
	if(cm_y_) y = y / v ; else y /= 100.0;

	editor_.setGrid(x,y);

}

void GridDrawer::snapCB(Widget w,XtPointer data)
{
	XmToggleButtonCallbackStruct* cb = (XmToggleButtonCallbackStruct*)data;
	editor_.snapGrid(cb->set);
}

void GridDrawer::showCB(Widget w,XtPointer data)
{
	XmToggleButtonCallbackStruct* cb = (XmToggleButtonCallbackStruct*)data;
	editor_.showGrid(cb->set);
}

void GridDrawer::xEntryCB(Widget w,XtPointer data)
{
	XmRowColumnCallbackStruct* cb = (XmRowColumnCallbackStruct*)data;
	cm_x_ = XtName(cb->widget)[0] != '%';
	setGrid();
}

void GridDrawer::yEntryCB(Widget w,XtPointer data)
{
	XmRowColumnCallbackStruct* cb = (XmRowColumnCallbackStruct*)data;
	cm_y_ = XtName(cb->widget)[0] != '%';
	setGrid();
}

static EditorDrawerMaker<GridDrawer,ViewEditor> maker(11);

