// Author(s): Aad Mathijssen
// Copyright: see the accompanying file COPYING or copy at
// https://svn.win.tue.nl/trac/MCRL2/browser/trunk/COPYING
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
/// \file toolset_version.cpp

/*
 * The MCRL2_VERSION constant is declared in toolset_version_const.h, which
 * is a file generated by the build system. This constant is separated from
 * the declaration of get_toolset_version() so we do not have to recompile
 * the entire toolkit when the version number changes (only 
 * toolset_version.cpp depends on toolset_version_const.h).
 */

#include "mcrl2/utilities/toolset_version.h"
#include "mcrl2/utilities/toolset_version_const.h"

std::string mcrl2::utilities::get_toolset_version()
{
  return MCRL2_VERSION;
}
