# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_context_item import AbstractContextItem


class ChartMatrix(AbstractContextItem):
    r"""
    ChartMatrix - container for a matrix of charts.
    
    Superclass: AbstractContextItem
    
    This class contains a matrix of charts. These charts will be of type
    ChartXY by default, but this can be overridden. The class will
    manage their layout and object lifetime.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkChartMatrix, obj, update, **traits)
    
    def get_borders(self, *args):
        """
        get_borders(self, borders:[int, int, int, int]) -> None
        C++: virtual void get_borders(int borders[4])"""
        ret = self._wrap_call(self._vtk_obj.GetBorders, *args)
        return ret

    def set_borders(self, *args):
        """
        set_borders(self, left:int, bottom:int, right:int, top:int) -> None
        C++: virtual void set_borders(int left, int bottom, int right,
            int top)
        Set/get the borders of the chart matrix (space in pixels around
        each chart).
        """
        ret = self._wrap_call(self._vtk_obj.SetBorders, *args)
        return ret

    def get_chart(self, *args):
        """
        get_chart(self, position:Vector2i) -> Chart
        C++: virtual Chart *get_chart(const Vector2i &position)
        Get the specified chart element, if the element does not exist
        nullptr will be returned. If the chart element has not yet been
        allocated it will be at this point.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetChart, *my_args)
        return wrap_vtk(ret)

    def set_chart(self, *args):
        """
        set_chart(self, position:Vector2i, chart:Chart) -> bool
        C++: virtual bool set_chart(const Vector2i &position,
            Chart *chart)
        Set the chart element, note that the chart matrix must be large
        enough to accommodate the element being set. Note that this class
        will take ownership of the chart object.
        \\return false if the element cannot be set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetChart, *my_args)
        return ret

    def get_chart_matrix(self, *args):
        """
        get_chart_matrix(self, position:Vector2i) -> ChartMatrix
        C++: virtual ChartMatrix *get_chart_matrix(
            const Vector2i &position)
        Get the specified chart matrix element. if the element does not
        exist, nullptr will be returned. If the element has not yet been
        allocated it will be at this point
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetChartMatrix, *my_args)
        return wrap_vtk(ret)

    def set_chart_matrix(self, *args):
        """
        set_chart_matrix(self, position:Vector2i,
            chartMatrix:ChartMatrix) -> bool
        C++: virtual bool set_chart_matrix(const Vector2i &position,
            ChartMatrix *chartMatrix)
        Set the element at position to a chart matrix, note that the
        chart matrix must be large enough to accommodate the element
        being set. Note that this class will take ownership of the chart
        matrix object.
        \\return false if the element cannot be set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetChartMatrix, *my_args)
        return ret

    def get_chart_span(self, *args):
        """
        get_chart_span(self, position:Vector2i) -> Vector2i
        C++: virtual Vector2i get_chart_span(const Vector2i &position)
        Get the span of the specified element.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetChartSpan, *my_args)
        return wrap_vtk(ret)

    def set_chart_span(self, *args):
        """
        set_chart_span(self, position:Vector2i, span:Vector2i) -> bool
        C++: virtual bool set_chart_span(const Vector2i &position,
            const Vector2i &span)
        Set the span of an element in the matrix. This defaults to 1x1,
        and cannot exceed the remaining space in x or y.
        \\return false If the span is not possible.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetChartSpan, *my_args)
        return ret

    def get_chart_index(self, *args):
        """
        get_chart_index(self, position:Vector2f) -> Vector2i
        C++: virtual Vector2i get_chart_index(
            const Vector2f &position)
        Get the position of an element in the matrix at the specified
        location. The position should be specified in scene coordinates.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetChartIndex, *my_args)
        return wrap_vtk(ret)

    def get_flat_index(self, *args):
        """
        get_flat_index(self, index:Vector2i) -> int
        C++: virtual std::size_t get_flat_index(const Vector2i &index)
        Get internal 1-D index corresponding to the 2-D element index.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetFlatIndex, *my_args)
        return ret

    def _get_number_of_charts(self):
        return self._vtk_obj.GetNumberOfCharts()
    number_of_charts = traits.Property(_get_number_of_charts, desc=\
        r"""
        Total number of charts within this chart matrix.
        """
    )

    def allocate(self):
        """
        allocate(self) -> None
        C++: virtual void allocate()
        Allocate the charts, this will cause any null chart to be
        allocated.
        """
        ret = self._vtk_obj.Allocate()
        return ret
        

    def clear_specific_resizes(self):
        """
        clear_specific_resizes(self) -> None
        C++: virtual void clear_specific_resizes()"""
        ret = self._vtk_obj.ClearSpecificResizes()
        return ret
        

    def compute_current_element_scene_rect(self, *args):
        """
        compute_current_element_scene_rect(self, index:Vector2i,
            offset:Vector2f, increment:Vector2f) -> Rectf
        C++: virtual Rectf compute_current_element_scene_rect(
            const Vector2i &index, const Vector2f &offset,
            const Vector2f &increment)
        Override this method if you want to customize layout instead of
        the default. The returned rect will be in scene coordinates and
        suitable for a chart element or chart matrix element.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ComputeCurrentElementSceneRect, *my_args)
        return wrap_vtk(ret)

    def go_to_next_element(self, *args):
        """
        go_to_next_element(self, index:Vector2i, offset:Vector2f)
            -> None
        C++: virtual void go_to_next_element(Vector2i &index,
            Vector2f &offset)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GoToNextElement, *my_args)
        return ret

    def init_layout_traversal(self, *args):
        """
        init_layout_traversal(self, index:Vector2i, offset:Vector2f,
            increment:Vector2f) -> None
        C++: virtual void init_layout_traversal(Vector2i &index,
            Vector2f &offset, Vector2f &increment)
        These methods offer an API to iterate over the layout and obtain
        the offset of each child element (chart or chart matrix) within
        the scene, the index and the increment b/w each element.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitLayoutTraversal, *my_args)
        return ret

    def is_done_with_traversal(self):
        """
        is_done_with_traversal(self) -> bool
        C++: virtual bool is_done_with_traversal()"""
        ret = self._vtk_obj.IsDoneWithTraversal()
        return ret
        

    def label_outer(self, *args):
        """
        label_outer(self, leftBottomIdx:Vector2i,
            rightTopIdx:Vector2i) -> None
        C++: virtual void label_outer(const Vector2i &leftBottomIdx,
            const Vector2i &rightTopIdx)
        Link all charts in the rectangle from leftBottom to rightTop.
        Label only the outer most y-axis and x-axis. This removes of
        gutter space between the linked charts.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.LabelOuter, *my_args)
        return ret

    def link(self, *args):
        """
        link(self, index1:Vector2i, index2:Vector2i, axis:int=1)
            -> None
        C++: virtual void link(const Vector2i &index1,
            const Vector2i &index2, int axis=1)
        link(self, flatIndex1:int, flatIndex2:int, axis:int=1) -> None
        C++: virtual void link(const size_t &flatIndex1,
            const size_t &flatIndex2, int axis=1)
        The chart at index2 will be setup to mimic axis range of chart at
        index1 for specified axis. Note: index is a two dimensional chart
        index. See ChartMatrix::GetChartIndex()
              flatIndex is a one dimensional chart index. See
        ChartMatrix::GetFlatIndex()
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Link, *my_args)
        return ret

    def link_all(self, *args):
        """
        link_all(self, index:Vector2i, axis:int=1) -> None
        C++: virtual void link_all(const Vector2i &index, int axis=1)
        link_all(self, flatIndex:int, axis:int=1) -> None
        C++: virtual void link_all(const size_t &flatIndex, int axis=1)
        Link a chart to all other charts in this chart matrix for
        specified axis
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.LinkAll, *my_args)
        return ret

    def reset_linked_layout(self):
        """
        reset_linked_layout(self) -> None
        C++: virtual void reset_linked_layout()"""
        ret = self._vtk_obj.ResetLinkedLayout()
        return ret
        

    def reset_links(self, *args):
        """
        reset_links(self, axis:int=1) -> None
        C++: virtual void reset_links(int axis=1)
        Unlink every chart from all other charts for a specified axis.
        This effectively removes any linkage in the chart matrix. If
        ChartMatrix::LabelOuter() was used, call reset_linked_layout,
        sot that the gutters that were removed will be put back in place.
        """
        ret = self._wrap_call(self._vtk_obj.ResetLinks, *args)
        return ret

    def set_border_bottom(self, *args):
        """
        set_border_bottom(self, value:int) -> None
        C++: void set_border_bottom(int value)"""
        ret = self._wrap_call(self._vtk_obj.SetBorderBottom, *args)
        return ret

    def set_border_left(self, *args):
        """
        set_border_left(self, value:int) -> None
        C++: void set_border_left(int value)"""
        ret = self._wrap_call(self._vtk_obj.SetBorderLeft, *args)
        return ret

    def set_border_right(self, *args):
        """
        set_border_right(self, value:int) -> None
        C++: void set_border_right(int value)"""
        ret = self._wrap_call(self._vtk_obj.SetBorderRight, *args)
        return ret

    def set_border_top(self, *args):
        """
        set_border_top(self, value:int) -> None
        C++: void set_border_top(int value)"""
        ret = self._wrap_call(self._vtk_obj.SetBorderTop, *args)
        return ret

    def set_gutter_x(self, *args):
        """
        set_gutter_x(self, value:float) -> None
        C++: void set_gutter_x(float value)"""
        ret = self._wrap_call(self._vtk_obj.SetGutterX, *args)
        return ret

    def set_gutter_y(self, *args):
        """
        set_gutter_y(self, value:float) -> None
        C++: void set_gutter_y(float value)"""
        ret = self._wrap_call(self._vtk_obj.SetGutterY, *args)
        return ret

    def set_padding(self, *args):
        """
        set_padding(self, padding:float) -> None
        C++: virtual void set_padding(const float &padding)
        Set the gutter that should be left between the charts in the
        matrix.
        """
        ret = self._wrap_call(self._vtk_obj.SetPadding, *args)
        return ret

    def set_specific_resize(self, *args):
        """
        set_specific_resize(self, index:Vector2i, resize:Vector2f)
            -> None
        C++: virtual void set_specific_resize(const Vector2i &index,
            const Vector2f &resize)
        Set a specific resize that will move the bottom left point of a
        chart.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSpecificResize, *my_args)
        return ret

    def unlink(self, *args):
        """
        unlink(self, index1:Vector2i, index2:Vector2i, axis:int=1)
            -> None
        C++: virtual void unlink(const Vector2i &index1,
            const Vector2i &index2, int axis=1)
        unlink(self, flatIndex1:int, flatIndex2:int, axis:int=1) -> None
        C++: virtual void unlink(const size_t &flatIndex1,
            const size_t &flatIndex2, int axis=1)
        Unlink the two charts for specified axis i.e, Chart at index2
        will no longer mimic the axis range of chart at index1
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Unlink, *my_args)
        return ret

    def unlink_all(self, *args):
        """
        unlink_all(self, index:Vector2i, axis:int=1) -> None
        C++: virtual void unlink_all(const Vector2i &index, int axis=1)
        unlink_all(self, flatIndex:int, axis:int=1) -> None
        C++: virtual void unlink_all(const size_t &flatIndex, int axis=1)
        Unlink all charts from given chart for a specified axis.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UnlinkAll, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('interactive', 'GetInteractive'),
    ('visible', 'GetVisible'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'interactive', 'object_name',
    'visible'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ChartMatrix, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ChartMatrix properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['interactive', 'object_name', 'visible']),
            title='Edit ChartMatrix properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ChartMatrix properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

