# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.higher_order_wedge import HigherOrderWedge


class BezierWedge(HigherOrderWedge):
    r"""
    BezierWedge - A 3D cell that represents an arbitrary order Bezier
    wedge
    
    Superclass: HigherOrderWedge
    
    BezierWedge is a concrete implementation of Cell to represent a
    3D wedge using Bezier shape functions of user specified order. A
    wedge consists of two triangular and three quadrilateral faces. The
    first six points of the wedge (0-5) are the "corner" points where the
    first three points are the base of the wedge. This wedge point
    ordering is opposite the Wedge ordering though in that the base of
    the wedge defined by the first three points (0,1,2) form a triangle
    whose normal points inward (toward the triangular face (3,4,5)).
    While this is opposite the Wedge convention it is consistent with
    every other cell type in VTK. The first 2 parametric coordinates of
    the Bezier wedge or for the triangular base and vary between 0 and 1.
    The third parametric coordinate is between the two triangular faces
    and goes from 0 to 1 as well.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBezierWedge, obj, update, **traits)
    
    def _get_rational_weights(self):
        return wrap_vtk(self._vtk_obj.GetRationalWeights())
    rational_weights = traits.Property(_get_rational_weights, desc=\
        r"""
        
        """
    )

    def evaluate_location_projected_node(self, *args):
        """
        evaluate_location_projected_node(self, subId:int, point_id:int,
            x:[float, float, float], weights:[float, ...]) -> None
        C++: void evaluate_location_projected_node(int &subId,
            const IdType point_id, double x[3], double *weights)"""
        ret = self._wrap_call(self._vtk_obj.EvaluateLocationProjectedNode, *args)
        return ret

    def set_rational_weights_from_point_data(self, *args):
        """
        set_rational_weights_from_point_data(self, point_data:PointData,
            numPts:int) -> None
        C++: void set_rational_weights_from_point_data(
            PointData *point_data, const IdType numPts)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetRationalWeightsFromPointData, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('parametric_coords',
    'GetParametricCoords'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name',
    'parametric_coords'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BezierWedge, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BezierWedge properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name', 'parametric_coords']),
            title='Edit BezierWedge properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BezierWedge properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

