------------------------------------------------------------------------------
--                             Templates Parser                             --
--                                                                          --
--                     Copyright (C) 2003-2010, AdaCore                     --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

package Templates_Parser.Query is

   function Kind
     (Association : Templates_Parser.Association) return Association_Kind;
   --  Returns the kind for this association

   function Variable
     (Association : Templates_Parser.Association) return String;
   --  Returns the variable name for Association

   function Composite
     (Association : Templates_Parser.Association) return Tag;
   --  Returns the vector tag for this association, raises Constraint_Error
   --  if it is not a vector.

   function Nested_Level (T : Tag) return Positive;
   --  Returns the nested level for tag T, 1 means that this is a vector tag,
   --  2 that it is a matrix.

end Templates_Parser.Query;
