/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class Move
extends Copy {
    public Move() {
        this.setOverwrite(true);
    }

    protected void doFileOperations() {
        int i;
        Enumeration e;
        if (this.completeDirMap.size() > 0) {
            e = this.completeDirMap.keys();
            while (e.hasMoreElements()) {
                File fromDir = (File)e.nextElement();
                File toDir = (File)this.completeDirMap.get(fromDir);
                try {
                    this.log("Attempting to rename dir: " + fromDir + " to " + toDir, this.verbosity);
                    this.renameFile(fromDir, toDir, this.filtering, this.forceOverwrite);
                }
                catch (IOException ioe) {
                    String msg = "Failed to rename dir " + fromDir + " to " + toDir + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
            }
        }
        if (this.fileCopyMap.size() > 0) {
            this.log("Moving " + this.fileCopyMap.size() + " files to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                File f = new File(fromFile);
                boolean selfMove = false;
                if (!f.exists()) continue;
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                i = 0;
                while (i < toFiles.length) {
                    String toFile = toFiles[i];
                    if (fromFile.equals(toFile)) {
                        this.log("Skipping self-move of " + fromFile, this.verbosity);
                        selfMove = true;
                    } else {
                        File d = new File(toFile);
                        if (i + 1 == toFiles.length && !selfMove) {
                            this.moveFile(f, d, this.filtering, this.forceOverwrite);
                        } else {
                            this.copyFile(f, d, this.filtering, this.forceOverwrite);
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.keys();
            int createCount = 0;
            while (e.hasMoreElements()) {
                String fromDirName = (String)e.nextElement();
                String[] toDirNames = (String[])this.dirCopyMap.get(fromDirName);
                boolean selfMove = false;
                i = 0;
                while (i < toDirNames.length) {
                    if (fromDirName.equals(toDirNames[i])) {
                        this.log("Skipping self-move of " + fromDirName, this.verbosity);
                        selfMove = true;
                    } else {
                        File d = new File(toDirNames[i]);
                        if (!d.exists()) {
                            if (!d.mkdirs()) {
                                this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                            } else {
                                ++createCount;
                            }
                        }
                    }
                    ++i;
                }
                File fromDir = new File(fromDirName);
                if (selfMove || !this.okToDelete(fromDir)) continue;
                this.deleteDir(fromDir);
            }
            if (createCount > 0) {
                this.log("Moved " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + createCount + " empty director" + (createCount == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }

    private void moveFile(File fromFile, File toFile, boolean filtering, boolean overwrite) {
        boolean moved = false;
        try {
            this.log("Attempting to rename: " + fromFile + " to " + toFile, this.verbosity);
            moved = this.renameFile(fromFile, toFile, filtering, this.forceOverwrite);
        }
        catch (IOException ioe) {
            String msg = "Failed to rename " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
            throw new BuildException(msg, ioe, this.getLocation());
        }
        if (!moved) {
            this.copyFile(fromFile, toFile, filtering, overwrite);
            if (!fromFile.delete()) {
                throw new BuildException("Unable to delete file " + fromFile.getAbsolutePath());
            }
        }
    }

    private void copyFile(File fromFile, File toFile, boolean filtering, boolean overwrite) {
        try {
            this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
            FilterSetCollection executionFilters = new FilterSetCollection();
            if (filtering) {
                executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
            }
            Enumeration filterEnum = this.getFilterSets().elements();
            while (filterEnum.hasMoreElements()) {
                executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
            }
            this.getFileUtils().copyFile(fromFile, toFile, executionFilters, this.getFilterChains(), this.forceOverwrite, this.getPreserveLastModified(), this.getEncoding(), this.getOutputEncoding(), this.getProject());
        }
        catch (IOException ioe) {
            String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
            throw new BuildException(msg, ioe, this.getLocation());
        }
    }

    protected boolean okToDelete(File d) {
        String[] list = d.list();
        if (list == null) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                if (!this.okToDelete(f)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void deleteDir(File d) {
        String[] list = d.list();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(d, s);
            if (!f.isDirectory()) {
                throw new BuildException("UNEXPECTED ERROR - The file " + f.getAbsolutePath() + " should not exist!");
            }
            this.deleteDir(f);
            ++i;
        }
        this.log("Deleting directory " + d.getAbsolutePath(), this.verbosity);
        if (!d.delete()) {
            throw new BuildException("Unable to delete directory " + d.getAbsolutePath());
        }
    }

    protected boolean renameFile(File sourceFile, File destFile, boolean filtering, boolean overwrite) throws IOException, BuildException {
        boolean renamed = true;
        if (this.getFilterSets() != null && this.getFilterSets().size() > 0 || this.getFilterChains() != null && this.getFilterChains().size() > 0) {
            renamed = false;
        } else if (!filtering) {
            File parent;
            String parentPath = destFile.getParent();
            if (parentPath != null && !(parent = new File(parentPath)).exists()) {
                parent.mkdirs();
            }
            if (destFile.exists() && destFile.isFile() && !destFile.delete()) {
                throw new BuildException("Unable to remove existing file " + destFile);
            }
            renamed = sourceFile.renameTo(destFile);
        } else {
            renamed = false;
        }
        return renamed;
    }
}

