/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.Task;

public class LogOutputStream
extends OutputStream {
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(132);
    private boolean skip = false;
    private Task task;
    private int level = 2;

    public LogOutputStream(Task task, int level) {
        this.task = task;
        this.level = level;
    }

    public void write(int cc) throws IOException {
        byte c = (byte)cc;
        if (c == 10 || c == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc);
        }
        this.skip = c == 13;
    }

    public void flush() {
        this.processBuffer();
    }

    protected void processBuffer() {
        this.processLine(this.buffer.toString());
        this.buffer.reset();
    }

    protected void processLine(String line) {
        this.processLine(line, this.level);
    }

    protected void processLine(String line, int level) {
        this.task.log(line, level);
    }

    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    public int getMessageLevel() {
        return this.level;
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] b, int off, int len) throws IOException {
        blockStartOffset = offset = off;
        remaining = len;
        ** GOTO lbl17
        {
            ++offset;
            --remaining;
            do {
                if (remaining > 0 && b[offset] != 10 && b[offset] != 13) continue block0;
                blockLength = offset - blockStartOffset;
                if (blockLength > 0) {
                    this.buffer.write(b, blockStartOffset, blockLength);
                }
                while (remaining > 0 && (b[offset] == 10 || b[offset] == 13)) {
                    this.write(b[offset]);
                    ++offset;
                    --remaining;
                }
                blockStartOffset = offset;
lbl17:
                // 2 sources

            } while (remaining > 0);
        }
    }
}

