/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.internal.rowset;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.rowset.CachedRowSet;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class CachedRowSetImplTest
extends TestCase {
    private static final String DERBY_URL = "jdbc:derby:src/test/resources/TESTDB;create=true";
    private Connection conn;
    private Statement st;
    private ResultSet rs;
    private CachedRowSet crset;

    public void setUp() throws IllegalAccessException, InstantiationException, ClassNotFoundException, SQLException {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        this.conn = DriverManager.getConnection("jdbc:derby:src/test/resources/TESTDB;create=true");
        this.st = this.conn.createStatement();
        this.rs = this.conn.getMetaData().getTables(null, null, "USER_INFO", null);
        if (!this.rs.next()) {
            this.st.execute("create table USER_INFO (ID INT NOT NULL,NAME VARCHAR(10) NOT NULL)");
        }
        this.st.executeUpdate("delete from USER_INFO");
        this.st.executeUpdate("insert into USER_INFO(ID,NAME) values (1,'hermit')");
        this.st.executeUpdate("insert into USER_INFO(ID,NAME) values (2,'test')");
        this.rs = this.st.executeQuery("select * from USER_INFO");
        try {
            this.crset = (CachedRowSet)Class.forName("com.sun.rowset.CachedRowSetImpl").newInstance();
            System.setProperty("CachedRowSetImpl_Test_Signal", "Testing RI");
            System.out.println("Testing RI");
        }
        catch (ClassNotFoundException e) {
            System.setProperty("CachedRowSetImpl_Test_Signal", "Testing Harmony");
            this.crset = (CachedRowSet)Class.forName("org.apache.harmony.sql.internal.rowset.CachedRowSetImpl").newInstance();
        }
        this.crset.populate(this.rs);
        this.rs = this.st.executeQuery("select * from USER_INFO");
    }

    public void tearDown() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
    }

    public void testCachedRowSetVersion() {
        CachedRowSetImplTest.assertEquals((String)System.getProperty("CachedRowSetImpl_Test_Signal"), (String)"Testing Harmony");
    }

    public void testSetSyncProvider() throws Exception {
    }

    public void testColumnUpdatedInt() throws SQLException {
        try {
            CachedRowSetImplTest.assertFalse((boolean)this.crset.columnUpdated(1));
            CachedRowSetImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.crset.next();
        try {
            this.crset.columnUpdated(-1);
            CachedRowSetImplTest.fail((String)"should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.crset.columnUpdated(0);
            CachedRowSetImplTest.fail((String)"should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        CachedRowSetImplTest.assertFalse((boolean)this.crset.columnUpdated(1));
    }

    public void testColumnUpdatedString() throws SQLException {
        try {
            CachedRowSetImplTest.assertFalse((boolean)this.crset.columnUpdated("ID"));
            CachedRowSetImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.crset.next();
        try {
            CachedRowSetImplTest.assertFalse((boolean)this.crset.columnUpdated("Incorrect"));
            CachedRowSetImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        CachedRowSetImplTest.assertFalse((boolean)this.crset.columnUpdated("NAME"));
    }

    public void testGetPageSize() throws SQLException {
        CachedRowSetImplTest.assertEquals((int)0, (int)this.crset.getPageSize());
        this.crset.setPageSize(1);
        CachedRowSetImplTest.assertEquals((int)1, (int)this.crset.getPageSize());
    }

    public void testSetPageSize() throws SQLException {
        try {
            this.crset.setPageSize(-1);
            CachedRowSetImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.crset.setPageSize(0);
        this.crset.setPageSize(Integer.MAX_VALUE);
        CachedRowSetImplTest.assertEquals((int)Integer.MAX_VALUE, (int)this.crset.getPageSize());
    }

    public void testGetTableName() throws SQLException {
        CachedRowSetImplTest.assertEquals(null, (String)this.crset.getTableName());
        this.crset.setTableName("USER");
        CachedRowSetImplTest.assertEquals((String)"USER", (String)this.crset.getTableName());
    }

    public void testSetTableName() throws SQLException {
        try {
            this.crset.setTableName(null);
            CachedRowSetImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testSize() {
        CachedRowSetImplTest.assertEquals((int)2, (int)this.crset.size());
    }

    public void testDeleteRow() throws SQLException {
        try {
            this.crset.deleteRow();
            CachedRowSetImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.crset.next();
        CachedRowSetImplTest.assertFalse((boolean)this.crset.rowDeleted());
        this.crset.deleteRow();
        CachedRowSetImplTest.assertEquals((int)2, (int)this.crset.size());
        CachedRowSetImplTest.assertTrue((boolean)this.crset.rowDeleted());
    }

    public void testRowDeleted() throws SQLException {
        try {
            this.crset.rowDeleted();
            CachedRowSetImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testInsertRow() throws SQLException {
        try {
            this.crset.insertRow();
            CachedRowSetImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.crset.next();
        try {
            this.crset.insertRow();
            CachedRowSetImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.crset.moveToInsertRow();
        this.crset.updateString("Name", "TonyWu");
        this.crset.updateInt("ID", 3);
        this.crset.insertRow();
        CachedRowSetImplTest.assertEquals((String)"TonyWu", (String)this.crset.getString(2));
        CachedRowSetImplTest.assertEquals((String)"TonyWu", (String)this.crset.getString("Name"));
        CachedRowSetImplTest.assertEquals((int)3, (int)this.crset.getInt(1));
        CachedRowSetImplTest.assertEquals((int)3, (int)this.crset.getInt("ID"));
        CachedRowSetImplTest.assertTrue((boolean)this.crset.rowInserted());
    }

    public void testAcceptChanges() throws SQLException {
        this.rs.next();
        CachedRowSetImplTest.assertEquals((int)1, (int)this.rs.getInt(1));
        this.crset.next();
        CachedRowSetImplTest.assertEquals((int)1, (int)this.crset.getInt(1));
        this.crset.updateInt(1, 3);
        CachedRowSetImplTest.assertEquals((int)3, (int)this.crset.getInt(1));
    }

    public void testAcceptChangesConnection() throws SQLException {
        this.rs.next();
        CachedRowSetImplTest.assertEquals((int)1, (int)this.rs.getInt(1));
        this.crset.first();
        CachedRowSetImplTest.assertEquals((int)1, (int)this.crset.getInt(1));
        this.crset.updateInt(1, 3);
        CachedRowSetImplTest.assertEquals((int)3, (int)this.crset.getInt(1));
        this.crset.updateRow();
        this.crset.moveToCurrentRow();
        CachedRowSetImplTest.assertEquals((int)3, (int)this.crset.getInt(1));
    }
}

