; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-attributes --check-globals
; RUN: opt < %s -simplifycfg -simplifycfg-require-and-preserve-domtree=1 -sink-common-insts -S | FileCheck %s
; RUN: opt < %s -passes='simplifycfg<sink-common-insts>' -S | FileCheck %s

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

; Simple test, nothing interesting happens here.
define void @t0_noop() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t0_noop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c = call i1 @cond()
  br i1 %c, label %if.then, label %if.end

if.then:
  invoke void @simple_throw() to label %invoke.cont unwind label %lpad

invoke.cont:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.end:
  call void @sideeffect()
  ret void
}

; More interesting test, here we can merge the invokes.
define void @t1_mergeable_invoke() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t1_mergeable_invoke(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; 'unreachable' block is shared, but it is unreachable, so we are fine.
define void @t2_shared_normal_dest() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t2_shared_normal_dest(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD]]
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() to label %invoke.cont unwind label %lpad

invoke.cont:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() to label %invoke.cont unwind label %lpad

if.end:
  call void @sideeffect()
  ret void
}

; shared normal destination is not unreachable.
define void @t3_bad_shared_normal_dest() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t3_bad_shared_normal_dest(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD]]
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() to label %invoke.cont unwind label %lpad

invoke.cont:
  call void @sideeffect()
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() to label %invoke.cont unwind label %lpad

if.end:
  call void @sideeffect()
  ret void
}

; normal destinations are not unreachable.
define void @t4_normal_dests() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t4_normal_dests(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    call void @another_sideeffect()
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  call void @sideeffect()
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  call void @another_sideeffect()
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; Invokes lead to different landing pads.
define void @t5_different_landingpads() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t5_different_landingpads(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD0:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       common.resume:
; CHECK-NEXT:    [[COMMON_RESUME_OP:%.*]] = phi { i8*, i32 } [ [[EH0:%.*]], [[LPAD0]] ], [ [[EH1:%.*]], [[LPAD1:%.*]] ]
; CHECK-NEXT:    resume { i8*, i32 } [[COMMON_RESUME_OP]]
; CHECK:       lpad0:
; CHECK-NEXT:    [[EH0]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    br label [[COMMON_RESUME:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD1]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       lpad1:
; CHECK-NEXT:    [[EH1]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @another_destructor()
; CHECK-NEXT:    br label [[COMMON_RESUME]]
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() to label %invoke.cont0 unwind label %lpad0

invoke.cont0:
  unreachable

lpad0:
  %eh0 = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh0

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() to label %invoke.cont2 unwind label %lpad1

invoke.cont2:
  unreachable

lpad1:
  %eh1 = landingpad { i8*, i32 } cleanup
  call void @another_destructor()
  resume { i8*, i32 } %eh1

if.end:
  call void @sideeffect()
  ret void
}

; The invoked functions are different
define void @t6_different_invokes() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t6_different_invokes(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @another_simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @another_simple_throw() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; Merging of this invoke is disallowed
define void @t7_nomerge0() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t7_nomerge0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw() #[[ATTR1:[0-9]+]]
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() nomerge to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}
define void @t8_nomerge1() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t8_nomerge1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw() #[[ATTR1]]
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() nomerge to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}
define void @t9_nomerge2() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t9_nomerge2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw() #[[ATTR1]]
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw() #[[ATTR1]]
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() nomerge to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() nomerge to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; Just don't deal with inlineasm.
define void @t10_inlineasm() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t10_inlineasm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void asm sideeffect "something bad", ""()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void asm sideeffect "something bad", ""()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void asm sideeffect "something bad", ""() to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void asm sideeffect "something bad", ""() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; More interesting test, here we can merge the invokes.
define void @t11_phi_in_landingpad() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t11_phi_in_landingpad(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 0, [[IF_THEN0]] ], [ 1, [[IF_THEN1:%.*]] ]
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @consume(i32 [[PHI]])
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %phi = phi i32 [ 0, %if.then0 ], [ 1, %if.then1 ]
  %eh = landingpad { i8*, i32 } cleanup
  call void @consume(i32 %phi)
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; It is okay for the invoke to take arguments
define void @t12_arguments_are_fine() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t12_arguments_are_fine(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw_taking_argument(i32 42)
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw_taking_argument(i32 42)
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw_taking_argument(i32 42) to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw_taking_argument(i32 42) to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; It is okay for the invoke to take different arguments
define void @t13_different_arguments_are_fine() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t13_different_arguments_are_fine(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw_taking_argument(i32 0)
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw_taking_argument(i32 42)
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw_taking_argument(i32 0) to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw_taking_argument(i32 42) to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; There can be more than two invokes in a set
define void @t14_three_invokes_only_two_compatible() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t14_three_invokes_only_two_compatible(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE0:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else0:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_ELSE1:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.else1:
; CHECK-NEXT:    [[C2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C2]], label [[IF_THEN2:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then2:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont3:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else0

if.then0:
  invoke void @simple_throw() to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else0:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.else1

if.then1:
  invoke void @simple_throw() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.else1:
  %c2 = call i1 @cond()
  br i1 %c2, label %if.then2, label %if.end

if.then2:
  invoke void @simple_throw() to label %invoke.cont3 unwind label %lpad

invoke.cont3:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; If not all invokes of landingpad are compatible then we still merge compatible ones.
define void @t15_three_invokes_only_two_compatible() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t15_three_invokes_only_two_compatible(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE0:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else0:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_ELSE1:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.else1:
; CHECK-NEXT:    [[C2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C2]], label [[IF_THEN2:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then2:
; CHECK-NEXT:    invoke void @another_simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont3:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else0

if.then0:
  invoke void @simple_throw() to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else0:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.else1

if.then1:
  invoke void @simple_throw() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.else1:
  %c2 = call i1 @cond()
  br i1 %c2, label %if.then2, label %if.end

if.then2:
  invoke void @another_simple_throw() to label %invoke.cont3 unwind label %lpad

invoke.cont3:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; We succeed in merging invokes into two sets
define void @t16_four_invokes_forming_two_sets() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t16_four_invokes_forming_two_sets(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE0:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else0:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_ELSE1:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.else1:
; CHECK-NEXT:    [[C2:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C2]], label [[IF_THEN2:%.*]], label [[IF_ELSE2:%.*]]
; CHECK:       if.then2:
; CHECK-NEXT:    invoke void @another_simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT3:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont3:
; CHECK-NEXT:    unreachable
; CHECK:       if.else2:
; CHECK-NEXT:    [[C3:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C3]], label [[IF_THEN3:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then3:
; CHECK-NEXT:    invoke void @another_simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT4:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont4:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else0

if.then0:
  invoke void @simple_throw() to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else0:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.else1

if.then1:
  invoke void @simple_throw() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.else1:
  %c2 = call i1 @cond()
  br i1 %c2, label %if.then2, label %if.else2

if.then2:
  invoke void @another_simple_throw() to label %invoke.cont3 unwind label %lpad

invoke.cont3:
  unreachable

if.else2:
  %c3 = call i1 @cond()
  br i1 %c3, label %if.then3, label %if.end

if.then3:
  invoke void @another_simple_throw() to label %invoke.cont4 unwind label %lpad

invoke.cont4:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; Attributes must match
define void @t17_mismatched_attrs_prevent_merge() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t17_mismatched_attrs_prevent_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw() #[[ATTR2:[0-9]+]]
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw()
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() readnone to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; Common attributes are preserved
define void @t18_attributes_are_preserved() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t18_attributes_are_preserved(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw() #[[ATTR2]]
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw() #[[ATTR2]]
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() readnone to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() readnone to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; Fully identical operand bundles are good.
define void @t19_compatible_operand_bundle() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t19_compatible_operand_bundle(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw() [ "abc"(i32 42) ]
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw() [ "abc"(i32 42) ]
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() [ "abc"(i32 42) ] to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() [ "abc"(i32 42) ] to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; Operand bundles must be compatible, else we can't merge.
define void @t20_incompatible_operand_bundle() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t20_incompatible_operand_bundle(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw() [ "abc"(i32 42) ]
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw() [ "def"(i32 0) ]
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() [ "abc"(i32 42) ] to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() [ "def"(i32 0) ] to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

; We need to PHI together the arguments of the operand bundles.
define void @t21_semicompatible_operand_bundle() personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @t21_semicompatible_operand_bundle(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C0]], label [[IF_THEN0:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then0:
; CHECK-NEXT:    invoke void @simple_throw() [ "abc"(i32 42) ]
; CHECK-NEXT:    to label [[INVOKE_CONT0:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       invoke.cont0:
; CHECK-NEXT:    unreachable
; CHECK:       lpad:
; CHECK-NEXT:    [[EH:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    call void @destructor()
; CHECK-NEXT:    resume { i8*, i32 } [[EH]]
; CHECK:       if.else:
; CHECK-NEXT:    [[C1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C1]], label [[IF_THEN1:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    invoke void @simple_throw() [ "abc"(i32 0) ]
; CHECK-NEXT:    to label [[INVOKE_CONT2:%.*]] unwind label [[LPAD]]
; CHECK:       invoke.cont2:
; CHECK-NEXT:    unreachable
; CHECK:       if.end:
; CHECK-NEXT:    call void @sideeffect()
; CHECK-NEXT:    ret void
;
entry:
  %c0 = call i1 @cond()
  br i1 %c0, label %if.then0, label %if.else

if.then0:
  invoke void @simple_throw() [ "abc"(i32 42) ] to label %invoke.cont0 unwind label %lpad

invoke.cont0:
  unreachable

lpad:
  %eh = landingpad { i8*, i32 } cleanup
  call void @destructor()
  resume { i8*, i32 } %eh

if.else:
  %c1 = call i1 @cond()
  br i1 %c1, label %if.then1, label %if.end

if.then1:
  invoke void @simple_throw() [ "abc"(i32 0) ] to label %invoke.cont2 unwind label %lpad

invoke.cont2:
  unreachable

if.end:
  call void @sideeffect()
  ret void
}

declare i1 @cond()

declare void @sideeffect()
declare void @another_sideeffect()

declare void @simple_throw() noreturn
declare void @another_simple_throw() noreturn

declare void @simple_throw_taking_argument(i32) noreturn

declare void @destructor()
declare void @another_destructor()

declare void @consume(i32)

declare dso_local i32 @__gxx_personality_v0(...)
;.
; CHECK: attributes #[[ATTR0:[0-9]+]] = { noreturn }
; CHECK: attributes #[[ATTR1]] = { nomerge }
; CHECK: attributes #[[ATTR2]] = { readnone }
;.
