; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512FVEC512
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=AVX512FVEC256
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512dq | FileCheck %s --check-prefixes=AVX512DQVEC512
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512dq,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=AVX512DQVEC256
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512bw | FileCheck %s --check-prefixes=AVX512BWVEC512
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512bw,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=AVX512BWVEC256

; RUN: opt < %s -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mcpu=slm | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mcpu=goldmont | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mcpu=btver2 | FileCheck %s --check-prefixes=BTVER2

define i32 @zext_vXi32() "min-legal-vector-width"="256" {
; SSE-LABEL: 'zext_vXi32'
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; SSE-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'zext_vXi32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'zext_vXi32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'zext_vXi32'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'zext_vXi32'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'zext_vXi32'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'zext_vXi32'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'zext_vXi32'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'zext_vXi32'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'zext_vXi32'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %I64 = zext i32 undef to i64
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i32> undef to <2 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = zext <4 x i32> undef to <4 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i64 = zext <8 x i32> undef to <8 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V16i64 = zext <16 x i32> undef to <16 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V32i64 = zext <32 x i32> undef to <32 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I64 = zext i32 undef to i64
  %V2i64 = zext <2 x i32> undef to <2 x i64>
  %V4i64 = zext <4 x i32> undef to <4 x i64>
  %V8i64 = zext <8 x i32> undef to <8 x i64>
  %V16i64 = zext <16 x i32> undef to <16 x i64>
  %V32i64 = zext <32 x i32> undef to <32 x i64>

  ret i32 undef
}

define i32 @zext_vXi16() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'zext_vXi16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'zext_vXi16'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'zext_vXi16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'zext_vXi16'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'zext_vXi16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'zext_vXi16'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'zext_vXi16'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'zext_vXi16'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'zext_vXi16'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'zext_vXi16'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'zext_vXi16'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'zext_vXi16'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i16 undef to i64
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i16> undef to <2 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = zext <4 x i16> undef to <4 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = zext <8 x i16> undef to <8 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V16i64 = zext <16 x i16> undef to <16 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V32i64 = zext <32 x i16> undef to <32 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V64i64 = zext <64 x i16> undef to <64 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i16 undef to i32
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i16> undef to <2 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i16> undef to <4 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = zext <8 x i16> undef to <8 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i32 = zext <16 x i16> undef to <16 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32i32 = zext <32 x i16> undef to <32 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64i32 = zext <64 x i16> undef to <64 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I64 = zext i16 undef to i64
  %V2i64 = zext <2 x i16> undef to <2 x i64>
  %V4i64 = zext <4 x i16> undef to <4 x i64>
  %V8i64 = zext <8 x i16> undef to <8 x i64>
  %V16i64 = zext <16 x i16> undef to <16 x i64>
  %V32i64 = zext <32 x i16> undef to <32 x i64>
  %V64i64 = zext <64 x i16> undef to <64 x i64>

  %I32 = zext i16 undef to i32
  %V2i32 = zext <2 x i16> undef to <2 x i32>
  %V4i32 = zext <4 x i16> undef to <4 x i32>
  %V8i32 = zext <8 x i16> undef to <8 x i32>
  %V16i32 = zext <16 x i16> undef to <16 x i32>
  %V32i32 = zext <32 x i16> undef to <32 x i32>
  %V64i32 = zext <64 x i16> undef to <64 x i32>

  ret i32 undef
}

define i32 @zext_vXi8() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'zext_vXi8'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'zext_vXi8'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'zext_vXi8'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'zext_vXi8'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'zext_vXi8'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'zext_vXi8'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'zext_vXi8'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'zext_vXi8'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'zext_vXi8'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'zext_vXi8'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'zext_vXi8'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'zext_vXi8'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i8 undef to i64
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i8> undef to <2 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = zext <4 x i8> undef to <4 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = zext <8 x i8> undef to <8 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i64 = zext <16 x i8> undef to <16 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i64 = zext <32 x i8> undef to <32 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i64 = zext <64 x i8> undef to <64 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i64 = zext <128 x i8> undef to <128 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i8 undef to i32
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i8> undef to <2 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i8> undef to <4 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = zext <8 x i8> undef to <8 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = zext <16 x i8> undef to <16 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = zext <32 x i8> undef to <32 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = zext <64 x i8> undef to <64 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = zext <128 x i8> undef to <128 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i8 undef to i16
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i8> undef to <2 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i8> undef to <4 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i8> undef to <8 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = zext <16 x i8> undef to <16 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = zext <32 x i8> undef to <32 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i16 = zext <64 x i8> undef to <64 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128i16 = zext <128 x i8> undef to <128 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I64 = zext i8 undef to i64
  %V2i64 = zext <2 x i8> undef to <2 x i64>
  %V4i64 = zext <4 x i8> undef to <4 x i64>
  %V8i64 = zext <8 x i8> undef to <8 x i64>
  %V16i64 = zext <16 x i8> undef to <16 x i64>
  %V32i64 = zext <32 x i8> undef to <32 x i64>
  %V64i64 = zext <64 x i8> undef to <64 x i64>
  %V128i64 = zext <128 x i8> undef to <128 x i64>

  %I32 = zext i8 undef to i32
  %V2i32 = zext <2 x i8> undef to <2 x i32>
  %V4i32 = zext <4 x i8> undef to <4 x i32>
  %V8i32 = zext <8 x i8> undef to <8 x i32>
  %V16i32 = zext <16 x i8> undef to <16 x i32>
  %V32i32 = zext <32 x i8> undef to <32 x i32>
  %V64i32 = zext <64 x i8> undef to <64 x i32>
  %V128i32 = zext <128 x i8> undef to <128 x i32>

  %I16 = zext i8 undef to i16
  %V2i16 = zext <2 x i8> undef to <2 x i16>
  %V4i16 = zext <4 x i8> undef to <4 x i16>
  %V8i16 = zext <8 x i8> undef to <8 x i16>
  %V16i16 = zext <16 x i8> undef to <16 x i16>
  %V32i16 = zext <32 x i8> undef to <32 x i16>
  %V64i16 = zext <64 x i8> undef to <64 x i16>
  %V128i16 = zext <128 x i8> undef to <128 x i16>

  ret i32 undef
}

define i32 @zext_vXi1() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'zext_vXi1'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'zext_vXi1'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'zext_vXi1'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'zext_vXi1'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'zext_vXi1'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'zext_vXi1'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'zext_vXi1'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'zext_vXi1'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'zext_vXi1'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'zext_vXi1'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'zext_vXi1'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 94 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'zext_vXi1'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = zext i1 undef to i64
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i64 = zext <16 x i1> undef to <16 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i64 = zext <32 x i1> undef to <32 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i64 = zext <64 x i1> undef to <64 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i64 = zext <128 x i1> undef to <128 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = zext i1 undef to i32
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = zext <32 x i1> undef to <32 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = zext <64 x i1> undef to <64 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = zext <128 x i1> undef to <128 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = zext i1 undef to i16
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = zext <64 x i1> undef to <64 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i16 = zext <128 x i1> undef to <128 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = zext i1 undef to i8
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V128i8 = zext <128 x i1> undef to <128 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I64 = zext i1 undef to i64
  %V2i64 = zext <2 x i1> undef to <2 x i64>
  %V4i64 = zext <4 x i1> undef to <4 x i64>
  %V8i64 = zext <8 x i1> undef to <8 x i64>
  %V16i64 = zext <16 x i1> undef to <16 x i64>
  %V32i64 = zext <32 x i1> undef to <32 x i64>
  %V64i64 = zext <64 x i1> undef to <64 x i64>
  %V128i64 = zext <128 x i1> undef to <128 x i64>

  %I32 = zext i1 undef to i32
  %V2i32 = zext <2 x i1> undef to <2 x i32>
  %V4i32 = zext <4 x i1> undef to <4 x i32>
  %V8i32 = zext <8 x i1> undef to <8 x i32>
  %V16i32 = zext <16 x i1> undef to <16 x i32>
  %V32i32 = zext <32 x i1> undef to <32 x i32>
  %V64i32 = zext <64 x i1> undef to <64 x i32>
  %V128i32 = zext <128 x i1> undef to <128 x i32>

  %I16 = zext i1 undef to i16
  %V2i16 = zext <2 x i1> undef to <2 x i16>
  %V4i16 = zext <4 x i1> undef to <4 x i16>
  %V8i16 = zext <8 x i1> undef to <8 x i16>
  %V16i16 = zext <16 x i1> undef to <16 x i16>
  %V32i16 = zext <32 x i1> undef to <32 x i16>
  %V64i16 = zext <64 x i1> undef to <64 x i16>
  %V128i16 = zext <128 x i1> undef to <128 x i16>

  %I8 = zext i1 undef to i8
  %V2i8 = zext <2 x i1> undef to <2 x i8>
  %V4i8 = zext <4 x i1> undef to <4 x i8>
  %V8i8 = zext <8 x i1> undef to <8 x i8>
  %V16i8 = zext <16 x i1> undef to <16 x i8>
  %V32i8 = zext <32 x i1> undef to <32 x i8>
  %V64i8 = zext <64 x i1> undef to <64 x i8>
  %V128i8 = zext <128 x i1> undef to <128 x i8>

  ret i32 undef
}

define i32 @sext_vXi32() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'sext_vXi32'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'sext_vXi32'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'sext_vXi32'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'sext_vXi32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'sext_vXi32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'sext_vXi32'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'sext_vXi32'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'sext_vXi32'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'sext_vXi32'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'sext_vXi32'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'sext_vXi32'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'sext_vXi32'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i32 undef to i64
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i32> undef to <2 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = sext <4 x i32> undef to <4 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i64 = sext <8 x i32> undef to <8 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V16i64 = sext <16 x i32> undef to <16 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V32i64 = sext <32 x i32> undef to <32 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I64 = sext i32 undef to i64
  %V2i64 = sext <2 x i32> undef to <2 x i64>
  %V4i64 = sext <4 x i32> undef to <4 x i64>
  %V8i64 = sext <8 x i32> undef to <8 x i64>
  %V16i64 = sext <16 x i32> undef to <16 x i64>
  %V32i64 = sext <32 x i32> undef to <32 x i64>

  ret i32 undef
}

define i32 @sext_vXi16() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'sext_vXi16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'sext_vXi16'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'sext_vXi16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'sext_vXi16'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'sext_vXi16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'sext_vXi16'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'sext_vXi16'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'sext_vXi16'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'sext_vXi16'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'sext_vXi16'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'sext_vXi16'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'sext_vXi16'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i16 undef to i64
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i16> undef to <2 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = sext <4 x i16> undef to <4 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = sext <8 x i16> undef to <8 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V16i64 = sext <16 x i16> undef to <16 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V32i64 = sext <32 x i16> undef to <32 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V64i64 = sext <64 x i16> undef to <64 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i16 undef to i32
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i16> undef to <2 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i16> undef to <4 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = sext <8 x i16> undef to <8 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i32 = sext <16 x i16> undef to <16 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32i32 = sext <32 x i16> undef to <32 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64i32 = sext <64 x i16> undef to <64 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I64 = sext i16 undef to i64
  %V2i64 = sext <2 x i16> undef to <2 x i64>
  %V4i64 = sext <4 x i16> undef to <4 x i64>
  %V8i64 = sext <8 x i16> undef to <8 x i64>
  %V16i64 = sext <16 x i16> undef to <16 x i64>
  %V32i64 = sext <32 x i16> undef to <32 x i64>
  %V64i64 = sext <64 x i16> undef to <64 x i64>

  %I32 = sext i16 undef to i32
  %V2i32 = sext <2 x i16> undef to <2 x i32>
  %V4i32 = sext <4 x i16> undef to <4 x i32>
  %V8i32 = sext <8 x i16> undef to <8 x i32>
  %V16i32 = sext <16 x i16> undef to <16 x i32>
  %V32i32 = sext <32 x i16> undef to <32 x i32>
  %V64i32 = sext <64 x i16> undef to <64 x i32>

  ret i32 undef
}

define i32 @sext_vXi8() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'sext_vXi8'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'sext_vXi8'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'sext_vXi8'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'sext_vXi8'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'sext_vXi8'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'sext_vXi8'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'sext_vXi8'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'sext_vXi8'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'sext_vXi8'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'sext_vXi8'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'sext_vXi8'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'sext_vXi8'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i8 undef to i64
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i8> undef to <2 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = sext <4 x i8> undef to <4 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = sext <8 x i8> undef to <8 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i64 = sext <16 x i8> undef to <16 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i64 = sext <32 x i8> undef to <32 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i64 = sext <64 x i8> undef to <64 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i64 = sext <128 x i8> undef to <128 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i8 undef to i32
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i8> undef to <2 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i8> undef to <4 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = sext <8 x i8> undef to <8 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = sext <16 x i8> undef to <16 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = sext <32 x i8> undef to <32 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = sext <64 x i8> undef to <64 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = sext <128 x i8> undef to <128 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i8 undef to i16
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i8> undef to <2 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i8> undef to <4 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i8> undef to <8 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = sext <16 x i8> undef to <16 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = sext <32 x i8> undef to <32 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i16 = sext <64 x i8> undef to <64 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128i16 = sext <128 x i8> undef to <128 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I64 = sext i8 undef to i64
  %V2i64 = sext <2 x i8> undef to <2 x i64>
  %V4i64 = sext <4 x i8> undef to <4 x i64>
  %V8i64 = sext <8 x i8> undef to <8 x i64>
  %V16i64 = sext <16 x i8> undef to <16 x i64>
  %V32i64 = sext <32 x i8> undef to <32 x i64>
  %V64i64 = sext <64 x i8> undef to <64 x i64>
  %V128i64 = sext <128 x i8> undef to <128 x i64>

  %I32 = sext i8 undef to i32
  %V2i32 = sext <2 x i8> undef to <2 x i32>
  %V4i32 = sext <4 x i8> undef to <4 x i32>
  %V8i32 = sext <8 x i8> undef to <8 x i32>
  %V16i32 = sext <16 x i8> undef to <16 x i32>
  %V32i32 = sext <32 x i8> undef to <32 x i32>
  %V64i32 = sext <64 x i8> undef to <64 x i32>
  %V128i32 = sext <128 x i8> undef to <128 x i32>

  %I16 = sext i8 undef to i16
  %V2i16 = sext <2 x i8> undef to <2 x i16>
  %V4i16 = sext <4 x i8> undef to <4 x i16>
  %V8i16 = sext <8 x i8> undef to <8 x i16>
  %V16i16 = sext <16 x i8> undef to <16 x i16>
  %V32i16 = sext <32 x i8> undef to <32 x i16>
  %V64i16 = sext <64 x i8> undef to <64 x i16>
  %V128i16 = sext <128 x i8> undef to <128 x i16>

  ret i32 undef
}

define i32 @sext_vXi1() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'sext_vXi1'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'sext_vXi1'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'sext_vXi1'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'sext_vXi1'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'sext_vXi1'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'sext_vXi1'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'sext_vXi1'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'sext_vXi1'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'sext_vXi1'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'sext_vXi1'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'sext_vXi1'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 62 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'sext_vXi1'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i64 = sext <16 x i1> undef to <16 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i64 = sext <32 x i1> undef to <32 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i64 = sext <64 x i1> undef to <64 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 100 for instruction: %V128i64 = sext <128 x i1> undef to <128 x i64>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = sext <32 x i1> undef to <32 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = sext <64 x i1> undef to <64 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = sext <128 x i1> undef to <128 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = sext <64 x i1> undef to <64 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i16 = sext <128 x i1> undef to <128 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i8 = sext <128 x i1> undef to <128 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I64 = sext i1 undef to i64
  %V2i64 = sext <2 x i1> undef to <2 x i64>
  %V4i64 = sext <4 x i1> undef to <4 x i64>
  %V8i64 = sext <8 x i1> undef to <8 x i64>
  %V16i64 = sext <16 x i1> undef to <16 x i64>
  %V32i64 = sext <32 x i1> undef to <32 x i64>
  %V64i64 = sext <64 x i1> undef to <64 x i64>
  %V128i64 = sext <128 x i1> undef to <128 x i64>

  %I32 = sext i1 undef to i32
  %V2i32 = sext <2 x i1> undef to <2 x i32>
  %V4i32 = sext <4 x i1> undef to <4 x i32>
  %V8i32 = sext <8 x i1> undef to <8 x i32>
  %V16i32 = sext <16 x i1> undef to <16 x i32>
  %V32i32 = sext <32 x i1> undef to <32 x i32>
  %V64i32 = sext <64 x i1> undef to <64 x i32>
  %V128i32 = sext <128 x i1> undef to <128 x i32>

  %I16 = sext i1 undef to i16
  %V2i16 = sext <2 x i1> undef to <2 x i16>
  %V4i16 = sext <4 x i1> undef to <4 x i16>
  %V8i16 = sext <8 x i1> undef to <8 x i16>
  %V16i16 = sext <16 x i1> undef to <16 x i16>
  %V32i16 = sext <32 x i1> undef to <32 x i16>
  %V64i16 = sext <64 x i1> undef to <64 x i16>
  %V128i16 = sext <128 x i1> undef to <128 x i16>

  %I8 = sext i1 undef to i8
  %V2i8 = sext <2 x i1> undef to <2 x i8>
  %V4i8 = sext <4 x i1> undef to <4 x i8>
  %V8i8 = sext <8 x i1> undef to <8 x i8>
  %V16i8 = sext <16 x i1> undef to <16 x i8>
  %V32i8 = sext <32 x i1> undef to <32 x i8>
  %V64i8 = sext <64 x i1> undef to <64 x i8>
  %V128i8 = sext <128 x i1> undef to <128 x i8>

  ret i32 undef
}
